/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.service.BusiRoleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class BusiRoleMigration
implements PermMigratedBean {
    @Override
    public String generateJson(Set<Object> exportDataIds) {
        Object[] exportDataIdsArr = exportDataIds.stream().map(k -> Long.parseLong(k + "")).toArray(Object[]::new);
        DynamicObject[] busiRoleObjs = BusinessDataServiceHelper.load((Object[])exportDataIdsArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_busirole"));
        if (busiRoleObjs.length == 0) {
            logger.info("BusiRoleMigration.generateJson: busiRoleObjs.length == 0");
            return "";
        }
        ArrayList<BusiRole> busiRoles = new ArrayList<BusiRole>(exportDataIds.size());
        for (DynamicObject busiRoleObj : busiRoleObjs) {
            BusiRole busiRole = new BusiRole();
            busiRole.setNumber(busiRoleObj.getString("number"));
            busiRole.setName(busiRoleObj.getString("name"));
            busiRole.setType(busiRoleObj.getString("usertype"));
            busiRole.setRemark(busiRoleObj.getString("description"));
            DynamicObject busiRoleGroupObj = busiRoleObj.getDynamicObject("group");
            if (busiRoleGroupObj != null) {
                busiRole.setGroupId(busiRoleGroupObj.getString("number") + "|" + busiRoleGroupObj.getString("name"));
            }
            DynamicObjectCollection busiRoleComRoleCol = busiRoleObj.getDynamicObjectCollection("role_entry");
            HashSet<String> comRoleNumSet = new HashSet<String>(10);
            for (DynamicObject busiRoleComRoleObj : busiRoleComRoleCol) {
                DynamicObject comRoleObj = busiRoleComRoleObj.getDynamicObject("role_visible");
                if (comRoleObj == null) continue;
                comRoleNumSet.add(comRoleObj.getString("number"));
            }
            busiRole.setComRoleSet(comRoleNumSet);
            DynamicObjectCollection busiRolePermCol = busiRoleObj.getDynamicObjectCollection("bizroleperm");
            HashSet<PermItem> bizrolePermSet = new HashSet<PermItem>(10);
            for (DynamicObject busiRolePermObj : busiRolePermCol) {
                DynamicObject permItemObj;
                DynamicObject entObj;
                DynamicObject appObj = busiRolePermObj.getDynamicObject("bizapp");
                if (appObj == null || (entObj = busiRolePermObj.getDynamicObject("entitytype")) == null || (permItemObj = busiRolePermObj.getDynamicObject("permitem")) == null) continue;
                PermItem permItem = new PermItem();
                permItem.setAppNumber(appObj.getString("number"));
                permItem.setEntityNumber(entObj.getString("number"));
                permItem.setPermItemNumber(permItemObj.getString("number"));
                bizrolePermSet.add(permItem);
            }
            busiRole.setBizrolePermSet(bizrolePermSet);
            DynamicObjectCollection busiRoleDisPermCol = busiRoleObj.getDynamicObjectCollection("bizroledisperm");
            HashSet<PermItem> bizroleDisPermSet = new HashSet<PermItem>(10);
            for (DynamicObject busiRoleDisPermObj : busiRoleDisPermCol) {
                DynamicObject permItemObj;
                DynamicObject entObj;
                DynamicObject appObj = busiRoleDisPermObj.getDynamicObject("bizappforbid");
                if (appObj == null || (entObj = busiRoleDisPermObj.getDynamicObject("entitytypeforbid")) == null || (permItemObj = busiRoleDisPermObj.getDynamicObject("permitemforbid")) == null) continue;
                PermItem permItem = new PermItem();
                permItem.setAppNumber(appObj.getString("number"));
                permItem.setEntityNumber(entObj.getString("number"));
                permItem.setPermItemNumber(permItemObj.getString("number"));
                bizroleDisPermSet.add(permItem);
            }
            busiRole.setDisPermSet(bizroleDisPermSet);
            DynamicObjectCollection busiRoleDimCol = busiRoleObj.getDynamicObjectCollection("org_entry");
            HashSet<Dim> dimSet = new HashSet<Dim>(10);
            for (DynamicObject busiRoleDimObj : busiRoleDimCol) {
                DynamicObject dimNumObj = busiRoleDimObj.getDynamicObject("dim_num");
                if (dimNumObj == null) {
                    logger.info("BusiRoleMigration.generateJson: busiRoleDimObj.dim_num is null :" + busiRoleDimObj);
                    continue;
                }
                String dimType = busiRoleDimObj.getString("dimentitynum");
                DynamicObject dimObj = QueryServiceHelper.queryOne((String)dimType, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", dimNumObj.get("id"))});
                if (dimObj == null) continue;
                boolean isIncludeSub = busiRoleDimObj.getBoolean("isincludesuborg_visible");
                Dim dim = new Dim();
                dim.setDimNumber(dimObj.getString("number"));
                dim.setDimType(PermCommonUtil.getSuitableDimType((String)dimType)[0]);
                dim.setIncludeSub(Boolean.valueOf(isIncludeSub));
                dimSet.add(dim);
            }
            busiRole.setDimSet(dimSet);
            busiRoles.add(busiRole);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("userTypeMap", PermCommonUtil.getBosUserTypeMap());
        map.put("busiRoles", busiRoles);
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public boolean validate(Object data, StringBuilder mes, Map<Long, String> bosUserTypeMap, Map<Long, String> sourceUserTypeMap) {
        boolean dimTypeNumExist;
        ArrayList<String> errorList = new ArrayList<String>(10);
        BusiRole busiRole = (BusiRole)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String number = busiRole.getNumber();
        Set dimSet = busiRole.getDimSet();
        HashMap<String, List> dimTypeDimNumMap = new HashMap<String, List>(10);
        for (Object dim : dimSet) {
            String string = dim.getDimType();
            String dimNumber = dim.getDimNumber();
            dimTypeDimNumMap.computeIfAbsent(string, k -> new ArrayList(10)).add(dimNumber);
        }
        if (!dimTypeDimNumMap.isEmpty() && (dimTypeNumExist = PermMigrationHelper.isDimTypeNumExist(number, dimTypeDimNumMap.keySet(), errorList))) {
            for (Map.Entry entry : dimTypeDimNumMap.entrySet()) {
                DynamicObjectCollection existDimCol;
                Set existDimNums;
                Sets.SetView notExistDimNums;
                String dimTypeNum = (String)entry.getKey();
                List dimNums = (List)entry.getValue();
                String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimTypeNum);
                String bizObjectId = suitableDimType[1];
                if (!StringUtils.isNotEmpty((String)bizObjectId) || (notExistDimNums = Sets.difference(new HashSet(dimNums), existDimNums = (existDimCol = QueryServiceHelper.query((String)bizObjectId, (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dimNums)})).stream().map(k -> k.getString("number")).collect(Collectors.toSet()))).isEmpty()) continue;
                String notExistDimNumsStr = notExistDimNums.toString();
                notExistDimNumsStr = notExistDimNumsStr.substring(1, notExistDimNumsStr.length() - 1);
                errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684%2$s\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_14", (String)"bos-mservice-permission", (Object[])new Object[0]), notExistDimNumsStr, suitableDimType[3]));
            }
        }
        HashSet<String> appNums = new HashSet<String>(10);
        HashSet<String> entNums = new HashSet<String>(10);
        HashSet<String> hashSet = new HashSet<String>(10);
        Set comRoleSet = busiRole.getComRoleSet();
        busiRole.getBizrolePermSet().parallelStream().forEach(k -> {
            appNums.add(k.getAppNumber());
            entNums.add(k.getEntityNumber());
            permItemNums.add(k.getPermItemNumber());
        });
        busiRole.getDisPermSet().parallelStream().forEach(k -> {
            appNums.add(k.getAppNumber());
            entNums.add(k.getEntityNumber());
            permItemNums.add(k.getPermItemNumber());
        });
        String userTypeStr = busiRole.getType();
        PermMigrationHelper.isUserTypeExist(number, userTypeStr, bosUserTypeMap, sourceUserTypeMap, errorList);
        PermMigrationHelper.isComRoleNumExist(number, comRoleSet, errorList);
        PermMigrationHelper.isAppNumExist(number, appNums, errorList);
        PermMigrationHelper.isEntityNumExist(number, entNums, errorList);
        PermMigrationHelper.isPermItemNumExist(number, hashSet, errorList);
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        Map sourceUserTypeMap = (Map)map.get("userTypeMap");
        JSONArray busiRolesArr = (JSONArray)map.get("busiRoles");
        List busiRoles = busiRolesArr.toJavaList(BusiRole.class);
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        Map bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
        for (BusiRole busiRole : busiRoles) {
            if (!this.validate(busiRole, mes, bosUserTypeMap, sourceUserTypeMap)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            String number = busiRole.getNumber();
            DynamicObject busiRoleObj = BusinessDataServiceHelper.loadSingle((String)"perm_busirole", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            String mainId = "";
            if (busiRoleObj == null) {
                busiRoleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_busirole");
                busiRoleObj.set("number", (Object)number);
            } else {
                mainId = busiRoleObj.getPkValue() + "";
            }
            HashMap<String, Object> preData = new HashMap(1);
            if (PermCommonUtil.isEnablePermLog() && !"".equals(mainId)) {
                preData = PermBusiRoleLogHelper.busiRoleEventImage((Set)Sets.newHashSet((Object[])new String[]{mainId}), (boolean)false, (boolean)true);
            }
            busiRoleObj.set("name", (Object)busiRole.getName());
            busiRoleObj.set("usertype", (Object)busiRole.getType());
            busiRoleObj.set("description", (Object)busiRole.getRemark());
            busiRoleObj.set("enable", (Object)"1");
            PermMigrationHelper.setUnimportantInfo(busiRoleObj, true);
            String groupInfo = busiRole.getGroupId();
            if (StringUtils.isNotEmpty((String)groupInfo)) {
                String[] split = groupInfo.split("\\|");
                String busiRoleGrpNum = split[0];
                DynamicObject busiRoleGrpObj = QueryServiceHelper.queryOne((String)"perm_busirolegroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)busiRoleGrpNum)});
                if (busiRoleGrpObj != null) {
                    busiRoleObj.set("group", busiRoleGrpObj.get("id"));
                } else {
                    String busiRoleGrpName = split[1];
                    DynamicObject newBusiRoleGrpObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_busirolegroup");
                    newBusiRoleGrpObj.set("number", (Object)busiRoleGrpNum);
                    newBusiRoleGrpObj.set("name", (Object)busiRoleGrpName);
                    PermMigrationHelper.setUnimportantInfo(newBusiRoleGrpObj, true);
                    newBusiRoleGrpObj.set("enable", (Object)"1");
                    newBusiRoleGrpObj.set("level", (Object)1);
                    newBusiRoleGrpObj.set("isleaf", (Object)true);
                    newBusiRoleGrpObj.set("longnumber", (Object)busiRoleGrpNum);
                    Object[] sussessIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newBusiRoleGrpObj});
                    busiRoleObj.set("group", sussessIds[0]);
                }
            } else {
                busiRoleObj.set("group", null);
            }
            DynamicObjectCollection busiRoleComRoleCol = busiRoleObj.getDynamicObjectCollection("role_entry");
            busiRoleComRoleCol.clear();
            DynamicObjectType comRoleEntryType = busiRoleComRoleCol.getDynamicObjectType();
            Set comRoleSet = busiRole.getComRoleSet();
            DynamicObjectCollection comRoleCol = QueryServiceHelper.query((String)"perm_role", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)comRoleSet)});
            for (DynamicObject comRoleObj : comRoleCol) {
                DynamicObject comRoleEntryObj = new DynamicObject(comRoleEntryType);
                comRoleEntryObj.set("role_visible", comRoleObj.get("id"));
                busiRoleComRoleCol.add((Object)comRoleEntryObj);
            }
            DynamicObjectCollection busiRolePermCol = busiRoleObj.getDynamicObjectCollection("bizroleperm");
            busiRolePermCol.clear();
            DynamicObjectType busiRolePermEntryType = busiRolePermCol.getDynamicObjectType();
            Set busiRolePermSet = busiRole.getBizrolePermSet();
            for (PermItem busiRolePerm : busiRolePermSet) {
                DynamicObject busiRolePermEntryObj = new DynamicObject(busiRolePermEntryType);
                String appNum = busiRolePerm.getAppNumber();
                busiRolePermEntryObj.set("bizapp", (Object)PermMigrationHelper.getAppIdByAppNum(appNum));
                busiRolePermEntryObj.set("entitytype", (Object)busiRolePerm.getEntityNumber());
                DynamicObject permItemObj = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)busiRolePerm.getPermItemNumber())});
                busiRolePermEntryObj.set("permitem", permItemObj.get("id"));
                busiRolePermCol.add((Object)busiRolePermEntryObj);
            }
            DynamicObjectCollection busiRoleDisPermCol = busiRoleObj.getDynamicObjectCollection("bizroledisperm");
            busiRoleDisPermCol.clear();
            DynamicObjectType busiRoleDisPermEntryType = busiRoleDisPermCol.getDynamicObjectType();
            Set busiRoleDisPermSet = busiRole.getDisPermSet();
            for (PermItem busiRoleDisPerm : busiRoleDisPermSet) {
                DynamicObject busiRoleDisPermEntryObj = new DynamicObject(busiRoleDisPermEntryType);
                String appNum = busiRoleDisPerm.getAppNumber();
                busiRoleDisPermEntryObj.set("bizappforbid", (Object)PermMigrationHelper.getAppIdByAppNum(appNum));
                busiRoleDisPermEntryObj.set("entitytypeforbid", (Object)busiRoleDisPerm.getEntityNumber());
                DynamicObject permItemObj = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)busiRoleDisPerm.getPermItemNumber())});
                busiRoleDisPermEntryObj.set("permitemforbid", permItemObj.get("id"));
                busiRoleDisPermCol.add((Object)busiRoleDisPermEntryObj);
            }
            DynamicObjectCollection busiRoleDimCol = busiRoleObj.getDynamicObjectCollection("org_entry");
            busiRoleDimCol.clear();
            DynamicObjectType busiRoleDimEntryType = busiRoleDimCol.getDynamicObjectType();
            Set busiRoleDimSet = busiRole.getDimSet();
            for (Dim busiRoleDim : busiRoleDimSet) {
                DynamicObject busiRoleDimEntryObj = new DynamicObject(busiRoleDimEntryType);
                busiRoleDimEntryObj.set("isincludesuborg_visible", (Object)busiRoleDim.getIncludeSub());
                String dimTypeNum = busiRoleDim.getDimType();
                String lowerCasedimType = PermCommonUtil.getSuitableDimType((String)dimTypeNum)[1];
                busiRoleDimEntryObj.set("dimentitynum", (Object)lowerCasedimType);
                String dimNumber = busiRoleDim.getDimNumber();
                Object dimId = QueryServiceHelper.queryOne((String)lowerCasedimType, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber)}).get("id");
                busiRoleDimEntryObj.set("dim_num", dimId);
                busiRoleDimCol.add((Object)busiRoleDimEntryObj);
            }
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busiRoleObj});
                    ++successCount;
                    if (pkIds.length != 1 || !PermCommonUtil.isEnablePermLog()) continue;
                    String successId = ((DynamicObject)pkIds[0]).get("id") + "";
                    Map afterData = PermBusiRoleLogHelper.busiRoleEventImage((Set)Sets.newHashSet((Object[])new String[]{successId}), (boolean)true, (boolean)true);
                    BusiRoleService busiRoleService = (BusiRoleService)PermServiceFactory.getService("BusiRoleService");
                    HashMap<String, Map<String, Object>> busiRoleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(1);
                    busiRoleIdSaveDiffMap.put(successId, busiRoleService.getSaveDiffMap(successId, preData, afterData));
                    String permLogBusiType = "".equals(mainId) ? "busirole_role_add_save" : "busirole_role_modify_save";
                    HashMap<String, String> paramMap = new HashMap<String, String>(10);
                    paramMap.put("ENTSAVE_PERMLOG", "1");
                    paramMap.put("permlog_op", "save");
                    paramMap.put("permlog_opbtn", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u5165", (String)"PermDataMigrationNewUtils_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
                    paramMap.put("permlog_interfacemethod", "kd.bos.permission.util.PermDataMigrationNewUtils.importBusiRolesJson");
                    paramMap.put("permlog_busitype", permLogBusiType);
                    paramMap.put("permlog_formnum", "perm_datamigration");
                    paramMap.put("currbizappid", "0XWTKVOQW+ML");
                    PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(paramMap, null, null, null, null, null);
                    permLogReq.setBusiFrom(ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u4e1a\u52a1\u89d2\u8272", (String)"PermDataMigrationNewUtils_8", (String)"bos-mservice-permission", (Object[])new Object[0]));
                    busiRoleService.saveOrDelPermLog(permLogReq, Sets.newHashSet((Object[])new String[]{successId}), busiRoleIdSaveDiffMap, preData);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }
}

