/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.service.ComRoleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class ComRoleMigration
implements PermMigratedBean {
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"ComRoleMigration_CachedThreadPool", (int)4);

    @Override
    public String generateJson(Set<Object> exportDataIds) {
        DynamicObject[] comRoleObjs = BusinessDataServiceHelper.load((Object[])exportDataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_role"));
        if (comRoleObjs.length == 0) {
            logger.info("ComRoleMigration.generateJson: comRoleObjs.length == 0");
            return "";
        }
        Future<Map<String, Set<PermItem>>> comRoleFuncPermMapFuture = ComRoleMigration.queryComRoleFuncPerm(exportDataIds);
        Future<Map<String, Set<FieldPerm>>> comRoleFieldPermMapFuture = ComRoleMigration.queryComRoleFieldPerm(exportDataIds);
        Future<Map<String, Set<NewDrPerm>>> comRoleNewDrPermMapFuture = ComRoleMigration.queryComRoleDrPerm(exportDataIds);
        Future<Map<String, Set<NewDrPrPerm>>> comRoleNewDrPrPermMapFuture = ComRoleMigration.queryComRoleDrPrPerm(exportDataIds);
        ArrayList<ComRole> comRoles = new ArrayList<ComRole>(10);
        for (DynamicObject comRoleObj : comRoleObjs) {
            String roleId = comRoleObj.getString("id");
            ComRole comRole = new ComRole();
            comRole.setNumber(comRoleObj.getString("number"));
            comRole.setName(comRoleObj.getString("name"));
            DynamicObject appObj = comRoleObj.getDynamicObject("bizdomain");
            if (appObj != null) {
                comRole.setBizDomainId(appObj.getString("number"));
            }
            comRole.setType(comRoleObj.getString("roletype"));
            DynamicObject roleGroupObj = comRoleObj.getDynamicObject("group");
            if (roleGroupObj != null) {
                comRole.setGroupId(roleGroupObj.getString("number") + "|" + roleGroupObj.getString("name"));
            }
            comRole.setRemark(comRoleObj.getString("remark"));
            comRole.setSystem(Boolean.valueOf(comRoleObj.getBoolean("issystem")));
            comRole.setEnable(Boolean.valueOf(comRoleObj.getBoolean("enable")));
            DynamicObject createAdminGrpObj = comRoleObj.getDynamicObject("createadmingrp");
            if (createAdminGrpObj != null) {
                comRole.setCreateAdminGrp(createAdminGrpObj.getString("number"));
            }
            comRole.setUseScope(comRoleObj.getString("usescope"));
            DynamicObject dimtypeObj = comRoleObj.getDynamicObject("dimtypeid");
            if (dimtypeObj != null) {
                comRole.setDimTypeId(dimtypeObj.getString("number"));
            }
            HashSet<ComRoleAdminGrp> comRoleAdminGrpSet = new HashSet<ComRoleAdminGrp>(10);
            DynamicObjectCollection comRoleAdminGrpCol = QueryServiceHelper.query((String)"perm_admingrouprole", (String)"admingroup,modifiable", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)comRoleObj.getString("id"))});
            for (DynamicObject comRoleAdminGrpObj : comRoleAdminGrpCol) {
                DynamicObject adminGroupObj = comRoleAdminGrpObj.getDynamicObject("admingroup");
                if (adminGroupObj == null) continue;
                ComRoleAdminGrp comRoleAdminGrp = new ComRoleAdminGrp();
                comRoleAdminGrp.setAdminGroupNumber(adminGroupObj.getString("number"));
                comRoleAdminGrp.setModifiable(comRoleAdminGrpObj.getBoolean("modifiable"));
                comRoleAdminGrpSet.add(comRoleAdminGrp);
            }
            comRole.setComRoleAdminGrpSet(comRoleAdminGrpSet);
            try {
                Map<String, Set<PermItem>> comRoleFuncPermMap = comRoleFuncPermMapFuture.get();
                comRole.setFuncPermSet(comRoleFuncPermMap.get(roleId));
                Map<String, Set<FieldPerm>> comRoleFieldPermMap = comRoleFieldPermMapFuture.get();
                comRole.setFieldPermSet(comRoleFieldPermMap.get(roleId));
                Map<String, Set<NewDrPerm>> comRoleNewDrPermMap = comRoleNewDrPermMapFuture.get();
                comRole.setNewDrPermSet(comRoleNewDrPermMap.get(roleId));
                Map<String, Set<NewDrPrPerm>> comRoleNewDrPrPermMap = comRoleNewDrPrPermMapFuture.get();
                comRole.setNewDrPrPermSet(comRoleNewDrPrPermMap.get(roleId));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            comRoles.add(comRole);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("userTypeMap", PermCommonUtil.getBosUserTypeMap());
        map.put("comRoles", comRoles);
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public boolean validate(Object data, StringBuilder mes, Map<Long, String> bosUserTypeMap, Map<Long, String> sourceUserTypeMap) {
        Set newDrPrPermSet;
        Set newDrPermSet;
        String entityNumber;
        Set fieldPermSet;
        Set funcPermSet;
        String dimTypeNum;
        ArrayList<String> errorList = new ArrayList<String>(10);
        ComRole comRole = (ComRole)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String number = comRole.getNumber();
        HashSet<String> adminGrpNums = new HashSet<String>(10);
        String createAdminGrp = comRole.getCreateAdminGrp();
        if (StringUtils.isNotEmpty((String)createAdminGrp)) {
            adminGrpNums.add(createAdminGrp);
        }
        Set comRoleAdminGrpSet = comRole.getComRoleAdminGrpSet();
        for (ComRoleAdminGrp comRoleAdminGrp : comRoleAdminGrpSet) {
            adminGrpNums.add(comRoleAdminGrp.getAdminGroupNumber());
        }
        if (!adminGrpNums.isEmpty()) {
            PermMigrationHelper.isAdminGrpNumExist(number, adminGrpNums, errorList);
        }
        if (StringUtils.isNotEmpty((String)(dimTypeNum = comRole.getDimTypeId())) && !QueryServiceHelper.exists((String)"perm_ctrltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimTypeNum)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_5", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNum));
        }
        HashSet<String> appNums = new HashSet<String>(10);
        HashSet<String> entNums = new HashSet<String>(10);
        HashSet<String> permItemNums = new HashSet<String>(10);
        HashMap<String, String> fieldSchemeNumEntNumMap = new HashMap<String, String>(10);
        HashMap<String, String> newDrPermNumEntNumMap = new HashMap<String, String>(10);
        String appNum = comRole.getBizDomainId();
        if (StringUtils.isNotEmpty((String)appNum)) {
            appNums.add(appNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)(funcPermSet = comRole.getFuncPermSet()))) {
            for (PermItem permItem : funcPermSet) {
                appNums.add(permItem.getAppNumber());
                entNums.add(permItem.getEntityNumber());
                permItemNums.add(permItem.getPermItemNumber());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldPermSet = comRole.getFieldPermSet()))) {
            for (FieldPerm fieldPerm : fieldPermSet) {
                String fieldSchemeNum;
                String appNumber = fieldPerm.getAppNumber();
                if (StringUtils.isNotEmpty((String)appNumber)) {
                    appNums.add(appNumber);
                }
                if (StringUtils.isNotEmpty((String)(entityNumber = fieldPerm.getEntityNumber()))) {
                    entNums.add(entityNumber);
                }
                if (!StringUtils.isEmpty((String)fieldPerm.getControlMode()) || !StringUtils.isNotEmpty((String)(fieldSchemeNum = fieldPerm.getFieldName()))) continue;
                fieldSchemeNumEntNumMap.put(fieldSchemeNum, entityNumber);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(newDrPermSet = comRole.getNewDrPermSet()))) {
            for (NewDrPerm newDrPerm : newDrPermSet) {
                entityNumber = newDrPerm.getEntityNumber();
                appNums.add(newDrPerm.getAppNumber());
                entNums.add(entityNumber);
                permItemNums.add(newDrPerm.getPermItemNumber());
                newDrPermNumEntNumMap.put(newDrPerm.getDataRuleName(), entityNumber);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(newDrPrPermSet = comRole.getNewDrPrPermSet()))) {
            for (NewDrPrPerm newDrPrPerm : newDrPrPermSet) {
                appNums.add(newDrPrPerm.getAppNumber());
                entNums.add(newDrPrPerm.getEntityNumber());
                newDrPermNumEntNumMap.put(newDrPrPerm.getDataRuleName(), newDrPrPerm.getPropEntNum());
            }
        }
        String userTypeStr = comRole.getType();
        PermMigrationHelper.isUserTypeExist(number, userTypeStr, bosUserTypeMap, sourceUserTypeMap, errorList);
        PermMigrationHelper.isAppNumExist(number, appNums, errorList);
        PermMigrationHelper.isEntityNumExist(number, entNums, errorList);
        PermMigrationHelper.isPermItemNumExist(number, permItemNums, errorList);
        PermMigrationHelper.isFieldSchemeNumEntNumExist(number, fieldSchemeNumEntNumMap, errorList);
        PermMigrationHelper.isNewDrNumEntNumExist(number, newDrPermNumEntNumMap, errorList);
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        Map sourceUserTypeMap = (Map)map.get("userTypeMap");
        JSONArray comRolesArr = (JSONArray)map.get("comRoles");
        List comRoles = comRolesArr.toJavaList(ComRole.class);
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        Map bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
        for (ComRole comRole : comRoles) {
            if (!this.validate(comRole, mes, bosUserTypeMap, sourceUserTypeMap)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            String number = comRole.getNumber();
            DynamicObject comRoleObj = BusinessDataServiceHelper.loadSingle((String)"perm_role", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            String mainId = "";
            if (comRoleObj == null) {
                comRoleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_role");
                comRoleObj.set("number", (Object)number);
            } else {
                mainId = (String)comRoleObj.getPkValue();
            }
            HashMap<String, Object> preData = new HashMap(1);
            if (PermCommonUtil.isEnablePermLog()) {
                HashSet<String> roleIdSet = new HashSet<String>(1);
                roleIdSet.add(mainId);
                preData = PermRoleLogHelper.commRoleEventImage(roleIdSet, (boolean)false, (boolean)true);
            }
            comRoleObj.set("name", (Object)comRole.getName());
            String appNumber = comRole.getBizDomainId();
            if (StringUtils.isNotEmpty((String)appNumber)) {
                comRoleObj.set("bizdomain", (Object)PermMigrationHelper.getAppIdByAppNum(appNumber));
            } else {
                comRoleObj.set("bizdomain", null);
            }
            comRoleObj.set("roletype", (Object)comRole.getType());
            String groupInfo = comRole.getGroupId();
            if (StringUtils.isNotEmpty((String)groupInfo)) {
                String[] split = groupInfo.split("\\|");
                String roleGrpNum = split[0];
                DynamicObject roleGrpObj = QueryServiceHelper.queryOne((String)"perm_rolegroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)roleGrpNum)});
                if (roleGrpObj != null) {
                    comRoleObj.set("group", roleGrpObj.get("id"));
                } else {
                    String roleGrpName = split[1];
                    DynamicObject newRoleGrpObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolegroup");
                    newRoleGrpObj.set("number", (Object)roleGrpNum);
                    newRoleGrpObj.set("name", (Object)roleGrpName);
                    PermMigrationHelper.setUnimportantInfo(newRoleGrpObj, true);
                    newRoleGrpObj.set("enable", (Object)"1");
                    newRoleGrpObj.set("level", (Object)1);
                    newRoleGrpObj.set("isleaf", (Object)true);
                    newRoleGrpObj.set("longnumber", (Object)roleGrpNum);
                    Object[] sussessIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newRoleGrpObj});
                    comRoleObj.set("group", sussessIds[0]);
                }
            } else {
                comRoleObj.set("group", null);
            }
            comRoleObj.set("remark", (Object)comRole.getRemark());
            comRoleObj.set("issystem", (Object)comRole.isSystem());
            comRoleObj.set("enable", (Object)(comRole.isEnable() != false ? "1" : "0"));
            PermMigrationHelper.setUnimportantInfo(comRoleObj, true);
            String createAdminGrp = comRole.getCreateAdminGrp();
            if (StringUtils.isNotEmpty((String)createAdminGrp)) {
                DynamicObject createAdminGrpObj = QueryServiceHelper.queryOne((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createAdminGrp)});
                comRoleObj.set("createadmingrp", createAdminGrpObj.get("id"));
            } else {
                comRoleObj.set("createadmingrp", null);
            }
            comRoleObj.set("usescope", (Object)comRole.getUseScope());
            String dimTypeNum = comRole.getDimTypeId();
            if (StringUtils.isNotEmpty((String)createAdminGrp)) {
                DynamicObject dimTypeObj = QueryServiceHelper.queryOne((String)"perm_ctrltype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimTypeNum)});
                comRoleObj.set("dimtypeid", dimTypeObj.get("id"));
            } else {
                comRoleObj.set("dimtypeid", (Object)"DIM_ORG");
            }
            DynamicObjectCollection comRoleAdminGrpCol = comRoleObj.getDynamicObjectCollection("entry_assign_admingrp");
            comRoleAdminGrpCol.clear();
            Set comRoleAdminGrpSet = comRole.getComRoleAdminGrpSet();
            if (CollectionUtils.isNotEmpty((Collection)comRoleAdminGrpSet)) {
                DynamicObjectType entryType = comRoleAdminGrpCol.getDynamicObjectType();
                for (ComRoleAdminGrp comRoleAdminGrp : comRoleAdminGrpSet) {
                    DynamicObject entryObj = new DynamicObject(entryType);
                    String adminGrpNum = comRoleAdminGrp.getAdminGroupId();
                    DynamicObject adminGrpObj = QueryServiceHelper.queryOne((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)adminGrpNum)});
                    comRoleObj.set("admingrp", adminGrpObj.get("id"));
                    entryObj.set("rolemodifiable", (Object)comRoleAdminGrp.isModifiable());
                    comRoleAdminGrpCol.add((Object)entryObj);
                }
            } else {
                comRoleAdminGrpCol.clear();
            }
            TXHandle h = TX.required();
            Object object = null;
            try {
                try {
                    boolean hasEnableRoleDataRuleNewModel;
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{comRoleObj});
                    ++successCount;
                    if (pkIds.length != 1) {
                        throw new KDBizException("save error");
                    }
                    String successId = (String)((DynamicObject)pkIds[0]).getPkValue();
                    DeleteServiceHelper.delete((String)"perm_rolefuncperm", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                    DeleteServiceHelper.delete((String)"perm_rolefieldscheme", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                    DynamicObject[] roleFieldPermCol = BusinessDataServiceHelper.load((String)"perm_rolefieldperm", (String)"fieldperm", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                    if (roleFieldPermCol.length != 0) {
                        ArrayList<Object> fieldPermPks = new ArrayList<Object>(roleFieldPermCol.length);
                        StringBuilder fieldPermStr = new StringBuilder();
                        for (DynamicObject roleFieldPerm : roleFieldPermCol) {
                            DynamicObject fieldPermObj = roleFieldPerm.getDynamicObject("fieldperm");
                            if (fieldPermObj == null) continue;
                            Object id = fieldPermObj.get("id");
                            fieldPermStr.append("'").append(id).append("'").append(",");
                            fieldPermPks.add(id);
                        }
                        fieldPermStr.deleteCharAt(fieldPermStr.length() - 1);
                        DeleteServiceHelper.delete((String)"perm_fieldperm", (QFilter[])new QFilter[]{new QFilter("id", "in", fieldPermPks)});
                        DeleteServiceHelper.delete((String)"perm_rolefieldperm", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                    }
                    if (hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel()) {
                        DeleteServiceHelper.delete((String)"perm_roledatarule", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                        DeleteServiceHelper.delete((String)"perm_roledatarule_prop", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
                    } else {
                        this.delRoleDrOldModelByRoleId(successId);
                    }
                    Set funcPermSet = comRole.getFuncPermSet();
                    if (CollectionUtils.isNotEmpty((Collection)funcPermSet)) {
                        ArrayList<DynamicObject> funPermList = new ArrayList<DynamicObject>(funcPermSet.size());
                        for (PermItem permItem : funcPermSet) {
                            DynamicObject roleFuncPerm = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolefuncperm");
                            roleFuncPerm.set("role", (Object)successId);
                            roleFuncPerm.set("bizapp", (Object)PermMigrationHelper.getAppIdByAppNum(permItem.getAppNumber()));
                            DynamicObject entObj = QueryServiceHelper.queryOne((String)"bos_objecttype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)permItem.getEntityNumber())});
                            roleFuncPerm.set("entity", entObj.get("id"));
                            DynamicObject permItemObj = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)permItem.getPermItemNumber())});
                            roleFuncPerm.set("permitem", permItemObj.get("id"));
                            funPermList.add(roleFuncPerm);
                        }
                        SaveServiceHelper.save((DynamicObject[])funPermList.toArray(new DynamicObject[0]));
                    }
                    ComRoleMigration.setComRoleFieldPerm(comRole, successId);
                    ComRoleMigration.setComRoleNewDrPerm(comRole, successId);
                    ComRoleMigration.setComRoleNewDrPrPerm(comRole, successId);
                    if (!PermCommonUtil.isEnablePermLog()) continue;
                    Map afterData = PermRoleLogHelper.commRoleEventImage((Set)Sets.newHashSet((Object[])new String[]{successId}), (boolean)true, (boolean)true);
                    ComRoleService comRoleService = (ComRoleService)PermServiceFactory.getService("ComRoleService");
                    HashMap<String, Map<String, Object>> roleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(1);
                    roleIdSaveDiffMap.put(successId, comRoleService.getSaveDiffMap(successId, preData, afterData));
                    String permLogBusiType = null == mainId || "".equals(mainId) ? "common_role_add_save" : "common_role_modify_save";
                    HashMap<String, String> paramMap = new HashMap<String, String>(10);
                    paramMap.put("ENTSAVE_PERMLOG", "1");
                    paramMap.put("permlog_op", "save");
                    paramMap.put("permlog_opbtn", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u5165", (String)"PermDataMigrationNewUtils_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
                    paramMap.put("permlog_interfacemethod", "kd.bos.permission.util.PermDataMigrationNewUtils.importComRolesJson");
                    paramMap.put("permlog_busitype", permLogBusiType);
                    paramMap.put("permlog_formnum", "perm_datamigration");
                    paramMap.put("currbizappid", "0XWTKVOQW+ML");
                    PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(paramMap, null, null, null, null, null);
                    permLogReq.setBusiFrom(ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u901a\u7528\u89d2\u8272", (String)"PermDataMigrationNewUtils_3", (String)"bos-mservice-permission", (Object[])new Object[0]));
                    comRoleService.saveOrDelPermLog(permLogReq, Sets.newHashSet((Object[])new String[]{successId}), roleIdSaveDiffMap, preData);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h == null) continue;
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                h.close();
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }

    @Deprecated
    private void delRoleDrOldModelByRoleId(String successId) {
        DynamicObject[] roleDrsCol = BusinessDataServiceHelper.load((String)"perm_roledatarules", (String)"datarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
        if (roleDrsCol.length != 0) {
            ArrayList<Object> drsPks = new ArrayList<Object>(roleDrsCol.length);
            StringBuilder drsStr = new StringBuilder();
            for (DynamicObject roleDrs : roleDrsCol) {
                DynamicObject drsObj = roleDrs.getDynamicObject("datarules");
                if (drsObj == null) continue;
                Object id = drsObj.get("id");
                drsStr.append(id).append(",");
                drsPks.add(id);
            }
            drsStr.deleteCharAt(drsStr.length() - 1);
            DeleteServiceHelper.delete((String)"perm_datarules", (QFilter[])new QFilter[]{new QFilter("id", "in", drsPks)});
            DB.execute((DBRoute)DBRoute.permission, (String)("delete from t_perm_datarules_entry where fid in (" + drsStr + ')'));
            DeleteServiceHelper.delete((String)"perm_roledatarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
        }
    }

    private static Future<Map<String, Set<PermItem>>> queryComRoleFuncPerm(Set<Object> roleIds) {
        Callable<Map> callable = () -> {
            DynamicObject[] roleFuncPermObjArr = BusinessDataServiceHelper.load((String)"perm_rolefuncperm", (String)"role,bizapp,entity,permitem", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIds)});
            HashMap<String, Set> comRoleFuncPermMap = new HashMap<String, Set>(10);
            for (DynamicObject roleFuncPermObj : roleFuncPermObjArr) {
                DynamicObject permItemObj;
                DynamicObject entityObj;
                DynamicObject bizappObj;
                DynamicObject roleObj = roleFuncPermObj.getDynamicObject("role");
                if (roleObj == null || (bizappObj = roleFuncPermObj.getDynamicObject("bizapp")) == null || (entityObj = roleFuncPermObj.getDynamicObject("entity")) == null || (permItemObj = roleFuncPermObj.getDynamicObject("permitem")) == null) continue;
                PermItem permItem = new PermItem();
                permItem.setAppNumber(bizappObj.getString("number"));
                permItem.setEntityNumber(entityObj.getString("number"));
                permItem.setPermItemNumber(permItemObj.getString("number"));
                comRoleFuncPermMap.computeIfAbsent(roleObj.getString("id"), k -> new HashSet(10)).add(permItem);
            }
            return comRoleFuncPermMap;
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, Set<FieldPerm>>> queryComRoleFieldPerm(Set<Object> roleIds) {
        Callable<Map> callable = () -> {
            DynamicObject[] roleFieldPermSchemeObjArr;
            DynamicObject bizappObj;
            DynamicObject fieldpermObj;
            DynamicObject roleObj;
            HashMap<String, Set> comRoleFieldPermMap = new HashMap<String, Set>(10);
            DynamicObject roleFieldPermObj = BusinessDataServiceHelper.loadSingle((String)"perm_rolefieldperm", (String)"role,fieldperm", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIds)});
            if (roleFieldPermObj != null && (roleObj = roleFieldPermObj.getDynamicObject("role")) != null && (fieldpermObj = roleFieldPermObj.getDynamicObject("fieldperm")) != null) {
                String fieldPermNum = fieldpermObj.getString("number");
                DynamicObjectCollection fieldRuleCol = fieldpermObj.getDynamicObjectCollection("fieldrule");
                for (DynamicObject fieldRule : fieldRuleCol) {
                    FieldPerm fieldPerm = new FieldPerm();
                    fieldPerm.setFieldPermNumber(fieldPermNum);
                    bizappObj = fieldRule.getDynamicObject("bizapp");
                    if (bizappObj == null) continue;
                    fieldPerm.setAppNumber(bizappObj.getString("number"));
                    DynamicObject entObj = fieldRule.getDynamicObject("entitytype");
                    if (entObj == null) continue;
                    fieldPerm.setEntityNumber(entObj.getString("number"));
                    fieldPerm.setFieldName(fieldRule.getString("fieldname"));
                    fieldPerm.setControlMode(fieldRule.getString("rowcondition"));
                    comRoleFieldPermMap.computeIfAbsent(roleObj.getString("id"), k -> new HashSet(10)).add(fieldPerm);
                }
            }
            for (DynamicObject roleFieldPermSchemeObj : roleFieldPermSchemeObjArr = BusinessDataServiceHelper.load((String)"perm_rolefieldscheme", (String)"role,fps,app,ent", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIds)})) {
                DynamicObject entityObj;
                DynamicObject fieldpermSchemeObj;
                DynamicObject roleObj2 = roleFieldPermSchemeObj.getDynamicObject("role");
                if (roleObj2 == null || (fieldpermSchemeObj = roleFieldPermSchemeObj.getDynamicObject("fps")) == null || (bizappObj = roleFieldPermSchemeObj.getDynamicObject("app")) == null || (entityObj = roleFieldPermSchemeObj.getDynamicObject("ent")) == null) continue;
                FieldPerm fieldPerm = new FieldPerm();
                fieldPerm.setFieldName(fieldpermSchemeObj.getString("number"));
                fieldPerm.setAppNumber(bizappObj.getString("number"));
                fieldPerm.setEntityNumber(entityObj.getString("number"));
                comRoleFieldPermMap.computeIfAbsent(roleObj2.getString("id"), k -> new HashSet(10)).add(fieldPerm);
            }
            return comRoleFieldPermMap;
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, Set<NewDrPerm>>> queryComRoleDrPerm(Set<Object> roleIds) {
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        Callable<Map> callable = () -> {
            HashMap<String, Set<NewDrPerm>> comRoleDrPermMap = new HashMap<String, Set<NewDrPerm>>(10);
            if (hasEnableRoleDataRuleNewModel) {
                DynamicObject[] roleDataRuleObjArr = BusinessDataServiceHelper.load((String)"perm_roledatarule", (String)"role, app, entity, permitem, datarule, modifier, modifytime", (QFilter[])new QFilter("role", "in", (Object)roleIds).toArray());
                if (roleDataRuleObjArr != null && roleDataRuleObjArr.length != 0) {
                    for (DynamicObject roleDataRuleObj : roleDataRuleObjArr) {
                        String roleId = roleDataRuleObj.getString("role_id");
                        String appId = roleDataRuleObj.getString("app_id");
                        String entityNum = roleDataRuleObj.getString("entity_id");
                        String permItemId = roleDataRuleObj.getString("permitem_id");
                        Long dataRuleId = roleDataRuleObj.getLong("datarule_id");
                        String appNum = "";
                        DynamicObject appObj = roleDataRuleObj.getDynamicObject("app");
                        if (appObj != null) {
                            appNum = appObj.getString("number");
                        }
                        DynamicObject permItemObj = roleDataRuleObj.getDynamicObject("permitem");
                        String permItemNum = "";
                        if (permItemObj != null) {
                            permItemNum = permItemObj.getString("number");
                        }
                        DynamicObject dataRuleObj = roleDataRuleObj.getDynamicObject("datarule");
                        String dataRuleNum = "";
                        if (dataRuleObj != null) {
                            dataRuleNum = dataRuleObj.getString("number");
                        }
                        NewDrPerm newDrPerm = new NewDrPerm();
                        newDrPerm.setAppId(appId);
                        newDrPerm.setAppNumber(appNum);
                        newDrPerm.setEntityNumber(entityNum);
                        newDrPerm.setPermItemId(permItemId);
                        newDrPerm.setPermItemNumber(permItemNum);
                        newDrPerm.setDataRuleId(dataRuleId);
                        newDrPerm.setDataRuleName(dataRuleNum);
                        comRoleDrPermMap.computeIfAbsent(roleId, k -> new HashSet(10)).add(newDrPerm);
                    }
                }
                return comRoleDrPermMap;
            }
            return ComRoleMigration.queryComRoleDrPermDeprecated(roleIds, comRoleDrPermMap);
        };
        return pool.submit(callable);
    }

    @Deprecated
    private static Map<String, Set<NewDrPerm>> queryComRoleDrPermDeprecated(Set<Object> roleIds, Map<String, Set<NewDrPerm>> comRoleDrPermMap) {
        DynamicObject[] roleDrsArr;
        for (DynamicObject roleDrsObj : roleDrsArr = BusinessDataServiceHelper.load((String)"perm_roledatarules", (String)"role,datarules", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIds)})) {
            DynamicObject dataRulesObj;
            DynamicObject roleObj = roleDrsObj.getDynamicObject("role");
            if (roleObj == null || (dataRulesObj = roleDrsObj.getDynamicObject("datarules")) == null) continue;
            DynamicObjectCollection dataRulesEntryCol = dataRulesObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dataRulesEntry : dataRulesEntryCol) {
                DynamicObject dataRule;
                DynamicObject entObj;
                DynamicObject appObj = dataRulesEntry.getDynamicObject("bizapp");
                if (appObj == null || (entObj = dataRulesEntry.getDynamicObject("entity")) == null || (dataRule = dataRulesEntry.getDynamicObject("datarule")) == null) continue;
                long dataRuleId = dataRule.getLong("id");
                StringBuilder sql = new StringBuilder().append("select p.fnumber permitemnum,d.fnumber drnumber ").append("from t_perm_datarule_entry de ").append("join t_perm_permitem p on (de.fpermitemid = p.fid) ").append("join t_perm_datarule d on (de.fdataruleid = d.fid) ").append("where de.fid = ? ");
                DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{dataRuleId}, rs -> {
                    while (rs.next()) {
                        NewDrPerm newDrPerm = new NewDrPerm();
                        newDrPerm.setDataRuleName(rs.getString("drnumber"));
                        newDrPerm.setAppNumber(appObj.getString("number"));
                        newDrPerm.setEntityNumber(entObj.getString("number"));
                        newDrPerm.setPermItemNumber(rs.getString("permitemnum"));
                        comRoleDrPermMap.computeIfAbsent(roleObj.getString("id"), k -> new HashSet(10)).add(newDrPerm);
                    }
                    return true;
                });
            }
        }
        return comRoleDrPermMap;
    }

    private static Future<Map<String, Set<NewDrPrPerm>>> queryComRoleDrPrPerm(Set<Object> roleIds) {
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        Callable<Map> callable = () -> {
            HashMap<String, Set<NewDrPrPerm>> comRoleDrPrPermMap = new HashMap<String, Set<NewDrPrPerm>>(10);
            if (hasEnableRoleDataRuleNewModel) {
                DynamicObject[] roleDataRuleObjArr = BusinessDataServiceHelper.load((String)"perm_roledatarule_prop", (String)"role, app, entity, propkey, propentnum, datarule, modifier, modifytime", (QFilter[])new QFilter("role", "in", (Object)roleIds).toArray());
                if (roleDataRuleObjArr != null && roleDataRuleObjArr.length != 0) {
                    for (DynamicObject roleDataRuleObj : roleDataRuleObjArr) {
                        String roleId = roleDataRuleObj.getString("role_id");
                        String appId = roleDataRuleObj.getString("app_id");
                        String entityNum = roleDataRuleObj.getString("entity_id");
                        String propKey = roleDataRuleObj.getString("propkey");
                        String propEntNum = roleDataRuleObj.getString("propentnum");
                        Long dataRuleId = roleDataRuleObj.getLong("datarule_id");
                        String appNum = "";
                        DynamicObject appObj = roleDataRuleObj.getDynamicObject("app");
                        if (appObj != null) {
                            appNum = appObj.getString("number");
                        }
                        DynamicObject dataRuleObj = roleDataRuleObj.getDynamicObject("datarule");
                        String dataRuleNum = "";
                        if (dataRuleObj != null) {
                            dataRuleNum = dataRuleObj.getString("number");
                        }
                        NewDrPrPerm newDrPr = new NewDrPrPerm();
                        newDrPr.setAppId(appId);
                        newDrPr.setAppNumber(appNum);
                        newDrPr.setEntityNumber(entityNum);
                        newDrPr.setPropKey(propKey);
                        newDrPr.setPropEntNum(propEntNum);
                        newDrPr.setDataRuleId(dataRuleId);
                        newDrPr.setDataRuleName(dataRuleNum);
                        comRoleDrPrPermMap.computeIfAbsent(roleId, k -> new HashSet(10)).add(newDrPr);
                    }
                }
                return comRoleDrPrPermMap;
            }
            return ComRoleMigration.queryComRoleDrPrPermDeprecated(roleIds, comRoleDrPrPermMap);
        };
        return pool.submit(callable);
    }

    @Deprecated
    private static Map<String, Set<NewDrPrPerm>> queryComRoleDrPrPermDeprecated(Set<Object> roleIds, Map<String, Set<NewDrPrPerm>> comRoleDrPrPermMap) {
        DynamicObject[] roleDrsArr;
        for (DynamicObject roleDrsObj : roleDrsArr = BusinessDataServiceHelper.load((String)"perm_roledatarules", (String)"role,datarules", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIds)})) {
            DynamicObject dataRulesObj;
            DynamicObject roleObj = roleDrsObj.getDynamicObject("role");
            if (roleObj == null || (dataRulesObj = roleDrsObj.getDynamicObject("datarules")) == null) continue;
            DynamicObjectCollection dataRulesEntryCol = dataRulesObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dataRulesEntry : dataRulesEntryCol) {
                DynamicObject dataRule;
                DynamicObject entObj;
                DynamicObject appObj = dataRulesEntry.getDynamicObject("bizapp");
                if (appObj == null || (entObj = dataRulesEntry.getDynamicObject("entity")) == null || (dataRule = dataRulesEntry.getDynamicObject("datarule")) == null) continue;
                long dataRuleId = dataRule.getLong("id");
                StringBuilder sql = new StringBuilder().append("select dp.fpropkey propkey,dp.fpropentnum entnum,d.fnumber drnumber ").append("from t_perm_datarule_prop dp ").append("join t_perm_datarule d on (dp.fdataruleid = d.fid) ").append("where dp.fid = ? ");
                DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{dataRuleId}, rs -> {
                    while (rs.next()) {
                        NewDrPrPerm newDrPrPerm = new NewDrPrPerm();
                        newDrPrPerm.setDataRuleName(rs.getString("drnumber"));
                        newDrPrPerm.setAppNumber(appObj.getString("number"));
                        newDrPrPerm.setEntityNumber(entObj.getString("number"));
                        newDrPrPerm.setPropKey(rs.getString("propkey"));
                        newDrPrPerm.setPropEntNum(rs.getString("entnum"));
                        comRoleDrPrPermMap.computeIfAbsent(roleObj.getString("id"), k -> new HashSet(10)).add(newDrPrPerm);
                    }
                    return true;
                });
            }
        }
        return comRoleDrPrPermMap;
    }

    private static void setComRoleNewDrPrPerm(ComRole comRole, String successId) {
        Set newDrPrPermSet = comRole.getNewDrPrPermSet();
        if (CollectionUtils.isEmpty((Collection)newDrPrPermSet)) {
            return;
        }
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            DataRuleCache.roleAssignDataRuleProp((String)successId, new ArrayList(newDrPrPermSet), (AssignModEnum)AssignModEnum.ASSIGNMODE_INCREMENT);
        } else {
            ComRoleMigration.setComRoleNewDrPrPermDeprecated(successId, newDrPrPermSet);
        }
    }

    @Deprecated
    private static void setComRoleNewDrPrPermDeprecated(String successId, Set<NewDrPrPerm> newDrPrPermSet) {
        DynamicObject roleDataRulesObj = BusinessDataServiceHelper.loadSingle((String)"perm_roledatarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
        if (roleDataRulesObj == null) {
            roleDataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarules");
            roleDataRulesObj.set("role", (Object)successId);
            PermMigrationHelper.setUnimportantInfo(roleDataRulesObj, false);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        DynamicObject dataRulesObj = roleDataRulesObj.getDynamicObject("datarules");
        if (dataRulesObj == null) {
            dataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarules");
            String roleDataRuleNum = successId + "_" + sdf.format(new Date());
            dataRulesObj.set("number", (Object)roleDataRuleNum);
            dataRulesObj.set("name", (Object)roleDataRuleNum);
            dataRulesObj.set("enable", (Object)"1");
            PermMigrationHelper.setUnimportantInfo(dataRulesObj, true);
        }
        DynamicObjectCollection dataRulesEntryCol = dataRulesObj.getDynamicObjectCollection("entryentity");
        DynamicObjectType dataRulesEntryType = dataRulesEntryCol.getDynamicObjectType();
        for (NewDrPrPerm newDrDrPerm : newDrPrPermSet) {
            String drNum = newDrDrPerm.getDataRuleName();
            DynamicObject drObj = QueryServiceHelper.queryOne((String)"perm_datarule", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)drNum)});
            Long drId = drObj.getLong("id");
            String appNum = newDrDrPerm.getAppNumber();
            String appId = PermMigrationHelper.getAppIdByAppNum(appNum);
            String entityNum = newDrDrPerm.getEntityNumber();
            DynamicObject dataRulesEntry = new DynamicObject(dataRulesEntryType);
            dataRulesEntry.set("bizapp", (Object)appId);
            dataRulesEntry.set("entity", (Object)entityNum);
            DynamicObject dataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarule");
            String dataRuleNum = successId + "_" + sdf.format(new Date());
            dataRuleObj.set("number", (Object)dataRuleNum);
            dataRuleObj.set("name", (Object)dataRuleNum);
            dataRuleObj.set("bizapp", (Object)appId);
            dataRuleObj.set("entity", (Object)entityNum);
            dataRuleObj.set("enable", (Object)"1");
            PermMigrationHelper.setUnimportantInfo(dataRuleObj, true);
            dataRuleObj.set("isdetail", (Object)false);
            DynamicObjectCollection dataRulePropCol = dataRuleObj.getDynamicObjectCollection("entryentity_prop");
            DynamicObjectType dataRulePropType = dataRulePropCol.getDynamicObjectType();
            DynamicObject dataRuleProp = new DynamicObject(dataRulePropType);
            dataRuleProp.set("propkey", (Object)newDrDrPerm.getPropKey());
            dataRuleProp.set("propent", (Object)newDrDrPerm.getPropEntNum());
            dataRuleProp.set("propdatarule", (Object)drId);
            dataRulePropCol.add((Object)dataRuleProp);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRuleObj});
            dataRulesEntry.set("datarule", (Object)dataRuleObj);
            dataRulesEntryCol.add((Object)dataRulesEntry);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRulesObj});
        roleDataRulesObj.set("datarules", (Object)dataRulesObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roleDataRulesObj});
    }

    private static void setComRoleNewDrPerm(ComRole comRole, String successId) {
        Set newDrPermSet = comRole.getNewDrPermSet();
        if (CollectionUtils.isEmpty((Collection)newDrPermSet)) {
            return;
        }
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            DataRuleCache.roleAssignDataRule((String)successId, new ArrayList(newDrPermSet), (AssignModEnum)AssignModEnum.ASSIGNMODE_INCREMENT);
        } else {
            ComRoleMigration.setComRoleDrPermDeprecated(successId, newDrPermSet);
        }
    }

    @Deprecated
    private static void setComRoleDrPermDeprecated(String successId, Set<NewDrPerm> newDrPermSet) {
        DynamicObject roleDataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarules");
        roleDataRulesObj.set("role", (Object)successId);
        PermMigrationHelper.setUnimportantInfo(roleDataRulesObj, false);
        DynamicObject dataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarules");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dataRulesNum = successId + "_" + sdf.format(new Date());
        dataRulesObj.set("number", (Object)dataRulesNum);
        dataRulesObj.set("name", (Object)dataRulesNum);
        dataRulesObj.set("enable", (Object)"1");
        PermMigrationHelper.setUnimportantInfo(dataRulesObj, true);
        DynamicObjectCollection dataRulesEntryCol = dataRulesObj.getDynamicObjectCollection("entryentity");
        DynamicObjectType dataRulesEntryType = dataRulesEntryCol.getDynamicObjectType();
        for (NewDrPerm newDrPerm : newDrPermSet) {
            String drNum = newDrPerm.getDataRuleName();
            DynamicObject drObj = QueryServiceHelper.queryOne((String)"perm_datarule", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)drNum)});
            Long drId = drObj.getLong("id");
            String appNum = newDrPerm.getAppNumber();
            String appId = PermMigrationHelper.getAppIdByAppNum(appNum);
            String entityNum = newDrPerm.getEntityNumber();
            DynamicObject dataRulesEntry = new DynamicObject(dataRulesEntryType);
            dataRulesEntry.set("bizapp", (Object)appId);
            dataRulesEntry.set("entity", (Object)entityNum);
            DynamicObject dataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarule");
            String dataRuleNum = successId + "_" + sdf.format(new Date());
            dataRuleObj.set("number", (Object)dataRuleNum);
            dataRuleObj.set("name", (Object)dataRuleNum);
            dataRuleObj.set("bizapp", (Object)appId);
            dataRuleObj.set("entity", (Object)entityNum);
            dataRuleObj.set("enable", (Object)"1");
            PermMigrationHelper.setUnimportantInfo(dataRuleObj, true);
            dataRuleObj.set("isdetail", (Object)false);
            DynamicObjectCollection dataRuleEntryCol = dataRuleObj.getDynamicObjectCollection("entryentity");
            DynamicObjectType dataRuleEntryType = dataRuleEntryCol.getDynamicObjectType();
            DynamicObject dataRuleEntry = new DynamicObject(dataRuleEntryType);
            DynamicObject permItemObj = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)newDrPerm.getPermItemNumber())});
            dataRuleEntry.set("permitem", permItemObj.get("id"));
            dataRuleEntry.set("datarule", (Object)drId);
            dataRuleEntryCol.add((Object)dataRuleEntry);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRuleObj});
            dataRulesEntry.set("datarule", (Object)dataRuleObj);
            dataRulesEntryCol.add((Object)dataRulesEntry);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRulesObj});
        roleDataRulesObj.set("datarules", (Object)dataRulesObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roleDataRulesObj});
    }

    private static void setComRoleFieldPerm(ComRole comRole, String successId) {
        Set fieldPermSet = comRole.getFieldPermSet();
        if (CollectionUtils.isEmpty((Collection)fieldPermSet)) {
            return;
        }
        DynamicObject roleFieldPerm = BusinessDataServiceHelper.loadSingle((String)"perm_rolefieldperm", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)successId)});
        DynamicObject fieldPermObj = null;
        ArrayList<DynamicObject> fieldSchemeList = new ArrayList<DynamicObject>(fieldPermSet.size());
        boolean fieldPermObjQueryed = false;
        for (FieldPerm fieldPerm : fieldPermSet) {
            String appNum = fieldPerm.getAppNumber();
            String appId = PermMigrationHelper.getAppIdByAppNum(appNum);
            String entityNumber = fieldPerm.getEntityNumber();
            String fieldPermNum = fieldPerm.getFieldPermNumber();
            if (StringUtils.isNotEmpty((String)fieldPermNum)) {
                if (roleFieldPerm == null) {
                    roleFieldPerm = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolefieldperm");
                    roleFieldPerm.set("role", (Object)successId);
                }
                if (!fieldPermObjQueryed) {
                    fieldPermObj = BusinessDataServiceHelper.loadSingle((String)"perm_fieldperm", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)fieldPermNum)});
                    fieldPermObjQueryed = true;
                }
                if (fieldPermObj == null) {
                    fieldPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_fieldperm");
                    fieldPermObj.set("number", (Object)fieldPermNum);
                }
                DynamicObjectCollection fieldRuleCol = fieldPermObj.getDynamicObjectCollection("fieldrule");
                DynamicObjectType entryObjType = fieldRuleCol.getDynamicObjectType();
                DynamicObject entryObj = new DynamicObject(entryObjType);
                entryObj.set("bizapp", (Object)appId);
                entryObj.set("entitytype", (Object)entityNumber);
                entryObj.set("fieldname", (Object)fieldPerm.getFieldName());
                entryObj.set("rowcondition", (Object)fieldPerm.getControlMode());
                fieldRuleCol.add((Object)entryObj);
                continue;
            }
            String fieldSchemeNum = fieldPerm.getFieldName();
            DynamicObject roleFieldScheme = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolefieldscheme");
            roleFieldScheme.set("role", (Object)successId);
            DynamicObject fieldSchemeObj = QueryServiceHelper.queryOne((String)"perm_fieldscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)fieldSchemeNum)});
            roleFieldScheme.set("fps", fieldSchemeObj.get("id"));
            roleFieldScheme.set("app", (Object)appId);
            roleFieldScheme.set("ent", (Object)entityNumber);
            fieldSchemeList.add(roleFieldScheme);
        }
        if (fieldPermObj != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fieldPermObj});
            roleFieldPerm.set("fieldperm", fieldPermObj.get("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roleFieldPerm});
        }
        if (!fieldSchemeList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])fieldSchemeList.toArray(new DynamicObject[0]));
        }
    }
}

