/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.DrLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.DataRuleInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class DataRuleMigration
implements PermMigratedBean {
    @Override
    public String generateJson(Set<Object> exportDataIds) {
        Object[] exportDataIdsArr = exportDataIds.stream().map(k -> Long.parseLong(k + "")).toArray(Object[]::new);
        DynamicObject[] dataRuleObjs = BusinessDataServiceHelper.load((Object[])exportDataIdsArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_datarule"));
        if (dataRuleObjs.length == 0) {
            logger.info("DataRuleMigration.generateJson: dataRuleObjs.length == 0");
            return "";
        }
        ArrayList<DataRuleInfo> dataRuleInfos = new ArrayList<DataRuleInfo>(10);
        for (DynamicObject dataRuleObj : dataRuleObjs) {
            DynamicObject entityObj;
            if (!dataRuleObj.getBoolean("isdetail")) continue;
            DataRuleInfo dataRuleInfo = new DataRuleInfo();
            dataRuleInfo.setDetail(true);
            DynamicObject appObj = dataRuleObj.getDynamicObject("bizapp");
            if (appObj != null) {
                dataRuleInfo.setAppId(appObj.getString("number"));
            }
            if ((entityObj = dataRuleObj.getDynamicObject("entity")) != null) {
                dataRuleInfo.setEntityNum(entityObj.getString("id"));
            }
            dataRuleInfo.setNumber(dataRuleObj.getString("number"));
            dataRuleInfo.setStrName(dataRuleObj.getString("name"));
            dataRuleInfo.setDescription(dataRuleObj.getString("description"));
            dataRuleInfo.setEnable(Boolean.valueOf(dataRuleObj.getString("enable").equals("1")));
            String ruleJson = dataRuleObj.getString("rule");
            if (StringUtils.isNotEmpty((String)ruleJson)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJson, FilterCondition.class);
                dataRuleInfo.setRule(filterCondition);
            }
            dataRuleInfos.add(dataRuleInfo);
        }
        return JSON.toJSONString(dataRuleInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @Override
    public boolean validate(Object data, StringBuilder mes) {
        FilterCondition rule;
        String ruleEntNum;
        String entityNum;
        ArrayList<String> errorList = new ArrayList<String>(10);
        DataRuleInfo dataRuleInfo = (DataRuleInfo)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        if (StringUtils.isEmpty((String)(entityNum = dataRuleInfo.getEntityNum()))) {
            return true;
        }
        String number = dataRuleInfo.getNumber();
        PermMigrationHelper.isEntityNumExist(number, Sets.newHashSet((Object[])new String[]{entityNum}), errorList);
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, sb.toString()));
            return false;
        }
        DynamicObject existRuleObj = QueryServiceHelper.queryOne((String)"perm_datarule", (String)"entity_id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (existRuleObj != null && !entityNum.equals(ruleEntNum = existRuleObj.getString("entity_id"))) {
            errorList.add(ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u65b9\u6848\u4e2d\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0e\u73af\u5883\u5185\u540c\u7f16\u7801\u65b9\u6848\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u4e00\u81f4", (String)"PermDataMigrationValidator_2", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        if ((rule = dataRuleInfo.getRule()) != null) {
            List filterRow = rule.getFilterRow();
            HashSet<String> fieldKeys = new HashSet<String>(10);
            for (SimpleFilterRow row : filterRow) {
                String fieldName = row.getFieldName();
                String firstFieldNum = fieldName.split("\\.")[0];
                fieldKeys.add(firstFieldNum);
            }
            PermMigrationHelper.isFieldNumExist(number, fieldKeys, entityNum, errorList);
        }
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        List dataRuleInfos = JSON.parseArray((String)json, DataRuleInfo.class);
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        for (DataRuleInfo dataRuleInfo : dataRuleInfos) {
            if (!this.validate(dataRuleInfo, mes)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            String number = dataRuleInfo.getNumber();
            DynamicObject dataRuleObj = BusinessDataServiceHelper.loadSingle((String)"perm_datarule", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            Long mainId = 0L;
            if (dataRuleObj == null) {
                dataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarule");
                dataRuleObj.set("number", (Object)number);
            } else {
                mainId = (Long)dataRuleObj.getPkValue();
            }
            String preData = "";
            String localeName = RequestContext.get().getLang().name();
            if (PermCommonUtil.isEnablePermLog()) {
                preData = DrLogHelper.drEventImage((Long)mainId, (String)localeName, (boolean)false, (String)"");
            }
            dataRuleObj.set("isdetail", (Object)true);
            dataRuleObj.set("bizapp", (Object)PermMigrationHelper.getAppIdByAppNum(dataRuleInfo.getAppId()));
            dataRuleObj.set("entity", (Object)dataRuleInfo.getEntityNum());
            dataRuleObj.set("name", (Object)new LocaleString(dataRuleInfo.getStrName()));
            dataRuleObj.set("description", (Object)new LocaleString(dataRuleInfo.getDescription()));
            dataRuleObj.set("enable", (Object)(dataRuleInfo.isEnable() != false ? "1" : "0"));
            dataRuleObj.set("rule", (Object)JSON.toJSONString((Object)dataRuleInfo.getRule()));
            PermMigrationHelper.setUnimportantInfo(dataRuleObj, true);
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRuleObj});
                    ++successCount;
                    if (pkIds.length != 1 || !PermCommonUtil.isEnablePermLog()) continue;
                    PermLogBusiType permLogBusiType = null == mainId || 0L == mainId ? PermLogService.getPermLogBusiType((String)"dr_add_save") : PermLogService.getPermLogBusiType((String)"dr_modify_save");
                    Long successId = (Long)((DynamicObject)pkIds[0]).getPkValue();
                    String afterData = DrLogHelper.drEventImage((Long)successId, (String)localeName, (boolean)true, (String)"");
                    PermMigrationHelper.addPermLog(permLogBusiType, afterData, successId, dataRuleInfo.getNumber(), dataRuleInfo.getStrName(), preData, ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u6570\u636e\u89c4\u5219\u65b9\u6848", (String)"PermDataMigrationNewUtils_2", (String)"bos-mservice-permission", (Object[])new Object[0]), null);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }
}

