/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.FieldPermSchemeLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class FieldSchemeMigration
implements PermMigratedBean {
    @Override
    public String generateJson(Set<Object> exportDataIds) {
        Object[] exportDataIdsArr = exportDataIds.stream().map(k -> Long.parseLong(k + "")).toArray(Object[]::new);
        DynamicObject[] fieldSchemeObjs = BusinessDataServiceHelper.load((Object[])exportDataIdsArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_fieldscheme"));
        if (fieldSchemeObjs.length == 0) {
            logger.info("FieldSchemeMigration.generateJson: fieldSchemeObjs.length == 0");
            return "";
        }
        ArrayList<FieldPermScheme> FieldPermSchemes = new ArrayList<FieldPermScheme>(10);
        for (DynamicObject fieldSchemeObj : fieldSchemeObjs) {
            DynamicObjectCollection fieldPermEntryCol;
            DynamicObject appObj;
            FieldPermScheme fieldPermScheme = new FieldPermScheme();
            fieldPermScheme.setNumber(fieldSchemeObj.getString("number"));
            fieldPermScheme.setName(fieldSchemeObj.getString("name"));
            fieldPermScheme.setFieldFrom(fieldSchemeObj.getString("fieldfrom"));
            fieldPermScheme.setControlFieldType(fieldSchemeObj.getString("controlfieldtype"));
            fieldPermScheme.setControlMode(fieldSchemeObj.getString("controlmode"));
            fieldPermScheme.setEnable(fieldSchemeObj.getString("enable"));
            fieldPermScheme.setDesc(fieldSchemeObj.getString("desc"));
            fieldPermScheme.setSystem(fieldSchemeObj.getString("issystem"));
            boolean sensitive = fieldSchemeObj.getBoolean("sensitive");
            fieldPermScheme.setSensitive(sensitive ? "1" : "0");
            DynamicObject entityObj = fieldSchemeObj.getDynamicObject("ent");
            if (entityObj != null) {
                fieldPermScheme.setEntityNumber(entityObj.getString("id"));
            }
            if ((appObj = fieldSchemeObj.getDynamicObject("app")) != null) {
                fieldPermScheme.setAppNumber(appObj.getString("number"));
            }
            if (!(fieldPermEntryCol = fieldSchemeObj.getDynamicObjectCollection("fieldperm_entry")).isEmpty()) {
                ArrayList<FieldPerm> fieldPermList = new ArrayList<FieldPerm>(fieldPermEntryCol.size());
                for (DynamicObject fieldPermEntry : fieldPermEntryCol) {
                    FieldPerm fieldPerm = new FieldPerm();
                    fieldPerm.setFieldName(fieldPermEntry.getString("fieldperm_fieldnum"));
                    fieldPerm.setControlMode(fieldPermEntry.getString("fieldperm_rowcondition"));
                    fieldPermList.add(fieldPerm);
                }
                fieldPermScheme.setFieldPermList(fieldPermList);
            }
            FieldPermSchemes.add(fieldPermScheme);
        }
        return JSON.toJSONString(FieldPermSchemes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @Override
    public boolean validate(Object data, StringBuilder mes) {
        List fieldPermList;
        String fieldFrom;
        String schemeEntNum;
        ArrayList<String> errorList = new ArrayList<String>(10);
        FieldPermScheme fieldPermScheme = (FieldPermScheme)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String number = fieldPermScheme.getNumber();
        String entityNum = fieldPermScheme.getEntityNumber();
        if (StringUtils.isEmpty((String)entityNum)) {
            return true;
        }
        PermMigrationHelper.isEntityNumExist(number, Sets.newHashSet((Object[])new String[]{entityNum}), errorList);
        DynamicObject existSchemeObj = QueryServiceHelper.queryOne((String)"perm_fieldscheme", (String)"ent_id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (existSchemeObj != null && !entityNum.equals(schemeEntNum = existSchemeObj.getString("ent_id"))) {
            errorList.add(ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u65b9\u6848\u4e2d\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0e\u73af\u5883\u5185\u540c\u7f16\u7801\u65b9\u6848\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u4e00\u81f4", (String)"PermDataMigrationValidator_2", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        if ("2".equals(fieldFrom = fieldPermScheme.getFieldFrom()) && !CollectionUtils.isEmpty((Collection)(fieldPermList = fieldPermScheme.getFieldPermList()))) {
            HashSet<String> fieldKeys = new HashSet<String>(fieldPermList.size());
            for (FieldPerm fieldPerm : fieldPermList) {
                fieldKeys.add(fieldPerm.getFieldName());
            }
            PermMigrationHelper.isFieldNumExist(number, fieldKeys, entityNum, errorList);
        }
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        List fieldPermSchemes = JSON.parseArray((String)json, FieldPermScheme.class);
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        for (FieldPermScheme fieldPermScheme : fieldPermSchemes) {
            if (!this.validate(fieldPermScheme, mes)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            String number = fieldPermScheme.getNumber();
            DynamicObject fieldSchemeObj = BusinessDataServiceHelper.loadSingle((String)"perm_fieldscheme", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            Long mainId = 0L;
            if (fieldSchemeObj == null) {
                fieldSchemeObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_fieldscheme");
                fieldSchemeObj.set("number", (Object)number);
            } else {
                mainId = (Long)fieldSchemeObj.getPkValue();
            }
            String preData = "";
            if (PermCommonUtil.isEnablePermLog()) {
                preData = FieldPermSchemeLogHelper.snapshot((Long)mainId, (boolean)false);
            }
            fieldSchemeObj.set("name", (Object)new LocaleString(fieldPermScheme.getName()));
            fieldSchemeObj.set("fieldfrom", (Object)fieldPermScheme.getFieldFrom());
            fieldSchemeObj.set("controlfieldtype", (Object)fieldPermScheme.getControlFieldType());
            fieldSchemeObj.set("controlmode", (Object)fieldPermScheme.getControlMode());
            fieldSchemeObj.set("enable", (Object)fieldPermScheme.getEnable());
            fieldSchemeObj.set("desc", (Object)new LocaleString(fieldPermScheme.getDesc()));
            fieldSchemeObj.set("issystem", (Object)fieldPermScheme.getSystem());
            fieldSchemeObj.set("sensitive", (Object)fieldPermScheme.getSensitive().equals("1"));
            fieldSchemeObj.set("ent", (Object)fieldPermScheme.getEntityNumber());
            PermMigrationHelper.setUnimportantInfo(fieldSchemeObj, true);
            fieldSchemeObj.set("app", (Object)PermMigrationHelper.getAppIdByAppNum(fieldPermScheme.getAppNumber()));
            DynamicObjectCollection entryCol = fieldSchemeObj.getDynamicObjectCollection("fieldperm_entry");
            entryCol.clear();
            List fieldPermList = fieldPermScheme.getFieldPermList();
            if (!CollectionUtils.isEmpty((Collection)fieldPermList)) {
                DynamicObjectType entryType = entryCol.getDynamicObjectType();
                for (FieldPerm fieldPerm : fieldPermList) {
                    DynamicObject entryObj = new DynamicObject(entryType);
                    entryObj.set("fieldperm_fieldnum", (Object)fieldPerm.getFieldName());
                    entryObj.set("fieldperm_rowcondition", (Object)fieldPerm.getControlMode());
                    entryCol.add((Object)entryObj);
                }
            }
            TXHandle h = TX.required();
            Object object = null;
            try {
                try {
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fieldSchemeObj});
                    ++successCount;
                    if (pkIds.length != 1 || !PermCommonUtil.isEnablePermLog()) continue;
                    PermLogBusiType permLogBusiType = null == mainId || 0L == mainId ? PermLogService.getPermLogBusiType((String)"fps_add_save") : PermLogService.getPermLogBusiType((String)"fps_modify_save");
                    Long successPkId = (Long)((DynamicObject)pkIds[0]).getPkValue();
                    String afterData = FieldPermSchemeLogHelper.snapshot((Long)successPkId, (boolean)true);
                    PermMigrationHelper.addPermLog(permLogBusiType, afterData, successPkId, fieldPermScheme.getNumber(), fieldPermScheme.getName(), preData, ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u5b57\u6bb5\u6743\u9650\u65b9\u6848", (String)"PermDataMigrationNewUtils_1", (String)"bos-mservice-permission", (Object[])new Object[0]), null);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), number, e.getMessage());
                    logger.info(errorMes);
                    mes.append(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h == null) continue;
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                h.close();
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }
}

