/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogCommonRole;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.userbusirole.UserBusiRole;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserBizRoleMigration
implements PermMigratedBean {
    @Override
    public String generateJson(Set<Object> exportDataIds) {
        DynamicObjectCollection userBizRoleObjCol = QueryServiceHelper.query((String)"perm_userbizrole", (String)"user.number,bizrole.number,starttime,endtime", (QFilter[])new QFilter[]{new QFilter("id", "in", exportDataIds.stream().map(k -> Long.parseLong(k + "")).collect(Collectors.toList()))});
        if (userBizRoleObjCol.size() == 0) {
            logger.info("UserBizRoleMigration.generateJson: userBizRoleObjCol.size() == 0");
            return "";
        }
        ArrayList<UserBusiRole> userBizRoleDims = new ArrayList<UserBusiRole>(10);
        for (DynamicObject userBizRoleObj : userBizRoleObjCol) {
            UserBusiRole userBizRoleDim = new UserBusiRole();
            userBizRoleDim.setUserNumber(userBizRoleObj.getString("user.number"));
            userBizRoleDim.setBusiRoleNumber(userBizRoleObj.getString("bizrole.number"));
            userBizRoleDim.setStartTime(userBizRoleObj.getDate("starttime"));
            userBizRoleDim.setEndTime(userBizRoleObj.getDate("endtime"));
            userBizRoleDims.add(userBizRoleDim);
        }
        return JSON.toJSONString(userBizRoleDims, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @Override
    public boolean validate(Object data, StringBuilder mes) {
        ArrayList<String> errorList = new ArrayList<String>(10);
        UserBusiRole userBusiRole = (UserBusiRole)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String busiRoleNumber = userBusiRole.getBusiRoleNumber();
        String userNumber = userBusiRole.getUserNumber();
        if (!QueryServiceHelper.exists((String)"perm_busirole", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)busiRoleNumber)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u4e1a\u52a1\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_15", (String)"bos-mservice-permission", (Object[])new Object[0]), busiRoleNumber));
        }
        if (!QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userNumber)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a \u201c%1$s\u201d \u7684\u7528\u6237\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
        }
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"[\u4e1a\u52a1\u89d2\u8272\u7f16\u7801 \u201c%1$s\u201d ,\u7528\u6237\u7f16\u7801 \u201c%2$s\u201d ]\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%3$s\u3002\r\n", (String)"PermDataMigrationValidator_16", (String)"bos-mservice-permission", (Object[])new Object[0]), busiRoleNumber, userNumber, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        List userBusiRoles = JSON.parseArray((String)json, UserBusiRole.class);
        HashMap<Long, String> busiRoleIdNameMap = new HashMap<Long, String>(10);
        HashMap<Long, Set> busiRoleIdPreDataMap = new HashMap<Long, Set>(10);
        String langStr = RequestContext.get().getLang().name();
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        for (UserBusiRole userBusiRole : userBusiRoles) {
            if (!this.validate(userBusiRole, mes)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            HashSet<Long> changedUserIdSet = new HashSet<Long>(1);
            String busiRoleNumber = userBusiRole.getBusiRoleNumber();
            DynamicObject busiRoleObj = QueryServiceHelper.queryOne((String)"perm_busirole", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)busiRoleNumber)});
            Long busiRoleId = busiRoleObj.getLong("id");
            busiRoleIdNameMap.putIfAbsent(busiRoleId, busiRoleObj.getString("name"));
            String userNumber = userBusiRole.getUserNumber();
            Long userId = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userNumber)}).getLong("id");
            changedUserIdSet.add(userId);
            DynamicObject userBusiRoleObj = BusinessDataServiceHelper.loadSingle((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter("bizrole", "=", (Object)busiRoleId).and("user", "=", (Object)userId)});
            if (userBusiRoleObj == null) {
                userBusiRoleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userbizrole");
                userBusiRoleObj.set("bizrole", (Object)busiRoleId);
                userBusiRoleObj.set("user", (Object)userId);
            }
            if (PermCommonUtil.isEnablePermLog()) {
                busiRoleIdPreDataMap.putIfAbsent(busiRoleId, PermBusiRoleHelper.getBizRoleUserSet((Long)busiRoleId));
            }
            userBusiRoleObj.set("starttime", (Object)userBusiRole.getStartTime());
            userBusiRoleObj.set("endtime", (Object)userBusiRole.getEndTime());
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userBusiRoleObj});
                    ++successCount;
                    if (pkIds.length != 1 || !kd.bos.util.CollectionUtils.isNotEmpty(changedUserIdSet)) continue;
                    ArrayList userIds = new ArrayList(changedUserIdSet);
                    FormConfigFactory.cancelShowFormRights(userIds);
                    List commonRoleList = PermBusiRoleLogHelper.getCommonRoleList((Long)busiRoleId, (String)langStr);
                    if (CollectionUtils.isEmpty((Collection)commonRoleList)) continue;
                    HashSet newDRAppEntityAllSet = new HashSet(1);
                    List collect = commonRoleList.stream().filter(LogCommonRole2 -> "1".equals(LogCommonRole2.getEnable())).collect(Collectors.toList());
                    for (LogCommonRole logCommonRole : collect) {
                        LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)logCommonRole.getRoleId(), (String)langStr);
                        Set newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                    if (!CollectionUtils.isEmpty(newDRAppEntityAllSet)) {
                        List newDRAppEntityList = newDRAppEntityAllSet.stream().map(x -> {
                            String[] split = x.split("\\|", 2);
                            HashMap<String, String> map = new HashMap<String, String>(2);
                            map.put(split[0], split[1]);
                            return map;
                        }).collect(Collectors.toList());
                        FormConfigFactory.cancelShowFormDataRights(userIds, newDRAppEntityList);
                    }
                    UserHasPermOrgCache.clearUserLoginOrgs(changedUserIdSet);
                    Map appEntity = PermCommonUtil.getAppEntityByBizRole((Long)busiRoleId);
                    LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(changedUserIdSet), (Map)appEntity);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"[\u4e1a\u52a1\u89d2\u8272\u7f16\u7801 \u201c%1$s\u201d ,\u7528\u6237\u7f16\u7801 \u201c%2$s\u201d ]\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%3$s\u3002\r\n", (String)"PermDataMigrationValidator_16", (String)"bos-mservice-permission", (Object[])new Object[0]), busiRoleNumber, userNumber, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        if (PermCommonUtil.isEnablePermLog()) {
            for (Map.Entry entry : busiRoleIdPreDataMap.entrySet()) {
                Long busiRoleId = (Long)entry.getKey();
                PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"busi_role_assignuser");
                Set after = PermBusiRoleHelper.getBizRoleUserSet((Long)busiRoleId);
                LinkedList preList = new LinkedList((Collection)entry.getValue());
                LinkedList afterList = new LinkedList(after);
                List delList = ListUtil.removeAll(preList, afterList);
                List addList = ListUtil.removeAll(afterList, preList);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)delList) && kd.bos.util.CollectionUtils.isEmpty((Collection)addList)) continue;
                HashMap<String, Object> logMap = new HashMap<String, Object>(2);
                logMap.put("del", delList);
                logMap.put("add", addList);
                logMap.put("langStr", langStr);
                try {
                    PermMigrationHelper.addPermLog(permLogBusiType, null, null, null, (String)busiRoleIdNameMap.get(busiRoleId), null, ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u4e1a\u52a1\u89d2\u8272\u4e0e\u7528\u6237\u5173\u7cfb", (String)"PermDataMigrationNewUtils_9", (String)"bos-mservice-permission", (Object[])new Object[0]), StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)));
                }
                catch (JsonProcessingException e) {
                    logger.info("PermDataMigrationNewUtils.importUserBizRolesJson.addPermLog: " + e.getMessage());
                }
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }
}

