/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.DimNewDrPerm;
import kd.bos.permission.model.perm.DimNewDrPrPerm;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.UserDimFieldPerm;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserDirectPermAfterSaveReq;
import kd.bos.permission.model.perm.user.UserDrDim;
import kd.bos.permission.model.perm.user.UserDrPrDim;
import kd.bos.permission.model.perm.user.UserFieldPermDim;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.model.perm.usrgrpuser.UsrGrpUser;
import kd.bos.permission.service.UserDirectPermService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserPermMigration
implements PermMigratedBean {
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UserPermMigration_CachedThreadPool", (int)7);

    @Override
    public String generateJson(Set<Object> exportDataIds) {
        List<Long> userIds = exportDataIds.stream().map(k -> Long.parseLong(k + "")).collect(Collectors.toList());
        Map dimTypeEntMap = IsoDimHelper.permCtrlTypeMap();
        Map dimEntTypeMap = IsoDimHelper.permCtrlTypeBigMap();
        StringBuilder userIdStr = new StringBuilder("(");
        for (Long userId : userIds) {
            userIdStr.append(userId).append(',');
        }
        userIdStr.deleteCharAt(userIdStr.length() - 1);
        userIdStr.append(')');
        Throwable throwable = null;
        try (DataSet bizAppDs = DB.queryDataSet((String)"UserPermMigration.queryApp", (DBRoute)DBRoute.meta, (String)"select fid,fnumber appnum from t_meta_bizapp");){
            Future<Map<String, List<Object>>> funcPermFuture = UserPermMigration.queryUserDirectFuncPerm(userIds, dimTypeEntMap);
            Future<Map<String, List<Object>>> fieldSchemeFuture = UserPermMigration.queryUserFieldScheme(userIdStr, bizAppDs.copy(), dimEntTypeMap);
            Future<Map<String, List<Object>>> fpdFuture = UserPermMigration.queryUserFieldPermDetail(userIdStr, bizAppDs.copy(), dimTypeEntMap);
            Future<Map<String, List<Object>>> drFuture = UserPermMigration.queryUserDrPerm(userIds, dimEntTypeMap);
            Future<Map<String, List<Object>>> drPrFuture = UserPermMigration.queryUserDrPrPerm(userIdStr, bizAppDs.copy(), dimEntTypeMap);
            Future<Map<String, List<Object>>> disPermFuture = UserPermMigration.queryUserDisFuncPerm(userIds, dimEntTypeMap);
            Future<Map<String, List<Object>>> usrGrpFuture = UserPermMigration.queryUserUsrGrpInfo(userIds);
            try {
                HashMap<String, Map<String, List<Object>>> result = new HashMap<String, Map<String, List<Object>>>(10);
                UserPermMigration.combineData("funcperm", funcPermFuture, result);
                UserPermMigration.combineData("fieldscheme", fieldSchemeFuture, result);
                UserPermMigration.combineData("fieldperm", fpdFuture, result);
                UserPermMigration.combineData("dr", drFuture, result);
                UserPermMigration.combineData("drpr", drPrFuture, result);
                UserPermMigration.combineData("disperm", disPermFuture, result);
                UserPermMigration.combineData("usrgrpinfo", usrGrpFuture, result);
                String string = JSON.toJSONString(result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
                return string;
            }
            catch (Exception e) {
                try {
                    String errorMes = e.getMessage();
                    logger.info(errorMes);
                    throw new KDBizException(errorMes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static void combineData(String mapKey, Future<Map<String, List<Object>>> funcPermFuture, Map<String, Map<String, List<Object>>> result) throws InterruptedException, ExecutionException {
        Map<String, List<Object>> funcPermMap = funcPermFuture.get();
        for (Map.Entry<String, List<Object>> entry : funcPermMap.entrySet()) {
            result.computeIfAbsent(entry.getKey(), k -> new HashMap(10)).computeIfAbsent(mapKey, s -> new ArrayList(10)).add(entry.getValue());
        }
    }

    private static Future<Map<String, List<Object>>> queryUserUsrGrpInfo(List<Long> userIds) {
        Callable<Map> callable = () -> {
            DynamicObject[] userUsrGrpArr;
            HashMap<String, List> result = new HashMap<String, List>(10);
            for (DynamicObject userUsrGrpObj : userUsrGrpArr = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"usergroup,user,from_type", (QFilter[])new QFilter[]{new QFilter("user", "in", (Object)userIds)})) {
                DynamicObject usrGrp = userUsrGrpObj.getDynamicObject("usergroup");
                if (usrGrp == null) continue;
                Long usrGrpId = usrGrp.getLong("id");
                usrGrp = BusinessDataServiceHelper.loadSingle((Object)usrGrpId, (String)"bos_usergroup");
                String userGrpDesc = usrGrp.getString("description");
                DynamicObject usrGrpStd = usrGrp.getDynamicObject("usrgrpstd");
                String usrGrpStdNum = "DEFAULT";
                String usrGrpStdName = " ";
                String usrGrpStdDesc = " ";
                if (usrGrpStd != null) {
                    usrGrpStdNum = usrGrpStd.getString("number");
                    usrGrpStdName = usrGrpStd.getString("name");
                    Long usrGrpStdId = usrGrpStd.getLong("id");
                    usrGrpStd = BusinessDataServiceHelper.loadSingle((Object)usrGrpStdId, (String)"perm_usergroupstandard");
                    usrGrpStdDesc = usrGrpStd.getString("description");
                }
                String fromType = userUsrGrpObj.getString("from_type");
                DynamicObject user = userUsrGrpObj.getDynamicObject("user");
                if (user == null) continue;
                UsrGrpUser usrGrpUser = new UsrGrpUser();
                usrGrpUser.setFromType(fromType);
                usrGrpUser.setUserGroupNum(usrGrp.getString("number"));
                usrGrpUser.setUserGroupName(usrGrp.getString("name"));
                usrGrpUser.setUserGroupDesc(userGrpDesc);
                usrGrpUser.setUsrGrpStdNum(usrGrpStdNum);
                usrGrpUser.setUsrGrpStdName(usrGrpStdName);
                usrGrpUser.setUsrGrpStdDesc(usrGrpStdDesc);
                result.computeIfAbsent(user.getString("number"), k -> new ArrayList(10)).add(usrGrpUser);
            }
            return result;
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserDisFuncPerm(List<Long> userIds, Map<String, String> dimEntTypeMap) {
        Callable<Map> callable = () -> {
            DynamicObject[] userDisPermArr;
            HashMap<String, List> result = new HashMap<String, List>(10);
            for (DynamicObject userDisPermObj : userDisPermArr = BusinessDataServiceHelper.load((String)"perm_disfunperm_multype", (String)"entitytype,permitem,user.number,bizapp,dimtype,includesuborg,dimtypeid", (QFilter[])new QFilter[]{new QFilter("user", "in", (Object)userIds)})) {
                DynamicObject permItemObj;
                DynamicObject entObj;
                DynamicObject appObj;
                long dimId;
                String userNum = userDisPermObj.getString("user.number");
                if (StringUtils.isEmpty((String)userNum)) continue;
                boolean includeSub = userDisPermObj.getBoolean("includesuborg");
                String dimEntNum = userDisPermObj.getString("dimtype");
                DynamicObject dimObj = QueryServiceHelper.queryOne((String)dimEntNum, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(dimId = userDisPermObj.getLong("dimtypeid")))});
                if (dimObj == null || (appObj = userDisPermObj.getDynamicObject("bizapp")) == null || (entObj = userDisPermObj.getDynamicObject("entitytype")) == null || (permItemObj = userDisPermObj.getDynamicObject("permitem")) == null) continue;
                UserFuncDim userDisFuncDim = new UserFuncDim();
                userDisFuncDim.setIncludeSub(Boolean.valueOf(includeSub));
                userDisFuncDim.setDimType((String)dimEntTypeMap.get(dimEntNum));
                userDisFuncDim.setDimNumber(dimObj.getString("number"));
                userDisFuncDim.setAppNumber(appObj.getString("number"));
                userDisFuncDim.setEntityNumber(entObj.getString("number"));
                userDisFuncDim.setPermItemNumber(permItemObj.getString("number"));
                result.computeIfAbsent(userNum, k -> new ArrayList(10)).add(userDisFuncDim);
            }
            return result;
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserDrPrPerm(StringBuilder userIdStr, DataSet bizAppDs, Map<String, String> dimEntTypeMap) {
        Callable<Map> callable = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserDrPerm(List<Long> userIds, Map<String, String> dimEntTypeMap) {
        Callable<Map> callable = () -> {
            DynamicObject[] userDrArr;
            HashMap<String, List> result = new HashMap<String, List>(10);
            for (DynamicObject userDr : userDrArr = BusinessDataServiceHelper.load((String)"perm_userdatarule", (String)"user,app,entity,permitem,datarule,dimobj,dimtype,isincludesub", (QFilter[])new QFilter[]{new QFilter("user", "in", (Object)userIds)})) {
                DynamicObject dimObj;
                DynamicObject drObj;
                DynamicObject permItemObj;
                DynamicObject entityObj;
                DynamicObject appObj;
                String userNum;
                DynamicObject userObj = userDr.getDynamicObject("user");
                if (userObj == null || StringUtils.isEmpty((String)(userNum = userObj.getString("number"))) || (appObj = userDr.getDynamicObject("app")) == null || (entityObj = userDr.getDynamicObject("entity")) == null || (permItemObj = userDr.getDynamicObject("permItem")) == null || (drObj = userDr.getDynamicObject("datarule")) == null || (dimObj = userDr.getDynamicObject("dimobj")) == null) continue;
                boolean isIncludeSub = userDr.getBoolean("isincludesub");
                String dimEntNum = userDr.getString("dimtype");
                String dimTypeNum = (String)dimEntTypeMap.get(dimEntNum);
                if (!StringUtils.isNotEmpty((String)dimTypeNum)) continue;
                DimNewDrPerm dimNewDrPerm = new DimNewDrPerm();
                dimNewDrPerm.setAppNumber(appObj.getString("number"));
                dimNewDrPerm.setEntityNumber(entityObj.getString("number"));
                dimNewDrPerm.setPermItemNumber(permItemObj.getString("number"));
                dimNewDrPerm.setDataRuleName(drObj.getString("number"));
                dimNewDrPerm.setIncludesuborg(isIncludeSub ? "1" : "0");
                dimNewDrPerm.setDimType(dimTypeNum);
                dimNewDrPerm.setDimNumber(dimObj.getString("number"));
                result.computeIfAbsent(userNum, k -> new ArrayList(10)).add(dimNewDrPerm);
            }
            return result;
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserFieldPermDetail(StringBuilder userIdStr, DataSet bizAppDs, Map<String, String> dimTypeEntMap) {
        Callable<Map> callable = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserFieldScheme(StringBuilder userIdStr, DataSet bizAppDs, Map<String, String> dimEntTypeMap) {
        Callable<Map> callable = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        return pool.submit(callable);
    }

    private static Future<Map<String, List<Object>>> queryUserDirectFuncPerm(List<Long> userIds, Map<String, String> dimTypeEntMap) {
        Callable<Map> callable = () -> {
            DynamicObject[] userPermArr;
            HashMap<String, List> result = new HashMap<String, List>(10);
            for (DynamicObject userPermObj : userPermArr = BusinessDataServiceHelper.load((String)"perm_userperm_multype", (String)"user.number,includesuborg,dimtype,dimtypeid,entryentity,bizapp,entitytype,permitem", (QFilter[])new QFilter[]{new QFilter("user", "in", (Object)userIds)})) {
                DynamicObject dimObj;
                ArrayList<UserFuncDim> userFuncDims = new ArrayList<UserFuncDim>(10);
                String userNum = userPermObj.getString("user.number");
                if (StringUtils.isEmpty((String)userNum)) continue;
                boolean includeSub = userPermObj.getBoolean("includesuborg");
                String dimTypeNum = userPermObj.getString("dimtype");
                long dimId = userPermObj.getLong("dimtypeid");
                String dimEntNum = (String)dimTypeEntMap.get(dimTypeNum);
                if (StringUtils.isEmpty((String)dimEntNum) || (dimObj = QueryServiceHelper.queryOne((String)dimEntNum, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimId)})) == null) continue;
                String dimNum = dimObj.getString("number");
                DynamicObjectCollection userPermDetailCol = userPermObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject userPermDetail : userPermDetailCol) {
                    DynamicObject permItemObj;
                    DynamicObject entObj;
                    DynamicObject appObj = userPermDetail.getDynamicObject("bizapp");
                    if (appObj == null || (entObj = userPermDetail.getDynamicObject("entitytype")) == null || (permItemObj = userPermDetail.getDynamicObject("permitem")) == null) continue;
                    UserFuncDim userFuncDim = new UserFuncDim();
                    userFuncDim.setIncludeSub(Boolean.valueOf(includeSub));
                    userFuncDim.setDimType(dimTypeNum);
                    userFuncDim.setDimNumber(dimNum);
                    userFuncDim.setAppNumber(appObj.getString("number"));
                    userFuncDim.setEntityNumber(entObj.getString("number"));
                    userFuncDim.setPermItemNumber(permItemObj.getString("number"));
                    userFuncDims.add(userFuncDim);
                }
                result.computeIfAbsent(userNum, k -> new ArrayList(10)).addAll(userFuncDims);
            }
            return result;
        };
        return pool.submit(callable);
    }

    @Override
    public boolean validate(Object data, StringBuilder mes) {
        List dataPropRules;
        List fieldPerms;
        String dimTypeNum;
        List fieldSchemes;
        List disPerms;
        ArrayList<String> errorList = new ArrayList<String>(10);
        Map.Entry entry = (Map.Entry)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String userNum = (String)entry.getKey();
        if (!QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userNum)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a \u201c%1$s\u201d \u7684\u7528\u6237\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNum));
        }
        Map permDataMap = (Map)entry.getValue();
        Map dimTypeEntMap = IsoDimHelper.permCtrlTypeMap();
        HashSet<String> appNums = new HashSet<String>(10);
        HashSet<String> entNums = new HashSet<String>(10);
        HashSet<String> permItemNums = new HashSet<String>(10);
        List funcPerms = (List)permDataMap.get("funcperm");
        if (CollectionUtils.isNotEmpty((Collection)funcPerms)) {
            for (Object funcPerm : funcPerms) {
                UserFuncDim userFuncDim = (UserFuncDim)funcPerm;
                String dimTypeNum2 = userFuncDim.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum2, (String)dimTypeEntMap.get(dimTypeNum2), userFuncDim.getDimNumber(), userNum, errorList)) continue;
                appNums.add(userFuncDim.getAppNumber());
                entNums.add(userFuncDim.getEntityNumber());
                permItemNums.add(userFuncDim.getPermItemNumber());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(disPerms = (List)permDataMap.get("disperm")))) {
            for (Object disPerm : disPerms) {
                UserFuncDim userDisPerm = (UserFuncDim)disPerm;
                String dimTypeNum3 = userDisPerm.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum3, (String)dimTypeEntMap.get(dimTypeNum3), userDisPerm.getDimNumber(), userNum, errorList)) continue;
                appNums.add(userDisPerm.getAppNumber());
                entNums.add(userDisPerm.getEntityNumber());
                permItemNums.add(userDisPerm.getPermItemNumber());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldSchemes = (List)permDataMap.get("fieldscheme")))) {
            HashMap<String, String> fieldSchemeNumEntNumMap = new HashMap<String, String>(10);
            for (Object fieldScheme : fieldSchemes) {
                UserFieldPermScheme userFieldPermScheme = (UserFieldPermScheme)fieldScheme;
                dimTypeNum = userFieldPermScheme.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum, (String)dimTypeEntMap.get(dimTypeNum), userFieldPermScheme.getDimNumber(), userNum, errorList)) continue;
                String entityNum = userFieldPermScheme.getEntityNumber();
                fieldSchemeNumEntNumMap.put(userFieldPermScheme.getNumber(), entityNum);
                appNums.add(userFieldPermScheme.getAppNumber());
                entNums.add(entityNum);
            }
            PermMigrationHelper.isFieldSchemeNumEntNumExist(userNum, fieldSchemeNumEntNumMap, errorList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldPerms = (List)permDataMap.get("fieldperm")))) {
            for (Object fieldPerm : fieldPerms) {
                UserDimFieldPerm userFieldPermDetail = (UserDimFieldPerm)fieldPerm;
                dimTypeNum = userFieldPermDetail.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum, (String)dimTypeEntMap.get(dimTypeNum), userFieldPermDetail.getDimNumber(), userNum, errorList)) continue;
                appNums.add(userFieldPermDetail.getAppNumber());
                entNums.add(userFieldPermDetail.getEntityNumber());
            }
        }
        HashMap<String, String> newDrPermNumEntNumMap = new HashMap<String, String>(10);
        List dataRules = (List)permDataMap.get("dr");
        if (CollectionUtils.isNotEmpty((Collection)dataRules)) {
            for (Object dataRule : dataRules) {
                DimNewDrPerm dimNewDrPerm = (DimNewDrPerm)dataRule;
                String dimTypeNum4 = dimNewDrPerm.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum4, (String)dimTypeEntMap.get(dimTypeNum4), dimNewDrPerm.getDimNumber(), userNum, errorList)) continue;
                String entityNum = dimNewDrPerm.getEntityNumber();
                newDrPermNumEntNumMap.put(dimNewDrPerm.getDataRuleName(), entityNum);
                appNums.add(dimNewDrPerm.getAppNumber());
                entNums.add(entityNum);
                permItemNums.add(dimNewDrPerm.getPermItemNumber());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(dataPropRules = (List)permDataMap.get("drpr")))) {
            for (Object dataPropRule : dataPropRules) {
                DimNewDrPrPerm dimNewDrPrPerm = (DimNewDrPrPerm)dataPropRule;
                String dimTypeNum5 = dimNewDrPrPerm.getDimType();
                if (!UserPermMigration.validateDimInfo(dimTypeNum5, (String)dimTypeEntMap.get(dimTypeNum5), dimNewDrPrPerm.getDimNumber(), userNum, errorList)) continue;
                String entityNum = dimNewDrPrPerm.getEntityNumber();
                newDrPermNumEntNumMap.put(dimNewDrPrPerm.getDataRuleName(), dimNewDrPrPerm.getPropEntNum());
                appNums.add(dimNewDrPrPerm.getAppNumber());
                entNums.add(entityNum);
            }
        }
        PermMigrationHelper.isAppNumExist(userNum, appNums, errorList);
        PermMigrationHelper.isEntityNumExist(userNum, entNums, errorList);
        PermMigrationHelper.isPermItemNumExist(userNum, permItemNums, errorList);
        PermMigrationHelper.isNewDrNumEntNumExist(userNum, newDrPermNumEntNumMap, errorList);
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), userNum, sb.toString()));
            return false;
        }
        return true;
    }

    private static boolean validateDimInfo(String dimTypeNum, String dimEntNum, String dimNum, String userNum, List<String> errorList) {
        if (StringUtils.isEmpty((String)dimEntNum)) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_5", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNum));
        }
        PermMigrationHelper.isDimNumExist(userNum, dimEntNum, Sets.newHashSet((Object[])new String[]{dimNum}), errorList);
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        Map userPerm = (Map)JSON.parse((String)json);
        Map dimTypeEntMap = IsoDimHelper.permCtrlTypeMap();
        Map appNumIdMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)"select fnumber,fid from t_meta_bizapp", resultSet -> {
            HashMap<String, String> result = new HashMap<String, String>(10);
            while (resultSet.next()) {
                result.put(resultSet.getString("fnumber"), resultSet.getString("fid"));
            }
            return result;
        });
        Map permItemNumIdMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)"select fnumber,fid from t_perm_permitem", resultSet -> {
            HashMap<String, String> result = new HashMap<String, String>(10);
            while (resultSet.next()) {
                result.put(resultSet.getString("fnumber"), resultSet.getString("fid"));
            }
            return result;
        });
        Set userNums = userPerm.keySet();
        DynamicObject[] userObjArr = BusinessDataServiceHelper.load((String)"bos_user", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("number", "in", userNums)});
        HashMap<String, Long> userNumIdMap = new HashMap<String, Long>(10);
        for (DynamicObject userObj : userObjArr) {
            userNumIdMap.put(userObj.getString("number"), userObj.getLong("id"));
        }
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        if (userNumIdMap.isEmpty()) {
            return importResult;
        }
        HashMap<Long, Map> appEntityMap = new HashMap<Long, Map>(10);
        UserFuncDim addUserUFD = null;
        HashMap<Long, Set> addUserUFDMap = new HashMap<Long, Set>(8);
        UserFuncDim addUserDisUFD = null;
        HashMap<Long, Set> addUserDisUFDMap = new HashMap<Long, Set>(8);
        UserFieldPermDim addUFPD = null;
        HashMap<Long, Set> addUFPDMap = new HashMap<Long, Set>(8);
        UserFieldPermScheme addUFPS = null;
        HashMap<Long, Set> addUFPSMap = new HashMap<Long, Set>(8);
        UserDrDim addUDR = null;
        HashMap<Long, Set> addUDRMap = new HashMap<Long, Set>(8);
        UserDrPrDim addUDRPR = null;
        HashMap<Long, Set> addUDRPRMap = new HashMap<Long, Set>(8);
        UsrGrpUser addUGU = null;
        HashMap<Long, Set> addUGUMap = new HashMap<Long, Set>(8);
        long currUserId = RequestContext.get().getCurrUserId();
        Date curTime = new Date();
        String busiFrom = ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u7528\u6237\u6743\u9650", (String)"PermDataMigrationNewUtils_10", (String)"bos-mservice-permission", (Object[])new Object[0]);
        for (Map.Entry entry : userPerm.entrySet()) {
            if (!this.validate(entry, mes)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            String userNum = (String)entry.getKey();
            Long userId = (Long)userNumIdMap.get(userNum);
            Map permDataMap = (Map)entry.getValue();
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    List dataPropRules;
                    List dataRules;
                    List fieldPerms;
                    List fieldSchemes;
                    DynamicObject dimObj;
                    Long dimId;
                    String dimEntNum;
                    String dimTypeNum;
                    Object disPerm2;
                    List disPerms;
                    List funcPerms = (List)permDataMap.get("funcperm");
                    if (CollectionUtils.isNotEmpty((Collection)funcPerms)) {
                        for (Object funcPerm : funcPerms) {
                            DynamicObject dimObj2;
                            Long dimId2;
                            UserFuncDim userFuncDim = (UserFuncDim)funcPerm;
                            Boolean includeSub = userFuncDim.getIncludeSub();
                            String appId = (String)appNumIdMap.get(userFuncDim.getAppNumber());
                            String entityNum = userFuncDim.getEntityNumber();
                            String permItemId = (String)permItemNumIdMap.get(userFuncDim.getPermItemNumber());
                            String dimTypeNum2 = userFuncDim.getDimType();
                            String dimEntNum2 = (String)dimTypeEntMap.get(dimTypeNum2);
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_userpermdetail where fuserid = ? and fdimtype = ? and fdimid = ? and fisincludesub = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ", (Object[])new Object[]{userId, dimEntNum2, dimId2 = Long.valueOf((dimObj2 = QueryServiceHelper.queryOne((String)dimEntNum2, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userFuncDim.getDimNumber())})).getLong("id")), includeSub, appId, entityNum, permItemId}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            appEntityMap.computeIfAbsent(userId, k -> new HashMap(8)).computeIfAbsent(appId, k -> new HashSet(8)).add(entityNum);
                            DynamicObject userPermObj = BusinessDataServiceHelper.loadSingle((String)"perm_userperm_multype", (String)"user,includesuborg,dimtype,dimtypeid,entryentity,bizapp,entitytype,permitem", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId).and("includesuborg", "=", (Object)includeSub).and("dimtype", "=", (Object)dimTypeNum2).and("dimtypeid", "=", (Object)dimId2)});
                            if (userPermObj == null) {
                                userPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userperm_multype");
                                userPermObj.set("user", (Object)userId);
                                userPermObj.set("includesuborg", (Object)includeSub);
                                userPermObj.set("dimtype", (Object)dimTypeNum2);
                                userPermObj.set("dimtypeid", (Object)dimId2);
                            }
                            DynamicObjectCollection userPermDetailCol = userPermObj.getDynamicObjectCollection("entryentity");
                            DynamicObjectType entryType = userPermDetailCol.getDynamicObjectType();
                            DynamicObject entryObj = new DynamicObject(entryType);
                            entryObj.set("bizapp", (Object)appId);
                            entryObj.set("entitytype", (Object)entityNum);
                            entryObj.set("permitem", (Object)permItemId);
                            userPermDetailCol.add((Object)entryObj);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userPermObj});
                            addUserUFD = new UserFuncDim(userId, appId, entityNum, permItemId, dimTypeNum2, dimId2, includeSub, busiFrom);
                            addUserUFDMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUserUFD);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(disPerms = (List)permDataMap.get("disperm")))) {
                        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
                        for (Object disPerm2 : disPerms) {
                            UserFuncDim userDisPerm = (UserFuncDim)disPerm2;
                            Boolean includeSub = userDisPerm.getIncludeSub();
                            String appId = (String)appNumIdMap.get(userDisPerm.getAppNumber());
                            String entityNum = userDisPerm.getEntityNumber();
                            String permItemId = (String)permItemNumIdMap.get(userDisPerm.getPermItemNumber());
                            dimTypeNum = userDisPerm.getDimType();
                            dimEntNum = (String)dimTypeEntMap.get(dimTypeNum);
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_disfunperm where fuserid = ? and fdimtype = ? and forgid = ? and fisincludesuborg = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ", (Object[])new Object[]{userId, dimEntNum, dimId = Long.valueOf((dimObj = QueryServiceHelper.queryOne((String)dimEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userDisPerm.getDimNumber())})).getLong("id")), includeSub, appId, entityNum, permItemId}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            DynamicObject userDisPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_disfunperm_multype");
                            userDisPermObj.set("user", (Object)userId);
                            userDisPermObj.set("includesuborg", (Object)includeSub);
                            userDisPermObj.set("dimtype", (Object)dimEntNum);
                            userDisPermObj.set("dimtypeid", (Object)dimId);
                            userDisPermObj.set("bizapp", (Object)appId);
                            userDisPermObj.set("entitytype", (Object)entityNum);
                            userDisPermObj.set("permitem", (Object)permItemId);
                            saveList.add(userDisPermObj);
                            addUserDisUFD = new UserFuncDim(userId, appId, entityNum, permItemId, dimTypeNum, dimId, includeSub, busiFrom);
                            addUserDisUFDMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUserDisUFD);
                        }
                        if (!saveList.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(fieldSchemes = (List)permDataMap.get("fieldscheme")))) {
                        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
                        disPerm2 = fieldSchemes.iterator();
                        while (disPerm2.hasNext()) {
                            DynamicObject fpsObj;
                            Long fpsId;
                            String includeSub;
                            Object fieldScheme = disPerm2.next();
                            UserFieldPermScheme userFieldPermScheme = (UserFieldPermScheme)fieldScheme;
                            String fieldSchemeNum = userFieldPermScheme.getNumber();
                            String appId = (String)appNumIdMap.get(userFieldPermScheme.getAppNumber());
                            String entityNum = userFieldPermScheme.getEntityNumber();
                            dimTypeNum = userFieldPermScheme.getDimType();
                            dimEntNum = (String)dimTypeEntMap.get(dimTypeNum);
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_userfieldscheme where fuserid = ? and fdimtype = ? and fdimid = ? and fincludesub = ? and fappid = ? and fentnum = ? and ffieldpermschemeid = ? ", (Object[])new Object[]{userId, dimEntNum, dimId = Long.valueOf((dimObj = QueryServiceHelper.queryOne((String)dimEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userFieldPermScheme.getDimNumber())})).getLong("id")), includeSub = userFieldPermScheme.getIncludeSub(), appId, entityNum, fpsId = Long.valueOf((fpsObj = BusinessDataServiceHelper.loadSingle((String)"perm_fieldscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)fieldSchemeNum)})).getLong("id"))}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            DynamicObject userFieldSchemeObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userfieldscheme");
                            userFieldSchemeObj.set("user", (Object)userId);
                            userFieldSchemeObj.set("includesub", (Object)includeSub.equals("1"));
                            userFieldSchemeObj.set("dimtype", (Object)dimEntNum);
                            userFieldSchemeObj.set("dimid", (Object)dimId);
                            userFieldSchemeObj.set("app", (Object)appId);
                            userFieldSchemeObj.set("ent", (Object)entityNum);
                            userFieldSchemeObj.set("fps", (Object)fpsId);
                            saveList.add(userFieldSchemeObj);
                            addUFPS = new UserFieldPermScheme(appId, entityNum, fpsId, userId, dimEntNum, dimId, includeSub, busiFrom);
                            addUFPSMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUFPS);
                        }
                        if (!saveList.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(fieldPerms = (List)permDataMap.get("fieldperm")))) {
                        disPerm2 = fieldPerms.iterator();
                        while (disPerm2.hasNext()) {
                            Object fieldPerm = disPerm2.next();
                            UserDimFieldPerm userFieldPermDetail = (UserDimFieldPerm)fieldPerm;
                            String dimTypeNum3 = userFieldPermDetail.getDimType();
                            String dimEntNum3 = (String)dimTypeEntMap.get(dimTypeNum3);
                            DynamicObject dimObj3 = QueryServiceHelper.queryOne((String)dimEntNum3, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userFieldPermDetail.getDimNumber())});
                            long dimId3 = dimObj3.getLong("id");
                            Boolean includeSub = userFieldPermDetail.getIncludeSub();
                            String appId = (String)appNumIdMap.get(userFieldPermDetail.getAppNumber());
                            String entityNum = userFieldPermDetail.getEntityNumber();
                            String fieldKey = userFieldPermDetail.getFieldName();
                            String controlMode = userFieldPermDetail.getControlMode();
                            StringBuilder sql = new StringBuilder();
                            sql.append("select c.fnumber usernum, a.forgid, a.fdimtype, a.fisincludesuborg, b.fbizappid, b.fentitytypeid, b.ffieldname, b.fcontrolmode").append(" from t_perm_userfieldperm a ").append(" join t_perm_fieldpermdetail b on a.ffieldpermid = b.fid").append(" join t_sec_user c on a.fuserid = c.fid ").append(" where a.fuserid = ? and a.forgid = ? and a.fdimtype = ? and a.fisincludesuborg = ? and b.fbizappid = ? and b.fentitytypeid = ? and b.ffieldname = ? and b.fcontrolmode = ? ");
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{userId, dimId3, dimTypeNum3, includeSub != false ? "1" : "0", appId, entityNum, fieldKey, controlMode}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            String fieldpermid = "";
                            DynamicObject userFieldpermDyn = BusinessDataServiceHelper.loadSingle((String)"perm_userfieldperm", (String)"fieldperm", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId).and("includesuborg", "=", (Object)includeSub).and("dimtype", "=", (Object)dimTypeNum3).and("org", "=", (Object)dimId3)});
                            if (userFieldpermDyn == null) {
                                userFieldpermDyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_userfieldperm");
                                fieldpermid = DB.genStringId((String)"t_perm_fieldperm");
                                userFieldpermDyn.set("fieldperm", (Object)fieldpermid);
                            } else {
                                fieldpermid = userFieldpermDyn.getString("fieldperm");
                            }
                            userFieldpermDyn.set("user", (Object)userId);
                            userFieldpermDyn.set("includesuborg", (Object)includeSub);
                            userFieldpermDyn.set("dimtype", (Object)dimTypeNum3);
                            userFieldpermDyn.set("org", (Object)dimId3);
                            DynamicObject fieldpermDyn = BusinessDataServiceHelper.loadSingle((String)"perm_fieldperm", (String)"id, number, name, fieldrule.bizapp, fieldrule.entitytype, fieldrule.fieldname, fieldrule.rowcondition", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fieldpermid)});
                            if (null == fieldpermDyn) {
                                fieldpermDyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_fieldperm");
                            }
                            DynamicObjectCollection fieldpermDetailDoc = fieldpermDyn.getDynamicObjectCollection("fieldrule");
                            DynamicObjectType entryType = fieldpermDetailDoc.getDynamicObjectType();
                            DynamicObject entryObj = new DynamicObject(entryType);
                            entryObj.set("bizapp", (Object)appId);
                            entryObj.set("entitytype", (Object)entityNum);
                            entryObj.set("fieldname", (Object)fieldKey);
                            entryObj.set("rowcondition", (Object)controlMode);
                            fieldpermDetailDoc.add((Object)entryObj);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fieldpermDyn});
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userFieldpermDyn});
                            addUFPD = new UserFieldPermDim(userId, appId, entityNum, fieldKey, controlMode, dimTypeNum3, Long.valueOf(dimId3), includeSub, busiFrom);
                            addUFPDMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUFPD);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(dataRules = (List)permDataMap.get("dr")))) {
                        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
                        for (Object dataRule : dataRules) {
                            DimNewDrPerm dimNewDrPerm = (DimNewDrPerm)dataRule;
                            String appId = (String)appNumIdMap.get(dimNewDrPerm.getAppNumber());
                            String entityNum = dimNewDrPerm.getEntityNumber();
                            String permItemId = (String)permItemNumIdMap.get(dimNewDrPerm.getPermItemNumber());
                            String dataRuleNum = dimNewDrPerm.getDataRuleName();
                            DynamicObject drObj = QueryServiceHelper.queryOne((String)"perm_datarule", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dataRuleNum)});
                            Long drId = drObj.getLong("id");
                            String includeSub = dimNewDrPerm.getIncludesuborg();
                            String dimTypeNum4 = dimNewDrPerm.getDimType();
                            String dimEntNum4 = (String)dimTypeEntMap.get(dimTypeNum4);
                            DynamicObject dimObj4 = QueryServiceHelper.queryOne((String)dimEntNum4, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNewDrPerm.getDimNumber())});
                            Long dimId4 = dimObj4.getLong("id");
                            StringBuilder sql = new StringBuilder();
                            sql.append("select fid from t_perm_userdatarule where fuserid = ? and fappid = ? and fentitynum = ? and fpermitemid = ? and fdataruleid = ? and fdimtype = ? and fdimid = ? and fisincludesub = ? ");
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{userId, appId, entityNum, permItemId, drId, dimEntNum4, dimId4, includeSub}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            DynamicObject userFieldSchemeObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userdatarule");
                            userFieldSchemeObj.set("user", (Object)userId);
                            userFieldSchemeObj.set("app", (Object)appId);
                            userFieldSchemeObj.set("entity", (Object)entityNum);
                            userFieldSchemeObj.set("permitem", (Object)permItemId);
                            userFieldSchemeObj.set("datarule", (Object)drId);
                            userFieldSchemeObj.set("dimtype", (Object)dimEntNum4);
                            userFieldSchemeObj.set("dimobj", (Object)dimId4);
                            userFieldSchemeObj.set("isincludesub", (Object)includeSub.equals("1"));
                            userFieldSchemeObj.set("creator", (Object)currUserId);
                            userFieldSchemeObj.set("createtime", (Object)curTime);
                            userFieldSchemeObj.set("modifier", (Object)currUserId);
                            userFieldSchemeObj.set("modifytime", (Object)curTime);
                            saveList.add(userFieldSchemeObj);
                            addUDR = new UserDrDim(appId, entityNum, permItemId, drId, dimId4, includeSub, dimEntNum4, userId, busiFrom);
                            addUDRMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUDR);
                        }
                        if (!saveList.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(dataPropRules = (List)permDataMap.get("drpr")))) {
                        Object dataRule;
                        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
                        dataRule = dataPropRules.iterator();
                        while (dataRule.hasNext()) {
                            Object dataPropRule = dataRule.next();
                            DimNewDrPrPerm dimNewDrPrPerm = (DimNewDrPrPerm)dataPropRule;
                            String appId = (String)appNumIdMap.get(dimNewDrPrPerm.getAppNumber());
                            String entityNum = dimNewDrPrPerm.getEntityNumber();
                            String propKey = dimNewDrPrPerm.getPropKey();
                            String propEntNum = dimNewDrPrPerm.getPropEntNum();
                            String dataRuleNum = dimNewDrPrPerm.getDataRuleName();
                            DynamicObject drObj = QueryServiceHelper.queryOne((String)"perm_datarule", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dataRuleNum)});
                            Long drId = drObj.getLong("id");
                            String includeSub = dimNewDrPrPerm.getIncludesuborg();
                            String dimTypeNum5 = dimNewDrPrPerm.getDimType();
                            String dimEntNum5 = (String)dimTypeEntMap.get(dimTypeNum5);
                            DynamicObject dimObj5 = QueryServiceHelper.queryOne((String)dimEntNum5, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNewDrPrPerm.getDimNumber())});
                            Long dimId5 = dimObj5.getLong("id");
                            StringBuilder sql = new StringBuilder();
                            sql.append("select fid from t_perm_userdatarule_prop where fuserid = ? and fappid = ? and fentitynum = ? and fpropkey = ? and fpropentnum = ? and fdataruleid = ? and fdimtype = ? and fdimid = ? and fisincludesub = ? ");
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{userId, appId, entityNum, propKey, propEntNum, drId, dimEntNum5, dimId5, includeSub}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            DynamicObject userFieldSchemeObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userdatarule_prop");
                            userFieldSchemeObj.set("user", (Object)userId);
                            userFieldSchemeObj.set("app", (Object)appId);
                            userFieldSchemeObj.set("entity", (Object)entityNum);
                            userFieldSchemeObj.set("propkey", (Object)propKey);
                            userFieldSchemeObj.set("propentity", (Object)propEntNum);
                            userFieldSchemeObj.set("datarule", (Object)drId);
                            userFieldSchemeObj.set("dimtype", (Object)dimEntNum5);
                            userFieldSchemeObj.set("dimobj", (Object)dimId5);
                            userFieldSchemeObj.set("isincludesub", (Object)includeSub.equals("1"));
                            userFieldSchemeObj.set("creator", (Object)currUserId);
                            userFieldSchemeObj.set("createtime", (Object)curTime);
                            userFieldSchemeObj.set("modifier", (Object)currUserId);
                            userFieldSchemeObj.set("modifytime", (Object)curTime);
                            saveList.add(userFieldSchemeObj);
                            addUDRPR = new UserDrPrDim(appId, entityNum, propKey, propEntNum, drId, dimId5, includeSub, dimEntNum5, userId, busiFrom);
                            addUDRPRMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUDRPR);
                        }
                        if (!saveList.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                        }
                    }
                    List usrGrpInfos = (List)permDataMap.get("usrgrpinfo");
                    HashMap<Long, Set> addUserIdGrpIdSetMap = new HashMap<Long, Set>(8);
                    if (CollectionUtils.isNotEmpty((Collection)usrGrpInfos)) {
                        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
                        for (Object usrGrpInfo : usrGrpInfos) {
                            Long usrGrpStdId;
                            DynamicObject usrGrpObj;
                            UsrGrpUser usrGrpUser = (UsrGrpUser)usrGrpInfo;
                            String fromType = usrGrpUser.getFromType();
                            String userGroupNum = usrGrpUser.getUserGroupNum();
                            String usrGrpName = usrGrpUser.getUserGroupName();
                            String usrGrpDesc = usrGrpUser.getUserGroupDesc();
                            String usrGrpStdNum = usrGrpUser.getUsrGrpStdNum();
                            String usrGrpStdName = usrGrpUser.getUsrGrpStdName();
                            String usrGrpStdDesc = usrGrpUser.getUsrGrpStdDesc();
                            DynamicObject usrGrpStdObj = QueryServiceHelper.queryOne((String)"perm_usergroupstandard", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)usrGrpStdNum)});
                            if (null == usrGrpStdObj) {
                                usrGrpStdObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_usergroupstandard");
                                usrGrpStdObj.set("number", (Object)usrGrpStdNum);
                                usrGrpStdObj.set("name", (Object)usrGrpStdName);
                                usrGrpStdObj.set("description", (Object)usrGrpStdDesc);
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{usrGrpStdObj});
                            }
                            if (null == (usrGrpObj = QueryServiceHelper.queryOne((String)"bos_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userGroupNum), new QFilter("usrgrpstd", "=", (Object)(usrGrpStdId = Long.valueOf(usrGrpStdObj.getLong("id"))))}))) {
                                usrGrpObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usrgrp");
                                usrGrpObj.set("number", (Object)userGroupNum);
                                usrGrpObj.set("name", (Object)usrGrpName);
                                usrGrpObj.set("description", (Object)usrGrpDesc);
                                usrGrpObj.set("usrgrpstd", (Object)usrGrpStdId);
                                usrGrpObj.set("enable", (Object)"1");
                                usrGrpObj.set("parent", (Object)0L);
                                usrGrpObj.set("level", (Object)0);
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{usrGrpObj});
                            }
                            Long usrGrpId = usrGrpObj.getLong("id");
                            StringBuilder sql = new StringBuilder();
                            sql.append("select fid from t_sec_usergroupstaff where fuserid = ? and fusergroupid = ? ");
                            Boolean dataExist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{userId, usrGrpId}, ResultSet::next);
                            if (dataExist.booleanValue()) continue;
                            DynamicObject usrGrpRelateObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                            usrGrpRelateObj.set("usergroup", (Object)usrGrpId);
                            usrGrpRelateObj.set("user", (Object)userId);
                            usrGrpRelateObj.set("from_type", (Object)fromType);
                            saveList.add(usrGrpRelateObj);
                            addUserIdGrpIdSetMap.computeIfAbsent(userId, k -> new HashSet(8)).add(usrGrpId);
                            addUGU = new UsrGrpUser(usrGrpId, usrGrpStdId, userId, fromType, busiFrom);
                            addUGUMap.computeIfAbsent(userId, k -> new HashSet(8)).add(addUGU);
                        }
                        if (!saveList.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                        }
                    }
                    Collection changedUserIds = userNumIdMap.values();
                    ArrayList userIds = new ArrayList(changedUserIds);
                    FormConfigFactory.cancelShowFormRights(userIds);
                    UserHasPermOrgCache.clearUserLoginOrgs(changedUserIds);
                    for (Map.Entry addUserIdGrpIdSet : addUserIdGrpIdSetMap.entrySet()) {
                        Map usrGrpIdAppEntSetMap;
                        Long key = (Long)addUserIdGrpIdSet.getKey();
                        Set value = (Set)addUserIdGrpIdSet.getValue();
                        if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty() || null == (usrGrpIdAppEntSetMap = UserGroupHelper.getUsrGrpIdAppEntSetMap((Set)value)) || usrGrpIdAppEntSetMap.isEmpty()) continue;
                        for (Map.Entry usrGrpIdAppEntSet : usrGrpIdAppEntSetMap.entrySet()) {
                            Long usrGrpId = (Long)usrGrpIdAppEntSet.getKey();
                            Map appEntSet = (Map)usrGrpIdAppEntSet.getValue();
                            if (null == usrGrpId || Objects.equals(0L, usrGrpId) || null == appEntSet || appEntSet.isEmpty()) continue;
                            for (Map.Entry appEnt : appEntSet.entrySet()) {
                                if (StringUtils.isEmpty((String)((String)appEnt.getKey())) || CollectionUtils.isEmpty((Collection)((Collection)appEnt.getValue()))) continue;
                                appEntityMap.computeIfAbsent(key, k -> new HashMap(8)).computeIfAbsent(appEnt.getKey(), k -> new HashSet(8)).addAll((Collection)appEnt.getValue());
                            }
                        }
                    }
                    HashMap<String, List> bizAppAndObjInfo = null;
                    for (Map.Entry appEntity : appEntityMap.entrySet()) {
                        Long key = (Long)appEntity.getKey();
                        Map value = (Map)appEntity.getValue();
                        if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty()) continue;
                        bizAppAndObjInfo = new HashMap<String, List>(8);
                        for (Map.Entry one : value.entrySet()) {
                            bizAppAndObjInfo.computeIfAbsent((String)one.getKey(), k -> new ArrayList(10)).addAll((Collection)one.getValue());
                        }
                        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj((List)Lists.newArrayList((Object[])new Long[]{key}), bizAppAndObjInfo);
                    }
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), userNum, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        if (PermCommonUtil.isEnablePermLog()) {
            HashMap<String, String> paramMap = new HashMap<String, String>(10);
            paramMap.put("ENTSAVE_PERMLOG", "1");
            paramMap.put("permlog_op", "save");
            paramMap.put("permlog_opbtn", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u5165", (String)"PermDataMigrationNewUtils_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
            paramMap.put("permlog_interfacemethod", "kd.bos.permission.migration.model.UserPermMigration.importData");
            paramMap.put("permlog_busitype", "userdirect_save");
            paramMap.put("permlog_formnum", "perm_datamigration");
            paramMap.put("currbizappid", "0XWTKVOQW+ML");
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(paramMap, null, null, null, null, null);
            permLogReq.setBusiFrom(busiFrom);
            UserDirectPermAfterSaveReq afterSaveReq = (UserDirectPermAfterSaveReq)PermBuilder.of(UserDirectPermAfterSaveReq::new).with(PermOperationReq::setCurAppNum, (Object)"0XWTKVOQW+ML").with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(UserDirectPermAfterSaveReq::setAddUserUFDMap, addUserUFDMap).with(UserDirectPermAfterSaveReq::setAddUFPDMap, addUFPDMap).with(UserDirectPermAfterSaveReq::setAddUFPSMap, addUFPSMap).with(UserDirectPermAfterSaveReq::setAddUDRMap, addUDRMap).with(UserDirectPermAfterSaveReq::setAddUDRPRMap, addUDRPRMap).build();
            UserDirectPermService userDirectPermService = (UserDirectPermService)PermServiceFactory.getService("UserDirectPermService");
            userDirectPermService.afterMainEntitySave((PermOperationReq)afterSaveReq);
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }

    private static /* synthetic */ List lambda$null$13(String k) {
        return new ArrayList(10);
    }

    private static /* synthetic */ List lambda$null$11(String k) {
        return new ArrayList(10);
    }

    private static /* synthetic */ List lambda$null$7(String k) {
        return new ArrayList(10);
    }
}

