/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.PermMigrationHelper;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.permission.model.perm.userrole.UserRoleDim;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserRoleMigration
implements PermMigratedBean {
    @Override
    public String generateJson(Set<Object> exportDataIds) {
        DynamicObjectCollection userRoleObjCol = QueryServiceHelper.query((String)"perm_userrole_multype", (String)"role.number,user.number,itemclass,itemclasstypefield,includesuborg,starttime,endtime", (QFilter[])new QFilter[]{new QFilter("id", "in", exportDataIds)});
        if (userRoleObjCol.size() == 0) {
            logger.info("UserRoleMigration.generateJson: userRoleObjCol.size() == 0");
            return "";
        }
        ArrayList<UserRoleDim> userRoleDims = new ArrayList<UserRoleDim>(10);
        for (DynamicObject userRoleObj : userRoleObjCol) {
            UserRoleDim userRoleDim = new UserRoleDim();
            userRoleDim.setUserNumber(userRoleObj.getString("user.number"));
            Object dimTypeId = userRoleObj.get("itemclass");
            String dimType = userRoleObj.getString("itemclasstypefield");
            DynamicObject dimTypeObj = QueryServiceHelper.queryOne((String)dimType, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", dimTypeId)});
            if (dimTypeObj == null) continue;
            userRoleDim.setDimNumber(dimTypeObj.getString("number"));
            userRoleDim.setRoleNumber(userRoleObj.getString("role.number"));
            userRoleDim.setIncludeSub(Boolean.valueOf(userRoleObj.getBoolean("includesuborg")));
            userRoleDim.setDimType(PermCommonUtil.getSuitableDimType((String)dimType)[0]);
            userRoleDim.setStartTime(userRoleObj.getDate("starttime"));
            userRoleDim.setEndTime(userRoleObj.getDate("endtime"));
            userRoleDims.add(userRoleDim);
        }
        return JSON.toJSONString(userRoleDims, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @Override
    public boolean validate(Object data, StringBuilder mes) {
        String[] suitableDimType;
        String bizObjectId;
        String dimTypeNum;
        ArrayList<String> errorList = new ArrayList<String>(10);
        UserRoleDim userRoleDim = (UserRoleDim)data;
        if (mes == null) {
            mes = new StringBuilder();
        }
        String roleNumber = userRoleDim.getRoleNumber();
        String userNumber = userRoleDim.getUserNumber();
        String dimNumber = userRoleDim.getDimNumber();
        if (!QueryServiceHelper.exists((String)"perm_role", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)roleNumber)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_12", (String)"bos-mservice-permission", (Object[])new Object[0]), roleNumber));
        }
        if (!QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userNumber)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a \u201c%1$s\u201d \u7684\u7528\u6237\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
        }
        if (StringUtils.isNotEmpty((String)(dimTypeNum = userRoleDim.getDimType())) && !QueryServiceHelper.exists((String)"perm_ctrltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimTypeNum)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_5", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNum));
        }
        if (StringUtils.isNotEmpty((String)(bizObjectId = (suitableDimType = PermCommonUtil.getSuitableDimType((String)dimTypeNum))[1])) && !QueryServiceHelper.exists((String)bizObjectId, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber)})) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684%2$s\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_14", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNumber, suitableDimType[3]));
        }
        if (errorList.size() > 0) {
            StringBuilder sb = this.appenSb(errorList);
            mes.append(String.format(ResManager.loadKDString((String)"[\u901a\u7528\u89d2\u8272\u7f16\u7801 \u201c%1$s\u201d ,\u7528\u6237\u7f16\u7801 \u201c%2$s\u201d ,\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801 \u201c%3$s\u201d ]\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%4$s\u3002\r\n", (String)"PermDataMigrationValidator_11", (String)"bos-mservice-permission", (Object[])new Object[0]), roleNumber, userNumber, dimNumber, sb.toString()));
            return false;
        }
        return true;
    }

    @Override
    public ImportResult importData(String json, StringBuilder mes) {
        List userRoleDims = JSON.parseArray((String)json, UserRoleDim.class);
        HashMap<String, String> roleIdNameMap = new HashMap<String, String>(10);
        HashMap<String, List> roleIdPreDataMap = new HashMap<String, List>(10);
        ImportResult importResult = new ImportResult();
        int successCount = 0;
        int errorCount = 0;
        importResult.setErrorMes(mes);
        for (UserRoleDim userRoleDim : userRoleDims) {
            if (!this.validate(userRoleDim, mes)) {
                ++errorCount;
                importResult.setAllSuccess(false);
                continue;
            }
            HashSet<Long> changedUserIdSet = new HashSet<Long>(1);
            String dimTypeNum = userRoleDim.getDimType();
            String lowerCasedimType = PermCommonUtil.getSuitableDimType((String)dimTypeNum)[1];
            String roleNumber = userRoleDim.getRoleNumber();
            DynamicObject roleObj = QueryServiceHelper.queryOne((String)"perm_role", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)roleNumber)});
            String roleId = roleObj.getString("id");
            roleIdNameMap.putIfAbsent(roleId, roleObj.getString("name"));
            String userNumber = userRoleDim.getUserNumber();
            Long userId = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)userNumber)}).getLong("id");
            changedUserIdSet.add(userId);
            String dimNumber = userRoleDim.getDimNumber();
            Object dimId = QueryServiceHelper.queryOne((String)lowerCasedimType, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber)}).get("id");
            Boolean includeSub = userRoleDim.getIncludeSub();
            DynamicObject userRoleObj = BusinessDataServiceHelper.loadSingle((String)"perm_userrole_multype", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId).and("user", "=", (Object)userId).and("itemclasstypefield", "=", (Object)lowerCasedimType).and("itemclass", "=", dimId).and("includesuborg", "=", (Object)includeSub)});
            if (userRoleObj == null) {
                userRoleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole_multype");
                userRoleObj.set("role", (Object)roleId);
                userRoleObj.set("user", (Object)userId);
                userRoleObj.set("itemclasstypefield", (Object)lowerCasedimType);
                userRoleObj.set("itemclass", dimId);
                userRoleObj.set("includesuborg", (Object)includeSub);
            }
            if (PermCommonUtil.isEnablePermLog()) {
                roleIdPreDataMap.putIfAbsent(roleId, OrgUserHelper.getPURList((Set)Sets.newHashSet((Object[])new String[]{roleId}), null, null, null, null, (boolean)true));
            }
            userRoleObj.set("starttime", (Object)userRoleDim.getStartTime());
            userRoleObj.set("endtime", (Object)userRoleDim.getEndTime());
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    Object[] pkIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userRoleObj});
                    ++successCount;
                    if (pkIds.length != 1 || !CollectionUtils.isNotEmpty(changedUserIdSet)) continue;
                    UserHasPermOrgCache.clearUserLoginOrgs(changedUserIdSet);
                    LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)RequestContext.get().getLang().toString());
                    List newDRAppEntityList = newDataRule.getNewDRAppEntityList();
                    PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdSet), (List)newDRAppEntityList, (boolean)false);
                    Map appEntity = PermissionServiceHelper.getAppEntityByRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleId}));
                    LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(changedUserIdSet), (Map)appEntity);
                }
                catch (Exception e) {
                    String errorMes = String.format(ResManager.loadKDString((String)"[\u901a\u7528\u89d2\u8272\u7f16\u7801 \u201c%1$s\u201d ,\u7528\u6237\u7f16\u7801 \u201c%2$s\u201d ,\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801 \u201c%3$s\u201d ]\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%4$s\u3002\r\n", (String)"PermDataMigrationValidator_11", (String)"bos-mservice-permission", (Object[])new Object[0]), roleNumber, userNumber, dimNumber, e.getMessage());
                    mes.append(errorMes);
                    logger.info(errorMes);
                    h.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        if (PermCommonUtil.isEnablePermLog()) {
            for (Map.Entry entry : roleIdPreDataMap.entrySet()) {
                String roleId = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (StringUtils.isEmpty((String)roleId) || null == value || value.isEmpty()) continue;
                PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"common_role_assignorguser");
                List afterData = OrgUserHelper.getPURList((Set)Sets.newHashSet((Object[])new String[]{roleId}), null, null, null, null, (boolean)true);
                Map diffMap = PermUserRole.logCompareMutiThread((List)value, (List)afterData);
                diffMap.put("langStr", RequestContext.get().getLang().name());
                try {
                    PermMigrationHelper.addPermLog(permLogBusiType, null, null, null, (String)roleIdNameMap.get(roleId), null, ResManager.loadKDString((String)"\u6743\u9650\u79fb\u5e93\uff1a\u901a\u7528\u89d2\u8272\u4e0e\u7528\u6237\u5173\u7cfb", (String)"PermDataMigrationNewUtils_7", (String)"bos-mservice-permission", (Object[])new Object[0]), StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)diffMap)));
                }
                catch (JsonProcessingException e) {
                    logger.info("PermDataMigrationNewUtils.importUserRolesJson.addPermLog: " + e.getMessage());
                }
            }
        }
        importResult.setSuccessCount(successCount);
        importResult.setErrorCount(errorCount);
        return importResult;
    }
}

