/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.nocode.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.api.INoCodePermissionService;
import kd.bos.permission.nocode.api.IPermResult;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.DataRule;
import kd.bos.permission.nocode.model.DataRuleTypeEnum;
import kd.bos.permission.nocode.model.EntityPerm;
import kd.bos.permission.nocode.model.PermItem;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.permission.nocode.model.PermResult;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.permission.nocode.model.RoleTypeEnum;
import kd.bos.permission.nocode.utils.NoCodePermImplUtils;
import kd.bos.permission.nocode.utils.NoCodePermUtils;
import kd.bos.permission.nocode.utils.NoCodeRolePermMerger;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class NoCodePermissionServiceImpl
implements INoCodePermissionService {
    private static final Log log = LogFactory.getLog(NoCodePermissionServiceImpl.class);

    public void saveRole(Role role) {
        this.saveRole(role, true);
    }

    private void saveRole(Role role, boolean clearPermCache) {
        DynamicObject appObj;
        if (clearPermCache) {
            log.info("NoCodePermissionServiceImpl.saveRole\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\uff1a{}", (Object)role);
        }
        if (role == null) {
            return;
        }
        DynamicObject roleObj = null;
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            role.setId(ORM.create().genStringId("perm_role"));
        } else {
            roleObj = NoCodePermImplUtils.loadSingle((Object)role.getId(), "perm_role");
        }
        if (roleObj == null) {
            roleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_role");
            roleObj.set("id", (Object)role.getId());
            NoCodePermUtils.setDynamicObjectCommonProperty((DynamicObject)roleObj);
        }
        if ((appObj = this.setAppObj(role, roleObj)) == null) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)role, ResManager.loadKDString((String)"\u201c\u5e94\u7528\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"NoCodePermissionServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return;
        }
        this.setRoleGroup(roleObj);
        roleObj.set("number", (Object)("NOCODE-" + role.getId()));
        if (StringUtils.isNotBlank((CharSequence)role.getName())) {
            roleObj.set("name", (Object)role.getName());
        }
        roleObj.set("issystem", (Object)role.isSystem());
        roleObj.set("sortcode", (Object)role.getSortCode());
        roleObj.set("remark", (Object)role.getDescription());
        roleObj.set("appmanagetype", (Object)role.getAppManageType().getValue());
        roleObj.set("appusetype", (Object)role.getAppUseType().getValue());
        RoleTypeEnum roleType = role.getRoleType();
        if (roleType == null) {
            roleType = RoleTypeEnum.APP;
        }
        roleObj.set("roletype", (Object)roleType.getValue());
        roleObj.set("usescope", (Object)"2");
        if (role.isSuccess()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"nocodesave", (String)"perm_role", (DynamicObject[])new DynamicObject[]{roleObj}, (OperateOption)NoCodePermImplUtils.getOperateOption());
            HashMap<Object, IPermResult> roleMap = new HashMap<Object, IPermResult>(1);
            roleMap.put(role.getId(), (IPermResult)role);
            NoCodePermImplUtils.convertPermResult(operationResult, roleMap);
            NoCodePermImplUtils.afterOperation("perm_role", "save", clearPermCache, NoCodePermImplUtils.toRoleIds(role));
        }
    }

    private DynamicObject setAppObj(Role role, DynamicObject roleObj) {
        if (StringUtils.isBlank((CharSequence)role.getAppId())) {
            return null;
        }
        DynamicObjectType roleDynamicObjectType = roleObj.getDynamicObjectType();
        DynamicProperty appProperty = roleDynamicObjectType.getProperty("bizdomain");
        DynamicObjectType appType = (DynamicObjectType)((BasedataProp)appProperty).getComplexType();
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)role.getAppId(), (DynamicObjectType)appType);
        roleObj.set("bizdomain", (Object)appObj);
        return appObj;
    }

    private DynamicObject setRoleGroup(DynamicObject roleObj) {
        DynamicObjectType roleDynamicObjectType = roleObj.getDynamicObjectType();
        DynamicProperty groupProperty = roleDynamicObjectType.getProperty("group");
        DynamicObjectType groupType = (DynamicObjectType)((BasedataProp)groupProperty).getComplexType();
        DynamicObject rootGroupObj = BusinessDataServiceHelper.loadSingleFromCache((Object)"3G8DIP1FPT8X", (DynamicObjectType)groupType);
        roleObj.set("group", (Object)rootGroupObj);
        return rootGroupObj;
    }

    public String updateRoleSort(List<String> roleIds) {
        log.debug("NoCodePermissionServiceImpl.updateRoleSort\u66f4\u65b0\u89d2\u8272\u6392\u5e8f\uff1a{}", roleIds);
        if (CollectionUtils.isEmpty(roleIds)) {
            return "";
        }
        String selectFields = "sortcode,modifier,modifytime";
        QFilter idFilter = new QFilter("id", "in", roleIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] roleObjArr = BusinessDataServiceHelper.load((String)"perm_role", (String)selectFields, (QFilter[])filters);
        if (roleObjArr == null || roleObjArr.length == 0) {
            return "";
        }
        int sortCode = 1;
        HashMap<String, Integer> roleSortMap = new HashMap<String, Integer>(roleIds.size());
        for (String roleId : roleIds) {
            roleSortMap.put(roleId, sortCode++);
        }
        for (DynamicObject roleObj : roleObjArr) {
            roleObj.set("sortcode", roleSortMap.get(roleObj.getString("id")));
            NoCodePermUtils.setDynamicObjectModify((DynamicObject)roleObj);
        }
        SaveServiceHelper.save((DynamicObject[])roleObjArr);
        return "";
    }

    public Role getRole(String roleId) {
        Role role = new Role();
        this.getRole(roleId, role);
        return role;
    }

    public List<Role> getRoleByAppId(String appId) {
        return this.getRoles(0L, Collections.singletonList(appId), null);
    }

    public List<Role> getRoleByUserId(long userId) {
        return this.getRoles(userId, new ArrayList<String>(0), RoleTypeEnum.APP);
    }

    public List<Role> getSystemRoleByUserId(long userId) {
        return this.getRoles(userId, new ArrayList<String>(0), RoleTypeEnum.SYSTEM);
    }

    private List<Role> getRoles(long userId, String appId, String entityNumber, RoleTypeEnum roleType) {
        List<String> appIds = this.getAppIds(appId, entityNumber);
        if (appIds.isEmpty()) {
            return new ArrayList<Role>(0);
        }
        return this.getRoles(userId, appIds, roleType);
    }

    private List<String> getAppIds(String appId, String entityNumber) {
        String originalAppId;
        ArrayList<String> appIds = new ArrayList<String>();
        AppInfo appInfo = EntityMetadataCache.getAppInfo((String)EntityMetadataCache.getBizAppNumber((String)entityNumber));
        String string = originalAppId = appInfo == null ? appId : appInfo.getId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appIds.add(originalAppId);
            appIds.addAll(this.getAppliedApIds(entityNumber));
        } else if (Objects.equals(originalAppId, appId) || this.getAppliedApIds(entityNumber).contains(appId)) {
            appIds.add(appId);
        }
        return appIds;
    }

    private List<Role> getRoles(long userId, List<String> appIds, RoleTypeEnum roleType) {
        QFilter filter = null;
        if (userId == 0L) {
            if (!CollectionUtils.isEmpty(appIds)) {
                filter = this.getRoleByAppIdFilter(appIds);
            }
        } else {
            Set<String> userRoleIds = this.getUserRoleIds(userId, appIds);
            if (!CollectionUtils.isEmpty(userRoleIds)) {
                filter = new QFilter("id", "in", userRoleIds);
            }
        }
        if (filter == null) {
            return new ArrayList<Role>(0);
        }
        if (roleType != null) {
            filter = filter.and(new QFilter("roletype", "=", (Object)roleType.getValue()));
        }
        return this.getRoles(filter);
    }

    private List<Role> getRoles(QFilter filter) {
        if (filter == null) {
            filter = new QFilter("group", "=", (Object)"3G8DIP1FPT8X");
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectFields = "id,number,name,group,bizdomain,issystem,sortcode,remark,appmanagetype,appusetype,roletype,enable";
        QFilter[] filters = new QFilter[]{filter, enableFilter};
        Map roleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)selectFields, (QFilter[])filters);
        if (roleObjMap.isEmpty()) {
            return new ArrayList<Role>(0);
        }
        TreeMap<Integer, List> orderRoleMap = new TreeMap<Integer, List>();
        for (Map.Entry entry : roleObjMap.entrySet()) {
            Role role = new Role();
            this.convertRoleObj((DynamicObject)entry.getValue(), role);
            orderRoleMap.computeIfAbsent(role.getSortCode(), v -> new ArrayList(roleObjMap.size())).add(role);
        }
        ArrayList<Role> roleList = new ArrayList<Role>(roleObjMap.size());
        for (Map.Entry entry : orderRoleMap.entrySet()) {
            roleList.addAll((Collection)entry.getValue());
        }
        return roleList;
    }

    private QFilter getRoleByAppIdFilter(List<String> appIds) {
        QFilter groupFilter = new QFilter("group", "=", (Object)"3G8DIP1FPT8X");
        QFilter appFilter = new QFilter("bizdomain", "in", appIds);
        groupFilter = groupFilter.and(appFilter);
        return groupFilter;
    }

    private void getRole(String roleId, Role role) {
        DynamicObject roleObj = this.getRoleObj(roleId, role);
        if (roleObj != null) {
            this.convertRoleObj(roleObj, role);
        }
    }

    private DynamicObject getRoleObj(String roleId, Role role) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)role, ResManager.loadKDString((String)"\u89d2\u8272\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoCodePermissionServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return null;
        }
        DynamicObject roleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)roleId, (String)"perm_role");
        if (roleObj == null) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)role, ResManager.loadKDString((String)"\u89d2\u8272\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"NoCodePermissionServiceImpl_2", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return null;
        }
        return roleObj;
    }

    private void convertRoleObj(DynamicObject roleObj, Role role) {
        role.setId(roleObj.getString("id"));
        role.setName(roleObj.getString("name"));
        role.setAppId(roleObj.getString("bizdomain_id"));
        role.setSystem(roleObj.getBoolean("issystem"));
        role.setDescription(roleObj.getString("remark"));
        role.setSortCode(roleObj.getInt("sortcode"));
        role.setAppManageType(AppManageTypeEnum.of((String)roleObj.getString("appmanagetype")));
        role.setAppUseType(AppUseTypeEnum.of((String)roleObj.getString("appusetype")));
        role.setRoleType(RoleTypeEnum.of((String)roleObj.getString("roletype")));
        role.setEnable(roleObj.getBoolean("enable"));
    }

    public void saveRolePerm(RolePerm rolePerm) {
        if (rolePerm == null) {
            return;
        }
        log.info("NoCodePermissionServiceImpl.saveRolePerm\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\u6743\u9650\uff1a{}", (Object)rolePerm);
        for (Map.Entry entry : rolePerm.getEntityNumberPermMap().entrySet()) {
            log.info("NoCodePermissionServiceImpl.saveRolePerm\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\u7684\u5355\u636e\u6743\u9650\u4fe1\u606f\uff1a{}", entry.getValue());
        }
        this.saveRole((Role)rolePerm, false);
        if (rolePerm.isSuccess()) {
            this.saveRoleScope(rolePerm);
            this.saveEntityPerm(rolePerm);
            NoCodePermImplUtils.afterOperation("perm_role", "save", true, null);
        }
    }

    public RolePerm copyRolePerm(String roleId, String name) {
        log.info("NoCodePermissionServiceImpl.copyRolePerm\u5f00\u59cb\u590d\u5236\u89d2\u8272\u6743\u9650\uff1a\u3010\u6e90\u89d2\u8272ID\u3011{}\u3010\u65b0\u89d2\u8272\u540d\u79f0\u3011{}", (Object)roleId, (Object)name);
        RolePerm rolePerm = this.getRolePerm(roleId);
        if (rolePerm.isSuccess()) {
            rolePerm.setId("");
            rolePerm.setName(name);
            rolePerm.setSystem(false);
            rolePerm.setSortCode(this.getMaxSortCodeByAppId(rolePerm.getAppId()) + 1);
            this.saveRolePerm(rolePerm);
        }
        return rolePerm;
    }

    private int getMaxSortCodeByAppId(String appId) {
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)"select max(fsortcode) sortcode from t_perm_role where fbizdomainid = ?", (Object[])new Object[]{appId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("sortcode");
            }
            return 0;
        });
    }

    public RolePerm getRolePerm(String roleId) {
        RolePerm rolePerm = new RolePerm();
        this.getRole(roleId, (Role)rolePerm);
        if (!rolePerm.isSuccess()) {
            log.info("NoCodePermissionServiceImpl.getRolePerm\u83b7\u53d6\u89d2\u8272\u5931\u8d25\uff1a{}", (Object)rolePerm.getErrors());
            return rolePerm;
        }
        this.loadRoleScope(rolePerm);
        this.loadEntityPerm(rolePerm);
        log.info("NoCodePermissionServiceImpl.getRolePerm\u5b8c\u6210\u83b7\u53d6\u89d2\u8272\u6743\u9650\u4fe1\u606f\uff1a{}", (Object)rolePerm);
        for (Map.Entry entry : rolePerm.getEntityNumberPermMap().entrySet()) {
            log.info("NoCodePermissionServiceImpl.getRolePerm\u89d2\u8272\u7684\u5355\u636e\u6743\u9650\u4fe1\u606f\uff1a{}", entry.getValue());
        }
        return rolePerm;
    }

    private void loadRoleScope(RolePerm rolePerm) {
        QFilter[] filters = NoCodePermImplUtils.getRoleFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm));
        Map userRoleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_userrole", (String)"org,user", (QFilter[])filters);
        userRoleObjMap.entrySet().forEach(entry -> {
            DynamicObject obj = (DynamicObject)entry.getValue();
            Long userId = obj.getLong("user_id");
            if (Objects.equals(userId, 0L)) {
                rolePerm.getAssignOrgIds().add(obj.getLong("org_id"));
            } else {
                rolePerm.getAssignUserIds().add(userId);
            }
        });
    }

    private void loadEntityPerm(RolePerm rolePerm) {
        this.loadDataRule(rolePerm);
        this.loadFunctionPerm(rolePerm);
        this.loadFieldPerm(rolePerm);
    }

    private void loadDataRule(RolePerm rolePerm) {
        DynamicObject roleDataRuleObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_roledatarules", (QFilter[])NoCodePermImplUtils.getRoleFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (roleDataRuleObj == null) {
            return;
        }
        long dataRulesId = roleDataRuleObj.getLong("datarules_id");
        if (dataRulesId == 0L) {
            return;
        }
        DynamicObject dataRulesObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataRulesId, (String)"perm_datarules");
        if (dataRulesObj == null) {
            return;
        }
        DynamicObjectCollection entryEntityCol = dataRulesObj.getDynamicObjectCollection("entryentity");
        HashMap<Long, String> dataRuleEntityMap = new HashMap<Long, String>(entryEntityCol.size());
        for (DynamicObject entryObj : entryEntityCol) {
            EntityPerm entityPerm = this.getEntityPerm(rolePerm, entryObj);
            if (entityPerm == null) continue;
            long dataRuleId = entryObj.getLong("datarule_id");
            dataRuleEntityMap.put(dataRuleId, entityPerm.getEntityNumber());
        }
        if (dataRuleEntityMap.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", dataRuleEntityMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter};
        Map dataRuleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_datarule", (String)"id,entity,nocoderule", (QFilter[])filters);
        dataRuleObjMap.entrySet().forEach(entry -> {
            DynamicObject dataRuleObj = (DynamicObject)entry.getValue();
            String entityNumber = dataRuleObj.getString("entity_id");
            EntityPerm entityPerm = (EntityPerm)rolePerm.getEntityNumberPermMap().get(entityNumber);
            if (entityPerm != null) {
                DataRule dataRule = entityPerm.getDataRule();
                dataRule.setId(dataRuleObj.getLong("id"));
                dataRule.parseNoCodeRule(dataRuleObj.getString("nocoderule"));
            }
            log.info(entityNumber + "\uff1a\u6570\u636e\u89c4\u5219\uff1a" + (entityPerm == null ? null : entityPerm.getDataRule()));
        });
    }

    private void loadFunctionPerm(RolePerm rolePerm) {
        DynamicObject rolePermObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_roleperm", (QFilter[])NoCodePermImplUtils.getRoleIdFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (rolePermObj == null) {
            return;
        }
        DynamicObjectCollection rolePermCol = rolePermObj.getDynamicObjectCollection("roleperm");
        for (DynamicObject entryObj : rolePermCol) {
            EntityPerm entityPerm = this.getEntityPerm(rolePerm, entryObj);
            if (entityPerm == null) continue;
            Map permItemMap = entityPerm.getPermItemMap();
            String permItemId = entryObj.getString("permitem_id");
            permItemMap.put(permItemId, new PermItem(permItemId));
        }
    }

    private void loadFieldPerm(RolePerm rolePerm) {
        DynamicObject roleFieldPermObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_rolefieldperm", (QFilter[])NoCodePermImplUtils.getRoleFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (roleFieldPermObj == null) {
            return;
        }
        String fieldPermId = roleFieldPermObj.getString("fieldperm_id");
        if (StringUtils.isBlank((CharSequence)fieldPermId)) {
            return;
        }
        DynamicObject fieldPermObj = BusinessDataServiceHelper.loadSingleFromCache((Object)fieldPermId, (String)"perm_fieldperm");
        if (fieldPermObj == null) {
            return;
        }
        DynamicObjectCollection fieldRuleCol = fieldPermObj.getDynamicObjectCollection("fieldrule");
        for (DynamicObject entryObj : fieldRuleCol) {
            PermItem permItem;
            DynamicObject entityObj;
            String property = entryObj.getString("fieldname");
            if (StringUtils.isBlank((CharSequence)property) || (entityObj = entryObj.getDynamicObject("entitytype")) == null) continue;
            String entityNumber = entityObj.getString("number");
            EntityPerm entityPerm = rolePerm.getEntityNumberPermMap().computeIfAbsent(entityNumber, v -> new EntityPerm(entityObj.getString("id"), entityNumber));
            Map permItemMap = entityPerm.getPermItemMap();
            if (CollectionUtils.isEmpty((Map)permItemMap) || (permItem = (PermItem)permItemMap.get(entryObj.getString("permitem_id"))) == null) continue;
            permItem.getNoPermProperties().add(property);
        }
    }

    private EntityPerm getEntityPerm(RolePerm rolePerm, DynamicObject entryObj) {
        DynamicObject entityObj = entryObj.getDynamicObject("entity");
        if (entityObj == null) {
            return null;
        }
        String entityNumber = entityObj.getString("number");
        return rolePerm.getEntityNumberPermMap().computeIfAbsent(entityNumber, v -> new EntityPerm(entityObj.getString("id"), entityNumber));
    }

    private void saveRoleScope(RolePerm rolePerm) {
        if (!rolePerm.isSuccess()) {
            return;
        }
        log.info("NoCodePermissionServiceImpl.saveRoleScope\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u8303\u56f4\uff1a\u3010\u7ec4\u7ec7\u3011{}\u3010\u7528\u6237\u3011{}", (Object)rolePerm.getAssignOrgIds(), (Object)rolePerm.getAssignUserIds());
        NoCodePermImplUtils.transHandle((IPermResult)rolePerm, objects -> {
            this.deleteRoleScope(NoCodePermImplUtils.toRoleIds((Role)rolePerm));
            int count = rolePerm.getAssignOrgIds().size() + rolePerm.getAssignUserIds().size();
            if (count == 0) {
                return null;
            }
            MainEntityType userRoleType = EntityMetadataCache.getDataEntityType((String)"perm_userrole");
            String[] ids = ORM.create().genStringIds("perm_userrole", count);
            List<String> newIds = Arrays.stream(ids).collect(Collectors.toList());
            ArrayList<DynamicObject> roleScopeObjList = new ArrayList<DynamicObject>(count);
            if (!CollectionUtils.isEmpty((Collection)rolePerm.getAssignOrgIds())) {
                for (Long orgId : rolePerm.getAssignOrgIds()) {
                    DynamicObject roleScopeObj = (DynamicObject)userRoleType.createInstance();
                    roleScopeObjList.add(roleScopeObj);
                    roleScopeObj.set("org", (Object)orgId);
                    this.setRoleScopeCommonProperty(rolePerm, roleScopeObj, newIds);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rolePerm.getAssignUserIds())) {
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                for (Long userId : rolePerm.getAssignUserIds()) {
                    DynamicObject roleScopeObj = (DynamicObject)userRoleType.createInstance();
                    roleScopeObjList.add(roleScopeObj);
                    roleScopeObj.set("org", (Object)rootOrgId);
                    roleScopeObj.set("user", (Object)userId);
                    this.setRoleScopeCommonProperty(rolePerm, roleScopeObj, newIds);
                }
            }
            if (rolePerm.isSuccess() && !roleScopeObjList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])roleScopeObjList.toArray(new DynamicObject[0]));
            }
            return null;
        });
    }

    private void setRoleScopeCommonProperty(RolePerm rolePerm, DynamicObject roleScopeObj, List<String> newIds) {
        String id = newIds.isEmpty() ? ORM.create().genStringId("perm_userrole") : newIds.remove(0);
        roleScopeObj.set("id", (Object)id);
        roleScopeObj.set("role", (Object)rolePerm.getId());
        roleScopeObj.set("includesuborg", (Object)"1");
        roleScopeObj.set("source", (Object)"2");
        roleScopeObj.set("dimtype", (Object)"bos_org");
    }

    private void saveEntityPerm(RolePerm rolePerm) {
        if (!this.validateEntityPerm(rolePerm)) {
            return;
        }
        Map entityPermMap = rolePerm.getEntityNumberPermMap();
        log.info("NoCodePermissionServiceImpl.saveEntityPerm\u5f00\u59cb\u4fdd\u5b58\u5b9e\u4f53\u6743\u9650\u4fe1\u606f\uff1a{}", entityPermMap.keySet());
        int count = entityPermMap.size();
        HashMap<String, DataRule> entityDataRuleMap = new HashMap<String, DataRule>(count);
        HashMap<EntityPerm, Map<String, PermItem>> entityPermFieldMap = new HashMap<EntityPerm, Map<String, PermItem>>(count);
        DynamicObject rolePermObj = NoCodePermImplUtils.loadSingle("perm_roleperm", NoCodePermImplUtils.getRoleIdFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (rolePermObj == null) {
            rolePermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roleperm");
            rolePermObj.set("roleid", (Object)rolePerm.getId());
        }
        DynamicObject finalRolePermObj = rolePermObj;
        NoCodePermImplUtils.transHandle((IPermResult)rolePerm, objects -> {
            DynamicObjectCollection rolePermCol = finalRolePermObj.getDynamicObjectCollection("roleperm");
            NoCodePermImplUtils.clearEntryEntity(rolePermCol, null);
            for (Map.Entry entry : entityPermMap.entrySet()) {
                EntityPerm entityPerm = (EntityPerm)entry.getValue();
                DataRule dataRule = entityPerm.getDataRule();
                entityDataRuleMap.put((String)entry.getKey(), dataRule);
                this.genRolePermEntry(rolePerm, entityPerm, rolePermCol, entityPermFieldMap);
            }
            if (rolePermCol.isEmpty()) {
                this.deleteRoleFunctionPerm(NoCodePermImplUtils.toRoleIds((Role)rolePerm));
            } else {
                NoCodePermUtils.setDynamicObjectCommonProperty((DynamicObject)finalRolePermObj);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalRolePermObj});
            }
            return null;
        });
        this.saveRoleFieldPerm(rolePerm, entityPermFieldMap);
        this.saveDataRule(rolePerm, entityDataRuleMap);
    }

    private boolean validateEntityPerm(RolePerm rolePerm) {
        if (!rolePerm.isSuccess()) {
            return false;
        }
        Map entityPermMap = rolePerm.getEntityNumberPermMap();
        if (CollectionUtils.isEmpty((Map)entityPermMap)) {
            this.deleteEntityPerm(NoCodePermImplUtils.toRoleIds((Role)rolePerm));
            return true;
        }
        if (!(rolePerm.getAppUseType() != AppUseTypeEnum.VIEW_ALL && rolePerm.getAppUseType() != AppUseTypeEnum.OWN || entityPermMap.size() == 1 && entityPermMap.containsKey("perm_nocode_publicentity"))) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)rolePerm, ResManager.loadKDString((String)"\u5e94\u7528\u4f7f\u7528\u6743\u662f\u201c\u53ef\u4ee5\u4f7f\u7528\u81ea\u5df1\u5f55\u5165\u7684\u8868\u5355\u8bb0\u5f55\u201d\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u516c\u5171\u57fa\u7840\u8d44\u6599\u7684\u6743\u9650\u9879\u3002", (String)"NoCodePermissionServiceImpl_3", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void genRolePermEntry(RolePerm rolePerm, EntityPerm entityPerm, DynamicObjectCollection rolePermCol, Map<EntityPerm, Map<String, PermItem>> entityPermFieldMap) {
        Map permItemMap = entityPerm.getPermItemMap();
        for (Map.Entry permEntry : permItemMap.entrySet()) {
            PermItem permItem = (PermItem)permEntry.getValue();
            DynamicObject permItemObj = rolePermCol.addNew();
            permItemObj.set("entity", (Object)entityPerm.getEntityNumber());
            permItemObj.set("permitem", permEntry.getKey());
            permItemObj.set("bizapp", (Object)rolePerm.getAppId());
            permItemObj.set("droleid", (Object)rolePerm.getId());
            permItemObj.set("controlmode", (Object)"10");
            if (CollectionUtils.isEmpty((Collection)permItem.getNoPermProperties())) continue;
            entityPermFieldMap.computeIfAbsent(entityPerm, v -> new HashMap()).put(permEntry.getKey(), permItem);
        }
    }

    private void saveRoleFieldPerm(RolePerm rolePerm, Map<EntityPerm, Map<String, PermItem>> entityPermFieldMap) {
        String fieldPermId;
        if (CollectionUtils.isEmpty(entityPermFieldMap)) {
            this.deleteRoleFieldPerm(NoCodePermImplUtils.toRoleIds((Role)rolePerm));
            return;
        }
        DynamicObject fieldPermObj = null;
        DynamicObject roleFieldPermObj = NoCodePermImplUtils.loadSingle("perm_rolefieldperm", NoCodePermImplUtils.getRoleFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (roleFieldPermObj == null) {
            roleFieldPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolefieldperm");
            roleFieldPermObj.set("role", (Object)rolePerm.getId());
        } else {
            fieldPermId = roleFieldPermObj.getString("fieldperm_id");
            if (StringUtils.isNotBlank((CharSequence)fieldPermId)) {
                fieldPermObj = NoCodePermImplUtils.loadSingle((Object)fieldPermId, "perm_fieldperm");
            }
        }
        if (fieldPermObj == null) {
            fieldPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_fieldperm");
            fieldPermId = ORM.create().genStringId("perm_fieldperm");
            fieldPermObj.set("id", (Object)fieldPermId);
            fieldPermObj.set("number", (Object)fieldPermId);
            fieldPermObj.set("name", (Object)rolePerm.getName());
        }
        DynamicObject finalFieldPermObj = fieldPermObj;
        DynamicObject finalRoleFieldPermObj = roleFieldPermObj;
        NoCodePermImplUtils.transHandle((IPermResult)rolePerm, objects -> {
            DynamicObjectCollection fieldRuleCol = finalFieldPermObj.getDynamicObjectCollection("fieldrule");
            NoCodePermImplUtils.clearEntryEntity(fieldRuleCol, null);
            for (Map.Entry entry : entityPermFieldMap.entrySet()) {
                EntityPerm entityPerm = (EntityPerm)entry.getKey();
                Map permItemMap = (Map)entry.getValue();
                for (Map.Entry permEntry : permItemMap.entrySet()) {
                    PermItem permItem = (PermItem)permEntry.getValue();
                    for (String property : permItem.getNoPermProperties()) {
                        DynamicObject filedRuleObj = fieldRuleCol.addNew();
                        filedRuleObj.set("bizapp", (Object)rolePerm.getAppId());
                        filedRuleObj.set("entitytype", (Object)entityPerm.getEntityNumber());
                        filedRuleObj.set("permitem", permEntry.getKey());
                        filedRuleObj.set("fieldname", (Object)property);
                        filedRuleObj.set("rowcondition", (Object)"10");
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalFieldPermObj});
            finalRoleFieldPermObj.set("fieldperm", finalFieldPermObj.getPkValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalRoleFieldPermObj});
            return null;
        });
    }

    private void saveDataRule(RolePerm rolePerm, Map<String, DataRule> entityDataRuleMap) {
        log.info("NoCodePermissionServiceImpl.saveDataRule\u5f00\u59cb\u4fdd\u5b58\u6570\u636e\u89c4\u5219\uff1a{}", entityDataRuleMap.keySet());
        if (CollectionUtils.isEmpty(entityDataRuleMap)) {
            return;
        }
        DynamicObject roleDataRuleObj = this.getRoleDataRules(rolePerm);
        DynamicObject dataRulesObj = this.getDataRules(rolePerm, roleDataRuleObj);
        NoCodePermImplUtils.transHandle((IPermResult)rolePerm, object -> {
            this.saveDataRule(rolePerm, entityDataRuleMap, dataRulesObj);
            if (!roleDataRuleObj.getDataEntityState().getFromDatabase()) {
                roleDataRuleObj.set("datarules", dataRulesObj.getPkValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roleDataRuleObj});
            }
            return null;
        });
    }

    private DynamicObject getRoleDataRules(RolePerm rolePerm) {
        DynamicObject roleDataRuleObj = NoCodePermImplUtils.loadSingle("perm_roledatarules", NoCodePermImplUtils.getRoleFilters(NoCodePermImplUtils.toRoleIds((Role)rolePerm)));
        if (roleDataRuleObj == null) {
            roleDataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarules");
            long roleDataRuleId = ORM.create().genLongId("perm_roledatarules");
            roleDataRuleObj.set("id", (Object)roleDataRuleId);
            roleDataRuleObj.set("role", (Object)rolePerm.getId());
            NoCodePermUtils.setDynamicObjectMaintenance((DynamicObject)roleDataRuleObj);
        }
        return roleDataRuleObj;
    }

    private DynamicObject getDataRules(RolePerm rolePerm, DynamicObject roleDataRuleObj) {
        DynamicObject dataRulesObj = roleDataRuleObj.getDynamicObject("datarules");
        if (dataRulesObj == null) {
            dataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarules");
            long dataRulesId = ORM.create().genLongId("perm_datarules");
            dataRulesObj.set("id", (Object)dataRulesId);
            dataRulesObj.set("number", (Object)rolePerm.getId());
            dataRulesObj.set("name", (Object)rolePerm.getName());
            NoCodePermUtils.setDynamicObjectCommonProperty((DynamicObject)dataRulesObj);
        } else {
            dataRulesObj = NoCodePermImplUtils.loadSingle(dataRulesObj.getPkValue(), "perm_datarules");
        }
        return dataRulesObj;
    }

    private void saveDataRule(RolePerm rolePerm, Map<String, DataRule> entityDataRuleMap, DynamicObject dataRulesObj) {
        DynamicObjectCollection dataRulesEntity = dataRulesObj.getDynamicObjectCollection("entryentity");
        ArrayList<Long> roleDataRuleIds = new ArrayList<Long>(dataRulesEntity.size());
        NoCodePermImplUtils.clearEntryEntity(dataRulesEntity, params -> {
            DynamicObject entryObj = (DynamicObject)params[0];
            roleDataRuleIds.add(entryObj.getLong("datarule_id"));
            return roleDataRuleIds;
        });
        int count = entityDataRuleMap.size();
        Map<DataRuleTypeEnum, Map<String, DynamicObject>> typeEntityDataRuleObjMap = this.getEntityCommonDataRuleObjMap(rolePerm.getEntityNumberPermMap().keySet(), roleDataRuleIds);
        int index = 0;
        long[] ids = ORM.create().genLongIds("perm_datarule", count);
        ArrayList<DynamicObject> dataRuleObjList = new ArrayList<DynamicObject>(count);
        String emptyRule = this.getEmptyRule();
        DynamicObject dataRuleAppObj = null;
        Map<Object, DynamicObject> dataRuleEntityObjMap = null;
        DynamicObject dataRulesAppObj = null;
        Map<Object, DynamicObject> dataRulesEntityObjMap = null;
        for (Map.Entry<String, DataRule> dataRuleEntry : entityDataRuleMap.entrySet()) {
            long dataRuleId;
            String entityNumber = dataRuleEntry.getKey();
            DataRule dataRule = dataRuleEntry.getValue();
            DynamicObject dataRuleObj = null;
            Map<String, DynamicObject> entityDataRuleObjMap = typeEntityDataRuleObjMap.get(dataRule.getType());
            if (entityDataRuleObjMap != null) {
                dataRuleObj = entityDataRuleObjMap.get(entityNumber);
            }
            if (dataRuleObj == null) {
                dataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarule");
                dataRuleObjList.add(dataRuleObj);
                dataRuleId = ids[index++];
                dataRuleObj.set("id", (Object)dataRuleId);
                if (dataRuleAppObj == null) {
                    dataRuleAppObj = this.getDataRuleRefAppObj((Role)rolePerm, dataRuleObj);
                }
                if (dataRuleEntityObjMap == null) {
                    dataRuleEntityObjMap = this.getDataRuleRefEntityObj(entityDataRuleMap.keySet(), dataRuleObj);
                }
                this.convertDataRuleObj(dataRuleAppObj, dataRuleObj, dataRuleEntityObjMap, dataRuleEntry, emptyRule);
            } else {
                dataRuleId = dataRuleObj.getLong("id");
            }
            dataRule.setId(dataRuleId);
            DynamicObject dataRulesEntry = dataRulesEntity.addNew();
            if (dataRulesAppObj == null) {
                dataRulesAppObj = this.getDataRuleRefAppObj((Role)rolePerm, dataRulesEntry);
            }
            if (dataRulesEntityObjMap == null) {
                dataRulesEntityObjMap = this.getDataRuleRefEntityObj(entityDataRuleMap.keySet(), dataRulesEntry);
            }
            dataRulesEntry.set("bizapp", (Object)dataRulesAppObj);
            dataRulesEntry.set("entity", (Object)dataRulesEntityObjMap.get(entityNumber));
            dataRulesEntry.set("datarule", (Object)dataRuleObj);
        }
        if (!dataRuleObjList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dataRuleObjList.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRulesObj});
    }

    private void convertDataRuleObj(DynamicObject dataRuleAppObj, DynamicObject dataRuleObj, Map<Object, DynamicObject> dataRuleEntityObjMap, Map.Entry<String, DataRule> dataRuleEntry, String emptyRule) {
        long dataRuleId = dataRuleObj.getLong("id");
        dataRuleObj.set("bizapp", (Object)dataRuleAppObj);
        dataRuleObj.set("entity", (Object)dataRuleEntityObjMap.get(dataRuleEntry.getKey()));
        DataRule dataRule = dataRuleEntry.getValue();
        String number = "NOCODE-" + dataRule.getType().getValue() + dataRuleId;
        dataRuleObj.set("number", (Object)number);
        dataRuleObj.set("name", (Object)number);
        dataRuleObj.set("nocoderule", (Object)dataRule.toNoCodeRuleField());
        dataRuleObj.set("rule", (Object)emptyRule);
        dataRuleObj.set("isdetail", (Object)"1");
        NoCodePermUtils.setDynamicObjectCommonProperty((DynamicObject)dataRuleObj);
        DynamicObjectCollection dataRuleEntryCol = dataRuleObj.getDynamicObjectCollection("entryentity");
        DynamicObject dataRuleEntryObj = dataRuleEntryCol.addNew();
        dataRuleEntryObj.set("permitem", (Object)PermItemEnum.VIEW.getId());
        dataRuleEntryObj.set("datarule", (Object)dataRuleId);
    }

    private Map<Object, DynamicObject> getDataRuleRefEntityObj(Collection<String> entityIds, DynamicObject object) {
        DynamicObjectType refType = (DynamicObjectType)((BasedataProp)object.getDynamicObjectType().getProperty("entity")).getComplexType();
        return BusinessDataServiceHelper.loadFromCache((Object[])entityIds.toArray(new String[0]), (DynamicObjectType)refType);
    }

    private DynamicObject getDataRuleRefAppObj(Role role, DynamicObject object) {
        DynamicObjectType refType = (DynamicObjectType)((BasedataProp)object.getDynamicObjectType().getProperty("bizapp")).getComplexType();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)role.getAppId(), (DynamicObjectType)refType);
    }

    private String getEmptyRule() {
        FilterCondition emptyFilterCondition = new FilterCondition();
        return SerializationUtils.toJsonString((Object)emptyFilterCondition);
    }

    private Map<DataRuleTypeEnum, Map<String, DynamicObject>> getEntityCommonDataRuleObjMap(Collection entityIds, List<Long> roleDataRuleIds) {
        HashMap<DataRuleTypeEnum, Map<String, DynamicObject>> typeEntityDataRuleObjMap = new HashMap<DataRuleTypeEnum, Map<String, DynamicObject>>(entityIds.size());
        QFilter entityFilter = new QFilter("entity", "in", (Object)entityIds);
        QFilter[] filters = new QFilter[]{entityFilter};
        Map dataRuleMap = BusinessDataServiceHelper.loadFromCache((String)"perm_datarule", (QFilter[])filters);
        ArrayList<Long> deleteDataRuleIds = new ArrayList<Long>(roleDataRuleIds.size());
        for (Map.Entry entry : dataRuleMap.entrySet()) {
            String noCodeRule;
            DynamicObject dataRuleObj = (DynamicObject)entry.getValue();
            DynamicObject entityObj = dataRuleObj.getDynamicObject("entity");
            if (entityObj == null || StringUtils.isBlank((CharSequence)(noCodeRule = dataRuleObj.getString("nocoderule")))) continue;
            DataRule dataRule = DataRule.toDataRule((String)noCodeRule);
            if (dataRule.getType() == DataRuleTypeEnum.CUSTOM) {
                long id = dataRuleObj.getLong("id");
                if (!roleDataRuleIds.contains(id)) continue;
                deleteDataRuleIds.add(id);
                continue;
            }
            typeEntityDataRuleObjMap.computeIfAbsent(dataRule.getType(), v -> new HashMap(4)).put(entityObj.getString("id"), dataRuleObj);
        }
        if (!deleteDataRuleIds.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", deleteDataRuleIds);
            NoCodePermImplUtils.delete("perm_datarule", idFilter);
        }
        return typeEntityDataRuleObjMap;
    }

    public void deleteRole(Role role) {
        if (role == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)role, ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoCodePermissionServiceImpl_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return;
        }
        this.deleteRole(role, NoCodePermImplUtils.toRoleIds(role));
    }

    public void deleteRoleByAppId(Role role) {
        if (role == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)role.getAppId())) {
            NoCodePermImplUtils.addErrorPermResult((IPermResult)role, ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoCodePermissionServiceImpl_5", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = new QFilter[]{this.getRoleByAppIdFilter(Collections.singletonList(role.getAppId()))};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NoCodePermissionServiceImpl.deleteRoleByAppId.perm_role", (String)"perm_role", (String)"id", (QFilter[])filters, (String)"");){
            ArrayList<String> roleIds = new ArrayList<String>();
            for (Row row : dataSet) {
                roleIds.add(row.getString("id"));
            }
            this.deleteRole(role, roleIds);
        }
    }

    private void deleteRole(Role role, List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        HashMap<Object, IPermResult> roleMap = new HashMap<Object, IPermResult>(roleIds.size());
        for (String roleId : roleIds) {
            roleMap.put(roleId, (IPermResult)role);
        }
        log.info("NoCodePermissionServiceImpl.deleteRole\u8981\u6267\u884c\u5220\u9664\u7684\u89d2\u8272ID\uff1a{}", roleIds);
        NoCodePermImplUtils.transHandle((IPermResult)role, result -> {
            this.deleteRoleScope(roleIds);
            this.deleteEntityPerm(roleIds);
            return null;
        });
        if (role.isSuccess()) {
            Object[] roleIdArr = roleIds.toArray(new String[0]);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"nocodedelete", (String)"perm_role", (Object[])roleIdArr, (OperateOption)NoCodePermImplUtils.getOperateOption());
            NoCodePermImplUtils.convertPermResult(operationResult, roleMap);
            NoCodePermImplUtils.afterOperation("perm_role", "delete", true, roleIds);
        }
    }

    private void deleteRoleScope(List<String> roleIds) {
        NoCodePermImplUtils.delete("perm_userrole", NoCodePermImplUtils.getRoleFilter(roleIds));
    }

    private void deleteEntityPerm(List<String> roleIds) {
        this.deleteRoleFunctionPerm(roleIds);
        this.deleteRoleDataRule(roleIds);
        this.deleteRoleFieldPerm(roleIds);
    }

    private void deleteRoleFunctionPerm(List<String> roleIds) {
        NoCodePermImplUtils.delete("perm_roleperm", NoCodePermImplUtils.getRoleIdFilter(roleIds));
    }

    private void deleteRoleDataRule(List<String> roleIds) {
        DynamicObject roleDataRuleObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_roledatarules", (QFilter[])NoCodePermImplUtils.getRoleFilters(roleIds));
        if (roleDataRuleObj == null) {
            return;
        }
        NoCodePermImplUtils.delete((IDataEntityType)roleDataRuleObj.getDynamicObjectType(), new Object[]{roleDataRuleObj.getPkValue()});
        DynamicObject dataRulesObj = roleDataRuleObj.getDynamicObject("datarules");
        if (dataRulesObj == null) {
            return;
        }
        Object dataRulesId = dataRulesObj.getPkValue();
        if ((dataRulesObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataRulesId, (String)"perm_datarules")) == null) {
            return;
        }
        DynamicObjectCollection dataRulesEntity = dataRulesObj.getDynamicObjectCollection("entryentity");
        ArrayList<Long> dataRuleIds = new ArrayList<Long>(dataRulesEntity.size());
        for (DynamicObject entryObj : dataRulesEntity) {
            dataRuleIds.add(entryObj.getLong("datarule_id"));
        }
        this.deleteCustomDataRule(dataRuleIds);
        NoCodePermImplUtils.delete((IDataEntityType)dataRulesObj.getDynamicObjectType(), new Object[]{dataRulesId});
    }

    private void deleteCustomDataRule(List<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        ArrayList<Long> dataRuleIds = new ArrayList<Long>(ids.size());
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NoCodePermissionServiceImpl.deleteCustomDataRule.perm_datarule", (String)"perm_datarule", (String)"id,nocoderule", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                DataRule dataRule;
                String noCodeRule = row.getString("nocoderule");
                if (StringUtils.isBlank((CharSequence)noCodeRule) || (dataRule = DataRule.toDataRule((String)noCodeRule)).getType() != DataRuleTypeEnum.CUSTOM) continue;
                dataRuleIds.add(row.getLong("id"));
            }
        }
        if (!dataRuleIds.isEmpty()) {
            idFilter = new QFilter("id", "in", dataRuleIds);
            NoCodePermImplUtils.delete("perm_datarule", idFilter);
        }
    }

    private void deleteRoleFieldPerm(List<String> roleIds) {
        DynamicObject roleFieldPermObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_rolefieldperm", (QFilter[])NoCodePermImplUtils.getRoleFilters(roleIds));
        if (roleFieldPermObj == null) {
            return;
        }
        String fieldPermId = roleFieldPermObj.getString("fieldperm_id");
        NoCodePermImplUtils.delete("perm_fieldperm", new QFilter("id", "=", (Object)fieldPermId));
        NoCodePermImplUtils.delete("perm_rolefieldperm", new QFilter("id", "=", roleFieldPermObj.getPkValue()));
    }

    public Set<String> getManageAppIds(long userId) {
        Set<String> userRoleIds = this.getUserRoleIds(userId);
        QFilter userManageFilter = new QFilter("appmanagetype", "=", (Object)AppManageTypeEnum.ALL.getValue());
        Set<String> appIds = this.getAppIdsOfRole(userRoleIds, userManageFilter);
        log.debug("NoCodePermissionServiceImpl.getManageAppIds\u7528\u6237\uff08{}\uff09\u7ba1\u7406\u7684\u5e94\u7528\u6709\uff1a{}", (Object)userId, appIds);
        return appIds;
    }

    public Set<String> getUsableAppIds(long userId) {
        HashSet<String> usableAppIds = new HashSet<String>();
        Set<String> userRoleIds = this.getUserRoleIds(userId);
        if (userRoleIds.isEmpty()) {
            return usableAppIds;
        }
        QFilter userManageFilter = new QFilter("appmanagetype", "=", (Object)AppManageTypeEnum.ALL.getValue());
        userManageFilter = userManageFilter.or(new QFilter("appusetype", "in", (Object)new String[]{AppUseTypeEnum.ALL.getValue(), AppUseTypeEnum.VIEW_ALL.getValue()}));
        usableAppIds.addAll(this.getAppIdsOfRole(userRoleIds, userManageFilter));
        QFilter roleFilter = new QFilter("roleid", "in", userRoleIds);
        QFilter[] filters = new QFilter[]{roleFilter};
        Map rolePermObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_roleperm", (String)"roleperm.bizapp", (QFilter[])filters);
        for (Map.Entry entry : rolePermObjMap.entrySet()) {
            DynamicObjectCollection rolePermDetailCol = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("roleperm");
            for (DynamicObject rolePermDetailObj : rolePermDetailCol) {
                usableAppIds.add(rolePermDetailObj.getString("bizapp_id"));
            }
        }
        log.debug("NoCodePermissionServiceImpl.getUsableAppIds\u7528\u6237\uff08{}\uff09\u53ef\u7528\u7684\u5e94\u7528\u6709\uff1a{}", (Object)userId, usableAppIds);
        return usableAppIds;
    }

    private Set<String> getUserRoleIds(long userId) {
        return this.getUserRoleIds(userId, new ArrayList<String>(0));
    }

    private Set<String> getUserRoleIds(long userId, List<String> appIds) {
        if (userId == 0L) {
            return new HashSet<String>(0);
        }
        Set userOrgIds = UserServiceHelper.getDepartmentIncludeSuperior((long)userId);
        HashSet<String> roleIds = new HashSet<String>();
        QFilter groupFilter = new QFilter("role.group", "=", (Object)"3G8DIP1FPT8X");
        if (!CollectionUtils.isEmpty(appIds)) {
            groupFilter = groupFilter.and(new QFilter("role.bizdomain", "in", appIds));
        }
        groupFilter = groupFilter.and(new QFilter("role.enable", "=", (Object)Boolean.TRUE));
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter orgFilter = new QFilter("org", "in", (Object)userOrgIds);
        orgFilter = orgFilter.and(new QFilter("user", "=", (Object)0L));
        userFilter = userFilter.or(orgFilter);
        QFilter[] filters = new QFilter[]{groupFilter, userFilter};
        Map userRoleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_userrole", (String)"role", (QFilter[])filters);
        userRoleObjMap.entrySet().forEach(entry -> roleIds.add(((DynamicObject)entry.getValue()).getString("role_id")));
        log.debug("NoCodePermissionServiceImpl.getUserRoleIds\u7528\u6237\uff08{}\uff09\u5728\u5e94\u7528\uff08{}\uff09\u4e0b\u62e5\u6709\u7684\u89d2\u8272ID\uff1a{}", new Object[]{userId, appIds, roleIds});
        return roleIds;
    }

    private Set<String> getAppIdsOfRole(Set<String> userRoleIds, QFilter otherFilter) {
        if (userRoleIds.isEmpty()) {
            return new HashSet<String>(0);
        }
        HashSet<String> appIds = new HashSet<String>();
        QFilter idFilter = new QFilter("id", "in", userRoleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, enableFilter, otherFilter};
        Map roleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)"bizdomain", (QFilter[])filters);
        roleObjMap.entrySet().forEach(entry -> appIds.add(((DynamicObject)entry.getValue()).getString("bizdomain_id")));
        return appIds;
    }

    public PermResult applyPerm(Map<String, Set<String>> entityAppMap) {
        PermResult permResult = new PermResult();
        log.info("NoCodePermissionServiceImpl.applyPerm\u7533\u8bf7\u5b9e\u4f53\u6743\u9650\uff1a{}", entityAppMap);
        if (CollectionUtils.isEmpty(entityAppMap)) {
            return permResult;
        }
        Map<String, Set<String>> appliedEntityPerm = this.getAppliedEntityPerm(new ArrayList<String>(entityAppMap.keySet()));
        ArrayList<DynamicObject> addNewObjList = new ArrayList<DynamicObject>(entityAppMap.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_bizobjapp");
        for (Map.Entry<String, Set<String>> entry : entityAppMap.entrySet()) {
            String entity = entry.getKey();
            Set<String> appIds = entry.getValue();
            Set<String> appliedAppIds = appliedEntityPerm.get(entity);
            for (String appId : appIds) {
                if (appliedAppIds != null && appliedAppIds.contains(appId)) continue;
                DynamicObject instance = (DynamicObject)dataEntityType.createInstance();
                addNewObjList.add(instance);
                instance.set("bizobj", (Object)entity);
                instance.set("bizapp", (Object)appId);
            }
        }
        if (addNewObjList.isEmpty()) {
            return permResult;
        }
        SaveServiceHelper.save((DynamicObject[])addNewObjList.toArray(new DynamicObject[0]));
        NoCodePermImplUtils.afterOperation("perm_bizobjapp", "save", true, null);
        return permResult;
    }

    public PermResult deleteAppliedPerm(Map<String, Set<String>> entityAppMap) {
        log.info("NoCodePermissionServiceImpl.deleteAppliedPerm\u5220\u9664\u5b9e\u4f53\u6743\u9650\uff1a{}", entityAppMap);
        PermResult permResult = new PermResult();
        if (CollectionUtils.isEmpty(entityAppMap)) {
            return permResult;
        }
        QFilter entityFilter = new QFilter("bizobj", "in", entityAppMap.keySet());
        QFilter[] filters = new QFilter[]{entityFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NoCodePermissionServiceImpl.deleteAppliedPerm.perm_bizobjapp", (String)"perm_bizobjapp", (String)"id,bizobj,bizapp", (QFilter[])filters, (String)"");){
            ArrayList<Object> ids = new ArrayList<Object>(entityAppMap.size());
            for (Row row : dataSet) {
                Set<String> appIds = entityAppMap.get(row.getString("bizobj"));
                if (!CollectionUtils.isEmpty(appIds) && !appIds.contains(row.getString("bizapp"))) continue;
                ids.add(row.get("id"));
            }
            if (!ids.isEmpty()) {
                QFilter idFilter = new QFilter("id", "in", ids);
                NoCodePermImplUtils.delete("perm_bizobjapp", idFilter);
                NoCodePermImplUtils.afterOperation("perm_bizobjapp", "delete", true, null);
            }
        }
        return permResult;
    }

    public Map<String, Set<String>> getAppliedEntityPerm(List<String> entityNumberList) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> entityAppMap = new HashMap<String, Set<String>>(entityNumberList.size());
        QFilter entityFilter = new QFilter("bizobj", "in", entityNumberList);
        QFilter[] filters = new QFilter[]{entityFilter};
        Map objAppMap = BusinessDataServiceHelper.loadFromCache((String)"perm_bizobjapp", (String)"bizobj,bizapp", (QFilter[])filters);
        for (Map.Entry entry : objAppMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            entityAppMap.computeIfAbsent(obj.getString("bizobj_id"), k -> new HashSet()).add(obj.getString("bizapp_id"));
        }
        return entityAppMap;
    }

    public Map<String, Set<String>> getAppliedAppPerm(List<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> appEntityMap = new HashMap<String, Set<String>>(appIds.size());
        QFilter entityFilter = new QFilter("bizapp", "in", appIds);
        QFilter[] filters = new QFilter[]{entityFilter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_bizobjapp", (String)"bizobj,bizapp", (QFilter[])filters);
        objMap.entrySet().forEach(entry -> appEntityMap.computeIfAbsent(((DynamicObject)entry.getValue()).getString("bizapp_id"), k -> new HashSet()).add(((DynamicObject)entry.getValue()).getString("bizobj_id")));
        return appEntityMap;
    }

    private Set<String> getAppliedApIds(String entityNumber) {
        Map<String, Set<String>> appliedEntityPerm = this.getAppliedEntityPerm(Collections.singletonList(entityNumber));
        HashSet appliedApIds = appliedEntityPerm.get(entityNumber);
        return appliedApIds == null ? new HashSet(0) : appliedApIds;
    }

    public Set<String> getPermItems(long userId, String appId, String entityNumber) {
        log.debug("NoCodePermissionServiceImpl.getPermItems\u53c2\u6570\uff1a\u3010userId\u3011{}\u3010appId\u3011{}\u3010entityNumber\u3011{}", new Object[]{userId, appId, entityNumber});
        if (userId == 0L || StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashSet<String>(0);
        }
        NoCodeRolePermMerger merger = new NoCodeRolePermMerger(this.getRoles(userId, appId, entityNumber, RoleTypeEnum.APP));
        merger.merge();
        Map<String, Role> customRoleMap = merger.getCustomRoleMap();
        if (merger.isAll()) {
            log.debug("NoCodePermissionServiceImpl.getPermItems\u62e5\u6709\u5168\u90e8\u6743\u9650\u9879\uff1a\u3010appId\u3011{}\u3010entityNumber\u3011{}", (Object)appId, (Object)entityNumber);
            return PermItemEnum.getIds();
        }
        if (customRoleMap.isEmpty()) {
            log.debug("NoCodePermissionServiceImpl.getPermItems\u6ca1\u6709\u4efb\u4f55\u6743\u9650\u9879\uff1a\u3010appId\u3011{}\u3010entityNumber\u3011{}", (Object)appId, (Object)entityNumber);
            return new HashSet<String>(0);
        }
        HashSet<String> permItems = new HashSet<String>(PermItemEnum.values().length);
        this.getPermItems(appId, merger.mergeForms(entityNumber), customRoleMap, null, permItems);
        return permItems;
    }

    private void getPermItems(String appId, Set<String> entityNumbers, Map<String, Role> customRoleMap, Map<String, List<String>> rolePermItemMap, Set<String> permItems) {
        QFilter roleFilter = new QFilter("roleid", "in", customRoleMap.keySet());
        QFilter[] filters = new QFilter[]{roleFilter};
        String selectProperties = "roleperm.permitem,roleperm.bizapp,roleperm.entity,roleperm.droleid";
        Map rolePermObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_roleperm", (String)selectProperties, (QFilter[])filters);
        for (Map.Entry entry : rolePermObjMap.entrySet()) {
            DynamicObjectCollection rolePermDetailCol = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("roleperm");
            for (DynamicObject rolePermDetailObj : rolePermDetailCol) {
                if (!entityNumbers.contains(rolePermDetailObj.getString("entity_id")) || StringUtils.isNotBlank((CharSequence)appId) && !Objects.equals(appId, rolePermDetailObj.getString("bizapp_id"))) continue;
                String permItem = rolePermDetailObj.getString("permitem_id");
                if (rolePermItemMap != null) {
                    rolePermItemMap.computeIfAbsent(rolePermDetailObj.getString("droleid"), v -> new ArrayList()).add(permItem);
                }
                if (permItems == null) continue;
                permItems.add(permItem);
            }
        }
        log.debug("NoCodePermissionServiceImpl.getPermItems\u6743\u9650\u9879\uff1a\u3010appId\u3011{}\u3010entityNumber\u3011{}\u3010\u89d2\u8272\u6743\u9650\u9879\u3011{}", new Object[]{appId, entityNumbers, rolePermItemMap == null ? permItems : rolePermItemMap});
    }

    public QFilter getDataRuleFilter(long userId, String appId, String entityNumber) {
        return this.getDataRuleFilter(userId, appId, entityNumber, null);
    }

    public QFilter getDataRuleFilter(long userId, String entityNumber, PermItemEnum permItem) {
        return this.getDataRuleFilter(userId, "", entityNumber, permItem);
    }

    private QFilter getDataRuleFilter(long userId, String appId, String entityNumber, PermItemEnum permItem) {
        if (permItem == null) {
            permItem = PermItemEnum.VIEW;
        }
        Map<String, QFilter> dataRuleFilters = this.getDataRuleFilters(userId, appId, entityNumber, Collections.singletonList(permItem.getId()));
        return dataRuleFilters.get(permItem.getId());
    }

    public Map<String, QFilter> getDataRuleFilters(long userId, String entityNumber, List<String> permItemIds) {
        return this.getDataRuleFilters(userId, "", entityNumber, permItemIds);
    }

    private Map<String, QFilter> getDataRuleFilters(long userId, String appId, String entityNumber, List<String> permItemIds) {
        log.debug("NoCodePermissionServiceImpl.getDataRuleFilter\u53c2\u6570\uff1a\u3010userId\u3011{}\u3010appId\u3011{}\u3010entityNumber\u3011{}\u3010permItem\u3011{}", new Object[]{userId, appId, entityNumber, permItemIds});
        if (userId == 0L || StringUtils.isBlank((CharSequence)entityNumber) || CollectionUtils.isEmpty(permItemIds)) {
            return new HashMap<String, QFilter>();
        }
        List<Role> roleList = this.getRoles(userId, appId, entityNumber, RoleTypeEnum.APP);
        return this.getDataRuleFilters(roleList, appId, entityNumber, permItemIds, null);
    }

    private Map<String, QFilter> getDataRuleFilters(List<Role> roleList, String appId, String entityNumber, List<String> permItemIds, Set<Long> sysRoleFilterValues) {
        HashMap<String, QFilter> permItemFilterMap = new HashMap<String, QFilter>(permItemIds.size());
        if (roleList.isEmpty()) {
            permItemIds.forEach(permItemId -> permItemFilterMap.put((String)permItemId, NoCodePermImplUtils.getNoPermissionFilter()));
            return permItemFilterMap;
        }
        NoCodeRolePermMerger merger = new NoCodeRolePermMerger(roleList);
        merger.merge();
        Map<String, Role> customRoleMap = merger.getCustomRoleMap();
        if (merger.isAll()) {
            log.debug("NoCodePermissionServiceImpl.getDataRuleFilter\u62e5\u6709\u5168\u90e8\u6570\u636e\u6743\u9650\u3002");
            permItemIds.forEach(permItemId -> {
                QFilter cfr_ignored_0 = permItemFilterMap.put((String)permItemId, (QFilter)null);
            });
            return permItemFilterMap;
        }
        if (customRoleMap.isEmpty()) {
            permItemIds.forEach(permItemId -> permItemFilterMap.put((String)permItemId, NoCodePermImplUtils.getNoPermissionFilter()));
            log.debug("NoCodePermissionServiceImpl.getDataRuleFilter\u6ca1\u6709\u4efb\u4f55\u6570\u636e\u6743\u9650\u3002");
            return permItemFilterMap;
        }
        boolean isSystemRole = sysRoleFilterValues != null;
        Set<String> entityNumbers = merger.mergeForms(entityNumber);
        HashMap<String, List<String>> rolePermItemMap = new HashMap<String, List<String>>(customRoleMap.size());
        HashSet<String> hasPermItemIds = new HashSet<String>(PermItemEnum.values().length);
        if (isSystemRole) {
            hasPermItemIds.addAll(permItemIds);
        } else {
            this.getPermItems(appId, entityNumbers, customRoleMap, rolePermItemMap, hasPermItemIds);
            hasPermItemIds.retainAll(permItemIds);
            permItemIds.forEach(permItemId -> {
                if (!hasPermItemIds.contains(permItemId)) {
                    permItemFilterMap.put((String)permItemId, NoCodePermImplUtils.getNoPermissionFilter());
                }
            });
            if (hasPermItemIds.isEmpty()) {
                return permItemFilterMap;
            }
        }
        Map<Long, String> dataRulesRoleMap = this.getDataRulesRoleMap(customRoleMap);
        Map<String, List<DataRule>> roleDataRuleMap = null;
        if (!dataRulesRoleMap.isEmpty()) {
            roleDataRuleMap = this.getRoleDataRuleMap(appId, entityNumbers, dataRulesRoleMap);
        }
        if (roleDataRuleMap == null || roleDataRuleMap.isEmpty()) {
            hasPermItemIds.forEach(permItemId -> {
                QFilter cfr_ignored_0 = permItemFilterMap.put((String)permItemId, (QFilter)null);
            });
            log.debug("NoCodePermissionServiceImpl.getDataRuleFilter\u81ea\u5b9a\u4e49\u89d2\u8272\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u89c4\u5219\uff1a" + permItemFilterMap);
            return permItemFilterMap;
        }
        for (String permItemId2 : hasPermItemIds) {
            HashSet<String> rules = new HashSet<String>();
            for (Map.Entry<String, List<DataRule>> roleEntry : roleDataRuleMap.entrySet()) {
                List hasRolePermItemIds;
                if (!isSystemRole && ((hasRolePermItemIds = (List)rolePermItemMap.get(roleEntry.getKey())) == null || !hasRolePermItemIds.contains(permItemId2))) continue;
                this.getDataRule(rules, roleEntry.getValue(), permItemId2, permItemFilterMap, isSystemRole);
            }
            if (permItemFilterMap.containsKey(permItemId2)) continue;
            permItemFilterMap.put(permItemId2, this.convertDataRuleFilter(entityNumber, rules, sysRoleFilterValues));
        }
        log.debug("NoCodePermissionServiceImpl.getDataRuleFilter\u6743\u9650\u9879\u6570\u636e\u89c4\u5219\u8fc7\u6ee4\u6761\u4ef6\uff1a " + permItemFilterMap);
        return permItemFilterMap;
    }

    private void getDataRule(Set<String> rules, List<DataRule> dataRuleList, String permItemId, Map<String, QFilter> permItemFilterMap, boolean isSystemRole) {
        for (DataRule dataRule : dataRuleList) {
            if (!isSystemRole) {
                if (dataRule.getType() == DataRuleTypeEnum.ALL) {
                    permItemFilterMap.put(permItemId, null);
                    break;
                }
                if (this.isViewAllFilter(dataRule, permItemId)) {
                    permItemFilterMap.put(permItemId, null);
                    break;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)dataRule.getNoCodeRule())) continue;
            rules.add(dataRule.getNoCodeRule());
        }
    }

    private Map<Long, String> getDataRulesRoleMap(Map<String, Role> customRoleMap) {
        HashMap<Long, String> dataRulesRoleMap = new HashMap<Long, String>(customRoleMap.size());
        QFilter roleFilter = new QFilter("role", "in", customRoleMap.keySet());
        QFilter[] filters = new QFilter[]{roleFilter};
        Map permDataRulesObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_roledatarules", (String)"role,datarules", (QFilter[])filters);
        for (Map.Entry entry : permDataRulesObjMap.entrySet()) {
            DynamicObject permDataRulesObj = (DynamicObject)entry.getValue();
            dataRulesRoleMap.put(permDataRulesObj.getLong("datarules_id"), permDataRulesObj.getString("role_id"));
        }
        return dataRulesRoleMap;
    }

    private Map<String, List<DataRule>> getRoleDataRuleMap(String appId, Set<String> entityNumbers, Map<Long, String> dataRuleRoleMap) {
        HashMap<String, List<DataRule>> roleDataRuleMap = new HashMap<String, List<DataRule>>(dataRuleRoleMap.size());
        QFilter idFilter = new QFilter("id", "in", dataRuleRoleMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter};
        String selectProperties = "entryentity.datarule,entryentity.bizapp,entryentity.entity";
        Map dataRulesObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_datarules", (String)selectProperties, (QFilter[])filters);
        for (Map.Entry entry : dataRulesObjMap.entrySet()) {
            DynamicObject dataRulesObj = (DynamicObject)entry.getValue();
            String roleId = dataRuleRoleMap.get(dataRulesObj.getPkValue());
            DynamicObjectCollection entryEntityObjCol = dataRulesObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntityObj : entryEntityObjCol) {
                DynamicObject dataRuleObj;
                if (!entityNumbers.contains(entryEntityObj.getString("entity_id")) || StringUtils.isNotBlank((CharSequence)appId) && !Objects.equals(appId, entryEntityObj.getString("bizapp_id")) || (dataRuleObj = entryEntityObj.getDynamicObject("datarule")) == null) continue;
                DataRule dataRule = DataRule.toDataRule((String)dataRuleObj.getString("nocoderule"));
                roleDataRuleMap.computeIfAbsent(roleId, v -> new ArrayList()).add(dataRule);
            }
        }
        return roleDataRuleMap;
    }

    private boolean isViewAllFilter(DataRule dataRule, String permItemId) {
        if (dataRule.getType() != DataRuleTypeEnum.VIEW_ALL) {
            return false;
        }
        return Objects.equals(permItemId, PermItemEnum.VIEW.getId()) || ((List)PermItemEnum.getSubPermItemMap().get(PermItemEnum.VIEW.getId())).contains(permItemId);
    }

    private QFilter convertDataRuleFilter(String entityNumber, Set<String> rules, Set<Long> noCodeFilterValues) {
        if (CollectionUtils.isEmpty(rules)) {
            return null;
        }
        QFilter dataRuleFilter = null;
        NoCodeRuntimeService noCodeRuntimeService = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        for (String rule : rules) {
            QFilter noCodeFilter = noCodeRuntimeService.getQFilter(entityNumber, rule);
            if (noCodeFilter == null) continue;
            dataRuleFilter = dataRuleFilter == null ? noCodeFilter : dataRuleFilter.or(noCodeFilter);
            this.convertDataRuleFilterValue(noCodeFilterValues, noCodeFilter);
        }
        return dataRuleFilter;
    }

    private void convertDataRuleFilterValue(Set<Long> noCodeFilterValues, QFilter noCodeFilter) {
        if (noCodeFilterValues == null || noCodeFilter == null) {
            return;
        }
        if (!Objects.equals("id", noCodeFilter.getProperty()) || !Objects.equals("in", noCodeFilter.getCP())) {
            return;
        }
        Object filterValue = noCodeFilter.getValue();
        if (!(filterValue instanceof Collection)) {
            List nests = noCodeFilter.getNests(false);
            if (CollectionUtils.isEmpty((Collection)nests)) {
                return;
            }
            for (QFilter.QFilterNest nest : nests) {
                this.convertDataRuleFilterValue(noCodeFilterValues, nest.getFilter());
            }
            return;
        }
        ((Collection)filterValue).forEach(v -> {
            if (v != null) {
                if (v instanceof Long) {
                    noCodeFilterValues.add((Long)v);
                } else {
                    noCodeFilterValues.add(Long.valueOf(v.toString()));
                }
            }
        });
    }

    public Map<String, Set<String>> getNoPermProperties(long userId, String appId, String entityNumber) {
        log.debug("NoCodePermissionServiceImpl.getNoPermProperties\u53c2\u6570\uff1a\u3010userId\u3011{}\u3010appId\u3011{}\u3010entityNumber\u3011{}", new Object[]{userId, appId, entityNumber});
        if (userId == 0L || StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<String, Set<String>>(0);
        }
        List<Role> roleList = this.getRoles(userId, appId, entityNumber, RoleTypeEnum.APP);
        NoCodeRolePermMerger merger = new NoCodeRolePermMerger(roleList, true, true);
        merger.merge();
        Map<String, Role> customRoleMap = merger.getCustomRoleMap();
        if (merger.isAll() || customRoleMap.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Map<String, Set<String>>> permItemRolePropertiesMap = new HashMap<String, Map<String, Set<String>>>(customRoleMap.size());
        Map<String, Set<String>> fieldPermRoleMap = this.getFieldPermIds(customRoleMap, permItemRolePropertiesMap);
        if (fieldPermRoleMap.isEmpty() || this.isEntityCustomRoleExists(entityNumber, customRoleMap)) {
            return new HashMap<String, Set<String>>(0);
        }
        boolean notExistsFieldPermRecord = true;
        QFilter idFilter = new QFilter("id", "in", fieldPermRoleMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter};
        String selectFields = "id,fieldrule.permitem,fieldrule.fieldname,fieldrule.entitytype,fieldrule.bizapp,fieldrule.rowcondition";
        Map fieldPermObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_fieldperm", (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : fieldPermObjMap.entrySet()) {
            DynamicObject fieldPermObj = (DynamicObject)entry.getValue();
            String id = fieldPermObj.getString("id");
            Set<String> roleIds = fieldPermRoleMap.get(id);
            if (roleIds == null) continue;
            DynamicObjectCollection detailObjCol = fieldPermObj.getDynamicObjectCollection("fieldrule");
            for (DynamicObject detailObj : detailObjCol) {
                String permItemId;
                Map rolePropertiesMap;
                if (!Objects.equals(detailObj.getString("rowcondition"), "10") || !Objects.equals(detailObj.getString("entitytype_id"), entityNumber) || StringUtils.isNotBlank((CharSequence)appId) && !Objects.equals(detailObj.getString("bizapp_id"), appId) || (rolePropertiesMap = (Map)permItemRolePropertiesMap.get(permItemId = detailObj.getString("permitem_id"))) == null) continue;
                String property = detailObj.getString("fieldname");
                for (String roleId : roleIds) {
                    Set properties = (Set)rolePropertiesMap.get(roleId);
                    if (properties == null) continue;
                    properties.add(property);
                    notExistsFieldPermRecord = false;
                }
            }
        }
        return notExistsFieldPermRecord ? new HashMap(0) : this.getNoPermProperties(permItemRolePropertiesMap);
    }

    private boolean isEntityCustomRoleExists(String entityNumber, Map<String, Role> customRoleMap) {
        if (customRoleMap.isEmpty()) {
            return false;
        }
        QFilter entityFilter = new QFilter("roleperm.entity", "=", (Object)entityNumber);
        QFilter roleFilter = new QFilter("roleperm.droleid", "in", customRoleMap.keySet());
        QFilter[] filters = new QFilter[]{entityFilter, roleFilter};
        return QueryServiceHelper.exists((String)"perm_roleperm", (QFilter[])filters);
    }

    private Map<String, Set<String>> getFieldPermIds(Map<String, Role> customRoleMap, Map<String, Map<String, Set<String>>> rolePermItemPropertiesMap) {
        HashMap<String, Set<String>> fieldPermRoleMap = new HashMap<String, Set<String>>();
        QFilter roleFilter = new QFilter("role", "in", customRoleMap.keySet());
        QFilter[] filters = new QFilter[]{roleFilter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_rolefieldperm", (String)"role,fieldperm", (QFilter[])filters);
        for (Map.Entry entry : objMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            String roleId = obj.getString("role_id");
            String fieldPermId = obj.getString("fieldperm_id");
            fieldPermRoleMap.computeIfAbsent(fieldPermId, v -> new HashSet()).add(roleId);
            customRoleMap.remove(roleId);
            for (PermItemEnum permItemEnum : PermItemEnum.values()) {
                Map rolePropertiesMap = rolePermItemPropertiesMap.computeIfAbsent(permItemEnum.getId(), v -> new HashMap(customRoleMap.size()));
                rolePropertiesMap.put(roleId, new HashSet());
            }
        }
        return fieldPermRoleMap;
    }

    private Map<String, Set<String>> getNoPermProperties(Map<String, Map<String, Set<String>>> permItemRolePropertiesMap) {
        HashMap<String, Set<String>> noPermPropertyMap = new HashMap<String, Set<String>>(PermItemEnum.values().length);
        Map subPermItemMap = PermItemEnum.getSubPermItemMap();
        for (Map.Entry<String, Map<String, Set<String>>> permItemEntry : permItemRolePropertiesMap.entrySet()) {
            Set<String> properties = null;
            Map<String, Set<String>> rolePropertiesMap = permItemEntry.getValue();
            for (Map.Entry<String, Set<String>> ruleEntry : rolePropertiesMap.entrySet()) {
                if (properties == null) {
                    properties = ruleEntry.getValue();
                    continue;
                }
                properties.retainAll((Collection)ruleEntry.getValue());
                if (!properties.isEmpty()) continue;
                break;
            }
            if (CollectionUtils.isEmpty(properties)) continue;
            String permItemId = permItemEntry.getKey();
            noPermPropertyMap.put(permItemId, properties);
            List subPermItemIds = (List)subPermItemMap.get(permItemId);
            if (CollectionUtils.isEmpty((Collection)subPermItemIds)) continue;
            for (String subPermItemId : subPermItemIds) {
                noPermPropertyMap.put(subPermItemId, properties);
            }
        }
        if (!noPermPropertyMap.isEmpty()) {
            log.info("NoCodePermissionServiceImpl.getNoPermProperties\u64cd\u4f5c\u4e0b\u65e0\u6743\u9650\u7684\u5c5e\u6027\uff1a" + noPermPropertyMap);
        }
        return noPermPropertyMap;
    }

    public Map<String, Map<String, Set<String>>> getAuthorizedAppEntityNumbers(long userId, List<String> permItemIds) {
        List<Role> roleList = this.getRoleByUserId(userId);
        if (CollectionUtils.isEmpty(roleList)) {
            return new HashMap<String, Map<String, Set<String>>>(0);
        }
        int roleCount = roleList.size();
        HashMap<String, Map<String, Set<String>>> appEntityPermItemMap = new HashMap<String, Map<String, Set<String>>>(roleCount);
        HashMap<String, List> appRoleMap = new HashMap<String, List>(roleCount);
        for (Role role : roleList) {
            if (AppManageTypeEnum.ALL == role.getAppManageType() || AppUseTypeEnum.ALL == role.getAppUseType()) {
                appEntityPermItemMap.put(role.getAppId(), new HashMap(0));
                continue;
            }
            if (this.hasAllEntityPerm(role.getAppId(), appEntityPermItemMap)) {
                appRoleMap.remove(role.getAppId());
                continue;
            }
            appRoleMap.computeIfAbsent(role.getAppId(), v -> new ArrayList(roleCount)).add(role.getId());
        }
        if (appRoleMap.isEmpty()) {
            return appEntityPermItemMap;
        }
        ArrayList authorizedRoleIds = new ArrayList(roleCount);
        for (Map.Entry entry2 : appRoleMap.entrySet()) {
            authorizedRoleIds.addAll((Collection)entry2.getValue());
        }
        if (authorizedRoleIds.isEmpty()) {
            return appEntityPermItemMap;
        }
        QFilter qFilter = new QFilter("roleid", "in", authorizedRoleIds);
        QFilter[] qFilterArray = new QFilter[]{qFilter};
        String selectFields = "roleperm.bizapp,roleperm.entity,roleperm.permitem";
        Map rolePermObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_roleperm", (String)selectFields, (QFilter[])qFilterArray);
        rolePermObjMap.entrySet().forEach(entry -> {
            DynamicObjectCollection rolePermDetailCol = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("roleperm");
            for (DynamicObject rolePermDetailObj : rolePermDetailCol) {
                String appId = rolePermDetailObj.getString("bizapp_id");
                if (this.hasAllEntityPerm(appId, appEntityPermItemMap)) {
                    return;
                }
                String permItemId = rolePermDetailObj.getString("permitem_id");
                if (!CollectionUtils.isEmpty((Collection)permItemIds) && !permItemIds.contains(permItemId)) continue;
                String entityNumber = rolePermDetailObj.getString("entity_id");
                Map entityPermItemMap = appEntityPermItemMap.computeIfAbsent(appId, v -> new HashMap());
                entityPermItemMap.computeIfAbsent(entityNumber, v -> new HashSet()).add(permItemId);
            }
        });
        return appEntityPermItemMap;
    }

    private boolean hasAllEntityPerm(String appId, Map<String, Map<String, Set<String>>> appEntityNumberMap) {
        Map<String, Set<String>> entityPermItemMap = appEntityNumberMap.get(appId);
        return entityPermItemMap != null && entityPermItemMap.isEmpty();
    }

    public Map<String, Boolean> checkMultiPermItemInfos(long userId, String entityNumber, Set<String> pPermItems) {
        log.debug("NoCodePermissionServiceImpl.checkMultiPermItemInfos\u53c2\u6570\uff1a\u3010userId\u3011{}\u3010entityNumber\u3011{}\u3010permItems\u3011{}", new Object[]{userId, entityNumber, pPermItems});
        if (userId == 0L || StringUtils.isBlank((CharSequence)entityNumber) || CollectionUtils.isEmpty(pPermItems)) {
            return new HashMap<String, Boolean>(0);
        }
        HashSet<String> allCheckPermAppIds = new HashSet<String>(8);
        String originalAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        allCheckPermAppIds.add(originalAppId);
        ArrayList<String> entityNumbers = new ArrayList<String>(1);
        entityNumbers.add(entityNumber);
        Map<String, Set<String>> appliedEntityPerm = this.getAppliedEntityPerm(entityNumbers);
        for (Map.Entry<String, Set<String>> entry : appliedEntityPerm.entrySet()) {
            allCheckPermAppIds.addAll((Collection)entry.getValue());
        }
        HashMap<String, Boolean> permItemMap = new HashMap<String, Boolean>(pPermItems.size());
        for (String appId : allCheckPermAppIds) {
            Map<String, Boolean> appPermItemMap = this.checkMultiPermItemInfos(userId, appId, entityNumber, pPermItems);
            boolean isAllPermItemAuthorized = true;
            for (Map.Entry<String, Boolean> entry : appPermItemMap.entrySet()) {
                Boolean hasPermission = (Boolean)permItemMap.get(entry.getKey());
                if (hasPermission != null && hasPermission.booleanValue()) continue;
                hasPermission = entry.getValue();
                permItemMap.put(entry.getKey(), hasPermission);
                if (hasPermission.booleanValue()) continue;
                isAllPermItemAuthorized = false;
            }
            if (!isAllPermItemAuthorized) continue;
            break;
        }
        return permItemMap;
    }

    public Map<String, Boolean> checkMultiPermItemInfos(long userId, String appId, String entityNumber, Set<String> pPermItems) {
        log.debug("NoCodePermissionServiceImpl.checkMultiPermItemInfos\u53c2\u6570\uff1a\u3010userId\u3011{}\u3010appId\u3011{}\u3010entityNumber\u3011{}\u3010permItems\u3011{}", new Object[]{userId, appId, entityNumber, pPermItems});
        if (userId == 0L || StringUtils.isBlank((CharSequence)entityNumber) || CollectionUtils.isEmpty(pPermItems)) {
            return new HashMap<String, Boolean>(0);
        }
        HashMap<String, Boolean> permItemMap = new HashMap<String, Boolean>(pPermItems.size());
        Set ids = PermItemEnum.getIds();
        boolean hasNoCodePermItem = false;
        for (String permItem : pPermItems) {
            if (ids.contains(permItem)) {
                hasNoCodePermItem = true;
                permItemMap.put(permItem, Boolean.FALSE);
                continue;
            }
            permItemMap.put(permItem, Boolean.TRUE);
        }
        if (!hasNoCodePermItem || StringUtils.isBlank((CharSequence)appId)) {
            return permItemMap;
        }
        Set<String> permItemSet = this.getPermItems(userId, appId, entityNumber);
        if (CollectionUtils.isEmpty(permItemSet)) {
            return permItemMap;
        }
        for (Map.Entry entry : permItemMap.entrySet()) {
            String permItem = (String)entry.getKey();
            Boolean hasPermission = permItemSet.remove(permItem);
            if (hasPermission == null) continue;
            permItemMap.put(permItem, Boolean.TRUE);
        }
        return permItemMap;
    }

    public Map<Object, Boolean> checkOperationRule(Long userId, String entityNum, String operationKey, List<Object> pkIds, StringBuilder sbNotMatchTips) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return new HashMap<Object, Boolean>(0);
        }
        HashMap<Object, Boolean> pkPermissionMap = new HashMap<Object, Boolean>(pkIds.size());
        for (Object pk : pkIds) {
            pkPermissionMap.put(pk, Boolean.TRUE);
        }
        return pkPermissionMap;
    }

    public QFilter getSystemRoleOrgFilter(long userId, boolean includeSubOrg) {
        return this.getFilterByIds(this.getSystemRoleOrgIds(userId, includeSubOrg));
    }

    public Set<Long> getSystemRoleOrgIds(long userId, boolean includeSubOrg) {
        HashSet<Object> orgIds = null;
        List<Role> roleList = this.getSystemRoleByUserId(userId);
        ArrayList<Long> configOrgIds = new ArrayList<Long>();
        DataRuleTypeEnum orgDataRuleType = this.getSystemRoleOrgFilterIds(configOrgIds, roleList, includeSubOrg);
        switch (orgDataRuleType) {
            case ALL: 
            case VIEW_ALL: {
                break;
            }
            case CUSTOM: {
                orgIds = new HashSet<Long>(configOrgIds);
                break;
            }
            default: {
                orgIds = new HashSet();
            }
        }
        return orgIds;
    }

    private QFilter getFilterByIds(Set<Long> ids) {
        if (ids == null) {
            return null;
        }
        if (ids.isEmpty()) {
            return NoCodePermImplUtils.getNoPermissionFilter();
        }
        return new QFilter("id", "in", ids);
    }

    private DataRuleTypeEnum getSystemRoleOrgFilterIds(List<Long> orgIds, List<Role> roleList, boolean includeSubOrg) {
        if (roleList.isEmpty()) {
            return DataRuleTypeEnum.OWN;
        }
        for (Role role : roleList) {
            if (AppManageTypeEnum.ALL != role.getAppManageType()) continue;
            return DataRuleTypeEnum.ALL;
        }
        Set<Long> filterOrgIds = this.getSystemRoleFilter(roleList, "perm_nocode_orgentity");
        if (filterOrgIds.isEmpty()) {
            return DataRuleTypeEnum.OWN;
        }
        if (filterOrgIds.contains(OrgUnitServiceHelper.getRootOrgId())) {
            return DataRuleTypeEnum.VIEW_ALL;
        }
        if (includeSubOrg) {
            orgIds.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, new ArrayList<Long>(filterOrgIds), (boolean)true, (boolean)false));
        } else {
            orgIds.addAll(filterOrgIds);
        }
        return DataRuleTypeEnum.CUSTOM;
    }

    public QFilter getSystemRoleUserFilter(long userId, boolean includeSubOrg) {
        return this.getFilterByIds(this.getSystemRoleUserIds(userId, includeSubOrg));
    }

    public Set<Long> getSystemRoleUserIds(long userId, boolean includeSubOrg) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        List<Role> roleList = this.getSystemRoleByUserId(userId);
        DataRuleTypeEnum orgDataRuleType = this.getSystemRoleOrgFilterIds(orgIds, roleList, includeSubOrg);
        if (orgDataRuleType == DataRuleTypeEnum.ALL || orgDataRuleType == DataRuleTypeEnum.VIEW_ALL) {
            return null;
        }
        Set<Long> userIds = this.getSystemRoleFilter(roleList, "perm_nocode_userentity");
        if (!orgIds.isEmpty()) {
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            Map userPositionMap = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (String)"user", (QFilter[])new QFilter[]{orgFilter});
            userPositionMap.entrySet().forEach(entry -> userIds.add(((DynamicObject)entry.getValue()).getLong("user_id")));
        }
        return userIds;
    }

    private Set<Long> getSystemRoleFilter(List<Role> roleList, String entity) {
        String permItemId = PermItemEnum.VIEW.getId();
        HashSet<Long> sysRoleFilterValues = new HashSet<Long>();
        this.getDataRuleFilters(roleList, "", entity, Collections.singletonList(permItemId), sysRoleFilterValues);
        return sysRoleFilterValues;
    }
}

