/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.nocode.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.api.IPermHandler;
import kd.bos.permission.nocode.api.IPermResult;
import kd.bos.permission.nocode.model.Role;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class NoCodePermImplUtils {
    private static final Log log = LogFactory.getLog(NoCodePermImplUtils.class);
    public static final String OPERATION_NOCODE_SAVE = "nocodesave";
    public static final String OPERATION_NOCODE_DELETE = "nocodedelete";

    private NoCodePermImplUtils() {
    }

    public static OperateOption getOperateOption() {
        String skipCheckPermission = Boolean.toString(true);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", skipCheckPermission);
        operateOption.setVariableValue("skipCheckDataPermission", skipCheckPermission);
        operateOption.setVariableValue("skipCheckSpecialDataPermission", skipCheckPermission);
        return operateOption;
    }

    public static void convertPermResult(OperationResult operationResult, Map<Object, IPermResult> permResultMap) {
        List errorInfoList;
        if (operationResult == null || CollectionUtils.isEmpty(permResultMap)) {
            return;
        }
        List ids = operationResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            for (Object pk : ids) {
                IPermResult permParam = permResultMap.get(pk);
                if (permParam == null) continue;
                permParam.setSuccess(true);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(errorInfoList = operationResult.getAllErrorOrValidateInfo()))) {
            for (IOperateInfo info : errorInfoList) {
                Object pk = info.getPkValue();
                IPermResult permParam = permResultMap.get(pk);
                if (permParam == null) continue;
                permParam.setSuccess(false);
                permParam.getErrors().add(info.getMessage());
            }
        }
    }

    public static String convertPermResult(OperationResult operationResult) {
        if (operationResult == null) {
            return "";
        }
        StringBuilder errors = new StringBuilder();
        List errorInfoList = operationResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)errorInfoList)) {
            for (IOperateInfo info : errorInfoList) {
                errors.append(info.getMessage());
            }
        }
        return errors.toString();
    }

    public static void addPermResult(IPermResult permResult, String error) {
        if (StringUtils.isNotBlank((CharSequence)error)) {
            NoCodePermImplUtils.addErrorPermResult(permResult, error);
        }
    }

    public static void addErrorPermResult(IPermResult permResult, String error) {
        if (permResult != null) {
            permResult.setSuccess(false);
            permResult.getErrors().add(error);
        }
    }

    public static void clearEntryEntity(DynamicObjectCollection entryEntity, IPermHandler rowHandler) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int index = 0;
        Object[] pks = new Object[entryEntity.size()];
        for (DynamicObject entryObj : entryEntity) {
            pks[index++] = entryObj.getPkValue();
            if (rowHandler == null) continue;
            rowHandler.handle(new Object[]{entryObj});
        }
        if (pks.length > 0) {
            NoCodePermImplUtils.delete((IDataEntityType)entryEntity.getDynamicObjectType(), pks);
        }
        entryEntity.clear();
    }

    public static Object transHandle(IPermResult permResult, IPermHandler handler) {
        if (handler == null) {
            return null;
        }
        Object result = null;
        try (TXHandle t = TX.required((String)"NoCodePermission");){
            try {
                result = handler.handle(new Object[0]);
                if (permResult != null && !permResult.isSuccess()) {
                    t.markRollback();
                }
            }
            catch (Exception e) {
                NoCodePermImplUtils.addErrorPermResult(permResult, String.format(ResManager.loadKDString((String)"\u5904\u7406\u6743\u9650\u6570\u636e\u4e8b\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%1$s", (String)"NoCodePermImplUtils_0", (String)"bos-mservice-permission", (Object[])new Object[0]), e.getMessage()));
                log.warn("NoCodePermImplUtils.transHandle\u5904\u7406\u6743\u9650\u6570\u636e\u4e8b\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                t.markRollback();
            }
        }
        return result;
    }

    public static void afterOperation(String entityNumber, String operation, boolean clearCache, List<String> ids) {
        if (clearCache) {
            PermissionServiceHelper.clearAllCache();
        }
    }

    public static void delete(String entityNumber, QFilter filter) {
        log.info("NoCodePermImplUtils.delete\u5220\u9664\u300b\u6839\u636e\u7f16\u7801\uff1a\u3010\u5355\u636e\u3011{}\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011{}", (Object)entityNumber, (Object)filter);
        if (filter != null) {
            DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{filter});
        }
    }

    public static void delete(IDataEntityType type, Object[] pks) {
        if (type == null || pks == null || pks.length == 0) {
            return;
        }
        log.info("NoCodePermImplUtils.delete\u5220\u9664\u300b\u6839\u636e\u7c7b\u578b\uff1a\u3010\u5355\u636e\u3011{}\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011{}", (Object)type.getName(), (Object)pks);
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])pks);
    }

    public static List<String> toRoleIds(Role role) {
        ArrayList<String> roleIds = new ArrayList<String>(1);
        roleIds.add(role.getId());
        return roleIds;
    }

    public static QFilter[] getRoleFilters(List<String> roleIds) {
        return new QFilter[]{NoCodePermImplUtils.getRoleFilter(roleIds)};
    }

    public static QFilter getRoleFilter(List<String> roleIds) {
        return new QFilter("role", "in", roleIds);
    }

    public static QFilter[] getRoleIdFilters(List<String> roleIds) {
        return new QFilter[]{NoCodePermImplUtils.getRoleIdFilter(roleIds)};
    }

    public static QFilter getRoleIdFilter(List<String> roleIds) {
        return new QFilter("roleid", "in", roleIds);
    }

    public static QFilter getNoPermissionFilter() {
        return new QFilter("1", "=", (Object)17);
    }

    public static void removeCache(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    public static DynamicObject loadSingle(Object pk, String entityName) {
        try {
            return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        }
        catch (Exception e) {
            log.info(entityName + "\uff1a\u3010\u65e0\u4ee3\u7801\u5e73\u53f0\u3011\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + pk);
            return null;
        }
    }

    public static DynamicObject loadSingle(String entityName, QFilter[] filters) {
        try {
            return BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])filters);
        }
        catch (Exception e) {
            log.info(entityName + "\uff1a\u3010\u65e0\u4ee3\u7801\u5e73\u53f0\u3011\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + Arrays.toString(filters));
            return null;
        }
    }
}

