/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.nocode.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.Role;

public class NoCodeRolePermMerger {
    private List<Role> roleList;
    private boolean manageAllAsAll = true;
    private boolean useAllAsAll = true;
    private boolean useViewAllAsAll;
    private boolean useOwnAsAll;
    private boolean usedInAllForm;
    private boolean all;
    private Map<String, Role> customRoleMap = new HashMap<String, Role>();

    public NoCodeRolePermMerger(List<Role> roleList) {
        this.roleList = roleList;
    }

    public NoCodeRolePermMerger(List<Role> roleList, boolean useViewAllAsAll, boolean useOwnAsAll) {
        this.roleList = roleList;
        this.useViewAllAsAll = useViewAllAsAll;
        this.useOwnAsAll = useOwnAsAll;
    }

    public void merge() {
        if (CollectionUtils.isEmpty(this.roleList)) {
            return;
        }
        for (Role role : this.roleList) {
            if (!this.usedInAllForm) {
                this.usedInAllForm = role.getAppUseType().isUsedInAllEntity();
            }
            if (this.isAll(role)) {
                this.all = true;
                break;
            }
            this.customRoleMap.put(role.getId(), role);
        }
    }

    private boolean isAll(Role role) {
        if (this.manageAllAsAll && role.getAppManageType() == AppManageTypeEnum.ALL) {
            return true;
        }
        if (this.useAllAsAll && role.getAppUseType() == AppUseTypeEnum.ALL) {
            return true;
        }
        if (this.useViewAllAsAll && role.getAppUseType() == AppUseTypeEnum.VIEW_ALL) {
            return true;
        }
        return this.useOwnAsAll && role.getAppUseType() == AppUseTypeEnum.OWN;
    }

    public Set<String> mergeForms(String ... formArr) {
        HashSet<String> forms = new HashSet<String>(8);
        if (this.isUsedInAllForm()) {
            forms.add("perm_nocode_publicentity");
        }
        if (formArr != null) {
            for (String form : formArr) {
                forms.add(form);
            }
        }
        return forms;
    }

    public boolean isAll() {
        return this.all;
    }

    public Map<String, Role> getCustomRoleMap() {
        return this.customRoleMap;
    }

    public boolean isUsedInAllForm() {
        return this.usedInAllForm;
    }
}

