/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.AdminInfo;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrp;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrg;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpAppReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpBizUnitReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpFunpermReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpOrgAddUserReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpOrgReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.admingroup.AdmGrpAppService;
import kd.bos.permission.service.admingroup.AdmGrpBizUnitService;
import kd.bos.permission.service.admingroup.AdmGrpFunpermService;
import kd.bos.permission.service.admingroup.AdmGrpOrgAddUserService;
import kd.bos.permission.service.admingroup.AdmGrpOrgService;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.beanutils.BeanUtils;

@SdkInternal
public class AdminGroupService
extends CommonService
implements IPermExt {
    private static final String ROOT_NODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final Log logger = LogFactory.getLog(AdminGroupService.class);
    private static final String PERM_USERADMINGROUP = "perm_useradmingroup";
    public static final String PERM_ADMINGROUP = "perm_admingroup";
    public static final String PERM_ADMINGROUPFUNPERM = "perm_admingroupfunperm";
    public static final String PERM_ADMINGROUPBIZUNIT = "perm_admingroupbizunit";
    public static final String PERM_ADMINGROUPORG = "perm_admingrouporg";
    public static final String PERM_ADMINGROUPAPP = "perm_admingroupapp";
    private static final String PROP_ADMIN_GROUP = "usergroup";
    private static final String KEY_GROUP = "key_group";
    private static final String KEY_ORG = "key_org";
    private static final String KEY_BIZAPP = "key_bizapp";
    private static final String KEY_ENTITY = "key_entity";
    private static final String KEY_PERMITEM = "key_permitem";
    private static final int SYS = 1;
    private static final int BIZ = 2;
    private static final int ADMIN = 3;
    private static final int APP = 4;

    public static TreeNode initAdminGroupTree(TreeView tv, IPageCache pageCache) throws Exception {
        Long userId = RequestContext.get().getCurrUserId();
        String adminSchemeStr = pageCache.get("adminScheme");
        Long adminScheme = null;
        adminScheme = kd.bos.util.StringUtils.isEmpty((String)adminSchemeStr) ? AdminSchemeHelper.getCurEnableSchemeId() : Long.valueOf(adminSchemeStr);
        QFilter filter = null;
        HashSet<String> superiorGroupLongNumberSet = new HashSet<String>(16);
        HashSet<String> currentUserInGroup = new HashSet<String>(16);
        DynamicObject[] userAdminGroup = UserAdmGrpService.getUserAdmGrpDynArr(userId, adminScheme);
        Long adminType = null;
        try {
            adminType = (Long)userAdminGroup[0].getDynamicObject(PROP_ADMIN_GROUP).get("admintype.id");
        }
        catch (Exception e) {
            logger.warn("[AdminGroupService]\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u5df2\u5207\u6362\u6216\u7ba1\u7406\u5458\u7ec4\u6570\u636e\u5f02\u5e38\u6216\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u7ba1\u7406\u5458\u9875\u9762\uff0c\u5982\u65e0\u6548\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u65b0\u5347\u7ea7\u7ba1\u7406\u5458\u6570\u636e\u3002", (String)"AdminGroupService_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        String longNumberFirst = (String)userAdminGroup[0].getDynamicObject(PROP_ADMIN_GROUP).get("longnumber");
        for (int i = 0; i < userAdminGroup.length; ++i) {
            DynamicObject value = userAdminGroup[i];
            String longNumber = (String)value.getDynamicObject(PROP_ADMIN_GROUP).get("longnumber");
            currentUserInGroup.add(longNumber);
            if (i == 0) {
                filter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            } else {
                filter.or(new QFilter("longnumber", "like", (Object)(longNumber + "%")));
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)longNumber)) continue;
            while (longNumber.lastIndexOf(46) > 0) {
                superiorGroupLongNumberSet.add(longNumber);
                longNumber = longNumber.substring(0, longNumber.lastIndexOf(46));
            }
            superiorGroupLongNumberSet.add(longNumber);
        }
        QFilter filter2 = new QFilter("longnumber", "in", superiorGroupLongNumberSet);
        filter2.or(filter);
        QFilter[] filters = new QFilter[]{filter2};
        DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)PERM_ADMINGROUP, (String)"id, name, parent, longnumber, level", (QFilter[])filters, (String)"longnumber asc, level asc");
        ArrayList<Long> adminGroupCanSee = new ArrayList<Long>(10);
        tv.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ROOT_NODE);
        root.setText(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4", (String)"AdminGroupService_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        root.setIsOpened(true);
        root.setLongNumber("");
        tv.addNode(root);
        ArrayList<String[]> treeNodeInfos = new ArrayList<String[]>(30);
        ArrayList<Long> superiorGroupIds = new ArrayList<Long>(10);
        TreeNode focusNode = new TreeNode();
        for (DynamicObject adminGroup : adminGroups) {
            Long id = (Long)adminGroup.get("id");
            adminGroupCanSee.add(id);
            Long parent = (Long)adminGroup.get("parent.id");
            String longNumber = (String)adminGroup.get("longnumber");
            Integer level = (Integer)adminGroup.get("level");
            TreeNode node = new TreeNode();
            if (parent == null) {
                node.setParentid(ROOT_NODE);
            } else {
                node.setParentid(parent.toString() + "_" + (level - 1));
            }
            node.setId(id.toString() + "_" + level);
            String name = "";
            ILocaleString nameLoc = (ILocaleString)adminGroup.get("name");
            if (null != nameLoc) {
                name = nameLoc.toString();
            }
            node.setText(name);
            node.setIsOpened(true);
            node.setLongNumber(longNumber);
            tv.addNode(node);
            if (longNumberFirst.equalsIgnoreCase(longNumber)) {
                focusNode = node;
            }
            if (superiorGroupLongNumberSet.contains(longNumber) && currentUserInGroup.stream().noneMatch(x -> longNumber.startsWith((String)x) && !longNumber.equals(x))) {
                superiorGroupIds.add(id);
            }
            String[] treeNodeInfo = new String[]{node.getText(), node.getId(), node.getParentid()};
            treeNodeInfos.add(treeNodeInfo);
        }
        tv.focusNode(focusNode);
        tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        pageCache.put("adminScheme", adminScheme.toString());
        if (adminType != null) {
            pageCache.put("adminType", adminType.toString());
        }
        pageCache.put("currentUserInGroup", SerializationUtils.toJsonString(currentUserInGroup));
        pageCache.put("superiorGroupIds", SerializationUtils.toJsonString(superiorGroupIds));
        pageCache.put("adminGroupCanSee", SerializationUtils.toJsonString(adminGroupCanSee));
        pageCache.put("treeNodeInfos", SerializationUtils.toJsonString(treeNodeInfos));
        pageCache.remove("searchResult");
        pageCache.remove("lastSearchText");
        pageCache.remove("searchIndex");
        return root;
    }

    public static List<AdminInfo> getTopAdminInfo() {
        ArrayList<AdminInfo> resultList = new ArrayList<AdminInfo>(10);
        HashSet<String> strAdminUserIds = new HashSet<String>(8);
        strAdminUserIds.add("1");
        strAdminUserIds.add("2");
        strAdminUserIds.add("3");
        strAdminUserIds.add("10");
        Map userAdminTagMap = AdminSchemeHelper.getUserAdminTagMap(strAdminUserIds);
        Set userIdset = userAdminTagMap.keySet();
        if (null == userIdset || userIdset.isEmpty()) {
            return new ArrayList<AdminInfo>(0);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupService.getTopAdminInfo", (String)"bos_user", (String)"id, username, phone, email, name, enable", (QFilter[])new QFilter[]{new QFilter("id", "in", userIdset)}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long userId = row.getLong("id");
                String userName = row.getString("username");
                String phone = row.getString("phone");
                String email = row.getString("email");
                String name = row.getString("name");
                boolean enable = row.getBoolean("enable");
                if (!enable) continue;
                AdminInfo adminInfo = new AdminInfo();
                adminInfo.setAdminType(AdminType.getAdminType((String)((String)userAdminTagMap.get(userId))));
                adminInfo.setEmail(email);
                adminInfo.setPhone(phone);
                adminInfo.setUserid(userId);
                adminInfo.setUsername(userName);
                adminInfo.setTruename(name);
                resultList.add(adminInfo);
            }
        }
        return resultList;
    }

    @Deprecated
    public static List<Long> getAdminGrpIdsByUser(Long userId) {
        return new ArrayList<Long>(AdminGroupService.getUserInAdmGrpIdSet(userId));
    }

    public static Set<Long> getUserInAdmGrpIdSet(Long userId) {
        HashSet<Long> resultIds = new HashSet<Long>(8);
        DynamicObject adminSchemeObj = QueryServiceHelper.queryOne((String)"perm_adminscheme", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Character.valueOf('1')).toArray());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)PERM_USERADMINGROUP, (String)PROP_ADMIN_GROUP, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("usergroup.adminscheme", "=", (Object)adminSchemeObj.getLong("id"))});
        if (doc == null || doc.isEmpty()) {
            return resultIds;
        }
        for (DynamicObject dObj : doc) {
            resultIds.add(dObj.getLong(PROP_ADMIN_GROUP));
        }
        return resultIds;
    }

    public static Set<String> getCanOperAdmGroupIdSet(Long userId, boolean includeInAdmGrp, String useThreadCacheStr) {
        boolean useThreadCache;
        boolean bl = useThreadCache = StringUtils.isEmpty((Object)useThreadCacheStr) || Objects.equals("1", useThreadCacheStr);
        if (useThreadCache) {
            String key = String.format("%s%s%s%s", "getCanOperAdmGroupIdSet_", RequestContext.get().getAccountId(), userId, includeInAdmGrp);
            Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
                Set<String> canOperAdmGroupIdSetPri = AdminGroupService.getCanOperAdmGroupIdSetPri(userId, includeInAdmGrp);
                if (null == canOperAdmGroupIdSetPri) {
                    return map;
                }
                map.put("getCanOperAdmGroupIdSet_", canOperAdmGroupIdSetPri);
                return map;
            });
            return (Set)threadCacheMap.get("getCanOperAdmGroupIdSet_");
        }
        return AdminGroupService.getCanOperAdmGroupIdSetPri(userId, includeInAdmGrp);
    }

    private static Set<String> getCanOperAdmGroupIdSetPri(Long userId, boolean includeInAdmGrp) {
        HashSet<String> resultIds = new HashSet<String>(8);
        DynamicObject adminSchemeObj = QueryServiceHelper.queryOne((String)"perm_adminscheme", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Character.valueOf('1')).toArray());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)PERM_USERADMINGROUP, (String)"usergroup_id, usergroup.longnumber", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("usergroup.adminscheme", "=", (Object)adminSchemeObj.getLong("id"))});
        if (doc == null || doc.isEmpty()) {
            return resultIds;
        }
        for (DynamicObject dObj : doc) {
            Set<String> adminGroupIds;
            Long adminGrpId = dObj.getLong("usergroup_id");
            String longNum = dObj.getString("usergroup.longnumber");
            if (null == adminGrpId || Objects.equals(0L, adminGrpId) || kd.bos.util.StringUtils.isEmpty((String)longNum) || null == (adminGroupIds = AdminGroupService.getAdmGrpAllSub(longNum, adminGrpId, includeInAdmGrp)) || adminGroupIds.isEmpty()) continue;
            resultIds.addAll(adminGroupIds);
        }
        resultIds.remove(ROOT_NODE);
        return resultIds;
    }

    public static List<String> getHasViewPermComRoleIds(Long userId) {
        return AdminGroupService.getHasPermComRoleIds(userId, Boolean.FALSE);
    }

    public static List<String> getHasModifyPermComRoleIds(Long userId) {
        return AdminGroupService.getHasPermComRoleIds(userId, Boolean.TRUE);
    }

    public static List<String> getHasPermComRoleIds(Long userId, Boolean hasModifyPerm) {
        Set<String> hasPermComRoleIdSet = AdminGroupService.getHasPermComRoleIdSet(userId, hasModifyPerm);
        if (null == hasPermComRoleIdSet) {
            return null;
        }
        return new ArrayList<String>(hasPermComRoleIdSet);
    }

    private static Set<String> getHasPermComRoleIdSet(Long userId, Boolean hasModifyPerm) {
        Map<String, Boolean> comRoleHasPermInfo;
        HashSet<String> result = new HashSet<String>(8);
        if (hasModifyPerm == null) {
            hasModifyPerm = Boolean.FALSE;
        }
        if ((comRoleHasPermInfo = AdminGroupService.getComRoleHasPermInfo(userId)) == null) {
            return null;
        }
        if (comRoleHasPermInfo.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, Boolean> entry : comRoleHasPermInfo.entrySet()) {
            String commonRoleId = entry.getKey();
            if (kd.bos.util.StringUtils.isEmpty((String)commonRoleId)) continue;
            Boolean isModifiable = entry.getValue();
            if (isModifiable == null) {
                isModifiable = Boolean.FALSE;
            }
            if (hasModifyPerm.equals(Boolean.TRUE)) {
                if (!isModifiable.equals(Boolean.TRUE)) continue;
                result.add(commonRoleId);
                continue;
            }
            result.add(commonRoleId);
        }
        return result;
    }

    public static Map<String, Boolean> getComRoleHasPermInfo(Long userId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(10);
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (isSuperAdmin) {
            return null;
        }
        List<Long> adminGrpIds = AdminGroupService.getAdminGrpIdsByUser(userId);
        if (adminGrpIds == null || adminGrpIds.isEmpty()) {
            return null;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_admingrouprole", (String)"role,modifiable", (QFilter[])new QFilter("admingroup", "in", adminGrpIds).toArray());
        if (doc != null && !doc.isEmpty()) {
            for (DynamicObject dObj : doc) {
                String comRoleId = dObj.getString("role");
                boolean modifiable = dObj.getBoolean("modifiable");
                if (kd.bos.util.StringUtils.isEmpty((String)comRoleId)) continue;
                result.put(comRoleId, modifiable);
            }
        }
        Set<String> createAdminGrpComRoleIds = AdminGroupService.getCreateAdminGrpComRoleIds(adminGrpIds);
        for (String roleId : createAdminGrpComRoleIds) {
            if (kd.bos.util.StringUtils.isEmpty((String)roleId)) continue;
            result.put(roleId, Boolean.TRUE);
        }
        Set<String> allPublicComRoleIds = AdminGroupService.getAllPublicComRoleIds();
        for (String publicComRoleId : allPublicComRoleIds) {
            if (kd.bos.util.StringUtils.isEmpty((String)publicComRoleId)) continue;
            result.put(publicComRoleId, Boolean.TRUE);
        }
        return result;
    }

    public static Set<String> getCreateAdminGrpComRoleIds(List<Long> createAdminGrpIds) {
        HashSet<String> result = new HashSet<String>(8);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_role", (String)"id", (QFilter[])new QFilter[]{new QFilter("createadmingrp", "in", createAdminGrpIds)});
        if (doc == null || doc.isEmpty()) {
            return new HashSet<String>(8);
        }
        for (DynamicObject dObj : doc) {
            String comRoleId = dObj.getString("id");
            result.add(comRoleId);
        }
        return result;
    }

    public static Set<String> getAllPublicComRoleIds() {
        HashSet<String> result = new HashSet<String>(8);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_role", (String)"id", (QFilter[])new QFilter("usescope", "=", (Object)Character.valueOf('2')).toArray());
        if (doc == null || doc.isEmpty()) {
            return result;
        }
        for (DynamicObject dObj : doc) {
            String comRoleId = dObj.getString("id");
            result.add(comRoleId);
        }
        return result;
    }

    public static boolean canModifyRole(Long userId, String comRoleId) {
        List<String> hasModifyPermComRoleIds = AdminGroupService.getHasModifyPermComRoleIds(userId);
        if (hasModifyPermComRoleIds == null) {
            return true;
        }
        Sets.SetView difference = Sets.difference((Set)Sets.newHashSet((Object[])new String[]{comRoleId}), new HashSet<String>(hasModifyPermComRoleIds));
        return 0 == difference.size();
    }

    public static Map<String, Boolean> canModifyRole(Long userId, List<String> comRoleIds) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List<String> hasModifyPermComRoleIds = AdminGroupService.getHasModifyPermComRoleIds(userId);
        if (hasModifyPermComRoleIds == null) {
            for (String id : comRoleIds) {
                result.put(id, Boolean.TRUE);
            }
        } else {
            Sets.SetView hasPermSet = Sets.intersection((Set)Sets.newHashSet(comRoleIds), new HashSet<String>(hasModifyPermComRoleIds));
            for (String id : hasPermSet) {
                result.put(id, Boolean.TRUE);
            }
            Sets.SetView noPermSet = Sets.difference((Set)Sets.newHashSet(comRoleIds), (Set)hasPermSet);
            for (String id : noPermSet) {
                result.put(id, Boolean.FALSE);
            }
        }
        return result;
    }

    public static Map<String, Boolean> canModifyRole(Long userId, Set<String> comRoleNumbers) {
        if (null == comRoleNumbers || comRoleNumbers.isEmpty()) {
            return new HashMap<String, Boolean>(1);
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(comRoleNumbers.size());
        Map roleNumIdMap = PermRoleHelper.getRoleNumIdMap(comRoleNumbers);
        if (null == roleNumIdMap || roleNumIdMap.isEmpty()) {
            for (String comRoleNumber : comRoleNumbers) {
                resultMap.put(comRoleNumber, Boolean.TRUE);
            }
            return resultMap;
        }
        Set roleIdSet = roleNumIdMap.values().stream().collect(Collectors.toSet());
        Map<String, Boolean> canModifyMap = AdminGroupService.canModifyRole(userId, new ArrayList<String>(roleIdSet));
        for (String comRoleNumber : comRoleNumbers) {
            String roleId = (String)roleNumIdMap.get(comRoleNumber);
            if (kd.bos.util.StringUtils.isEmpty((String)roleId)) {
                resultMap.put(comRoleNumber, Boolean.FALSE);
                continue;
            }
            Boolean can = canModifyMap.get(roleId);
            resultMap.put(comRoleNumber, null == can ? Boolean.FALSE : can);
        }
        return resultMap;
    }

    public static PermResult saveUserAdminGroup(Long adminGroupId, Set<Long> userIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        userIds.remove(currUserId);
        userIds.remove(1L);
        userIds.remove(2L);
        userIds.remove(3L);
        userIds.remove(10L);
        ArrayList saveList = new ArrayList(10);
        ArrayList saveUserIds = new ArrayList(10);
        userIds.forEach(primaryKeyValue -> {
            DynamicObject userAdminGroup = BusinessDataServiceHelper.newDynamicObject((String)PERM_USERADMINGROUP);
            userAdminGroup.set("user", primaryKeyValue);
            userAdminGroup.set(PROP_ADMIN_GROUP, (Object)adminGroupId);
            saveList.add(userAdminGroup);
            saveUserIds.add(primaryKeyValue);
        });
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        CacheMrg.clearAllCache();
        if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
            try {
                FormConfigFactory.cancelShowFormRights(saveUserIds);
            }
            catch (Exception e) {
                logger.warn("[clearDynamicCache]clearDynamicCache error", (Throwable)e);
            }
        }
        return PermResult.ok((StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"AdminGroupService_2", (String)"bos-mservice-permission", (Object[])new Object[0])));
    }

    public static PermResult saveAdminGroupPerm(String type, Long adminGroupId, Set<String> addPerms, Set<String> delPerms) {
        try {
            Long adminSchemeId = PermCommonUtil.cunrrentAdminStrategy();
            DynamicObject currentAdminGroup = BusinessDataServiceHelper.loadSingle((String)PERM_ADMINGROUP, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)adminGroupId), new QFilter("adminscheme", "=", (Object)adminSchemeId)});
            if (currentAdminGroup == null) {
                return PermResult.fail((String)ResManager.loadKDString((String)"[AdminGroupService.saveAdminGroupSysPerm]\u8be5\u7ba1\u7406\u5458\u7ec4[adminGroupId=%s]\u4e0d\u5b58\u5728\u3002", (String)"AdminGroupService_3", (String)"bos-mservice-permission", (Object[])new Object[]{adminGroupId}));
            }
            HashMap<String, Set<AdmGrpFunperm>> willDelFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpFunperm>> willAddFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpApp>> willDelAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            HashMap<String, Set<AdmGrpApp>> willAddAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            String curAdmGrpNumber = currentAdminGroup.getString("number");
            switch (type) {
                case "SYS": {
                    AdminGroupService.saveAdminGroupSys(curAdmGrpNumber, addPerms, delPerms, willDelFunpermMap, willAddFunpermMap);
                    break;
                }
                case "APP": {
                    AdminGroupService.saveAdminGroupApp(curAdmGrpNumber, addPerms, delPerms, willDelAppMap, willAddAppMap);
                    break;
                }
            }
            if (CollectionUtils.isEmpty(willDelFunpermMap) && CollectionUtils.isEmpty(willAddFunpermMap) && CollectionUtils.isEmpty(willDelAppMap) && CollectionUtils.isEmpty(willAddAppMap)) {
                return PermResult.ok((StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminGroupService_4", (String)"bos-mservice-permission", (Object[])new Object[0])));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
            option.setVariableValue("permlog_busitype", "admingroupperm_save");
            option.setVariableValue("permlog_op", "save");
            option.setVariableValue("permlog_opbtn", ConstantsHelper.getSave());
            option.setVariableValue("permlog_interfacemethod", "AdminGroupService.saveAdminGroupPerm");
            option.setVariableValue("willDelFunpermMap", SerializationUtils.toJsonString(willDelFunpermMap));
            option.setVariableValue("willAddFunpermMap", SerializationUtils.toJsonString(willAddFunpermMap));
            option.setVariableValue("willDelAppMap", SerializationUtils.toJsonString(willDelAppMap));
            option.setVariableValue("willAddAppMap", SerializationUtils.toJsonString(willAddAppMap));
            PermResult permResult = CommonService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setOperEntnum, (Object)PERM_ADMINGROUP).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)new DynamicObject[]{currentAdminGroup}).with(PermOperationReq::setEntSavePermlog, (Object)Boolean.TRUE).with(PermOperationReq::setOption, (Object)option).build());
            if (permResult.isOk()) {
                return PermResult.ok((StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminGroupService_4", (String)"bos-mservice-permission", (Object[])new Object[0])));
            }
            return permResult;
        }
        catch (Exception e) {
            logger.warn("AdminGroupService.saveAdminGroupPerm error", (Throwable)e);
            return PermResult.fail((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u5728monitor\u5e73\u53f0\u67e5\u770b\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u3002", (String)"AdminGroupService_5", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
    }

    private static void saveAdminGroupApp(String curAdmGrpNumber, Set<String> addApps, Set<String> delApps, Map<String, Set<AdmGrpApp>> willDelAppMap, Map<String, Set<AdmGrpApp>> willAddAppMap) {
        String[] info;
        if (!CollectionUtils.isEmpty(delApps)) {
            for (String app : delApps) {
                info = app.split("\\|");
                if (null == info) continue;
                willDelAppMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpApp::new).with(AdmGrpApp::setAppId, (Object)info[1]).build());
            }
        }
        if (!CollectionUtils.isEmpty(addApps)) {
            for (String app : addApps) {
                info = app.split("\\|");
                if (null == info) continue;
                willAddAppMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpApp::new).with(AdmGrpApp::setAppId, (Object)info[1]).build());
            }
        }
    }

    private static void saveAdminGroupSys(String curAdmGrpNumber, Set<String> addPerms, Set<String> delPerms, Map<String, Set<AdmGrpFunperm>> willDelFunpermMap, Map<String, Set<AdmGrpFunperm>> willAddFunpermMap) {
        String[] info;
        if (!CollectionUtils.isEmpty(delPerms)) {
            for (String delPerm : delPerms) {
                info = delPerm.split("\\|");
                if (null == info) continue;
                willDelFunpermMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpFunperm::new).with(AdmGrpFunperm::setAppId, (Object)info[0]).with(AdmGrpFunperm::setEntNum, (Object)info[1]).with(AdmGrpFunperm::setPermItemId, (Object)info[2]).build());
            }
        }
        if (!CollectionUtils.isEmpty(addPerms)) {
            for (String addPerm : addPerms) {
                info = addPerm.split("\\|");
                if (null == info) continue;
                willAddFunpermMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpFunperm::new).with(AdmGrpFunperm::setAppId, (Object)info[0]).with(AdmGrpFunperm::setEntNum, (Object)info[1]).with(AdmGrpFunperm::setPermItemId, (Object)info[2]).build());
            }
        }
    }

    public static boolean verifyAdminGroupRange(Long currUserId, Long adminSchemeId, Long adminGroupId, String type) {
        DynamicObject currentAdminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)PERM_ADMINGROUP);
        String currentLongNumber = currentAdminGroup.getString("longnumber");
        QFilter filter = null;
        HashSet<String> superiorGroupLongNumberSet = new HashSet<String>(16);
        HashSet<String> currentUserInGroup = new HashSet<String>(16);
        QFilter[] filters = new QFilter[]{new QFilter("user.id", "=", (Object)currUserId).and("usergroup.adminscheme.id", "=", (Object)adminSchemeId)};
        DynamicObject[] userAdminGroup = BusinessDataServiceHelper.load((String)PERM_USERADMINGROUP, (String)"user,usergroup", (QFilter[])filters);
        if (userAdminGroup == null || userAdminGroup.length == 0) {
            return false;
        }
        for (int i = 0; i < userAdminGroup.length; ++i) {
            DynamicObject value = userAdminGroup[i];
            String longNumber = (String)value.getDynamicObject(PROP_ADMIN_GROUP).get("longnumber");
            currentUserInGroup.add(longNumber);
            if (i == 0) {
                filter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            } else {
                filter.or(new QFilter("longnumber", "like", (Object)(longNumber + "%")));
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)longNumber)) continue;
            while (longNumber.lastIndexOf(46) > 0) {
                superiorGroupLongNumberSet.add(longNumber);
                longNumber = longNumber.substring(0, longNumber.lastIndexOf(46));
            }
            superiorGroupLongNumberSet.add(longNumber);
        }
        QFilter filter2 = new QFilter("longnumber", "in", superiorGroupLongNumberSet);
        filter2.or(filter);
        filters = new QFilter[]{filter2};
        DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)PERM_ADMINGROUP, (String)"id, name, parent, longnumber, level", (QFilter[])filters, (String)"longnumber asc, level asc");
        ArrayList<Long> adminGroupCanSee = new ArrayList<Long>(10);
        ArrayList<Long> superiorGroupIds = new ArrayList<Long>(10);
        for (DynamicObject adminGroup : adminGroups) {
            Long id = (Long)adminGroup.get("id");
            adminGroupCanSee.add(id);
            String longNumber = (String)adminGroup.get("longnumber");
            if (!superiorGroupLongNumberSet.contains(longNumber) || !currentUserInGroup.stream().noneMatch(x -> longNumber.startsWith((String)x) && !longNumber.equals(x))) continue;
            superiorGroupIds.add(id);
        }
        if ("adminGroup".equals(type)) {
            if (currentUserInGroup.contains(currentLongNumber)) {
                return true;
            }
            if (superiorGroupIds.contains(adminGroupId)) {
                return false;
            }
            return adminGroupCanSee.contains(adminGroupId);
        }
        if ("admin".equals(type)) {
            if (superiorGroupIds.contains(adminGroupId)) {
                return false;
            }
            return adminGroupCanSee.contains(adminGroupId);
        }
        return false;
    }

    public static Map<String, Object> getExcessData(final int dataType, Long adminGroupId, List<Long> subAdminGroups) {
        StringBuilder adminGroupIdsBf = new StringBuilder();
        for (Long subAdminGroup : subAdminGroups) {
            adminGroupIdsBf.append(subAdminGroup).append(',');
        }
        adminGroupIdsBf.deleteCharAt(adminGroupIdsBf.length() - 1);
        String adminGroupIds = adminGroupIdsBf.toString();
        String table = "";
        String field1 = "";
        String field2 = "";
        switch (dataType) {
            case 1: {
                table = "t_perm_admingroupfunperm ";
                field1 = "t1.fusergroupid, t1.fappid, t1.fentitynum, t1.fpermitemid ";
                field2 = "t2 WHERE t2.fappid = t1.fappid AND t2.fentitynum = t1.fentitynum AND t2.fpermitemid = t1.fpermitemid AND t2.fusergroupid = ";
                break;
            }
            case 2: {
                table = "t_perm_admingroupbizunit ";
                field1 = "t1.fusergroupid, t1.forgid ";
                field2 = "t2 WHERE t2.forgid = t1.forgid AND t2.fusergroupid = ";
                break;
            }
            case 3: {
                table = "t_perm_admingrouporg ";
                field1 = "t1.fusergroupid, t1.forgid ";
                field2 = "t2 WHERE t2.forgid = t1.forgid AND t2.fusergroupid = ";
                break;
            }
            case 4: {
                table = "t_perm_admingroupapp ";
                field1 = "t1.fusergroupid, t1.fappid ";
                field2 = "t2 WHERE t2.fappid = t1.fappid AND t2.fusergroupid =";
            }
        }
        StringBuilder sql = new StringBuilder().append("SELECT ").append(field1).append("FROM ").append(table).append("t1 WHERE t1.fusergroupid IN (").append(adminGroupIds).append(") AND NOT EXISTS (SELECT 1 FROM ").append(table).append(field2).append(adminGroupId).append(")");
        Map result = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                switch (dataType) {
                    case 4: {
                        HashSet<Long> appGroupFilter = new HashSet<Long>(16);
                        result.put(AdminGroupService.KEY_GROUP, appGroupFilter);
                        HashSet<String> appFilter = new HashSet<String>(100);
                        result.put(AdminGroupService.KEY_BIZAPP, appFilter);
                        while (rs.next()) {
                            appGroupFilter.add(rs.getLong("fusergroupid"));
                            appFilter.add(rs.getString("fappid"));
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        HashSet<Long> orgGroupFilter = new HashSet<Long>(16);
                        result.put(AdminGroupService.KEY_GROUP, orgGroupFilter);
                        HashSet<Long> orgOrgFilter = new HashSet<Long>(100);
                        result.put(AdminGroupService.KEY_ORG, orgOrgFilter);
                        while (rs.next()) {
                            orgGroupFilter.add(rs.getLong("fusergroupid"));
                            orgOrgFilter.add(rs.getLong("forgid"));
                        }
                        break;
                    }
                    case 1: {
                        ArrayList<Object[]> delParams = new ArrayList<Object[]>(100);
                        result.put(AdminGroupService.KEY_GROUP, delParams);
                        while (rs.next()) {
                            long groupId = rs.getLong("fusergroupid");
                            String appId = rs.getString("fappid");
                            String entityNum = rs.getString("fentitynum");
                            String permItemId = rs.getString("fpermitemid");
                            delParams.add(new Object[]{groupId, appId, entityNum, permItemId});
                        }
                        break;
                    }
                }
                return result;
            }
        });
        return result;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<Long, AdmGrp> preDataMap = new HashMap<Long, AdmGrp>(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (kd.bos.util.StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, AdmGrp>>(){}));
            }
            HashMap<String, Set<AdmGrpFunperm>> willAddFunpermMap = null == req.getWillAddFunpermMap() ? new HashMap(0) : req.getWillAddFunpermMap();
            HashMap<String, Set<AdmGrpBizUnit>> willAddBizUnitMap = null == req.getWillAddBizUnitMap() ? new HashMap(0) : req.getWillAddBizUnitMap();
            HashMap<String, Set<AdmGrpOrg>> willAddOrgMap = null == req.getWillAddOrgMap() ? new HashMap(0) : req.getWillAddOrgMap();
            HashMap<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap = null == req.getWillAddOrgAddUserMap() ? new HashMap(0) : req.getWillAddOrgAddUserMap();
            HashMap<String, Set<AdmGrpApp>> willAddAppMap = null == req.getWillAddAppMap() ? new HashMap(0) : req.getWillAddAppMap();
            Set<Long> adminGroupIdSet = mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            GetBaseDataDynMapResp baseDataDynMapResp = this.getRelatedBd(adminGroupIdSet, willAddFunpermMap, willAddBizUnitMap, willAddOrgMap, willAddOrgAddUserMap, willAddAppMap);
            PermResult saveGrpAuthorizeRes = this.saveGrpAuthorize(baseDataDynMapResp, req, "0", "0", Boolean.FALSE);
            if (!saveGrpAuthorizeRes.isOk()) {
                throw new KDBizException(saveGrpAuthorizeRes.getMsg());
            }
            HashMap<String, Map<String, Object>> diffContentMap = new HashMap<String, Map<String, Object>>(8);
            HashMap<Long, Set<Long>> preAdmUserIdSetMap = new HashMap<Long, Set<Long>>(8);
            this.getAdmGrpDiffInfo(diffContentMap, preAdmUserIdSetMap, preDataMap, adminGroupIdSet);
            String curAppNum = req.getCurAppNum();
            String curFormNum = req.getCurFormNum();
            PermLogReq permLogReq = req.getPermLogReq();
            PermResult isleaf2FalseForParentRes = this.isleaf2FalseForParent(adminGroupIdSet, curAppNum, curFormNum, permLogReq, "0");
            if (!isleaf2FalseForParentRes.isOk()) {
                throw new KDBizException(isleaf2FalseForParentRes.getMsg());
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, (Object)mainIdSet).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, diffContentMap).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(AdmGrpOperationReq::setPreAdmGroupMap, this.preDataMap2PreAdmGroupMap(preDataMap)).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, preAdmUserIdSetMap).build());
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            logger.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private void getAdmGrpDiffInfo(Map<String, Map<String, Object>> diffContentMap, Map<Long, Set<Long>> preAdmUserIdSetMap, Map<Long, AdmGrp> preDataMap, Set<Long> adminGroupIdSet) {
        if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
            return;
        }
        Map<Long, AdmGrp> afterDataMap = AdminGroupService.getAdmGrpMap(new GetAdmGrpReq(adminGroupIdSet, true, true, true));
        for (Long adminGroupId : adminGroupIdSet) {
            String adminGroupIdStr = String.valueOf(adminGroupId);
            HashMap<String, Sets.SetView> map = new HashMap<String, Sets.SetView>(8);
            AdmGrp preAdmGrp = null == preDataMap.get(adminGroupId) ? new AdmGrp() : preDataMap.get(adminGroupId);
            AdmGrp afterAdmGrp = null == afterDataMap.get(adminGroupId) ? new AdmGrp() : afterDataMap.get(adminGroupId);
            Set preFunpermSet = null == preAdmGrp.getFunpermSet() ? new HashSet(0) : preAdmGrp.getFunpermSet();
            Set afterFunpermSet = null == afterAdmGrp.getFunpermSet() ? new HashSet(0) : afterAdmGrp.getFunpermSet();
            Sets.SetView delFunpermSet = Sets.difference(preFunpermSet, afterFunpermSet);
            Sets.SetView addFunpermSet = Sets.difference(afterFunpermSet, preFunpermSet);
            map.put("delAdmGrpFunperm", delFunpermSet);
            map.put("addAdmGrpFunperm", addFunpermSet);
            Set preBizUnitSet = null == preAdmGrp.getBizUnitSet() ? new HashSet(0) : preAdmGrp.getBizUnitSet();
            Set afterBizUnitSet = null == afterAdmGrp.getBizUnitSet() ? new HashSet(0) : afterAdmGrp.getBizUnitSet();
            Sets.SetView delBizUnitSet = Sets.difference(preBizUnitSet, afterBizUnitSet);
            Sets.SetView addBizUnitSet = Sets.difference(afterBizUnitSet, preBizUnitSet);
            map.put("delAdmGrpBizUnit", delBizUnitSet);
            map.put("addAdmGrpBizUnit", addBizUnitSet);
            Set preOrgSet = null == preAdmGrp.getOrgSet() ? new HashSet(0) : preAdmGrp.getOrgSet();
            Set afterOrgSet = null == afterAdmGrp.getOrgSet() ? new HashSet(0) : afterAdmGrp.getOrgSet();
            Sets.SetView delOrgSet = Sets.difference(preOrgSet, afterOrgSet);
            Sets.SetView addOrgSet = Sets.difference(afterOrgSet, preOrgSet);
            map.put("delAdmGrpOrg", delOrgSet);
            map.put("addAdmGrpOrg", addOrgSet);
            Set preOrgAddUserSet = null == preAdmGrp.getOrgAddUserSet() ? new HashSet(0) : preAdmGrp.getOrgAddUserSet();
            Set afterOrgAddUserSet = null == afterAdmGrp.getOrgAddUserSet() ? new HashSet(0) : afterAdmGrp.getOrgAddUserSet();
            Sets.SetView delOrgAddUserSet = Sets.difference(preOrgAddUserSet, afterOrgAddUserSet);
            Sets.SetView addOrgAddUserSet = Sets.difference(afterOrgAddUserSet, preOrgAddUserSet);
            map.put("delAdmGrpOrgAddUser", delOrgAddUserSet);
            map.put("addAdmGrpOrgAddUser", addOrgAddUserSet);
            Set preAppSet = null == preAdmGrp.getAppSet() ? new HashSet(0) : preAdmGrp.getAppSet();
            Set afterAppSet = null == afterAdmGrp.getAppSet() ? new HashSet(0) : afterAdmGrp.getAppSet();
            Sets.SetView delAppSet = Sets.difference(preAppSet, afterAppSet);
            Sets.SetView addAppSet = Sets.difference(afterAppSet, preAppSet);
            map.put("delAdmGrpApp", delAppSet);
            map.put("addAdmGrpApp", addAppSet);
            diffContentMap.put(adminGroupIdStr, map);
            Set preUserIdSet = null == preAdmGrp.getUserIdSet() ? new HashSet(0) : preAdmGrp.getUserIdSet();
            preAdmUserIdSetMap.computeIfAbsent(adminGroupId, k -> new HashSet(8)).addAll(preUserIdSet);
        }
    }

    private GetBaseDataDynMapResp getRelatedBd(Set<Long> adminGroupIdSet, Map<String, Set<AdmGrpFunperm>> willAddFunpermMap, Map<String, Set<AdmGrpBizUnit>> willAddBizUnitMap, Map<String, Set<AdmGrpOrg>> willAddOrgMap, Map<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap, Map<String, Set<AdmGrpApp>> willAddAppMap) {
        HashSet admGrpIdSet = new HashSet(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> funperm_entNumSet = new HashSet<String>(8);
        HashSet<String> funperm_permItemIdSet = new HashSet<String>(8);
        HashSet<Long> bizunitAndOrg_orgIdSet = new HashSet<Long>(8);
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        for (Long adminGroupId : adminGroupIdSet) {
            Set<AdmGrpApp> set;
            Set<AdmGrpOrgAddUser> orgAddUserSet;
            Set<AdmGrpOrg> set2;
            Set<AdmGrpBizUnit> bizUnitSet;
            String adminGroupIdStr = String.valueOf(adminGroupId);
            Set<AdmGrpFunperm> admGrpFunpermSet = willAddFunpermMap.get(adminGroupIdStr);
            if (null != admGrpFunpermSet && !admGrpFunpermSet.isEmpty()) {
                for (AdmGrpFunperm admGrpFunperm : admGrpFunpermSet) {
                    appIdSet.add(admGrpFunperm.getAppId());
                    funperm_entNumSet.add(admGrpFunperm.getEntNum());
                    funperm_permItemIdSet.add(admGrpFunperm.getPermItemId());
                }
            }
            if (null != (bizUnitSet = willAddBizUnitMap.get(adminGroupIdStr)) && !bizUnitSet.isEmpty()) {
                for (Object admGrpBizUnit : bizUnitSet) {
                    bizunitAndOrg_orgIdSet.add(admGrpBizUnit.getOrgId());
                }
            }
            if (null != (set2 = willAddOrgMap.get(adminGroupIdStr)) && !set2.isEmpty()) {
                Object admGrpBizUnit;
                admGrpBizUnit = set2.iterator();
                while (admGrpBizUnit.hasNext()) {
                    AdmGrpOrg admGrpOrg = (AdmGrpOrg)admGrpBizUnit.next();
                    bizunitAndOrg_orgIdSet.add(admGrpOrg.getOrgId());
                }
            }
            if (null != (orgAddUserSet = willAddOrgAddUserMap.get(adminGroupIdStr)) && !orgAddUserSet.isEmpty()) {
                for (AdmGrpOrgAddUser admGrpOrgAddUser : orgAddUserSet) {
                    userIdSet.add(admGrpOrgAddUser.getUserId());
                }
            }
            if (null == (set = willAddAppMap.get(adminGroupIdStr)) || set.isEmpty()) continue;
            for (AdmGrpApp admGrpApp : set) {
                appIdSet.add(admGrpApp.getAppId());
            }
        }
        GetBaseDataDynMapReq baseDataDynMapReq = (GetBaseDataDynMapReq)PermBuilder.of(GetBaseDataDynMapReq::new).with(GetBaseDataDynMapReq::setAdmGrpIdSet, admGrpIdSet).with(GetBaseDataDynMapReq::setAppIdSet, appIdSet).with(GetBaseDataDynMapReq::setEntNumSet, funperm_entNumSet).with(GetBaseDataDynMapReq::setPermItemIdSet, funperm_permItemIdSet).with(GetBaseDataDynMapReq::setOrgIdSet, bizunitAndOrg_orgIdSet).with(GetBaseDataDynMapReq::setUserIdSet, userIdSet).build();
        GetBaseDataDynMapResp baseDataDynMapResp = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)baseDataDynMapReq);
        return baseDataDynMapResp;
    }

    private PermResult isleaf2FalseForParent(Set<Long> adminGroupIdSet, String curAppNum, String curFormNum, PermLogReq permLogReq, String needClearAllCache) {
        if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
            return PermResult.ok();
        }
        Map map = BusinessDataServiceHelper.loadFromCache((String)PERM_ADMINGROUP, (String)"number, parent", (QFilter[])new QFilter[]{new QFilter("id", "in", adminGroupIdSet)});
        if (null == map || map.isEmpty()) {
            return PermResult.ok();
        }
        ArrayList<DynamicObject> updateParentList = new ArrayList<DynamicObject>(10);
        for (Map.Entry one : map.entrySet()) {
            DynamicObject value = (DynamicObject)one.getValue();
            if (null == value) continue;
            String number = value.getString("number");
            DynamicObject parent = value.getDynamicObject("parent");
            if (null == parent) {
                return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4[%1$s]\u7684\u4e0a\u7ea7\u5206\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdminGroupService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), number));
            }
            boolean isleaf = parent.getBoolean("isleaf");
            if (!isleaf) continue;
            value.set("isleaf", (Object)false);
            updateParentList.add(value);
        }
        if (null == updateParentList || updateParentList.isEmpty()) {
            return PermResult.ok();
        }
        return AdminGroupService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)PERM_ADMINGROUP).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)updateParentList.toArray(new DynamicObject[updateParentList.size()])).with(PermOperationReq::setEntSavePermlog, (Object)Boolean.TRUE).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)"AdminGroupService.isleaf2FalseForParent").build());
    }

    private PermResult saveGrpAuthorize(GetBaseDataDynMapResp baseDataDynMapResp, AdmGrpOperationReq req, String needClearAllCache, String doDelExcessData, Boolean entSavePermlog) {
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        PermLogReq permLogReq = req.getPermLogReq();
        Map willDelFunpermMap = null == req.getWillDelFunpermMap() ? new HashMap(0) : req.getWillDelFunpermMap();
        Map willAddFunpermMap = null == req.getWillAddFunpermMap() ? new HashMap(0) : req.getWillAddFunpermMap();
        PermResult funpermSaveRes = AdmGrpFunpermService.saveByAdmGrp((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setBaseDataDynMapResp, (Object)baseDataDynMapResp).with(AdmGrpOperationReq::setWillDelFunpermMap, willDelFunpermMap).with(AdmGrpOperationReq::setWillAddFunpermMap, willAddFunpermMap).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build());
        if (!funpermSaveRes.isOk()) {
            return funpermSaveRes;
        }
        Map willDelBizUnitMap = null == req.getWillDelBizUnitMap() ? new HashMap(0) : req.getWillDelBizUnitMap();
        Map willAddBizUnitMap = null == req.getWillAddBizUnitMap() ? new HashMap(0) : req.getWillAddBizUnitMap();
        PermResult bizUnitSaveRes = AdmGrpBizUnitService.saveByAdmGrp((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setBaseDataDynMapResp, (Object)baseDataDynMapResp).with(AdmGrpOperationReq::setWillDelBizUnitMap, willDelBizUnitMap).with(AdmGrpOperationReq::setWillAddBizUnitMap, willAddBizUnitMap).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build());
        if (!bizUnitSaveRes.isOk()) {
            return bizUnitSaveRes;
        }
        Map willDelOrgMap = null == req.getWillDelOrgMap() ? new HashMap(0) : req.getWillDelOrgMap();
        Map willAddOrgMap = null == req.getWillAddOrgMap() ? new HashMap(0) : req.getWillAddOrgMap();
        PermResult orgSaveRes = AdmGrpOrgService.saveByAdmGrp((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setBaseDataDynMapResp, (Object)baseDataDynMapResp).with(AdmGrpOperationReq::setWillDelOrgMap, willDelOrgMap).with(AdmGrpOperationReq::setWillAddOrgMap, willAddOrgMap).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build());
        if (!orgSaveRes.isOk()) {
            return orgSaveRes;
        }
        Map willDelOrgAddUserMap = null == req.getWillDelOrgAddUserMap() ? new HashMap(0) : req.getWillDelOrgAddUserMap();
        Map willAddOrgAddUserMap = null == req.getWillAddOrgAddUserMap() ? new HashMap(0) : req.getWillAddOrgAddUserMap();
        PermResult orgAddUserSaveRes = AdmGrpOrgAddUserService.saveByAdmGrp((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setBaseDataDynMapResp, (Object)baseDataDynMapResp).with(AdmGrpOperationReq::setWillDelOrgAddUserMap, willDelOrgAddUserMap).with(AdmGrpOperationReq::setWillAddOrgAddUserMap, willAddOrgAddUserMap).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build());
        if (!orgAddUserSaveRes.isOk()) {
            return orgAddUserSaveRes;
        }
        Map willDelAppMap = null == req.getWillDelAppMap() ? new HashMap(0) : req.getWillDelAppMap();
        Map willAddAppMap = null == req.getWillAddAppMap() ? new HashMap(0) : req.getWillAddAppMap();
        PermResult appSaveRes = AdmGrpAppService.saveByAdmGrp((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setBaseDataDynMapResp, (Object)baseDataDynMapResp).with(AdmGrpOperationReq::setWillDelAppMap, willDelAppMap).with(AdmGrpOperationReq::setWillAddAppMap, willAddAppMap).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build());
        if (!appSaveRes.isOk()) {
            return appSaveRes;
        }
        return PermResult.ok();
    }

    private Map<String, AdmGroup> preDataMap2PreAdmGroupMap(Map<Long, AdmGrp> preDataMap) throws Exception {
        if (null == preDataMap) {
            return new HashMap<String, AdmGroup>(0);
        }
        HashMap<String, AdmGroup> map = new HashMap<String, AdmGroup>(preDataMap.size());
        for (Map.Entry<Long, AdmGrp> preData : preDataMap.entrySet()) {
            Long key = preData.getKey();
            AdmGrp value = preData.getValue();
            if (null == key || Objects.equals(0L, key) || null == value) continue;
            AdmGroup admGroup = new AdmGroup();
            BeanUtils.copyProperties((Object)admGroup, (Object)value);
            map.put(String.valueOf(key), admGroup);
        }
        return map;
    }

    public static void saveOrDel(AdmGrpOperationReq admGrpOperationReq) {
        boolean isDelExcessData;
        AdminGroupService.saveOrDel2PermLog(admGrpOperationReq);
        Map diffContentMap = admGrpOperationReq.getDiffContentMap();
        if (null == diffContentMap || diffContentMap.isEmpty()) {
            return;
        }
        boolean isClearAllCache = kd.bos.util.StringUtils.isEmpty((String)admGrpOperationReq.getNeedClearAllCache()) || Objects.equals("1", admGrpOperationReq.getNeedClearAllCache());
        boolean bl = isDelExcessData = kd.bos.util.StringUtils.isEmpty((String)admGrpOperationReq.getDoDelExcessData()) || Objects.equals("1", admGrpOperationReq.getDoDelExcessData());
        if (isDelExcessData) {
            AdminGroupService.delExcessData(diffContentMap, admGrpOperationReq.getCurAppNum(), admGrpOperationReq.getCurFormNum(), admGrpOperationReq.getPermLogReq(), "0", "0");
        }
        if (isClearAllCache) {
            CacheMrg.clearAllCache();
        }
    }

    private static void delExcessData(Map<String, Map<String, Object>> diffContentMap, String curAppNum, String curFormNum, PermLogReq permLogReq, String needClearAllCache, String alreadyCheckBusiParam) {
        if (null == diffContentMap || diffContentMap.isEmpty()) {
            return;
        }
        HashSet<Long> delRelateDataAdmGrpIdSet = new HashSet<Long>(8);
        HashMap<Long, Set<AdmGrpFunperm>> delAdmGrpFunpermMap = new HashMap<Long, Set<AdmGrpFunperm>>(8);
        HashMap<Long, Set<AdmGrpBizUnit>> delAdmGrpBizUnitMap = new HashMap<Long, Set<AdmGrpBizUnit>>(8);
        HashMap<Long, Set<AdmGrpOrg>> delAdmGrpOrgMap = new HashMap<Long, Set<AdmGrpOrg>>(8);
        HashMap<Long, Set<AdmGrpApp>> delAdmGrpAppMap = new HashMap<Long, Set<AdmGrpApp>>(8);
        AdminGroupService.analysisDel(diffContentMap, delRelateDataAdmGrpIdSet, delAdmGrpFunpermMap, delAdmGrpBizUnitMap, delAdmGrpOrgMap, delAdmGrpAppMap);
        if (null == delRelateDataAdmGrpIdSet || delRelateDataAdmGrpIdSet.isEmpty()) {
            return;
        }
        HashMap<String, Set> willDelFunpermMap = new HashMap<String, Set>(8);
        HashMap<String, Set> willDelBizUnitMap = new HashMap<String, Set>(8);
        HashMap<String, Set> willDelOrgMap = new HashMap<String, Set>(8);
        HashMap<String, Set> willDelAppMap = new HashMap<String, Set>(8);
        ArrayList<DynamicObject> delExcessAdmGrpList = new ArrayList<DynamicObject>(10);
        Map admGroupInfoMap = AdminGroupHelper.getAdmGroupInfoMap(delRelateDataAdmGrpIdSet);
        for (Long admGrpId : delRelateDataAdmGrpIdSet) {
            Set<String> adminGroupIds;
            Set delAppSet;
            String longNum;
            AdmGroup admGroup = (AdmGroup)admGroupInfoMap.get(admGrpId);
            if (null == admGroup || kd.bos.util.StringUtils.isEmpty((String)(longNum = admGroup.getLongNum()))) continue;
            Set delFunpermSet = null == delAdmGrpFunpermMap.get(admGrpId) ? new HashSet(0) : (Set)delAdmGrpFunpermMap.get(admGrpId);
            Set delBizUnitSet = null == delAdmGrpBizUnitMap.get(admGrpId) ? new HashSet(0) : (Set)delAdmGrpBizUnitMap.get(admGrpId);
            Set delOrgSet = null == delAdmGrpOrgMap.get(admGrpId) ? new HashSet(0) : (Set)delAdmGrpOrgMap.get(admGrpId);
            Set set = delAppSet = null == delAdmGrpAppMap.get(admGrpId) ? new HashSet(0) : (Set)delAdmGrpAppMap.get(admGrpId);
            if (CollectionUtils.isEmpty(delFunpermSet) && CollectionUtils.isEmpty(delBizUnitSet) && CollectionUtils.isEmpty(delOrgSet) && CollectionUtils.isEmpty(delAppSet) || null == (adminGroupIds = AdminGroupService.getAdmGrpAllSub(longNum, admGrpId, false)) || adminGroupIds.isEmpty()) continue;
            Set collect = adminGroupIds.stream().map(Long::valueOf).collect(Collectors.toSet());
            Map dynMap = BusinessDataServiceHelper.loadFromCache((String)PERM_ADMINGROUP, (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
            if (null == dynMap || dynMap.isEmpty()) continue;
            Map<Long, AdmGrp> admGrpChildsMap = AdminGroupService.getAdmGrpMap(new GetAdmGrpReq(collect, true, false, false));
            for (Map.Entry dynOne : dynMap.entrySet()) {
                Long id;
                AdmGrp admGrp;
                Object admGrpIdObj = dynOne.getKey();
                DynamicObject dyn = (DynamicObject)dynOne.getValue();
                if (null == admGrpIdObj || null == dyn || null == (admGrp = admGrpChildsMap.get(id = (Long)admGrpIdObj))) continue;
                Set funpermSet = admGrp.getFunpermSet();
                Set bizUnitSet = admGrp.getBizUnitSet();
                Set orgSet = admGrp.getOrgSet();
                Set appSet = admGrp.getAppSet();
                if (!(null != funpermSet && !funpermSet.isEmpty() || null != bizUnitSet && !bizUnitSet.isEmpty() || null != orgSet && !orgSet.isEmpty() || null != appSet && !appSet.isEmpty())) continue;
                String number = dyn.getString("number");
                willDelFunpermMap.computeIfAbsent(number, k -> new HashSet(8)).addAll(delFunpermSet);
                willDelBizUnitMap.computeIfAbsent(number, k -> new HashSet(8)).addAll(delBizUnitSet);
                willDelOrgMap.computeIfAbsent(number, k -> new HashSet(8)).addAll(delOrgSet);
                willDelAppMap.computeIfAbsent(number, k -> new HashSet(8)).addAll(delAppSet);
                delExcessAdmGrpList.add(dyn);
            }
        }
        if (null == delExcessAdmGrpList || delExcessAdmGrpList.isEmpty()) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
        operateOption.setVariableValue("ENTSAVE_PERMLOG", "1");
        operateOption.setVariableValue("canSavePermAdmGroupIdSet_useThreadCache", "0");
        operateOption.setVariableValue("NEED_CLEARALLCACHE", needClearAllCache);
        operateOption.setVariableValue("ALREADY_CHECKBUSIPARAM", alreadyCheckBusiParam);
        operateOption.setVariableValue("DO_DELEXCESSDATA", "0");
        operateOption.setVariableValue("permlog_busitype", null == permLogReq || kd.bos.util.StringUtils.isEmpty((String)permLogReq.getBusiType()) ? "admingroup_modify" : permLogReq.getBusiType());
        operateOption.setVariableValue("permlog_op", null == permLogReq || kd.bos.util.StringUtils.isEmpty((String)permLogReq.getOp()) ? "save" : permLogReq.getOp());
        operateOption.setVariableValue("permlog_opbtn", null == permLogReq || kd.bos.util.StringUtils.isEmpty((String)permLogReq.getOpbtn()) ? ConstantsHelper.getSave() : permLogReq.getOpbtn());
        operateOption.setVariableValue("permlog_interfacemethod", null == permLogReq || kd.bos.util.StringUtils.isEmpty((String)permLogReq.getInterfaceMethod()) ? "AdmGrpFunpermService.saveByAdmGrp" : permLogReq.getInterfaceMethod());
        operateOption.setVariableValue("permlog_formnum", curFormNum);
        operateOption.setVariableValue("currbizappid", curAppNum);
        operateOption.setVariableValue("willDelFunpermMap", SerializationUtils.toJsonString(willDelFunpermMap));
        operateOption.setVariableValue("willDelBizUnitMap", SerializationUtils.toJsonString(willDelBizUnitMap));
        operateOption.setVariableValue("willDelOrgMap", SerializationUtils.toJsonString(willDelOrgMap));
        operateOption.setVariableValue("willDelAppMap", SerializationUtils.toJsonString(willDelAppMap));
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)PERM_ADMINGROUP, (DynamicObject[])delExcessAdmGrpList.toArray(new DynamicObject[delExcessAdmGrpList.size()]), (OperateOption)operateOption);
        if (!executeOperate.isSuccess()) {
            List allErrorOrValidateInfo = executeOperate.getAllErrorOrValidateInfo();
            if (null != allErrorOrValidateInfo && !allErrorOrValidateInfo.isEmpty()) {
                List collect = allErrorOrValidateInfo.stream().map(x -> x.getMessage()).collect(Collectors.toList());
                throw new KDBizException(String.join((CharSequence)"\r\n", collect));
            }
            String message = executeOperate.getMessage();
            if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
                throw new KDBizException(message);
            }
        }
    }

    private static Set<String> getAdmGrpAllSub(String curAdmGrpLongNum, Long curAdmGrpId, boolean includeCurAdmGrpId) {
        DynamicObject[] adminGroups;
        HashSet<String> adminGroupIds = new HashSet<String>(8);
        for (DynamicObject adminGroup : adminGroups = BusinessDataServiceHelper.load((String)PERM_ADMINGROUP, (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(curAdmGrpLongNum + "%"))}, (String)"id asc")) {
            adminGroupIds.add(adminGroup.getString("id"));
        }
        if (!includeCurAdmGrpId) {
            adminGroupIds.remove(String.valueOf(curAdmGrpId));
        }
        return adminGroupIds;
    }

    private static void analysisDel(Map<String, Map<String, Object>> diffContentMap, Set<Long> delRelateDataAdmGrpIdSet, Map<Long, Set<AdmGrpFunperm>> delAdmGrpFunpermMap, Map<Long, Set<AdmGrpBizUnit>> delAdmGrpBizUnitMap, Map<Long, Set<AdmGrpOrg>> delAdmGrpOrgMap, Map<Long, Set<AdmGrpApp>> delAdmGrpAppMap) {
        if (null == diffContentMap || diffContentMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> saveDiff : diffContentMap.entrySet()) {
            String adminGrpIdStr = saveDiff.getKey();
            Map<String, Object> diffValue = saveDiff.getValue();
            if (kd.bos.util.StringUtils.isEmpty((String)adminGrpIdStr) || null == diffValue || diffValue.isEmpty()) continue;
            Long adminGrpId = Long.valueOf(adminGrpIdStr);
            Object delAdmGrpFunpermObj = diffValue.get("delAdmGrpFunperm");
            Object delAdmGrpBizUnitObj = diffValue.get("delAdmGrpBizUnit");
            Object delAdmGrpOrgObj = diffValue.get("delAdmGrpOrg");
            Object delAdmGrpAppObj = diffValue.get("delAdmGrpApp");
            if (null != delAdmGrpFunpermObj) {
                Set delAdmGrpFunpermSet = (Set)delAdmGrpFunpermObj;
                delAdmGrpFunpermMap.computeIfAbsent(adminGrpId, k -> new HashSet(8)).addAll(delAdmGrpFunpermSet);
                delRelateDataAdmGrpIdSet.add(adminGrpId);
            }
            if (null != delAdmGrpBizUnitObj) {
                Set delAdmGrpBizUnitSet = (Set)delAdmGrpBizUnitObj;
                delAdmGrpBizUnitMap.computeIfAbsent(adminGrpId, k -> new HashSet(8)).addAll(delAdmGrpBizUnitSet);
                delRelateDataAdmGrpIdSet.add(adminGrpId);
            }
            if (null != delAdmGrpOrgObj) {
                Set delAdmGrpOrgSet = (Set)delAdmGrpOrgObj;
                delAdmGrpOrgMap.computeIfAbsent(adminGrpId, k -> new HashSet(8)).addAll(delAdmGrpOrgSet);
                delRelateDataAdmGrpIdSet.add(adminGrpId);
            }
            if (null == delAdmGrpAppObj) continue;
            Set delAdmGrpAppSet = (Set)delAdmGrpAppObj;
            delAdmGrpAppMap.computeIfAbsent(adminGrpId, k -> new HashSet(8)).addAll(delAdmGrpAppSet);
            delRelateDataAdmGrpIdSet.add(adminGrpId);
        }
    }

    private static void saveOrDel2PermLog(AdmGrpOperationReq admGrpOperationReq) {
        PermLogReq permLogReq = admGrpOperationReq.getPermLogReq();
        if (!PermCommonUtil.isEnablePermLog() || null == permLogReq) {
            return;
        }
        Map diffContentMap = admGrpOperationReq.getDiffContentMap();
        Set admGroupIdSet = admGrpOperationReq.getMainIdSet();
        Set set = admGroupIdSet = null == admGroupIdSet || admGroupIdSet.isEmpty() ? diffContentMap.keySet() : admGroupIdSet;
        if (null == admGroupIdSet || admGroupIdSet.isEmpty()) {
            return;
        }
        try {
            boolean del = permLogReq.getBusiType().contains("_del");
            Set admGroupIdLongSet = admGroupIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            Map preAdmGroupMap = admGrpOperationReq.getPreAdmGroupMap();
            preAdmGroupMap = null == preAdmGroupMap ? new HashMap(0) : preAdmGroupMap;
            Map afterAdmGroupMap = AdminGroupHelper.getAdmGroupInfoMap(admGroupIdLongSet);
            Map preAdmUserIdSetMap = admGrpOperationReq.getPreAdmUserIdSetMap();
            preAdmUserIdSetMap = null == preAdmUserIdSetMap ? new HashMap(0) : preAdmUserIdSetMap;
            Map afterAdmGrpUserIdSetMap = AdminGroupHelper.getAdmGrpUserIdSetMap(admGroupIdLongSet, (boolean)true);
            int size = admGroupIdSet.size();
            ArrayList list = new ArrayList(size);
            for (String admGroupId : admGroupIdSet) {
                HashMap<String, Object> adminGroupIdSaveDiff;
                boolean existDiff;
                AdmGroup admGroup;
                AdmGroup preAdmGroup = (AdmGroup)preAdmGroupMap.get(admGroupId);
                AdmGroup afterAdmGroup = (AdmGroup)afterAdmGroupMap.get(Long.valueOf(admGroupId));
                AdmGroup admGroup2 = admGroup = null == afterAdmGroup ? preAdmGroup : afterAdmGroup;
                if (!del && null == admGroup || !(existDiff = AdminGroupService.existDiff(adminGroupIdSaveDiff = null == diffContentMap.get(admGroupId) ? new HashMap(8) : (Map)diffContentMap.get(admGroupId), preAdmGroup, afterAdmGroup))) continue;
                String opItemId = admGroupId;
                String opItemName = "";
                String opItemNumber = "";
                if (null == admGroup) continue;
                opItemName = admGroup.getName();
                opItemNumber = admGroup.getNumber();
                Long admGroupIdL = Long.valueOf(admGroupId);
                Set afterUserIdSet = null == afterAdmGrpUserIdSetMap.get(admGroupIdL) ? new HashSet(0) : (Set)afterAdmGrpUserIdSetMap.get(admGroupIdL);
                Set preUserIdSet = null == preAdmUserIdSetMap.get(admGroupIdL) ? new HashSet(0) : (Set)preAdmUserIdSetMap.get(admGroupIdL);
                afterUserIdSet.addAll(preUserIdSet);
                adminGroupIdSaveDiff.put("influenUserIdSet", afterUserIdSet);
                adminGroupIdSaveDiff.put("langStr", RequestContext.get().getLang().name());
                adminGroupIdSaveDiff.put("baseInfoDB_pre", null != preAdmGroup ? preAdmGroup : new AdmGroup());
                adminGroupIdSaveDiff.put("baseInfoDB_after", null != afterAdmGroup ? afterAdmGroup : new AdmGroup());
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", permLogReq.getCloudId());
                map.put("app_id", permLogReq.getAppId());
                map.put("form_identity", permLogReq.getFormIdentity());
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", permLogReq.getPreData());
                map.put("after_data", permLogReq.getAfterData());
                String saveDiffStr = StrUtil.compress((String)new ObjectMapper().writeValueAsString(adminGroupIdSaveDiff));
                map.put("diff_content", saveDiffStr);
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("AdminGroupService.saveOrDel error, mainIdSet:{}", (Object)JSON.toJSONString((Object)admGroupIdSet), (Object)e);
        }
    }

    private static boolean existDiff(Map<String, Object> adminGroupIdSaveDiff, AdmGroup preAdmGroup, AdmGroup afterAdmGroup) {
        Set addAdmGrpApp;
        preAdmGroup = null != preAdmGroup ? preAdmGroup : new AdmGroup();
        AdmGroup admGroup = afterAdmGroup = null != afterAdmGroup ? afterAdmGroup : new AdmGroup();
        if (!preAdmGroup.equals((Object)afterAdmGroup)) {
            return true;
        }
        if (null == adminGroupIdSaveDiff || adminGroupIdSaveDiff.isEmpty()) {
            return false;
        }
        Set delAdmGrpFunperm = null == adminGroupIdSaveDiff.get("delAdmGrpFunperm") ? null : (Set)adminGroupIdSaveDiff.get("delAdmGrpFunperm");
        Set addAdmGrpFunperm = null == adminGroupIdSaveDiff.get("addAdmGrpFunperm") ? null : (Set)adminGroupIdSaveDiff.get("addAdmGrpFunperm");
        Set delAdmGrpBizUnit = null == adminGroupIdSaveDiff.get("delAdmGrpBizUnit") ? null : (Set)adminGroupIdSaveDiff.get("delAdmGrpBizUnit");
        Set addAdmGrpBizUnit = null == adminGroupIdSaveDiff.get("addAdmGrpBizUnit") ? null : (Set)adminGroupIdSaveDiff.get("addAdmGrpBizUnit");
        Set delAdmGrpOrg = null == adminGroupIdSaveDiff.get("delAdmGrpOrg") ? null : (Set)adminGroupIdSaveDiff.get("delAdmGrpOrg");
        Set addAdmGrpOrg = null == adminGroupIdSaveDiff.get("addAdmGrpOrg") ? null : (Set)adminGroupIdSaveDiff.get("addAdmGrpOrg");
        Set delAdmGrpOrgAddUser = null == adminGroupIdSaveDiff.get("delAdmGrpOrgAddUser") ? null : (Set)adminGroupIdSaveDiff.get("delAdmGrpOrgAddUser");
        Set addAdmGrpOrgAddUser = null == adminGroupIdSaveDiff.get("addAdmGrpOrgAddUser") ? null : (Set)adminGroupIdSaveDiff.get("addAdmGrpOrgAddUser");
        Set delAdmGrpApp = null == adminGroupIdSaveDiff.get("delAdmGrpApp") ? null : (Set)adminGroupIdSaveDiff.get("delAdmGrpApp");
        Set set = addAdmGrpApp = null == adminGroupIdSaveDiff.get("addAdmGrpApp") ? null : (Set)adminGroupIdSaveDiff.get("addAdmGrpApp");
        return !CollectionUtils.isEmpty((Collection)delAdmGrpFunperm) || !CollectionUtils.isEmpty((Collection)addAdmGrpFunperm) || !CollectionUtils.isEmpty((Collection)delAdmGrpBizUnit) || !CollectionUtils.isEmpty((Collection)addAdmGrpBizUnit) || !CollectionUtils.isEmpty((Collection)delAdmGrpOrg) || !CollectionUtils.isEmpty((Collection)addAdmGrpOrg) || !CollectionUtils.isEmpty((Collection)delAdmGrpOrgAddUser) || !CollectionUtils.isEmpty((Collection)addAdmGrpOrgAddUser) || !CollectionUtils.isEmpty((Collection)delAdmGrpApp) || !CollectionUtils.isEmpty((Collection)addAdmGrpApp);
    }

    private static List<QFilter> getFilter(GetAdmGrpReq req) {
        Set domainSet;
        Boolean domainGroup;
        Set adminTypeSet;
        Set adminSchemeSet;
        String longNumLike;
        Set longNumSet;
        Set levelSet;
        Set parentSet;
        Set admGrpNumSet;
        if (null == req) {
            req = new GetAdmGrpReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set admGrpIdSet = req.getAdmGrpIdSet();
        if (!CollectionUtils.isEmpty((Collection)admGrpIdSet)) {
            filterList.add(new QFilter("id", "in", (Object)admGrpIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(admGrpNumSet = req.getAdmGrpNumSet()))) {
            filterList.add(new QFilter("number", "in", (Object)admGrpNumSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(parentSet = req.getParentSet()))) {
            filterList.add(new QFilter("parent", "in", (Object)parentSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(levelSet = req.getLevelSet()))) {
            filterList.add(new QFilter("level", "in", (Object)levelSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(longNumSet = req.getLongNumSet()))) {
            filterList.add(new QFilter("longnumber", "in", (Object)longNumSet));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(longNumLike = req.getLongNumLike()))) {
            String text = String.format("%s%s%s", "%", longNumLike, "%");
            filterList.add(new QFilter("longnumber", "like", (Object)text));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminSchemeSet = req.getAdminSchemeSet()))) {
            filterList.add(new QFilter("adminscheme", "in", (Object)adminSchemeSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminTypeSet = req.getAdminTypeSet()))) {
            filterList.add(new QFilter("admintype", "in", (Object)adminTypeSet));
        }
        if (null != (domainGroup = req.getDomainGroup())) {
            filterList.add(new QFilter("isdomain", "=", (Object)domainGroup));
        }
        if (!CollectionUtils.isEmpty((Collection)(domainSet = req.getDomainSet()))) {
            filterList.add(new QFilter("domain", "in", (Object)domainSet));
        }
        return filterList;
    }

    public static Map<Long, AdmGrp> getAdmGrpMap(GetAdmGrpReq req) {
        List<QFilter> filterList = AdminGroupService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdminGroupService.getAdmGrpMap", (String)PERM_ADMINGROUP, (String)"id, number, name, parent, isleaf, level, longnumber, adminscheme, admintype, isdomain, domain, description", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean includeGrpUser;
            Object row;
            HashMap<Long, AdmGrp> map = new HashMap<Long, AdmGrp>(8);
            AdmGrp one = null;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Long adminGroupId = row.getLong("id");
                one = new AdmGrp(adminGroupId, row.getLong("parent"), row.getInteger("level"), row.getString("longnumber"), row.getBoolean("isleaf").booleanValue(), row.getString("name"), row.getString("number"), row.getString("description"), row.getLong("adminscheme"), row.getLong("admintype"), row.getBoolean("isdomain").booleanValue(), row.getLong("domain"));
                map.put(adminGroupId, one);
            }
            if (map.isEmpty()) {
                row = map;
                return row;
            }
            Set<Long> admGrpIdSet = map.keySet();
            boolean includeRangeInfo = req.isIncludeRangeInfo();
            if (includeRangeInfo) {
                Map<Long, Set<AdmGrpFunperm>> funpermSetMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(new GetAdmGrpFunpermReq(null, admGrpIdSet, null, null, null, null, null, null, null));
                Map<Long, Set<AdmGrpBizUnit>> bizUnitSetMap = AdmGrpBizUnitService.getAdmGrpBizUnitSetMap(new GetAdmGrpBizUnitReq(null, admGrpIdSet, null, null, null, null));
                Map<Long, Set<AdmGrpOrg>> orgSetMap = AdmGrpOrgService.getAdmGrpOrgSetMap(new GetAdmGrpOrgReq(null, admGrpIdSet, null, null, null, null));
                Map<Long, Set<AdmGrpOrgAddUser>> orgAddUserSetMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserSetMap(new GetAdmGrpOrgAddUserReq(null, admGrpIdSet, null, null, null, null));
                Map<Long, Set<AdmGrpApp>> appSetMap = AdmGrpAppService.getAdmGrpAppSetMap(new GetAdmGrpAppReq(null, admGrpIdSet, null, null, null, null));
                for (Map.Entry admGrp : map.entrySet()) {
                    Long admGrpId = (Long)admGrp.getKey();
                    AdmGrp value = (AdmGrp)admGrp.getValue();
                    value.setFunpermSet(funpermSetMap.get(admGrpId));
                    value.setBizUnitSet(bizUnitSetMap.get(admGrpId));
                    value.setOrgSet(orgSetMap.get(admGrpId));
                    value.setOrgAddUserSet(orgAddUserSetMap.get(admGrpId));
                    value.setAppSet(appSetMap.get(admGrpId));
                }
            }
            if (includeGrpUser = req.isIncludeGrpUser()) {
                Map<Long, Set<Long>> admGrpUserIdSetMap = UserAdmGrpService.getAdmGrpUserIdSetMap(admGrpIdSet, req.isGrpUserIncludeOrgAddUser());
                for (Map.Entry admGrp : map.entrySet()) {
                    Long admGrpId = (Long)admGrp.getKey();
                    AdmGrp value = (AdmGrp)admGrp.getValue();
                    value.setUserIdSet(null == admGrpUserIdSetMap.get(admGrpId) ? new HashSet(0) : admGrpUserIdSetMap.get(admGrpId));
                }
            }
            HashMap<Long, AdmGrp> hashMap = map;
            return hashMap;
        }
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<Long, AdmGrp> preDataMap = new HashMap<Long, AdmGrp>(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (kd.bos.util.StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, AdmGrp>>(){}));
            }
            Set<Long> adminGroupIdSet = mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            this.fullDelGrpAuthorizeInfo(req, adminGroupIdSet, preDataMap);
            PermResult delRes = this.saveGrpAuthorize(null, req, "0", "0", Boolean.FALSE);
            if (!delRes.isOk()) {
                throw new KDBizException(delRes.getMsg());
            }
            HashMap<String, Map<String, Object>> diffContentMap = new HashMap<String, Map<String, Object>>(8);
            HashMap<Long, Set<Long>> preAdmUserIdSetMap = new HashMap<Long, Set<Long>>(8);
            this.getAdmGrpDiffInfo(diffContentMap, preAdmUserIdSetMap, preDataMap, adminGroupIdSet);
            String curAppNum = req.getCurAppNum();
            String curFormNum = req.getCurFormNum();
            PermLogReq permLogReq = req.getPermLogReq();
            Set<Long> parentIdSet = preDataMap.values().stream().map(x -> x.getParent()).collect(Collectors.toSet());
            PermResult isleaf2FalseForParentRes = this.isleaf2TrueForParent(parentIdSet, curAppNum, curFormNum, permLogReq, "0");
            if (!isleaf2FalseForParentRes.isOk()) {
                throw new KDBizException(isleaf2FalseForParentRes.getMsg());
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, (Object)mainIdSet).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, diffContentMap).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(AdmGrpOperationReq::setPreAdmGroupMap, this.preDataMap2PreAdmGroupMap(preDataMap)).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, preAdmUserIdSetMap).build());
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            logger.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private void fullDelGrpAuthorizeInfo(AdmGrpOperationReq req, Set<Long> adminGroupIdSet, Map<Long, AdmGrp> preDataMap) {
        HashMap willDelFunpermMap = new HashMap(8);
        HashMap willDelBizUnitMap = new HashMap(8);
        HashMap willDelOrgMap = new HashMap(8);
        HashMap willDelOrgAddUserMap = new HashMap(8);
        HashMap willDelAppMap = new HashMap(8);
        for (Long adminGroupId : adminGroupIdSet) {
            AdmGrp admGrp = preDataMap.get(adminGroupId);
            if (null == admGrp) continue;
            String adminGroupIdStr = String.valueOf(adminGroupId);
            Set funpermSet = null == admGrp.getFunpermSet() ? new HashSet(0) : admGrp.getFunpermSet();
            Set bizUnitSet = null == admGrp.getBizUnitSet() ? new HashSet(0) : admGrp.getBizUnitSet();
            Set orgSet = null == admGrp.getOrgSet() ? new HashSet(0) : admGrp.getOrgSet();
            Set orgAddUserSet = null == admGrp.getOrgAddUserSet() ? new HashSet(0) : admGrp.getOrgAddUserSet();
            Set appSet = null == admGrp.getAppSet() ? new HashSet(0) : admGrp.getAppSet();
            willDelFunpermMap.put(adminGroupIdStr, funpermSet);
            willDelBizUnitMap.put(adminGroupIdStr, bizUnitSet);
            willDelOrgMap.put(adminGroupIdStr, orgSet);
            willDelOrgAddUserMap.put(adminGroupIdStr, orgAddUserSet);
            willDelAppMap.put(adminGroupIdStr, appSet);
        }
        req.setWillDelFunpermMap(willDelFunpermMap);
        req.setWillDelBizUnitMap(willDelBizUnitMap);
        req.setWillDelOrgMap(willDelOrgMap);
        req.setWillDelOrgAddUserMap(willDelOrgAddUserMap);
        req.setWillDelAppMap(willDelAppMap);
    }

    private PermResult isleaf2TrueForParent(Set<Long> parentIdSet, String curAppNum, String curFormNum, PermLogReq permLogReq, String needClearAllCache) {
        Sets.SetView notExistChildAdmGrpIdSet;
        if (null == parentIdSet || parentIdSet.isEmpty()) {
            return PermResult.ok();
        }
        HashSet<Long> existChildAdmGrpIdSet = new HashSet<Long>(8);
        Map map = BusinessDataServiceHelper.loadFromCache((String)PERM_ADMINGROUP, (String)"id, number, parent_id", (QFilter[])new QFilter[]{new QFilter("parent", "in", parentIdSet)});
        if (null != map && !map.isEmpty()) {
            for (Map.Entry dyn : map.entrySet()) {
                Long parentId;
                DynamicObject value = (DynamicObject)dyn.getValue();
                if (null == value || null == (parentId = Long.valueOf(value.getLong("parent_id")))) continue;
                existChildAdmGrpIdSet.add(parentId);
            }
        }
        if (null == (notExistChildAdmGrpIdSet = Sets.difference(parentIdSet, existChildAdmGrpIdSet)) || notExistChildAdmGrpIdSet.isEmpty()) {
            return PermResult.ok();
        }
        DynamicObject[] dynArr = BusinessDataServiceHelper.load((Object[])notExistChildAdmGrpIdSet.toArray(new Object[notExistChildAdmGrpIdSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PERM_ADMINGROUP));
        if (null == dynArr || Objects.equals(0, dynArr.length)) {
            return PermResult.ok();
        }
        Arrays.stream(dynArr).forEach(x -> x.set("isleaf", (Object)true));
        return AdminGroupService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)PERM_ADMINGROUP).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)dynArr).with(PermOperationReq::setEntSavePermlog, (Object)Boolean.TRUE).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)"AdminGroupService.isleaf2TrueForParent").build());
    }
}

