/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.groups.Default;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.api.group.Add;
import kd.bos.permission.api.group.PermLog;
import kd.bos.permission.api.group.Update;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.BusiRoleGroupHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.ComRoleContentEnum;
import kd.bos.permission.enums.EnumsDataStatus;
import kd.bos.permission.enums.EnumsEnable;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.busirole.BusiRoleBcFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.busirole.BusiRoleDimObj;
import kd.bos.permission.model.perm.busirole.BusiRoleDisFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleGroup;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.imp.BusiRoleImportBean;
import kd.bos.permission.model.perm.req.BusiRoleAddOrUpdateReq;
import kd.bos.permission.model.perm.req.BusiRoleDelReq;
import kd.bos.permission.model.perm.req.BusiRoleSearchReq;
import kd.bos.permission.model.perm.req.GetComRoleListReq;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.BusiRoleAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.BusiRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.resp.GetBusiRoleAllPermResp;
import kd.bos.permission.model.perm.resp.GetBusiRoleAssignedUserResp;
import kd.bos.permission.model.perm.resp.GetBusiRoleDataRuleResp;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.service.ComRoleService;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class BusiRoleService
extends CommonService
implements IPermExt {
    private static final String SYSTERM_TYPE = "bos-mservice-permission";
    private static final Log log = LogFactory.getLog(BusiRoleService.class);

    public PermResult add(BusiRoleAddOrUpdateReq req) {
        super.checkPerm("perm_busirole", "47156aff000000ac", req);
        super.commonValidate(req, Add.class, PermLog.class);
        List busiRoleList = req.getBusiRoleList();
        ArrayList<Object[]> t_perm_bizrole_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizrole_l_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizrolecomrole_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroleperm_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroledisperm_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroleorg_params = new ArrayList<Object[]>(busiRoleList.size());
        long[] bizroleIds = DB.genLongIds((String)"t_perm_bizrole", (int)busiRoleList.size());
        String[] bizrole_l_Ids = DB.genStringIds((String)"t_perm_bizrole_l", (int)busiRoleList.size());
        for (int i = 0; i < busiRoleList.size(); ++i) {
            BusiRole busiRole = (BusiRole)busiRoleList.get(i);
            Long id = busiRole.getId();
            if (id != null) {
                throw new RuntimeException("busiRole[" + i + "]: " + ResManager.loadKDString((String)"\u65b0\u589e\u4e1a\u52a1\u89d2\u8272\u4e0d\u9700\u8981\u4f20\u5165id\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_0", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            this.addOrUpdateBusiroleCheck(busiRole, i);
            String number = busiRole.getNumber();
            String name = busiRole.getName();
            String remark = busiRole.getRemark();
            String type = busiRole.getType();
            long currUserId = RequestContext.get().getCurrUserId();
            String localeName = RequestContext.get().getLang().name();
            t_perm_bizrole_params.add(new Object[]{bizroleIds[i], bizroleIds[i], number, type, Character.valueOf('C'), Character.valueOf('1'), new Date(), currUserId, new Date(), currUserId, name, remark});
            t_perm_bizrole_l_params.add(new Object[]{bizrole_l_Ids[i], bizroleIds[i], localeName, name, remark});
            Set comRoleSet = busiRole.getComRoleSet();
            long[] bizrolecomrole_Ids = DB.genLongIds((String)"t_perm_bizrolecomrole", (int)comRoleSet.size());
            int index = 0;
            for (String comRoleId : comRoleSet) {
                t_perm_bizrolecomrole_params.add(new Object[]{bizrolecomrole_Ids[index++], bizroleIds[i], 0, comRoleId, Character.valueOf('1')});
            }
            index = 0;
            Set bizrolePermSet = busiRole.getBizrolePermSet();
            long[] bizroleperm_Ids = DB.genLongIds((String)"t_perm_bizroleperm", (int)bizrolePermSet.size());
            for (PermItem permItem : bizrolePermSet) {
                t_perm_bizroleperm_params.add(new Object[]{bizroleperm_Ids[index++], bizroleIds[i], 0, permItem.getPermItemId(), permItem.getEntityNumber(), permItem.getAppId()});
            }
            index = 0;
            Set disPermSet = busiRole.getDisPermSet();
            long[] bizroledisperm_Ids = DB.genLongIds((String)"t_perm_bizroledisperm", (int)disPermSet.size());
            for (PermItem permItem : disPermSet) {
                t_perm_bizroledisperm_params.add(new Object[]{bizroledisperm_Ids[index++], bizroleIds[i], 0, permItem.getPermItemId(), permItem.getEntityNumber(), permItem.getAppId()});
            }
            index = 0;
            Set dimSet = busiRole.getDimSet();
            long[] bizroleorg_Ids = DB.genLongIds((String)"t_perm_bizroleorg", (int)dimSet.size());
            for (Dim dim : dimSet) {
                t_perm_bizroleorg_params.add(new Object[]{bizroleorg_Ids[index++], bizroleIds[i], 0, dim.getDimId(), dim.getIncludeSub(), dim.getDimType()});
            }
        }
        String t_perm_bizrole_sql = "insert into t_perm_bizrole (fid, fmasterid, fnumber, fusertype, fstatus, fenable, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fname, fdescription) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        String t_perm_bizrole_l_sql = "insert into t_perm_bizrole_l (fpkid,fid,flocaleid,fname,fdescription) values (?,?,?,?,?)";
        String t_perm_bizrolecomrole_sql = "insert into t_perm_bizrolecomrole (fentryid, fid, fseq, froleid, fenable) values (?,?,?,?,?)";
        String t_perm_bizroleperm_sql = "insert into t_perm_bizroleperm (fentryid, fid, fseq, fpermitemid,fentitytypeid, fbizappid) values (?,?,?,?,?,?)";
        String t_perm_bizroledisperm_sql = "insert into t_perm_bizroledisperm (fentryid, fid, fseq, fpermitemid,fentitytypeid, fbizappid) values (?,?,?,?,?,?)";
        String t_perm_bizroleorg_sql = "insert into t_perm_bizroleorg (fentryid, fid, fseq, forgid, fisincludesuborg, fdimtype) values (?,?,?,?,?,?)";
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrole_sql, t_perm_bizrole_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrole_l_sql, t_perm_bizrole_l_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrolecomrole_sql, t_perm_bizrolecomrole_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroleperm_sql, t_perm_bizroleperm_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroledisperm_sql, t_perm_bizroledisperm_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroleorg_sql, t_perm_bizroleorg_params);
            PermResult permResult = PermResult.ok();
            return permResult;
        }
        catch (Exception e) {
            h.markRollback();
            log.warn("BusiRoleService.add error.", (Throwable)e);
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public PermResult update(BusiRoleAddOrUpdateReq req) {
        super.checkPerm("perm_busirole", "4715a0df000000ac", req);
        super.commonValidate(req, Update.class, PermLog.class);
        List busiRoleList = req.getBusiRoleList();
        ArrayList<Object[]> t_perm_bizrole_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizrole_l_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizrolecomrole_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroleperm_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroledisperm_params = new ArrayList<Object[]>(busiRoleList.size());
        ArrayList<Object[]> t_perm_bizroleorg_params = new ArrayList<Object[]>(busiRoleList.size());
        HashSet<Long> busiRoleIds = new HashSet<Long>(busiRoleList.size());
        for (int i = 0; i < busiRoleList.size(); ++i) {
            BusiRole busiRole = (BusiRole)busiRoleList.get(i);
            Long id = busiRole.getId();
            if (id == null || id == 0L) {
                throw new RuntimeException("busiRole[" + i + "]: " + ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1\u89d2\u8272\u9700\u8981\u4f20\u5165id\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_1", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            this.addOrUpdateBusiroleCheck(busiRole, i);
            busiRoleIds.add(id);
            String number = busiRole.getNumber();
            String name = busiRole.getName();
            String remark = busiRole.getRemark();
            String type = busiRole.getType();
            long currUserId = RequestContext.get().getCurrUserId();
            String localeName = RequestContext.get().getLang().name();
            t_perm_bizrole_params.add(new Object[]{number, type, new Date(), currUserId, name, remark, id});
            t_perm_bizrole_l_params.add(new Object[]{name, remark, id, localeName});
            Set comRoleSet = busiRole.getComRoleSet();
            long[] bizrolecomrole_Ids = DB.genLongIds((String)"t_perm_bizrolecomrole", (int)comRoleSet.size());
            int index = 0;
            for (String comRoleId : comRoleSet) {
                t_perm_bizrolecomrole_params.add(new Object[]{bizrolecomrole_Ids[index++], id, 0, comRoleId, Character.valueOf('1')});
            }
            index = 0;
            Set bizrolePermSet = busiRole.getBizrolePermSet();
            long[] bizroleperm_Ids = DB.genLongIds((String)"t_perm_bizroleperm", (int)bizrolePermSet.size());
            for (PermItem permItem : bizrolePermSet) {
                t_perm_bizroleperm_params.add(new Object[]{bizroleperm_Ids[index++], id, 0, permItem.getPermItemId(), permItem.getEntityNumber(), permItem.getAppId()});
            }
            index = 0;
            Set disPermSet = busiRole.getDisPermSet();
            long[] bizroledisperm_Ids = DB.genLongIds((String)"t_perm_bizroledisperm", (int)disPermSet.size());
            for (PermItem permItem : disPermSet) {
                t_perm_bizroledisperm_params.add(new Object[]{bizroledisperm_Ids[index++], id, 0, permItem.getPermItemId(), permItem.getEntityNumber(), permItem.getAppId()});
            }
            index = 0;
            Set dimSet = busiRole.getDimSet();
            long[] bizroleorg_Ids = DB.genLongIds((String)"t_perm_bizroleorg", (int)dimSet.size());
            for (Dim dim : dimSet) {
                t_perm_bizroleorg_params.add(new Object[]{bizroleorg_Ids[index++], id, 0, dim.getDimId(), dim.getIncludeSub(), dim.getDimType()});
            }
        }
        String t_perm_bizrole_sql = "update t_perm_bizrole set fnumber = ?, fusertype = ? , fmodifytime = ?, fmodifierid = ?, fname = ?, fdescription = ? where fid = ? ";
        String t_perm_bizrole_l_sql = "update t_perm_bizrole_l set fname = ? ,fdescription = ? where fid = ? and flocaleid = ? ";
        String t_perm_bizrolecomrole_sql = "insert into t_perm_bizrolecomrole (fentryid, fid, fseq, froleid, fenable) values (?,?,?,?,?)";
        String t_perm_bizroleperm_sql = "insert into t_perm_bizroleperm (fentryid, fid, fseq, fpermitemid,fentitytypeid, fbizappid) values (?,?,?,?,?,?)";
        String t_perm_bizroledisperm_sql = "insert into t_perm_bizroledisperm (fentryid, fid, fseq, fpermitemid,fentitytypeid, fbizappid) values (?,?,?,?,?,?)";
        String t_perm_bizroleorg_sql = "insert into t_perm_bizroleorg (fentryid, fid, fseq, forgid, fisincludesuborg, fdimtype) values (?,?,?,?,?,?)";
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            this.deleteBusiRoles(busiRoleIds, false);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrole_sql, t_perm_bizrole_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrole_l_sql, t_perm_bizrole_l_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizrolecomrole_sql, t_perm_bizrolecomrole_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroleperm_sql, t_perm_bizroleperm_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroledisperm_sql, t_perm_bizroledisperm_params);
            DB.executeBatch((DBRoute)DBRoute.permission, (String)t_perm_bizroleorg_sql, t_perm_bizroleorg_params);
            PermResult permResult = PermResult.ok();
            return permResult;
        }
        catch (Exception e) {
            h.markRollback();
            log.warn("BusiRoleService.update error.", (Throwable)e);
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public PermResult del(BusiRoleDelReq req) {
        super.checkPerm("perm_busirole", "4715e1f1000000ac", req);
        super.commonValidate(req, Default.class);
        Set busiRoleIdSet = req.getBusiRoleIdSet();
        for (Long busiRoleId : busiRoleIdSet) {
            this.delBusiRoleCheck(busiRoleId);
        }
        try {
            this.deleteBusiRoles(busiRoleIdSet, true);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("BusiRoleService.del error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    public GetBusiRoleAssignedUserResp getAssignedUser(BusiRoleSearchReq req) {
        Long busiRoleId = req.getBusiRoleId();
        if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        HashSet<Long> directAssignedUsers = new HashSet<Long>();
        DynamicObjectCollection assignedUsersCol = QueryServiceHelper.query((String)"perm_userbizrole", (String)"user", (QFilter[])new QFilter[]{new QFilter("bizrole", "=", (Object)busiRoleId)});
        for (DynamicObject assignedUser : assignedUsersCol) {
            directAssignedUsers.add(assignedUser.getLong("user"));
        }
        StringBuilder sql = new StringBuilder("select ugs.fuserid userid from t_perm_usrgrpbizrole ugb ").append("join t_sec_usergroupstaff ugs on ugs.fusergroupid=ugb.fusrgrpid ").append("where ugb.fbizroleid = ? ");
        Set assignedByUserGroupUsers = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{busiRoleId}, rs -> {
            HashSet<Long> result = new HashSet<Long>(10);
            while (rs.next()) {
                result.add(rs.getLong("userid"));
            }
            return result;
        });
        GetBusiRoleAssignedUserResp getBusiRoleAssignedUserResp = new GetBusiRoleAssignedUserResp();
        getBusiRoleAssignedUserResp.setDirectAssignedUsers(directAssignedUsers);
        getBusiRoleAssignedUserResp.setAssignedByUserGroupUsers(assignedByUserGroupUsers);
        return getBusiRoleAssignedUserResp;
    }

    public PermResult getFuncPerm(BusiRoleSearchReq req) {
        try {
            Long busiRoleId = req.getBusiRoleId();
            if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            Set<String> busiRoleHasComRoleIdSet = this.getBusiRoleHasComRoleIdSet(busiRoleId);
            GetComRoleListReq comRoleListReq = new GetComRoleListReq();
            comRoleListReq.setEnable(true);
            comRoleListReq.setComRoleIdSet(busiRoleHasComRoleIdSet);
            HashSet<String> queryRangeSet = new HashSet<String>(1);
            queryRangeSet.add(ComRoleContentEnum.FUNC.getType());
            comRoleListReq.setQueryRangeSet(queryRangeSet);
            List comRoleList = PermRoleHelper.getList((GetComRoleListReq)comRoleListReq);
            HashSet<PermItem> funcPerms = new HashSet<PermItem>(10);
            for (ComRole comRole : comRoleList) {
                Set funcPermSet = comRole.getFuncPermSet();
                if (funcPermSet == null) continue;
                funcPerms.addAll(funcPermSet);
            }
            Set<PermItem> busiRolePerm = this.getBusiRolePermOrDisPerm(busiRoleId, false);
            funcPerms.addAll(busiRolePerm);
            return PermResult.ok(funcPerms);
        }
        catch (RuntimeException e) {
            return PermResult.fail((String)e.getMessage());
        }
    }

    public PermResult getDisPerm(BusiRoleSearchReq req) {
        try {
            Long busiRoleId = req.getBusiRoleId();
            if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            return PermResult.ok(this.getBusiRolePermOrDisPerm(busiRoleId, true));
        }
        catch (RuntimeException e) {
            return PermResult.fail((String)e.getMessage());
        }
    }

    public PermResult getFieldPerm(BusiRoleSearchReq req) {
        try {
            Long busiRoleId = req.getBusiRoleId();
            if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            Set<String> busiRoleHasComRoleIdSet = this.getBusiRoleHasComRoleIdSet(busiRoleId);
            GetComRoleListReq comRoleListReq = new GetComRoleListReq();
            comRoleListReq.setComRoleIdSet(busiRoleHasComRoleIdSet);
            comRoleListReq.setEnable(true);
            HashSet<String> queryRangeSet = new HashSet<String>(1);
            queryRangeSet.add(ComRoleContentEnum.FIELD.getType());
            comRoleListReq.setQueryRangeSet(queryRangeSet);
            List comRoleList = PermRoleHelper.getList((GetComRoleListReq)comRoleListReq);
            HashSet fieldPerms = new HashSet(10);
            for (ComRole comRole : comRoleList) {
                Set fieldPermSet = comRole.getFieldPermSet();
                if (fieldPermSet == null) continue;
                fieldPerms.addAll(fieldPermSet);
            }
            return PermResult.ok(fieldPerms);
        }
        catch (RuntimeException e) {
            return PermResult.fail((String)e.getMessage());
        }
    }

    public GetBusiRoleDataRuleResp getDataRule(BusiRoleSearchReq req) {
        Long busiRoleId = req.getBusiRoleId();
        if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        Set<String> busiRoleHasComRoleIdSet = this.getBusiRoleHasComRoleIdSet(busiRoleId);
        GetComRoleListReq comRoleListReq = new GetComRoleListReq();
        comRoleListReq.setComRoleIdSet(busiRoleHasComRoleIdSet);
        comRoleListReq.setEnable(true);
        HashSet<String> queryRangeSet = new HashSet<String>(1);
        queryRangeSet.add(ComRoleContentEnum.NEWDR.getType());
        comRoleListReq.setQueryRangeSet(queryRangeSet);
        List comRoleList = PermRoleHelper.getList((GetComRoleListReq)comRoleListReq);
        GetBusiRoleDataRuleResp busiRoleDataRuleResp = new GetBusiRoleDataRuleResp();
        HashSet newDrPermSet = new HashSet(10);
        HashSet newDrPrPermSet = new HashSet(10);
        for (ComRole comRole : comRoleList) {
            Set comRoleNewDrPrPermSet;
            Set comRoleNewDrPermSet = comRole.getNewDrPermSet();
            if (comRoleNewDrPermSet != null) {
                newDrPermSet.addAll(comRoleNewDrPermSet);
            }
            if ((comRoleNewDrPrPermSet = comRole.getNewDrPrPermSet()) == null) continue;
            newDrPrPermSet.addAll(comRoleNewDrPrPermSet);
        }
        busiRoleDataRuleResp.setNewDrPermSet(newDrPermSet);
        busiRoleDataRuleResp.setNewDrPrPermSet(newDrPrPermSet);
        return busiRoleDataRuleResp;
    }

    private void checkNumOrNameRepeated(Long id, String prop, Map<String, Long> existPropMap, int index, boolean isNum) {
        if (StringUtils.isEmpty((String)prop)) {
            String mes = isNum ? ResManager.loadKDString((String)"\u5b58\u5728\u201c\u7f16\u7801\u201d\u4e3a\u7a7a\u7684\u6570\u636e\u3002", (String)"BusiRoleService_3", (String)SYSTERM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u201c\u540d\u79f0\u201d\u4e3a\u7a7a\u7684\u6570\u636e\u3002", (String)"BusiRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]);
            throw new RuntimeException("busiRole[" + index + "]: " + mes);
        }
        Set<String> existPropSet = existPropMap.keySet();
        if (id == null) {
            if (existPropSet.contains(prop)) {
                String mes = isNum ? ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d[%s]\u5df2\u5b58\u5728\u3002", (String)"BusiRoleService_5", (String)SYSTERM_TYPE, (Object[])new Object[]{prop}) : ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d[%s]\u5df2\u5b58\u5728\u3002", (String)"BusiRoleService_6", (String)SYSTERM_TYPE, (Object[])new Object[]{prop});
                throw new RuntimeException("busiRole[" + index + "]: " + mes);
            }
        } else {
            Long existId = existPropMap.get(prop);
            if (existId != null && existId != 0L && !existId.equals(id)) {
                String mes = isNum ? ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d[%s]\u5df2\u5b58\u5728\u3002", (String)"BusiRoleService_5", (String)SYSTERM_TYPE, (Object[])new Object[]{prop}) : ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d[%s]\u5df2\u5b58\u5728\u3002", (String)"BusiRoleService_6", (String)SYSTERM_TYPE, (Object[])new Object[]{prop});
                throw new RuntimeException("busiRole[" + index + "]: " + mes);
            }
        }
        existPropMap.put(prop, id);
    }

    private void addOrUpdateBusiroleCheck(BusiRole busiRole, int index) {
        String userType = busiRole.getType();
        if (StringUtils.isEmpty((String)userType)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u79cd\u3002", (String)"BusiRoleService_7", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        String[] userTypeSplit = userType.split(",");
        if (userTypeSplit.length > 5) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"BusiRoleService_8", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        List allUserTypeList = UserServiceHelper.getAllUserType((boolean)false);
        Set allUserTypeSet = allUserTypeList.stream().map(String::valueOf).collect(Collectors.toSet());
        for (String userTypeOne : userTypeSplit) {
            if (allUserTypeSet.contains(userTypeOne)) continue;
            throw new RuntimeException("type[" + (String)userTypeOne + "]invalid;");
        }
        DynamicObjectCollection busiRoleCol = QueryServiceHelper.query((String)"perm_busirole", (String)"id,number,name", null);
        HashMap<String, Long> existNumMap = new HashMap<String, Long>(busiRoleCol.size());
        HashMap<String, Long> existNameMap = new HashMap<String, Long>(busiRoleCol.size());
        for (DynamicObject busiRoleObj : busiRoleCol) {
            long id = busiRoleObj.getLong("id");
            existNumMap.put(busiRoleObj.getString("number"), id);
            String name = busiRoleObj.getString("name");
            if (name == null) continue;
            existNameMap.put(name, id);
        }
        Long id = busiRole.getId();
        String number = busiRole.getNumber();
        this.checkNumOrNameRepeated(id, number, existNumMap, index, true);
        String name = busiRole.getName();
        this.checkNumOrNameRepeated(id, name, existNameMap, index, false);
        Set comRoleSet = busiRole.getComRoleSet();
        if (comRoleSet == null || comRoleSet.isEmpty()) {
            throw new RuntimeException("busiRole[" + index + "]: " + ResManager.loadKDString((String)"\u201c\u901a\u7528\u89d2\u8272\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusiRoleService_9", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        DynamicObjectCollection existComRoleCol = QueryServiceHelper.query((String)"perm_role", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)comRoleSet)});
        if (existComRoleCol.isEmpty()) {
            throw new RuntimeException("busiRole[" + index + "]: " + ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u901a\u7528\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        HashSet<String> existComRoleSet = new HashSet<String>(comRoleSet.size());
        for (DynamicObject existComRole : existComRoleCol) {
            existComRoleSet.add(existComRole.getString("id"));
        }
        comRoleSet.removeAll(existComRoleSet);
        if (!comRoleSet.isEmpty()) {
            log.debug("busiRole[" + index + "]: " + "\u4f20\u5165\u7684\u901a\u7528\u89d2\u8272\u6709\u4e00\u4e9b\u4e0d\u5b58\u5728\uff1a" + comRoleSet.toString());
        }
        busiRole.setComRoleSet(existComRoleSet);
        Set dimSet = busiRole.getDimSet();
        if (dimSet == null || dimSet.isEmpty()) {
            throw new RuntimeException("busiRole[" + index + "]: " + ResManager.loadKDString((String)"\u201c\u9694\u79bb\u7ef4\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusiRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
    }

    private void deleteBusiRoles(Set<Long> busiRoleIds, boolean containBaseInfo) {
        if (busiRoleIds == null || busiRoleIds.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        for (Long busiRoleId : busiRoleIds) {
            if (QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) continue;
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u2014\u2014[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_12", (String)SYSTERM_TYPE, (Object[])new Object[]{busiRoleId}));
        }
        StringBuilder t_perm_bizrole_delsql = null;
        StringBuilder t_perm_bizrole_l_delsql = null;
        StringBuilder t_perm_bizrolecomrole_delsql = new StringBuilder("delete from t_perm_bizrolecomrole where fid in (");
        StringBuilder t_perm_bizroleperm_delsql = new StringBuilder("delete from t_perm_bizroleperm where fid in (");
        StringBuilder t_perm_bizroledisperm_delsql = new StringBuilder("delete from t_perm_bizroledisperm where fid in (");
        StringBuilder t_perm_bizroleorg_delsql = new StringBuilder("delete from t_perm_bizroleorg where fid in (");
        if (containBaseInfo) {
            t_perm_bizrole_delsql = new StringBuilder("delete from t_perm_bizrole where fid in (");
            t_perm_bizrole_l_delsql = new StringBuilder("delete from t_perm_bizrole_l where fid in (");
        }
        for (Long busiRoleId : busiRoleIds) {
            String idStr = "'" + busiRoleId + "',";
            t_perm_bizrolecomrole_delsql.append(idStr);
            t_perm_bizroleperm_delsql.append(idStr);
            t_perm_bizroledisperm_delsql.append(idStr);
            t_perm_bizroleorg_delsql.append(idStr);
            if (!containBaseInfo) continue;
            t_perm_bizrole_delsql.append(idStr);
            t_perm_bizrole_l_delsql.append(idStr);
        }
        t_perm_bizrolecomrole_delsql.deleteCharAt(t_perm_bizrolecomrole_delsql.length() - 1).append(")");
        t_perm_bizroleperm_delsql.deleteCharAt(t_perm_bizroleperm_delsql.length() - 1).append(")");
        t_perm_bizroledisperm_delsql.deleteCharAt(t_perm_bizroledisperm_delsql.length() - 1).append(")");
        t_perm_bizroleorg_delsql.deleteCharAt(t_perm_bizroleorg_delsql.length() - 1).append(")");
        if (containBaseInfo) {
            t_perm_bizrole_delsql.deleteCharAt(t_perm_bizrole_delsql.length() - 1).append(")");
            t_perm_bizrole_l_delsql.deleteCharAt(t_perm_bizrole_l_delsql.length() - 1).append(")");
        }
        try (TXHandle h = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizrolecomrole_delsql.toString());
                DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizroleperm_delsql.toString());
                DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizroledisperm_delsql.toString());
                DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizroleorg_delsql.toString());
                if (containBaseInfo) {
                    DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizrole_delsql.toString());
                    DB.execute((DBRoute)DBRoute.permission, (String)t_perm_bizrole_l_delsql.toString());
                }
            }
            catch (Exception e) {
                log.warn("BusiRoleService.deleteBusiRoles error.", (Throwable)e);
                h.markRollback();
            }
        }
    }

    private void delBusiRoleCheck(Long busiRoleId) {
        QFilter[] qFilter = new QFilter[]{new QFilter("bizrole", "=", (Object)busiRoleId)};
        if (QueryServiceHelper.exists((String)"perm_userbizrole", (QFilter[])qFilter)) {
            throw new RuntimeException("busiRole[" + busiRoleId + "]: " + ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u4e0e\u7528\u6237\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"BusiRoleService_13", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)"perm_usrgrpbusirole", (QFilter[])qFilter)) {
            throw new RuntimeException("busiRole[" + busiRoleId + "]: " + ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u4e0e\u7528\u6237\u7ec4\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"BusiRoleService_14", (String)SYSTERM_TYPE, (Object[])new Object[0]));
        }
    }

    private Set<String> getBusiRoleHasComRoleIdSet(Long busiRoleId) {
        String sql = "select froleid from t_perm_bizrolecomrole where fid = ? ";
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{busiRoleId}, rs -> {
            HashSet<String> result = new HashSet<String>(10);
            while (rs.next()) {
                result.add(rs.getString("froleid"));
            }
            return result;
        });
    }

    private Set<PermItem> getBusiRolePermOrDisPerm(Long busiRoleId, boolean isDisPerm) {
        HashSet<PermItem> result = new HashSet<PermItem>(8);
        String localeName = RequestContext.get().getLang().name();
        String tableName = isDisPerm ? "t_perm_bizroledisperm" : "t_perm_bizroleperm";
        StringBuilder busiRolePermSql = new StringBuilder("select a.fpermitemid permitemid,p.fnumber permitemnum,pl.fname permitemname,a.fentitytypeid entnum,a.fbizappid appid ").append("from ").append(tableName).append(" a ").append("join t_perm_permitem p on p.fid = a.fpermitemid ").append("join t_perm_permitem_l pl on (p.fid = pl.fid and pl.flocaleid = ?) ").append("where a.fid = ? ");
        StringBuilder cloudAppEntSql = new StringBuilder("select ");
        cloudAppEntSql.append("apprtl.fname as appname,app.fid as appid,app.fnumber as appnum, ").append("cloudl.fname as cloudname,cloud.fnumber as cloudnum,cloud.fid as cloudid, ").append("ml.fname as entname,m.fdentityid as entid ").append("from t_meta_bizapp app ").append("left join t_meta_appruntime_l apprtl on (apprtl.fappid = app.fnumber and apprtl.flocaleid = ?) ").append("left join t_meta_bizcloud cloud on app.fbizcloudid=cloud.fid ").append("left join t_meta_bizcloud_l cloudl on (cloudl.fid = cloud.fid and cloudl.flocaleid = ?) ").append("left join t_meta_mainentityinfo m on m.fbizappid = app.fid ").append("left join t_meta_mainentityinfo_l ml on (m.fid = ml.fid and ml.flocaleid = ? ) ");
        try (DataSet busiRolePermSet = DB.queryDataSet((String)"BusiRoleService.getBusiRolePermOrDisPerm.busiRolePermSet", (DBRoute)DBRoute.permission, (String)busiRolePermSql.toString(), (Object[])new Object[]{localeName, busiRoleId});
             DataSet cloudAppEntSet = DB.queryDataSet((String)"BusiRoleService.getBusiRolePermOrDisPerm.cloudAppEntSet", (DBRoute)DBRoute.meta, (String)cloudAppEntSql.toString(), (Object[])new Object[]{localeName, localeName, localeName});
             DataSet resultSet = busiRolePermSet.join(cloudAppEntSet).on("appid", "appid").select(new String[]{"permitemid", "permitemnum", "permitemname", "entnum", "appid"}, new String[]{"appname", "appnum", "cloudname", "cloudnum", "cloudid", "entname", "entid"}).finish();){
            for (Row row : resultSet) {
                PermItem permItem = new PermItem();
                permItem.setPermItemId(row.getString("permitemid"));
                permItem.setPermItemName(row.getString("permitemname"));
                permItem.setPermItemNumber(row.getString("permitemnum"));
                permItem.setAppId(row.getString("appid"));
                permItem.setAppName(row.getString("appname"));
                permItem.setAppNumber(row.getString("appnum"));
                permItem.setEntityId(row.getString("entid"));
                permItem.setEntityName(row.getString("entname"));
                permItem.setEntityNumber(row.getString("entnum"));
                permItem.setCloudId(row.getString("cloudid"));
                permItem.setCloudName(row.getString("cloudname"));
                permItem.setCloudNumber(row.getString("cloudnum"));
                result.add(permItem);
            }
        }
        return result;
    }

    public PermResult getDimObjs(BusiRoleSearchReq req) {
        try {
            Long busiRoleId = req.getBusiRoleId();
            if (!QueryServiceHelper.exists((String)"perm_busirole", (Object)busiRoleId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u3002", (String)"BusiRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            }
            HashSet result = new HashSet(10);
            ArrayList dimIncludeSub = new ArrayList(10);
            String sql = "select forgid,fisincludesuborg from t_perm_bizroleorg where fid = ? and fdimtype = 'bos_org' ";
            DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{busiRoleId}, rs -> {
                while (rs.next()) {
                    long orgId = rs.getLong("forgid");
                    String isIncludeSubOrg = rs.getString("fisincludesuborg");
                    if ("1".equals(isIncludeSubOrg)) {
                        dimIncludeSub.add(orgId);
                    }
                    result.add(orgId);
                }
                return null;
            });
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)15L, dimIncludeSub, (boolean)false, (boolean)true);
            result.addAll(allSubordinateOrgs);
            return PermResult.ok(result);
        }
        catch (RuntimeException e) {
            return PermResult.fail((String)e.getMessage());
        }
    }

    public GetBusiRoleAllPermResp getAllPerm(BusiRoleSearchReq req) {
        GetBusiRoleAllPermResp resp = new GetBusiRoleAllPermResp();
        PermResult funcPerm = this.getFuncPerm(req);
        resp.setFuncPermSet((Set)funcPerm.getData());
        PermResult disPerm = this.getDisPerm(req);
        resp.setDisPermSet((Set)disPerm.getData());
        PermResult fieldPerm = this.getFieldPerm(req);
        resp.setFieldPermSet((Set)fieldPerm.getData());
        GetBusiRoleDataRuleResp dataRule = this.getDataRule(req);
        resp.setNewDrPermSet(dataRule.getNewDrPermSet());
        resp.setNewDrPrPermSet(dataRule.getNewDrPrPermSet());
        return resp;
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map needCheckBeanMap = req.getNeedCheckBeanMap();
        if (null == needCheckBeanMap || needCheckBeanMap.isEmpty()) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, BusiRoleImportBean> passedMap = new HashMap<Integer, BusiRoleImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        BusiRoleService.fullOperationTypeEnum(req);
        for (Map.Entry one : needCheckBeanMap.entrySet()) {
            BusiRoleImportBean willSaveBean = (BusiRoleImportBean)one.getValue();
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        super.beforeSaveCheckExt(req);
        return new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, BusiRoleImportBean willSaveBean, Map<Integer, BusiRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        switch (operationTypeEnum) {
            case ADD: {
                checkResult = this.newImportCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap, checkResult);
                break;
            }
            case UPDATE: {
                checkResult = this.overrideImportCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap, checkResult);
                break;
            }
        }
        return checkResult;
    }

    private boolean overrideImportCheck(PermBeforeSaveCheckReq req, BusiRoleImportBean willSaveBean, Map<Integer, BusiRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap, boolean commonCheckResult) {
        List disFuncPermList;
        List bcFuncPermList;
        List dimObjList;
        List comRoleList;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        List keyFieldList = req.getKeyFieldList();
        if (null == keyFieldList || keyFieldList.isEmpty()) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u5339\u914d\u5b57\u6bb5\u4e0b\u62c9\u5217\u8868\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_17", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        } else {
            Map roleNumberBusiRoleMap;
            Set busiRoles;
            if (keyFieldList.contains("number") && StringUtils.isEmpty((String)roleNum)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_18", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (failFast) {
                    return commonCheckResult && checkResult;
                }
            }
            if (keyFieldList.contains("number") && StringUtils.isNotEmpty((String)roleNum) && (null == (busiRoles = (Set)(roleNumberBusiRoleMap = null == checkNeedParamMap.get("roleNumberBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberBusiRoleMap")).get(roleNum)) || busiRoles.isEmpty())) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_19", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleNum));
                checkResult = false;
                if (failFast) {
                    return commonCheckResult && checkResult;
                }
            }
        }
        if (null != (comRoleList = willSaveBean.getComRoleList()) && !comRoleList.isEmpty()) {
            Map comRoleSetMap = null == checkNeedParamMap.get("comRoleSetMap") ? PermBusiRoleHelper.getComRoleSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("comRoleSetMap");
            Set comRoleSet = (Set)comRoleSetMap.get(roleNum);
            for (BusiRoleComRole comRole : comRoleList) {
                Set comRoleEntryIdSet;
                int lineNum = comRole.getLineNum();
                String entryId = comRole.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    BusiRoleComRole first;
                    if (null == comRoleSet || comRoleSet.isEmpty() || null == (first = (BusiRoleComRole)comRoleSet.stream().filter(x -> Objects.equals(comRole.getBusiRoleNum(), x.getBusiRoleNum()) && Objects.equals(comRole.getComRoleNumber(), x.getComRoleNumber())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u901a\u7528\u89d2\u8272\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"BusiRoleService_20", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == comRoleSet || comRoleSet.isEmpty() || (comRoleEntryIdSet = comRoleSet.stream().map(BusiRoleComRole::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u89d2\u8272\u6ca1\u6709\u8be5\u901a\u7528\u89d2\u8272\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"BusiRoleService_21", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (null != (dimObjList = willSaveBean.getDimObjList()) && !dimObjList.isEmpty()) {
            Map dimObjSetMap = null == checkNeedParamMap.get("dimObjSetMap") ? PermBusiRoleHelper.getDimObjSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("dimObjSetMap");
            Set dimObjSet = (Set)dimObjSetMap.get(roleNum);
            for (BusiRoleDimObj dimObj : dimObjList) {
                Set dimObjeEntryIdSet;
                int lineNum = dimObj.getLineNum();
                String entryId = dimObj.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    BusiRoleDimObj first;
                    if (null == dimObjSet || dimObjSet.isEmpty() || null == (first = (BusiRoleDimObj)dimObjSet.stream().filter(x -> Objects.equals(dimObj.getBusiRoleNum(), x.getBusiRoleNum()) && Objects.equals(dimObj.getDimTypeSmall(), x.getDimTypeSmall()) && Objects.equals(dimObj.getDimNum(), x.getDimNum())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u4fe1\u606f\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"BusiRoleService_22", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == dimObjSet || dimObjSet.isEmpty() || (dimObjeEntryIdSet = dimObjSet.stream().map(BusiRoleDimObj::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u89d2\u8272\u6ca1\u6709\u8be5\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u4fe1\u606f\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"BusiRoleService_23", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (null != (bcFuncPermList = willSaveBean.getBcFuncPermList()) && !bcFuncPermList.isEmpty()) {
            Map bcFuncPermSetMap = null == checkNeedParamMap.get("bcFuncPermSetMap") ? PermBusiRoleHelper.getBcFuncPermSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("bcFuncPermSetMap");
            Set bcFuncPermSet = (Set)bcFuncPermSetMap.get(roleNum);
            for (BusiRoleBcFuncPerm bcFuncPerm : bcFuncPermList) {
                Set bcEntryIdSet;
                if (null == bcFuncPerm) continue;
                int lineNum = bcFuncPerm.getLineNum();
                String entryId = bcFuncPerm.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    BusiRoleBcFuncPerm first;
                    if (null == bcFuncPermSet || bcFuncPermSet.isEmpty() || null == (first = (BusiRoleBcFuncPerm)bcFuncPermSet.stream().filter(x -> Objects.equals(bcFuncPerm.getBusiRoleNum(), x.getBusiRoleNum()) && Objects.equals(bcFuncPerm.getAppNumber(), x.getAppNumber()) && Objects.equals(bcFuncPerm.getEntityNumber(), x.getEntityNumber()) && Objects.equals(bcFuncPerm.getPermItemNumber(), x.getPermItemNumber())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8865\u5145\u6743\u9650\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"BusiRoleService_24", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == bcFuncPermSet || bcFuncPermSet.isEmpty() || (bcEntryIdSet = bcFuncPermSet.stream().map(BusiRoleBcFuncPerm::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u89d2\u8272\u6ca1\u6709\u8be5\u8865\u5145\u6743\u9650\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"BusiRoleService_25", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (null != (disFuncPermList = willSaveBean.getDisFuncPermList()) && !disFuncPermList.isEmpty()) {
            Map disFuncPermSetMap = null == checkNeedParamMap.get("disFuncPermSetMap") ? PermBusiRoleHelper.getDisFuncPermSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("disFuncPermSetMap");
            Set disFuncPermSet = (Set)disFuncPermSetMap.get(roleNum);
            for (BusiRoleDisFuncPerm disFuncPerm : disFuncPermList) {
                Set bcEntryIdSet;
                if (null == disFuncPerm) continue;
                int lineNum = disFuncPerm.getLineNum();
                String entryId = disFuncPerm.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    BusiRoleDisFuncPerm first;
                    if (null == disFuncPermSet || disFuncPermSet.isEmpty() || null == (first = (BusiRoleDisFuncPerm)disFuncPermSet.stream().filter(x -> Objects.equals(disFuncPerm.getBusiRoleNum(), x.getBusiRoleNum()) && Objects.equals(disFuncPerm.getAppNumber(), x.getAppNumber()) && Objects.equals(disFuncPerm.getEntityNumber(), x.getEntityNumber()) && Objects.equals(disFuncPerm.getPermItemNumber(), x.getPermItemNumber())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7981\u7528\u6743\u9650\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"BusiRoleService_26", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == disFuncPermSet || disFuncPermSet.isEmpty() || (bcEntryIdSet = disFuncPermSet.stream().map(BusiRoleDisFuncPerm::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u89d2\u8272\u6ca1\u6709\u8be5\u7981\u7528\u6743\u9650\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"BusiRoleService_27", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (commonCheckResult && checkResult) {
            passedMap.put(roleLineNum, willSaveBean);
        }
        return commonCheckResult && checkResult;
    }

    private boolean newImportCheck(PermBeforeSaveCheckReq req, BusiRoleImportBean willSaveBean, Map<Integer, BusiRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap, boolean commonCheckResult) {
        Map roleNameBusiRoleMap;
        Map roleNumberBusiRoleMap;
        String currentLangRoleName;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        String name = willSaveBean.getName();
        if (StringUtils.isEmpty((String)(roleNum + name))) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6dfb\u52a0\u65b0\u6570\u636e\u65f6\uff0c\u7f16\u7801\u3001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_27", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(currentLangRoleName = willSaveBean.getName()))) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5f53\u524d\u8bed\u8a00\u4e0b\u672a\u8bbe\u7f6e\u89d2\u8272\u540d\u79f0\u3002", (String)"ComRoleService_28", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        String currentNumber = willSaveBean.getNumber();
        Map map = roleNumberBusiRoleMap = null == checkNeedParamMap.get("roleNumberBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{currentNumber}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberBusiRoleMap");
        if (roleNumberBusiRoleMap.containsKey(currentNumber)) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\u3002", (String)"BusiRoleService_17", (String)SYSTERM_TYPE, (Object[])new Object[0]), currentNumber));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        Map map2 = roleNameBusiRoleMap = null == checkNeedParamMap.get("roleNameBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{currentLangRoleName}), (String)"name") : (Map)checkNeedParamMap.get("roleNameBusiRoleMap");
        if (roleNameBusiRoleMap.containsKey(currentLangRoleName)) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u540d\u79f0\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\u3002", (String)"BusiRoleService_18", (String)SYSTERM_TYPE, (Object[])new Object[0]), currentLangRoleName));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        if (commonCheckResult && checkResult) {
            passedMap.put(roleLineNum, willSaveBean);
        }
        return commonCheckResult && checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, BusiRoleImportBean willSaveBean, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        Set adminChargeAppSet;
        AppInfo appInfo;
        Set permItemSet;
        Set entNumSet;
        String permItemId;
        String permItemNumber;
        String entityNumber;
        String appNumber;
        PermItem curPermItem;
        List disFuncPermList;
        List dimObjList;
        List comRoleList;
        String groupNum;
        String status;
        String enable;
        Set<String> collect;
        String[] split;
        String[] split2;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        boolean checkedUserType = false;
        String userTypeName = willSaveBean.getUserTypeName();
        if (StringUtils.isNotEmpty((String)userTypeName) && null != (split2 = userTypeName.split(",")) && split2.length > 0 && split2.length > 5) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"ComRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            checkedUserType = true;
            if (failFast) {
                return checkResult;
            }
        }
        String userTypeStr = willSaveBean.getUserType();
        if (!checkedUserType && StringUtils.isNotEmpty((String)userTypeStr) && null != (split = userTypeStr.split(",")) && split.length > 0 && (split = (collect = Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toSet())).toArray(new String[0])).length > 5) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"ComRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)(enable = willSaveBean.getEnable()))) {
            Map enableMap;
            Map map = enableMap = null == checkNeedParamMap.get("enableMap") ? EnumsEnable.getMap() : (Map)checkNeedParamMap.get("enableMap");
            if (!enableMap.containsKey(enable)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_39", (String)SYSTERM_TYPE, (Object[])new Object[0]), enable));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setEnable(enable);
            }
        }
        if (StringUtils.isNotEmpty((String)(status = willSaveBean.getStatus()))) {
            Map dataStatusMap;
            Map map = dataStatusMap = null == checkNeedParamMap.get("dataStatusMap") ? EnumsDataStatus.getMap() : (Map)checkNeedParamMap.get("dataStatusMap");
            if (!dataStatusMap.containsKey(status)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_15", (String)SYSTERM_TYPE, (Object[])new Object[0]), status));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setStatus(status);
            }
        }
        if (StringUtils.isNotEmpty((String)(groupNum = willSaveBean.getGroupNum()))) {
            Map busiRoleGroupMap = null == checkNeedParamMap.get("busiRoleGroupMap") ? BusiRoleGroupHelper.getNumberGroupMap((Set)Sets.newHashSet((Object[])new String[]{roleNum})) : (Map)checkNeedParamMap.get("busiRoleGroupMap");
            Set busiRoleGroups = (Set)busiRoleGroupMap.get(groupNum);
            if (null == busiRoleGroups || busiRoleGroups.isEmpty()) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5206\u7ec4\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_15", (String)SYSTERM_TYPE, (Object[])new Object[0]), groupNum));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                BusiRoleGroup first = busiRoleGroups.stream().findFirst().orElse(null);
                if (null != first) {
                    willSaveBean.setGroupId(first.getId());
                }
            }
        }
        if (null != (comRoleList = willSaveBean.getComRoleList()) && !comRoleList.isEmpty()) {
            for (BusiRoleComRole busiRoleComRole : comRoleList) {
                Map<String, Set<ComRole>> adminGroupRoleRangeMap;
                Map comRoleNumberComRoleMap;
                int lineNum = busiRoleComRole.getLineNum();
                String comRoleNumber = busiRoleComRole.getComRoleNumber();
                if (!StringUtils.isNotEmpty((String)comRoleNumber)) continue;
                Map map = comRoleNumberComRoleMap = null == checkNeedParamMap.get("comRoleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{comRoleNumber}), (String)"number") : (Map)checkNeedParamMap.get("comRoleNumberComRoleMap");
                if (!comRoleNumberComRoleMap.containsKey(comRoleNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_16", (String)SYSTERM_TYPE, (Object[])new Object[0]), comRoleNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if ((adminGroupRoleRangeMap = null == checkNeedParamMap.get("adminGroupRoleRangeMap") ? ComRoleService.getAdminGroupRoleRangeMap(Sets.newHashSet((Object[])new String[]{comRoleNumber}), "number") : (Map<String, Set<ComRole>>)checkNeedParamMap.get("adminGroupRoleRangeMap")).containsKey(comRoleNumber)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ComRoleService_20", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleNum));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        if (null != (dimObjList = willSaveBean.getDimObjList()) && !dimObjList.isEmpty()) {
            Map bigPermCtrlTypeMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            for (BusiRoleDimObj dimObj : dimObjList) {
                Boolean includeSub;
                PermCtrlType bigPermCtrlType;
                int lineNum = dimObj.getLineNum();
                String dimTypeBig = dimObj.getDimTypeBig();
                String dimTypeSmall = dimObj.getDimTypeSmall();
                String dimNum = dimObj.getDimNum();
                if (StringUtils.isNotEmpty((String)dimTypeBig) && null == (bigPermCtrlType = (PermCtrlType)bigPermCtrlTypeMap.get(dimTypeBig))) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimTypeBig));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)dimTypeSmall) && StringUtils.isNotEmpty((String)dimNum)) {
                    Set hasPermDimSet;
                    Dim dim;
                    Set dimdyns;
                    DynamicObject dyn;
                    Map dimNumExistMap;
                    HashMap<String, Map> dimTypeDimNumExistMap = null;
                    if (null == checkNeedParamMap.get("dimTypeDimNumExistMap")) {
                        dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimTypeSmall, (Set)Sets.newHashSet((Object[])new String[]{dimNum}));
                        dimTypeDimNumExistMap = new HashMap<String, Map>(8);
                        dimTypeDimNumExistMap.put(dimTypeSmall, dimNumExistMap);
                    } else {
                        dimTypeDimNumExistMap = (HashMap<String, Map>)checkNeedParamMap.get("dimTypeDimNumExistMap");
                    }
                    if (!(CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimTypeSmall))) || null != (dimNumExistMap = (Map)dimTypeDimNumExistMap.get(dimTypeSmall)).get(dimNum) && ((Boolean)dimNumExistMap.get(dimNum)).booleanValue())) {
                        this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    }
                    if (CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimTypeSmall)))) {
                        this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    }
                    Map<String, Map> dimTypeDimNumDimDynMap = null;
                    if (null == checkNeedParamMap.get("dimTypeDimNumDimDynMap")) {
                        dimTypeDimNumDimDynMap = new HashMap(8);
                        Map dimNumDimDynSetMap = IsoDimHelper.getDimDynSetMap((Set)Sets.newHashSet((Object[])new String[]{dimNum}), (String)"number", (String)dimTypeSmall);
                        dimTypeDimNumDimDynMap.put(dimTypeSmall, dimNumDimDynSetMap);
                    } else {
                        dimTypeDimNumDimDynMap = (Map)checkNeedParamMap.get("dimTypeDimNumDimDynMap");
                    }
                    Map dimNumDimDynMap = (Map)dimTypeDimNumDimDynMap.get(dimTypeSmall);
                    if (!CollectionUtils.isEmpty((Map)dimNumDimDynMap) && !CollectionUtils.isEmpty((Collection)((Collection)dimNumDimDynMap.get(dimNum))) && null != (dyn = (DynamicObject)(dimdyns = (Set)dimNumDimDynMap.get(dimNum)).stream().findFirst().orElse(null))) {
                        dimObj.setDimDyn(dyn);
                    }
                    GetHasPermPermCtrlObjResp hasPermDimResult = null;
                    if (null == checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap")) {
                        hasPermDimResult = PermCtrlTypeService.getAdminHasPermPermCtrlObj(new GetHasPermPermCtrlObjReq(dimTypeSmall, Long.valueOf(RequestContext.get().getCurrUserId()), null, (Set)Sets.newHashSet((Object[])new String[]{dimNum})));
                    } else {
                        Map dimTypeAdminHasPermPermCtrlObjMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap");
                        GetHasPermPermCtrlObjResp getHasPermPermCtrlObjResp = hasPermDimResult = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermPermCtrlObjMap) ? null : (GetHasPermPermCtrlObjResp)dimTypeAdminHasPermPermCtrlObjMap.get(dimTypeSmall);
                    }
                    if (null != hasPermDimResult && !hasPermDimResult.isHasAllDimPerm() && null == (dim = (Dim)(hasPermDimSet = hasPermDimResult.getHasPermDimSet()).stream().filter(x -> Objects.equals(dimNum, x.getDimNumber())).findFirst().orElse(null))) {
                        this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    }
                    if (StringUtils.isEmpty((String)dimTypeSmall) && null == hasPermDimResult) {
                        this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    }
                }
                if (null != (includeSub = dimObj.getIncludeSub())) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u662f\u6216\u5426\u3002", (String)"UserRoleService_17", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        Map appNumExistMap = null;
        Map entNumExistMap = null;
        Map permItemNumExistMap = null;
        Map permItemExistMap = null;
        HashSet plainPermItemSet = null;
        HashMap<String, Set> appNumEntNumSetMap = null;
        HashMap<String, Set> entNumPermItemNumSetMap = null;
        List bcFuncPermList = null == willSaveBean.getBcFuncPermList() ? new ArrayList(0) : willSaveBean.getBcFuncPermList();
        List list = disFuncPermList = null == willSaveBean.getDisFuncPermList() ? new ArrayList(0) : willSaveBean.getDisFuncPermList();
        if (null != bcFuncPermList && !bcFuncPermList.isEmpty() || null != disFuncPermList && !disFuncPermList.isEmpty()) {
            appNumExistMap = null == checkNeedParamMap.get("appNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_devportal_bizapp", null) : (Map)checkNeedParamMap.get("appNumExistMap");
            entNumExistMap = null == checkNeedParamMap.get("entNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_entityobject", null) : (Map)checkNeedParamMap.get("entNumExistMap");
            permItemNumExistMap = null == checkNeedParamMap.get("permItemNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"perm_permitem", null) : (Map)checkNeedParamMap.get("permItemNumExistMap");
            Set collect2 = bcFuncPermList.stream().map(PermItem::getPermItemId).collect(Collectors.toSet());
            Set collect22 = disFuncPermList.stream().map(PermItem::getPermItemId).collect(Collectors.toSet());
            collect2.addAll(collect22);
            Map map = permItemExistMap = null == checkNeedParamMap.get("permItemExistMap") ? PermItemHelper.getPermItemMap(collect2) : (Map)checkNeedParamMap.get("permItemExistMap");
            if (null == checkNeedParamMap.get("plainPermItemSet")) {
                GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
                getPlainPermItemListReq.setDimType("DIM_ORG");
                getPlainPermItemListReq.setReturnByField(true);
                getPlainPermItemListReq.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
                List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
                plainPermItemSet = new HashSet(plainPermItemList);
                appNumEntNumSetMap = new HashMap<String, Set>(8);
                entNumPermItemNumSetMap = new HashMap<String, Set>(8);
                for (PermItem permItem : plainPermItemSet) {
                    appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                    entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
                }
            } else {
                plainPermItemSet = (HashSet)checkNeedParamMap.get("plainPermItemSet");
                appNumEntNumSetMap = (Map)checkNeedParamMap.get("appNumEntNumSetMap");
                entNumPermItemNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("entNumPermItemNumSetMap");
            }
        }
        if (null != bcFuncPermList && !bcFuncPermList.isEmpty()) {
            curPermItem = null;
            for (BusiRoleBcFuncPerm bcFuncPerm : bcFuncPermList) {
                if (null == bcFuncPerm) continue;
                int lineNum = bcFuncPerm.getLineNum();
                curPermItem = new PermItem();
                appNumber = bcFuncPerm.getAppNumber();
                if (null == appNumExistMap.get(appNumber) || !((Boolean)appNumExistMap.get(appNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null == entNumExistMap.get(entityNumber = bcFuncPerm.getEntityNumber()) || !((Boolean)entNumExistMap.get(entityNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_45", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemNumber = bcFuncPerm.getPermItemNumber())) && (null == permItemNumExistMap.get(permItemNumber) || !((Boolean)permItemNumExistMap.get(permItemNumber)).booleanValue())) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_46", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemId = bcFuncPerm.getPermItemId())) && null == permItemExistMap.get(permItemId)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879id\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_59", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemId));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null != (entNumSet = (Set)appNumEntNumSetMap.get(appNumber)) && !entNumSet.contains(entityNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_47", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber, entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                permItemSet = (Set)entNumPermItemNumSetMap.get(entityNumber);
                if (StringUtils.isNotEmpty((String)permItemNumber) && null != permItemSet && !permItemSet.contains(permItemNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_48", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber, permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                curPermItem.setAppNumber(appNumber);
                curPermItem.setEntityNumber(entityNumber);
                curPermItem.setPermItemNumber(permItemNumber);
                appInfo = null;
                appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)appNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(appNumber);
                Set set = adminChargeAppSet = null == checkNeedParamMap.get("adminChargeAppSet") ? new HashSet(AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)) : (Set)checkNeedParamMap.get("adminChargeAppSet");
                if (null != appInfo && adminChargeAppSet.contains(appInfo.getId())) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getBcPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleService_49", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        if (null != disFuncPermList && !disFuncPermList.isEmpty()) {
            curPermItem = null;
            for (BusiRoleDisFuncPerm disFuncPerm : disFuncPermList) {
                if (null == disFuncPerm) continue;
                int lineNum = disFuncPerm.getLineNum();
                curPermItem = new PermItem();
                appNumber = disFuncPerm.getAppNumber();
                if (null == appNumExistMap.get(appNumber) || !((Boolean)appNumExistMap.get(appNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null == entNumExistMap.get(entityNumber = disFuncPerm.getEntityNumber()) || !((Boolean)entNumExistMap.get(entityNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_45", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemNumber = disFuncPerm.getPermItemNumber())) && (null == permItemNumExistMap.get(permItemNumber) || !((Boolean)permItemNumExistMap.get(permItemNumber)).booleanValue())) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_46", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemId = disFuncPerm.getPermItemId())) && null == permItemExistMap.get(permItemId)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879id\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_59", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemId));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null != (entNumSet = (Set)appNumEntNumSetMap.get(appNumber)) && !entNumSet.contains(entityNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_47", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber, entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                permItemSet = (Set)entNumPermItemNumSetMap.get(entityNumber);
                if (StringUtils.isNotEmpty((String)permItemNumber) && null != permItemSet && !permItemSet.contains(permItemNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_48", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber, permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                curPermItem.setAppNumber(appNumber);
                curPermItem.setEntityNumber(entityNumber);
                curPermItem.setPermItemNumber(permItemNumber);
                appInfo = null;
                appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)appNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(appNumber);
                Set set = adminChargeAppSet = null == checkNeedParamMap.get("adminChargeAppSet") ? new HashSet(AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)) : (Set)checkNeedParamMap.get("adminChargeAppSet");
                if (null != appInfo && adminChargeAppSet.contains(appInfo.getId())) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ConstantsHelper.getForbidPerm2() + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleService_49", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        return checkResult;
    }

    private static void fullOperationTypeEnum(PermBeforeSaveCheckReq req) {
        Map needCheckBeanMap = req.getNeedCheckBeanMap();
        if (null == needCheckBeanMap || needCheckBeanMap.isEmpty()) {
            return;
        }
        HashMap checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            checkNeedParamMap = new HashMap(8);
            req.setCheckNeedParamMap(checkNeedParamMap);
        }
        EnumsImportType enumsImportType = req.getEnumsImportType();
        for (Map.Entry one : needCheckBeanMap.entrySet()) {
            BusiRoleImportBean value = (BusiRoleImportBean)one.getValue();
            if (null == value) continue;
            if (EnumsImportType.NEW == enumsImportType) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            if (EnumsImportType.OVERRIDE == enumsImportType) {
                value.setOperationTypeEnum(OperationTypeEnum.UPDATE);
                continue;
            }
            if (EnumsImportType.OVERRIDENEW != enumsImportType) continue;
            String number = value.getNumber();
            if (StringUtils.isEmpty((String)number)) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            Map roleNumberBusiRoleMap = null == checkNeedParamMap.get("roleNumberBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{value.getNumber()}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberBusiRoleMap");
            Set busiRoles = (Set)roleNumberBusiRoleMap.get(number);
            if (null == busiRoles || busiRoles.isEmpty()) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            value.setOperationTypeEnum(OperationTypeEnum.UPDATE);
        }
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            BusiRoleAfterSaveReq req = (BusiRoleAfterSaveReq)reqOri;
            Set busiRoleIdSet = req.getMainIdSet();
            if (null != busiRoleIdSet && !busiRoleIdSet.isEmpty()) {
                HashMap<String, Map<String, Object>> bizRoleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(8);
                HashMap<String, Object> preDataMap = new HashMap<String, Object>(8);
                CacheMrg.clearAllCache();
                Map afterDataMap = PermBusiRoleLogHelper.busiRoleEventImage((Set)busiRoleIdSet, (boolean)true, (boolean)true);
                String preDataMapStr = req.getPreDataMapStr();
                if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                    String uncompress = StrUtil.uncompress((String)preDataMapStr);
                    preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, Map.class));
                }
                String langStr = RequestContext.get().getLang().name();
                for (String busiRoleId : busiRoleIdSet) {
                    Map afterDataForOneMap = (Map)afterDataMap.get(busiRoleId);
                    Set assignedUserIdStrSet = null == afterDataForOneMap.get("roleUserIdSet") ? new HashSet(1) : (Set)afterDataForOneMap.get("roleUserIdSet");
                    Set<Long> assignedUserIdSet = assignedUserIdStrSet.stream().map(Long::valueOf).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(assignedUserIdSet)) {
                        UserHasPermOrgCache.clearUserLoginOrgs(assignedUserIdSet);
                    }
                    this.cancelShowFormOfSave(bizRoleIdSaveDiffMap, preDataMap, afterDataMap, langStr, busiRoleId, assignedUserIdSet);
                }
                PermLogReq permLogReq = req.getPermLogReq();
                this.saveOrDelPermLog(permLogReq, busiRoleIdSet, bizRoleIdSaveDiffMap, preDataMap);
            }
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("BusiRoleService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private void cancelShowFormOfSave(Map<String, Map<String, Object>> bizRoleIdSaveDiffMap, Map<String, Object> preDataMap, Map<String, Object> afterDataMap, String langStr, String busiRoleId, Set<Long> assignedUserIdSet) {
        try {
            List newDRAppEntityList = null;
            Map<String, Object> saveDiffMap = this.getSaveDiffMap(busiRoleId, preDataMap, afterDataMap);
            bizRoleIdSaveDiffMap.put(busiRoleId, saveDiffMap);
            if (null == assignedUserIdSet || CollectionUtils.isEmpty(assignedUserIdSet)) {
                return;
            }
            Set delComRole = (Set)saveDiffMap.get("delComRole");
            Set addComRole = (Set)saveDiffMap.get("addComRole");
            Set updateComRole = (Set)saveDiffMap.get("updateComRole");
            Set delDimObj = (Set)saveDiffMap.get("delDimObj");
            Set addDimObj = (Set)saveDiffMap.get("addDimObj");
            Set updateDimObj = (Set)saveDiffMap.get("updateDimObj");
            Set addBcFuncPerm = (Set)saveDiffMap.get("addBcFuncPerm");
            BusiRoleService.addUsersLic(assignedUserIdSet, addComRole, addBcFuncPerm);
            if (!PermCommonUtil.isEnableAuthorityChangeNotice()) {
                return;
            }
            if (!(CollectionUtils.isEmpty((Collection)delComRole) && CollectionUtils.isEmpty((Collection)addComRole) && CollectionUtils.isEmpty((Collection)updateComRole) && CollectionUtils.isEmpty((Collection)delDimObj) && CollectionUtils.isEmpty((Collection)addDimObj) && CollectionUtils.isEmpty((Collection)updateDimObj))) {
                HashSet newDRAppEntityAllSet = new HashSet(16);
                if (!(CollectionUtils.isEmpty((Collection)delComRole) && CollectionUtils.isEmpty((Collection)addComRole) && CollectionUtils.isEmpty((Collection)updateComRole))) {
                    Set newDRAppEntitySet;
                    LogNewDataRuleWrapper newDataRule;
                    for (BusiRoleComRole one : delComRole) {
                        if (Objects.equals("0", one.getComRoleEnable())) continue;
                        newDataRule = PermRoleLogHelper.getNewDataRule((String)one.getComRoleId(), (String)langStr);
                        newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                    for (BusiRoleComRole one : addComRole) {
                        if (Objects.equals("0", one.getComRoleEnable())) continue;
                        newDataRule = PermRoleLogHelper.getNewDataRule((String)one.getComRoleId(), (String)langStr);
                        newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                    for (BusiRoleComRole one : updateComRole) {
                        if (Objects.equals("0", one.getComRoleEnable())) continue;
                        newDataRule = PermRoleLogHelper.getNewDataRule((String)one.getComRoleId(), (String)langStr);
                        newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                } else {
                    Set comRoleSetDB_after = new HashSet(1);
                    Map sucAfterData = (Map)afterDataMap.get(busiRoleId);
                    if (null != sucAfterData && !sucAfterData.isEmpty()) {
                        comRoleSetDB_after = (Set)sucAfterData.get("comRoleSetDB");
                        comRoleSetDB_after = null == comRoleSetDB_after || comRoleSetDB_after.isEmpty() ? new HashSet(1) : comRoleSetDB_after;
                    }
                    for (BusiRoleComRole one : comRoleSetDB_after) {
                        if ("0".equals(one.getComRoleEnable())) continue;
                        LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)one.getComRoleId(), (String)langStr);
                        Set newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                }
                if (!CollectionUtils.isEmpty(newDRAppEntityAllSet)) {
                    newDRAppEntityList = newDRAppEntityAllSet.stream().map(x -> {
                        String[] split = x.split("\\|", 2);
                        HashMap<String, String> map = new HashMap<String, String>(2);
                        map.put(split[0], split[1]);
                        return map;
                    }).collect(Collectors.toList());
                }
            }
            PermCommonUtil.cancelShowForm(new ArrayList<Long>(assignedUserIdSet), newDRAppEntityList, (boolean)false);
        }
        catch (Exception e) {
            log.warn("BusiRoleService.cancelShowFormOfSave error", (Throwable)e);
        }
    }

    private static void addUsersLic(Set<Long> assignedUserIdSet, Set<BusiRoleComRole> addComRole, Set<BusiRoleBcFuncPerm> addBcFuncPerm) {
        Object rolePermSetMap;
        if (CollectionUtils.isEmpty(addComRole) && CollectionUtils.isEmpty(addBcFuncPerm)) {
            return;
        }
        HashMap<String, Set> appEntitySetMap = new HashMap<String, Set>(8);
        Set comroleIdSet = addComRole.stream().map(BusiRoleComRole::getComRoleId).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(comroleIdSet) && !CollectionUtils.isEmpty((Map)(rolePermSetMap = PermRoleHelper.getRolePermSetMap(comroleIdSet, (String)"id")))) {
            for (Map.Entry rolePermSet : rolePermSetMap.entrySet()) {
                Set value = (Set)rolePermSet.getValue();
                if (null == value || value.isEmpty()) continue;
                for (ComRoleFuncPerm comRoleFuncPerm : value) {
                    appEntitySetMap.computeIfAbsent(comRoleFuncPerm.getAppId(), k -> new HashSet()).add(comRoleFuncPerm.getEntityNumber());
                }
            }
        }
        for (BusiRoleBcFuncPerm addBcFunc : addBcFuncPerm) {
            appEntitySetMap.computeIfAbsent(addBcFunc.getAppId(), k -> new HashSet()).add(addBcFunc.getEntityNumber());
        }
        if (!CollectionUtils.isEmpty(assignedUserIdSet) && !CollectionUtils.isEmpty(appEntitySetMap)) {
            HashMap<String, List> appEntityMap = new HashMap<String, List>(8);
            for (Map.Entry appEntitySet : appEntitySetMap.entrySet()) {
                appEntityMap.computeIfAbsent((String)appEntitySet.getKey(), k -> new ArrayList(10)).addAll((Collection)appEntitySet.getValue());
            }
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList<Long>(assignedUserIdSet), appEntityMap);
        }
    }

    public void saveOrDelPermLog(PermLogReq permLogReq, Set<String> bizRoleIdSet, Map<String, Map<String, Object>> bizRoleIdSaveDiffMap, Map<String, Object> preDataMap) {
        if (!PermCommonUtil.isEnablePermLog()) {
            return;
        }
        if (null == permLogReq || null == bizRoleIdSet || bizRoleIdSet.isEmpty() || null == bizRoleIdSaveDiffMap || bizRoleIdSaveDiffMap.isEmpty()) {
            return;
        }
        try {
            Map roleIdBusiRoleMap = PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap(bizRoleIdSet, (String)"id");
            int size = bizRoleIdSet.size();
            ArrayList list = new ArrayList(size);
            for (String bizRoleId : bizRoleIdSet) {
                Map<String, Object> bizRoleIdSaveDiff;
                String bizRoleIdSetStr = String.valueOf(bizRoleId);
                boolean del = permLogReq.getBusiType().contains("_del");
                Set busiRoles = (Set)roleIdBusiRoleMap.get(bizRoleIdSetStr);
                if (!del && (null == busiRoles || busiRoles.isEmpty()) || null == (bizRoleIdSaveDiff = bizRoleIdSaveDiffMap.get(bizRoleId)) || bizRoleIdSaveDiff.isEmpty()) continue;
                String opItemId = bizRoleId;
                String opItemName = "";
                String opItemNumber = "";
                if (del) {
                    Map preData = (Map)preDataMap.get(opItemId);
                    if (null != preData && !preData.isEmpty()) {
                        BusiRole baseInfoDB_pre;
                        ObjectMapper baseInfoMapper = new ObjectMapper();
                        BusiRole busiRole = baseInfoDB_pre = null == preData.get("baseInfoDB") ? new BusiRole() : (BusiRole)baseInfoMapper.readValue(baseInfoMapper.writeValueAsString(preData.get("baseInfoDB")), BusiRole.class);
                        if (null != baseInfoDB_pre) {
                            opItemName = baseInfoDB_pre.getName();
                            opItemNumber = baseInfoDB_pre.getNumber();
                        }
                    }
                } else {
                    Optional first = busiRoles.stream().findFirst();
                    BusiRole busiRole = (BusiRole)first.get();
                    if (null == busiRole) continue;
                    opItemName = busiRole.getName();
                    opItemNumber = busiRole.getNumber();
                }
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", permLogReq.getCloudId());
                map.put("app_id", permLogReq.getAppId());
                map.put("form_identity", permLogReq.getFormIdentity());
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", permLogReq.getPreData());
                map.put("after_data", permLogReq.getAfterData());
                String saveDiffStr = StrUtil.compress((String)new ObjectMapper().writeValueAsString(bizRoleIdSaveDiff));
                map.put("diff_content", saveDiffStr);
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("BusiRoleService.saveOrDelPermLog error, bizRoleIdSet:{}", (Object)JSON.toJSONString(bizRoleIdSet), (Object)e);
        }
    }

    public Map<String, Object> getSaveDiffMap(String opItemId, Map<String, Object> preDataMap, Map<String, Object> sucAfterDataMap) {
        try {
            Map preData = (Map)preDataMap.get(opItemId);
            BusiRole baseInfoDB_pre = new BusiRole();
            HashSet comRoleSetDB_pre = new HashSet(1);
            HashSet dimObjSetDB_pre = new HashSet(1);
            HashSet bcFuncPermSetDB_pre = new HashSet(1);
            HashSet disFuncPermSetDB_pre = new HashSet(1);
            if (null != preData && !preData.isEmpty()) {
                ObjectMapper baseInfoMapper = new ObjectMapper();
                baseInfoDB_pre = null == preData.get("baseInfoDB") ? baseInfoDB_pre : (BusiRole)baseInfoMapper.readValue(baseInfoMapper.writeValueAsString(preData.get("baseInfoDB")), BusiRole.class);
                ObjectMapper comRoleMapper = new ObjectMapper();
                comRoleSetDB_pre = null == preData.get("comRoleSetDB") ? comRoleSetDB_pre : (Set)comRoleMapper.readValue(comRoleMapper.writeValueAsString(preData.get("comRoleSetDB")), comRoleMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{BusiRoleComRole.class}));
                ObjectMapper dimObjMapper = new ObjectMapper();
                dimObjSetDB_pre = null == preData.get("dimObjSetDB") ? dimObjSetDB_pre : (Set)dimObjMapper.readValue(dimObjMapper.writeValueAsString(preData.get("dimObjSetDB")), dimObjMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{BusiRoleDimObj.class}));
                ObjectMapper bcFuncPermMapper = new ObjectMapper();
                bcFuncPermSetDB_pre = null == preData.get("bcFuncPermSetDB") ? bcFuncPermSetDB_pre : (Set)bcFuncPermMapper.readValue(bcFuncPermMapper.writeValueAsString(preData.get("bcFuncPermSetDB")), bcFuncPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{BusiRoleBcFuncPerm.class}));
                ObjectMapper disFuncPermMapper = new ObjectMapper();
                disFuncPermSetDB_pre = null == preData.get("disFuncPermSetDB") ? disFuncPermSetDB_pre : (Set)disFuncPermMapper.readValue(disFuncPermMapper.writeValueAsString(preData.get("disFuncPermSetDB")), disFuncPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{BusiRoleDisFuncPerm.class}));
            }
            Map sucAfterData = (Map)sucAfterDataMap.get(opItemId);
            BusiRole baseInfoDB_after = new BusiRole();
            Set comRoleSetDB_after = new HashSet(1);
            Set dimObjSetDB_after = new HashSet(1);
            Set bcFuncPermSetDB_after = new HashSet(1);
            Set disFuncPermSetDB_after = new HashSet(1);
            Set roleUserIdSet_after = new HashSet(1);
            if (null != sucAfterData && !sucAfterData.isEmpty()) {
                baseInfoDB_after = (BusiRole)sucAfterData.get("baseInfoDB");
                comRoleSetDB_after = (Set)sucAfterData.get("comRoleSetDB");
                comRoleSetDB_after = null == comRoleSetDB_after || comRoleSetDB_after.isEmpty() ? new HashSet(1) : comRoleSetDB_after;
                dimObjSetDB_after = (Set)sucAfterData.get("dimObjSetDB");
                dimObjSetDB_after = null == dimObjSetDB_after || dimObjSetDB_after.isEmpty() ? new HashSet(1) : dimObjSetDB_after;
                bcFuncPermSetDB_after = (Set)sucAfterData.get("bcFuncPermSetDB");
                bcFuncPermSetDB_after = null == bcFuncPermSetDB_after || bcFuncPermSetDB_after.isEmpty() ? new HashSet(1) : bcFuncPermSetDB_after;
                disFuncPermSetDB_after = (Set)sucAfterData.get("disFuncPermSetDB");
                disFuncPermSetDB_after = null == disFuncPermSetDB_after || disFuncPermSetDB_after.isEmpty() ? new HashSet(1) : disFuncPermSetDB_after;
                roleUserIdSet_after = (Set)sucAfterData.get("roleUserIdSet");
                roleUserIdSet_after = null == roleUserIdSet_after || roleUserIdSet_after.isEmpty() ? new HashSet(1) : roleUserIdSet_after;
            }
            List delComRole = ListUtil.removeAll(new ArrayList(comRoleSetDB_pre), new ArrayList(comRoleSetDB_after));
            List addComRole = ListUtil.removeAll(new ArrayList(comRoleSetDB_after), new ArrayList(comRoleSetDB_pre));
            ArrayList updateComRole = new ArrayList(10);
            List delDimObj = ListUtil.removeAll(new ArrayList(dimObjSetDB_pre), new ArrayList(dimObjSetDB_after));
            List addDimObj = ListUtil.removeAll(new ArrayList(dimObjSetDB_after), new ArrayList(dimObjSetDB_pre));
            ArrayList updateDimObj = new ArrayList(10);
            List delBcFuncPerm = ListUtil.removeAll(new ArrayList(bcFuncPermSetDB_pre), new ArrayList(bcFuncPermSetDB_after));
            List addBcFuncPerm = ListUtil.removeAll(new ArrayList(bcFuncPermSetDB_after), new ArrayList(bcFuncPermSetDB_pre));
            ArrayList updateBcFuncPerm = new ArrayList(10);
            List delDisFuncPerm = ListUtil.removeAll(new ArrayList(disFuncPermSetDB_pre), new ArrayList(disFuncPermSetDB_after));
            List addDisFuncPerm = ListUtil.removeAll(new ArrayList(disFuncPermSetDB_after), new ArrayList(disFuncPermSetDB_pre));
            ArrayList updateDisFuncPerm = new ArrayList(10);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(16);
            diffMap.put("baseInfoDB_pre", baseInfoDB_pre);
            diffMap.put("baseInfoDB_after", baseInfoDB_after);
            diffMap.put("delComRole", new HashSet(delComRole));
            diffMap.put("addComRole", new HashSet(addComRole));
            diffMap.put("updateComRole", new HashSet(updateComRole));
            diffMap.put("delDimObj", new HashSet(delDimObj));
            diffMap.put("addDimObj", new HashSet(addDimObj));
            diffMap.put("updateDimObj", new HashSet(updateDimObj));
            diffMap.put("delBcFuncPerm", new HashSet(delBcFuncPerm));
            diffMap.put("addBcFuncPerm", new HashSet(addBcFuncPerm));
            diffMap.put("updateBcFuncPerm", new HashSet(updateBcFuncPerm));
            diffMap.put("delDisFuncPerm", new HashSet(delDisFuncPerm));
            diffMap.put("addDisFuncPerm", new HashSet(addDisFuncPerm));
            diffMap.put("updateDisFuncPerm", new HashSet(updateDisFuncPerm));
            diffMap.put("influenUserIdSet", roleUserIdSet_after);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            return diffMap;
        }
        catch (Exception e) {
            log.warn("BusiRoleService.getSaveDiffMap error.", (Throwable)e);
            return new HashMap<String, Object>(0);
        }
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            BusiRoleAfterDelReq req = (BusiRoleAfterDelReq)reqOri;
            Set busiRoleIdSet = req.getMainIdSet();
            if (null != busiRoleIdSet && !busiRoleIdSet.isEmpty()) {
                HashMap<String, Map<String, Object>> bizRoleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(8);
                HashMap<String, Object> preDataMap = new HashMap<String, Object>(8);
                BusiRoleService.delBizRoleRelationData(busiRoleIdSet);
                if (PermCommonUtil.isEnablePermLog()) {
                    String preDataMapStr = req.getPreDataMapStr();
                    if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                        String uncompress = StrUtil.uncompress((String)preDataMapStr);
                        preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, Map.class));
                    }
                    Map afterDataMap = PermBusiRoleLogHelper.busiRoleEventImage((Set)busiRoleIdSet, (boolean)true, (boolean)true);
                    for (String busiRoleId : busiRoleIdSet) {
                        Map<String, Object> saveDiffMap = this.getSaveDiffMap(busiRoleId, preDataMap, afterDataMap);
                        bizRoleIdSaveDiffMap.put(busiRoleId, saveDiffMap);
                    }
                }
                PermLogReq permLogReq = req.getPermLogReq();
                this.saveOrDelPermLog(permLogReq, busiRoleIdSet, bizRoleIdSaveDiffMap, preDataMap);
            }
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("BusiRoleService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private static void delBizRoleRelationData(Set<String> busiRoleIdSet) {
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                Object[] bizRoleIdArr = busiRoleIdSet.stream().map(Long::valueOf).toArray();
                SqlBuilder bizRolePermSql = new SqlBuilder();
                bizRolePermSql.append("delete from t_perm_bizroleperm ", new Object[0]);
                bizRolePermSql.appendIn(" where fid ", bizRoleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)bizRolePermSql);
                SqlBuilder bizRoleDisPermSql = new SqlBuilder();
                bizRoleDisPermSql.append("delete from t_perm_bizroledisperm ", new Object[0]);
                bizRoleDisPermSql.appendIn(" where fid ", bizRoleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)bizRoleDisPermSql);
                SqlBuilder bizRoleOrgSql = new SqlBuilder();
                bizRoleOrgSql.append("delete from t_perm_bizroleorg ", new Object[0]);
                bizRoleOrgSql.appendIn(" where fid ", bizRoleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)bizRoleOrgSql);
                SqlBuilder bizRoleComRoleSql = new SqlBuilder();
                bizRoleComRoleSql.append("delete from t_perm_bizrolecomrole ", new Object[0]);
                bizRoleComRoleSql.appendIn(" where fid ", bizRoleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)bizRoleComRoleSql);
                SqlBuilder userBizRoleSql = new SqlBuilder();
                userBizRoleSql.append("delete from t_perm_userbizrole ", new Object[0]);
                userBizRoleSql.appendIn(" where fbizroleid ", bizRoleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)userBizRoleSql);
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                log.warn("BusiRoleService.delBizRoleRelationData error\uff0c busiRoleIdSet\uff1a{}", (Object)e, (Object)JSON.toJSONString(busiRoleIdSet));
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

