/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.service.custom.validation.ValidatorUtil;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.CommonReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.PermCheckReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CommonService {
    private static final Log log = LogFactory.getLog(CommonService.class);

    private static PermissionService getPermissionService() {
        return (PermissionService)ServiceFactory.getService(PermissionService.class);
    }

    public <T> void commonValidate(T req, Class<?> ... groups) {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        StringBuilder msg = new StringBuilder();
        msg.append(methodName).append(".");
        Set constraintViolations = ValidatorUtil.validate(req, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            for (ConstraintViolation constraint : constraintViolations) {
                constraint.getPropertyPath().forEach(x -> msg.append(x).append("."));
                msg.append(constraint.getMessage()).append(";");
            }
            msg.deleteCharAt(msg.length() - 1).append("\u3002");
            throw new RuntimeException(msg.toString());
        }
    }

    public <T> void checkPerm(String entityNum, String permItemId, T req) {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        StringBuilder msg = new StringBuilder();
        msg.append(methodName).append('.');
        CommonReq commonReq = (CommonReq)req;
        PermissionService permissionService = CommonService.getPermissionService();
        boolean checkPermission = permissionService.checkPermission(RequestContext.get().getCurrUserId(), commonReq.getCheckPermAppId(), entityNum, permItemId);
        if (!checkPermission) {
            msg.append(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonService_0", (String)"bos-mservice-permission", (Object[])new Object[0]), FormMetadataCache.getFormConfig((String)entityNum).getCaption().toString(), PermItemHelper.getPermItemNameById((String)permItemId))).append(';');
            throw new RuntimeException(msg.toString());
        }
    }

    public PermCheckResp beforeSaveCheckExt(PermBeforeSaveCheckReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.beforeSaveCheck(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
                }
                return (PermCheckResp)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.beforeSaveCheckExt error.", (Throwable)e);
        }
        return new PermCheckResp(true, new HashMap(1), new HashMap(1), new HashMap(1));
    }

    public PermResult saveExt(PermOperationReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.save(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                return (PermResult)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.saveExt error.", (Throwable)e);
        }
        return PermResult.ok();
    }

    public PermResult afterMainEntitySaveExt(PermOperationReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.afterMainEntitySave(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                return (PermResult)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.afterMainEntitySaveExt error.", (Throwable)e);
        }
        return PermResult.ok();
    }

    public PermCheckResp beforeDelCheckExt(PermCheckReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.beforeDelCheck(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
                }
                return (PermCheckResp)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.beforeDelCheckExt error.", (Throwable)e);
        }
        return new PermCheckResp(true, new HashMap(1), new HashMap(1), new HashMap(1));
    }

    public PermResult delExt(PermOperationReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.del(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                return (PermResult)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.delExt error.", (Throwable)e);
        }
        return PermResult.ok();
    }

    public PermResult afterDelExt(PermOperationReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.afterDel(req);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                return (PermResult)pluginResults.get(0);
            }
        }
        catch (Exception e) {
            log.error("CommonService.afterDelExt error.", (Throwable)e);
        }
        return PermResult.ok();
    }

    public static PermResult genOperateOptionAndExec(PermOperationReq req) {
        OperationResult executeOperate;
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String operEntnum = req.getOperEntnum();
        String operationKey = req.getOperationKey();
        DynamicObject[] dynArr = req.getDataEntities();
        PermLogReq permLogReq = req.getPermLogReq();
        String defaultPermLogBusiType = req.getPermLogBusiType();
        String defaultPermlogOp = req.getPermLogOp();
        String defaultPermlogOpbtn = req.getPermLogOpbtn();
        String permlogInterfacemethod = req.getPermLogInterfaceMethod();
        Boolean entSavePermlog = req.getEntSavePermlog();
        String needClearAllCache = req.getNeedClearAllCache();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        String doDelExcessData = req.getDoDelExcessData();
        OperateOption option = req.getOption();
        if (null == option) {
            option = OperateOption.create();
            option.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
            option.setVariableValue("ENTSAVE_PERMLOG", null == entSavePermlog ? "1" : (entSavePermlog != false ? "1" : "0"));
            option.setVariableValue("canSavePermAdmGroupIdSet_useThreadCache", "0");
            option.setVariableValue("NEED_CLEARALLCACHE", needClearAllCache);
            option.setVariableValue("ALREADY_CHECKBUSIPARAM", alreadyCheckBusiParam);
            option.setVariableValue("DO_DELEXCESSDATA", doDelExcessData);
            option.setVariableValue("permlog_busitype", null == permLogReq || StringUtils.isEmpty((String)permLogReq.getBusiType()) ? defaultPermLogBusiType : permLogReq.getBusiType());
            option.setVariableValue("permlog_op", null == permLogReq || StringUtils.isEmpty((String)permLogReq.getOp()) ? defaultPermlogOp : permLogReq.getOp());
            option.setVariableValue("permlog_opbtn", null == permLogReq || StringUtils.isEmpty((String)permLogReq.getOpbtn()) ? defaultPermlogOpbtn : permLogReq.getOpbtn());
            option.setVariableValue("permlog_interfacemethod", null == permLogReq || StringUtils.isEmpty((String)permLogReq.getInterfaceMethod()) ? permlogInterfacemethod : permLogReq.getInterfaceMethod());
            option.setVariableValue("permlog_formnum", curFormNum);
            option.setVariableValue("currbizappid", curAppNum);
        }
        if (!(executeOperate = OperationServiceHelper.executeOperate((String)operationKey, (String)operEntnum, (DynamicObject[])dynArr, (OperateOption)option)).isSuccess()) {
            List allErrorOrValidateInfo = executeOperate.getAllErrorOrValidateInfo();
            if (null != allErrorOrValidateInfo && !allErrorOrValidateInfo.isEmpty()) {
                List collect = allErrorOrValidateInfo.stream().map(x -> x.getMessage()).collect(Collectors.toList());
                return PermResult.fail((String)String.join((CharSequence)"\r\n", collect));
            }
            String message = executeOperate.getMessage();
            if (StringUtils.isNotEmpty((String)message)) {
                return PermResult.fail((String)message);
            }
        }
        return PermResult.ok();
    }
}

