/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.DataPermissionResult;
import kd.bos.permission.api.DataRule;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.RoleCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class DataPermission {
    public static DataPermissionResult getDataPermission(long userId, long orgId, String appId, String entityNum) {
        Set roleIds;
        assert (entityNum != null);
        DataPermissionResult result = null;
        HashMap<String, DataRule> allRuleMap = new HashMap<String, DataRule>();
        List ruleList = DataPermissionCache.getDataRule((String)String.valueOf(userId), (String)"0", (Long)orgId, (String)appId, (String)entityNum);
        if (ruleList != null) {
            for (DataRule rule : ruleList) {
                allRuleMap.put(rule.getId(), rule);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(roleIds = RoleCache.getRoles((Long)userId, (Long)orgId)))) {
            for (String roleId : roleIds) {
                ruleList = DataPermissionCache.getDataRule((String)roleId, (String)"1", (Long)orgId, (String)appId, (String)entityNum);
                if (ruleList == null) continue;
                for (DataRule rule : ruleList) {
                    if (allRuleMap.containsKey(rule.getId())) continue;
                    allRuleMap.put(rule.getId(), rule);
                }
            }
        }
        if (allRuleMap.size() > 0) {
            result = new DataPermissionResult();
            result.setDataRules(new ArrayList(allRuleMap.values()));
        }
        return result;
    }

    public static void copyUserDataPerm(long sourceUserId, long targetUserId) {
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (!hasEnableOldDataRule) {
            DataRuleCache.copyUserDataRule((long)sourceUserId, (long)targetUserId);
            return;
        }
        String selUserDataPermFields = "org" + ", " + "dataperm" + ", " + "dimtype";
        DynamicObject[] arrSrcUserDataPermObj = BusinessDataServiceHelper.load((String)"perm_userdataperm", (String)selUserDataPermFields, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)sourceUserId)});
        DynamicObject[] arrTargetUserDataPermObj = BusinessDataServiceHelper.load((String)"perm_userdataperm", (String)selUserDataPermFields, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)targetUserId)});
        ArrayList<DynamicObject> listTargetUserDataPermObj = new ArrayList<DynamicObject>();
        if (arrTargetUserDataPermObj != null && arrTargetUserDataPermObj.length > 0) {
            for (DynamicObject targetObj : arrTargetUserDataPermObj) {
                listTargetUserDataPermObj.add(targetObj);
            }
        }
        HashMap<Object, Object[]> forAddInfoMap = new HashMap<Object, Object[]>();
        HashMap<Object, String> forUpdateInfoMap = new HashMap<Object, String>();
        if (arrSrcUserDataPermObj != null && arrSrcUserDataPermObj.length > 0) {
            for (DynamicObject srcObj : arrSrcUserDataPermObj) {
                Long srcOrgId = srcObj.getLong("org");
                String srcDataPermId = srcObj.getString("dataperm");
                String srcDimType = srcObj.getString("dimtype");
                boolean ifFound = false;
                String tarDataPermId = null;
                Iterator iterator = listTargetUserDataPermObj.iterator();
                while (iterator.hasNext()) {
                    DynamicObject targetObj = (DynamicObject)iterator.next();
                    Long tarOrgId = targetObj.getLong("org");
                    tarDataPermId = targetObj.getString("dataperm");
                    if (!srcOrgId.equals(tarOrgId)) continue;
                    ifFound = true;
                    iterator.remove();
                    break;
                }
                if (ifFound) {
                    forUpdateInfoMap.put(srcDataPermId, tarDataPermId);
                    continue;
                }
                forAddInfoMap.put(srcDataPermId, new Object[]{srcOrgId, null, srcDimType});
            }
        }
        ArrayList<DynamicObject> listNewUserDataPermObjs = new ArrayList<DynamicObject>();
        int userDataPermIdCount = 0;
        for (Object[] info : forAddInfoMap.values()) {
            if (info == null || info.length <= 0) continue;
            ++userDataPermIdCount;
        }
        ORM orm = ORM.create();
        String[] userDataPermIds = orm.genStringIds("perm_userdataperm", userDataPermIdCount);
        int userDataPermIdIndex = 0;
        for (Object[] info : forAddInfoMap.values()) {
            if (info == null || info.length <= 0) continue;
            Long addOrgId = (Long)info[0];
            DynamicObject[] dimType = info[2];
            DynamicObject newUserDataPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userdataperm");
            String userDataPermId = userDataPermIds[userDataPermIdIndex++];
            info[1] = userDataPermId;
            newUserDataPermObj.set("dataperm", (Object)userDataPermId);
            newUserDataPermObj.set("user", (Object)targetUserId);
            newUserDataPermObj.set("org", (Object)addOrgId);
            newUserDataPermObj.set("dimtype", (Object)dimType);
            listNewUserDataPermObjs.add(newUserDataPermObj);
        }
        String selDataPermFields = "entitytypelist.rule" + ", " + "entitytypelist.entitytype" + ", " + "entitytypelist.bizapp";
        DynamicObject[] arrSrcDataPermObj = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)selDataPermFields, (QFilter[])new QFilter[]{new QFilter("id", "in", forAddInfoMap.keySet())});
        ArrayList<DynamicObject[]> listNewDataPermObjs = new ArrayList<DynamicObject[]>();
        if (arrSrcDataPermObj != null && arrSrcDataPermObj.length > 0) {
            for (DynamicObject srcDataPermObj : arrSrcDataPermObj) {
                String srcDataPermObjId = srcDataPermObj.getString("id");
                DynamicObject[] newDataPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_dataperm");
                listNewDataPermObjs.add(newDataPermObj);
                Object[] info = (Object[])forAddInfoMap.get(srcDataPermObjId);
                if (info != null && info.length > 0) {
                    Object id = info[1];
                    newDataPermObj.set("id", id);
                    newDataPermObj.set("number", id);
                    newDataPermObj.set("permitem", (Object)"0");
                }
                DynamicObjectCollection dataRule = srcDataPermObj.getDynamicObjectCollection("entitytypelist");
                DynamicObjectCollection newDataRule = newDataPermObj.getDynamicObjectCollection("entitytypelist");
                for (int i = 0; i < dataRule.size(); ++i) {
                    DynamicObject rowRule = (DynamicObject)dataRule.get(i);
                    IDataEntityType dataPermRuleRowType = ((EntryProp)newDataPermObj.getDynamicObjectType().getProperty("entitytypelist")).getItemType();
                    DynamicObject newRow = new DynamicObject((DynamicObjectType)dataPermRuleRowType);
                    newRow.set("bizapp", rowRule.get("bizapp"));
                    newRow.set("entitytype", rowRule.get("entitytype"));
                    newRow.set("rule", rowRule.get("rule"));
                    newDataRule.add((Object)newRow);
                }
            }
        }
        ArrayList<DynamicObject> listUpdateDataPermObj = new ArrayList<DynamicObject>();
        String selDataPermFieldsForUpdate = "id" + ", " + "entitytypelist.rule" + ", " + "entitytypelist.bizapp" + ", " + "entitytypelist.entitytype";
        DynamicObject[] arrSrcDataPermObjForUpdate = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)selDataPermFieldsForUpdate, (QFilter[])new QFilter[]{new QFilter("id", "in", forUpdateInfoMap.keySet())});
        DynamicObject[] arrTargetDataPermObjForUpdate = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)selDataPermFieldsForUpdate, (QFilter[])new QFilter[]{new QFilter("id", "in", forUpdateInfoMap.values())});
        ArrayList<DynamicObject> listTargetDataPermObj = new ArrayList<DynamicObject>();
        if (arrTargetDataPermObjForUpdate != null && arrTargetDataPermObjForUpdate.length > 0) {
            for (DynamicObject targetObj : arrTargetDataPermObjForUpdate) {
                listTargetDataPermObj.add(targetObj);
            }
        }
        if (arrSrcDataPermObjForUpdate != null && arrSrcDataPermObjForUpdate.length > 0) {
            IDataEntityType dataPermRuleRowType = ((EntryProp)arrSrcDataPermObjForUpdate[0].getDynamicObjectType().getProperty("entitytypelist")).getItemType();
            block19: for (DynamicObject srcDataPermObjForUpdate : arrSrcDataPermObjForUpdate) {
                String srcDataPermObjId = srcDataPermObjForUpdate.getString("id");
                String tarDataPermObjId = (String)forUpdateInfoMap.get(srcDataPermObjId);
                Iterator iterator = listTargetDataPermObj.iterator();
                while (iterator.hasNext()) {
                    boolean needUpdateTarDataPerm = false;
                    DynamicObject tarDataPermObjForUpdate = (DynamicObject)iterator.next();
                    String tempTarDataPermObjId = tarDataPermObjForUpdate.getString("id");
                    if (!tarDataPermObjId.equals(tempTarDataPermObjId)) continue;
                    DynamicObjectCollection srcDataRule = srcDataPermObjForUpdate.getDynamicObjectCollection("entitytypelist");
                    DynamicObjectCollection tarDataRule = tarDataPermObjForUpdate.getDynamicObjectCollection("entitytypelist");
                    for (DynamicObject srcRowRule : srcDataRule) {
                        String srcAppId = srcRowRule.getString("bizapp.id");
                        String srcEntityName = srcRowRule.getString("entitytype.id");
                        String srcCondition = srcRowRule.getString("rule");
                        if (!StringUtils.isNotEmpty((String)srcCondition)) continue;
                        FilterCondition srcFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)srcCondition, FilterCondition.class);
                        List srcFilterRows = srcFilterCondition.getFilterRow();
                        boolean ifFound = false;
                        for (DynamicObject tarRowRule : tarDataRule) {
                            String tarAppId = tarRowRule.getString("bizapp.id");
                            String tarEntityName = tarRowRule.getString("entitytype.id");
                            String tarCondition = tarRowRule.getString("rule");
                            FilterCondition tarFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)tarCondition, FilterCondition.class);
                            List tarFilterRows = tarFilterCondition.getFilterRow();
                            if (!StringUtils.isNotEmpty((String)tarCondition) || !srcAppId.equals(tarAppId) || !srcEntityName.equals(tarEntityName)) continue;
                            ifFound = true;
                            if (tarFilterRows.containsAll(srcFilterRows)) continue;
                            tarFilterCondition.getFilterRow().addAll(srcFilterCondition.getFilterRow());
                            String newTarDataRule = SerializationUtils.toJsonString((Object)tarFilterCondition);
                            tarRowRule.set("rule", (Object)newTarDataRule);
                            needUpdateTarDataPerm = true;
                            break;
                        }
                        if (ifFound) continue;
                        DynamicObject newTarRow = new DynamicObject((DynamicObjectType)dataPermRuleRowType);
                        newTarRow.set("bizapp", (Object)srcAppId);
                        newTarRow.set("entitytype", (Object)srcEntityName);
                        newTarRow.set("rule", (Object)srcCondition);
                        tarDataRule.add((Object)newTarRow);
                        needUpdateTarDataPerm = true;
                    }
                    iterator.remove();
                    if (!needUpdateTarDataPerm) continue block19;
                    listUpdateDataPermObj.add(tarDataPermObjForUpdate);
                    continue block19;
                }
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (listNewDataPermObjs != null && listNewDataPermObjs.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)listNewDataPermObjs.get(0)).getDataEntityType(), (Object[])listNewDataPermObjs.toArray(new DynamicObject[0]));
                }
                if (listNewUserDataPermObjs != null && listNewUserDataPermObjs.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)listNewUserDataPermObjs.get(0)).getDataEntityType(), (Object[])listNewUserDataPermObjs.toArray(new DynamicObject[0]));
                }
                if (listUpdateDataPermObj != null && listUpdateDataPermObj.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)listUpdateDataPermObj.get(0)).getDataEntityType(), (Object[])listUpdateDataPermObj.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    public static QFilter getDataPermWithOrg(long pUserId, String pAppId, String pEntityNum, Map<String, Object> customParam) {
        return DataPermissionCache.getDataPermWithOrg((long)pUserId, (String)pAppId, (String)pEntityNum, customParam);
    }

    public static QFilter getDataPermWithOrg(long pUserId, String pAppId, String pEntityNum) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        return DataPermission.getDataPermWithOrg(pUserId, pAppId, pEntityNum, customParam);
    }

    public static QFilter getDataPerm(long pUserId, String pAppId, String pEntityNum) {
        return DataPermissionCache.getDataPermWithoutOrg((long)pUserId, (String)pAppId, (String)pEntityNum);
    }

    public static QFilter getDataPerm(long userId, String appId, String entityNum, List<Long> orgIds) {
        return DataPermissionCache.getDataPermWithoutOrg((long)userId, (String)appId, (String)entityNum, orgIds);
    }
}

