/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.log.LogDrEvent;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.LogDrInfo;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class DrService {
    private static final Log log = LogFactory.getLog(DrService.class);
    private static final String SYSTERM_TYPE = "bos-mservice-permission";

    public static PermResult justDrPermLog(LogDrInfo pre, LogDrInfo after, Set<String> userIdSet, PermLogReq permLogReq) {
        try {
            String afterDrNumber;
            String preDrNumber;
            pre.check("pre");
            after.check("pre");
            String lineSep = System.getProperty("line.separator");
            StringBuilder resultMsg = new StringBuilder();
            if (null != pre && null != after && !(preDrNumber = pre.getDrNumber()).equals(afterDrNumber = after.getDrNumber())) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u524d\u540e\uff0c\u6570\u636e\u89c4\u5219\u65b9\u6848\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0cpreDrNumber\uff1a%1$s\uff0c afterDrNumber\uff1a%2$s\u3002%3$s", (String)"DrService_0", (String)SYSTERM_TYPE, (Object[])new Object[0]), preDrNumber, afterDrNumber, lineSep));
                log.warn("DrService.justPermLog, {}", (Object)resultMsg);
                return PermResult.fail((StringBuilder)resultMsg);
            }
            if (permLogReq.getSignPermLog().booleanValue() && PermCommonUtil.isEnablePermLog()) {
                DrService.toPermLog(pre, after, userIdSet, permLogReq, resultMsg);
            }
            return PermResult.ok((StringBuilder)resultMsg);
        }
        catch (Exception e) {
            log.warn("DrService.justPermLog, exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    private static void toPermLog(LogDrInfo pre, LogDrInfo after, Set<String> userIdSet, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            permLogReq.check(false);
            String formNum = permLogReq.getFormIdentity();
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            LogDrEvent preLDR = new LogDrEvent();
            preLDR.setBaseInfo(pre);
            LogDrEvent afterLDR = new LogDrEvent();
            afterLDR.setBaseInfo(after);
            if (CollectionUtils.isEmpty(userIdSet)) {
                Set collect = userIdSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toSet());
                afterLDR.setAffectUserList(UserHelper.getUserListBySet(collect, (String)RequestContext.get().getLang().name()));
            }
            map.put("pre_data", new ObjectMapper().writeValueAsString((Object)preLDR));
            map.put("after_data", new ObjectMapper().writeValueAsString((Object)afterLDR));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("DrService.toPermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("DrService.toPermLog error.").append(lineSep).append(e.getMessage()).append(System.getProperty("line.separator"));
        }
    }
}

