/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class EventCenterService {
    private static final Log logger = LogFactory.getLog(EventCenterService.class);

    public static void deleteUsrGrpEventData(Long userGroupId) {
        DynamicObject syncRule = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)userGroupId)});
        if (syncRule == null) {
            return;
        }
        String entityNum = syncRule.getString("source_entity.number");
        String operation = syncRule.getString("oper");
        Map<String, Long[]> existOperation = EventCenterService.getSourceEntitySubscription(entityNum);
        Set<String> existOperationNum = existOperation.keySet();
        ArrayList<Long> updateCacheIds = new ArrayList<Long>(10);
        EventCenterService.deleteSubscription(entityNum, operation, existOperation, existOperationNum, new ArrayList<Long>(10));
        EventCenterService.eventCacheHandle(updateCacheIds);
    }

    public static void createListenEvent(String sourceNum, String newOperationKey, String oldOperationKey) {
        Long eventId;
        if (newOperationKey.equals(oldOperationKey)) {
            return;
        }
        ArrayList<Long> updateCacheIds = new ArrayList<Long>(10);
        Map<String, Long[]> existOperation = EventCenterService.getSourceEntitySubscription(sourceNum);
        Set<String> existOperationNum = existOperation.keySet();
        EventCenterService.deleteSubscription(sourceNum, oldOperationKey, existOperation, existOperationNum, updateCacheIds);
        String eventNum = sourceNum + "." + newOperationKey;
        if (existOperationNum.contains(eventNum)) {
            return;
        }
        DynamicObject[] events = BusinessDataServiceHelper.load((String)"evt_event", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("entity", "=", (Object)sourceNum)});
        HashMap<String, Long> existEventNum = new HashMap<String, Long>(16);
        for (DynamicObject event : events) {
            Long id = event.getLong("id");
            String number = event.getString("number");
            existEventNum.put(number, id);
        }
        DynamicObject sourceEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)sourceNum)});
        String entityName = sourceEntity.getString("name");
        String operationName = EventCenterService.getOperationName(sourceNum, newOperationKey);
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)sourceNum);
        String eventName = entityName + "." + operationName;
        if (existEventNum.containsKey(eventNum)) {
            eventId = (Long)existEventNum.get(eventNum);
        } else {
            Object[] eventInfo = EventCenterService.createEvent(sourceNum, appId, operationName, newOperationKey, eventNum, eventName);
            eventId = (Long)eventInfo[0];
        }
        Long subscriptionId = EventCenterService.createSubscription(eventId, eventNum, eventName);
        updateCacheIds.add(subscriptionId);
        EventCenterService.eventCacheHandle(updateCacheIds);
    }

    public static void deleteSubscription(String sourceNum, String oldOperationKey, Map<String, Long[]> existOperation, Set<String> existOperationNum, List<Long> updateCacheIds) {
        String sql;
        int count;
        String oldEventNum = sourceNum + "." + oldOperationKey;
        if (StringUtils.isNotEmpty((String)oldOperationKey) && existOperationNum.contains(oldEventNum) && (count = ((Integer)DB.query((DBRoute)DBRoute.permission, (String)(sql = " SELECT count(1) FROM t_perm_usrgrprel_ruleent WHERE fsrcentity = ? and foper = ? "), (Object[])new Object[]{sourceNum, oldOperationKey}, rs -> {
            int result = 0;
            if (rs.next()) {
                return rs.getInt(1);
            }
            return result;
        })).intValue()) == 0) {
            Long subscriptionId = existOperation.get(oldEventNum)[1];
            updateCacheIds.add(subscriptionId);
            DeleteServiceHelper.delete((String)"evt_subscription", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subscriptionId)});
        }
    }

    public static Map<String, Long[]> getSourceEntitySubscription(String sourceNum) {
        String sql = " SELECT a.fid event_id, a.fnumber, b.fid subscription_id FROM t_evt_event a INNER JOIN t_evt_subscription b ON a.fid = b.fevent WHERE a.fentity = ? AND b.fserviceconfig LIKE '%kd.bos.permission.formplugin.plugin.eventcenter.UgStdEvtListenPlugin%' ";
        return (Map)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{sourceNum}, (ResultSetHandler)new ResultSetHandler<Map<String, Long[]>>(){

            public Map<String, Long[]> handle(ResultSet rs) throws Exception {
                HashMap<String, Long[]> result = new HashMap<String, Long[]>(16);
                while (rs.next()) {
                    result.put(rs.getString(2), new Long[]{rs.getLong(1), rs.getLong(3)});
                }
                return result;
            }
        });
    }

    public static void eventCacheHandle(List<Long> ids) {
        DynamicObject[] savedSubscriptions = BusinessDataServiceHelper.load((String)"evt_subscription", (String)"eventnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, List> needCachedEvtNums = new HashMap<String, List>();
        ArrayList<String> eventNumList = new ArrayList<String>(16);
        for (DynamicObject o : savedSubscriptions) {
            String evtNumber = o.getString("eventnumber");
            String groupNumber = evtNumber.contains(".") ? evtNumber.split("\\.")[0] : "defaultGroup";
            List needRemovedEvent = needCachedEvtNums.computeIfAbsent(groupNumber, k -> new ArrayList());
            needRemovedEvent.add(evtNumber);
            EvtCacheHelper.removeCacheEvent((String)groupNumber);
            eventNumList.add(groupNumber);
        }
        EvtCacheHelper.removeCacheSubscriptionMap(eventNumList);
        EvtCacheHelper.removeCacheEventMap(eventNumList);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy(true, true));
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append(".evt.").append("cacheEvent");
        Set entrySet = needCachedEvtNums.entrySet();
        for (Map.Entry entry : entrySet) {
            String deleteKey = String.format("%s.%s", sb, entry.getKey());
            cache.addToSet(deleteKey, ((List)entry.getValue()).toArray(new String[0]), Integer.MAX_VALUE);
        }
    }

    private static Long createSubscription(Long eventId, String eventNum, String eventName) {
        DynamicObject opEventSubscrpObj = BusinessDataServiceHelper.newDynamicObject((String)"evt_subscription");
        opEventSubscrpObj.set("event", (Object)eventId);
        opEventSubscrpObj.set("service", (Object)904236026388547584L);
        opEventSubscrpObj.set("number", (Object)(eventNum + ".executePlugin"));
        opEventSubscrpObj.set("eventnumber", (Object)eventNum);
        opEventSubscrpObj.set("isconcurrent", (Object)"1");
        opEventSubscrpObj.set("status", (Object)"1");
        opEventSubscrpObj.set("errorstrategy", (Object)"retry");
        opEventSubscrpObj.set("servicenumber", (Object)"executePlugin");
        opEventSubscrpObj.set("name", (Object)(eventName + ResManager.loadKDString((String)".\u81ea\u52a8\u540c\u6b65", (String)"EventCenterService_0", (String)"bos-mservice-permission", (Object[])new Object[0])));
        opEventSubscrpObj.set("ispreinsdata", (Object)"0");
        opEventSubscrpObj.set("ismodified", (Object)"1");
        opEventSubscrpObj.set("serviceconfig", (Object)"{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"base\\\",\\\"class\\\":\\\"kd.bos.permission.formplugin.plugin.eventcenter.UgStdEvtListenPlugin\\\"}\"}");
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])ArrayUtils.toArray((Object[])new DynamicObject[]{opEventSubscrpObj})));
        return (Long)opEventSubscrpObj.getPkValue();
    }

    private static Object[] createEvent(String entityNum, String appId, String operationName, String operationKey, String eventNum, String eventName) {
        DynamicObject opEventObj = BusinessDataServiceHelper.newDynamicObject((String)"evt_event");
        opEventObj.set("type", (Object)"cosmic");
        opEventObj.set("entity", (Object)entityNum);
        opEventObj.set("source", (Object)appId);
        opEventObj.set("operation", (Object)operationName);
        opEventObj.set("opernumber", (Object)operationKey);
        opEventObj.set("scene", (Object)"operate");
        opEventObj.set("numberview", (Object)eventNum);
        opEventObj.set("number", (Object)eventNum);
        opEventObj.set("name", (Object)eventName);
        opEventObj.set("description", (Object)eventName);
        opEventObj.set("status", (Object)"1");
        opEventObj.set("ismodified", (Object)"1");
        opEventObj.set("ispreinsdata", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])ArrayUtils.toArray((Object[])new DynamicObject[]{opEventObj})));
        return new Object[]{opEventObj.getPkValue(), opEventObj.getString("number")};
    }

    public static String getOperationName(String entityNum, String operationKey) {
        String operationName = null;
        List operationList = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        if (StringUtils.isNotEmpty((String)operationKey)) {
            for (Map operationInfo : operationList) {
                String key = (String)operationInfo.get("key");
                if (!key.equals(operationKey)) continue;
                Map operationNameMap = (Map)operationInfo.get("name");
                LocaleString operationLocaleName = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)operationNameMap), LocaleString.class);
                operationName = operationLocaleName.toString();
                break;
            }
        }
        return operationName;
    }
}

