/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.cache.FieldPermissionCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class FieldPermission {
    public static FieldControlRule getFieldControlRule(long userId, long orgId, String appId, String entityNum) {
        return FieldPermissionCache.getFieldControlRule((long)userId, (long)orgId, (String)appId, (String)entityNum);
    }

    public static void copyUserFieldPerm(long sourceUserId, long targetUserId) {
        String algoKey = "FieldPermission";
        QFilter[] qFilters1 = new QFilter[]{new QFilter("user.id", "=", (Object)sourceUserId)};
        QFilter[] qFilters2 = new QFilter[]{new QFilter("user.id", "=", (Object)targetUserId)};
        ORM orm = ORM.create();
        try (DataSet sourceDS = orm.queryDataSet(algoKey, "perm_userfieldperm", "user.id,fieldperm.id,org.id,dimtype,includesuborg", qFilters1);
             DataSet targetDS = orm.queryDataSet(algoKey, "perm_userfieldperm", "user.id,fieldperm.id,org.id,dimtype,includesuborg", qFilters2);
             DataSet preCopyDS = sourceDS.join(targetDS, JoinType.LEFT).on("fieldperm.id", "fieldperm.id").on("org.id", "org.id").on("dimtype", "dimtype").on("includesuborg", "includesuborg").select(new String[]{"fieldperm.id", "org.id", "dimtype", "includesuborg"}, new String[]{"user.id as targetuser"}).finish();){
            ArrayList<DynamicObject> copyList = new ArrayList<DynamicObject>(8);
            for (Row row : preCopyDS) {
                if (!StringUtils.isEmpty((String)row.getString("targetuser"))) continue;
                DynamicObject userFieldPerm = BusinessDataServiceHelper.newDynamicObject((String)"perm_userfieldperm");
                userFieldPerm.set("user", (Object)targetUserId);
                userFieldPerm.set("fieldperm", row.get("fieldperm.id"));
                userFieldPerm.set("org", row.get("org.id"));
                userFieldPerm.set("dimtype", row.get("dimtype"));
                userFieldPerm.set("includesuborg", row.get("includesuborg"));
                copyList.add(userFieldPerm);
            }
            SaveServiceHelper.save((DynamicObject[])copyList.toArray(new DynamicObject[0]));
        }
    }

    public static FieldControlRule getFieldRulesSum(long pUserId, String pAppId, String pEntityNum) {
        return FieldPermissionCache.getFieldRulesSum((long)pUserId, (String)pAppId, (String)pEntityNum);
    }

    public static FieldControlRules getFieldControlRules(long pUserId, String pAppId, String pEntityNum) {
        return FieldPermissionCache.getFieldControlRules((long)pUserId, (String)pAppId, (String)pEntityNum);
    }

    @Deprecated
    public static Map<Long, FieldControlRule> getAllFieldControlRule(long pUserId, String pAppId, String pEntityNum) {
        return FieldPermissionCache.getAllFieldControlRule((long)pUserId, (String)pAppId, (String)pEntityNum);
    }
}

