/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.CommRoleFunPermService;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.UserDirectFunPermService;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.model.FuncPermItem;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.perm.req.user.GetUsableEntitiesInfoReq;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class FunctionPermission {
    private static Log log = LogFactory.getLog(FunctionPermission.class);
    public static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_FunctionPermission", (int)1);
    private static final String INCLUDESUBORGIDSETKEY = "includeSubOrgIdSetKey";
    private static final String EXCLUDESUBORGIDSETKEY = "excludeSubOrgIdSetKey";
    private static final String DEFAULT_LANG = "zh_CN";

    public static List<Long> getAllPermissionOrgs(long userId, String appId, String entityNum, String permItemId) {
        if (SuperUserCache.isSuperUser((long)userId) || PermissionServiceHelper.isAdminUser((long)userId, (String)"10")) {
            return PermCommonUtil.getAllOrgIds();
        }
        HasPermOrgResult allPermOrgs = FunctionPermission.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return PermCommonUtil.getAllOrgIds();
        }
        return allPermOrgs.getHasPermOrgs();
    }

    public static Set<Long> getSubOrgIdSet(long orgId) {
        List<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)15L, orgIds, (boolean)false, (boolean)true);
        HashSet<Long> subOrgIdSet = new HashSet<Long>();
        subOrgIdSet.addAll(orgIds);
        return subOrgIdSet;
    }

    public static Map<String, Set> getUserOrgIdSetMap(long userId) {
        boolean includeSubOrg;
        Object orgObj;
        HashMap<String, Set> result = new HashMap<String, Set>();
        HashSet<Long> includeSubOrgIdSet = new HashSet<Long>();
        HashSet<Long> excludeSubOrgIdSet = new HashSet<Long>();
        result.put(INCLUDESUBORGIDSETKEY, includeSubOrgIdSet);
        result.put(EXCLUDESUBORGIDSETKEY, excludeSubOrgIdSet);
        Map orgMapInfoFromUserPerm = BusinessDataServiceHelper.loadFromCache((String)"perm_userperm", (String)"org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)"DIM_ORG")});
        Map orgMapInfoFromUserRole = BusinessDataServiceHelper.loadFromCache((String)"perm_userrole", (String)"org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        if (orgMapInfoFromUserPerm != null && orgMapInfoFromUserPerm.size() > 0) {
            for (DynamicObject queryResult : orgMapInfoFromUserPerm.values()) {
                orgObj = queryResult.getDynamicObject("org");
                if (orgObj == null) continue;
                includeSubOrg = queryResult.getBoolean("includesuborg");
                if (includeSubOrg) {
                    includeSubOrgIdSet.add(orgObj.getLong("id"));
                    continue;
                }
                excludeSubOrgIdSet.add(orgObj.getLong("id"));
            }
        }
        if (orgMapInfoFromUserRole != null && orgMapInfoFromUserRole.size() > 0) {
            for (DynamicObject queryResult : orgMapInfoFromUserRole.values()) {
                orgObj = queryResult.getDynamicObject("org");
                if (orgObj == null) continue;
                includeSubOrg = queryResult.getBoolean("includesuborg");
                if (includeSubOrg) {
                    includeSubOrgIdSet.add(orgObj.getLong("id"));
                    continue;
                }
                excludeSubOrgIdSet.add(orgObj.getLong("id"));
            }
        }
        Map includeSubMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", includeSubOrgIdSet), new QFilter("enable", "=", (Object)"1")});
        includeSubOrgIdSet.clear();
        if (includeSubMap != null && includeSubMap.size() > 0) {
            Set includeSubSet = includeSubMap.keySet();
            for (Object obj : includeSubSet) {
                includeSubOrgIdSet.add((Long)obj);
            }
        }
        Map excludeSubMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", excludeSubOrgIdSet), new QFilter("enable", "=", (Object)"1")});
        excludeSubOrgIdSet.clear();
        if (excludeSubMap != null && excludeSubMap.size() > 0) {
            Set excludeSubSet = excludeSubMap.keySet();
            for (Object obj : excludeSubSet) {
                excludeSubOrgIdSet.add((Long)obj);
            }
        }
        excludeSubOrgIdSet.removeAll(includeSubOrgIdSet);
        return result;
    }

    public static Map<String, Set<Long>> getUserDimObjIdSetMap(long userId, String dimType) {
        boolean includeSubDimObj;
        Object dimObjId;
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        HashSet<Long> includeSubDimObjIdSet = new HashSet<Long>();
        HashSet<Long> excludeSubDimObjIdSet = new HashSet<Long>();
        result.put(INCLUDESUBORGIDSETKEY, includeSubDimObjIdSet);
        result.put(EXCLUDESUBORGIDSETKEY, excludeSubDimObjIdSet);
        Map dimObjMapInfoFromUserPerm = BusinessDataServiceHelper.loadFromCache((String)"perm_userperm", (String)"org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)dimType)});
        Map orgMapInfoFromUserRole = BusinessDataServiceHelper.loadFromCache((String)"perm_userrole", (String)"org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)dimType)});
        if (dimObjMapInfoFromUserPerm != null && dimObjMapInfoFromUserPerm.size() > 0) {
            for (DynamicObject queryResult : dimObjMapInfoFromUserPerm.values()) {
                dimObjId = queryResult.getLong("org_id");
                if (dimObjId == null) continue;
                includeSubDimObj = queryResult.getBoolean("includesuborg");
                if (includeSubDimObj) {
                    includeSubDimObjIdSet.add((Long)dimObjId);
                    continue;
                }
                excludeSubDimObjIdSet.add((Long)dimObjId);
            }
        }
        if (orgMapInfoFromUserRole != null && orgMapInfoFromUserRole.size() > 0) {
            for (DynamicObject queryResult : orgMapInfoFromUserRole.values()) {
                dimObjId = queryResult.getLong("org_id");
                if (dimObjId == null) continue;
                includeSubDimObj = queryResult.getBoolean("includesuborg");
                if (includeSubDimObj) {
                    includeSubDimObjIdSet.add((Long)dimObjId);
                    continue;
                }
                excludeSubDimObjIdSet.add((Long)dimObjId);
            }
        }
        if (dimType.equals("DIM_ORG") || dimType.equals("bos_org")) {
            Map includeSubMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", includeSubDimObjIdSet), new QFilter("enable", "=", (Object)"1")});
            includeSubDimObjIdSet.clear();
            if (includeSubMap != null && includeSubMap.size() > 0) {
                Set includeSubSet = includeSubMap.keySet();
                for (Object obj : includeSubSet) {
                    includeSubDimObjIdSet.add((Long)obj);
                }
            }
            Map excludeSubMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", excludeSubDimObjIdSet), new QFilter("enable", "=", (Object)"1")});
            excludeSubDimObjIdSet.clear();
            if (excludeSubMap != null && excludeSubMap.size() > 0) {
                Set excludeSubSet = excludeSubMap.keySet();
                for (Object obj : excludeSubSet) {
                    excludeSubDimObjIdSet.add((Long)obj);
                }
            }
        }
        excludeSubDimObjIdSet.removeAll(includeSubDimObjIdSet);
        return result;
    }

    public static int checkBySingleBizRole(long userId, long dimObjId, String appId, String entityNum, String permItemId) {
        Object[] filters;
        StringBuilder sql;
        String bizRoleId = UserBizRoleCache.getSelBizRole((Long)userId);
        if (bizRoleId.equals("")) {
            return 0;
        }
        String dimObjFieldKey = PermCommonUtil.getCheckPermDimObjFieldKey((String)entityNum);
        if (dimObjFieldKey != null && dimObjId != 0L) {
            sql = new StringBuilder();
            sql.append("select a.forgid,a.fisincludesuborg from t_perm_bizroleorg a ").append("where a.fid= ? ");
            filters = new Object[]{Long.parseLong(bizRoleId)};
            Map orgMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, rs -> {
                HashMap<Long, String> ids = new HashMap<Long, String>(16);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    String isIncludeSubOrg = rs.getString(2);
                    ids.put(id, isIncludeSubOrg);
                }
                return ids;
            });
            ArrayList orgList = new ArrayList(10);
            ArrayList orgIncludeSub = new ArrayList(10);
            for (Map.Entry org : orgMap.entrySet()) {
                if (((String)org.getValue()).equals("1")) {
                    orgIncludeSub.add(org.getKey());
                }
                orgList.add(org.getKey());
            }
            boolean isExist = false;
            if (orgList.contains(dimObjId)) {
                isExist = true;
            } else {
                String orgViewType = new PermissionServiceImpl().queryViewSchemeCfg(appId, entityNum).toString();
                List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)orgViewType, (long)dimObjId);
                for (Long orgIncludeSubId : orgIncludeSub) {
                    if (!superiorOrgs.contains(orgIncludeSubId)) continue;
                    isExist = true;
                    break;
                }
            }
            if (!isExist) {
                return 0;
            }
        }
        sql = new StringBuilder();
        sql.append("select a.fid from t_perm_bizroledisperm a ").append("where a.fid = ? ").append("and a.fbizappid = ? ").append("and a.fentitytypeid = ? ").append("and a.fpermitemid = ? ");
        filters = new Object[]{StringUtils.isEmpty((String)bizRoleId) ? 0L : Long.parseLong(bizRoleId), appId, entityNum, permItemId};
        boolean isDisPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
        if (isDisPerm) {
            return 0;
        }
        sql.setLength(0);
        sql.append("select a.fid from t_perm_bizroleperm a ").append("where a.fid =? ").append("and a.fbizappid = ? ").append("and a.fentitytypeid = ? ").append("and a.fpermitemid = ? ");
        boolean isPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
        if (isPerm) {
            return 1;
        }
        sql.setLength(0);
        sql.append("select a.froleid from t_perm_bizrolecomrole a ").append("join t_perm_role b on a.froleid=b.fid ").append("join t_perm_rolepermdetial d on b.fid=d.froleid ").append("where a.fid =? ").append("and b.fenable = '1' ").append("and d.fbizappid = ? ").append("and d.fentitytypeid = ? ").append("and d.fpermitemid = ? ");
        isPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
        if (isPerm) {
            return 1;
        }
        return 0;
    }

    public static int check(long userId, String orgViewType, String dimType, long dimObjId, String appId, String entityNum, String permItemId) {
        if (SuperUserCache.isSuperUser((long)userId)) {
            return 1;
        }
        boolean enableSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        if (enableSingleBizRole) {
            return FunctionPermission.checkBySingleBizRole(userId, dimObjId, appId, entityNum, permItemId);
        }
        if (StringUtils.isEmpty((String)dimType)) {
            dimType = PermCommonUtil.getDimTypeByEntityNum((String)entityNum);
        }
        if (StringUtils.isEmpty((String)orgViewType)) {
            orgViewType = PermCommonUtil.getPermOrgFuncId((String)entityNum);
        }
        if (dimObjId == 0L && !"DIM_NULL".equals(dimType)) {
            return FunctionPermission.hasPermDimObjAppointPerm(userId, orgViewType, dimType, appId, entityNum, permItemId);
        }
        if ("DIM_NULL".equals(dimType)) {
            if (UserDirectFunPermService.cacheCheckDisPermWithOutOrg((long)userId, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckDisPermWithOutOrg((long)userId, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 0;
            }
            if (UserDirectFunPermService.cacheCheckPermissionWithOutOrg((long)userId, (String)appId, (String)entityNum, (String)permItemId) == 1 || CommRoleFunPermService.cacheCheckPermissionWithOutOrg((long)userId, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckPermissionWithOutOrg((long)userId, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 1;
            }
        } else if ("DIM_ORG".equals(dimType) || "bos_org".equals(dimType)) {
            if (UserDirectFunPermService.cacheCheckDisPermWithOrg((long)userId, (long)dimObjId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckDisPermWithOrg((long)userId, (long)dimObjId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 0;
            }
            if (UserDirectFunPermService.cacheCheckPermissionWithOrg((long)userId, (long)dimObjId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId) == 1 || CommRoleFunPermService.cacheCheckPermissionWithOrg((long)userId, (long)dimObjId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckPermissionWithOrg((long)userId, (long)dimObjId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 1;
            }
        } else {
            if (UserDirectFunPermService.cacheCheckDisPermWithDim((long)userId, (long)dimObjId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckDisPermWithDim((long)userId, (long)dimObjId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 0;
            }
            if (UserDirectFunPermService.cacheCheckPermissionWithDim((long)userId, (long)dimObjId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId) == 1 || CommRoleFunPermService.cacheCheckPermissionWithDim((long)userId, (long)dimObjId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId) == 1 || BizRoleFunPermService.cacheCheckPermissionWithDim((long)userId, (long)dimObjId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId) == 1) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static int hasPermDimObjAppointPerm(long userId, String orgViewType, String dimType, String appId, String entityNum, String permItemId) {
        void var15_23;
        void var15_21;
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
        String userDirectType = suitableDimType[0];
        String otherType = suitableDimType[1];
        HashMap<Long, Object> hasPermOrgs = new HashMap<Long, Object>(16);
        Map directHasPermOrgs = DirectAuthorizeHelper.cacheGetHasPermDimObj((Long)userId, (String)userDirectType, (String)appId, (String)entityNum, (String)permItemId);
        hasPermOrgs.putAll(directHasPermOrgs);
        Map commonRoleHasPermOrgs = CommRoleFunPermService.cacheGetHasPermDimObj((long)userId, (String)otherType, (String)appId, (String)entityNum, (String)permItemId);
        for (Map.Entry entry : commonRoleHasPermOrgs.entrySet()) {
            Long l = (Long)entry.getKey();
            String newValue = (String)entry.getValue();
            String oldValue = (String)hasPermOrgs.get(l);
            if (!StringUtils.isEmpty((String)oldValue)) {
                if (!"0".equals(oldValue) || !"1".equals(newValue)) continue;
                hasPermOrgs.put(l, newValue);
                continue;
            }
            hasPermOrgs.put(l, newValue);
        }
        Map bizRoleHasPermOrgs = BizRoleFunPermService.cacheGetHasPermDimObj((long)userId, (String)otherType, (String)appId, (String)entityNum, (String)permItemId);
        for (Map.Entry entry : bizRoleHasPermOrgs.entrySet()) {
            Long key = (Long)entry.getKey();
            String newValue = (String)entry.getValue();
            String string = (String)hasPermOrgs.get(key);
            if (!StringUtils.isEmpty((String)string)) {
                if (!"0".equals(string) || !"1".equals(newValue)) continue;
                hasPermOrgs.put(key, newValue);
                continue;
            }
            hasPermOrgs.put(key, newValue);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        ArrayList arrayList2 = new ArrayList(10);
        HashSet<Long> hasPermOrgsResult = new HashSet<Long>(16);
        for (Map.Entry entry : hasPermOrgs.entrySet()) {
            Long key = (Long)entry.getKey();
            String value = (String)entry.getValue();
            if ("1".equals(value)) {
                arrayList.add(key);
                continue;
            }
            hasPermOrgsResult.add(key);
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            List list = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewType, arrayList, (boolean)true, (boolean)true);
        }
        hasPermOrgsResult.addAll((Collection<Long>)var15_21);
        HashMap<Long, String> disPermOrgs = new HashMap<Long, String>(16);
        Map map = UserDirectFunPermService.cacheGetDisPermDimObj((long)userId, (String)otherType, (String)appId, (String)entityNum, (String)permItemId);
        disPermOrgs.putAll(map);
        Map bizRoledisPermOrgs = BizRoleFunPermService.cacheGetDisPermDimObj((long)userId, (String)otherType, (String)appId, (String)entityNum, (String)permItemId);
        for (Map.Entry entry : bizRoledisPermOrgs.entrySet()) {
            Long key = (Long)entry.getKey();
            String newValue = (String)entry.getValue();
            String oldValue = (String)disPermOrgs.get(key);
            if (!StringUtils.isEmpty((String)oldValue)) {
                if (!"0".equals(oldValue) || !"1".equals(newValue)) continue;
                disPermOrgs.put(key, newValue);
                continue;
            }
            disPermOrgs.put(key, newValue);
        }
        arrayList.clear();
        var15_21.clear();
        HashSet<Long> disPermOrgsResult = new HashSet<Long>(16);
        for (Map.Entry disPermEntry : disPermOrgs.entrySet()) {
            Long key = (Long)disPermEntry.getKey();
            String value = (String)disPermEntry.getValue();
            if ("1".equals(value)) {
                arrayList.add(key);
                continue;
            }
            disPermOrgsResult.add(key);
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            List list = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewType, arrayList, (boolean)true, (boolean)true);
        }
        disPermOrgsResult.addAll((Collection<Long>)var15_23);
        if (hasPermOrgsResult.size() > disPermOrgsResult.size()) {
            return 1;
        }
        if (hasPermOrgsResult.containsAll(disPermOrgsResult) || disPermOrgsResult.containsAll(hasPermOrgsResult)) {
            return 0;
        }
        return 1;
    }

    public static int check(long userId, String dimType, long dimObjId, String appId, String entityNum, String permItemId) {
        return FunctionPermission.check(userId, null, dimType, dimObjId, appId, entityNum, permItemId);
    }

    private static Map<String, String> getAllAppInfo(String localeId, String appIdQuerySetStr) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t1.fid appid, t1.fappid appnum, t2.FNAME appname ");
        sql.append("FROM t_meta_appruntime t1 ");
        sql.append("INNER JOIN t_meta_appruntime_l t2 ON (t1.fappid = t2.fappid and flocaleid = '").append(localeId).append("') ");
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            sql.append(" where t1.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        try (DataSet ds = DB.queryDataSet((String)"FunctionPermission_getAllAppInfo", (DBRoute)DBRoute.meta, (String)sql.toString(), null);){
            Iterator rowIterator = ds.iterator();
            while (rowIterator != null && rowIterator.hasNext()) {
                Row data = (Row)rowIterator.next();
                String appid = data.getString("appid");
                String appname = data.getString("appname");
                result.put(appid, appname);
            }
        }
        return result;
    }

    private static Map<String, String> getAllEntityInfo(String localeId, String modelTypeSetStr, String appIdQuerySetStr) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t1.fid entitynum, t1.fdentityid entityid, t2.fname entityname");
        sql.append(" FROM t_meta_mainentityinfo t1 ");
        sql.append(" inner join t_meta_mainentityinfo_l t2 on (t1.fid = t2.fid and t2.flocaleid ='");
        sql.append(localeId).append("') ");
        sql.append(" WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            sql.append(" AND fmodeltype IN ('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            sql.append(" AND t1.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        try (DataSet ds = DB.queryDataSet((String)"FunctionPermission_getAllEntityInfo", (DBRoute)DBRoute.meta, (String)sql.toString(), null);){
            Iterator rowIterator = ds.iterator();
            while (rowIterator != null && rowIterator.hasNext()) {
                Row data = (Row)rowIterator.next();
                String entityNum = data.getString("entitynum");
                String entityName = data.getString("entityname");
                result.put(entityNum, entityName);
            }
        }
        return result;
    }

    private static String generateJsonStr(Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> map) {
        ArrayList<JSONObject> allList = new ArrayList<JSONObject>(100);
        for (Map.Entry<String, Map<String, Set<String>>> cloudEntry : map.entrySet()) {
            JSONObject cloudObj = new JSONObject();
            String cloudId = cloudEntry.getKey();
            String cloudName = cloudMap.get(cloudId);
            if (StringUtils.isEmpty((String)cloudId)) continue;
            cloudObj.put("id", (Object)cloudId);
            cloudObj.put("name", (Object)cloudName);
            ArrayList<JSONObject> appList = new ArrayList<JSONObject>(100);
            Map<String, Set<String>> appInfo = cloudEntry.getValue();
            for (Map.Entry<String, Set<String>> appEntry : appInfo.entrySet()) {
                JSONObject appObj = new JSONObject();
                String appId = appEntry.getKey();
                String appName = appMap.get(appId);
                if (StringUtils.isEmpty((String)appId)) continue;
                appObj.put("id", (Object)appId);
                String appNameFromMap = appMap.get(appId);
                if (StringUtils.isEmpty((String)appNameFromMap)) {
                    String appRuntimeName = FunctionPermission.getAppName(appId);
                    if (StringUtils.isNotEmpty((String)appRuntimeName)) {
                        appName = appRuntimeName;
                    }
                    appMap.put(appId, appName);
                }
                if (StringUtils.isEmpty((String)appName)) {
                    appName = "appName_NotFound";
                }
                appObj.put("name", (Object)appName);
                ArrayList<JSONObject> entityList = new ArrayList<JSONObject>(200);
                Set<String> entityInfo = appEntry.getValue();
                for (String entityNum : entityInfo) {
                    JSONObject entityObj = new JSONObject();
                    if (StringUtils.isEmpty((String)entityNum)) continue;
                    entityObj.put("id", (Object)entityNum);
                    entityObj.put("name", (Object)entityMap.get(entityNum));
                    String entityId = entityNumIdMap.get(entityNum);
                    entityObj.put("fid", (Object)entityId);
                    entityList.add(entityObj);
                }
                appObj.put("children", entityList);
                appList.add(appObj);
            }
            cloudObj.put("children", appList);
            allList.add(cloudObj);
        }
        return JSON.toJSONString(allList);
    }

    @Deprecated
    public static String getSuperUserUsableEntitiesInfo(Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap) {
        return FunctionPermission.getSuperUserUsableEntitiesInfo(null, null, cloudMap, appMap, entityMap);
    }

    @Deprecated
    public static String getSuperUserUsableEntitiesInfo(Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> entityNumIdMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap) {
        HashSet modelTypeSet = Sets.newHashSet((Object[])new String[]{"BillFormModel", "BaseFormModel", "BalanceModel"});
        String modelTypeSetStr = null == modelTypeSet || modelTypeSet.isEmpty() ? "" : String.join((CharSequence)"','", modelTypeSet);
        return FunctionPermission.getSuperUserUsableEntitiesInfo(allRelMap, entityNumIdMap, cloudMap, appMap, entityMap, modelTypeSetStr, "", "", null);
    }

    /*
     * Exception decompiling
     */
    public static String getSuperUserUsableEntitiesInfo(Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> entityNumIdMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr, Set<String> appIdQuerySet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 16 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getAppName(String appId) {
        AppInfo appInfo = null;
        try {
            appInfo = AppHelper.getMetaAppInfo((String)appId);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return "";
        }
        LocaleString name = null;
        if (appInfo == null) {
            log.warn("appId:[" + appId + "] info is null");
        } else {
            name = appInfo.getName();
        }
        String appRuntimeName = null;
        appRuntimeName = name == null ? appId + "_NameNotFound" : name.getLocaleValue();
        return appRuntimeName;
    }

    public static String getUsableEntitiesInfo(Long userId) {
        return FunctionPermission.getUsableEntitiesInfo(new GetUsableEntitiesInfoReq(userId, (Set)Sets.newHashSet((Object[])new String[]{"BillFormModel", "BaseFormModel", "BalanceModel"}), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsableEntitiesInfo(GetUsableEntitiesInfoReq req) {
        DLock lock = null;
        String reqStr = JSON.toJSONString((Object)req);
        try {
            Long userId = req.getUserId();
            Set modelTypeSet = req.getModelTypeSet();
            modelTypeSet = null == modelTypeSet ? new HashSet(1) : modelTypeSet;
            List modelTypeList = modelTypeSet.stream().sorted().collect(Collectors.toList());
            Set cloudIdSet = req.getCloudIdSet();
            cloudIdSet = null == cloudIdSet ? new HashSet(1) : cloudIdSet;
            List cloudIdList = cloudIdSet.stream().sorted().collect(Collectors.toList());
            StringBuilder key = new StringBuilder();
            key.append(userId);
            for (String modelType : modelTypeList) {
                key.append(modelType);
            }
            for (String cloudId : cloudIdList) {
                key.append(cloudId);
            }
            key.append(RequestContext.get().getLang().name());
            String keyStr = key.toString();
            lock = DLock.create((String)("FunctionPermission/getUsableEntitiesInfo/u/" + keyStr));
            lock.lock();
            String cacheType = CacheMrg.getType4UsableEntities();
            String cacheKey = keyStr;
            String cachedStr = CacheMrg.getCache((String)cacheType, (String)cacheKey);
            if (StringUtils.isEmpty((String)cachedStr)) {
                String str = FunctionPermission.getUsableEntitiesInfoPrivate(req);
                CacheMrg.putCache((String)cacheType, (String)cacheKey, (String)StrUtil.compress((String)str));
                String string = str;
                return string;
            }
            String string = StrUtil.uncompress((String)cachedStr);
            return string;
        }
        catch (Exception e) {
            log.warn("FunctionPermission.getUsableEntitiesInfo error\uff0c reqStr\uff1a{}", (Object)reqStr, (Object)e);
            String string = JSON.toJSONString(new ArrayList(1));
            return string;
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
    }

    private static String getUsableEntitiesInfoPrivate(GetUsableEntitiesInfoReq req) {
        String adminKey = !PermCommonUtil.hasEnableOldAdmin() ? CacheMrg.getType4AdminGroupUser() : CacheMrg.getType4AdminUserOld();
        String localeId = RequestContext.get().getLang().name();
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = DEFAULT_LANG;
        }
        Long userId = req.getUserId();
        Set modelTypeSet = req.getModelTypeSet();
        String modelTypeSetStr = null == modelTypeSet || modelTypeSet.isEmpty() ? "" : String.join((CharSequence)"','", modelTypeSet);
        HashSet<String> appIdQuerySet = new HashSet<String>(8);
        HashSet<String> oriAppIdQuerySet = new HashSet<String>(8);
        Set cloudIdSet = req.getCloudIdSet();
        if (null != cloudIdSet && !cloudIdSet.isEmpty()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getUsableEntitiesInfoPrivate.getByCloud", (String)"bos_devportal_bizapp", (String)"id, masterid", (QFilter[])new QFilter[]{new QFilter("bizcloud", "in", (Object)cloudIdSet)}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String id = row.getString("id");
                    String masterid = row.getString("masterid");
                    appIdQuerySet.add(id);
                    if (StringUtils.isEmpty((String)masterid) || StringUtils.isEmpty((String)masterid.trim())) {
                        oriAppIdQuerySet.add(id);
                        continue;
                    }
                    oriAppIdQuerySet.add(masterid);
                }
            }
        }
        String appIdQuerySetStr = null == appIdQuerySet || appIdQuerySet.isEmpty() ? "" : String.join((CharSequence)"','", appIdQuerySet);
        String oriAppIdQuerySetStr = null == oriAppIdQuerySet || oriAppIdQuerySet.isEmpty() ? "" : String.join((CharSequence)"','", oriAppIdQuerySet);
        HashMap<String, String> entityNumIdMap = new HashMap<String, String>();
        HashMap<String, Map<String, Set<String>>> allRelMap = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, String> cloudMap = new HashMap<String, String>();
        Map<String, String> appMap = FunctionPermission.getAllAppInfo(localeId, appIdQuerySetStr);
        Map<String, String> entityMap = FunctionPermission.getAllEntityInfo(localeId, modelTypeSetStr, appIdQuerySetStr);
        String adminUsableEntitiesInfo = null;
        if (!PermCommonUtil.hasEnableOldAdmin()) {
            String adminInfoStr;
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
            if (adminUser && StringUtils.isNotEmpty((String)(adminInfoStr = CacheMrg.getCache((String)adminKey, (String)String.valueOf(userId)))) && !"{}".equalsIgnoreCase(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                String adminTypeStr = (String)adminInfo.get("adminType");
                long adminType = Long.parseLong(adminTypeStr);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                if (!CollectionUtils.isEmpty((Collection)adminGroupIds)) {
                    adminUsableEntitiesInfo = FunctionPermission.getAdminUsableEntitiesInfo(adminType, localeId, allRelMap, entityNumIdMap, cloudMap, appMap, entityMap, FunctionPermission.getAdminSys(adminGroupIds), modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
                }
            }
        } else {
            DynamicObject admin = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_admin", (String)"admintype", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
            if (admin != null) {
                Long adminType = admin.getLong("admintype.id");
                adminUsableEntitiesInfo = FunctionPermission.getAdminUsableEntitiesInfo(adminType, localeId, allRelMap, entityNumIdMap, cloudMap, appMap, entityMap, null, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
            }
        }
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            String superUserUsableEntitiesInfo = null;
            superUserUsableEntitiesInfo = StringUtils.isNotEmpty(adminUsableEntitiesInfo) ? FunctionPermission.getSuperUserUsableEntitiesInfo(allRelMap, entityNumIdMap, cloudMap, appMap, entityMap, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr, appIdQuerySet) : FunctionPermission.getSuperUserUsableEntitiesInfo(null, null, cloudMap, appMap, entityMap, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr, appIdQuerySet);
            return superUserUsableEntitiesInfo;
        }
        String algoKeyPrefix = FunctionPermission.class.getName() + ".getUsableEntitiesInfo.";
        boolean enableSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        if (enableSingleBizRole) {
            FunctionPermission.getUsableEntInfoByUserSingleBizRolePerm(userId, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, algoKeyPrefix, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
        } else {
            FunctionPermission.getUsableEntInfoByUserPerm(userId, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, algoKeyPrefix, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr, oriAppIdQuerySet);
        }
        HashSet<String> hasPermItemEntityIds = new HashSet<String>(8);
        Set<String> entNumSet = FunctionPermission.getFunctionPermEntNumSet(algoKeyPrefix);
        Map permControlTypeMap = PermCommonUtil.getPermControlType(entNumSet);
        StringBuilder hasFuncPermEntsql = new StringBuilder().append("SELECT distinct fp.fentitytypeid entid ").append(" FROM t_perm_functionperm fp ");
        try (DataSet ds = DB.queryDataSet((String)(algoKeyPrefix + "hasFuncPermEntsql"), (DBRoute)DBRoute.permission, (String)hasFuncPermEntsql.toString());){
            while (ds.hasNext()) {
                boolean controlFunction;
                Row data = ds.next();
                String entid = data.getString("entid");
                PermissionControlType permissionControlType = (PermissionControlType)permControlTypeMap.get(entid);
                if (null == permissionControlType || !(controlFunction = permissionControlType.isControlFunction())) continue;
                hasPermItemEntityIds.add(entid);
            }
        }
        StringBuilder noFuncPermEntSql = new StringBuilder("SELECT ent.fid entityId, ent.fnumber entityNum , entl.fname entityName, burf.fid AS burfId ");
        noFuncPermEntSql.append(" FROM t_meta_entitydesign ent ");
        noFuncPermEntSql.append(" INNER JOIN t_meta_entitydesign_l entl ON (ent.fid = entl.fid and entl.FLOCALEID = ?) ");
        noFuncPermEntSql.append(" INNER JOIN t_meta_bizunitrelform burf ON burf.fformid = ent.fid ");
        noFuncPermEntSql.append(" WHERE ent.FISTEMPLATE = '0' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            noFuncPermEntSql.append(" AND ent.FMODELTYPE IN('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            noFuncPermEntSql.append(" AND ent.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        noFuncPermEntSql.append(" AND ent.ftype = '0' ");
        Object[] noFuncPermEntParams = new Object[]{localeId};
        StringBuilder noFuncPermAppSql = new StringBuilder("SELECT cloud.fid AS cloudId, cloud.fname AS cloudName, t1.fid AS appId, t3.fname AS appName, burf.fid AS burfId, t1.falluserapp ");
        noFuncPermAppSql.append(" FROM t_meta_appruntime t1 ");
        noFuncPermAppSql.append(" INNER JOIN t_meta_bizapp t2 ON (t1.fid = t2.fid or t1.fid = t2.fmasterid) ");
        noFuncPermAppSql.append(" INNER JOIN t_meta_bizapp_l t3 ON (t2.fid = t3.fid and t3.FLOCALEID = ?) ");
        noFuncPermAppSql.append(" INNER JOIN t_meta_bizunitrelform burf ON t2.fid = burf.FBIZAPPID ");
        noFuncPermAppSql.append(" INNER JOIN t_meta_bizcloud_l cloud ON (cloud.FID = t2.FBIZCLOUDID AND cloud.FLOCALEID = ?) ");
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            noFuncPermAppSql.append(" WHERE t1.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        Object[] noFuncPermAppParams = new Object[]{localeId, localeId};
        try (DataSet noFuncPermEntDs = DB.queryDataSet((String)(algoKeyPrefix + "noFuncPermEntSql"), (DBRoute)DBRoute.meta, (String)noFuncPermEntSql.toString(), (Object[])noFuncPermEntParams);
             DataSet noFuncPermAppDs = DB.queryDataSet((String)(algoKeyPrefix + "noFuncPermAppSql"), (DBRoute)DBRoute.meta, (String)noFuncPermAppSql.toString(), (Object[])noFuncPermAppParams);
             DataSet ds = noFuncPermEntDs.join(noFuncPermAppDs, JoinType.INNER).on("burfId", "burfId").select(new String[]{"entityId", "entityNum", "entityName"}, new String[]{"cloudId", "cloudName", "appId", "appName", "falluserapp"}).finish();){
            while (ds.hasNext()) {
                String entityNameFromMap;
                Row data = ds.next();
                String cloudId = data.getString("cloudId");
                String cloudName = data.getString("cloudName");
                String appId = data.getString("appId");
                String appName = data.getString("appName");
                String entityId = data.getString("entityId");
                String entityNum = data.getString("entityNum");
                String entityName = data.getString("entityName");
                String falluserapp = data.getString("falluserapp");
                if (!Objects.equals(falluserapp, "1") && hasPermItemEntityIds.contains(entityNum)) continue;
                String appNameFromMap = appMap.get(appId);
                if (StringUtils.isEmpty((String)appNameFromMap)) {
                    String appRutimeName = FunctionPermission.getAppName(appId);
                    if (StringUtils.isNotEmpty((String)appRutimeName)) {
                        appName = appRutimeName;
                    }
                    appMap.put(appId, appName);
                }
                if (StringUtils.isEmpty((String)(entityNameFromMap = entityMap.get(entityNum)))) {
                    String entityRuntimeName = FunctionPermission.getRuntimeFormName(entityNum);
                    if (StringUtils.isNotEmpty((String)entityRuntimeName)) {
                        entityName = entityRuntimeName;
                    }
                    entityMap.put(entityNum, entityName);
                }
                cloudMap.put(cloudId, cloudName);
                entityNumIdMap.put(entityNum, entityId);
                allRelMap.computeIfAbsent(cloudId, k -> new HashMap()).computeIfAbsent(appId, k -> new HashSet()).add(entityNum);
            }
        }
        return FunctionPermission.generateJsonStr(cloudMap, appMap, entityMap, entityNumIdMap, allRelMap);
    }

    private static Set<String> getFunctionPermEntNumSet(String algoKeyPrefix) {
        HashSet<String> entNumSet = new HashSet<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT distinct fentitytypeid FROM t_perm_functionperm");
        try (DataSet ds = DB.queryDataSet((String)(algoKeyPrefix + "getFunctionPermEntNumSet"), (DBRoute)DBRoute.permission, (String)sb.toString());){
            while (ds.hasNext()) {
                Row data = ds.next();
                String entid = data.getString("fentitytypeid");
                entNumSet.add(entid);
            }
        }
        return entNumSet;
    }

    private static DataSet getAdminSys(Set<Long> adminGroupIds) {
        DataSet adminFuncPermDS = null;
        for (Long adminGroupId : adminGroupIds) {
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id,parent,level");
            long currentGroupId = adminGroupId;
            long parent = adminGroup.getLong("parent.id");
            long level = adminGroup.getLong("level");
            DataSet adminGroupSys = null;
            while (level > 1L && (adminGroupSys == null || adminGroupSys.copy().isEmpty())) {
                adminGroupSys = FunctionPermission.getEntityAdminGroupSys(currentGroupId);
                if (!adminGroupSys.copy().isEmpty()) continue;
                adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id,parent,level");
                currentGroupId = parent;
                parent = adminGroup.getLong("parent.id");
                level = adminGroup.getLong("level");
            }
            if (adminGroupSys != null && !adminGroupSys.copy().isEmpty()) {
                if (adminFuncPermDS == null) {
                    adminFuncPermDS = adminGroupSys;
                    continue;
                }
                adminFuncPermDS = adminFuncPermDS.union(adminGroupSys);
                continue;
            }
            return null;
        }
        return adminFuncPermDS;
    }

    private static DataSet getEntityAdminGroupSys(Long adminGroupId) {
        String sql = " SELECT DISTINCT fappid fbizappid, fentitynum FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        return DB.queryDataSet((String)"getEntityAdminGroupSys", (DBRoute)DBRoute.permission, (String)sql);
    }

    @Deprecated
    public static String getAdminUsableEntitiesInfo(Long userId, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap) {
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String getAdminUsableEntitiesInfo(Long adminType, String localeId, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> entityNumIdMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet adminFuncPerm, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DataSet getAdminFuncPermDS(String algoKeyPrefix, DataSet adminFuncPerm, String appIdQuerySetStr, String oriAppIdQuerySetStr, Long adminType) {
        if (adminFuncPerm != null) {
            return adminFuncPerm;
        }
        boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
        if (superAdminStrategy) {
            StringBuilder appIdEntNumSb = new StringBuilder();
            appIdEntNumSb.append(" SELECT a.fbizappid, b.fnumber fentitynum FROM t_meta_bizunitrelform a ");
            appIdEntNumSb.append("  LEFT JOIN t_meta_entitydesign b ON a.fformid = b.fid ");
            if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
                appIdEntNumSb.append(" where a.fbizappid in ('").append(appIdQuerySetStr).append("') ");
            }
            DataSet appIdEntNum = DB.queryDataSet((String)(algoKeyPrefix + "bizunitrelform"), (DBRoute)DBRoute.meta, (String)appIdEntNumSb.toString());
            StringBuilder publishAppIdEntNumSb = new StringBuilder();
            publishAppIdEntNumSb.append(" SELECT fbizappid, fbizobjid fentitynum FROM t_perm_bizobjapp ");
            if (StringUtils.isNotEmpty((String)oriAppIdQuerySetStr)) {
                publishAppIdEntNumSb.append(" where fbizappid in ('").append(oriAppIdQuerySetStr).append("') ");
            }
            DataSet publishAppIdDSEntNum = DB.queryDataSet((String)(algoKeyPrefix + "bizobjapp"), (DBRoute)DBRoute.permission, (String)publishAppIdEntNumSb.toString());
            return appIdEntNum.union(publishAppIdDSEntNum);
        }
        StringBuilder adminFuncPermSb = new StringBuilder();
        adminFuncPermSb.append(" SELECT DISTINCT dtl.fbizappid, dtl.fentitynum FROM t_perm_adminschemedetail dtl ");
        adminFuncPermSb.append(" INNER JOIN t_perm_adminschemeentry ent ON (dtl.fentryid = ent.fentryid AND ent.FADMINTYPE = ?) ");
        adminFuncPermSb.append(" INNER JOIN t_perm_adminscheme ads ON (ads.FID = ent.FID AND ads.FENABLE = '1') ");
        if (StringUtils.isNotEmpty((String)oriAppIdQuerySetStr)) {
            adminFuncPermSb.append(" where dtl.fbizappid in ('").append(oriAppIdQuerySetStr).append("') ");
        }
        adminFuncPermSb.append(" ORDER BY dtl.fbizappid ");
        return DB.queryDataSet((String)(algoKeyPrefix + "adminFuncPermDS"), (DBRoute)DBRoute.permission, (String)adminFuncPermSb.toString(), (Object[])new Object[]{adminType});
    }

    public static Set<Long> getAppUser(String appId) {
        Long userId;
        Row data;
        Iterator rowIterator3;
        DynamicObject[] dynamicObjects;
        HashSet<Long> userIds = new HashSet<Long>(16);
        Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel((String)appId);
        appId = (String)extAppAndOrgnlAppRel.get(appId);
        String cache = CacheMrg.getCache((String)CacheMrg.getType4AppUser(), (String)appId);
        if (!StringUtils.isEmpty((String)cache)) {
            Set userIdStr = (Set)SerializationUtils.fromJsonString((String)cache, Set.class);
            for (String id : userIdStr) {
                userIds.add(Long.parseLong(id));
            }
            return userIds;
        }
        for (DynamicObject superUser : dynamicObjects = BusinessDataServiceHelper.load((String)"perm_superuser", (String)"user", null)) {
            long userId2 = superUser.getLong("user.id");
            userIds.add(userId2);
        }
        String algoKey = PermissionServiceImpl.class.getName();
        Set directUserIdSet = DirectAuthorizeHelper.getDirectUserId((String)appId);
        Set directDisFunUserIdSet = DirectAuthorizeHelper.getDirectDisFunUserId((String)appId);
        directUserIdSet.removeAll(directDisFunUserIdSet);
        userIds.addAll(directUserIdSet);
        String validateSqlPart = "";
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            validateSqlPart = " and (now() between ur.fstarttime and ur.fendtime or (ur.fstarttime is null and  ur.fendtime is null) or  (now() >= ur.fstarttime and ur.fendtime is null) or (ur.fstarttime is null and now() <=  ur.fendtime )) ";
        }
        StringBuilder sql = new StringBuilder().append("SELECT distinct urr.fuserid userid ").append("FROM t_perm_rolepermdetial rpd ").append("INNER JOIN (").append("   SELECT DISTINCT ur.froleid, ur.fuserid FROM T_PERM_USERROLE ur ").append("   INNER JOIN T_PERM_ROLE r ON r.fid = ur.FROLEID ").append("   WHERE r.fenable = '1' ").append(validateSqlPart).append(" ) urr on (urr.froleid = rpd.froleid) ").append(" WHERE rpd.FBIZAPPID = ? ").append(" AND NOT EXISTS ( ").append(" SELECT 1 from t_perm_disfunperm dfp ").append(" WHERE dfp.FBIZAPPID = ? and urr.fuserid = dfp.fuserid ").append(" AND rpd.fpermitemid = dfp.fpermitemid ").append(" AND rpd.fentitytypeid = dfp.fentitytypeid) ");
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{appId, appId});){
            Iterator rowIterator2 = ds.iterator();
            while (rowIterator2 != null && rowIterator2.hasNext()) {
                Row data2 = (Row)rowIterator2.next();
                Long userId3 = data2.getLong("userid");
                userIds.add(userId3);
            }
        }
        String validateSqlPartForBizRole = "";
        if (enableValidateTime) {
            validateSqlPartForBizRole = " and (now() between ubr.fstarttime and ubr.fendtime  or (ubr.fstarttime is null and ubr.fendtime is null)  or (now() >= ubr.fstarttime and ubr.fendtime is null)  or (ubr.fstarttime is null and now() <= ubr.fendtime)) ";
        }
        sql = new StringBuilder().append("SELECT distinct urr.fuserid userid ").append("FROM t_perm_rolepermdetial rpd ").append("INNER JOIN (").append("   SELECT DISTINCT brcr.froleid, ubr.fuserid ").append("   FROM T_PERM_USERBIZROLE ubr ").append("   INNER JOIN T_PERM_BIZROLECOMROLE brcr ON brcr.fid = ubr.FBIZROLEID ").append("   INNER JOIN T_PERM_ROLE r ON r.fid = brcr.FROLEID ").append("   WHERE r.fenable = '1' ").append(validateSqlPartForBizRole).append(" ) urr on (urr.froleid = rpd.froleid) ").append(" WHERE rpd.FBIZAPPID = ? ");
        DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{appId});
        Object object = null;
        try {
            rowIterator3 = ds.iterator();
            while (rowIterator3 != null && rowIterator3.hasNext()) {
                data = (Row)rowIterator3.next();
                userId = data.getLong("userid");
                userIds.add(userId);
            }
        }
        catch (Throwable rowIterator3) {
            object = rowIterator3;
            throw rowIterator3;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable rowIterator3) {
                        ((Throwable)object).addSuppressed(rowIterator3);
                    }
                } else {
                    ds.close();
                }
            }
        }
        sql = new StringBuilder().append("SELECT distinct ubr.fuserid userid ").append("FROM T_PERM_BIZROLE br ").append("INNER JOIN t_perm_bizroleperm brp ON br.fid = brp.fid ").append("INNER JOIN t_perm_userbizrole ubr ON br.fid = ubr.fbizroleid ").append("WHERE br.fenable = '1' ").append(" AND brp.FBIZAPPID = ? ").append(validateSqlPartForBizRole);
        ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{appId});
        object = null;
        try {
            rowIterator3 = ds.iterator();
            while (rowIterator3 != null && rowIterator3.hasNext()) {
                data = (Row)rowIterator3.next();
                userId = data.getLong("userid");
                userIds.add(userId);
            }
        }
        catch (Throwable rowIterator4) {
            object = rowIterator4;
            throw rowIterator4;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable rowIterator4) {
                        ((Throwable)object).addSuppressed(rowIterator4);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> userIdStr = new HashSet<String>(userIds.size());
        for (Long userId4 : userIds) {
            userIdStr.add(userId4 + "");
        }
        CacheMrg.putCache((String)CacheMrg.getType4AppUser(), (String)appId, (String)SerializationUtils.toJsonString(userIdStr));
        return userIds;
    }

    private static String getRuntimeFormName(String formNum) {
        try {
            String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
            String name = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
            return name;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return null;
        }
    }

    public static HasPermDimObjResult getAllPermDimObjs(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getAllHasPermDimObjs((Long)userId, (String)dimType, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static HasPermOrgResult getAllPermOrgs(long userId, String appId, String entityNum, String permItemId) {
        HasPermDimObjResult allPermDimObjs = FunctionPermission.getAllPermDimObjs(userId, "bos_org", appId, entityNum, permItemId);
        return new HasPermOrgResultImpl(allPermDimObjs.hasAllDimObjPerm(), allPermDimObjs.getHasPermDimObjs());
    }

    private static Set<Long> getSubDimObjIdSet(Long includeSubDimObjId) {
        return new HashSet<Long>();
    }

    private static void getUsableEntInfoByUserSingleBizRolePerm(Long userId, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, String algoKeyPrefix, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr) {
        String bizRoleId = UserBizRoleCache.getSelBizRole((Long)userId);
        if (StringUtils.isEmpty((String)bizRoleId)) {
            return;
        }
        String localeId = RequestContext.get().getLang().name();
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = DEFAULT_LANG;
        }
        FunctionPermission.getUsableEntInfoByBusiRoleBcForSingleBizRole(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, algoKeyPrefix, bizRoleId, localeId, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
        FunctionPermission.getUsableEntInfoByBusiComRoleForSingleBizRole(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, algoKeyPrefix, bizRoleId, localeId, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
        FunctionPermission.getUsableEntInfoByBusiRoleForbidForSingleBizRole(allRelMap, algoKeyPrefix, bizRoleId, localeId, modelTypeSetStr, appIdQuerySetStr, oriAppIdQuerySetStr);
    }

    private static void getUsableEntInfoByBusiRoleForbidForSingleBizRole(Map<String, Map<String, Set<String>>> allRelMap, String algoKeyPrefix, String bizRoleId, String localeId, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr) {
        StringBuilder roleDisfuncPermSb = new StringBuilder();
        roleDisfuncPermSb.append(" SELECT disfuncp.fentitytypeid dfp_entnum, disfuncp.FBIZAPPID dfp_appid ");
        roleDisfuncPermSb.append("  FROM t_perm_bizroledisperm disfuncp ");
        roleDisfuncPermSb.append("  WHERE disfuncp.fid = ? AND disfuncp.fpermitemid= '47150e89000000ac' ");
        if (StringUtils.isNotEmpty((String)oriAppIdQuerySetStr)) {
            roleDisfuncPermSb.append(" where disfuncp.FBIZAPPID in ('").append(oriAppIdQuerySetStr).append("') ");
        }
        StringBuilder cloudAppSb = new StringBuilder();
        cloudAppSb.append(" SELECT cloudl.fid cloudl_id, cloudl.fname cloudl_name, ");
        cloudAppSb.append("  app.fid app_id, app.fnumber app_num, b.fname app_name ");
        cloudAppSb.append("  FROM t_meta_bizapp app ");
        cloudAppSb.append("  INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?) ");
        cloudAppSb.append("  INNER JOIN t_meta_bizapp_l b ON (app.fid = b.fid AND b.FLOCALEID = ?) ");
        cloudAppSb.append("  WHERE app.FDEPLOYSTATUS = '2' ");
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            cloudAppSb.append(" where app.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        StringBuilder entitySb = new StringBuilder();
        entitySb.append(" SELECT entd.FID entd_id, entd.FNumber entd_num ");
        entitySb.append(" FROM t_meta_entitydesign entd ");
        entitySb.append(" WHERE entd.FISTEMPLATE = '0' ");
        entitySb.append(" AND entd.FTYPE = '0' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            entitySb.append(" AND entd.FMODELTYPE IN('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            entitySb.append(" AND entd.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        try (DataSet roleDisfuncPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizRoleDisfuncPermDS"), (DBRoute)DBRoute.permission, (String)roleDisfuncPermSb.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});
             DataSet cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)cloudAppSb.toString(), (Object[])new Object[]{localeId, localeId});
             DataSet tempDS = roleDisfuncPermDS.join(cloudAppDS).on("dfp_appid", "app_id").select(new String[]{"dfp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet entityDS = DB.queryDataSet((String)(algoKeyPrefix + "entityDS"), (DBRoute)DBRoute.meta, (String)entitySb.toString());
             DataSet finalDS = tempDS.join(entityDS).on("dfp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id"}).finish();){
            while (finalDS.hasNext()) {
                Row data = finalDS.next();
                String cloudId = data.getString("cloudl_id");
                String appId = data.getString("app_id");
                String entityNum = data.getString("entd_num");
                allRelMap.computeIfPresent(cloudId, (cloudKey, appValue) -> {
                    appValue.computeIfPresent(appId, (appKey, entityValue) -> {
                        entityValue.remove(entityNum);
                        if (entityValue.size() == 0) {
                            return null;
                        }
                        return entityValue;
                    });
                    if (appValue.size() == 0) {
                        return null;
                    }
                    return appValue;
                });
            }
        }
    }

    private static void getUsableEntInfoByBusiComRoleForSingleBizRole(Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, String algoKeyPrefix, String bizRoleId, String localeId, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr) {
        StringBuilder comRolePermSb = new StringBuilder();
        comRolePermSb.append(" select distinct d.fbizappid brcr_appid, d.fentitytypeid brcr_entnum ");
        comRolePermSb.append(" from t_perm_bizrolecomrole a ");
        comRolePermSb.append(" join t_perm_role b on a.froleid=b.fid ");
        comRolePermSb.append(" join t_perm_rolepermdetial d on b.fid=d.froleid ");
        comRolePermSb.append(" WHERE a.fid = ? ");
        comRolePermSb.append(" AND b.fenable = '1'");
        comRolePermSb.append(" AND d.fpermitemid = '47150e89000000ac' ");
        if (StringUtils.isNotEmpty((String)oriAppIdQuerySetStr)) {
            comRolePermSb.append(" where d.fbizappid in ('").append(oriAppIdQuerySetStr).append("') ");
        }
        StringBuilder cloudAppSb = new StringBuilder();
        cloudAppSb.append(" SELECT cloudl.fid cloudl_id, cloudl.fname cloudl_name, ");
        cloudAppSb.append(" app.fid app_id, app.fnumber app_num, app.findustry app_industry, b.fname app_name ");
        cloudAppSb.append(" FROM t_meta_bizapp app ");
        cloudAppSb.append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?) ");
        cloudAppSb.append(" INNER JOIN t_meta_bizapp_l b ON (app.fid = b.fid AND b.FLOCALEID = ?) ");
        cloudAppSb.append(" WHERE app.FDEPLOYSTATUS = '2' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            cloudAppSb.append(" AND entd.FMODELTYPE IN('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            cloudAppSb.append(" AND app.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        StringBuilder entitySb = new StringBuilder();
        entitySb.append(" SELECT entd.FID entd_id, entd.FNumber entd_num, b.fname entd_name ");
        entitySb.append(" FROM t_meta_entitydesign entd ");
        entitySb.append(" INNER JOIN t_meta_entitydesign_l b on (entd.fid = b.fid and b.FLOCALEID = ?) ");
        entitySb.append(" WHERE entd.FISTEMPLATE = '0' ");
        entitySb.append(" AND entd.FTYPE = '0' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            entitySb.append(" AND entd.FMODELTYPE IN('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            entitySb.append(" AND entd.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        try (DataSet comRolePermDS = DB.queryDataSet((String)(algoKeyPrefix + "comRolePermDS"), (DBRoute)DBRoute.permission, (String)comRolePermSb.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});
             DataSet cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)cloudAppSb.toString(), (Object[])new Object[]{localeId, localeId});
             DataSet tempDS = comRolePermDS.join(cloudAppDS).on("brcr_appid", "app_id").select(new String[]{"brcr_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet entityDS = DB.queryDataSet((String)(algoKeyPrefix + "entityDS"), (DBRoute)DBRoute.meta, (String)entitySb.toString(), (Object[])new Object[]{localeId});
             DataSet finalDS = tempDS.join(entityDS).on("brcr_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoByBusiRoleBcForSingleBizRole(Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, String algoKeyPrefix, String bizRoleId, String localeId, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr) {
        StringBuilder bizRolePermSb = new StringBuilder();
        bizRolePermSb.append(" SELECT fbizappid brp_appid, fentitytypeid brp_entnum ");
        bizRolePermSb.append("  FROM t_perm_bizroleperm ");
        bizRolePermSb.append("  WHERE fid = ? AND fpermitemid= '47150e89000000ac' ");
        if (StringUtils.isNotEmpty((String)oriAppIdQuerySetStr)) {
            bizRolePermSb.append(" where fbizappid in ('").append(oriAppIdQuerySetStr).append("') ");
        }
        StringBuilder cloudAppSb = new StringBuilder();
        cloudAppSb.append(" SELECT cloudl.fid cloudl_id, cloudl.fname cloudl_name, ");
        cloudAppSb.append("  app.fid app_id, app.fnumber app_num, b.fname app_name ");
        cloudAppSb.append("  FROM t_meta_bizapp app ");
        cloudAppSb.append("  INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?) ");
        cloudAppSb.append("  INNER JOIN t_meta_bizapp_l b ON (app.fid = b.fid AND b.FLOCALEID = ?) ");
        cloudAppSb.append("   WHERE app.FDEPLOYSTATUS = '2' ");
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            cloudAppSb.append(" and app.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        StringBuilder entitySb = new StringBuilder();
        entitySb.append(" SELECT entd.FID entd_id, entd.FNumber entd_num, b.fname entd_name ");
        entitySb.append(" FROM t_meta_entitydesign entd ");
        entitySb.append(" INNER JOIN t_meta_entitydesign_l b on (entd.fid = b.fid and b.FLOCALEID = ?) ");
        entitySb.append(" WHERE entd.FISTEMPLATE = '0' ");
        entitySb.append(" AND entd.FTYPE = '0' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            entitySb.append(" AND entd.FMODELTYPE IN('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            entitySb.append(" AND entd.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        try (DataSet bizRolePermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizRolePermDS"), (DBRoute)DBRoute.permission, (String)bizRolePermSb.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});
             DataSet cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)cloudAppSb.toString(), (Object[])new Object[]{localeId, localeId});
             DataSet tempDS = bizRolePermDS.join(cloudAppDS).on("brp_appid", "app_id").select(new String[]{"brp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet entityDS = DB.queryDataSet((String)(algoKeyPrefix + "entityDS"), (DBRoute)DBRoute.meta, (String)entitySb.toString(), (Object[])new Object[]{localeId});
             DataSet finalDS = tempDS.join(entityDS).on("brp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoByUserPerm(final Long userId, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, String algoKeyPrefix, String modelTypeSetStr, String appIdQuerySetStr, String oriAppIdQuerySetStr, Set<String> oriAppIdQuerySet) {
        String localeId = RequestContext.get().getLang().name();
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = DEFAULT_LANG;
        }
        Callable<Set<String>> roleIDsCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserID((Long)userId);
            }
        };
        Future bizCommRoleIdFuture = pool.submit((Callable)roleIDsCallable, RequestContext.get());
        HashSet<String> authrorizeEntNumSet = new HashSet<String>(8);
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        try (DataSet userPermDS = FunctionPermission.getUserDirectDs(userId, algoKeyPrefix, oriAppIdQuerySet, authrorizeEntNumSet);
             DataSet comRoleDS = FunctionPermission.getComRoleDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet usrGrpComRoleDS = FunctionPermission.getUsrGrpComRoleDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet busiRoleComRoleDS = FunctionPermission.getBusiRoleComRoleDs(algoKeyPrefix, oriAppIdQuerySet, bizCommRoleIdFuture, authrorizeEntNumSet);
             DataSet busiRoleBcDS = FunctionPermission.getBusiRoleBcDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet usrGrpBusiRoleBcDS = FunctionPermission.getUsrGrpBusiRoleBcDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet busiRoleForbidDS = FunctionPermission.getBusiRoleForbidDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet usrGrpBusiRoleForbidDS = FunctionPermission.getUsrGrpBusiRoleForbidDs(userId, algoKeyPrefix, oriAppIdQuerySet, enableValidateTime, authrorizeEntNumSet);
             DataSet userForbidDS = FunctionPermission.getUserForbidDs(userId, algoKeyPrefix, oriAppIdQuerySet, authrorizeEntNumSet);
             DataSet entityDSForDir = FunctionPermission.getEntityDSForDir(algoKeyPrefix, modelTypeSetStr, appIdQuerySetStr, localeId, authrorizeEntNumSet);
             DataSet entityDSForComRole = entityDSForDir.copy();
             DataSet entityDSForUsrGrpComRole = entityDSForDir.copy();
             DataSet entityDSForBizRolePerm = entityDSForDir.copy();
             DataSet entityDSForUsrGrpBizRolePerm = entityDSForDir.copy();
             DataSet entityDSForBizComRolePerm = entityDSForDir.copy();
             DataSet entityDSForBizRoleDisPerm = entityDSForDir.copy();
             DataSet entityDSForUsrGrpBizRoleDisPerm = entityDSForDir.copy();
             DataSet entityDSForDisFun = entityDSForDir.copy();
             DataSet cloudAppDSForDir = FunctionPermission.getCloudAppDSForDir(algoKeyPrefix, appIdQuerySetStr, localeId);
             DataSet cloudAppDSForComRole = cloudAppDSForDir.copy();
             DataSet cloudAppDSForUsrGrpComRole = cloudAppDSForDir.copy();
             DataSet cloudAppDSForBizRolePerm = cloudAppDSForDir.copy();
             DataSet cloudAppDSForUsrGrpBizRolePerm = cloudAppDSForDir.copy();
             DataSet cloudAppDSForBizComRolePerm = cloudAppDSForDir.copy();
             DataSet cloudAppDSForBizRoleDisPerm = cloudAppDSForDir.copy();
             DataSet cloudAppDSForUsrGrpBizRoleDisPerm = cloudAppDSForDir.copy();
             DataSet cloudAppDSForDisFun = cloudAppDSForDir.copy();
             DataSet tempDS = userPermDS.join(cloudAppDSForDir).on("upd_appid", "app_id").select(new String[]{"upd_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForDir).on("upd_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
            FunctionPermission.getUsableEntInfoByCommrole(comRoleDS, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, cloudAppDSForComRole, entityDSForComRole);
            FunctionPermission.getUsableEntInfoByUsrGrpCommrole(usrGrpComRoleDS, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, cloudAppDSForUsrGrpComRole, entityDSForUsrGrpComRole);
            FunctionPermission.getUsableEntInfoByBusiRoleCommrole(busiRoleComRoleDS, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, cloudAppDSForBizComRolePerm, entityDSForBizComRolePerm);
            FunctionPermission.getUsableEntInfoByBusiRoleBc(busiRoleBcDS, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, cloudAppDSForBizRolePerm, entityDSForBizRolePerm);
            FunctionPermission.getUsableEntInfoByUsrGrpBusiRoleBc(usrGrpBusiRoleBcDS, entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, cloudAppDSForUsrGrpBizRolePerm, entityDSForUsrGrpBizRolePerm);
            FunctionPermission.getUsableEntInfoByBusiRoleForbid(busiRoleForbidDS, allRelMap, cloudAppDSForBizRoleDisPerm, entityDSForBizRoleDisPerm);
            FunctionPermission.getUsableEntInfoByUsrGrpBusiRoleForbid(usrGrpBusiRoleForbidDS, allRelMap, cloudAppDSForUsrGrpBizRoleDisPerm, entityDSForUsrGrpBizRoleDisPerm);
            FunctionPermission.getUsableEntInfoByUserForbid(userForbidDS, allRelMap, cloudAppDSForDisFun, entityDSForDisFun);
        }
    }

    private static DataSet getCloudAppDSForDir(String algoKeyPrefix, String appIdQuerySetStr, String localeId) {
        StringBuilder cloudAppDSForDirSb = new StringBuilder();
        cloudAppDSForDirSb.append(" SELECT cloudl.fid cloudl_id, cloudl.fname cloudl_name, ");
        cloudAppDSForDirSb.append(" app.fid app_id, app.fnumber app_num, b.fname app_name ");
        cloudAppDSForDirSb.append(" FROM t_meta_bizapp app ");
        cloudAppDSForDirSb.append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?) ");
        cloudAppDSForDirSb.append(" INNER JOIN t_meta_bizapp_l b ON (app.fid = b.fid AND b.FLOCALEID = ?) ");
        cloudAppDSForDirSb.append(" WHERE app.FDEPLOYSTATUS = '2' ");
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            cloudAppDSForDirSb.append(" and app.fid in ('").append(appIdQuerySetStr).append("') ");
        }
        return DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)cloudAppDSForDirSb.toString(), (Object[])new Object[]{localeId, localeId});
    }

    private static DataSet getEntityDSForDir(String algoKeyPrefix, String modelTypeSetStr, String appIdQuerySetStr, String localeId, Set<String> authrorizeEntNumSet) {
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder entityDSForDirSb = new StringBuilder();
        entityDSForDirSb.append(" select entd.FID entd_id, entd.fnumber entd_num, b.fname entd_name ");
        entityDSForDirSb.append(" from t_meta_entitydesign entd ");
        entityDSForDirSb.append(" left join t_meta_entitydesign_l b on (entd.fid = b.fid and b.flocaleid = ?) ");
        paramList.add(localeId);
        entityDSForDirSb.append(" where entd.fistemplate = '0' ");
        entityDSForDirSb.append(" and entd.ftype = '0' ");
        if (StringUtils.isNotEmpty((String)modelTypeSetStr)) {
            entityDSForDirSb.append(" and entd.fmodeltype in('").append(modelTypeSetStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdQuerySetStr)) {
            entityDSForDirSb.append(" and entd.fbizappid in ('").append(appIdQuerySetStr).append("') ");
        }
        if (null != authrorizeEntNumSet && !authrorizeEntNumSet.isEmpty()) {
            entityDSForDirSb.append(" and entd.fnumber in (").append(String.join((CharSequence)",", Collections.nCopies(authrorizeEntNumSet.size(), "?"))).append(") ");
            for (String authrorizeEntNum : authrorizeEntNumSet) {
                paramList.add(authrorizeEntNum);
            }
        }
        return DB.queryDataSet((String)(algoKeyPrefix + "getEntityDSForDir"), (DBRoute)DBRoute.meta, (String)entityDSForDirSb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
    }

    private static DataSet getUserForbidDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select disfuncp.fentitytypeid dfp_entnum, disfuncp.fbizappid dfp_appid ");
        stringBuilder.append(" from t_perm_disfunperm disfuncp ");
        stringBuilder.append(" where disfuncp.fuserid = ? and disfuncp.fpermitemid= '47150e89000000ac' ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            stringBuilder.append(" and disfuncp.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet disfuncPermDS = DB.queryDataSet((String)(algoKeyPrefix + "disfuncPermDS"), (DBRoute)DBRoute.permission, (String)stringBuilder.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = disfuncPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("dfp_entnum"));
            }
        }
        return disfuncPermDS;
    }

    private static DataSet getUsrGrpBusiRoleForbidDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder bizDispermSqlSB = new StringBuilder();
        bizDispermSqlSB.append(" select c.fentitytypeid pbdp_entnum, c.fbizappid pbdp_appid ");
        bizDispermSqlSB.append(" from t_perm_usrgrpbizrole a ");
        bizDispermSqlSB.append(" inner join t_sec_usergroupstaff b on b.fusergroupid = a.fusrgrpid ");
        bizDispermSqlSB.append(" inner join t_perm_bizroledisperm c on c.fid = a.fbizroleid ");
        bizDispermSqlSB.append("  where b.fuserid  = ? and c.fpermitemid ='47150e89000000ac' ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            bizDispermSqlSB.append(" and c.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet bizDisPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizDisPermDS"), (DBRoute)DBRoute.permission, (String)bizDispermSqlSB.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = bizDisPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("pbdp_entnum"));
            }
        }
        return bizDisPermDS;
    }

    private static DataSet getBusiRoleForbidDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder bizDispermSqlSB = new StringBuilder("SELECT pbdp.fentitytypeid pbdp_entnum, pbdp.fbizappid pbdp_appid ");
        bizDispermSqlSB.append(" from t_perm_bizroledisperm pbdp inner join t_perm_userbizrole pub");
        bizDispermSqlSB.append(" on pbdp.fid = pub.fbizroleid where pub.fuserid = ? and pbdp.fpermitemid= '47150e89000000ac' ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            bizDispermSqlSB.append(" and pbdp.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        if (enableValidateTime) {
            bizDispermSqlSB.append(" and ( now() between pub.fstarttime and pub.fendtime or (pub.fstarttime is null and pub.fendtime is null)").append(" or ( now() >= pub.fstarttime and pub.fendtime is null) or (pub.fstarttime is null and now() <=  pub.fendtime )").append(')');
        }
        DataSet bizDisPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizDisPermDS"), (DBRoute)DBRoute.permission, (String)bizDispermSqlSB.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = bizDisPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("pbdp_entnum"));
            }
        }
        return bizDisPermDS;
    }

    private static DataSet getUsrGrpBusiRoleBcDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder bizpermSqlSB = new StringBuilder();
        bizpermSqlSB.append("select c.fentitytypeid pbp_entnum, c.fbizappid pbp_appid");
        bizpermSqlSB.append(" from t_perm_usrgrpbizrole a ");
        bizpermSqlSB.append(" inner join t_sec_usergroupstaff b on b.fusergroupid = a.fusrgrpid ");
        bizpermSqlSB.append(" inner join t_perm_bizroleperm c on c.fid = a.fbizroleid ");
        bizpermSqlSB.append(" where b.fuserid  = ? and c.fpermitemid ='47150e89000000ac' ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            bizpermSqlSB.append(" and c.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet bizPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizPermDS"), (DBRoute)DBRoute.permission, (String)bizpermSqlSB.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = bizPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("pbp_entnum"));
            }
        }
        return bizPermDS;
    }

    private static DataSet getBusiRoleBcDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder bizpermSqlSB = new StringBuilder("select pbp.fentitytypeid pbp_entnum, pbp.fbizappid pbp_appid");
        bizpermSqlSB.append(" from t_perm_bizroleperm pbp inner join t_perm_userbizrole pub on (pbp.fid = pub.fbizroleid)");
        bizpermSqlSB.append(" where pub.fuserid = ? and pbp.fpermitemid= '47150e89000000ac' ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            bizpermSqlSB.append(" and pbp.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        if (enableValidateTime) {
            bizpermSqlSB.append(" and ( now() between pub.fstarttime and pub.fendtime or (pub.fstarttime is null and pub.fendtime is null)").append(" or ( now() >= pub.fstarttime and pub.fendtime is null) or (pub.fstarttime is null and now() <=  pub.fendtime )").append(')');
        }
        DataSet bizPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizPermDS"), (DBRoute)DBRoute.permission, (String)bizpermSqlSB.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = bizPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("pbp_entnum"));
            }
        }
        return bizPermDS;
    }

    private static DataSet getBusiRoleComRoleDs(String algoKeyPrefix, Set<String> oriAppIdQuerySet, Future<Set<String>> bizCommRoleIdFuture, Set<String> authrorizeEntNumSet) {
        Set<String> bizComRoleIdSet = null;
        try {
            bizComRoleIdSet = bizCommRoleIdFuture.get();
            if (null == bizComRoleIdSet || bizComRoleIdSet.isEmpty()) {
                return null;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder sqlSb = new StringBuilder("select rolepd.fentitytypeid rolepd_entnum,rolepd.fbizappid rolepd_appid");
        sqlSb.append(" from t_perm_rolepermdetial rolepd ");
        sqlSb.append(" where rolepd.fpermitemid= '47150e89000000ac' ");
        if (null != bizComRoleIdSet && !bizComRoleIdSet.isEmpty()) {
            sqlSb.append(" and rolepd.froleid in (").append(String.join((CharSequence)",", Collections.nCopies(bizComRoleIdSet.size(), "?"))).append(") ");
            for (String bizComRoleId : bizComRoleIdSet) {
                paramList.add(bizComRoleId);
            }
        }
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            sqlSb.append(" and rolepd.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet bizComPermDS = DB.queryDataSet((String)(algoKeyPrefix + "bizComPermDS"), (DBRoute)DBRoute.permission, (String)sqlSb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = bizComPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("rolepd_entnum"));
            }
        }
        return bizComPermDS;
    }

    private static DataSet getUsrGrpComRoleDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        String sqlPart = "";
        if (enableValidateTime) {
            sqlPart = " and (now() between a.fstarttime and a.fendtime or (a.fstarttime is null and  a.fendtime is null) or  (now() >= a.fstarttime and a.fendtime is null) or (a.fstarttime is null and now() <=  a.fendtime )) ";
        }
        StringBuilder userRoleSb = new StringBuilder();
        userRoleSb.append(" select distinct a.froleid roleid from t_perm_usrgrprole a ");
        userRoleSb.append(" inner join t_sec_usergroupstaff b on b.fusergroupid =  a.fusrgrpid ");
        userRoleSb.append(" inner join t_perm_role d on d.fid = a.froleid and d.fenable ='1' ");
        userRoleSb.append(" where b.fuserid  = ?  ");
        userRoleSb.append(sqlPart);
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder rolePermSb = new StringBuilder();
        rolePermSb.append(" select rolepd.fentitytypeid rolepd_entnum, ");
        rolePermSb.append(" rolepd.fbizappid rolepd_appid, rolepd.fpermitemid rolepd_permitemid,rolepd.froleid roleid ");
        rolePermSb.append(" from t_perm_rolepermdetial rolepd ");
        rolePermSb.append(" where rolepd.fpermitemid = '47150e89000000ac' ");
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            rolePermSb.append(" and rolepd.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet userRoleDS = DB.queryDataSet((String)(algoKeyPrefix + "userRoleDS"), (DBRoute)DBRoute.permission, (String)userRoleSb.toString(), (Object[])new Object[]{userId});
        DataSet rolePermDS = DB.queryDataSet((String)(algoKeyPrefix + "rolePermDS"), (DBRoute)DBRoute.permission, (String)rolePermSb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        DataSet rolePermDS2 = rolePermDS.join(userRoleDS).on("roleid", "roleid").select(new String[]{"rolepd_entnum", "rolepd_appid", "rolepd_permitemid"}).finish();
        try (DataSet copy = rolePermDS2.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("rolepd_entnum"));
            }
        }
        return rolePermDS2;
    }

    private static DataSet getComRoleDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, boolean enableValidateTime, Set<String> authrorizeEntNumSet) {
        StringBuilder userRoleSb = new StringBuilder();
        String sqlPart = "";
        if (enableValidateTime) {
            sqlPart = " and (now() between ur.fstarttime and ur.fendtime or (ur.fstarttime is null and  ur.fendtime is null) or  (now() >= ur.fstarttime and ur.fendtime is null) or (ur.fstarttime is null and now() <=  ur.fendtime )) ";
        }
        userRoleSb.append(" SELECT distinct ur.froleid roleid from t_perm_userrole ur ");
        userRoleSb.append(" inner join t_perm_role r on r.fid = ur.froleid ");
        userRoleSb.append(" where ur.fuserid = ? AND r.fenable = '1' ");
        userRoleSb.append(sqlPart);
        StringBuilder rolePermSb = new StringBuilder();
        rolePermSb.append(" SELECT rolepd.fentitytypeid rolepd_entnum, ");
        rolePermSb.append(" rolepd.fbizappid rolepd_appid, rolepd.fpermitemid rolepd_permitemid,rolepd.froleid roleid ");
        rolePermSb.append(" from t_perm_rolepermdetial rolepd ");
        rolePermSb.append(" where rolepd.fpermitemid = '47150e89000000ac' ");
        ArrayList<String> paramList = new ArrayList<String>(10);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            rolePermSb.append(" and rolepd.fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet userRoleDS = DB.queryDataSet((String)(algoKeyPrefix + "userRoleDS"), (DBRoute)DBRoute.permission, (String)userRoleSb.toString(), (Object[])new Object[]{userId});
        DataSet rolePermDS = DB.queryDataSet((String)(algoKeyPrefix + "rolePermDS"), (DBRoute)DBRoute.permission, (String)rolePermSb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        DataSet rolePermDS2 = rolePermDS.join(userRoleDS).on("roleid", "roleid").select(new String[]{"rolepd_entnum", "rolepd_appid", "rolepd_permitemid"}).finish().distinct();
        try (DataSet copy = rolePermDS2.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("rolepd_entnum"));
            }
        }
        return rolePermDS2;
    }

    private static DataSet getUserDirectDs(Long userId, String algoKeyPrefix, Set<String> oriAppIdQuerySet, Set<String> authrorizeEntNumSet) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder userPermSql = new StringBuilder();
        userPermSql.append("select distinct fentitytypeid upd_entnum, fbizappid upd_appid");
        userPermSql.append(" from t_perm_userpermdetail");
        userPermSql.append(" where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid = '47150e89000000ac' and fdimid > 0 ");
        paramList.add(userId);
        if (null != oriAppIdQuerySet && !oriAppIdQuerySet.isEmpty()) {
            userPermSql.append(" and fbizappid in (").append(String.join((CharSequence)",", Collections.nCopies(oriAppIdQuerySet.size(), "?"))).append(") ");
            for (String oriAppIdQuery : oriAppIdQuerySet) {
                paramList.add(oriAppIdQuery);
            }
        }
        DataSet userPermDS = DB.queryDataSet((String)(algoKeyPrefix + "userPermDS"), (DBRoute)DBRoute.permission, (String)userPermSql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
        try (DataSet copy = userPermDS.copy();){
            while (copy.hasNext()) {
                Row row = copy.next();
                authrorizeEntNumSet.add(row.getString("upd_entnum"));
            }
        }
        return userPermDS;
    }

    private static void getUsableEntInfoByUserForbid(DataSet userForbidDS, Map<String, Map<String, Set<String>>> allRelMap, DataSet cloudAppDSForDisFun, DataSet entityDSForDisFun) {
        if (null == userForbidDS) {
            return;
        }
        try (DataSet tempDS = userForbidDS.join(cloudAppDSForDisFun).on("dfp_appid", "app_id").select(new String[]{"dfp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForDisFun).on("dfp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id"}).finish();){
            while (finalDS.hasNext()) {
                Row data = finalDS.next();
                String cloudId = data.getString("cloudl_id");
                String appId = data.getString("app_id");
                String entityNum = data.getString("entd_num");
                allRelMap.computeIfPresent(cloudId, (cloudKey, appValue) -> {
                    appValue.computeIfPresent(appId, (appKey, entityValue) -> {
                        entityValue.remove(entityNum);
                        if (entityValue.size() == 0) {
                            return null;
                        }
                        return entityValue;
                    });
                    if (appValue.size() == 0) {
                        return null;
                    }
                    return appValue;
                });
            }
        }
    }

    private static void getUsableEntInfoByUsrGrpBusiRoleForbid(DataSet usrGrpBusiRoleForbidDS, Map<String, Map<String, Set<String>>> allRelMap, DataSet cloudAppDSForBizRoleDisPerm, DataSet entityDSForBizRoleDisPerm) {
        if (null == usrGrpBusiRoleForbidDS) {
            return;
        }
        try (DataSet tempDS = usrGrpBusiRoleForbidDS.join(cloudAppDSForBizRoleDisPerm).on("pbdp_appid", "app_id").select(new String[]{"pbdp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForBizRoleDisPerm).on("pbdp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id"}).finish();){
            while (finalDS.hasNext()) {
                Row data = finalDS.next();
                String cloudId = data.getString("cloudl_id");
                String appId = data.getString("app_id");
                String entityNum = data.getString("entd_num");
                allRelMap.computeIfPresent(cloudId, (cloudKey, appValue) -> {
                    appValue.computeIfPresent(appId, (appKey, entityValue) -> {
                        entityValue.remove(entityNum);
                        if (entityValue.size() == 0) {
                            return null;
                        }
                        return entityValue;
                    });
                    if (appValue.size() == 0) {
                        return null;
                    }
                    return appValue;
                });
            }
        }
    }

    private static void getUsableEntInfoByBusiRoleForbid(DataSet busiRoleForbidDS, Map<String, Map<String, Set<String>>> allRelMap, DataSet cloudAppDSForBizRoleDisPerm, DataSet entityDSForBizRoleDisPerm) {
        if (null == busiRoleForbidDS) {
            return;
        }
        try (DataSet tempDS = busiRoleForbidDS.join(cloudAppDSForBizRoleDisPerm).on("pbdp_appid", "app_id").select(new String[]{"pbdp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForBizRoleDisPerm).on("pbdp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id"}).finish();){
            while (finalDS.hasNext()) {
                Row data = finalDS.next();
                String cloudId = data.getString("cloudl_id");
                String appId = data.getString("app_id");
                String entityNum = data.getString("entd_num");
                allRelMap.computeIfPresent(cloudId, (cloudKey, appValue) -> {
                    appValue.computeIfPresent(appId, (appKey, entityValue) -> {
                        entityValue.remove(entityNum);
                        if (entityValue.size() == 0) {
                            return null;
                        }
                        return entityValue;
                    });
                    if (appValue.size() == 0) {
                        return null;
                    }
                    return appValue;
                });
            }
        }
    }

    private static void getUsableEntInfoByUsrGrpBusiRoleBc(DataSet usrGrpBusiRoleBcDS, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet cloudAppDSForBizRolePerm, DataSet entityDSForBizRolePerm) {
        if (null == usrGrpBusiRoleBcDS) {
            return;
        }
        try (DataSet tempDS = usrGrpBusiRoleBcDS.join(cloudAppDSForBizRolePerm).on("pbp_appid", "app_id").select(new String[]{"pbp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForBizRolePerm).on("pbp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoByBusiRoleBc(DataSet busiRoleBcDS, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet cloudAppDSForBizRolePerm, DataSet entityDSForBizRolePerm) {
        if (null == busiRoleBcDS) {
            return;
        }
        try (DataSet tempDS = busiRoleBcDS.join(cloudAppDSForBizRolePerm).on("pbp_appid", "app_id").select(new String[]{"pbp_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForBizRolePerm).on("pbp_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoByBusiRoleCommrole(DataSet busiRoleComRoleDS, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet cloudAppDSForBizComRolePerm, DataSet entityDSForBizComRolePerm) {
        if (null == busiRoleComRoleDS) {
            return;
        }
        try (DataSet tempDS = busiRoleComRoleDS.join(cloudAppDSForBizComRolePerm).on("rolepd_appid", "app_id").select(new String[]{"rolepd_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForBizComRolePerm).on("rolepd_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private static void getUsableEntInfoByCommrole(DataSet comRoleDS, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet cloudAppDSForComRole, DataSet entityDSForComRole) {
        if (null == comRoleDS) {
            return;
        }
        try (DataSet tempDS = comRoleDS.join(cloudAppDSForComRole).on("rolepd_appid", "app_id").select(new String[]{"rolepd_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish().distinct();
             DataSet finalDS = tempDS.join(entityDSForComRole).on("rolepd_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish().distinct();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoByUsrGrpCommrole(DataSet usrGrpComRoleDS, Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, DataSet cloudAppDSForComRole, DataSet entityDSForComRole) {
        if (null == usrGrpComRoleDS) {
            return;
        }
        try (DataSet tempDS = usrGrpComRoleDS.join(cloudAppDSForComRole).on("rolepd_appid", "app_id").select(new String[]{"rolepd_entnum"}, new String[]{"cloudl_id", "cloudl_name", "app_id", "app_num", "app_name"}).finish();
             DataSet finalDS = tempDS.join(entityDSForComRole).on("rolepd_entnum", "entd_num").select(new String[]{"cloudl_id", "cloudl_name", "app_id", "app_name"}, new String[]{"entd_num", "entd_id", "entd_name"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                FunctionPermission.getUsableEntInfoWrapResult(entityNumIdMap, allRelMap, cloudMap, appMap, entityMap, row);
            }
        }
    }

    private static void getUsableEntInfoWrapResult(Map<String, String> entityNumIdMap, Map<String, Map<String, Set<String>>> allRelMap, Map<String, String> cloudMap, Map<String, String> appMap, Map<String, String> entityMap, Row row) {
        String entityNameFromMap;
        String cloudId = row.getString("cloudl_id");
        String cloudName = row.getString("cloudl_name");
        String appId = row.getString("app_id");
        String appName = row.getString("app_name");
        String entityId = row.getString("entd_id");
        String entityNum = row.getString("entd_num");
        String entityName = row.getString("entd_name");
        String appNameFromMap = appMap.get(appId);
        if (StringUtils.isEmpty((String)appNameFromMap)) {
            String appRuntimeName = FunctionPermission.getAppName(appId);
            if (StringUtils.isNotEmpty((String)appRuntimeName)) {
                appName = appRuntimeName;
            }
            appMap.put(appId, appName);
        }
        if (StringUtils.isEmpty((String)(entityNameFromMap = entityMap.get(entityNum)))) {
            String entityRuntimeName = FunctionPermission.getRuntimeFormName(entityNum);
            if (StringUtils.isNotEmpty((String)entityRuntimeName)) {
                entityName = entityRuntimeName;
            }
            entityMap.put(entityNum, entityName);
        }
        cloudMap.put(cloudId, cloudName);
        entityNumIdMap.put(entityNum, entityId);
        allRelMap.computeIfAbsent(cloudId, k -> new HashMap()).computeIfAbsent(appId, k -> new HashSet()).add(entityNum);
    }

    public static HasPermDimObjResult getAllPermDimObjs(long userId, String dimType, String orgView, String checkPermAppId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getAllHasPermDimObjs((Long)userId, (String)dimType, (String)orgView, (String)checkPermAppId, (String)entityNum, (String)permItemId);
    }

    @Deprecated
    public static List<FuncPermItem> getAllFuncPermItemList() {
        return new ArrayList<FuncPermItem>(0);
    }

    private static /* synthetic */ Set lambda$getAdminUsableEntitiesInfo$6(String k) {
        return new HashSet();
    }

    private static /* synthetic */ Map lambda$getAdminUsableEntitiesInfo$5(String k) {
        return new HashMap();
    }

    private static /* synthetic */ Set lambda$getSuperUserUsableEntitiesInfo$2(String k) {
        return new HashSet();
    }

    private static /* synthetic */ Map lambda$getSuperUserUsableEntitiesInfo$1(String k) {
        return new HashMap();
    }
}

