/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.imp.UserBusiRoleImportBean;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.PermCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserBusiRoleAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserBusiRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.userbusirole.GetUserBusiRoleReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.model.perm.userbusirole.UserBusiRole;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class UserBusiRoleService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UserBusiRoleService.class);

    public static Map<String, UserBusiRole> getUserBusiRoleMap(GetUserBusiRoleReq req) {
        HashMap<String, UserBusiRole> map = new HashMap<String, UserBusiRole>(8);
        List<QFilter> filterList = UserBusiRoleService.getFilter(req);
        Integer returnType = req.getReturnType();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserBusiRoleService.getUserBusiRoleMap", (String)"perm_userbizrole", (String)"id, bizrole, bizrole.number, user, user.number, starttime, endtime", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            StringBuilder sb = null;
            UserBusiRole one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UserBusiRole();
                Long userId = row.getLong("user");
                String bizroleId = row.getString("bizrole");
                one.setId(row.getString("id"));
                one.setUserId(userId);
                one.setBusiRoleId(bizroleId);
                one.setStartTime(row.getDate("starttime"));
                one.setEndTime(row.getDate("endtime"));
                if (Objects.equals(1, returnType)) {
                    sb = new StringBuilder().append(userId).append("|").append(bizroleId);
                    map.put(sb.toString(), one);
                    continue;
                }
                if (!Objects.equals(2, returnType)) continue;
                map.put(row.getString("id"), one);
            }
        }
        return map;
    }

    private static List<QFilter> getFilter(GetUserBusiRoleReq req) {
        Map roleNumberBusiRoleMap;
        Set collect;
        Set busiRoleNumberSet;
        Set busiRoleIdSet;
        Map userMap;
        Set collect2;
        Set userNumberSet;
        Set userIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userNumberSet = req.getUserNumberSet())) && !CollectionUtils.isEmpty(collect2 = (userMap = UserHelper.getUserMap((Set)userNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(busiRoleIdSet = req.getBusiRoleIdSet()))) {
            filterList.add(new QFilter("bizrole", "in", busiRoleIdSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(busiRoleNumberSet = req.getBusiRoleNumberSet())) && !CollectionUtils.isEmpty(collect = (roleNumberBusiRoleMap = PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)busiRoleNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(BusiRole::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("bizrole", "in", collect));
        }
        return filterList;
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        List needCheckBeanList = req.getNeedCheckBeanList();
        if (CollectionUtils.isEmpty((Collection)needCheckBeanList)) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, UserBusiRoleImportBean> passedMap = new HashMap<Integer, UserBusiRoleImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        OperationTypeEnum operationTypeEnum = null;
        EnumsImportType enumsImportType = req.getEnumsImportType();
        if (EnumsImportType.NEW != enumsImportType) {
            throw new KDBizException("unsurpport importType.");
        }
        operationTypeEnum = OperationTypeEnum.ADD;
        for (UserBusiRoleImportBean willSaveBean : needCheckBeanList) {
            if (null == willSaveBean) continue;
            willSaveBean.setOperationTypeEnum(operationTypeEnum);
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        super.beforeSaveCheckExt(req);
        return new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, UserBusiRoleImportBean willSaveBean, Map<Integer, UserBusiRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, UserBusiRoleImportBean willSaveBean, Map<Integer, UserBusiRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean enableValidateTime;
        Set userSet;
        PermUser permUser;
        Map userNumExistMap;
        Map busiRoleNumBusiRoleMap;
        Set busiRoleSet;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int lineNum = willSaveBean.getLineNum();
        String busiRoleNum = willSaveBean.getBusiRoleNum();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        long currUserId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)busiRoleNum) && (null == (busiRoleSet = (Set)(busiRoleNumBusiRoleMap = null == checkNeedParamMap.get("busiRoleNumBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{busiRoleNum}), (String)"number") : (Map)checkNeedParamMap.get("busiRoleNumBusiRoleMap")).get(busiRoleNum)) || busiRoleSet.isEmpty())) {
            this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_19", (String)"bos-mservice-permission", (Object[])new Object[0]), busiRoleNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String userNumber = willSaveBean.getUserNumber();
        Map map = userNumExistMap = null == checkNeedParamMap.get("userNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_user", (Set)Sets.newHashSet((Object[])new String[]{userNumber})) : (Map)checkNeedParamMap.get("userNumExistMap");
        if (null == userNumExistMap.get(userNumber) || !((Boolean)userNumExistMap.get(userNumber)).booleanValue()) {
            this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermUserResp hasPermUser = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermUserMap")) {
            hasPermUser = PermCtrlTypeService.getAdminHasPermUser(new GetHasPermUserReq("bos_org", Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{userNumber})));
        } else {
            Map dimTypeAdminHasPermUserMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermUserMap");
            GetHasPermUserResp getHasPermUserResp = hasPermUser = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermUserMap) ? null : (GetHasPermUserResp)dimTypeAdminHasPermUserMap.get("bos_org");
        }
        if (null != hasPermUser && !hasPermUser.isHasAllUser() && null == (permUser = (PermUser)(userSet = hasPermUser.getUserSet()).stream().filter(x -> Objects.equals(userNumber, x.getUserNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u8303\u56f4\u5185\u6216\u4f8b\u5916\u4eba\u5458\u8303\u56f4\u5185\u3002", (String)"UserRoleService_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map<String, UserBusiRole> userBusiRoleMap = null;
        userBusiRoleMap = null == checkNeedParamMap.get("userRoleDimMap") ? UserBusiRoleService.getUserBusiRoleMap(new GetUserBusiRoleReq(Integer.valueOf(1), null, null, (Set)Sets.newHashSet((Object[])new String[]{userNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{busiRoleNum}))) : (Map<String, UserBusiRole>)checkNeedParamMap.get("userBusiRoleMap");
        if (StringUtils.isNotEmpty((String)userNumber) && StringUtils.isNotEmpty((String)busiRoleNum)) {
            Map userNumMap = null == checkNeedParamMap.get("userNumMap") ? UserHelper.getUserMap((Set)Sets.newHashSet((Object[])new String[]{userNumber}), (String)"number") : (Map)checkNeedParamMap.get("userNumMap");
            Set users = (Set)userNumMap.get(userNumber);
            Map busiRoleNumBusiRoleMap2 = null == checkNeedParamMap.get("busiRoleNumBusiRoleMap") ? PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap((Set)Sets.newHashSet((Object[])new String[]{busiRoleNum}), (String)"number") : (Map)checkNeedParamMap.get("busiRoleNumBusiRoleMap");
            Set busiRoles = (Set)busiRoleNumBusiRoleMap2.get(busiRoleNum);
            if (!CollectionUtils.isEmpty((Collection)users) && !CollectionUtils.isEmpty((Collection)busiRoles)) {
                for (User user : users) {
                    for (BusiRole busiRole : busiRoles) {
                        if (!userBusiRoleMap.containsKey(user.getFid() + "|" + busiRole.getId())) continue;
                        this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"UserRoleService_18", (String)"bos-mservice-permission", (Object[])new Object[0]));
                        checkResult = false;
                        if (!failFast) continue;
                        return checkResult;
                    }
                }
            }
        }
        boolean bl = enableValidateTime = null == checkNeedParamMap.get("enableValidateTime") ? PermCommonUtil.isEnableValidateTime() : (Boolean)checkNeedParamMap.get("enableValidateTime");
        if (enableValidateTime) {
            Date endTime;
            Date startTime = willSaveBean.getStartTime();
            List list = PermCommonUtil.checkValidateTime((Date)startTime, (Date)(endTime = willSaveBean.getEndTime()), (Map)checkNeedParamMap);
            if (null != list && !list.isEmpty()) {
                for (String dataValidStr : list) {
                    this.wrapFaildMsg(lineNum, busiRoleNum, failedErrorMap, numFailedErrorMap, dataValidStr);
                    checkResult = false;
                    if (!failFast) continue;
                    return checkResult;
                }
            }
        } else {
            willSaveBean.setStartTime(null);
            willSaveBean.setEndTime(null);
        }
        if (checkResult) {
            passedMap.put(lineNum, willSaveBean);
        }
        return checkResult;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            UserBusiRoleAfterSaveReq req = (UserBusiRoleAfterSaveReq)reqOri;
            Set userBizRoleIdSet = req.getMainIdSet();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])userBizRoleIdSet.stream().map(x -> Long.valueOf(x)).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_userbizrole"));
            if (null == dynamicObjects || Objects.equals(0, dynamicObjects.length)) {
                return PermResult.ok();
            }
            HashMap<String, Set<Long>> addBusiRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
            HashSet<String> addBusiRoleIds = new HashSet<String>(8);
            ArrayList<UserBusiRole> addList = new ArrayList<UserBusiRole>(10);
            UserBusiRole userBusiRole = null;
            for (DynamicObject one : dynamicObjects) {
                if (null == one) continue;
                String bizRoleId = one.getString("bizrole_id");
                Long userId = one.getLong("user_id");
                String startTimeStr = one.getString("starttime");
                String endTimeStr = one.getString("endtime");
                Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate((String)startTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                Date endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                userBusiRole = new UserBusiRole();
                userBusiRole.setUserId(userId);
                userBusiRole.setBusiRoleId(bizRoleId);
                userBusiRole.setStartTime(startTime);
                userBusiRole.setEndTime(endTime);
                userBusiRole.setFromTypeDesc(one.getString("fromtypedesc"));
                addBusiRoleIdUserIdsMap.computeIfAbsent(bizRoleId, k -> new HashSet(8)).add(userId);
                addBusiRoleIds.add(bizRoleId);
                addList.add(userBusiRole);
            }
            PermResult permResult = UserBusiRoleService.userBusiRoleRelateChangeBusi(addBusiRoleIdUserIdsMap, null, addBusiRoleIds, null);
            UserBusiRoleService.userBusiRole2PermLog(addList, null, null, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            super.afterMainEntitySaveExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserBusiRoleService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public PermCheckResp beforeDelCheck(PermCheckReq req) {
        PermCheckResp permCheckResp = super.beforeDelCheck(req);
        super.beforeDelCheckExt(req);
        return permCheckResp;
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            UserBusiRoleAfterDelReq req = (UserBusiRoleAfterDelReq)reqOri;
            Map delUserBusiRoleMap = req.getDelUserBusiRoleMap();
            if (!CollectionUtils.isEmpty((Map)delUserBusiRoleMap)) {
                ArrayList<UserBusiRole> delList = new ArrayList<UserBusiRole>(10);
                HashMap<String, Set<Long>> delBusiRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
                HashSet<String> delBusiRoleIds = new HashSet<String>(8);
                for (Map.Entry delUserBusiRole : delUserBusiRoleMap.entrySet()) {
                    UserBusiRole value = (UserBusiRole)delUserBusiRole.getValue();
                    if (null == value) continue;
                    delBusiRoleIdUserIdsMap.computeIfAbsent(value.getBusiRoleId(), k -> new HashSet(8)).add(value.getUserId());
                    delBusiRoleIds.add(value.getBusiRoleId());
                    delList.add(value);
                }
                PermResult permResult = UserBusiRoleService.userBusiRoleRelateChangeBusi(null, delBusiRoleIdUserIdsMap, null, delBusiRoleIds);
                UserBusiRoleService.userBusiRole2PermLog(null, null, delList, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            }
            super.afterDelExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserBusiRoleService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static PermResult userBusiRoleRelateChangeBusi(Map<String, Set<Long>> addBusiRoleIdUserIdsMap, Map<String, Set<Long>> delBusiRoleIdUserIdsMap, Set<String> addBusRoleIds, Set<String> delBusiRoleIds) {
        try {
            addBusiRoleIdUserIdsMap = null == addBusiRoleIdUserIdsMap ? new HashMap(1) : addBusiRoleIdUserIdsMap;
            delBusiRoleIdUserIdsMap = null == delBusiRoleIdUserIdsMap ? new HashMap(1) : delBusiRoleIdUserIdsMap;
            addBusRoleIds = null == addBusRoleIds ? new HashSet(1) : addBusRoleIds;
            delBusiRoleIds = null == delBusiRoleIds ? new HashSet(1) : delBusiRoleIds;
            Map busiRoleIdAppEntSetMap = PermBusiRoleHelper.getAppEntityByBizRole(addBusRoleIds, (String)"id");
            for (Map.Entry entry : addBusiRoleIdUserIdsMap.entrySet()) {
                Map appEntityMap;
                String busiRoleId = (String)entry.getKey();
                Set userIds = (Set)entry.getValue();
                if (StringUtils.isEmpty((String)busiRoleId) || null == userIds || userIds.isEmpty() || null == (appEntityMap = (Map)busiRoleIdAppEntSetMap.get(busiRoleId)) || appEntityMap.isEmpty()) continue;
                LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(userIds), (Map)appEntityMap);
            }
            if (null != addBusiRoleIdUserIdsMap && !addBusiRoleIdUserIdsMap.isEmpty() || null != delBusiRoleIdUserIdsMap && !delBusiRoleIdUserIdsMap.isEmpty() || null != addBusRoleIds && !addBusRoleIds.isEmpty() || null != delBusiRoleIds && !delBusiRoleIds.isEmpty()) {
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
            }
            HashMap<String, Set> allBizRoleIdUserIdsMap = new HashMap<String, Set>(8);
            for (Map.Entry one : addBusiRoleIdUserIdsMap.entrySet()) {
                allBizRoleIdUserIdsMap.computeIfAbsent((String)one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
            }
            for (Map.Entry one : delBusiRoleIdUserIdsMap.entrySet()) {
                allBizRoleIdUserIdsMap.computeIfAbsent((String)one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
            }
            String string = RequestContext.get().getLang().toString();
            addBusRoleIds.addAll(delBusiRoleIds);
            HashMap<String, Set> bizRoleIdAppEntitySetMap = new HashMap<String, Set>(8);
            Map comRoleSetMap = PermBusiRoleHelper.getComRoleSetMap(addBusRoleIds, (String)"id");
            for (Map.Entry comRoleSet : comRoleSetMap.entrySet()) {
                String busiRoleId = (String)comRoleSet.getKey();
                Set value = (Set)comRoleSet.getValue();
                if (null == value || value.isEmpty()) continue;
                for (BusiRoleComRole busiRoleComRole : value) {
                    LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)busiRoleComRole.getComRoleId(), (String)string);
                    Set newDRAppEntitySet = null == newDataRule ? new HashSet(0) : newDataRule.getNewDRAppEntitySet();
                    bizRoleIdAppEntitySetMap.computeIfAbsent(busiRoleId, k -> new HashSet(8)).addAll(newDRAppEntitySet);
                }
            }
            for (String bizRoleId : addBusRoleIds) {
                Set appEntityAllSet = null == bizRoleIdAppEntitySetMap.get(bizRoleId) ? new HashSet(0) : (Set)bizRoleIdAppEntitySetMap.get(bizRoleId);
                List appEntityAllList = appEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
                Set userIdSet = (Set)allBizRoleIdUserIdsMap.get(bizRoleId);
                PermCommonUtil.cancelShowForm(new ArrayList(userIdSet), appEntityAllList, (boolean)false);
            }
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserBusiRoleService.userBusiRoleRelateChangeBusi error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    private static void userBusiRole2PermLog(List<UserBusiRole> addList, List<UserBusiRole> updateList, List<UserBusiRole> delList, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            permLogReq.check(false);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            diffMap.put("add", null == addList ? new ArrayList(0) : addList);
            diffMap.put("update", null == updateList ? new ArrayList(0) : updateList);
            diffMap.put("del", null == delList ? new ArrayList(0) : delList);
            String formNum = permLogReq.getFormIdentity();
            String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : permLogReq.getAppId();
            String cloudId = StringUtils.isEmpty((String)permLogReq.getCloudId()) ? AppHelper.getMetaAppInfo((String)appId).getCloudId() : permLogReq.getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserBusiRoleService.userBusiRole2PermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UserBusiRoleService.userBusiRole2PermLog error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }
}

