/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.model.LogDimDis;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.imp.UserDisPermImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.PermCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserDirectDisPermAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserDirectDisPermAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.req.user.GetUserDisFuncDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class UserDisPermService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UserDisPermService.class);

    public static Map<String, UserFuncDim> getUserFuncDimMap(GetUserDisFuncDimReq req) {
        HashMap<String, UserFuncDim> map = new HashMap<String, UserFuncDim>(8);
        List<QFilter> filterList = UserDisPermService.getFilter(req);
        Integer returnType = req.getReturnType();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserDisPermService.getUserFuncDimMap", (String)"perm_direct_disperm", (String)"id, user, bizapp, entitytype, permitem, dimtype, dimid, includesub", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            StringBuilder sb = null;
            UserFuncDim one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UserFuncDim();
                Long userId = row.getLong("user");
                String appId = row.getString("bizapp");
                String entNum = row.getString("entitytype");
                String permitemId = row.getString("permitem");
                String dimType = row.getString("dimtype");
                Long dimId = row.getLong("dimid");
                one.setId(row.getString("id"));
                one.setUserId(userId);
                one.setAppId(appId);
                one.setEntityNumber(entNum);
                one.setPermItemId(permitemId);
                one.setDimType(dimType);
                one.setDimId(dimId);
                one.setIncludeSub(row.getBoolean("includesub"));
                if (Objects.equals(1, returnType)) {
                    sb = new StringBuilder().append(userId).append("|").append(appId).append("|").append(entNum).append("|").append(permitemId).append("|").append(dimType).append("|").append(dimId);
                    map.put(sb.toString(), one);
                    continue;
                }
                if (!Objects.equals(2, returnType)) continue;
                map.put(row.getString("id"), one);
            }
        }
        return map;
    }

    public static Set<String> getDimTypeSet(GetUserDisFuncDimReq req) {
        HashSet<String> result = new HashSet<String>(8);
        List<QFilter> filterList = UserDisPermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserDisPermService.getUserFuncDimMap", (String)"perm_direct_disperm", (String)"dimtype", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.add(row.getString("dimtype"));
            }
        }
        return result;
    }

    private static List<QFilter> getFilter(GetUserDisFuncDimReq req) {
        Map dimTypeDimNumSetMap;
        Set dimIdSet;
        Set dimTypeSet;
        Map permItemMap;
        Set collect;
        Set permItemNumSet;
        Set permItemIdSet;
        Set entNumSet;
        Map appMap;
        Set collect2;
        Set appNumSet;
        Set appIdSet;
        Map userMap;
        Set collect3;
        Set userNumberSet;
        Set userIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", (Object)mainIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userNumberSet = req.getUserNumberSet())) && !CollectionUtils.isEmpty(collect3 = (userMap = UserHelper.getUserMap((Set)userNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect3));
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdSet = req.getAppIdSet()))) {
            filterList.add(new QFilter("bizapp", "in", (Object)appIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(appNumSet = req.getAppNumSet())) && !CollectionUtils.isEmpty(collect2 = (appMap = AppHelper.getAppMap((Set)appNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(App::getAppId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("bizapp", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(entNumSet = req.getEntNumSet()))) {
            filterList.add(new QFilter("entitytype", "in", (Object)entNumSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemIdSet = req.getPermItemIdSet()))) {
            filterList.add(new QFilter("permitem", "in", (Object)permItemIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemNumSet = req.getPermItemNumSet())) && !CollectionUtils.isEmpty(collect = (permItemMap = PermItemHelper.getPermItemMap((Set)permItemNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(PermItem::getPermItemId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("permitem", "in", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimTypeSet = req.getDimTypeSet()))) {
            filterList.add(new QFilter("dimtype", "in", (Object)dimTypeSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimIdSet = req.getDimIdSet()))) {
            filterList.add(new QFilter("dimid", "in", (Object)dimIdSet));
        }
        if (null != (dimTypeDimNumSetMap = req.getDimTypeDimNumSetMap()) && !dimTypeDimNumSetMap.isEmpty()) {
            HashSet<String> innerDimTypeSet = new HashSet<String>(8);
            HashSet innerDimIdSet = new HashSet(8);
            for (Map.Entry dimTypeDimNumSet : dimTypeDimNumSetMap.entrySet()) {
                String dimType = (String)dimTypeDimNumSet.getKey();
                Set dimNumberSet = (Set)dimTypeDimNumSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty((Collection)dimNumberSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumberSet, (String)"number", (String)dimType);
                Set collect4 = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                innerDimTypeSet.add(dimType);
                innerDimIdSet.addAll(collect4);
            }
            if (!CollectionUtils.isEmpty(innerDimTypeSet)) {
                filterList.add(new QFilter("dimtype", "in", innerDimTypeSet));
            }
            if (!CollectionUtils.isEmpty(innerDimIdSet)) {
                filterList.add(new QFilter("dimid", "in", innerDimIdSet));
            }
        }
        return filterList;
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        List needCheckBeanList = req.getNeedCheckBeanList();
        if (CollectionUtils.isEmpty((Collection)needCheckBeanList)) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, UserDisPermImportBean> passedMap = new HashMap<Integer, UserDisPermImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        OperationTypeEnum operationTypeEnum = null;
        EnumsImportType enumsImportType = req.getEnumsImportType();
        if (EnumsImportType.NEW != enumsImportType) {
            throw new KDBizException("unsurpport importType.");
        }
        operationTypeEnum = OperationTypeEnum.ADD;
        for (UserDisPermImportBean willSaveBean : needCheckBeanList) {
            if (null == willSaveBean) continue;
            willSaveBean.setOperationTypeEnum(operationTypeEnum);
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        PermCheckResp permCheckResp = new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
        super.beforeSaveCheckExt(req);
        return permCheckResp;
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, UserDisPermImportBean willSaveBean, Map<Integer, UserDisPermImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, UserDisPermImportBean willSaveBean, Map<Integer, UserDisPermImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        Set entNumSet;
        Set adminChargeAppSet;
        Boolean includeSub;
        Set hasPermDimSet;
        Dim dim;
        Map dimNumExistMap;
        Map dimTypeAdminHasPermPermCtrlObjMap;
        String dimNum;
        Set userSet;
        PermUser permUser;
        Map userNumExistMap;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int lineNum = willSaveBean.getLineNum();
        String busiUniqueStr = "";
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        long currUserId = RequestContext.get().getCurrUserId();
        String userNumber = willSaveBean.getUserNumber();
        if (StringUtils.isEmpty((String)userNumber.trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u7528\u6237\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_22", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map map = userNumExistMap = null == checkNeedParamMap.get("userNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_user", (Set)Sets.newHashSet((Object[])new String[]{userNumber})) : (Map)checkNeedParamMap.get("userNumExistMap");
        if (null == userNumExistMap.get(userNumber) || !((Boolean)userNumExistMap.get(userNumber)).booleanValue()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String dimType = willSaveBean.getDimType();
        GetHasPermUserResp hasPermUser = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermUserMap")) {
            hasPermUser = PermCtrlTypeService.getAdminHasPermUser(new GetHasPermUserReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{userNumber})));
        } else {
            Map dimTypeAdminHasPermUserMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermUserMap");
            GetHasPermUserResp getHasPermUserResp = hasPermUser = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermUserMap) ? null : (GetHasPermUserResp)dimTypeAdminHasPermUserMap.get(dimType);
        }
        if (null != hasPermUser && !hasPermUser.isHasAllUser() && null == (permUser = (PermUser)(userSet = hasPermUser.getUserSet()).stream().filter(x -> Objects.equals(userNumber, x.getUserNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u8303\u56f4\u5185\u6216\u4f8b\u5916\u4eba\u5458\u8303\u56f4\u5185\u3002", (String)"UserRoleService_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(dimNum = willSaveBean.getDimNum()).trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_21", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermPermCtrlObjResp hasPermDimResult = null;
        hasPermDimResult = null == checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap") ? PermCtrlTypeService.getAdminHasPermPermCtrlObj(new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{dimNum}))) : (CollectionUtils.isEmpty((Map)(dimTypeAdminHasPermPermCtrlObjMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap"))) ? null : (GetHasPermPermCtrlObjResp)dimTypeAdminHasPermPermCtrlObjMap.get(dimType));
        String dimTypeNumBig = willSaveBean.getDimTypeBig();
        if (StringUtils.isNotEmpty((String)dimTypeNumBig)) {
            Map bigPermCtrlTypeMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            PermCtrlType bigPermCtrlType = (PermCtrlType)bigPermCtrlTypeMap.get(dimTypeNumBig);
            if (null == bigPermCtrlType) {
                this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNumBig));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        } else if (StringUtils.isEmpty((String)dimTypeNumBig.trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_20", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        HashMap<String, Map> dimTypeDimNumExistMap = null;
        if (null == checkNeedParamMap.get("dimTypeDimNumExistMap")) {
            dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimType, (Set)Sets.newHashSet((Object[])new String[]{dimNum}));
            dimTypeDimNumExistMap = new HashMap<String, Map>(8);
            dimTypeDimNumExistMap.put(dimType, dimNumExistMap);
        } else {
            dimTypeDimNumExistMap = (HashMap<String, Map>)checkNeedParamMap.get("dimTypeDimNumExistMap");
        }
        if (!(CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType))) || null != (dimNumExistMap = (Map)dimTypeDimNumExistMap.get(dimType)).get(dimNum) && ((Boolean)dimNumExistMap.get(dimNum)).booleanValue())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType)))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null != hasPermDimResult && !hasPermDimResult.isHasAllDimPerm() && null == (dim = (Dim)(hasPermDimSet = hasPermDimResult.getHasPermDimSet()).stream().filter(x -> Objects.equals(dimNum, x.getDimNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)dimType) && null == hasPermDimResult) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null == (includeSub = willSaveBean.getIncludeSub())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u662f\u6216\u5426\u3002", (String)"UserRoleService_17", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String appNumber = willSaveBean.getAppNumber();
        Map appMap = null == checkNeedParamMap.get("appMap") ? AppHelper.getAppMap((Set)Sets.newHashSet((Object[])new String[]{appNumber}), (String)"number") : (Map)checkNeedParamMap.get("appMap");
        String entityNumber = willSaveBean.getEntityNumber();
        Map entMap = null == checkNeedParamMap.get("entMap") ? FormHelper.getEntMap((Set)Sets.newHashSet((Object[])new String[]{entityNumber}), (String)"number") : (Map)checkNeedParamMap.get("entMap");
        String permItemNumber = willSaveBean.getPermItemNumber();
        Map permItemMap = null == checkNeedParamMap.get("permItemMap") ? PermItemHelper.getPermItemMap((Set)Sets.newHashSet((Object[])new String[]{permItemNumber}), (String)"number") : (Map)checkNeedParamMap.get("permItemMap");
        String permItemId = willSaveBean.getPermItemId();
        Map permItemExistMap = null == checkNeedParamMap.get("permItemExistMap") ? PermItemHelper.getPermItemMap((Set)Sets.newHashSet((Object[])new String[]{permItemId})) : (Map)checkNeedParamMap.get("permItemExistMap");
        HashSet plainPermItemSet = null;
        HashMap<String, Set> appNumEntNumSetMap = null;
        HashMap<String, Set> entNumPermItemNumSetMap = null;
        if (null == checkNeedParamMap.get("plainPermItemSet")) {
            GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
            getPlainPermItemListReq.setDimType("DIM_ORG");
            getPlainPermItemListReq.setReturnByField(true);
            getPlainPermItemListReq.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
            List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
            plainPermItemSet = new HashSet(plainPermItemList);
            appNumEntNumSetMap = new HashMap<String, Set>(8);
            entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
        } else {
            plainPermItemSet = (HashSet)checkNeedParamMap.get("plainPermItemSet");
            appNumEntNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("appNumEntNumSetMap");
            entNumPermItemNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("entNumPermItemNumSetMap");
        }
        if (null == appMap || null == appMap.get(appNumber) || ((Set)appMap.get(appNumber)).isEmpty()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        AppInfo appInfo = null;
        appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)appNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(appNumber);
        Set set = adminChargeAppSet = null == checkNeedParamMap.get("adminChargeAppSet") ? new HashSet(AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)) : (Set)checkNeedParamMap.get("adminChargeAppSet");
        if (null == appInfo || !adminChargeAppSet.contains(appInfo.getId())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleService_49", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null == entMap || null == entMap.get(entityNumber) || ((Set)entMap.get(entityNumber)).isEmpty()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_45", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)dimTypeNumBig)) {
            String formPermCtrlType = "";
            if (null == checkNeedParamMap.get("formCtrlTypeMap")) {
                PermissionControlType permissionControlType = FormHelper.getPermissionControlType((String)entityNumber);
                boolean controlFunction = permissionControlType.isControlFunction();
                boolean emptyObject = permissionControlType.isEmptyObject();
                String dimension = permissionControlType.getDimension();
                if (controlFunction && !emptyObject && StringUtils.isNotEmpty((String)dimension)) {
                    formPermCtrlType = dimension;
                }
            } else {
                Map formCtrlTypeMap = (Map)checkNeedParamMap.get("formCtrlTypeMap");
                formPermCtrlType = (String)formCtrlTypeMap.get(entityNumber);
            }
            if (StringUtils.isNotEmpty((String)formPermCtrlType) && !Objects.equals("DIM_NULL", formPermCtrlType) && !Objects.equals(dimTypeNumBig, formPermCtrlType)) {
                this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u201d%1$s\u201c\u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d%2$s\u201c\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u5e94\u8be5\u662f\u201d%3$s\u201c\u3002", (String)"UserDirectPermService_7", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber, dimTypeNumBig, formPermCtrlType));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        }
        if (null != (entNumSet = (Set)appNumEntNumSetMap.get(appNumber)) && !entNumSet.contains(entityNumber)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_47", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber, entityNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)permItemNumber) && (null == permItemMap || null == permItemMap.get(permItemNumber) || ((Set)permItemMap.get(permItemNumber)).isEmpty())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_46", (String)"bos-mservice-permission", (Object[])new Object[0]), permItemNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Set permItemSet = (Set)entNumPermItemNumSetMap.get(entityNumber);
        if (StringUtils.isNotEmpty((String)permItemNumber) && null != permItemSet && !permItemSet.contains(permItemNumber)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_48", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber, permItemNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)permItemId) && null == permItemExistMap.get(permItemId)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879id\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_59", (String)"bos-mservice-permission", (Object[])new Object[0]), permItemId));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map<String, UserFuncDim> userDisFuncDimMap = null;
        if (null == checkNeedParamMap.get("userDisFuncDimMap")) {
            HashMap<String, HashSet> dimTypeDimNumSetMap = new HashMap<String, HashSet>(8);
            dimTypeDimNumSetMap.put(dimType, Sets.newHashSet((Object[])new String[]{dimNum}));
            userDisFuncDimMap = UserDisPermService.getUserFuncDimMap(new GetUserDisFuncDimReq(Integer.valueOf(1), null, null, (Set)Sets.newHashSet((Object[])new String[]{userNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{appNumber}), (Set)Sets.newHashSet((Object[])new String[]{entityNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{permItemNumber}), null, null, dimTypeDimNumSetMap));
        } else {
            userDisFuncDimMap = (Map<String, UserFuncDim>)checkNeedParamMap.get("userDisFuncDimMap");
        }
        if (StringUtils.isNotEmpty((String)userNumber)) {
            HashSet dimIdSet;
            Map userNumMap = null == checkNeedParamMap.get("userNumMap") ? UserHelper.getUserMap((Set)Sets.newHashSet((Object[])new String[]{userNumber}), (String)"number") : (Map)checkNeedParamMap.get("userNumMap");
            Set users = (Set)userNumMap.get(userNumber);
            Map<String, Map> dimTypeDimNumDimMap = null;
            if (null == checkNeedParamMap.get("dimTypeDimNumDimMap")) {
                dimTypeDimNumDimMap = new HashMap(8);
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)Sets.newHashSet((Object[])new String[]{dimNum}), (String)"number", (String)dimType);
                dimTypeDimNumDimMap.put(dimType, dimNumDimSetMap);
            } else {
                dimTypeDimNumDimMap = (Map)checkNeedParamMap.get("dimTypeDimNumDimMap");
            }
            Map dimNumDimMap = (Map)dimTypeDimNumDimMap.get(dimType);
            Set<Object> set2 = dimIdSet = null == dimNumDimMap ? new HashSet(1) : dimNumDimMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
            if (!(CollectionUtils.isEmpty((Collection)users) || CollectionUtils.isEmpty(dimIdSet) || null == appMap || appMap.isEmpty() || null == appMap.get(appNumber) || ((Set)appMap.get(appNumber)).isEmpty() || null == entMap || entMap.isEmpty() || null == entMap.get(entityNumber) || ((Set)entMap.get(entityNumber)).isEmpty() || null == permItemMap || permItemMap.isEmpty() || null == permItemMap.get(permItemNumber) || ((Set)permItemMap.get(permItemNumber)).isEmpty())) {
                Set apps = (Set)appMap.get(appNumber);
                Set ents = (Set)entMap.get(entityNumber);
                Set permItems = (Set)permItemMap.get(permItemNumber);
                for (User user : users) {
                    for (App app : apps) {
                        for (Entity ent : ents) {
                            for (PermItem permItem : permItems) {
                                for (Long dimId : dimIdSet) {
                                    String key = user.getFid() + "|" + app.getAppId() + "|" + ent.getEntityNumber() + "|" + permItem.getPermItemId() + "|" + dimType + "|" + dimId;
                                    if (!userDisFuncDimMap.containsKey(key)) continue;
                                    this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"UserRoleService_18", (String)"bos-mservice-permission", (Object[])new Object[0]));
                                    checkResult = false;
                                    if (!failFast) continue;
                                    return checkResult;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (checkResult) {
            passedMap.put(lineNum, willSaveBean);
        }
        return checkResult;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            UserDirectDisPermAfterSaveReq req = (UserDirectDisPermAfterSaveReq)reqOri;
            Map addUserDisUFDMap = req.getAddUserUFDMap();
            if (null == addUserDisUFDMap || addUserDisUFDMap.isEmpty()) {
                return PermResult.ok();
            }
            Set<String> userIdSet = addUserDisUFDMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
            if (null == userIdSet || userIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<String, Map<String, Object>> diffDisDimFuncMap = UserDisPermService.getDiffDisDimFuncMap(addUserDisUFDMap, null, null, userIdSet);
            CacheMrg.clearAllCache();
            PermCommonUtil.cancelShowForm(new ArrayList(addUserDisUFDMap.keySet()), null, (boolean)false);
            this.userDisFuncPermRelateChange2PermLog(diffDisDimFuncMap, reqOri.getPermLogReq());
            super.afterMainEntitySaveExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserDisPermService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public PermCheckResp beforeDelCheck(PermCheckReq req) {
        PermCheckResp permCheckResp = super.beforeDelCheck(req);
        super.beforeDelCheckExt(req);
        return permCheckResp;
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            UserDirectDisPermAfterDelReq req = (UserDirectDisPermAfterDelReq)reqOri;
            Map delUserDisUFDMap = req.getDelUserUFDMap();
            if (null == delUserDisUFDMap || delUserDisUFDMap.isEmpty()) {
                return PermResult.ok();
            }
            Set<String> userIdSet = delUserDisUFDMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
            if (null == userIdSet || userIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<String, Map<String, Object>> diffDisDimFuncMap = UserDisPermService.getDiffDisDimFuncMap(null, delUserDisUFDMap, null, userIdSet);
            CacheMrg.clearAllCache();
            PermCommonUtil.cancelShowForm(new ArrayList(delUserDisUFDMap.keySet()), null, (boolean)false);
            this.userDisFuncPermRelateChange2PermLog(diffDisDimFuncMap, reqOri.getPermLogReq());
            super.afterDelExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserDisPermService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void userDisFuncPermRelateChange2PermLog(Map<String, Map<String, Object>> userDiffDimFuncMap, PermLogReq permLogReq) {
        try {
            if (!PermCommonUtil.isEnablePermLog() || null == permLogReq) {
                return;
            }
            HashMap hashMap = userDiffDimFuncMap = null == userDiffDimFuncMap ? new HashMap(0) : userDiffDimFuncMap;
            if (CollectionUtils.isEmpty(userDiffDimFuncMap)) {
                return;
            }
            HashSet allUserIdSet = new HashSet(8);
            allUserIdSet.addAll(null == userDiffDimFuncMap.keySet() ? new HashSet(0) : userDiffDimFuncMap.keySet());
            if (null == allUserIdSet || allUserIdSet.isEmpty()) {
                return;
            }
            Map userInfoMap = UserHelper.getUserInfoMapByIds(allUserIdSet.stream().map(Long::valueOf).collect(Collectors.toSet()), null);
            permLogReq.check(false);
            for (String oneUserId : allUserIdSet) {
                HashMap<String, Object> diffMap = new HashMap<String, Object>(3);
                diffMap.put("diffDimDisMap", null == userDiffDimFuncMap.get(oneUserId) ? new HashMap(0) : userDiffDimFuncMap.get(oneUserId));
                diffMap.put("langStr", RequestContext.get().getLang().name());
                diffMap.put("influenceUsers", Collections.singletonList(String.valueOf(oneUserId)));
                String formNum = permLogReq.getFormIdentity();
                String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : permLogReq.getAppId();
                String cloudId = StringUtils.isEmpty((String)permLogReq.getCloudId()) ? AppHelper.getMetaAppInfo((String)appId).getCloudId() : permLogReq.getCloudId();
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", cloudId);
                map.put("app_id", appId);
                map.put("form_identity", formNum);
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", permLogReq.getOpItemId());
                User user = (User)userInfoMap.get(Long.valueOf(oneUserId));
                if (null != user) {
                    map.put("op_item_number", user.getFnumber());
                    map.put("op_item_name", user.getFtruename());
                }
                map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                list.add(map);
                BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
                BDLogHelper.addBDLog((BDLogInfo)info);
            }
        }
        catch (Exception e) {
            log.warn("UserDisPermService.userFuncPermRelateChange2PermLog error.", (Throwable)e);
        }
    }

    private static Map<String, Map<String, Object>> getDiffDisDimFuncMap(Map<Long, Set<UserFuncDim>> addUserDisUFDMap, Map<Long, Set<UserFuncDim>> delUserDisUFDMap, Map<Long, Set<UserFuncDim>> updateUserDisUFDMap, Set<String> userIdSet) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserDisUFDMap = null == addUserDisUFDMap ? new HashMap(1) : addUserDisUFDMap;
        delUserDisUFDMap = null == delUserDisUFDMap ? new HashMap(1) : delUserDisUFDMap;
        updateUserDisUFDMap = null == updateUserDisUFDMap ? new HashMap(1) : updateUserDisUFDMap;
        for (String userId : userIdSet) {
            HashMap<String, List<LogDimDis>> diffDimFuncMap = new HashMap<String, List<LogDimDis>>(3);
            Long userIdL = Long.valueOf(userId);
            diffDimFuncMap.put("del", UserDisPermService.getLogLogDimDisList(userIdL, (Set)delUserDisUFDMap.get(userIdL)));
            diffDimFuncMap.put("add", UserDisPermService.getLogLogDimDisList(userIdL, (Set)addUserDisUFDMap.get(userIdL)));
            diffDimFuncMap.put("update", UserDisPermService.getLogLogDimDisList(userIdL, (Set)updateUserDisUFDMap.get(userIdL)));
            resultMap.put(userId, diffDimFuncMap);
        }
        return resultMap;
    }

    private static List<LogDimDis> getLogLogDimDisList(Long userIdL, Set<UserFuncDim> userDisUFDSet) {
        ArrayList<LogDimDis> list = new ArrayList<LogDimDis>(10);
        if (null == userDisUFDSet || userDisUFDSet.isEmpty()) {
            return list;
        }
        LogDimDis one = null;
        for (UserFuncDim userFuncDim : userDisUFDSet) {
            one = new LogDimDis();
            String appId = userFuncDim.getAppId();
            String entityNumber = userFuncDim.getEntityNumber();
            one.setUserId(userIdL);
            one.setAppId(appId);
            one.setEntityId(entityNumber);
            one.setPermItemId(userFuncDim.getPermItemId());
            one.setDimId(userFuncDim.getDimId());
            one.setIncludesuborg(userFuncDim.getIncludeSub() != false ? "1" : "0");
            one.setDimType(userFuncDim.getDimType());
            list.add(one);
        }
        return list;
    }
}

