/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.enums.GrpUsrRuleConfTypeEnum;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.UgSyncUserParam;
import kd.bos.permission.model.UgstdSyncUserParam;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.UserAssignUserGroupReq;
import kd.bos.permission.model.perm.req.UserGroupAssignUserReq;
import kd.bos.permission.service.EventCenterService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UserGroupService {
    private static final Log logger = LogFactory.getLog(UserGroupService.class);
    private static final String systemType = "bos-mservice-permission";
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_UserGroupService_Pool", (int)2);
    public static final String USERGROUPREL_MAIN_ENTITY_TYPE = "bos_usergroupstaff";
    public static final String USERGROUPREL_PROP_USER = "user";
    public static final String USERGROUPREL_PROP_USER_ID = "user_id";
    public static final String USERGROUPREL_PROP_USERGROUP = "usergroup";
    public static final String USERGROUPREL_PROP_USERGROUP_ID = "usergroup_id";
    public static final String USERGROUPREL_PROP_FROM_TYPE = "from_type";
    public static final String USERGROUP_INH_MAIN_ENTITY_TYPE = "perm_usrgrp_inh";
    public static final String USERGROUP_INH_PROP_PARENT = "parent";
    public static final String USERGROUP_INH_PROP_CHILDREN = "children";
    public static final String USERGROUP_INH_PROP_PARENT_ID = "parent_id";
    public static final String USERGROUP_INH_PROP_CHILDREN_ID = "children_id";
    public static final String USERGROUP_INH_PROP_CREATERFIELD = "createrfield";
    public static final String USERGROUP_INH_PROP_CREATEDATEFIELD = "createdatefield";
    public static final String USERGROUP_USRGRPSTD = "usrgrpstd";
    public static final String USERGROUP_SETED_USRSYCRULE = "seted_usrsycrule";
    public static final String USERGROUP_MAIN_ENTITY_TYPE = "bos_usrgrp";
    public static final String USERGROUP_PROP_USER = "user";
    public static final String USERGROUP_PROP_USERGROUP = "usergroup";
    public static final String USER_MAIN_ENTITY_TYPE = "bos_user";
    public static final String PERM_USRGRPSYNC_RULE = "perm_usrgrpsync_rule";
    public static final String BOS_USERGROUPSTAFF = "bos_usergroupstaff";
    public static final String PERM_USERGROUPSTANDARD = "perm_usergroupstandard";
    public static final int RECURSIVE_MAX_LEVEL = 100;

    public static PermResult userAssignUserGroup(UserAssignUserGroupReq req) {
        HashSet<UsrGrpUser> forAddSet = new HashSet<UsrGrpUser>(8);
        HashSet forDelSet = new HashSet(8);
        boolean dataChange = false;
        StringBuilder tips = new StringBuilder();
        HashMap<String, Serializable> resultData = new HashMap<String, Serializable>(8);
        resultData.put("add", forAddSet);
        resultData.put("del", forDelSet);
        resultData.put("dataChange", Boolean.valueOf(dataChange));
        PermResult permResult = new PermResult();
        permResult.setCode(-1);
        permResult.setData(resultData);
        String reason = req.getReason();
        String methodName = "UserGroupService.userAssignUserGroup";
        Map userIdAndGroupIdsMap = req.getUserIdAndGroupIdsMap();
        if (CollectionUtils.isEmpty((Map)userIdAndGroupIdsMap)) {
            tips.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"userIdAndGroupIdsMap"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        AssignModEnum mode = req.getMode();
        if (null == mode) {
            tips.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"mode"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        GrpUsrFromTypeEnum grpUsrFromTypeEnum = req.getGrpUsrFromTypeEnum();
        boolean check = GrpUsrFromTypeEnum.check((GrpUsrFromTypeEnum)grpUsrFromTypeEnum);
        if (!check) {
            tips.append(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e2d\u7528\u6237\u6765\u6e90\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"UserGroupService_1", (String)systemType, (Object[])new Object[]{"mode"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        String fromType = grpUsrFromTypeEnum.getType();
        LinkedList<Long> delUserIdList = new LinkedList<Long>();
        HashMap<Long, Set> delUserGroupMap = new HashMap<Long, Set>(8);
        ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
        UsrGrpUser addUsrGrpUser = null;
        for (Map.Entry map : userIdAndGroupIdsMap.entrySet()) {
            Long userId = (Long)map.getKey();
            Set set = (Set)map.getValue();
            if (null == userId || 0L == userId) {
                tips.append(ResManager.loadKDString((String)"\u975e\u6cd5\u7528\u6237ID\u3002", (String)"UserGroupService_2", (String)systemType, (Object[])new Object[0]));
                continue;
            }
            boolean paramUGIdSetForUIsEmpty = CollectionUtils.isEmpty((Collection)set);
            if (paramUGIdSetForUIsEmpty && AssignModEnum.ASSIGNMODE_CANCEL != mode) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237(%s)\u5206\u914d\u7684\u7528\u6237\u7ec4\u4e3a\u7a7a\u6216\u975e\u53d6\u6d88\u5206\u914d\u6a21\u5f0f\u3002", (String)"UserGroupService_3", (String)systemType, (Object[])new Object[0]), userId));
                continue;
            }
            if (paramUGIdSetForUIsEmpty && AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                delUserIdList.add(userId);
                continue;
            }
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                delUserGroupMap.computeIfAbsent(userId, k -> new HashSet(paramUGIdSetForU.size())).addAll(set);
            }
            if (AssignModEnum.ASSIGNMODE_REPLACE == mode) {
                delUserIdList.add(userId);
                for (Object userGroupId : set) {
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                    newObj.set("usergroup", userGroupId);
                    newObj.set("user", (Object)userId);
                    newObj.set(USERGROUPREL_PROP_FROM_TYPE, (Object)fromType);
                    forAddObjs.add(newObj);
                    addUsrGrpUser = new UsrGrpUser((Long)userGroupId, userId, fromType);
                    forAddSet.add(addUsrGrpUser);
                }
            }
            if (AssignModEnum.ASSIGNMODE_INCREMENT != mode) continue;
            DynamicObject[] existUserIdAndUserGroupRelObjs = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"usergroup", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("usergroup", "in", (Object)set)});
            if (null != existUserIdAndUserGroupRelObjs && existUserIdAndUserGroupRelObjs.length == set.size()) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237(%s)\u5206\u914d\u7684\u7528\u6237\u7ec4\u90fd\u5df2\u5206\u914d\u3002", (String)"UserGroupService_4", (String)systemType, (Object[])new Object[0]), userId));
                continue;
            }
            List groupIdLeaveList = new LinkedList();
            if (null != existUserIdAndUserGroupRelObjs) {
                Set dbGroupIdSet = Arrays.stream(existUserIdAndUserGroupRelObjs).map(x -> x.getLong(USERGROUPREL_PROP_USERGROUP_ID)).collect(Collectors.toSet());
                groupIdLeaveList = ListUtil.removeAll(new LinkedList(set), new LinkedList(dbGroupIdSet));
            }
            if (CollectionUtils.isEmpty(groupIdLeaveList)) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237(%s)\u5206\u914d\u7684\u7528\u6237\u7ec4\u90fd\u5df2\u5206\u914d\u3002", (String)"UserGroupService_4", (String)systemType, (Object[])new Object[0]), userId));
                continue;
            }
            for (Long userGroupId : groupIdLeaveList) {
                DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                newObj.set("usergroup", (Object)userGroupId);
                newObj.set("user", (Object)userId);
                newObj.set(USERGROUPREL_PROP_FROM_TYPE, (Object)fromType);
                forAddObjs.add(newObj);
                addUsrGrpUser = new UsrGrpUser(userGroupId, userId, fromType);
                forAddSet.add(addUsrGrpUser);
            }
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object delUsrGrpSet;
            if (!CollectionUtils.isEmpty(delUserIdList) && null != (delUsrGrpSet = UserGroupHelper.getUsrGrpUserList(null, new HashSet(delUserIdList))) && !delUsrGrpSet.isEmpty()) {
                forDelSet.addAll(delUsrGrpSet);
                List list = delUserIdList.stream().map(String::valueOf).collect(Collectors.toList());
                String delUserIdsStr = String.join((CharSequence)",", list);
                StringBuilder sb = new StringBuilder();
                sb.append("delete from t_sec_usergroupstaff where fuserid in (").append(delUserIdsStr).append(")");
                DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
                dataChange = true;
            }
            if (!CollectionUtils.isEmpty(delUserGroupMap)) {
                for (Map.Entry entry : delUserGroupMap.entrySet()) {
                    Long userId = (Long)entry.getKey();
                    Set usrGrpIdSet = (Set)entry.getValue();
                    Set collect = usrGrpIdSet.stream().map(x -> (Long)x).collect(Collectors.toSet());
                    Set delGroupUserSet = UserGroupHelper.getUsrGrpUserList(collect, Collections.singleton(userId));
                    if (null == delGroupUserSet || delGroupUserSet.isEmpty()) continue;
                    forDelSet.addAll(delGroupUserSet);
                    List usrGrpIdList = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                    String usrGrpIdStr = String.join((CharSequence)",", usrGrpIdList);
                    StringBuilder sb = new StringBuilder();
                    sb.append("delete from t_sec_usergroupstaff where fusergroupid in (").append(usrGrpIdStr).append(")").append(" and fuserid = ?");
                    UserGroupService.delUguByUserId(userId, sb);
                    dataChange = true;
                }
            }
            if (!CollectionUtils.isEmpty(forAddObjs)) {
                SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
                dataChange = true;
            }
            permResult.setCode(0);
            permResult.setMsg(tips.toString());
            resultData.put("dataChange", Boolean.valueOf(dataChange));
            delUsrGrpSet = permResult;
            return delUsrGrpSet;
        }
        catch (Exception e) {
            try {
                logger.warn("{}, reason:{}, exception", new Object[]{methodName, reason, e});
                h.markRollback();
                throw new KDBizException(String.format("reason: %s, exception: %s", reason, e.getMessage()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void delUguByUserId(Long userId, StringBuilder sb) {
        DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{userId});
    }

    public static PermResult userAssignUserGroupWithPermLog(List<UserAssignUserGroupReq> reqList, PermLogReq permLogReq) {
        try {
            StringBuilder resultMsg = new StringBuilder();
            if (null == reqList || reqList.isEmpty()) {
                resultMsg.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"reqList"}));
                return PermResult.fail((StringBuilder)resultMsg);
            }
            boolean needPermLog = false;
            if (permLogReq.getSignPermLog().booleanValue() && PermCommonUtil.isEnablePermLog()) {
                needPermLog = true;
            }
            boolean dataChange = false;
            HashSet<UsrGrpUser> forAddSet = new HashSet<UsrGrpUser>(8);
            HashSet<UsrGrpUser> forDelSet = new HashSet<UsrGrpUser>(8);
            Set oneAddSet = null;
            Set oneDelSet = null;
            for (UserAssignUserGroupReq req : reqList) {
                Map oneMap;
                boolean oneDataChange;
                PermResult one = UserGroupService.userAssignUserGroup(req);
                if (-1 == one.getCode() || !(oneDataChange = ((Boolean)(oneMap = (Map)one.getData()).get("dataChange")).booleanValue())) continue;
                dataChange = oneDataChange;
                if (!needPermLog) continue;
                oneAddSet = (Set)oneMap.get("add");
                if (null != oneAddSet && !oneAddSet.isEmpty()) {
                    forAddSet.addAll(oneAddSet);
                }
                if (null != (oneDelSet = (Set)oneMap.get("del")) && !oneDelSet.isEmpty()) {
                    forDelSet.addAll(oneDelSet);
                }
                resultMsg.append(one.getMsg());
            }
            if (dataChange) {
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
                UserGroupService.userGroupUser2Lic(forAddSet, resultMsg);
            }
            if (needPermLog && dataChange) {
                UserGroupService.userGroupsAssignUser2PermLog(forAddSet, forDelSet, permLogReq, resultMsg);
            }
            return PermResult.ok((StringBuilder)resultMsg);
        }
        catch (Exception e) {
            logger.warn("UserGroupService.userAssignUserGroupWithPermLog, exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    private static void userGroupUser2Lic(Set<UsrGrpUser> forAddSet, StringBuilder resultMsg) {
        try {
            if (null == forAddSet || forAddSet.isEmpty()) {
                return;
            }
            HashMap<Long, Set> grpUserIdSetMap = new HashMap<Long, Set>(8);
            for (UsrGrpUser usrGrpUser : forAddSet) {
                grpUserIdSetMap.computeIfAbsent(usrGrpUser.getUsrGrpId(), k -> new HashSet()).add(usrGrpUser.getUserId());
            }
            Set usrGrpIdSet = grpUserIdSetMap.keySet();
            Map usrGrpIdAppEntSetMap = UserGroupHelper.getUsrGrpIdAppEntSetMap(usrGrpIdSet);
            if (null == usrGrpIdAppEntSetMap || usrGrpIdAppEntSetMap.isEmpty()) {
                return;
            }
            for (Map.Entry entry : usrGrpIdAppEntSetMap.entrySet()) {
                Long usrGrpId = (Long)entry.getKey();
                Map value = (Map)entry.getValue();
                Set userIdSet = (Set)grpUserIdSetMap.get(usrGrpId);
                if (null == userIdSet || userIdSet.isEmpty() || null == value || value.isEmpty()) continue;
                HashMap appEntityMap = new HashMap(value.size());
                for (Map.Entry vv : value.entrySet()) {
                    appEntityMap.put(vv.getKey(), new ArrayList((Collection)vv.getValue()));
                }
                LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(userIdSet), appEntityMap);
            }
        }
        catch (Exception e) {
            logger.warn("UserGroupService.userGroupUser2Lic error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UserGroupService.userGroupUser2Lic error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }

    public static PermResult userGroupsAssignUser(UserGroupAssignUserReq req) {
        HashSet<UsrGrpUser> forAddSet = new HashSet<UsrGrpUser>(8);
        HashSet forDelSet = new HashSet(8);
        boolean dataChange = false;
        StringBuilder tips = new StringBuilder();
        HashMap<String, Serializable> resultData = new HashMap<String, Serializable>(8);
        resultData.put("add", forAddSet);
        resultData.put("del", forDelSet);
        resultData.put("dataChange", Boolean.valueOf(dataChange));
        PermResult permResult = new PermResult();
        permResult.setCode(-1);
        permResult.setData(resultData);
        String reason = req.getReason();
        String methodName = "UserGroupService.userGroupsAssignUser";
        Map groupIdAndUserIdsMap = req.getGroupIdAndUserIdsMap();
        if (CollectionUtils.isEmpty((Map)groupIdAndUserIdsMap)) {
            tips.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"groupIdAndUserIdsMap"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        AssignModEnum mode = req.getMode();
        if (null == mode) {
            tips.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"mode"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        GrpUsrFromTypeEnum grpUsrFromTypeEnum = req.getGrpUsrFromTypeEnum();
        boolean check = GrpUsrFromTypeEnum.check((GrpUsrFromTypeEnum)grpUsrFromTypeEnum);
        if (!check) {
            tips.append(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e2d\u7528\u6237\u6765\u6e90\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"UserGroupService_1", (String)systemType, (Object[])new Object[]{"mode"}));
            permResult.setMsg(tips.toString());
            return permResult;
        }
        String fromType = grpUsrFromTypeEnum.getType();
        LinkedList<Long> delUserGroupIdList = new LinkedList<Long>();
        HashMap<Long, Set> delGroupUserMap = new HashMap<Long, Set>(8);
        ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
        UsrGrpUser addUsrGrpUser = null;
        for (Map.Entry map : groupIdAndUserIdsMap.entrySet()) {
            Long userGroupId = (Long)map.getKey();
            Set set = (Set)map.getValue();
            if (null == userGroupId || 0L == userGroupId) {
                tips.append(ResManager.loadKDString((String)"\u7528\u6237\u7ec4ID\u975e\u6cd5\u3002", (String)"UserGroupService_5", (String)systemType, (Object[])new Object[0]));
                continue;
            }
            boolean paramUIdSetForGIsEmpty = CollectionUtils.isEmpty((Collection)set);
            if (paramUIdSetForGIsEmpty && AssignModEnum.ASSIGNMODE_CANCEL != mode) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4(%s)\u5206\u914d\u7684\u7528\u6237\u4e3a\u7a7a\u6216\u975e\u53d6\u6d88\u5206\u914d\u6a21\u5f0f\u3002", (String)"UserGroupService_6", (String)systemType, (Object[])new Object[0]), userGroupId));
                continue;
            }
            if (paramUIdSetForGIsEmpty && AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                delUserGroupIdList.add(userGroupId);
                continue;
            }
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                delGroupUserMap.computeIfAbsent(userGroupId, k -> new HashSet(paramUIdSetForG.size())).addAll(set);
            }
            if (AssignModEnum.ASSIGNMODE_REPLACE == mode) {
                delUserGroupIdList.add(userGroupId);
                for (Object userId : set) {
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                    newObj.set("usergroup", (Object)userGroupId);
                    newObj.set("user", userId);
                    newObj.set(USERGROUPREL_PROP_FROM_TYPE, (Object)fromType);
                    forAddObjs.add(newObj);
                    addUsrGrpUser = new UsrGrpUser(userGroupId, (Long)userId, fromType);
                    forAddSet.add(addUsrGrpUser);
                }
            }
            if (AssignModEnum.ASSIGNMODE_INCREMENT != mode) continue;
            DynamicObject[] existUserIdAndUserGroupRelObjs = UserGroupService.getExistUserIdAndUserGroupRelObjs(userGroupId, set);
            if (null != existUserIdAndUserGroupRelObjs && existUserIdAndUserGroupRelObjs.length == set.size()) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4(%s)\u5206\u914d\u7684\u7528\u6237\u90fd\u5df2\u5206\u914d\u3002", (String)"UserGroupService_7", (String)systemType, (Object[])new Object[0]), userGroupId));
                continue;
            }
            List userIdLeaveList = new LinkedList();
            if (null != existUserIdAndUserGroupRelObjs) {
                Set DBRelateUserIdSetForG = Arrays.stream(existUserIdAndUserGroupRelObjs).map(x -> x.getLong(USERGROUPREL_PROP_USER_ID)).collect(Collectors.toSet());
                userIdLeaveList = ListUtil.removeAll(new LinkedList(set), new LinkedList(DBRelateUserIdSetForG));
            }
            if (CollectionUtils.isEmpty(userIdLeaveList)) {
                tips.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4(%s)\u5206\u914d\u7684\u7528\u6237\u90fd\u5df2\u5206\u914d\u3002", (String)"UserGroupService_7", (String)systemType, (Object[])new Object[0]), userGroupId));
                continue;
            }
            for (Long userId : userIdLeaveList) {
                DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                newObj.set("usergroup", (Object)userGroupId);
                newObj.set("user", (Object)userId);
                newObj.set(USERGROUPREL_PROP_FROM_TYPE, (Object)fromType);
                forAddObjs.add(newObj);
                addUsrGrpUser = new UsrGrpUser(userGroupId, userId, fromType);
                forAddSet.add(addUsrGrpUser);
            }
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object delUsrGrpSet;
            if (!CollectionUtils.isEmpty(delUserGroupIdList) && null != (delUsrGrpSet = UserGroupHelper.getUsrGrpUserList(new HashSet(delUserGroupIdList), null)) && !delUsrGrpSet.isEmpty()) {
                forDelSet.addAll(delUsrGrpSet);
                List list = delUserGroupIdList.stream().map(String::valueOf).collect(Collectors.toList());
                String delUgIdsStr = String.join((CharSequence)",", list);
                StringBuilder sb = new StringBuilder();
                sb.append("delete from t_sec_usergroupstaff where fusergroupid in (").append(delUgIdsStr).append(")");
                DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
                dataChange = true;
            }
            if (!CollectionUtils.isEmpty(delGroupUserMap)) {
                for (Map.Entry entry : delGroupUserMap.entrySet()) {
                    Set userIdSet = (Set)entry.getValue();
                    Set collect = userIdSet.stream().map(x -> (Long)x).collect(Collectors.toSet());
                    Long usrGrpId = (Long)entry.getKey();
                    Set delGroupUserSet = UserGroupHelper.getUsrGrpUserList(Collections.singleton(usrGrpId), collect);
                    if (null == delGroupUserSet || delGroupUserSet.isEmpty()) continue;
                    forDelSet.addAll(delGroupUserSet);
                    List userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                    String userIdStr = String.join((CharSequence)",", userIdList);
                    StringBuilder sb = new StringBuilder();
                    sb.append("delete from t_sec_usergroupstaff where fuserid in (").append(userIdStr).append(")").append(" and fusergroupid = ?");
                    UserGroupService.delUguByUserId(usrGrpId, sb);
                    dataChange = true;
                }
            }
            if (!CollectionUtils.isEmpty(forAddObjs)) {
                SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
                dataChange = true;
            }
            permResult.setCode(0);
            permResult.setMsg(tips.toString());
            resultData.put("dataChange", Boolean.valueOf(dataChange));
            delUsrGrpSet = permResult;
            return delUsrGrpSet;
        }
        catch (Exception e) {
            try {
                logger.warn("{}, reason:{}, exception", new Object[]{methodName, reason, e});
                h.markRollback();
                throw new KDBizException(String.format("reason: %s, exception: %s", reason, e.getMessage()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static DynamicObject[] getExistUserIdAndUserGroupRelObjs(final Long userGroupId, final Set<Long> paramUIdSetForG) {
        if (null == userGroupId || Objects.equals(0L, userGroupId) || null == paramUIdSetForG || paramUIdSetForG.isEmpty()) {
            return new DynamicObject[0];
        }
        int m = SqlUtil.getBatchCount((Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (int)paramUIdSetForG.size());
        List listAvg = ListUtil.averageAssign(new ArrayList<Long>(paramUIdSetForG), (int)m);
        int avgSize = listAvg.size();
        ArrayList<Future> futureList = new ArrayList<Future>(avgSize);
        for (int i = 0; i < avgSize; ++i) {
            futureList.add(pool.submit(new Callable(){

                public Object call() throws Exception {
                    try {
                        DynamicObject[] existUserIdAndUserGroupRelObjs = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{new QFilter("user", "in", (Object)paramUIdSetForG), new QFilter("usergroup", "=", (Object)userGroupId)});
                        return existUserIdAndUserGroupRelObjs;
                    }
                    catch (Exception e) {
                        logger.warn("UserGroupService.getExistUserIdAndUserGroupRelObjs.call error.", (Throwable)e);
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }));
        }
        ArrayList list = new ArrayList(10);
        for (Future future : futureList) {
            try {
                DynamicObject[] o = (DynamicObject[])future.get();
                if (null == o || o.length == 0) continue;
                ArrayList objects = new ArrayList(o.length);
                list.addAll(objects);
            }
            catch (Exception e) {
                logger.warn("UserGroupService.getExistUserIdAndUserGroupRelObjs, for futureList error.", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    public static PermResult userGroupsAssignUserWithPermLog(List<UserGroupAssignUserReq> reqList, PermLogReq permLogReq) {
        try {
            StringBuilder resultMsg = new StringBuilder();
            if (null == reqList || reqList.isEmpty()) {
                resultMsg.append(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"reqList"}));
                return PermResult.fail((StringBuilder)resultMsg);
            }
            boolean needPermLog = false;
            if (permLogReq.getSignPermLog().booleanValue() && PermCommonUtil.isEnablePermLog()) {
                needPermLog = true;
            }
            boolean dataChange = false;
            HashSet<UsrGrpUser> forAddSet = new HashSet<UsrGrpUser>(8);
            HashSet<UsrGrpUser> forDelSet = new HashSet<UsrGrpUser>(8);
            Set oneAddSet = null;
            Set oneDelSet = null;
            for (UserGroupAssignUserReq req : reqList) {
                Map oneMap;
                boolean oneDataChange;
                PermResult one = UserGroupService.userGroupsAssignUser(req);
                if (-1 == one.getCode() || !(oneDataChange = ((Boolean)(oneMap = (Map)one.getData()).get("dataChange")).booleanValue())) continue;
                dataChange = oneDataChange;
                if (!needPermLog) continue;
                oneAddSet = (Set)oneMap.get("add");
                if (null != oneAddSet && !oneAddSet.isEmpty()) {
                    forAddSet.addAll(oneAddSet);
                }
                if (null != (oneDelSet = (Set)oneMap.get("del")) && !oneDelSet.isEmpty()) {
                    forDelSet.addAll(oneDelSet);
                }
                resultMsg.append(one.getMsg());
            }
            if (dataChange) {
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
                UserGroupService.userGroupUser2Lic(forAddSet, resultMsg);
            }
            if (needPermLog && dataChange) {
                UserGroupService.userGroupsAssignUser2PermLog(forAddSet, forDelSet, permLogReq, resultMsg);
            }
            return PermResult.ok((StringBuilder)resultMsg);
        }
        catch (Exception e) {
            logger.warn("UserGroupService.userGroupsAssignUserWithPermLog, exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    private static void userGroupsAssignUser2PermLog(Set<UsrGrpUser> forAddSet, Set<UsrGrpUser> forDelSet, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            permLogReq.check(false);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            diffMap.put("add", new ArrayList(1));
            diffMap.put("del", new ArrayList(1));
            if (!CollectionUtils.isEmpty(forAddSet)) {
                diffMap.put("add", new ArrayList<UsrGrpUser>(forAddSet));
            }
            if (!CollectionUtils.isEmpty(forDelSet)) {
                diffMap.put("del", new ArrayList<UsrGrpUser>(forDelSet));
            }
            String formNum = permLogReq.getFormIdentity();
            String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? AppHelper.getCurAppId((String)BizAppServiceHelp.getAppIdByFormNum((String)formNum), (String)"") : permLogReq.getAppId();
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("UserGroupService.userGroupsAssignUser2PermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UserGroupService.userGroupsAssignUser2PermLog error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }

    public static boolean userGroupInherit(Long childUserGroupId, List<Long> parentUserGroupIds, AssignModEnum mode, StringBuilder processInfo) {
        boolean parentGroupIdsIsEmpty;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (childUserGroupId == null || childUserGroupId == 0L) {
            processInfo.append("childUserGroupId can't be null or 0L");
            return false;
        }
        if (mode == null) {
            processInfo.append("mode can't be null");
            return false;
        }
        boolean bl = parentGroupIdsIsEmpty = parentUserGroupIds == null || parentUserGroupIds.isEmpty();
        if (AssignModEnum.ASSIGNMODE_CANCEL != mode && parentGroupIdsIsEmpty) {
            processInfo.append("parentGroupIds can't be null or empty when it isn't cancel mode");
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Map childUserGroupMapLoadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{childUserGroupId}, (String)USERGROUP_MAIN_ENTITY_TYPE);
            if (childUserGroupMapLoadFromCache == null || childUserGroupMapLoadFromCache.isEmpty()) {
                processInfo.append("childUserGroupId doesn't exist");
                boolean bl2 = false;
                return bl2;
            }
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode && parentGroupIdsIsEmpty) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_CHILDREN, "=", (Object)childUserGroupId)});
                boolean bl3 = true;
                return bl3;
            }
            assert (parentUserGroupIds != null);
            Map parentGroupMapLoadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])parentUserGroupIds.toArray(), (String)USERGROUP_MAIN_ENTITY_TYPE);
            if (parentGroupMapLoadFromCache == null || parentGroupMapLoadFromCache.isEmpty()) {
                processInfo.append("all parentGroupIds don't exist");
                boolean bl4 = false;
                return bl4;
            }
            Set parentUserGroupIdsExistInDB = parentGroupMapLoadFromCache.keySet();
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_CHILDREN, "=", (Object)childUserGroupId), new QFilter(USERGROUP_INH_PROP_PARENT, "in", parentUserGroupIdsExistInDB)});
                boolean bl5 = true;
                return bl5;
            }
            Object[] allInheritInfo = UserGroupService.getAllInheritInfo();
            if (AssignModEnum.ASSIGNMODE_REPLACE == mode) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_CHILDREN, "=", (Object)childUserGroupId)});
                ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
                int notProperIdCount = 0;
                for (Object parentUserGroupId : parentUserGroupIdsExistInDB) {
                    if (UserGroupService.existCircularInheritance(allInheritInfo, childUserGroupId, (Long)parentUserGroupId, true)) {
                        ++notProperIdCount;
                        continue;
                    }
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)USERGROUP_INH_MAIN_ENTITY_TYPE);
                    newObj.set(USERGROUP_INH_PROP_PARENT, parentUserGroupId);
                    newObj.set(USERGROUP_INH_PROP_CHILDREN, (Object)childUserGroupId);
                    newObj.set(USERGROUP_INH_PROP_CREATERFIELD, (Object)userId);
                    newObj.set(USERGROUP_INH_PROP_CREATEDATEFIELD, (Object)new Date());
                    forAddObjs.add(newObj);
                }
                if (notProperIdCount == parentUserGroupIdsExistInDB.size()) {
                    processInfo.append("all parentUserGroupIdsExistInDB may cause circular Inheritance");
                    boolean bl6 = false;
                    return bl6;
                }
                if (notProperIdCount > 0) {
                    processInfo.append("some parentUserGroupIdsExistInDB may cause circular Inheritance");
                }
                if (forAddObjs != null && !forAddObjs.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
                }
                boolean bl7 = true;
                return bl7;
            }
            DynamicObject[] existInheritRelObjs = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)USERGROUP_INH_PROP_PARENT, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_CHILDREN, "=", (Object)childUserGroupId), new QFilter(USERGROUP_INH_PROP_PARENT, "in", parentUserGroupIdsExistInDB)});
            if (existInheritRelObjs != null && existInheritRelObjs.length == parentUserGroupIdsExistInDB.size()) {
                processInfo.append("all parentUserGroupIdsExistInDB have been inherited");
                boolean notProperIdCount = false;
                return notProperIdCount;
            }
            if (existInheritRelObjs != null) {
                for (DynamicObject existUserGroupObj : existInheritRelObjs) {
                    parentUserGroupIdsExistInDB.remove(existUserGroupObj.get(USERGROUP_INH_PROP_PARENT_ID));
                }
            }
            if (parentUserGroupIdsExistInDB.isEmpty()) {
                processInfo.append("all parentUserGroupIdsExistInDB have been inherited");
                boolean notProperIdCount = false;
                return notProperIdCount;
            }
            ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
            int notProperIdCount = 0;
            for (Object parentUserGroupId : parentUserGroupIdsExistInDB) {
                if (UserGroupService.existCircularInheritance(allInheritInfo, childUserGroupId, (Long)parentUserGroupId, true)) {
                    ++notProperIdCount;
                    continue;
                }
                DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)USERGROUP_INH_MAIN_ENTITY_TYPE);
                newObj.set(USERGROUP_INH_PROP_CHILDREN, (Object)childUserGroupId);
                newObj.set(USERGROUP_INH_PROP_PARENT, parentUserGroupId);
                newObj.set(USERGROUP_INH_PROP_CREATERFIELD, (Object)userId);
                newObj.set(USERGROUP_INH_PROP_CREATEDATEFIELD, (Object)new Date());
                forAddObjs.add(newObj);
            }
            if (notProperIdCount == parentUserGroupIdsExistInDB.size()) {
                processInfo.append("all parentUserGroupIdsExistInDB may cause circular Inheritance");
                boolean bl8 = false;
                return bl8;
            }
            if (notProperIdCount > 0) {
                processInfo.append("some parentUserGroupIdsExistInDB may cause circular Inheritance");
            }
            SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
            boolean bl9 = true;
            return bl9;
        }
        catch (Exception e) {
            logger.warn("userGroupInherit() exception", (Throwable)e);
            h.markRollback();
            boolean bl10 = false;
            return bl10;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static Object[] getAllInheritInfo() {
        Map allInheritData = BusinessDataServiceHelper.loadFromCache((String)USERGROUP_INH_MAIN_ENTITY_TYPE, null);
        HashMap<Long, Set> inheritMap = new HashMap<Long, Set>();
        HashMap<Long, Set> beInheritedMap = new HashMap<Long, Set>();
        for (DynamicObject userGroupInheritDObj : allInheritData.values()) {
            Long parentId = userGroupInheritDObj.getLong(USERGROUP_INH_PROP_PARENT_ID);
            Long childId = userGroupInheritDObj.getLong(USERGROUP_INH_PROP_CHILDREN_ID);
            inheritMap.computeIfAbsent(childId, k -> new HashSet()).add(parentId);
            beInheritedMap.computeIfAbsent(parentId, k -> new HashSet()).add(childId);
        }
        return new Object[]{inheritMap, beInheritedMap};
    }

    public static boolean existCircularInheritance(Object[] allInheritData, Long curId, Long otherId, boolean isInherit) {
        return UserGroupService.existCircularInheritance(allInheritData, curId, otherId, isInherit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existCircularInheritance(Object[] allInheritData, Long curId, Long otherId, boolean isInherit, AtomicInteger recursiveLevel) {
        if (recursiveLevel == null) {
            recursiveLevel = new AtomicInteger(0);
        }
        try {
            if (recursiveLevel.intValue() >= 100) {
                boolean bl = false;
                return bl;
            }
            recursiveLevel.incrementAndGet();
            if (allInheritData == null) {
                allInheritData = UserGroupService.getAllInheritInfo();
            }
            Map inheritMap = (Map)allInheritData[0];
            Map beInheritedMap = (Map)allInheritData[1];
            if (isInherit) {
                if (beInheritedMap == null || beInheritedMap.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                Set beInheritedChildSet = (Set)beInheritedMap.get(curId);
                if (beInheritedChildSet == null || beInheritedChildSet.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (beInheritedChildSet.contains(otherId)) {
                    boolean bl = true;
                    return bl;
                }
                for (Long childId : beInheritedChildSet) {
                    Set subChildIds;
                    if (childId == null || (subChildIds = (Set)beInheritedMap.get(childId)) == null || subChildIds.isEmpty()) continue;
                    for (Long subChildId : subChildIds) {
                        if (subChildId == null || !UserGroupService.existCircularInheritance(allInheritData, subChildId, otherId, isInherit, recursiveLevel)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            } else {
                if (inheritMap == null || inheritMap.isEmpty()) {
                    boolean beInheritedChildSet = false;
                    return beInheritedChildSet;
                }
                Set inheritParentSet = (Set)inheritMap.get(curId);
                if (inheritParentSet == null || inheritParentSet.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (inheritParentSet.contains(otherId)) {
                    boolean bl = true;
                    return bl;
                }
                for (Long parentId : inheritParentSet) {
                    Set grandParentIds;
                    if (parentId == null || (grandParentIds = (Set)inheritMap.get(parentId)) == null || grandParentIds.isEmpty()) continue;
                    for (Long grandParentId : grandParentIds) {
                        if (grandParentId == null || !UserGroupService.existCircularInheritance(allInheritData, grandParentId, otherId, isInherit, recursiveLevel)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            recursiveLevel.decrementAndGet();
        }
    }

    public static boolean userGroupsResetParentGroup(List<Long> userGroupIds, Long parentGroupId) {
        if (userGroupIds == null || userGroupIds.isEmpty() || parentGroupId == null || parentGroupId == 0L) {
            return false;
        }
        SqlBuilder delSqlBuilder = new SqlBuilder();
        delSqlBuilder.append("delete from t_perm_usrgrp_inh ", new Object[0]).append(" where ", new Object[0]).appendIn("fchildrenid", new ArrayList<Long>(userGroupIds));
        DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)delSqlBuilder);
        String insertSql = "insert into t_perm_usrgrp_inh(fid, fparentid, fchildrenid, fcreaterfield, fcreatedatefield)" + "values(?,?,?,?,?) ";
        long[] newLongIdArr = DB.genLongIds((String)"t_perm_usrgrp_inh", (int)userGroupIds.size());
        if (newLongIdArr == null || newLongIdArr.length == 0) {
            return false;
        }
        long creatorId = RequestContext.get().getCurrUserId();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        for (int i = 0; i < userGroupIds.size(); ++i) {
            paramList.add(new Object[]{newLongIdArr[i], parentGroupId, userGroupIds.get(i), creatorId, new Date()});
        }
        DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramList);
        return true;
    }

    public static boolean userGroupBeInherited(Long parentUserGroupId, List<Long> childUserGroupIds, AssignModEnum mode, StringBuilder processInfo) {
        boolean childUserGroupIdsIsEmpty;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (parentUserGroupId == null || parentUserGroupId == 0L) {
            processInfo.append("parentUserGroupId can't be null or 0L");
            return false;
        }
        if (mode == null) {
            processInfo.append("mode can't be null");
            return false;
        }
        boolean bl = childUserGroupIdsIsEmpty = childUserGroupIds == null || childUserGroupIds.isEmpty();
        if (AssignModEnum.ASSIGNMODE_CANCEL != mode && childUserGroupIdsIsEmpty) {
            processInfo.append("childUserGroupIds can't be null or empty when it isn't cancel mode");
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Map parentUserGroupMapLoadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{parentUserGroupId}, (String)USERGROUP_MAIN_ENTITY_TYPE);
            if (parentUserGroupMapLoadFromCache == null || parentUserGroupMapLoadFromCache.isEmpty()) {
                processInfo.append("parentUserGroupId doesn't exist");
                boolean bl2 = false;
                return bl2;
            }
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode && childUserGroupIdsIsEmpty) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_PARENT, "=", (Object)parentUserGroupId)});
                boolean bl3 = true;
                return bl3;
            }
            assert (childUserGroupIds != null);
            Map childGroupMapLoadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])childUserGroupIds.toArray(), (String)USERGROUP_MAIN_ENTITY_TYPE);
            if (childGroupMapLoadFromCache == null || childGroupMapLoadFromCache.isEmpty()) {
                processInfo.append("all childUserGroupIds don't exist");
                boolean bl4 = false;
                return bl4;
            }
            Set childUserGroupIdsExistInDB = childGroupMapLoadFromCache.keySet();
            if (AssignModEnum.ASSIGNMODE_CANCEL == mode) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_PARENT, "=", (Object)parentUserGroupId), new QFilter(USERGROUP_INH_PROP_CHILDREN, "in", childUserGroupIdsExistInDB)});
                boolean bl5 = true;
                return bl5;
            }
            Object[] allInheritInfo = UserGroupService.getAllInheritInfo();
            if (AssignModEnum.ASSIGNMODE_REPLACE == mode) {
                DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_PARENT, "=", (Object)parentUserGroupId)});
                ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
                int notProperIdCount = 0;
                for (Object childId : childUserGroupIdsExistInDB) {
                    if (UserGroupService.existCircularInheritance(allInheritInfo, parentUserGroupId, (Long)childId, false)) {
                        ++notProperIdCount;
                        continue;
                    }
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)USERGROUP_INH_MAIN_ENTITY_TYPE);
                    newObj.set(USERGROUP_INH_PROP_CHILDREN, childId);
                    newObj.set(USERGROUP_INH_PROP_PARENT, (Object)parentUserGroupId);
                    newObj.set(USERGROUP_INH_PROP_CREATERFIELD, (Object)userId);
                    newObj.set(USERGROUP_INH_PROP_CREATEDATEFIELD, (Object)new Date());
                    forAddObjs.add(newObj);
                }
                if (notProperIdCount == childUserGroupIdsExistInDB.size()) {
                    processInfo.append("all childUserGroupIdsExistInDB may cause circular Inheritance");
                    boolean bl6 = false;
                    return bl6;
                }
                if (notProperIdCount > 0) {
                    processInfo.append("some childUserGroupIdsExistInDB may cause circular Inheritance");
                }
                if (forAddObjs != null && !forAddObjs.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
                }
                boolean bl7 = true;
                return bl7;
            }
            DynamicObject[] existInheritRelObjs = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)USERGROUP_INH_PROP_CHILDREN, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_PARENT, "=", (Object)parentUserGroupId), new QFilter(USERGROUP_INH_PROP_CHILDREN, "in", childUserGroupIdsExistInDB)});
            if (existInheritRelObjs != null && existInheritRelObjs.length == childUserGroupIdsExistInDB.size()) {
                processInfo.append("all childUserGroupIdsExistInDB have inherited");
                boolean notProperIdCount = false;
                return notProperIdCount;
            }
            if (existInheritRelObjs != null) {
                for (DynamicObject existUserGroupObj : existInheritRelObjs) {
                    childUserGroupIdsExistInDB.remove(existUserGroupObj.get(USERGROUP_INH_PROP_CHILDREN_ID));
                }
            }
            if (childUserGroupIdsExistInDB.isEmpty()) {
                processInfo.append("all childUserGroupIdsExistInDB have inherited");
                boolean notProperIdCount = false;
                return notProperIdCount;
            }
            ArrayList<DynamicObject> forAddObjs = new ArrayList<DynamicObject>(8);
            int notProperIdCount = 0;
            for (Object childId : childUserGroupIdsExistInDB) {
                if (UserGroupService.existCircularInheritance(allInheritInfo, parentUserGroupId, (Long)childId, false)) {
                    ++notProperIdCount;
                    continue;
                }
                DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)USERGROUP_INH_MAIN_ENTITY_TYPE);
                newObj.set(USERGROUP_INH_PROP_PARENT, (Object)parentUserGroupId);
                newObj.set(USERGROUP_INH_PROP_CHILDREN, childId);
                newObj.set(USERGROUP_INH_PROP_CREATERFIELD, (Object)userId);
                newObj.set(USERGROUP_INH_PROP_CREATEDATEFIELD, (Object)new Date());
                forAddObjs.add(newObj);
            }
            if (notProperIdCount == childUserGroupIdsExistInDB.size()) {
                processInfo.append("all childUserGroupIdsExistInDB may cause circular Inheritance");
                boolean bl8 = false;
                return bl8;
            }
            if (notProperIdCount > 0) {
                processInfo.append("some childUserGroupIdsExistInDB may cause circular Inheritance");
            }
            SaveServiceHelper.save((DynamicObject[])forAddObjs.toArray(new DynamicObject[forAddObjs.size()]));
            boolean bl9 = true;
            return bl9;
        }
        catch (Exception e) {
            logger.warn("userGroupInherit() exception", (Throwable)e);
            h.markRollback();
            boolean bl10 = false;
            return bl10;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static void initTree(TreeView userGroupTree, String rootId) {
        UserGroupService.initTree(userGroupTree, rootId, null);
    }

    public static void initTree(TreeView userGroupTree, String rootId, Long usrGrpStdId) {
        UserGroupService.initTree(userGroupTree, rootId, usrGrpStdId, false);
    }

    public static List<ComboItem> getAllUsrGrpStd() {
        LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
        DynamicObjectCollection UsrGrpStdCol = QueryServiceHelper.query((String)PERM_USERGROUPSTANDARD, (String)"id,name", (QFilter[])new QFilter[0], (String)"id");
        for (DynamicObject usrGrpStd : UsrGrpStdCol) {
            comboItems.add(new ComboItem(new LocaleString(usrGrpStd.getString("name")), usrGrpStd.getLong("id") + ""));
        }
        return comboItems;
    }

    public static void initTree(TreeView userGroupTree, String rootId, Long usrGrpStdId, boolean focusRootNode) {
        DynamicObject[] dynamicObjects;
        userGroupTree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserGroupService_8", (String)systemType, (Object[])new Object[0]));
        userGroupTree.addNode(root);
        HashMap<String, List<DynamicObject>> userGroupInhRelation = new HashMap<String, List<DynamicObject>>(8);
        QFilter qFilter = usrGrpStdId == null ? new QFilter(USERGROUP_USRGRPSTD, "=", (Object)PermHelperConst.NOTCLASSIFY_STDID) : new QFilter(USERGROUP_USRGRPSTD, "=", (Object)usrGrpStdId);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] allGroupArr = BusinessDataServiceHelper.load((String)USERGROUP_MAIN_ENTITY_TYPE, (String)"id,name", (QFilter[])filters);
        HashSet<Long> childGroupIds = new HashSet<Long>(8);
        for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)String.join((CharSequence)",", USERGROUP_INH_PROP_PARENT, USERGROUP_INH_PROP_CHILDREN), null)) {
            DynamicObject parent = object.getDynamicObject(USERGROUP_INH_PROP_PARENT);
            DynamicObject child = object.getDynamicObject(USERGROUP_INH_PROP_CHILDREN);
            if (child != null) {
                childGroupIds.add(child.getLong("id"));
            }
            String parentId = parent == null ? rootId : parent.getString("id");
            List childObjects = userGroupInhRelation.computeIfAbsent(parentId, k -> new ArrayList(8));
            childObjects.add(child);
            userGroupInhRelation.put(parentId, childObjects);
        }
        int index = 0;
        for (DynamicObject group : allGroupArr) {
            Long id = group.getLong("id");
            if (childGroupIds.contains(id)) continue;
            TreeNode firstLevelNode = new TreeNode();
            firstLevelNode.setId(id + "-" + ++index);
            firstLevelNode.setText(group.getString("name"));
            firstLevelNode.setParentid(rootId);
            index = UserGroupService.addChildTreeNode(firstLevelNode, userGroupInhRelation, index);
            userGroupTree.addNode(firstLevelNode);
        }
        userGroupTree.expand(rootId);
        UserGroupService.focusNodeSelf(userGroupTree, root);
    }

    private static void focusNodeSelf(TreeView tree, TreeNode node) {
        IPageCache pgCache = (IPageCache)tree.getView().getService(IPageCache.class);
        tree.focusNode(node);
        Map focusNode = tree.getTreeState().getFocusNode();
        String curUserGroupName = String.valueOf(focusNode.get("text"));
        pgCache.put("userGroupName", curUserGroupName);
        String focusNodeId = String.valueOf(focusNode.get("id"));
        pgCache.put("focusNodeId", focusNodeId);
        String parentId = String.valueOf(focusNode.get("parentid"));
        pgCache.put("focusNodeParentId", parentId);
    }

    public static int addChildTreeNode(TreeNode node, Map<String, List<DynamicObject>> userGroupInhRelation, int index) {
        String nodeId = node.getId().split("-")[0];
        List<DynamicObject> childrenNodeList = userGroupInhRelation.get(nodeId);
        if (childrenNodeList != null && !childrenNodeList.isEmpty()) {
            for (DynamicObject child : childrenNodeList) {
                TreeNode childNode = new TreeNode();
                childNode.setId(child.getString("id") + "-" + ++index);
                childNode.setText(child.getString("name"));
                childNode.setParentid(node.getId());
                node.addChild(childNode);
                index = UserGroupService.addChildTreeNode(childNode, userGroupInhRelation, index);
            }
        }
        return index;
    }

    public static Set<Long> getAllParentOrChildrenGroup(DynamicObject[] objects, Long grpId, int mode) {
        ArrayList<Long[]> list = new ArrayList<Long[]>(8);
        for (DynamicObject object : objects) {
            if (mode == 0) {
                list.add(new Long[]{object.getLong(USERGROUP_INH_PROP_CHILDREN_ID), object.getLong(USERGROUP_INH_PROP_PARENT_ID)});
                continue;
            }
            list.add(new Long[]{object.getLong(USERGROUP_INH_PROP_PARENT_ID), object.getLong(USERGROUP_INH_PROP_CHILDREN_ID)});
        }
        return UserGroupService.recursiveFindUserGroup(list, grpId, new HashSet<Long>(8));
    }

    private static Set<Long> recursiveFindUserGroup(ArrayList<Long[]> list, Long grpId, HashSet<Long> set) {
        if (list.isEmpty()) {
            return set;
        }
        for (Long[] relation : list) {
            if (!relation[0].equals(grpId)) continue;
            set.add(relation[1]);
            UserGroupService.recursiveFindUserGroup(list, relation[1], set);
        }
        return set;
    }

    public static Set<Long> getAllUsersIdByUsrGrpId(Long usrGrpId) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)"parent,children", null);
        Set<Long> allChildrenGroup = UserGroupService.getAllParentOrChildrenGroup(objs, usrGrpId, 1);
        allChildrenGroup.add(usrGrpId);
        QFilter[] qfArr = new QFilter[]{new QFilter("usergroup", "in", allChildrenGroup)};
        DynamicObject[] arrDObj = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"id, user", (QFilter[])qfArr);
        if (arrDObj.length == 0) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> userIds = new HashSet<Long>(8);
        for (DynamicObject obj : arrDObj) {
            DynamicObject user = obj.getDynamicObject("user");
            if (user == null) continue;
            Long userId = (Long)user.getPkValue();
            userIds.add(userId);
        }
        return userIds;
    }

    public static Set<Long> getUsersIdByUsrGrpId(Long usrGrpId) {
        return UserGroupService.getUsersIdByUsrGrpId(usrGrpId, Sets.newHashSet((Object[])new String[]{"1"}));
    }

    public static Set<Long> getUsersIdByUsrGrpId(Long usrGrpId, Set<String> enableVSet) {
        HashSet<Long> result = new HashSet<Long>(8);
        StringBuilder sql = new StringBuilder("select b.fid from t_sec_usergroupstaff a ");
        sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
        sql.append(" where a.fusergroupid = ? ");
        if (null != enableVSet && !enableVSet.isEmpty()) {
            String enableVSetStr = String.join((CharSequence)"','", enableVSet);
            sql.append(" and b.fenable in ('").append(enableVSetStr).append("')");
        }
        Object[] params = new Object[]{usrGrpId};
        try (DataSet dataSet = DB.queryDataSet((String)UserGroupService.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            for (Row row : dataSet) {
                result.add(row.getLong("fid"));
            }
        }
        return result;
    }

    public static Set<Long> getUsersIdByUsrGrpIds(List<Long> usrGrpIds) {
        HashSet<Long> result = new HashSet<Long>(8);
        if (usrGrpIds == null || usrGrpIds.isEmpty()) {
            return result;
        }
        StringBuilder sql = new StringBuilder("select b.fid from t_sec_usergroupstaff a ");
        sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
        sql.append(" where a.fusergroupid in (");
        for (Long usrGrpId : usrGrpIds) {
            sql.append(usrGrpId).append(",");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)UserGroupService.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString());){
            for (Row row : dataSet) {
                result.add(row.getLong("fid"));
            }
        }
        return result;
    }

    public static Map<Long, Set<Long>> getGrpIdUIdSetMap(Set<Long> usrGrpIdSet) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            return map;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fusergroupid, b.fid ");
        sql.append(" from t_sec_usergroupstaff a  ");
        sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
        sql.append(" where b.fenable = ? ");
        List collect = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String collectStr = String.join((CharSequence)",", collect);
        sql.append(" and a.fusergroupid in (").append(collectStr).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)UserGroupService.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{"1"});){
            for (Row row : dataSet) {
                map.computeIfAbsent(row.getLong("fusergroupid"), k -> new HashSet(8)).add(row.getLong("fid"));
            }
        }
        return map;
    }

    public static Map<Long, Set<Long>> getGrpIdUIdSetMapNoneEnable(Set<Long> usrGrpIdSet) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            return map;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fusergroupid, b.fid ");
        sql.append(" from t_sec_usergroupstaff a  ");
        sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
        List collect = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String collectStr = String.join((CharSequence)",", collect);
        sql.append(" and a.fusergroupid in (").append(collectStr).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)UserGroupService.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), null);){
            for (Row row : dataSet) {
                map.computeIfAbsent(row.getLong("fusergroupid"), k -> new HashSet(8)).add(row.getLong("fid"));
            }
        }
        return map;
    }

    public static Map<Long, Set<Long>> getUIdGrpIdSetMap(Set<Long> userIdSet) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        if (null == userIdSet || userIdSet.isEmpty()) {
            return map;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fusergroupid, b.fid ");
        sql.append(" from t_sec_usergroupstaff a  ");
        sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
        sql.append(" where b.fenable = ? ");
        List collect = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String collectStr = String.join((CharSequence)",", collect);
        sql.append(" and a.fuserid in (").append(collectStr).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)UserGroupService.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{"1"});){
            for (Row row : dataSet) {
                map.computeIfAbsent(row.getLong("fid"), k -> new HashSet(8)).add(row.getLong("fusergroupid"));
            }
        }
        return map;
    }

    public static Set<Long> getAllRelativeGroup(List<Long> parentList, List<Long> childrenList, int mode) {
        HashSet<Long> result = new HashSet<Long>(parentList);
        result.addAll(childrenList);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)"parent,children", null);
        if (mode == 0) {
            for (Long child : childrenList) {
                result.addAll(UserGroupService.getAllParentOrChildrenGroup(objects, child, 1));
            }
        } else {
            for (Long parent : parentList) {
                result.addAll(UserGroupService.getAllParentOrChildrenGroup(objects, parent, 0));
            }
        }
        return result;
    }

    public static Set<Long> getAllUsersIdByUsrGrpStdId(Long usrGrpStdId) {
        DynamicObject[] users;
        HashSet<Long> userIds = new HashSet<Long>(8);
        QFilter qFilter = new QFilter("usergrouptypeid", "=", (Object)PermHelperConst.NORMAL_USERGROUPTYPE_ID);
        QFilter[] filters = new QFilter[]{qFilter};
        if (usrGrpStdId == null) {
            qFilter.and(USERGROUP_USRGRPSTD, "=", (Object)0L);
        } else {
            qFilter.and(USERGROUP_USRGRPSTD, "=", (Object)usrGrpStdId);
        }
        DynamicObject[] usrGrps = BusinessDataServiceHelper.load((String)USERGROUP_MAIN_ENTITY_TYPE, (String)"id", (QFilter[])filters);
        ArrayList<Long> usrGrpIdList = new ArrayList<Long>(usrGrps.length);
        for (DynamicObject usrGrp : usrGrps) {
            usrGrpIdList.add(usrGrp.getLong("id"));
        }
        for (DynamicObject user : users = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", usrGrpIdList)})) {
            userIds.add(user.getLong(USERGROUPREL_PROP_USER_ID));
        }
        return userIds;
    }

    public static PermResult syncUserByUgstd(UgstdSyncUserParam param) {
        String tips = "";
        String methodName = "UserGroupService.syncUserByUgstd";
        try {
            Set<Long> ugstdIdSet = param.getUgstdIdSet();
            UserGroupService.checkUgstd(ugstdIdSet);
            Map userGroupDBMaps = BusinessDataServiceHelper.loadFromCache((String)USERGROUP_MAIN_ENTITY_TYPE, (String)"id", (QFilter[])new QFilter[]{new QFilter(USERGROUP_USRGRPSTD, "in", ugstdIdSet), new QFilter(USERGROUP_SETED_USRSYCRULE, "=", (Object)"1")});
            if (CollectionUtils.isEmpty((Map)userGroupDBMaps)) {
                tips = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u201c\u7528\u6237\u7ec4\u5206\u7c7b\u201d\u5173\u8054\u7684\u201c\u7528\u6237\u7ec4\u201d\u6216\u201c\u7528\u6237\u7ec4\u201d\u672a\u8bbe\u7f6e\u201c\u7528\u6237\u540c\u6b65\u89c4\u5219\u201d\u3002", (String)"UserGroupService_9", (String)systemType, (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            UserGroupService.syncUserByUserGroup(new UgSyncUserParam(userGroupDBMaps.keySet(), param.getGrpUsrFromTypeEnum(), param.getPermLogReq()));
        }
        catch (Exception e) {
            logger.warn("{}, exception", (Object)methodName, (Object)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok((Object)tips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermResult syncUserByUserGroup(UgSyncUserParam param) throws Exception {
        String tips = "";
        String methodName = "UserGroupService.syncUserByUserGroup";
        try {
            Set<Object> userGroupIdSet = param.getUserGroupIdSet();
            if (CollectionUtils.isEmpty(userGroupIdSet)) {
                tips = ResManager.loadKDString((String)"\u53c2\u6570%s\u4e3a\u7a7a\u3002", (String)"UserGroupService_0", (String)systemType, (Object[])new Object[]{"userGroupIdSet"});
                throw new KDBizException(tips);
            }
            GrpUsrFromTypeEnum grpUsrFromTypeEnum = param.getGrpUsrFromTypeEnum();
            boolean check = GrpUsrFromTypeEnum.check((GrpUsrFromTypeEnum)grpUsrFromTypeEnum);
            if (!check) {
                tips = ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e2d\u7528\u6237\u6765\u6e90\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"UserGroupService_1", (String)systemType, (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            Map userGroupDBMaps = BusinessDataServiceHelper.loadFromCache((String)USERGROUP_MAIN_ENTITY_TYPE, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", userGroupIdSet), new QFilter(USERGROUP_SETED_USRSYCRULE, "=", (Object)"1")});
            if (CollectionUtils.isEmpty((Map)userGroupDBMaps)) {
                tips = ResManager.loadKDString((String)"\u6240\u6709\u76f8\u5173\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\u6216\u5747\u672a\u8bbe\u7f6e\u7528\u6237\u540c\u6b65\u89c4\u5219\u3002", (String)"UserGroupService_10", (String)systemType, (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            userGroupIdSet = userGroupDBMaps.keySet();
            Map userSyncRuleMap = BusinessDataServiceHelper.loadFromCache((String)PERM_USRGRPSYNC_RULE, (String)"usergroup, source_entity, userfieldkey, grpreffieldkey, grprefbdtype, grprefvalue, iscomplexrule, rule, ruleconftype", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", userGroupIdSet)});
            if (CollectionUtils.isEmpty((Map)userSyncRuleMap)) {
                tips = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u201c\u7528\u6237\u7ec4\u201d\u5173\u8054\u7684\u201c\u7528\u6237\u540c\u6b65\u89c4\u5219\u201d\u3002", (String)"UserGroupService_11", (String)systemType, (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            HashMap<Long, List> userSyncRuleGroupMap = new HashMap<Long, List>(8);
            HashMap<Long, String> groupIdNameMap = new HashMap<Long, String>(8);
            for (DynamicObject value : userSyncRuleMap.values()) {
                Long l = value.getLong(USERGROUPREL_PROP_USERGROUP_ID);
                userSyncRuleGroupMap.computeIfAbsent(l, k -> new LinkedList()).add(value);
                DynamicObject ugdyn = value.getDynamicObject("usergroup");
                if (null == ugdyn) continue;
                groupIdNameMap.put(l, ugdyn.getString("name"));
            }
            switch (grpUsrFromTypeEnum) {
                case UGTYPE_SYNC: 
                case UG_HAND_SYNC: 
                case EVENT_SYNC: 
                case TIME_SYNC: {
                    Set ugIdSet = userSyncRuleGroupMap.keySet();
                    if (CollectionUtils.isEmpty(ugIdSet)) break;
                    for (Map.Entry<Long, List<DynamicObject>> entry : userSyncRuleGroupMap.entrySet()) {
                        DLock lock = null;
                        try {
                            lock = DLock.create((String)("UserGroupService/syncUserByUserGroup/dealOneGroup/" + entry.getKey()));
                            lock.lock();
                            String reason = methodName + ", " + grpUsrFromTypeEnum.getDesc();
                            UserGroupService.dealOneGroup(param, groupIdNameMap, reason, entry);
                        }
                        catch (Exception e) {
                            logger.warn("UserGroupService.syncUserByUserGroup error", (Throwable)e);
                        }
                        finally {
                            if (null == lock) continue;
                            lock.unlock();
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn("{}, exception", (Object)methodName, (Object)e);
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok((Object)tips);
    }

    private static void dealOneGroup(UgSyncUserParam param, Map<Long, String> groupIdNameMap, String reason, Map.Entry<Long, List<DynamicObject>> map) {
        Long userGroupId = map.getKey();
        try {
            HashSet oneUsrGrpIdSet = Sets.newHashSet((Object[])new Long[]{userGroupId});
            Map<Long, Set<Long>> groupSync_ugUserDBMap = UserGroupService.getUgUidSetMapByFromType(oneUsrGrpIdSet, GrpUsrFromTypeEnum.getFromGroupTypeList());
            Map<Long, Set<Long>> hand_ugUserDBMap = UserGroupService.getUgUidSetMapByFromType(oneUsrGrpIdSet, GrpUsrFromTypeEnum.getHandAddTypeList());
            HashMap cancelGAndUMap = new HashMap(8);
            HashMap increGAndUMap = new HashMap(8);
            List<DynamicObject> userSyncRuleList = map.getValue();
            Set<Long> singleUgUserIdSet = UserGroupService.getSingleUgUserIds(userGroupId, userSyncRuleList, groupIdNameMap);
            Set<Object> groupSyncDBUserIdSet = CollectionUtils.isEmpty((Collection)groupSync_ugUserDBMap.get(userGroupId)) ? new HashSet(1) : groupSync_ugUserDBMap.get(userGroupId);
            List removeUList = ListUtil.removeAll(new LinkedList(groupSyncDBUserIdSet), new LinkedList<Long>(singleUgUserIdSet));
            Set<Object> handDBUserIdSet = CollectionUtils.isEmpty((Collection)hand_ugUserDBMap.get(userGroupId)) ? new HashSet(1) : hand_ugUserDBMap.get(userGroupId);
            groupSyncDBUserIdSet.addAll(handDBUserIdSet);
            List addUList = ListUtil.removeAll(new LinkedList<Long>(singleUgUserIdSet), new LinkedList<Object>(groupSyncDBUserIdSet));
            if (!CollectionUtils.isEmpty((Collection)removeUList)) {
                cancelGAndUMap.put(userGroupId, new HashSet(removeUList));
            }
            if (!CollectionUtils.isEmpty((Collection)addUList)) {
                increGAndUMap.put(userGroupId, new HashSet(addUList));
            }
            PermLogReq permLogReq = param.getPermLogReq();
            GrpUsrFromTypeEnum grpUsrFromTypeEnum = param.getGrpUsrFromTypeEnum();
            ArrayList<UserGroupAssignUserReq> reqList = new ArrayList<UserGroupAssignUserReq>(2);
            reqList.add(new UserGroupAssignUserReq(cancelGAndUMap, AssignModEnum.ASSIGNMODE_CANCEL, grpUsrFromTypeEnum, reason));
            reqList.add(new UserGroupAssignUserReq(increGAndUMap, AssignModEnum.ASSIGNMODE_INCREMENT, grpUsrFromTypeEnum, reason));
            UserGroupService.userGroupsAssignUserWithPermLog(reqList, permLogReq);
        }
        catch (Exception e) {
            logger.warn("UserGroupService.dealOneGroup, userGroupId:{}, exception", (Object)userGroupId, (Object)e);
        }
    }

    private static Map<Long, Set<Long>> getUgUidSetMapByFromType(Set<Long> ugIdSet, List<String> fromTypeList) {
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fuserid, fusergroupid from t_sec_usergroupstaff where 1=1 ", new Object[0]);
        if (null != ugIdSet && !ugIdSet.isEmpty()) {
            sqlBuilder.appendIn(" and fusergroupid ", ugIdSet.toArray());
        }
        if (null != fromTypeList && !fromTypeList.isEmpty()) {
            sqlBuilder.appendIn(" and ffrom_type ", fromTypeList.toArray());
        }
        try (DataSet dataSet = DB.queryDataSet((String)"UserGroupService.getUgUidSetMapByFromType", (DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                resultMap.computeIfAbsent(row.getLong("fusergroupid"), k -> new HashSet(8)).add(row.getLong("fuserid"));
            }
        }
        return resultMap;
    }

    private static void checkUgstd(Set<Long> ugstdIdSet) {
        String tips = "";
        String methodName = "UserGroupService.checkUgstd";
        if (CollectionUtils.isEmpty(ugstdIdSet)) {
            tips = ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u5206\u7c7bID\u4e3a\u7a7a\u3002", (String)"UserGroupService_12", (String)systemType, (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        Map ugstdDBMaps = BusinessDataServiceHelper.loadFromCache((String)PERM_USERGROUPSTANDARD, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ugstdIdSet)});
        if (CollectionUtils.isEmpty((Map)ugstdDBMaps)) {
            tips = ResManager.loadKDString((String)"\u201c\u7528\u6237\u7ec4\u5206\u7c7b\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserGroupService_13", (String)systemType, (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        for (Map.Entry map : ugstdDBMaps.entrySet()) {
            DynamicObject value = (DynamicObject)map.getValue();
            if (null != value) continue;
            tips = ResManager.loadKDString((String)"\u201c\u7528\u6237\u7ec4\u5206\u7c7b\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserGroupService_13", (String)systemType, (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
    }

    private static Set<Long> getSingleUgUserIds(Long userGroupId, List<DynamicObject> userSyncRuleList, Map<Long, String> groupIdNameMap) throws Exception {
        if (CollectionUtils.isEmpty(userSyncRuleList)) {
            String info = String.format("UserGroupService.getSingleUgUserIds, userGroupId:%s, userSyncRuleList is empty.", userGroupId);
            throw new Exception(info);
        }
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        for (DynamicObject userSyncRule : userSyncRuleList) {
            Set<Long> singleUgUsers = UserGroupService.getSingleUgUsersByOneRule(userGroupId, userSyncRule);
            userIdSet.addAll(singleUgUsers);
        }
        return userIdSet;
    }

    private static Set<Long> getSingleUgUsersByOneRule(Long userGroupId, DynamicObject userSyncRule) throws Exception {
        String info = "";
        String entityNum = userSyncRule.getString("source_entity_id");
        if (StringUtils.isEmpty((String)entityNum)) {
            info = String.format("UserGroupService.getSingleUgUsersByOneRule, userGroupId:%s, entityNum is empty.", userGroupId);
            throw new Exception(info);
        }
        String grpreffieldkey = userSyncRule.getString("grpreffieldkey");
        if (StringUtils.isEmpty((String)grpreffieldkey)) {
            info = String.format("UserGroupService.getSingleUgUsersByOneRule, userGroupId:%s, grpreffieldkey is empty.", userGroupId);
            throw new Exception(info);
        }
        Object grprefvalue = userSyncRule.get("grprefvalue");
        if (null == grprefvalue) {
            info = String.format("UserGroupService.getSingleUgUsersByOneRule, userGroupId:%s, grprefvalue is null.", userGroupId);
            throw new Exception(info);
        }
        String userfieldkey = userSyncRule.getString("userfieldkey");
        if (StringUtils.isEmpty((String)userfieldkey)) {
            info = String.format("UserGroupService.getSingleUgUsersByOneRule, userGroupId:%s, userfieldkey is empty.", userGroupId);
            throw new Exception(info);
        }
        Set priKeyVSet = Arrays.stream(String.valueOf(grprefvalue).split(",")).collect(Collectors.toSet());
        Object realGrprefvalue = FormHelper.getEntPriKeyV((String)entityNum, priKeyVSet);
        Map userIdMaps = BusinessDataServiceHelper.loadFromCache((String)entityNum, (String)userfieldkey, (QFilter[])new QFilter[]{new QFilter(grpreffieldkey, "in", realGrprefvalue)});
        if (CollectionUtils.isEmpty((Map)userIdMaps)) {
            return new HashSet<Long>(1);
        }
        String ruleconftype = userSyncRule.getString("ruleconftype");
        Collection values = userIdMaps.values();
        if (GrpUsrRuleConfTypeEnum.USER.getType().equals(ruleconftype)) {
            return values.stream().map(x -> x.getLong(userfieldkey)).collect(Collectors.toSet());
        }
        if (GrpUsrRuleConfTypeEnum.CUSTOM.getType().equals(ruleconftype)) {
            String[] split = userfieldkey.split("\\.");
            HashSet<Long> result = new HashSet<Long>(values.size());
            for (DynamicObject value : values) {
                String FLflag = split[0];
                String FLField = split[1];
                if (StringUtils.isEmpty((String)FLflag) || StringUtils.isEmpty((String)FLField)) {
                    logger.warn("UserGroupService.getSingleUgUsersByOneRule, userGroupId:{}, FLflag:{}, or FLField:{}  is empty.", new Object[]{userGroupId, FLflag, FLField});
                    continue;
                }
                boolean isBaseData = FormHelper.isBaseData((String)entityNum, (String)FLField);
                if (!isBaseData) {
                    logger.warn("UserGroupService.getSingleUgUsersByOneRule, userGroupId:{}, FLflag:{}, FLField:{}  is not baseData.", new Object[]{userGroupId, FLflag, FLField});
                    continue;
                }
                DynamicObjectCollection FL = value.getDynamicObjectCollection(FLflag);
                if (null == FL) {
                    logger.warn("UserGroupService.getSingleUgUsersByOneRule, userGroupId:{}, FLflag:{}, FLField:{}, FL is empty.", new Object[]{userGroupId, FLflag, FLField});
                    continue;
                }
                result.addAll(FL.stream().map(x -> x.getLong(FLField + "_id")).collect(Collectors.toSet()));
            }
            return result;
        }
        info = String.format("UserGroupService.getSingleUgUsersByOneRule, userGroupId:%s, ruleconftype illeagal.", userGroupId);
        throw new Exception(info);
    }

    public static QFilter checkRuleJsonRetFilter(Long userGroupId, String entityNum, String ruleJson, Map<Long, String> groupIdNameMap) throws Exception {
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            QFilter oriFilter = PermCommonUtil.getQFilterFromFilterGridJsonStr((MainEntityType)entityType, (String)ruleJson);
            boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
            QFilter curRuleFilter = hasEnablePropCollapse ? PermCommonUtil.convertQFilter((String)entityNum, (QFilter)oriFilter) : oriFilter;
            return curRuleFilter;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            if (null != userGroupId && userGroupId > 0L) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u201c%s\u201d\u4e2d", (String)"UserGroupService_14", (String)systemType, (Object[])new Object[0]), groupIdNameMap.get(userGroupId)));
            }
            String entityNumDesc = EntityMetadataCache.getDataEntityType((String)entityNum).getDisplayName().getLocaleValue();
            sb.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5b9e\u4f53\u201c%1$s\u201d\uff0c%2$s", (String)"UserGroupService_15", (String)systemType, (Object[])new Object[0]), entityNumDesc, e.getMessage()));
            String sbStr = sb.toString();
            logger.warn("UserGroupService.checkRuleJsonRetFilter, {}, exception", (Object)sbStr, (Object)e);
            throw new Exception(sbStr);
        }
    }

    public static boolean isMultiInheritance(String usrGrpStd) {
        StringBuilder sql = new StringBuilder();
        sql.append("select ui.fchildrenid from t_sec_usergroup u ").append("join t_perm_usrgrp_inh ui on u.fid = ui.fchildrenid ");
        if (StringUtils.isNotEmpty((String)usrGrpStd)) {
            sql.append("where u.fusrgrpstdid = ? ");
        }
        sql.append(" group by ui.fchildrenid having count(ui.fparentid) > 1");
        Object[] param = new Object[1];
        if (StringUtils.isNotEmpty((String)usrGrpStd)) {
            param[0] = Long.valueOf(usrGrpStd);
        }
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])param, ResultSet::next);
    }

    public static void initTab(Tab tab, IFormView view) {
        List tabKeys;
        String pageCache_tabKeys = view.getPageCache().get("pageCache_tabKeys");
        if (StringUtils.isNotEmpty((String)pageCache_tabKeys) && !(tabKeys = (List)JSON.parseObject((String)pageCache_tabKeys, List.class)).isEmpty()) {
            String[] keys = tabKeys.toArray(new String[0]);
            tab.deleteControls(keys);
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        DynamicObjectCollection UsrGrpStdCol = QueryServiceHelper.query((String)PERM_USERGROUPSTANDARD, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "<>", (Object)PermHelperConst.NOTCLASSIFY_STDID)}, (String)"id");
        String selectedTab = view.getPageCache().get("pageCache_selectedTab");
        boolean tabStillExist = false;
        String firstStdId = "1404221671421785088";
        for (int i = 0; i < UsrGrpStdCol.size(); ++i) {
            DynamicObject usrGrpStd = (DynamicObject)UsrGrpStdCol.get(i);
            String usrGrpStdId = usrGrpStd.getLong("id") + "";
            if (0 == i) {
                firstStdId = usrGrpStdId;
            }
            allTabKeys.add(usrGrpStdId);
            if (usrGrpStdId.equals(selectedTab)) {
                tabStillExist = true;
            }
            items.add(UserGroupService.createTabPageApItem(usrGrpStdId, new LocaleString(usrGrpStd.getString("name"))));
        }
        allTabKeys.add("1404221671421785088");
        items.add(UserGroupService.createTabPageApItem("1404221671421785088", new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"UserGroupService_16", (String)systemType, (Object[])new Object[0]))));
        tab.addControls(items);
        view.getPageCache().put("pageCache_tabKeys", JSON.toJSONString(allTabKeys));
        view.getPageCache().put("pageCache_firstTabKey", firstStdId);
        if ("1404221671421785088".equals(selectedTab) || tabStillExist) {
            tab.selectTab(selectedTab);
            tab.activeTab(selectedTab);
        } else {
            tab.selectTab(firstStdId);
            tab.activeTab(firstStdId);
        }
    }

    public static void addSearchTab(Tab tab, IFormView view) {
        view.getPageCache().put("pageCache_isSearchMode", "1");
        List<String> tabKeys = new ArrayList(10);
        String pageCache_tabKeys = view.getPageCache().get("pageCache_tabKeys");
        if (StringUtils.isNotEmpty((String)pageCache_tabKeys)) {
            if (pageCache_tabKeys.contains("searchresult")) {
                tab.selectTab("searchresult");
                tab.activeTab("searchresult");
                return;
            }
            tabKeys = (List)JSON.parseObject((String)pageCache_tabKeys, List.class);
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        items.add(UserGroupService.createTabPageApItem("searchresult", new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u7ed3\u679c", (String)"UserGroupService_17", (String)systemType, (Object[])new Object[0]))));
        tab.insertControls(tabKeys.size(), items);
        if (!tabKeys.isEmpty()) {
            tabKeys.add("searchresult");
            view.getPageCache().put("pageCache_tabKeys", JSON.toJSONString(tabKeys));
        }
        tab.selectTab("searchresult");
        tab.activeTab("searchresult");
    }

    public static void exitSearchMode(Tab tab, IFormView view) {
        view.getPageCache().remove("pageCache_isSearchMode");
        String pageCache_firstTabKey = view.getPageCache().get("pageCache_firstTabKey");
        tab.deleteControls(new String[]{"searchresult"});
        String pageCache_tabKeys = view.getPageCache().get("pageCache_tabKeys");
        if (StringUtils.isNotEmpty((String)pageCache_tabKeys)) {
            List tabKeys = (List)JSON.parseObject((String)pageCache_tabKeys, List.class);
            tabKeys.remove("searchresult");
            view.getPageCache().put("pageCache_tabKeys", JSON.toJSONString((Object)tabKeys));
        }
        tab.selectTab(pageCache_firstTabKey);
        tab.activeTab(pageCache_firstTabKey);
    }

    private static Map<String, Object> createTabPageApItem(String key, LocaleString name) {
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey(key);
        tabPageAp.setName(name);
        return tabPageAp.createControl();
    }

    public static void tabSelected(String tabKey, IFormView view, IDataModel model) {
        if (StringUtils.isEmpty((String)tabKey)) {
            return;
        }
        view.getPageCache().put("pageCache_selectedTab", tabKey);
        if ("searchresult".equals(tabKey)) {
            String pageCache_searchResultIds;
            model.beginInit();
            model.deleteEntryData("treeentryentity");
            if (view.getControl("entryentity") != null) {
                model.deleteEntryData("entryentity");
            }
            if (StringUtils.isEmpty((String)(pageCache_searchResultIds = view.getPageCache().get("pageCache_searchResultIds")))) {
                return;
            }
            List searchIdsList = (List)JSON.parseObject((String)pageCache_searchResultIds, List.class);
            TableValueSetter vs = new TableValueSetter(new String[]{"id", "pid", "usrgrp"});
            for (Long usrGrpId : searchIdsList) {
                vs.addRow(new Object[]{usrGrpId, "0", usrGrpId});
            }
            ((AbstractFormDataModel)model).batchCreateNewEntryRow("treeentryentity", vs);
            model.endInit();
            view.updateView("treeentryentity");
            view.updateView("entryentity");
            return;
        }
        model.beginInit();
        model.deleteEntryData("treeentryentity");
        TableValueSetter vs = new TableValueSetter(new String[]{"id", "pid", "usrgrp"});
        QFilter qFilter = new QFilter(USERGROUP_USRGRPSTD, "=", (Object)Long.valueOf(tabKey));
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] groupObjs = BusinessDataServiceHelper.load((String)USERGROUP_MAIN_ENTITY_TYPE, (String)"id", (QFilter[])filters);
        if (UserGroupService.isMultiInheritance(tabKey)) {
            for (DynamicObject group : groupObjs) {
                String id = group.getString("id");
                vs.addRow(new Object[]{id, "0", id});
            }
        } else {
            qFilter = new QFilter("parent.usrgrpstd", "=", (Object)Long.valueOf(tabKey));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)String.join((CharSequence)",", USERGROUP_INH_PROP_PARENT_ID, USERGROUP_INH_PROP_CHILDREN_ID), (QFilter[])new QFilter[]{qFilter});
            HashSet<String> childGroupIds = new HashSet<String>(dynamicObjects.length);
            for (DynamicObject object : dynamicObjects) {
                String parentId = object.getString(USERGROUP_INH_PROP_PARENT_ID);
                String childId = object.getString(USERGROUP_INH_PROP_CHILDREN_ID);
                childGroupIds.add(childId);
                vs.addRow(new Object[]{childId, parentId, childId});
            }
            for (DynamicObject group : groupObjs) {
                String curGrpId = group.getString("id");
                if (childGroupIds.contains(curGrpId)) continue;
                vs.addRow(new Object[]{curGrpId, "0", curGrpId});
            }
        }
        ((AbstractFormDataModel)model).batchCreateNewEntryRow("treeentryentity", vs);
        model.endInit();
        view.updateView("treeentryentity");
    }

    public static void hyperLinkClick(int rowIndex, IFormView view, TreeEntryGrid treeEntryGrid, CloseCallBack closeCallBack) {
        EntryData entryData = treeEntryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        if (dataEntitys != null) {
            DynamicObject dataEntity = dataEntitys[rowIndex];
            Long usrGrpId = dataEntity.getLong("id");
            String parentPageId = view.getPageId();
            String prePageId = parentPageId + "_showForm_userGroupList_" + usrGrpId;
            IFormView iformView = view.getViewNoPlugin(prePageId);
            if (iformView != null) {
                PermCommonUtil.redirectToExistedPage((String)prePageId, (IFormView)view);
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId(USERGROUP_MAIN_ENTITY_TYPE);
            bsp.setPkId((Object)usrGrpId);
            bsp.setStatus(OperationStatus.EDIT);
            bsp.setPageId(prePageId);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setCloseCallBack(closeCallBack);
            StringBuilder failInfo = new StringBuilder();
            if (MutexHelper.require((String)USERGROUP_MAIN_ENTITY_TYPE, (Object)usrGrpId, (String)"modifyusrgrp", (StringBuilder)failInfo)) {
                bsp.setStatus(OperationStatus.EDIT);
            } else {
                bsp.setStatus(OperationStatus.VIEW);
                bsp.setCustomParam("mutexMes", (Object)failInfo.toString());
            }
            view.showForm((FormShowParameter)bsp);
        }
    }

    public static void deleteUsrGrpRelatedData(Long usrGrpId) {
        DeleteServiceHelper.delete((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter(USERGROUP_INH_PROP_PARENT, "=", (Object)usrGrpId).or(new QFilter(USERGROUP_INH_PROP_CHILDREN, "=", (Object)usrGrpId))});
        DeleteServiceHelper.delete((String)"bos_usergroupstaff", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        DeleteServiceHelper.delete((String)USERGROUP_MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)usrGrpId)});
        DeleteServiceHelper.delete((String)"perm_usrgrpbusirole", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        EventCenterService.deleteUsrGrpEventData(usrGrpId);
        DeleteServiceHelper.delete((String)PERM_USRGRPSYNC_RULE, (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        DeleteServiceHelper.delete((String)"perm_usrgrprole", (QFilter[])new QFilter[]{new QFilter("usrgrpid", "=", (Object)usrGrpId)});
    }

    public static Map<Object, DynamicObject> getUsrGrpObjById(List<Long> usrGrpIds) {
        if (CollectionUtils.isEmpty(usrGrpIds)) {
            return new HashMap<Object, DynamicObject>(1);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])usrGrpIds.toArray(), (String)USERGROUP_MAIN_ENTITY_TYPE);
    }

    public static Set<String> getDimUsrGrpStrSet(Set<String> roleIdSet, Set<String> queryDBDimTypeSet, Set<Long> queryDBDimIdSet, Set<Long> queryDBUsrGrpIdSet, boolean containRole) {
        StringBuilder sql = new StringBuilder("select fdimid, fdimtype, fusrgrpid,froleid from t_perm_usrgrprole where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            String roleIdSetStr = String.join((CharSequence)"','", roleIdSet);
            sql.append(" and froleid in ('").append(roleIdSetStr).append("')");
        }
        if (null != queryDBDimTypeSet && !queryDBDimTypeSet.isEmpty()) {
            List queryDBDimTypeList = queryDBDimTypeSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBDimTypeStr = String.join((CharSequence)"','", queryDBDimTypeList);
            sql.append(" and fdimtype in ('").append(queryDBDimTypeStr).append("')");
        }
        if (null != queryDBUsrGrpIdSet && !queryDBUsrGrpIdSet.isEmpty()) {
            List queryDBUserIdList = queryDBUsrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBUserIdStr = String.join((CharSequence)",", queryDBUserIdList);
            sql.append(" and fusrgrpid in (").append(queryDBUserIdStr).append(")");
        }
        if (null != queryDBDimIdSet && !queryDBDimIdSet.isEmpty()) {
            List queryDBDimIdList = queryDBDimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBDimIdStr = String.join((CharSequence)",", queryDBDimIdList);
            sql.append(" and fdimid in (").append(queryDBDimIdStr).append(")");
        }
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), resultSet -> {
            HashSet<String> set = new HashSet<String>(8);
            while (resultSet.next()) {
                long fdimid = resultSet.getLong("fdimid");
                String fdimtype = resultSet.getString("fdimtype");
                if (containRole) {
                    String froleid = resultSet.getString("froleid");
                    set.add(fdimtype + "$" + fdimid + "$" + froleid);
                    continue;
                }
                long fusrgrpid = resultSet.getLong("fusrgrpid");
                set.add(fdimtype + "$" + fdimid + "$" + fusrgrpid);
            }
            return set;
        });
    }
}

