/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.BaseUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.model.Position;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class UserPositionSaveServiceImpl {
    private static final String BOS_POSITION = "bos_position";
    private static final String SUPERIOR_POSITION = "superiorposition";
    private final List<Position> addOrUpdatePositionList;

    public UserPositionSaveServiceImpl(List<Position> addOrUpdatePositionList) {
        this.addOrUpdatePositionList = addOrUpdatePositionList;
    }

    public OperationResult save() {
        if (CollectionUtils.isEmpty(this.addOrUpdatePositionList)) {
            return this.addErrorMsg(ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a\u6216\u8005null\u3002", (String)"UserPositionSaveServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        int count = this.addOrUpdatePositionList.size();
        ArrayList<Long> positionIdsList = new ArrayList<Long>(count);
        ArrayList<Long> dptIdsList = new ArrayList<Long>(count);
        ArrayList<Long> supPositionIdsList = new ArrayList<Long>(count);
        int createIdCount = 0;
        for (Position position : this.addOrUpdatePositionList) {
            long spId;
            long id = position.getId();
            if (id != 0L) {
                positionIdsList.add(id);
            } else {
                ++createIdCount;
            }
            long dptId = position.getDptId();
            if (dptId != 0L) {
                dptIdsList.add(dptId);
            }
            if ((spId = position.getSuperiorPositionId()) == 0L) continue;
            supPositionIdsList.add(spId);
        }
        Map<Long, DynamicObject> positionObjMap = this.getPositionFromDatabase(positionIdsList);
        Map<Object, DynamicObject> dpyObjMap = this.getFromDatabase(dptIdsList, "dpt");
        Map<Object, DynamicObject> supPositionObjMap = this.getFromDatabase(supPositionIdsList, SUPERIOR_POSITION);
        ArrayList<DynamicObject> positionObjList = new ArrayList<DynamicObject>(count);
        this.getPositionObjList(positionObjMap, dpyObjMap, supPositionObjMap, createIdCount, positionObjList);
        if (supPositionObjMap.isEmpty()) {
            return this.addErrorMsg(ResManager.loadKDString((String)"\u9700\u8981\u4fdd\u5b58\u7684\u5c97\u4f4d\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"UserPositionSaveServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        OperateOption operateOption = BaseUtils.getOperateOption((boolean)true);
        return OperationServiceHelper.executeOperate((String)"save", (String)BOS_POSITION, (DynamicObject[])positionObjList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
    }

    private Map<Long, DynamicObject> getPositionFromDatabase(List<Long> positionIdsList) {
        int positionCount = positionIdsList.size();
        HashMap<Long, DynamicObject> positionObjMap = new HashMap<Long, DynamicObject>(positionCount);
        if (positionCount == 0) {
            return positionObjMap;
        }
        MainEntityType positionType = EntityMetadataCache.getDataEntityType((String)BOS_POSITION);
        DynamicObject[] dbPositionArr = BusinessDataServiceHelper.load((Object[])positionIdsList.toArray(new Long[0]), (DynamicObjectType)positionType);
        if (dbPositionArr != null) {
            for (DynamicObject dbPosition : dbPositionArr) {
                positionObjMap.put(dbPosition.getLong("id"), dbPosition);
            }
        }
        return positionObjMap;
    }

    private Map<Object, DynamicObject> getFromDatabase(List<Long> idsList, String type) {
        int count = idsList.size();
        if (count == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        BasedataProp typeProp = (BasedataProp)EntityMetadataCache.getDataEntityType((String)BOS_POSITION).getProperty(type);
        return BusinessDataServiceHelper.loadFromCache((Object[])idsList.toArray(new Object[]{0}), (DynamicObjectType)((DynamicObjectType)typeProp.getComplexType()));
    }

    private void getPositionObjList(Map<Long, DynamicObject> positionObjMap, Map<Object, DynamicObject> dpyObjMap, Map<Object, DynamicObject> supPositionObjMap, int createIdCount, List<DynamicObject> positionObjList) {
        ORM orm = ORM.create();
        long[] newIds = new long[createIdCount];
        if (createIdCount != 0) {
            newIds = orm.genLongIds(BOS_POSITION, createIdCount);
        }
        HashMap<Long, DynamicObject> supPositionIsNullList = new HashMap<Long, DynamicObject>(createIdCount);
        for (Position position : this.addOrUpdatePositionList) {
            long id = position.getId();
            DynamicObject positionObj = positionObjMap.get(id);
            if (positionObj == null) {
                positionObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_POSITION);
                if (id == 0L) {
                    id = this.getId(--createIdCount, orm, newIds);
                }
                positionObj.set("id", (Object)id);
                positionObj.set("enable", (Object)(position.isEnable() ? "1" : "0"));
                positionObj.set("status", (Object)"C");
            }
            this.parsePosition(position, positionObj, dpyObjMap, supPositionObjMap, supPositionIsNullList);
            supPositionObjMap.put(id, positionObj);
            positionObjList.add(positionObj);
        }
        if (CollectionUtils.isEmpty(supPositionIsNullList)) {
            return;
        }
        for (Map.Entry entry : supPositionIsNullList.entrySet()) {
            long supId = (Long)entry.getKey();
            DynamicObject supPosition = supPositionObjMap.get(supId);
            DynamicObject position = (DynamicObject)entry.getValue();
            if (position == null) continue;
            position.set(SUPERIOR_POSITION, (Object)supPosition);
        }
    }

    private long getId(int createIdCount, ORM orm, long[] newIds) {
        long id = createIdCount < 0 ? orm.genLongId(BOS_POSITION) : newIds[createIdCount];
        return id;
    }

    private void parsePosition(Position position, DynamicObject positionObj, Map<Object, DynamicObject> dpyObjMap, Map<Object, DynamicObject> supPositionObjMap, Map<Long, DynamicObject> supPositionIsNullList) {
        ILocaleString remarks;
        Boolean isMainPosition;
        long superiorPositionId;
        long dptId;
        ILocaleString name;
        String number = position.getNumber();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            positionObj.set("number", (Object)number);
        }
        if (StringUtils.isNotBlank((Object)(name = position.getName()))) {
            positionObj.set("name", (Object)name);
        }
        if ((dptId = position.getDptId()) != 0L) {
            DynamicObject dptObj = dpyObjMap.get(dptId);
            positionObj.set("dpt", (Object)dptObj);
        }
        if ((superiorPositionId = position.getSuperiorPositionId()) != 0L) {
            DynamicObject superiorPositionObj = supPositionObjMap.get(superiorPositionId);
            if (superiorPositionObj == null) {
                supPositionIsNullList.put(superiorPositionId, positionObj);
            } else {
                positionObj.set(SUPERIOR_POSITION, (Object)superiorPositionObj);
            }
        }
        if ((isMainPosition = position.isMainPosition()) != null) {
            positionObj.set("ismainposition", (Object)isMainPosition);
        }
        if ((remarks = position.getRemarks()) != null) {
            positionObj.set("remarks", (Object)remarks);
        }
    }

    private OperationResult addErrorMsg(String msg) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(false);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(msg);
        operationResult.getAllErrorInfo().add(operateErrorInfo);
        return operationResult;
    }
}

