/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.imp.UserComRoleImportBean;
import kd.bos.permission.model.perm.req.DimRoleReq;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.RoleAssignUserDimReq;
import kd.bos.permission.model.perm.req.UserAssignDimRoleReq;
import kd.bos.permission.model.perm.req.UserDimReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.PermCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserComRoleAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserComRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.userrole.GetUserRoleDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.model.perm.userrole.UserRoleDim;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class UserRoleService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UserRoleService.class);
    private static final String SYSTERM_TYPE = "bos-mservice-permission";

    private static Map<String, Object> userRoleDimAssignCheck(List<RoleAssignUserDimReq> reqList) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        String lineSep = System.getProperty("line.separator");
        StringBuilder resultMsg = new StringBuilder();
        if (CollectionUtils.isEmpty(reqList)) {
            resultMsg.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570%1$s\u4e3a\u7a7a\u3002%2$s", (String)"UserRoleService_0", (String)SYSTERM_TYPE, (Object[])new Object[0]), "reqList", lineSep));
            log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
            map.put("purAddMap", new HashMap(1));
            map.put("addRoleIds", new HashSet(1));
            map.put("addRoleIdUserIdsMap", new HashMap(1));
            map.put("addDimIds", new HashSet(1));
            map.put("addDimTypes", new HashSet(1));
            map.put("purDelMap", new HashMap(1));
            map.put("delRoleIds", new HashSet(1));
            map.put("delRoleIdUserIdsMap", new HashMap(1));
            map.put("delDimIds", new HashSet(1));
            map.put("delDimTypes", new HashSet(1));
            map.put("resultMsg", resultMsg);
            return map;
        }
        int reqListSize = reqList.size();
        Map permCtrlTypeMap = IsoDimHelper.permCtrlTypeMap();
        HashSet roleIdSet = new HashSet(reqListSize);
        HashSet dimTypeSet = new HashSet(6);
        HashSet userIdSet = new HashSet(reqListSize);
        HashSet dimIdSet = new HashSet(reqListSize);
        reqList.stream().forEach(x -> {
            roleIdSet.add(x.getRoleId());
            String dimType = x.getDimType();
            if (IsoDimHelper.validateDimType((String)dimType, (Map)permCtrlTypeMap)) {
                dimTypeSet.add(dimType);
            }
            if (!CollectionUtils.isEmpty((Collection)x.getAddList())) {
                x.getAddList().stream().forEach(y -> {
                    userIdSet.add(y.getUserId());
                    dimIdSet.add(y.getDimId());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)x.getDelList())) {
                x.getDelList().stream().forEach(y -> {
                    userIdSet.add(y.getUserId());
                    dimIdSet.add(y.getDimId());
                });
            }
        });
        Map roleMapDBCache = BusinessDataServiceHelper.loadFromCache((Object[])roleIdSet.toArray(new Object[roleIdSet.size()]), (String)"perm_role");
        Map userMapDBCache = BusinessDataServiceHelper.loadFromCache((Object[])userIdSet.toArray(new Object[userIdSet.size()]), (String)"bos_user");
        HashMap dimTypeMapDBCache = new HashMap(dimTypeSet.size());
        dimTypeSet.stream().forEach(x -> {
            String dimSelectProps = IsoDimHelper.getDimSelectProps((String)x);
            Map dimDynMap = IsoDimHelper.getDimDynMap(new ArrayList(dimIdSet), (String)x, (String)dimSelectProps);
            dimTypeMapDBCache.put(x, dimDynMap);
        });
        HashMap<String, Object[]> purAddMap = new HashMap<String, Object[]>(256);
        HashSet<String> addRoleIds = new HashSet<String>(16);
        HashMap<String, Set> addRoleIdUserIdsMap = new HashMap<String, Set>(8);
        HashSet<Long> addDimIds = new HashSet<Long>(32);
        HashSet<String> addDimTypes = new HashSet<String>(8);
        HashMap<String, Object[]> purDelMap = new HashMap<String, Object[]>(16);
        HashSet<String> delRoleIds = new HashSet<String>(16);
        HashMap<String, Set> delRoleIdUserIdsMap = new HashMap<String, Set>(8);
        HashSet<Long> delDimIds = new HashSet<Long>(32);
        HashSet<String> delDimTypes = new HashSet<String>(8);
        StringBuilder key = null;
        for (int i = 0; i < reqList.size(); ++i) {
            Long dimId;
            Long userId;
            RoleAssignUserDimReq req = reqList.get(i);
            String roleId = req.getRoleId();
            if (StringUtils.isEmpty((String)roleId)) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\uff0c\u89d2\u8272id\u4e3a\u7a7a\u3002%2$s", (String)"UserRoleService_1", (String)SYSTERM_TYPE, (Object[])new Object[0]), i, lineSep));
                log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                continue;
            }
            if (null == roleMapDBCache.get(roleId)) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272id\u4e3a[%1$s]\u7684\u89d2\u8272\u4e0d\u5b58\u5728\u3002%2$s", (String)"UserRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, lineSep));
                log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                continue;
            }
            String dimType = req.getDimType();
            if (StringUtils.isEmpty((String)dimType)) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272id[%1$s]\u7684\u9694\u79bb\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7a7a\u3002%2$s", (String)"UserRoleService_3", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, lineSep));
                log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                continue;
            }
            if (!IsoDimHelper.validateDimType((String)dimType, (Map)permCtrlTypeMap)) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272id[%1$s]\u7684\u9694\u79bb\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002%2$s", (String)"UserRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, lineSep));
                log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                continue;
            }
            Map dimDynMap = (Map)dimTypeMapDBCache.get(dimType);
            List addList = req.getAddList();
            List delList = req.getDelList();
            if (CollectionUtils.isEmpty((Collection)addList) && CollectionUtils.isEmpty((Collection)delList)) {
                resultMsg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272id[%1$s]\uff0c\u65e0\u76f8\u5173\u4e1a\u52a1\u6570\u636e\u53d8\u66f4\u3002%2$s", (String)"UserRoleService_5", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, lineSep));
                log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)addList)) {
                for (UserDimReq userDimReq : addList) {
                    userId = userDimReq.getUserId();
                    if (null == userMapDBCache.get(userId)) {
                        resultMsg.append(String.format(ResManager.loadKDString((String)"\u5bf9\u89d2\u8272[%1$s]\u7684\u5206\u914d\u4e2d\uff0c\u7528\u6237[%2$s]\uff0c\u4e0d\u5b58\u5728\u3002%3$s", (String)"UserRoleService_6", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, userId, lineSep));
                        log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                        continue;
                    }
                    dimId = userDimReq.getDimId();
                    if (null == dimDynMap.get(dimId)) {
                        resultMsg.append(String.format(ResManager.loadKDString((String)"\u5bf9\u89d2\u8272[%1$s]\u7684\u5206\u914d\u4e2d\uff0c\u9694\u79bb\u7ef4\u5ea6[%2$s]\uff0c\u4e0d\u5b58\u5728\u3002%3$s", (String)"UserRoleService_7", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, userId, lineSep));
                        log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                        continue;
                    }
                    key = new StringBuilder();
                    key.append(roleId).append("@@");
                    key.append(userId).append("@@");
                    key.append(dimId).append("@@");
                    key.append(dimType);
                    purAddMap.put(key.toString(), new Object[]{userDimReq.getIncludeSub(), userDimReq.getStartTime(), userDimReq.getEndTime(), userDimReq.getFromTypeDesc()});
                    addRoleIds.add(roleId);
                    addRoleIdUserIdsMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(userId);
                    addDimIds.add(dimId);
                    addDimTypes.add(dimType);
                }
            }
            if (CollectionUtils.isEmpty((Collection)delList)) continue;
            for (UserDimReq userDimReq : delList) {
                userId = userDimReq.getUserId();
                if (null == userMapDBCache.get(userId)) {
                    resultMsg.append(String.format(ResManager.loadKDString((String)"\u5bf9\u89d2\u8272[%1$s]\u7684\u5220\u9664\u5206\u914d\u4e2d\uff0c\u7528\u6237[%2$s]\uff0c\u4e0d\u5b58\u5728\u3002%3$s", (String)"UserRoleService_8", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, userId, lineSep));
                    log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                    continue;
                }
                dimId = userDimReq.getDimId();
                if (null == dimDynMap.get(dimId)) {
                    resultMsg.append(String.format(ResManager.loadKDString((String)"\u5bf9\u89d2\u8272[%1$s]\u7684\u5220\u9664\u5206\u914d\u4e2d\uff0c\u9694\u79bb\u7ef4\u5ea6[%2$s]\uff0c\u4e0d\u5b58\u5728\u3002%3$s", (String)"UserRoleService_9", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleId, userId, lineSep));
                    log.warn("UserRoleService.userRoleDimAssignCheck, {}", (Object)resultMsg);
                    continue;
                }
                key = new StringBuilder();
                key.append(roleId).append("@@");
                key.append(userId).append("@@");
                key.append(dimId).append("@@");
                key.append(dimType);
                purDelMap.put(key.toString(), new Object[]{userDimReq.getIncludeSub(), userDimReq.getStartTime(), userDimReq.getEndTime()});
                delRoleIds.add(roleId);
                delRoleIdUserIdsMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(userId);
                delDimIds.add(dimId);
                delDimTypes.add(dimType);
            }
        }
        map.put("purAddMap", purAddMap);
        map.put("addRoleIds", addRoleIds);
        map.put("addRoleIdUserIdsMap", addRoleIdUserIdsMap);
        map.put("addDimIds", addDimIds);
        map.put("addDimTypes", addDimTypes);
        map.put("purDelMap", purDelMap);
        map.put("delRoleIds", delRoleIds);
        map.put("delRoleIdUserIdsMap", delRoleIdUserIdsMap);
        map.put("delDimIds", delDimIds);
        map.put("delDimTypes", delDimTypes);
        map.put("resultMsg", resultMsg);
        return map;
    }

    private static Map<String, Object> userRoleDimAssign(List<RoleAssignUserDimReq> reqList) throws Exception {
        Map delRoleIdUserIdsMap;
        HashSet delUserIds;
        Map<String, Object> checkMap = UserRoleService.userRoleDimAssignCheck(reqList);
        Map purAddMap = (Map)checkMap.get("purAddMap");
        Map purDelMap = (Map)checkMap.get("purDelMap");
        StringBuilder resultMsg = (StringBuilder)checkMap.get("resultMsg");
        if (CollectionUtils.isEmpty((Map)purAddMap) && CollectionUtils.isEmpty((Map)purDelMap)) {
            throw new Exception(resultMsg.toString());
        }
        ArrayList<DynamicObject> forInsertObjs = null;
        ArrayList<DynamicObject> forUpdateObjs = null;
        HashSet<String> forDelFids = new HashSet<String>(8);
        ArrayList<PermUserRole> delList = new ArrayList<PermUserRole>(8);
        Map addRoleIdUserIdsMap = (Map)checkMap.get("addRoleIdUserIdsMap");
        HashSet addUserIds = null == addRoleIdUserIdsMap ? new HashSet(0) : addRoleIdUserIdsMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        Set addRoleIds = (Set)checkMap.get("addRoleIds");
        Set delRoleIds = (Set)checkMap.get("delRoleIds");
        if (!CollectionUtils.isEmpty((Map)purAddMap)) {
            int addSize = purAddMap.size();
            forInsertObjs = new ArrayList<DynamicObject>(addSize);
            forUpdateObjs = new ArrayList<DynamicObject>(addSize);
            Set addDimIds = (Set)checkMap.get("addDimIds");
            Set addDimTypes = (Set)checkMap.get("addDimTypes");
            Map purDBAddMap = OrgUserHelper.getByDimAndOtherMap((Set)addRoleIds, null, addUserIds, (Set)addDimIds, (Set)addDimTypes);
            DynamicObject dynObj = null;
            long currUserId = RequestContext.get().getCurrUserId();
            Date curTime = new Date();
            for (Map.Entry one : purAddMap.entrySet()) {
                String key = (String)one.getKey();
                String[] keySplit = key.split("@@");
                Object[] value = (Object[])one.getValue();
                List objList = (List)purDBAddMap.get(key);
                Object includeSubOrg = value[0];
                Object startTime = value[1];
                Object endTime = value[2];
                String source = "2";
                Object fromTypeDesc = value[3];
                long bizRoleId = 0L;
                if (CollectionUtils.isEmpty((Collection)objList)) {
                    dynObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole_multype");
                    dynObj.set("includesuborg", includeSubOrg);
                    dynObj.set("starttime", startTime);
                    dynObj.set("endtime", endTime);
                    dynObj.set("source", (Object)source);
                    dynObj.set("bizroleid", (Object)bizRoleId);
                    dynObj.set("fromtypedesc", fromTypeDesc);
                    dynObj.set("creator", (Object)currUserId);
                    dynObj.set("createtime", (Object)curTime);
                    dynObj.set("modifier", (Object)currUserId);
                    dynObj.set("modifytime", (Object)curTime);
                    dynObj.set("role", (Object)keySplit[0]);
                    dynObj.set("user", (Object)keySplit[1]);
                    dynObj.set("itemclass", (Object)keySplit[2]);
                    dynObj.set("itemclasstypefield", (Object)keySplit[3]);
                    forInsertObjs.add(dynObj);
                    continue;
                }
                DynamicObject first = (DynamicObject)objList.get(0);
                first.set("includesuborg", includeSubOrg);
                first.set("starttime", startTime);
                first.set("endtime", endTime);
                first.set("source", (Object)source);
                first.set("bizroleid", (Object)bizRoleId);
                first.set("fromtypedesc", fromTypeDesc);
                first.set("modifier", (Object)currUserId);
                first.set("modifytime", (Object)curTime);
                forUpdateObjs.add(first);
                if (objList.size() <= 1) continue;
                List subList = objList.subList(1, objList.size());
                for (DynamicObject justOne : subList) {
                    forDelFids.add(justOne.getString("id"));
                    delList.add(PermUserRole.userrole2pur((DynamicObject)justOne));
                }
            }
        }
        Set<Object> set = delUserIds = null == (delRoleIdUserIdsMap = (Map)checkMap.get("delRoleIdUserIdsMap")) ? new HashSet(0) : delRoleIdUserIdsMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Map)purDelMap)) {
            Set delDimIds = (Set)checkMap.get("delDimIds");
            Set delDimTypes = (Set)checkMap.get("delDimTypes");
            Map purDBDelMap = OrgUserHelper.getByDimAndOtherMap((Set)delRoleIds, null, delUserIds, (Set)delDimIds, (Set)delDimTypes);
            for (Map.Entry one : purDelMap.entrySet()) {
                String key = (String)one.getKey();
                List objList = (List)purDBDelMap.get(key);
                if (CollectionUtils.isEmpty((Collection)objList)) continue;
                for (DynamicObject justOne : objList) {
                    forDelFids.add(justOne.getString("id"));
                    delList.add(PermUserRole.userrole2pur((DynamicObject)justOne));
                }
            }
        }
        boolean dataChange = false;
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!CollectionUtils.isEmpty(forInsertObjs)) {
                    SaveServiceHelper.save((DynamicObject[])forInsertObjs.toArray(new DynamicObject[0]));
                    dataChange = true;
                }
                if (!CollectionUtils.isEmpty(forUpdateObjs)) {
                    SaveServiceHelper.update((DynamicObject[])forUpdateObjs.toArray(new DynamicObject[0]));
                    dataChange = true;
                }
                if (!CollectionUtils.isEmpty(forDelFids)) {
                    DeleteServiceHelper.delete((String)"perm_userrole_multype", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelFids)});
                    dataChange = true;
                }
            }
            catch (Exception e1) {
                h.markRollback();
                log.warn("UserRoleService.userRoleDimAssign tx error", (Throwable)e1);
                resultMsg.append(e1.getLocalizedMessage());
                throw new Exception(resultMsg.toString(), e1);
            }
            finally {
                if (dataChange && !CollectionUtils.isEmpty(reqList)) {
                    UserRoleService.userRoleRelateChangeBusi(addRoleIdUserIdsMap, delRoleIdUserIdsMap, addRoleIds, delRoleIds);
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("forInsertObjs", forInsertObjs);
        map.put("forUpdateObjs", forUpdateObjs);
        map.put("delList", delList);
        map.put("resultMsg", resultMsg);
        map.put("dataChange", dataChange);
        return map;
    }

    private static PermResult userRoleRelateChangeBusi(Map<String, Set<Long>> addRoleIdUserIdsMap, Map<String, Set<Long>> delRoleIdUserIdsMap, Set<String> addRoleIds, Set<String> delRoleIds) {
        try {
            addRoleIdUserIdsMap = null == addRoleIdUserIdsMap ? new HashMap(1) : addRoleIdUserIdsMap;
            delRoleIdUserIdsMap = null == delRoleIdUserIdsMap ? new HashMap(1) : delRoleIdUserIdsMap;
            addRoleIds = null == addRoleIds ? new HashSet(1) : addRoleIds;
            delRoleIds = null == delRoleIds ? new HashSet(1) : delRoleIds;
            Map roleIdAppEntSetMap = PermRoleHelper.getRoleIdAppEntSetMap(addRoleIds);
            HashMap appEntityMap = null;
            for (Map.Entry addRoleIdUserIds : addRoleIdUserIdsMap.entrySet()) {
                Map roleIdAppEntSet;
                Iterator roleId = (String)addRoleIdUserIds.getKey();
                Set userIds = (Set)addRoleIdUserIds.getValue();
                if (null == roleId || ((String)((Object)roleId)).isEmpty() || null == userIds || userIds.isEmpty() || null == (roleIdAppEntSet = (Map)roleIdAppEntSetMap.get(roleId)) || roleIdAppEntSet.isEmpty()) continue;
                appEntityMap = new HashMap(roleIdAppEntSet.size());
                for (Map.Entry roleIdAppEnt : roleIdAppEntSet.entrySet()) {
                    appEntityMap.put(roleIdAppEnt.getKey(), new ArrayList((Collection)roleIdAppEnt.getValue()));
                }
                LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(userIds), appEntityMap);
            }
            if (null != addRoleIdUserIdsMap && !addRoleIdUserIdsMap.isEmpty() || null != delRoleIdUserIdsMap && !delRoleIdUserIdsMap.isEmpty() || null != addRoleIds && !addRoleIds.isEmpty() || null != delRoleIds && !delRoleIds.isEmpty()) {
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
            }
            HashSet allUserIdSet = new HashSet(8);
            HashMap<String, Set> allRoleIdUserIdsMap = new HashMap<String, Set>(8);
            for (Map.Entry one : addRoleIdUserIdsMap.entrySet()) {
                allRoleIdUserIdsMap.computeIfAbsent((String)one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
                allUserIdSet.addAll((Collection)one.getValue());
            }
            for (Map.Entry one : delRoleIdUserIdsMap.entrySet()) {
                allRoleIdUserIdsMap.computeIfAbsent((String)one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
                allUserIdSet.addAll((Collection)one.getValue());
            }
            UserHasPermOrgCache.clearUserLoginOrgs(allUserIdSet);
            addRoleIds.addAll(delRoleIds);
            String langStr = RequestContext.get().getLang().name();
            Map newDrPermSetDBMap = PermRoleHelper.getNewDrPermSetMap(addRoleIds, null);
            Map newDrPrPermSetDBMap = PermRoleHelper.getNewDrPrPermSetMap(addRoleIds, null);
            for (String roleId : addRoleIds) {
                Set userIdSet = (Set)allRoleIdUserIdsMap.get(roleId);
                if (null == userIdSet || userIdSet.isEmpty()) continue;
                Set appEntityAllSet = new Set(8);
                boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
                if (hasEnableRoleDataRuleNewModel) {
                    Set newDrPerms = null == newDrPermSetDBMap.get(roleId) ? new HashSet(0) : (Set)newDrPermSetDBMap.get(roleId);
                    Set newDrPrPerms = null == newDrPrPermSetDBMap.get(roleId) ? new HashSet(0) : (Set)newDrPrPermSetDBMap.get(roleId);
                    appEntityAllSet.addAll(newDrPerms.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
                    appEntityAllSet.addAll(newDrPrPerms.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
                } else {
                    LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)langStr);
                    appEntityAllSet = null == newDataRule ? new HashSet(0) : newDataRule.getNewDRAppEntitySet();
                }
                ArrayList appEntityAllList = new ArrayList(10);
                HashMap<String, String> mm = null;
                for (String appEntity : appEntityAllSet) {
                    String[] split = appEntity.split("\\|", 2);
                    if (null == split || 0 == split.length) continue;
                    String appId = split[0];
                    String entNum = split[1];
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum)) continue;
                    mm = new HashMap<String, String>(1);
                    mm.put(appId, entNum);
                    appEntityAllList.add(mm);
                }
                PermCommonUtil.cancelShowForm(new ArrayList(userIdSet), appEntityAllList, (boolean)false);
            }
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserRoleService.userRoleRelateChangeBusi error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    private static void roleAssignUserDim2PermLog(List<DynamicObject> forInsertObjs, List<DynamicObject> forUpdateObjs, List<PermUserRole> delList, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            List listAvg;
            int m;
            permLogReq.check(false);
            if (null != forInsertObjs && !forInsertObjs.isEmpty() && forInsertObjs.size() > 0) {
                m = SqlUtil.getBatchCount((Integer)PermHelperConst.CONST_10000, (int)forInsertObjs.size());
                listAvg = ListUtil.averageAssign(forInsertObjs, (int)m);
                for (List avg : listAvg) {
                    UserRoleService.roleAssignUserDim2PermLogSplit(avg, null, null, permLogReq);
                }
            }
            if (null != forUpdateObjs && !forUpdateObjs.isEmpty() && forUpdateObjs.size() > 0) {
                m = SqlUtil.getBatchCount((Integer)PermHelperConst.CONST_10000, (int)forUpdateObjs.size());
                listAvg = ListUtil.averageAssign(forUpdateObjs, (int)m);
                for (List avg : listAvg) {
                    UserRoleService.roleAssignUserDim2PermLogSplit(null, avg, null, permLogReq);
                }
            }
            if (null != delList && !delList.isEmpty() && delList.size() > 0) {
                m = SqlUtil.getBatchCount((Integer)PermHelperConst.CONST_10000, (int)delList.size());
                listAvg = ListUtil.averageAssign(delList, (int)m);
                for (List avg : listAvg) {
                    UserRoleService.roleAssignUserDim2PermLogSplit(null, null, avg, permLogReq);
                }
            }
        }
        catch (Exception e) {
            log.warn("UserRoleService.roleAssignUserDim2PermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UserRoleService.roleAssignUserDim2PermLog error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }

    private static void roleAssignUserDim2PermLogSplit(List<DynamicObject> forInsertObjs, List<DynamicObject> forUpdateObjs, List<PermUserRole> delList, PermLogReq permLogReq) {
        try {
            forInsertObjs = null == forInsertObjs ? new ArrayList(0) : forInsertObjs;
            forUpdateObjs = null == forUpdateObjs ? new ArrayList(0) : forUpdateObjs;
            delList = null == delList ? new ArrayList(0) : delList;
            HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            diffMap.put("add", new ArrayList(1));
            diffMap.put("update", new ArrayList(1));
            diffMap.put("del", new ArrayList(1));
            if (!CollectionUtils.isEmpty(forInsertObjs)) {
                List addList = forInsertObjs.stream().map(x -> PermUserRole.userrole2pur((DynamicObject)x)).collect(Collectors.toList());
                diffMap.put("add", addList);
            }
            if (!CollectionUtils.isEmpty(forUpdateObjs)) {
                List updateList = forUpdateObjs.stream().map(x -> PermUserRole.userrole2pur((DynamicObject)x)).collect(Collectors.toList());
                diffMap.put("update", updateList);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                diffMap.put("del", delList);
            }
            String formNum = permLogReq.getFormIdentity();
            String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : permLogReq.getAppId();
            String cloudId = StringUtils.isEmpty((String)permLogReq.getCloudId()) ? AppHelper.getMetaAppInfo((String)appId).getCloudId() : permLogReq.getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserRoleService.roleAssignUserDim2PermLogSplit error.", (Throwable)e);
        }
    }

    public static PermResult roleAssignUserDim(List<RoleAssignUserDimReq> reqList, PermLogReq permLogReq) {
        try {
            Map<String, Object> map = UserRoleService.userRoleDimAssign(reqList);
            List forInsertObjs = (List)map.get("forInsertObjs");
            List forUpdateObjs = (List)map.get("forUpdateObjs");
            List delList = (List)map.get("delList");
            StringBuilder resultMsg = (StringBuilder)map.get("resultMsg");
            boolean dataChange = (Boolean)map.get("dataChange");
            if (permLogReq.getSignPermLog().booleanValue() && PermCommonUtil.isEnablePermLog() && dataChange) {
                UserRoleService.roleAssignUserDim2PermLog(forInsertObjs, forUpdateObjs, delList, permLogReq, resultMsg);
            }
            return PermResult.ok((StringBuilder)resultMsg);
        }
        catch (Exception e) {
            log.warn("UserRoleService.roleAssignUserDim, exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    private static List<RoleAssignUserDimReq> UADRReq2RAURReq(List<UserAssignDimRoleReq> reqList) {
        String[] split;
        if (CollectionUtils.isEmpty(reqList)) {
            return new ArrayList<RoleAssignUserDimReq>(1);
        }
        int size = reqList.size();
        HashMap<String, List> addMap = new HashMap<String, List>(size);
        HashMap<String, List> delMap = new HashMap<String, List>(size);
        UserDimReq udr = null;
        for (UserAssignDimRoleReq uadrReq : reqList) {
            Long userId = uadrReq.getUserId();
            String dimType = uadrReq.getDimType();
            List addList = uadrReq.getAddList();
            for (DimRoleReq dimRoleReq : addList) {
                udr = new UserDimReq();
                udr.setUserId(userId);
                udr.setDimId(dimRoleReq.getDimId());
                udr.setIncludeSub(dimRoleReq.getIncludeSub());
                udr.setStartTime(dimRoleReq.getStartTime());
                udr.setEndTime(dimRoleReq.getEndTime());
                udr.setFromTypeDesc(dimRoleReq.getFromTypeDesc());
                addMap.computeIfAbsent(dimRoleReq.getRoleId() + "@@" + dimType, k -> new ArrayList(8)).add(udr);
            }
            List delList = uadrReq.getDelList();
            for (DimRoleReq dimRoleReq : delList) {
                udr = new UserDimReq();
                udr.setUserId(userId);
                udr.setDimId(dimRoleReq.getDimId());
                udr.setIncludeSub(dimRoleReq.getIncludeSub());
                udr.setStartTime(dimRoleReq.getStartTime());
                udr.setEndTime(dimRoleReq.getEndTime());
                delMap.computeIfAbsent(dimRoleReq.getRoleId() + "@@" + dimType, k -> new ArrayList(8)).add(udr);
            }
        }
        ArrayList<RoleAssignUserDimReq> list = new ArrayList<RoleAssignUserDimReq>(8);
        RoleAssignUserDimReq req = null;
        for (Map.Entry add : addMap.entrySet()) {
            req = new RoleAssignUserDimReq();
            String addKey = (String)add.getKey();
            split = addKey.split("@@");
            req.setRoleId(split[0]);
            req.setDimType(split[1]);
            req.setAddList((List)add.getValue());
            req.setDelList((List)delMap.get(addKey));
            list.add(req);
        }
        for (Map.Entry del : delMap.entrySet()) {
            String delKey = (String)del.getKey();
            if (addMap.containsKey(delKey)) continue;
            split = delKey.split("@@");
            req = new RoleAssignUserDimReq();
            req.setRoleId(split[0]);
            req.setDimType(split[1]);
            req.setAddList((List)addMap.get(delKey));
            req.setDelList((List)del.getValue());
            list.add(req);
        }
        return list;
    }

    private static void userAssignDimRole2PermLog(List<DynamicObject> forInsertObjs, List<DynamicObject> forUpdateObjs, List<PermUserRole> delList, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            permLogReq.check(false);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            diffMap.put("add", new ArrayList(1));
            diffMap.put("update", new ArrayList(1));
            diffMap.put("del", delList);
            if (!CollectionUtils.isEmpty(forInsertObjs)) {
                List addList = forInsertObjs.stream().map(x -> PermUserRole.userrole2pur((DynamicObject)x)).collect(Collectors.toList());
                diffMap.put("add", addList);
            }
            if (!CollectionUtils.isEmpty(forUpdateObjs)) {
                List updateList = forUpdateObjs.stream().map(x -> PermUserRole.userrole2pur((DynamicObject)x)).collect(Collectors.toList());
                diffMap.put("update", updateList);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                diffMap.put("del", delList);
            }
            HashMap<String, Object> logMap = new HashMap<String, Object>(2);
            logMap.put("langStr", RequestContext.get().getLang().name());
            logMap.put("diffPURMap", CollectionUtils.isEmpty(diffMap) ? new HashMap<String, Object>(1) : diffMap);
            String formNum = permLogReq.getFormIdentity();
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserRoleService.userAssignDimRole2PermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UserRoleService.userAssignDimRole2PermLog error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }

    public static PermResult userAssignDimRole(List<UserAssignDimRoleReq> reqList, PermLogReq permLogReq) {
        try {
            Map<String, Object> map = UserRoleService.userRoleDimAssign(UserRoleService.UADRReq2RAURReq(reqList));
            List forInsertObjs = (List)map.get("forInsertObjs");
            List forUpdateObjs = (List)map.get("forUpdateObjs");
            List delList = (List)map.get("delList");
            StringBuilder resultMsg = (StringBuilder)map.get("resultMsg");
            boolean dataChange = (Boolean)map.get("dataChange");
            if (permLogReq.getSignPermLog().booleanValue() && PermCommonUtil.isEnablePermLog() && dataChange) {
                UserRoleService.userAssignDimRole2PermLog(forInsertObjs, forUpdateObjs, delList, permLogReq, resultMsg);
            }
            return PermResult.ok((StringBuilder)resultMsg);
        }
        catch (Exception e) {
            log.warn("UserRoleService.userAssignDimRole, exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        List needCheckBeanList = req.getNeedCheckBeanList();
        if (CollectionUtils.isEmpty((Collection)needCheckBeanList)) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, UserComRoleImportBean> passedMap = new HashMap<Integer, UserComRoleImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        OperationTypeEnum operationTypeEnum = null;
        EnumsImportType enumsImportType = req.getEnumsImportType();
        if (EnumsImportType.NEW != enumsImportType) {
            throw new KDBizException("unsurpport importType.");
        }
        operationTypeEnum = OperationTypeEnum.ADD;
        for (UserComRoleImportBean willSaveBean : needCheckBeanList) {
            if (null == willSaveBean) continue;
            willSaveBean.setOperationTypeEnum(operationTypeEnum);
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        PermCheckResp permCheckResp = new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
        super.beforeSaveCheckExt(req);
        return permCheckResp;
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, UserComRoleImportBean willSaveBean, Map<Integer, UserComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, UserComRoleImportBean willSaveBean, Map<Integer, UserComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean enableValidateTime;
        Set userSet;
        PermUser permUser;
        Map userNumExistMap;
        String userNumber;
        Set hasPermDimSet;
        Dim dim;
        Map dimNumExistMap;
        String dimTypeNumBig;
        Map roleNumberComRoleMap;
        Set comRoleSet;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int lineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getRoleNum();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)roleNum.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_19", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        long currUserId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)roleNum) && (null == (comRoleSet = (Set)(roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap")).get(roleNum)) || comRoleSet.isEmpty())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_16", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)(dimTypeNumBig = willSaveBean.getDimTypeBig()))) {
            Map bigPermCtrlTypeMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            PermCtrlType bigPermCtrlType = (PermCtrlType)bigPermCtrlTypeMap.get(dimTypeNumBig);
            if (null == bigPermCtrlType) {
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimTypeNumBig));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        } else if (StringUtils.isEmpty((String)dimTypeNumBig.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_20", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String dimType = willSaveBean.getDimType();
        String dimNum = willSaveBean.getDimNum();
        if (StringUtils.isEmpty((String)dimNum.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_21", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        HashMap<String, Map> dimTypeDimNumExistMap = null;
        if (null == checkNeedParamMap.get("dimTypeDimNumExistMap")) {
            dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimType, (Set)Sets.newHashSet((Object[])new String[]{dimNum}));
            dimTypeDimNumExistMap = new HashMap<String, Map>(8);
            dimTypeDimNumExistMap.put(dimType, dimNumExistMap);
        } else {
            dimTypeDimNumExistMap = (HashMap<String, Map>)checkNeedParamMap.get("dimTypeDimNumExistMap");
        }
        if (!(CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType))) || null != (dimNumExistMap = (Map)dimTypeDimNumExistMap.get(dimType)).get(dimNum) && ((Boolean)dimNumExistMap.get(dimNum)).booleanValue())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType)))) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermPermCtrlObjResp hasPermDimResult = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap")) {
            hasPermDimResult = PermCtrlTypeService.getAdminHasPermPermCtrlObj(new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{dimNum})));
        } else {
            Map dimTypeAdminHasPermPermCtrlObjMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap");
            GetHasPermPermCtrlObjResp getHasPermPermCtrlObjResp = hasPermDimResult = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermPermCtrlObjMap) ? null : (GetHasPermPermCtrlObjResp)dimTypeAdminHasPermPermCtrlObjMap.get(dimType);
        }
        if (null != hasPermDimResult && !hasPermDimResult.isHasAllDimPerm() && null == (dim = (Dim)(hasPermDimSet = hasPermDimResult.getHasPermDimSet()).stream().filter(x -> Objects.equals(dimNum, x.getDimNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)dimType) && null == hasPermDimResult) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(userNumber = willSaveBean.getUserNumber()).trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u7528\u6237\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_22", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map map = userNumExistMap = null == checkNeedParamMap.get("userNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_user", (Set)Sets.newHashSet((Object[])new String[]{userNumber})) : (Map)checkNeedParamMap.get("userNumExistMap");
        if (null == userNumExistMap.get(userNumber) || !((Boolean)userNumExistMap.get(userNumber)).booleanValue()) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)SYSTERM_TYPE, (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermUserResp hasPermUser = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermUserMap")) {
            hasPermUser = PermCtrlTypeService.getAdminHasPermUser(new GetHasPermUserReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{userNumber})));
        } else {
            Map dimTypeAdminHasPermUserMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermUserMap");
            GetHasPermUserResp getHasPermUserResp = hasPermUser = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermUserMap) ? null : (GetHasPermUserResp)dimTypeAdminHasPermUserMap.get(dimType);
        }
        if (null != hasPermUser && !hasPermUser.isHasAllUser() && null == (permUser = (PermUser)(userSet = hasPermUser.getUserSet()).stream().filter(x -> Objects.equals(userNumber, x.getUserNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u8303\u56f4\u5185\u6216\u4f8b\u5916\u4eba\u5458\u8303\u56f4\u5185\u3002", (String)"UserRoleService_13", (String)SYSTERM_TYPE, (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)dimType) && null == hasPermDimResult) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u8303\u56f4\u5185\u6216\u4f8b\u5916\u4eba\u5458\u8303\u56f4\u5185\u3002", (String)"UserRoleService_13", (String)SYSTERM_TYPE, (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map<String, UserRoleDim> userRoleDimMap = null;
        if (null == checkNeedParamMap.get("userRoleDimMap")) {
            HashMap<String, HashSet> dimTypeDimNumSetMap = new HashMap<String, HashSet>(8);
            dimTypeDimNumSetMap.put(dimType, Sets.newHashSet((Object[])new String[]{dimNum}));
            userRoleDimMap = UserRoleService.getUserRoleDimMap(new GetUserRoleDimReq(Integer.valueOf(1), null, null, (Set)Sets.newHashSet((Object[])new String[]{userNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{roleNum}), null, null, dimTypeDimNumSetMap));
        } else {
            userRoleDimMap = (Map<String, UserRoleDim>)checkNeedParamMap.get("userRoleDimMap");
        }
        if (StringUtils.isNotEmpty((String)userNumber) && StringUtils.isNotEmpty((String)roleNum)) {
            HashSet dimIdSet;
            Map userNumMap = null == checkNeedParamMap.get("userNumMap") ? UserHelper.getUserMap((Set)Sets.newHashSet((Object[])new String[]{userNumber}), (String)"number") : (Map)checkNeedParamMap.get("userNumMap");
            Set users = (Set)userNumMap.get(userNumber);
            Map roleNumberComRoleMap2 = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
            Set comRoles = (Set)roleNumberComRoleMap2.get(roleNum);
            Map<String, Map> dimTypeDimNumDimMap = null;
            if (null == checkNeedParamMap.get("dimTypeDimNumDimMap")) {
                dimTypeDimNumDimMap = new HashMap(8);
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)Sets.newHashSet((Object[])new String[]{dimNum}), (String)"number", (String)dimType);
                dimTypeDimNumDimMap.put(dimType, dimNumDimSetMap);
            } else {
                dimTypeDimNumDimMap = (Map)checkNeedParamMap.get("dimTypeDimNumDimMap");
            }
            Map dimNumDimMap = (Map)dimTypeDimNumDimMap.get(dimType);
            Set<Object> set = dimIdSet = null == dimNumDimMap ? new HashSet(1) : dimNumDimMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
            if (!(CollectionUtils.isEmpty((Collection)users) || CollectionUtils.isEmpty((Collection)comRoles) || CollectionUtils.isEmpty(dimIdSet))) {
                for (User user : users) {
                    for (ComRole comRole : comRoles) {
                        for (Long dimId : dimIdSet) {
                            String key = user.getFid() + "|" + comRole.getId() + "|" + dimType + "|" + dimId;
                            if (!userRoleDimMap.containsKey(key)) continue;
                            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"UserRoleService_18", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                            checkResult = false;
                            if (!failFast) continue;
                            return checkResult;
                        }
                    }
                }
            }
        }
        boolean bl = enableValidateTime = null == checkNeedParamMap.get("enableValidateTime") ? PermCommonUtil.isEnableValidateTime() : (Boolean)checkNeedParamMap.get("enableValidateTime");
        if (enableValidateTime) {
            Date endTime;
            Date startTime = willSaveBean.getStartTime();
            List list = PermCommonUtil.checkValidateTime((Date)startTime, (Date)(endTime = willSaveBean.getEndTime()), (Map)checkNeedParamMap);
            if (null != list && !list.isEmpty()) {
                for (String dataValidStr : list) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, dataValidStr);
                    checkResult = false;
                    if (!failFast) continue;
                    return checkResult;
                }
            }
        } else {
            willSaveBean.setStartTime(null);
            willSaveBean.setEndTime(null);
        }
        Boolean includeSub = willSaveBean.getIncludeSub();
        if (null == includeSub) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u662f\u6216\u5426\u3002", (String)"UserRoleService_17", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (checkResult) {
            passedMap.put(lineNum, willSaveBean);
        }
        return checkResult;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            UserComRoleAfterSaveReq req = (UserComRoleAfterSaveReq)reqOri;
            Set userRoleIdSet = req.getMainIdSet();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])userRoleIdSet.toArray(userRoleIdSet.toArray(new String[userRoleIdSet.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_userrole_multype"));
            if (null == dynamicObjects || Objects.equals(0, dynamicObjects.length)) {
                return PermResult.ok();
            }
            HashMap<String, Set<Long>> addRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
            HashSet<String> addRoleIds = new HashSet<String>(8);
            ArrayList<DynamicObject> forInsertObjs = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (DynamicObject one : dynamicObjects) {
                String roleId = one.getString("role_id");
                Long userId = one.getLong("user_id");
                addRoleIdUserIdsMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(userId);
                addRoleIds.add(roleId);
                forInsertObjs.add(one);
            }
            PermResult permResult = UserRoleService.userRoleRelateChangeBusi(addRoleIdUserIdsMap, null, addRoleIds, null);
            UserRoleService.roleAssignUserDim2PermLog(forInsertObjs, null, null, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            super.afterMainEntitySaveExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserRoleService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public PermCheckResp beforeDelCheck(PermCheckReq req) {
        PermCheckResp permCheckResp = super.beforeDelCheck(req);
        super.beforeDelCheckExt(req);
        return permCheckResp;
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            UserComRoleAfterDelReq req = (UserComRoleAfterDelReq)reqOri;
            Map delUserRoleDimMap = req.getDelUserRoleDimMap();
            if (!CollectionUtils.isEmpty((Map)delUserRoleDimMap)) {
                ArrayList<PermUserRole> delList = new ArrayList<PermUserRole>(10);
                HashMap<String, Set<Long>> delRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
                HashSet<String> delRoleIds = new HashSet<String>(8);
                for (Map.Entry delUserRoleDim : delUserRoleDimMap.entrySet()) {
                    UserRoleDim value = (UserRoleDim)delUserRoleDim.getValue();
                    if (null == value) continue;
                    delRoleIdUserIdsMap.computeIfAbsent(value.getRoleId(), k -> new HashSet(8)).add(value.getUserId());
                    delRoleIds.add(value.getRoleId());
                    delList.add(new PermUserRole(value.getId(), value.getDimId(), value.getUserId(), value.getRoleId(), value.getIncludeSub() != false ? "1" : "0", value.getDimType(), value.getStartTime(), value.getEndTime()));
                }
                PermResult permResult = UserRoleService.userRoleRelateChangeBusi(null, delRoleIdUserIdsMap, null, delRoleIds);
                UserRoleService.roleAssignUserDim2PermLog(null, null, delList, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            }
            super.afterDelExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserRoleService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static Map<String, UserRoleDim> getUserRoleDimMap(GetUserRoleDimReq req) {
        HashMap<String, UserRoleDim> map = new HashMap<String, UserRoleDim>(8);
        List<QFilter> filterList = UserRoleService.getFilter(req);
        Integer returnType = req.getReturnType();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserRoleService.getUserRoleDimMap", (String)"perm_userrole_multype", (String)"id, role, role.number, user, user.number, itemclasstypefield, itemclass, includesuborg, starttime, endtime", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            StringBuilder sb = null;
            UserRoleDim one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UserRoleDim();
                Long userId = row.getLong("user");
                String roleId = row.getString("role");
                String dimType = row.getString("itemclasstypefield");
                Long dimId = row.getLong("itemclass");
                one.setId(row.getString("id"));
                one.setUserId(userId);
                one.setRoleId(roleId);
                one.setDimType(dimType);
                one.setDimId(dimId);
                one.setIncludeSub(row.getBoolean("includesuborg"));
                one.setStartTime(row.getDate("starttime"));
                one.setEndTime(row.getDate("endtime"));
                if (Objects.equals(1, returnType)) {
                    sb = new StringBuilder().append(userId).append("|").append(roleId).append("|").append(dimType).append("|").append(dimId);
                    map.put(sb.toString(), one);
                    continue;
                }
                if (!Objects.equals(2, returnType)) continue;
                map.put(row.getString("id"), one);
            }
        }
        return map;
    }

    public static Set<String> getDimTypeSet(GetUserRoleDimReq req) {
        HashSet<String> result = new HashSet<String>(8);
        List<QFilter> filterList = UserRoleService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserRoleService.getDimTypeSet", (String)"perm_userrole_multype", (String)"itemclasstypefield", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.add(row.getString("itemclasstypefield"));
            }
        }
        return result;
    }

    private static List<QFilter> getFilter(GetUserRoleDimReq req) {
        Map dimTypeDimNumSetMap;
        Set dimIdSet;
        Set dimTypeSet;
        Map roleNumberComRoleMap;
        Set collect;
        Set roleNumberSet;
        Set roleIdSet;
        Map userMap;
        Set collect2;
        Set userNumberSet;
        Set userIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", (Object)mainIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userNumberSet = req.getUserNumberSet())) && !CollectionUtils.isEmpty(collect2 = (userMap = UserHelper.getUserMap((Set)userNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(roleIdSet = req.getRoleIdSet()))) {
            filterList.add(new QFilter("role", "in", (Object)roleIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(roleNumberSet = req.getRoleNumberSet())) && !CollectionUtils.isEmpty(collect = (roleNumberComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)roleNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(ComRole::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("role", "in", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimTypeSet = req.getDimTypeSet()))) {
            filterList.add(new QFilter("itemclasstypefield", "in", (Object)dimTypeSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimIdSet = req.getDimIdSet()))) {
            filterList.add(new QFilter("itemclass", "in", (Object)dimIdSet));
        }
        if (null != (dimTypeDimNumSetMap = req.getDimTypeDimNumSetMap()) && !dimTypeDimNumSetMap.isEmpty()) {
            HashSet<String> innerDimTypeSet = new HashSet<String>(8);
            HashSet innerDimIdSet = new HashSet(8);
            for (Map.Entry dimTypeDimNumSet : dimTypeDimNumSetMap.entrySet()) {
                String dimType = (String)dimTypeDimNumSet.getKey();
                Set dimNumberSet = (Set)dimTypeDimNumSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty((Collection)dimNumberSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumberSet, (String)"number", (String)dimType);
                Set collect3 = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                innerDimTypeSet.add(dimType);
                innerDimIdSet.addAll(collect3);
            }
            if (!CollectionUtils.isEmpty(innerDimTypeSet)) {
                filterList.add(new QFilter("itemclasstypefield", "in", innerDimTypeSet));
            }
            if (!CollectionUtils.isEmpty(innerDimIdSet)) {
                filterList.add(new QFilter("itemclass", "in", innerDimIdSet));
            }
        }
        return filterList;
    }
}

