/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.util.UserServiceUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class UserSaveServiceImpl {
    private static Log log = LogFactory.getLog(UserSaveServiceImpl.class);
    private static final String POST = "post";
    private static final String ID_TYPE = "idtype";
    private static final String BOS_POSITION = "bos_position";
    private static final String SOURCES = "sources";
    private List<UserParam> userList;
    private Map<Object, DynamicObject> userTypeMap;

    public UserSaveServiceImpl(List<UserParam> userList) {
        this.userList = userList;
    }

    public void save() {
        if (Utils.isListEmpty(this.userList)) {
            return;
        }
        int count = this.userList.size();
        ArrayList<Long> userIds = new ArrayList<Long>(count);
        for (UserParam userParam : this.userList) {
            long id = userParam.getId();
            if (id == 0L) continue;
            userIds.add(id);
        }
        Map<Long, DynamicObject> userObjMap = this.getUserFromDatabase(userIds);
        ArrayList<DynamicObject> userObjList = new ArrayList<DynamicObject>(count);
        HashMap<Long, UserParam> userParamMap = new HashMap<Long, UserParam>(count);
        ORM orm = ORM.create();
        UserObjParam userObjParam = new UserObjParam();
        DynamicObject userObj = null;
        for (UserParam userParam : this.userList) {
            userObj = this.parseUserParam(userParam, userObjParam, userObjMap, orm);
            if (userObj == null) continue;
            userObjList.add(userObj);
            userParamMap.put(userObj.getLong("id"), userParam);
        }
        if (userObjList.isEmpty()) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        for (UserParam userParam : this.userList) {
            Map dataMap = userParam.getDataMap();
            if (dataMap.get(SOURCES) == null) continue;
            operateOption.setVariableValue(SOURCES, dataMap.get(SOURCES).toString());
            break;
        }
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_user", (DynamicObject[])userObjList.toArray(new DynamicObject[userObjList.size()]), (OperateOption)operateOption);
        UserServiceUtils.genOperationResult(operationResult, userParamMap);
    }

    private DynamicObject parseUserParam(UserParam userParam, UserObjParam userObjParam, Map<Long, DynamicObject> userObjMap, ORM orm) {
        Map dataMap = userParam.getDataMap();
        if (dataMap == null || dataMap.isEmpty()) {
            UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserSaveServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return null;
        }
        DynamicObject userObj = this.getUserDynamicObject(userParam, userObjMap, orm);
        if (userObj == null) {
            return userObj;
        }
        boolean isAdd = userParam.getId() == 0L;
        for (Map.Entry userEntry : dataMap.entrySet()) {
            String proName = (String)userEntry.getKey();
            Object proValue = userEntry.getValue();
            if (SOURCES.equals(proName)) continue;
            if ("entryentity".equals(proName)) {
                this.parseUserPositionParam(userObjParam, userObj, proValue);
                continue;
            }
            if ("birthday".equals(proName)) {
                if (StringUtils.isBlank(proValue)) {
                    userObj.set(proName, proValue);
                    continue;
                }
                if (proValue instanceof String) {
                    userObj.set(proName, (Object)Utils.strToDate((String)proValue.toString(), (String)"yyyy-MM-dd"));
                    continue;
                }
                userObj.set(proName, proValue);
                continue;
            }
            if (ID_TYPE.equals(proName)) {
                this.parseUserIdType(userObjParam, userObj, proValue);
                continue;
            }
            userObj.set(proName, proValue);
        }
        if (isAdd) {
            if (!dataMap.containsKey("usertype")) {
                userObj.set("usertype", (Object)"1");
            }
            userObj.set("enable", (Object)"1");
            userObj.set("status", (Object)"C");
            if (!dataMap.containsKey("startdate")) {
                userObj.set("startdate", (Object)userObjParam.getToday());
            }
            if (!dataMap.containsKey("enddate")) {
                userObj.set("enddate", (Object)userObjParam.getEndDate());
            }
            userObj.set("creator", (Object)userObjParam.getUserId());
            userObj.set("createtime", (Object)userObjParam.getCurrentDate());
        } else {
            userObj.set("modifier", (Object)userObjParam.getUserId());
            userObj.set("modifytime", (Object)userObjParam.getCurrentDate());
        }
        this.parseUserType(dataMap, userObj);
        return userObj;
    }

    private void parseUserIdType(UserObjParam userObjParam, DynamicObject userEntity, Object posProValue) {
        if (posProValue instanceof Map) {
            Map idTypeMap = (Map)posProValue;
            Object number = idTypeMap.get("number");
            userEntity.set(ID_TYPE, (Object)this.getIdTypeDynamicObjectByNumber(userObjParam, number));
            return;
        }
        if (posProValue instanceof Long || posProValue instanceof Integer || posProValue instanceof String) {
            DynamicObject idTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(posProValue.toString()), (String)"cts_personal_identity");
            userEntity.set(ID_TYPE, (Object)idTypeObj);
            return;
        }
        if (posProValue instanceof DynamicObject) {
            userEntity.set(ID_TYPE, posProValue);
        }
    }

    private DynamicObject getIdTypeDynamicObjectByNumber(UserObjParam userObjParam, Object number) {
        if (StringUtils.isBlank((Object)number)) {
            return null;
        }
        Map<String, DynamicObject> idTypeNumberMap = userObjParam.getIdTypeNumberMap();
        DynamicObject idTypeObj = idTypeNumberMap.get(number.toString());
        if (idTypeObj != null) {
            return idTypeObj;
        }
        QFilter numberFilter = new QFilter("number", "=", number);
        QFilter[] filters = new QFilter[]{numberFilter};
        idTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"cts_personal_identity", (QFilter[])filters);
        idTypeNumberMap.put(number.toString(), idTypeObj);
        return idTypeObj;
    }

    private void parseUserType(Map<String, Object> dataMap, DynamicObject userObj) {
        if (this.userTypeMap == null) {
            this.userTypeMap = UserUtils.getAllUserType();
        }
        if (dataMap.containsKey("usertypes")) {
            userObj.set("usertypes", dataMap.get("usertypes"));
        }
        UserUtils.parseUserType((DynamicObject)userObj, this.userTypeMap);
    }

    private void parseUserPositionParam(UserObjParam userObjParam, DynamicObject userObj, Object proValue) {
        if (proValue == null || !(proValue instanceof List)) {
            return;
        }
        List positionList = (List)proValue;
        if (positionList.isEmpty()) {
            return;
        }
        DynamicObjectCollection posCol = userObj.getDynamicObjectCollection("entryentity");
        posCol.clear();
        int partJobSeq = 2;
        DynamicObjectType entityType = posCol.getDynamicObjectType();
        for (Map posMap : positionList) {
            DynamicObject userEntity = new DynamicObject(entityType);
            for (Map.Entry posEntry : posMap.entrySet()) {
                String posProName = (String)posEntry.getKey();
                Object posProValue = posEntry.getValue();
                if (StringUtils.isBlank(posProValue)) {
                    userEntity.set(posProName, posProValue);
                    continue;
                }
                if ("dpt".equals(posProName)) {
                    this.parseUserDepartmentParam(userObjParam, userEntity, posProValue);
                    continue;
                }
                if ("superior".equals(posProName)) {
                    this.parseUserSuperiorParam(userObjParam, userEntity, posProValue);
                    continue;
                }
                if (POST.equals(posProName)) {
                    this.parseUserPostParam(userObjParam, userEntity, posProValue);
                    continue;
                }
                userEntity.set(posProName, posProValue);
            }
            if (userEntity.getBoolean("ispartjob")) {
                userEntity.set("seq", (Object)partJobSeq++);
            } else {
                userEntity.set("seq", (Object)1);
            }
            posCol.add((Object)userEntity);
        }
    }

    private void parseUserPostParam(UserObjParam userObjParam, DynamicObject userEntity, Object posProValue) {
        if (posProValue instanceof Map) {
            Map postMap = (Map)posProValue;
            Object number = postMap.get("number");
            userEntity.set(POST, (Object)this.getPostDynamicObjectByNumber(userObjParam, number));
            return;
        }
        if (posProValue instanceof Long || posProValue instanceof Integer || posProValue instanceof String) {
            DynamicObject postObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(posProValue.toString()), (String)BOS_POSITION);
            userEntity.set(POST, (Object)postObj);
            return;
        }
        if (posProValue instanceof DynamicObject) {
            userEntity.set(POST, posProValue);
        }
    }

    private DynamicObject getPostDynamicObjectByNumber(UserObjParam userObjParam, Object number) {
        if (StringUtils.isBlank((Object)number)) {
            return null;
        }
        Map<String, DynamicObject> postNumberMap = userObjParam.getPostNumberMap();
        DynamicObject postObj = postNumberMap.get(number.toString());
        if (postObj != null) {
            return postObj;
        }
        QFilter numberFilter = new QFilter("number", "=", number);
        QFilter[] filters = new QFilter[]{numberFilter};
        postObj = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_POSITION, (QFilter[])filters);
        postNumberMap.put(number.toString(), postObj);
        return postObj;
    }

    private void parseUserSuperiorParam(UserObjParam userObjParam, DynamicObject userEntity, Object posProValue) {
        if (posProValue instanceof Map) {
            Map dptMap = (Map)posProValue;
            Object number = dptMap.get("number");
            userEntity.set("superior", (Object)this.getUserDynamicObjectByNumber(userObjParam, number));
            return;
        }
        if (posProValue instanceof Long || posProValue instanceof Integer || posProValue instanceof String) {
            DynamicObject superiorObj = BusinessDataServiceHelper.loadSingleFromCache((Object)posProValue, (String)"bos_user");
            userEntity.set("superior", (Object)superiorObj);
            return;
        }
        if (posProValue instanceof DynamicObject) {
            userEntity.set("superior", posProValue);
        }
    }

    private DynamicObject getUserDynamicObjectByNumber(UserObjParam userObjParam, Object number) {
        if (StringUtils.isBlank((Object)number)) {
            return null;
        }
        Map<String, DynamicObject> userNumberMap = userObjParam.getUserNumberMap();
        DynamicObject userObj = userNumberMap.get(number.toString());
        if (userObj != null) {
            return userObj;
        }
        QFilter numberFilter = new QFilter("number", "=", number);
        QFilter[] filters = new QFilter[]{numberFilter};
        userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])filters);
        userNumberMap.put(number.toString(), userObj);
        return userObj;
    }

    private void parseUserDepartmentParam(UserObjParam userObjParam, DynamicObject userEntity, Object posProValue) {
        if (posProValue instanceof Map) {
            Map dptMap = (Map)posProValue;
            Object number = dptMap.get("number");
            userEntity.set("dpt", (Object)this.getOrgDynamicObjectByNumber(userObjParam, number));
            return;
        }
        if (posProValue instanceof Long || posProValue instanceof Integer || posProValue instanceof String) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(posProValue.toString()), (String)"bos_org");
            userEntity.set("dpt", (Object)orgObj);
            return;
        }
        if (posProValue instanceof DynamicObject) {
            userEntity.set("dpt", posProValue);
        }
    }

    private DynamicObject getOrgDynamicObjectByNumber(UserObjParam userObjParam, Object number) {
        if (StringUtils.isBlank((Object)number)) {
            return null;
        }
        Map<String, DynamicObject> orgNumberMap = userObjParam.getOrgNumberMap();
        DynamicObject orgObj = orgNumberMap.get(number.toString());
        if (orgObj != null) {
            return orgObj;
        }
        QFilter numberFilter = new QFilter("number", "=", number);
        QFilter[] filters = new QFilter[]{numberFilter};
        orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])filters);
        orgNumberMap.put(number.toString(), orgObj);
        return orgObj;
    }

    private DynamicObject getUserDynamicObject(UserParam userParam, Map<Long, DynamicObject> userObjMap, ORM orm) {
        DynamicObject userObj = null;
        long id = userParam.getId();
        if (id == 0L) {
            userObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            long customUserId = userParam.getCustomUserId();
            id = customUserId == 0L ? orm.genLongId("bos_user") : customUserId;
            userObj.set("id", (Object)id);
            userObj.set("sortnumber", (Object)1000000);
        } else {
            userObj = userObjMap.get(id);
            if (userObj == null) {
                UserServiceUtils.genErrorMsg(userParam, String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728\uff0cID\uff1a%1$s", (String)"UserSaveServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]), id));
            }
        }
        return userObj;
    }

    private Map<Long, DynamicObject> getUserFromDatabase(List<Long> userIds) {
        int userCount = userIds.size();
        HashMap<Long, DynamicObject> userObjMap = new HashMap<Long, DynamicObject>(userCount);
        if (userCount == 0) {
            return userObjMap;
        }
        MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        DynamicObject[] dbUserArr = BusinessDataServiceHelper.load((Object[])userIds.toArray(new Long[userIds.size()]), (DynamicObjectType)userType);
        if (dbUserArr != null) {
            for (DynamicObject dbUser : dbUserArr) {
                userObjMap.put(dbUser.getLong("id"), dbUser);
            }
        }
        return userObjMap;
    }

    private static class UserObjParam {
        private final Date today = Utils.getDate((int)0);
        private final Date currentDate = Calendar.getInstance().getTime();
        private final Date endDate = Utils.getEndDate();
        private final String userId = RequestContext.get().getUserId();
        private Map<String, DynamicObject> orgNumberMap = new HashMap<String, DynamicObject>();
        private Map<String, DynamicObject> userNumberMap = new HashMap<String, DynamicObject>();
        private Map<String, DynamicObject> postNumberMap = new HashMap<String, DynamicObject>();
        private Map<String, DynamicObject> idTypeNumberMap = new HashMap<String, DynamicObject>();

        private UserObjParam() {
        }

        public Date getToday() {
            return this.today;
        }

        public Date getCurrentDate() {
            return this.currentDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public String getUserId() {
            return this.userId;
        }

        public Map<String, DynamicObject> getOrgNumberMap() {
            return this.orgNumberMap;
        }

        public Map<String, DynamicObject> getUserNumberMap() {
            return this.userNumberMap;
        }

        public Map<String, DynamicObject> getPostNumberMap() {
            return this.postNumberMap;
        }

        public Map<String, DynamicObject> getIdTypeNumberMap() {
            return this.idTypeNumberMap;
        }

        public void setUserNumberMap(Map<String, DynamicObject> userNumberMap) {
            this.userNumberMap = userNumberMap;
        }
    }
}

