/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSONObject;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.PswStrategyUtils;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PersonQueryParam;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.permission.model.Position;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.service.UserPositionSaveServiceImpl;
import kd.bos.permission.service.UserSaveServiceImpl;
import kd.bos.permission.util.UserServiceUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.EncryptUtils;
import kd.bos.util.PasswordEncryptUtil;
import org.apache.commons.collections.MapUtils;

public class UserServiceImpl
implements IUserService {
    private static final String SYSTEM_TYPE = "bos-mservice-permission";
    private static final String PROP_ENTRYENTITY_DPT = "entryentity.dpt";
    private static final String PROP_ENTRYENTITY_ISINCHARGE = "entryentity.isincharge";
    private static final String PROP_ENTRYENTITY_ISPARTJOB = "entryentity.ispartjob";
    private static final String PROP_ENABLE = "enable";
    private static final String F_DPTID = "fdptid";
    private static final String FID = "fid";
    private static final String F_ISINCHARGE = "fisincharge";
    private static final String F_ENABLE = "fenable";
    private static final String BOS_BIZPARTNERUSER_VIEW_PERMITERM = "47150e89000000ac";
    private static final String BOS_BIZPARTNERUSER_MODIFY_PERMITERM = "4715a0df000000ac";
    public static final String ENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    public static final String entityID_userChange = "bos_userchange";
    private static final String NUMBER = "number";
    private static final String CHANGETIME = "changetime";
    private static final String TIMESTAMP = "timestamp";
    private static final String USERTYPE = "usertype";
    private static final String USER_USERTYPE = "user.usertype";
    private static final String USER_EID = "user.eid";
    private static final String BIZPARTNER_NUMBER = "bizpartner.number";
    private static final String PARTNER_TYPE = "partnerType";
    private static final String PARTNER_EID = "partnerEid";
    private static final String PARTNER_USERS = "partnerUsers";
    private static final String ORG_ID = "orgId";
    private static final String PHONE = "phone";
    private static final String DPTID = "dptid";
    private static Log log = LogFactory.getLog(UserServiceImpl.class);
    private static final String BOS_POSITION = "bos_position";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String POSITION_ID = "position.id";
    private static final String DPT_ID = "dpt.id";
    private static final String REMARKS = "remarks";
    private static final String ISMAINPOSIITON = "ismainposition";
    private static final String BOS_REPORT_TYPE = "bos_reporttype";
    private static final String REPORT_TYPE = "reporttype";
    private static final String REPORT_TYPE_ID = "reporttype.id";
    private static final String TYPEID = "typeid";
    private static final String POSITIONID = "positionid";
    private static final String SUPPOSITIONID = "suppositionid";
    private static final String SUPERIORPOSITIONID = "superiorposition.id";
    private static final String SUPPOSITION = "superiorposition";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String[] PROPERTIES = new String[]{"id", "number", "name", "username", "phone", "gender", "usertype", "birthday", "idcard", "picturefield", "email", "eid", "useropenid", "tid", "fuid", "enable", "status", "isactived", "isregisted", "source", "pswstrategy", "sortnumber", "idtype"};
    private static final String[] JOB_PROPERTIES = new String[]{"seq", "ispartjob", "dpt", "position", "isincharge", "superior", "post"};
    private static final String ENTITY_USER_DEFAULT_ORG = "bas_userdefaultorg";
    public static final String AVATAR_ADMIN = "/icons/pc/other/superAdministrators_38_38.png";
    public static final String AVATAR_COSMIC_AD = "/private/universe_ad.png";
    public static final String AVATAR_SUPER_AD = "/private/super_ad.png";
    public static final String AVATAR_AUDIT_AD = "/private/audit_ad.png";
    public static final String AVATAR_SAFE_AD = "/private/safe_ad.png";
    public static final int INTERNAL_USERTYPE = 100;
    public static final int EXTERNAL_USERTYPE = 200;
    public static final int INTERNAL_AND_EXTERNAL_USERTYPE = 300;
    private static final String ENTITY_KEY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String ORG_AUTHOR_FILTER = "org_author_filter";
    private static final String PSWHISSTR = "pswhisstr";

    public void add(List<UserParam> userList) {
        this.addOrUpdate(userList);
    }

    public void update(List<UserParam> userList) {
        this.addOrUpdate(userList);
    }

    public void delete(List<UserParam> userList) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        this.execute(userList, "delete");
    }

    public void enable(List<UserParam> userList) {
        this.enable(userList, true);
    }

    public void disable(List<UserParam> userList) {
        this.enable(userList, false);
    }

    public void enableUser(List<UserParam> userList) {
        this.enableUser(userList, true);
    }

    public void disableUser(List<UserParam> userList) {
        this.enableUser(userList, false);
    }

    private void enable(List<UserParam> userList, boolean isEnable) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        this.execute(userList, isEnable ? PROP_ENABLE : "disable");
    }

    private void enableUser(List<UserParam> userList, boolean isEnable) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        this.execute(userList, isEnable ? "subscriberenable" : "subscriberdisable");
    }

    public void enableHR(List<UserParam> userList) {
        this.enableHR(userList, true);
    }

    public void disableHR(List<UserParam> userList) {
        this.enableHR(userList, false);
    }

    private void enableHR(List<UserParam> userList, boolean isEnable) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        for (UserParam userParam : userList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            long userId = userParam.getId();
            if (userId == 0L) {
                Object pk = dataMap.get("id");
                if (StringUtils.isBlank(pk) || Long.parseLong(pk.toString()) == 0L) {
                    UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserServiceImpl_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
            } else {
                dataMap.put("id", userId);
            }
            if (isEnable) {
                dataMap.put("source", "HR");
            } else {
                dataMap.put("source", "");
            }
            this.execute(userParam, dataMap, "save");
        }
    }

    public void updatePosition(List<UserParam> userList) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        for (UserParam userParam : userList) {
            Map dataMap = userParam.getDataMap();
            if (dataMap == null || dataMap.isEmpty()) {
                UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserServiceImpl_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            long userId = userParam.getId();
            if (userId == 0L) {
                Object pk = dataMap.get("id");
                if (StringUtils.isBlank(pk) || Long.parseLong(pk.toString()) == 0L) {
                    UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserServiceImpl_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
            } else {
                dataMap.put("id", userId);
            }
            this.execute(userParam, dataMap, "save");
        }
    }

    private void execute(UserParam userParam, Map<String, Object> dataMap, String operation) {
        JSONObject dataPack = new JSONObject();
        dataPack.put("data", dataMap);
        HashMap optionMap = new HashMap(1);
        dataPack.put("option", optionMap);
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)FormMetadataCache.getFormConfig((String)"bos_user").getEntityTypeId(), (String)operation);
        webApi.initialize("bos_user", (Map)dataPack);
        try {
            ApiResult result = webApi.execute();
            if (result == null) {
                UserServiceUtils.genNoResultErrorMsg(userParam);
            } else if (result.getSuccess()) {
                OperationResult operResult;
                List pkIds;
                Object resultData = result.getData();
                if (resultData instanceof OperationResult && Utils.isListNotEmpty((List)(pkIds = (operResult = (OperationResult)resultData).getSuccessPkIds()))) {
                    Object pkId = pkIds.get(0);
                    if (pkId == null) {
                        UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u65b0\u589e\u4eba\u5458ID\u4e3anull", (String)"UserServiceImpl_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else {
                        userParam.setId(Long.parseLong(pkId.toString()));
                    }
                }
            } else {
                String msg = result.getMessage();
                if (StringUtils.isBlank((CharSequence)msg) && result.getData() != null) {
                    OperationResult opRes = (OperationResult)result.getData();
                    List validateInfos = opRes.getAllErrorOrValidateInfo();
                    msg = Utils.isListEmpty((List)validateInfos) ? opRes.getMessage() : ((IOperateInfo)validateInfos.get(0)).getMessage();
                }
                UserServiceUtils.genErrorMsg(userParam, msg);
            }
        }
        catch (Exception e) {
            UserServiceUtils.genErrorMsg(userParam, e.getMessage());
        }
    }

    private void execute(List<UserParam> userList, String operation) {
        int count = userList.size();
        ArrayList<Long> ids = new ArrayList<Long>(count);
        HashMap<Long, UserParam> userParamMap = new HashMap<Long, UserParam>(count);
        for (UserParam userParam : userList) {
            long userId = userParam.getId();
            if (userId == 0L) {
                UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6eID\u53c2\u6570", (String)"UserServiceImpl_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            ids.add(userId);
            userParamMap.put(userId, userParam);
        }
        if (ids.isEmpty()) {
            return;
        }
        try {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
            operateOption.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
            OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)"bos_user", (Object[])ids.toArray(new Long[0]), (OperateOption)operateOption);
            if (result == null) {
                log.info("\u6267\u884c\u4eba\u5458\u64cd\u4f5c[" + operation + "]\u5931\u8d25\uff1a\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a");
            } else if (!result.isSuccess()) {
                UserServiceUtils.genOperationResult(result, userParamMap);
            }
        }
        catch (Exception e) {
            log.warn("\u6267\u884c\u4eba\u5458\u64cd\u4f5c[" + operation + "]\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public List<Map<String, Object>> get(List<Long> userIds) {
        return this.get(userIds, null, null);
    }

    public List<Map<String, Object>> get(List<Long> userIds, String[] properties, String[] jobProperties) {
        if (Utils.isListEmpty(userIds)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        if (properties == null || properties.length == 0) {
            properties = PROPERTIES;
        }
        if (jobProperties == null || jobProperties.length == 0) {
            jobProperties = JOB_PROPERTIES;
        }
        DynamicObject userTypeObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        DynamicObject[] userArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])userIds.toArray(new Long[userIds.size()]), (IDataEntityType)userTypeObj.getDataEntityType());
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(userArr.length);
        HashMap<String, Object> userMap = null;
        for (DynamicObject userObj : userArr) {
            userMap = new HashMap<String, Object>(properties.length);
            for (String proName : properties) {
                userMap.put(proName, userObj.get(proName));
            }
            DynamicObjectCollection posCol = userObj.getDynamicObjectCollection("entryentity");
            if (Utils.isListNotEmpty((List)posCol)) {
                ArrayList posList = new ArrayList();
                for (DynamicObject posObj : posCol) {
                    HashMap<String, Object> posMap = new HashMap<String, Object>();
                    posMap.put("id", posObj.getPkValue());
                    for (String posProName : jobProperties) {
                        if ("id".equals(posProName)) continue;
                        posMap.put(posProName, posObj.get(posProName));
                    }
                    posList.add(posMap);
                }
                userMap.put("entryentity", posList);
            }
            dataList.add(userMap);
        }
        return dataList;
    }

    public List<Map<String, Object>> getPosition(List<Long> userIds) {
        return this.get(userIds, new String[]{"id", "name"}, JOB_PROPERTIES);
    }

    @Deprecated
    public String getPerson(long orgId, long userId, PersonQueryType queryType, List<Long> resultList) {
        log.info(String.format("\u83b7\u53d6\u4eba\u5458\u7684\u53c2\u6570\uff1a\u7ec4\u7ec7[%s] \u4eba\u5458[%s] \u67e5\u8be2\u7c7b\u578b[%s]", orgId, userId, queryType));
        if (resultList == null) {
            String resultMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5bf9\u8c61\u4e3a\u7a7a", (String)"UserServiceImpl_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.info(resultMsg);
            return resultMsg;
        }
        PersonQueryParam personQueryParam = new PersonQueryParam();
        personQueryParam.setOrgId(orgId);
        personQueryParam.setUserId(userId);
        personQueryParam.setQueryType(queryType);
        if (queryType != null && queryType.getValue() == PersonQueryType.MANAGER_OF_ORG.getValue()) {
            personQueryParam.setQuerySuperior(true);
        }
        resultList.addAll(this.getPerson(personQueryParam));
        return personQueryParam.getErrorMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<Long> getPerson(PersonQueryParam personQueryParam) {
        if (personQueryParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserServiceImpl_5", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        orgId = personQueryParam.getOrgId();
        userId = personQueryParam.getUserId();
        includeMultipleUserTypes = personQueryParam.isIncludeMultipleUserTypes();
        queryType = personQueryParam.getQueryType();
        UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7684\u53c2\u6570\uff1a\u7ec4\u7ec7[%s] \u4eba\u5458[%s] \u67e5\u8be2\u7c7b\u578b[%s] \u662f\u5426\u9010\u7ea7\u5f80\u4e0a\u7ea7\u67e5\u8be2[%s] \u67e5\u8be2\u4eba\u5458\u662f\u5426\u5305\u62ec\u591a\u7c7b\u578b\u7684\u60c5\u51b5[%s]", new Object[]{orgId, userId, queryType, personQueryParam.isQuerySuperior(), includeMultipleUserTypes}));
        resultMsg = "";
        resultList = new ArrayList<Long>();
        if (queryType == null) {
            resultMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserServiceImpl_6", (String)"bos-mservice-permission", (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return resultList;
        }
        try {
            switch (1.$SwitchMap$kd$bos$permission$model$PersonQueryType[queryType.ordinal()]) {
                case 1: {
                    resultList.addAll(this.getAllPerson(false, includeMultipleUserTypes));
                    ** break;
                }
                case 2: {
                    resultList.addAll(this.getAllPerson(true, includeMultipleUserTypes));
                    ** break;
                }
                case 3: {
                    if (this.isOrgParamEmpty(orgId, personQueryParam)) {
                        resultMsg = personQueryParam.getErrorMsg();
                        ** break;
                    }
                    resultList.addAll(this.getPerson(orgId, false, false, false, includeMultipleUserTypes));
                    ** break;
                }
                case 4: {
                    if (this.isOrgParamEmpty(orgId, personQueryParam)) {
                        resultMsg = personQueryParam.getErrorMsg();
                        ** break;
                    }
                    resultList.addAll(this.getPerson(orgId, false, true, false, includeMultipleUserTypes));
                    ** break;
                }
                case 5: {
                    orgId = this.checkOrgParam(orgId, userId);
                    if (orgId == 0L) {
                        resultMsg = this.getOrgEmptyErrorMsg();
                        personQueryParam.setErrorMsg(resultMsg);
                        ** break;
                    }
                    resultMsg = this.getUsersOfEqualLevel(personQueryParam, resultList);
                    resultList.remove(userId);
                    ** break;
                }
                case 6: {
                    if (userId == 0L) {
                        resultMsg = ResManager.loadKDString((String)"\u4eba\u5458ID\u53c2\u6570\u672a\u8bbe\u7f6e", (String)"UserServiceImpl_7", (String)"bos-mservice-permission", (Object[])new Object[0]);
                        personQueryParam.setErrorMsg(resultMsg);
                        ** break;
                    }
                    orgIds = new ArrayList<Long>(1);
                    if (orgId != 0L) {
                        orgIds.add(orgId);
                    }
                    resultMsg = this.getSubordinate(orgIds, userId, resultList, 0);
                    ** break;
                }
                case 7: {
                    orgOfManagerList = new ArrayList<Long>();
                    resultMsg = this.getSuperior(personQueryParam, resultList, orgOfManagerList);
                    ** break;
                }
                case 8: {
                    resultMsg = this.getIndirectSuperior(personQueryParam, resultList);
                    ** break;
                }
                case 9: {
                    if (this.isOrgParamEmpty(orgId, personQueryParam)) {
                        resultMsg = personQueryParam.getErrorMsg();
                        ** break;
                    }
                    resultList.addAll(this.getManagerOfOrg(personQueryParam));
                    ** break;
                }
                case 10: {
                    resultMsg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u8be2", (String)"UserServiceImpl_8", (String)"bos-mservice-permission", (Object[])new Object[0]);
                    ** break;
                }
            }
        }
        catch (Throwable var11_11) {
            if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
                UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458\u5931\u8d25[%s]\uff1a%s", new Object[]{queryType, resultMsg}));
            } else {
                count = resultList.size();
                if (count == 0) {
                    UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458[%s]\u7ed3\u679c\u4e3a\uff1a\u4eba\u6570[0]", new Object[]{queryType}));
                } else {
                    UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458[%s]\u7ed3\u679c\u4e3a\uff1a\u4eba\u6570[%s] \u4eba\u5458[%s] ", new Object[]{queryType, count, resultList.get(0)}));
                }
            }
            throw var11_11;
        }
lbl86:
        // 16 sources

        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458\u5931\u8d25[%s]\uff1a%s", new Object[]{queryType, resultMsg}));
        } else {
            count = resultList.size();
            if (count == 0) {
                UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458[%s]\u7ed3\u679c\u4e3a\uff1a\u4eba\u6570[0]", new Object[]{queryType}));
            } else {
                UserServiceImpl.log.info(String.format("\u83b7\u53d6\u4eba\u5458[%s]\u7ed3\u679c\u4e3a\uff1a\u4eba\u6570[%s] \u4eba\u5458[%s] ", new Object[]{queryType, count, resultList.get(0)}));
            }
        }
        personQueryParam.setErrorMsg(resultMsg);
        breakUserIds = personQueryParam.getBreakUserIds();
        if (Utils.isListNotEmpty((List)breakUserIds)) {
            resultList.removeAll(breakUserIds);
        }
        return resultList;
    }

    private boolean isOrgParamEmpty(long orgId, PersonQueryParam personQueryParam) {
        if (orgId == 0L) {
            String resultMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u53c2\u6570\u672a\u8bbe\u7f6e", (String)"UserServiceImpl_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return true;
        }
        return false;
    }

    private String getOrgEmptyErrorMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7ID\u53c2\u6570\uff0c\u4e14\u8bbe\u7f6e\u4eba\u5458\u7684\u4e3b\u804c\u90e8\u95e8\u3002", (String)"UserServiceImpl_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private long checkOrgParam(long orgId, long userId) {
        if (orgId == 0L) {
            orgId = this.getUserMainOrgId(userId);
        }
        return orgId;
    }

    private List<Long> getAllPerson(boolean isIncludeDisable, boolean includeMultipleUserTypes) {
        QFilter filter = includeMultipleUserTypes ? UserUtils.getUserTypeLikeFilter((String)"1") : new QFilter(USERTYPE, "=", (Object)"1");
        if (!isIncludeDisable) {
            QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
            filter = filter.and(enableFilter);
        }
        return this.getPerson(filter);
    }

    private List<Long> getPerson(long orgId, boolean isIncludeDisable, boolean isIncludeSubOrg, boolean isManager, boolean includeMultipleUserTypes) {
        QFilter filter = includeMultipleUserTypes ? UserUtils.getUserTypeLikeFilter((String)"1") : new QFilter(USERTYPE, "=", (Object)"1");
        if (!isIncludeDisable) {
            QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
            filter = filter.and(enableFilter);
        }
        if (orgId != 0L) {
            QFilter orgFilter = null;
            orgFilter = isIncludeSubOrg ? new QFilter(PROP_ENTRYENTITY_DPT, "in", (Object)OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(orgId), (boolean)true)) : new QFilter(PROP_ENTRYENTITY_DPT, "=", (Object)orgId);
            filter = filter.and(orgFilter);
        }
        if (isManager) {
            QFilter managerFilter = new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.TRUE);
            filter = filter.and(managerFilter);
        }
        return this.getPerson(filter);
    }

    private List<Long> getPerson(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])filters);
        if (Utils.isListEmpty((List)userCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> userIds = new ArrayList<Long>(userCol.size());
        for (DynamicObject userObj : userCol) {
            userIds.add(userObj.getLong("id"));
        }
        return userIds;
    }

    private String getSubordinate(List<Long> baseOrgIds, long userId, List<Long> subordinateIds, int mangerFilterMode) {
        QFilter enableFilter = new QFilter("user.enable", "=", (Object)Boolean.TRUE);
        QFilter superiorFilter = new QFilter("superior", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{enableFilter, superiorFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.permission.service.UserServiceImpl.getSubordinate", (String)"bos_userposition", (String)"user", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                long subUserId = row.getLong("user");
                if (subordinateIds.contains(subUserId)) continue;
                subordinateIds.add(subUserId);
            }
        }
        QFilter isinchargeilter = new QFilter("isincharge", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("user", "=", (Object)userId);
        if (Utils.isListNotEmpty(baseOrgIds)) {
            QFilter orgFilter = new QFilter("org", "in", baseOrgIds);
            idFilter = idFilter.and(orgFilter);
        }
        filters = new QFilter[]{enableFilter, isinchargeilter, idFilter};
        ArrayList<Long> orgIds = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.permission.service.UserServiceImpl.getSubordinate", (String)"bos_userposition", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                orgIds.add(row.getLong("org"));
            }
        }
        return this.getSubordinateByOrgId(orgIds, userId, subordinateIds, mangerFilterMode);
    }

    private String getSubordinateByOrgId(List<Long> orgIds, long userId, List<Long> subordinateIds, int mangerFilterMode) {
        if (orgIds.isEmpty()) {
            return "";
        }
        QFilter orgFilter = new QFilter(PROP_ENTRYENTITY_DPT, "in", orgIds);
        QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
        if (mangerFilterMode == 1) {
            enableFilter = enableFilter.and(new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.TRUE));
        } else if (mangerFilterMode == 2) {
            enableFilter = enableFilter.and(new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{enableFilter, orgFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])filters);
        if (Utils.isListEmpty((List)userCol)) {
            return "";
        }
        for (DynamicObject userObj : userCol) {
            long subUserId = userObj.getLong("id");
            if (subordinateIds.contains(subUserId)) continue;
            subordinateIds.add(subUserId);
        }
        subordinateIds.remove(userId);
        return "";
    }

    private String getSuperior(PersonQueryParam personQueryParam, List<Long> managerList, List<Long> orgOfManagerList) {
        long userId = personQueryParam.getUserId();
        long orgId = personQueryParam.getOrgId();
        orgId = this.checkOrgParam(orgId, userId);
        String resultMsg = "";
        if (orgId == 0L) {
            resultMsg = this.getOrgEmptyErrorMsg();
            personQueryParam.setErrorMsg(resultMsg);
            return resultMsg;
        }
        ArrayList<Long> deptList = new ArrayList<Long>();
        long superiorId = this.getSuperiorOfUserConfig(userId, orgId, deptList, null);
        if (superiorId != 0L) {
            List breakUserIds = personQueryParam.getBreakUserIds();
            if (breakUserIds != null && breakUserIds.contains(superiorId)) {
                return "";
            }
            managerList.add(superiorId);
            return "";
        }
        if (deptList.isEmpty()) {
            resultMsg = ResManager.loadKDString((String)"\u4eba\u5458\u672a\u5206\u914d\u90e8\u95e8\uff0c\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25", (String)"UserServiceImpl_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return resultMsg;
        }
        return this.getSuperior(personQueryParam, managerList, deptList, orgOfManagerList);
    }

    private String getSuperior(PersonQueryParam personQueryParam, List<Long> managerList, List<Long> deptList, List<Long> orgOfManagerList) {
        Map<Long, Map<String, Object>> managerMap = null;
        long orgId = personQueryParam.getOrgId();
        if (deptList.contains(orgId)) {
            managerMap = this.getSuperiorByOrg(personQueryParam, orgOfManagerList);
        } else {
            long userId = personQueryParam.getUserId();
            long mainOrgId = this.getUserMainOrgId(userId);
            List breakOrgIds = personQueryParam.getBreakOrgIds();
            if (breakOrgIds != null && breakOrgIds.contains(mainOrgId)) {
                return "";
            }
            PersonQueryParam mainOrgQueryParam = new PersonQueryParam();
            mainOrgQueryParam.setOrgId(mainOrgId);
            mainOrgQueryParam.setUserId(userId);
            mainOrgQueryParam.setBreakOrgIds(breakOrgIds);
            mainOrgQueryParam.setBreakUserIds(personQueryParam.getBreakUserIds());
            mainOrgQueryParam.setQuerySuperior(personQueryParam.isQuerySuperior());
            mainOrgQueryParam.setQueryType(personQueryParam.getQueryType());
            managerMap = this.getSuperiorByOrg(mainOrgQueryParam, orgOfManagerList);
        }
        if (managerMap == null || managerMap.size() == 0) {
            return "";
        }
        for (long managerId : managerMap.keySet()) {
            managerList.add(managerId);
        }
        return "";
    }

    private String getIndirectSuperior(PersonQueryParam personQueryParam, List<Long> managerList) {
        List superiorAdminOrgList;
        long userId = personQueryParam.getUserId();
        long orgId = personQueryParam.getOrgId();
        orgId = this.checkOrgParam(orgId, userId);
        String resultMsg = "";
        if (orgId == 0L) {
            resultMsg = this.getOrgEmptyErrorMsg();
            personQueryParam.setErrorMsg(resultMsg);
            return resultMsg;
        }
        ArrayList<Long> orgOfManagerList = new ArrayList<Long>(1);
        resultMsg = this.getSuperior(personQueryParam, managerList, orgOfManagerList);
        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            return resultMsg;
        }
        if (managerList.isEmpty()) {
            return personQueryParam.getErrorMsg();
        }
        long superiorUserId = managerList.get(0);
        ArrayList<Long> deptList = new ArrayList<Long>();
        ArrayList<Long> chargeDeptList = new ArrayList<Long>();
        long userDefSuperiorId = this.getSuperiorOfUserConfig(superiorUserId, personQueryParam.getOrgId(), deptList, chargeDeptList);
        if (userDefSuperiorId != 0L) {
            managerList.clear();
            managerList.add(userDefSuperiorId);
            return "";
        }
        if (deptList.isEmpty()) {
            return ResManager.loadKDString((String)"\u4eba\u5458\u672a\u5206\u914d\u90e8\u95e8\uff0c\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25", (String)"UserServiceImpl_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if (Utils.isListNotEmpty(orgOfManagerList)) {
            orgId = (Long)orgOfManagerList.get(0);
        }
        if (orgId == OrgUnitServiceHelper.getRootOrgId()) {
            return "";
        }
        long superiorOrgId = this.getSuperiorOrgId(orgId, superiorUserId);
        if (superiorOrgId != 0L && superiorOrgId != orgId && Utils.isListNotEmpty((List)(superiorAdminOrgList = OrgUnitServiceHelper.getSuperiorOrgs((String)"01", (long)orgId))) && this.isSuperiorOrg((Long)superiorAdminOrgList.get(0), superiorOrgId) && chargeDeptList.contains(superiorOrgId)) {
            return "";
        }
        managerList.clear();
        List breakOrgIds = personQueryParam.getBreakOrgIds();
        if (breakOrgIds != null && breakOrgIds.contains(superiorOrgId)) {
            return "";
        }
        List breakUserIds = personQueryParam.getBreakUserIds();
        if (breakUserIds != null && breakUserIds.contains(superiorUserId)) {
            return "";
        }
        PersonQueryParam superiorQueryParam = new PersonQueryParam();
        superiorQueryParam.setOrgId(superiorOrgId);
        superiorQueryParam.setUserId(superiorUserId);
        superiorQueryParam.setBreakOrgIds(personQueryParam.getBreakOrgIds());
        superiorQueryParam.setBreakUserIds(personQueryParam.getBreakUserIds());
        superiorQueryParam.setQuerySuperior(personQueryParam.isQuerySuperior());
        superiorQueryParam.setQueryType(personQueryParam.getQueryType());
        return this.getSuperior(superiorQueryParam, managerList, deptList);
    }

    private boolean isSuperiorOrg(long orgId, long superiorOrgId) {
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter parentFilter = new QFilter("parent", "=", (Object)superiorOrgId);
        QFilter[] qFilters = new QFilter[]{viewFilter, orgFilter, parentFilter};
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])qFilters);
    }

    private long getSuperiorOrgId(long orgId, long superiorId) {
        String selectFields = "id,entryentity.dpt dpt, entryentity.ispartjob ispartjob";
        QFilter idFilter = new QFilter("id", "=", (Object)superiorId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)userCol)) {
            return 0L;
        }
        long superiorOrgId = 0L;
        for (DynamicObject userObj : userCol) {
            long dptId = userObj.getLong("dpt");
            if (userObj.getBoolean("ispartjob")) {
                if (dptId != orgId) continue;
                superiorOrgId = dptId;
                return superiorOrgId;
            }
            superiorOrgId = dptId;
        }
        return superiorOrgId;
    }

    private long getSuperiorOfUserConfig(long userId, long orgId, List<Long> deptList, List<Long> chargeDeptList) {
        long superiorId = 0L;
        if (userId == 0L || orgId == 0L) {
            return superiorId;
        }
        String selectFields = "id,entryentity.dpt,entryentity.isincharge,entryentity.superior";
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        if (userObj == null) {
            return superiorId;
        }
        DynamicObjectCollection positionObjCol = userObj.getDynamicObjectCollection("entryentity");
        if (positionObjCol == null || positionObjCol.isEmpty()) {
            return superiorId;
        }
        for (DynamicObject posObj : positionObjCol) {
            DynamicObject superiorObj;
            DynamicObject orgObj = posObj.getDynamicObject("dpt");
            if (orgObj == null) continue;
            long jobOrgId = orgObj.getLong("id");
            deptList.add(jobOrgId);
            if (chargeDeptList != null && posObj.getBoolean("isincharge")) {
                chargeDeptList.add(jobOrgId);
            }
            if (jobOrgId != orgId || (superiorObj = posObj.getDynamicObject("superior")) == null) continue;
            superiorId = superiorObj.getLong("id");
        }
        return superiorId;
    }

    public Map<Long, Map<String, Object>> getSuperiorOrgLeaderInfo(long userId) {
        List parentIds;
        if (userId == 0L) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        ArrayList<Long> lstJoinedOrgs = new ArrayList<Long>(1);
        boolean isIncharge = UserServiceImpl.getUserMainOrg(lstJoinedOrgs, userId);
        Map<Long, Map<String, Object>> managerMap = new HashMap<Long, Map<String, Object>>();
        if (lstJoinedOrgs.size() == 0) {
            return managerMap;
        }
        boolean isHasParent = false;
        if (isIncharge && (parentIds = OrgUnitServiceHelper.getSuperiorOrgs((String)"01", (long)((Long)lstJoinedOrgs.get(0)))) != null && parentIds.size() > 0) {
            isHasParent = true;
            managerMap = UserServiceImpl.getManagersOfOrgs(parentIds);
        }
        if (!isHasParent) {
            managerMap = UserServiceImpl.getManagersOfOrgs(lstJoinedOrgs);
        }
        return managerMap;
    }

    private Map<Long, Map<String, Object>> getSuperiorByOrg(PersonQueryParam personQueryParam, List<Long> orgOfManagerLis) {
        List parentIds;
        orgOfManagerLis.clear();
        long orgId = personQueryParam.getOrgId();
        List breakOrgIds = personQueryParam.getBreakOrgIds();
        Map<Long, Map<String, Object>> managerMap = new HashMap<Long, Map<String, Object>>();
        if (breakOrgIds != null && breakOrgIds.contains(orgId)) {
            return managerMap;
        }
        orgOfManagerLis.add(orgId);
        boolean isHasParent = false;
        List<Long> orgManagerList = UserServiceImpl.getOrgManager(Collections.singletonList(orgId));
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        long userId = personQueryParam.getUserId();
        if (orgId != rootOrgId && orgManagerList.contains(userId) && Utils.isListNotEmpty((List)(parentIds = OrgUnitServiceHelper.getSuperiorOrgs((String)"01", (long)orgId)))) {
            isHasParent = true;
            orgId = (Long)parentIds.get(0);
            if (breakOrgIds != null && breakOrgIds.contains(orgId)) {
                return managerMap;
            }
            managerMap = UserServiceImpl.getManagersOfOrgs(parentIds);
        }
        if (!isHasParent) {
            ArrayList<Long> lstJoinedOrgs = new ArrayList<Long>(1);
            lstJoinedOrgs.add(orgId);
            managerMap = UserServiceImpl.getManagersOfOrgs(lstJoinedOrgs);
        }
        if (!personQueryParam.isQuerySuperior()) {
            return managerMap;
        }
        if (managerMap == null || managerMap.size() == 0) {
            if (rootOrgId == orgId) {
                return managerMap;
            }
            List superiorOrgIds = OrgUnitServiceHelper.getSuperiorOrgs((String)"01", (long)orgId);
            if (Utils.isListEmpty((List)superiorOrgIds)) {
                return managerMap;
            }
            PersonQueryParam superiorQueryParam = new PersonQueryParam();
            superiorQueryParam.setOrgId(((Long)superiorOrgIds.get(0)).longValue());
            superiorQueryParam.setUserId(userId);
            superiorQueryParam.setBreakOrgIds(breakOrgIds);
            superiorQueryParam.setBreakUserIds(personQueryParam.getBreakUserIds());
            superiorQueryParam.setQuerySuperior(personQueryParam.isQuerySuperior());
            superiorQueryParam.setQueryType(personQueryParam.getQueryType());
            return this.getSuperiorByOrg(superiorQueryParam, orgOfManagerLis);
        }
        return managerMap;
    }

    private static Map<Long, Map<String, Object>> getManagersOfOrgs(List<Long> lstOrgs) {
        HashMap<Long, Map<String, Object>> managerMap = new HashMap<Long, Map<String, Object>>();
        String selectFields = "id,enable";
        QFilter f1 = new QFilter("entryentity.dpt.id", "in", lstOrgs);
        QFilter f2 = new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)"1");
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{f1, f2});
        if (userCol == null || userCol.size() == 0) {
            return managerMap;
        }
        for (DynamicObject user : userCol) {
            HashMap<String, Boolean> userInfoMap = new HashMap<String, Boolean>();
            userInfoMap.put(PROP_ENABLE, user.getBoolean(PROP_ENABLE));
            managerMap.put(user.getLong("id"), userInfoMap);
        }
        return managerMap;
    }

    private static boolean getUserMainOrg(List<Long> lstJoinedOrgs, long userId) {
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter jobFilter = new QFilter(PROP_ENTRYENTITY_ISPARTJOB, "=", (Object)Boolean.FALSE);
        String selectFields = "entryentity.dpt.id dpt, entryentity.isincharge isincharge";
        QFilter[] filters = new QFilter[]{idFilter, jobFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (org == null) {
            return false;
        }
        lstJoinedOrgs.add(org.getLong("dpt"));
        return org.getBoolean("isincharge");
    }

    private static List<Long> getOrgManager(List<Long> orgIds) {
        String selectFields = "user";
        QFilter jobFilter = new QFilter("org", "in", orgIds);
        QFilter isinchargeFilter = new QFilter("isincharge", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{jobFilter, isinchargeFilter};
        DynamicObjectCollection userPosCol = QueryServiceHelper.query((String)"bos_userposition", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)userPosCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> userIds = new ArrayList<Long>(userPosCol.size());
        for (DynamicObject userObj : userPosCol) {
            userIds.add(userObj.getLong("user"));
        }
        return userIds;
    }

    private String getUsersOfEqualLevel(PersonQueryParam personQueryParam, List<Long> resultList) {
        long orgId = personQueryParam.getOrgId();
        long userId = personQueryParam.getUserId();
        List<Long> orgManagerList = UserServiceImpl.getOrgManager(Collections.singletonList(orgId));
        if (orgManagerList.isEmpty()) {
            PersonQueryParam qp = new PersonQueryParam();
            qp.setOrgId(orgId);
            qp.setQueryType(PersonQueryType.ALL_OF_ORG);
            resultList.addAll(this.getPerson(qp));
            return "";
        }
        if (orgManagerList.contains(userId)) {
            if ((orgId = this.checkOrgParam(orgId, userId)) == 0L) {
                return this.getOrgEmptyErrorMsg();
            }
            ArrayList<Long> deptList = new ArrayList<Long>();
            long confSuperiorId = this.getSuperiorOfUserConfig(userId, orgId, deptList, null);
            if (confSuperiorId != 0L) {
                ArrayList<Long> confSuperiorList = new ArrayList<Long>();
                confSuperiorList.add(confSuperiorId);
                resultList.addAll(this.getSubordinateByConfig(confSuperiorList, true));
            }
            ArrayList<Long> superiorList = new ArrayList<Long>();
            if (OrgUnitServiceHelper.getRootOrgId() == orgId) {
                resultList.addAll(orgManagerList);
            } else {
                ArrayList<Long> orgOfManagerList = new ArrayList<Long>(1);
                this.getSuperior(personQueryParam, superiorList, deptList, orgOfManagerList);
                if (superiorList.isEmpty()) {
                    return "";
                }
                resultList.addAll(this.getSubOrgManager(superiorList));
            }
            return "";
        }
        String resultMsg = this.getSubordinate(Collections.singletonList(orgId), orgManagerList.get(0), resultList, 2);
        return resultMsg;
    }

    private List<Long> getSubOrgManager(List<Long> superiorList) {
        ArrayList<Long> subordinateIds = new ArrayList<Long>();
        List<Long> mainOrgIds = this.getUserMainOrgIds(superiorList);
        List subOrgIds = OrgUnitServiceHelper.getSubOrgLimitLevel(mainOrgIds, (int)1, (boolean)false);
        if (subOrgIds.isEmpty()) {
            return subordinateIds;
        }
        return UserServiceImpl.getOrgManager(subOrgIds);
    }

    private List<Long> getSubordinateByConfig(List<Long> userIds, boolean isIncharge) {
        QFilter[] filters;
        DynamicObjectCollection userCol;
        String selectFields = "id";
        QFilter filter = new QFilter("entryentity.superior", "in", userIds);
        if (isIncharge) {
            filter = filter.and(new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.TRUE));
        }
        if (Utils.isListEmpty((List)(userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])(filters = new QFilter[]{filter}))))) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> subordinateIds = new ArrayList<Long>(userCol.size());
        for (DynamicObject userObj : userCol) {
            subordinateIds.add(userObj.getLong("id"));
        }
        return subordinateIds;
    }

    private List<Long> getManagerOfOrg(PersonQueryParam personQueryParam) {
        boolean includeMultipleUserTypes = personQueryParam.isIncludeMultipleUserTypes();
        List<Long> managerList = this.getPerson(personQueryParam.getOrgId(), false, false, true, includeMultipleUserTypes);
        if (Utils.isListNotEmpty(managerList)) {
            List breakUserIds = personQueryParam.getBreakUserIds();
            if (Utils.isListNotEmpty((List)breakUserIds)) {
                managerList.removeAll(breakUserIds);
            }
            return managerList;
        }
        if (!personQueryParam.isQuerySuperior()) {
            return new ArrayList<Long>(0);
        }
        return this.getManagerOfOrgTillFirstCompany(personQueryParam);
    }

    private List<Long> getManagerOfOrgTillFirstCompany(PersonQueryParam personQueryParam) {
        QFilter managerFilter;
        QFilter dptFilter;
        QFilter enableFilter;
        boolean includeMultipleUserTypes;
        QFilter typeFilter;
        String selectUserFields;
        DynamicObjectCollection userCol;
        QFilter viewFilter;
        long orgId = personQueryParam.getOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter = OrgViewUtils.getOrgViewFilter((String)"01")};
        DynamicObject orgStrucObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])filters);
        if (orgStrucObj == null) {
            return new ArrayList<Long>(0);
        }
        String selectFields = "id,org,longnumber,org.orgpattern orgpattern";
        String longnumber = orgStrucObj.getString("longnumber");
        List superiorLongnumList = OrgViewUtils.getAllSuperiorLongnumber((String)longnumber);
        QFilter longnumFilter = new QFilter("longnumber", "in", (Object)superiorLongnumList);
        filters = new QFilter[]{viewFilter, longnumFilter};
        DynamicObjectCollection orgStrucCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber desc");
        if (Utils.isListEmpty((List)orgStrucCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> superiorOrgList = new ArrayList<Long>(orgStrucCol.size());
        for (DynamicObject superiorStrucObj : orgStrucCol) {
            long superiorOrgId = superiorStrucObj.getLong("org");
            superiorOrgList.add(superiorOrgId);
            if (superiorStrucObj.getLong("orgpattern") != 1L) continue;
            break;
        }
        if (Utils.isListEmpty((List)(userCol = QueryServiceHelper.query((String)"bos_user", (String)(selectUserFields = "id,entryentity.dpt dpt"), (QFilter[])(filters = new QFilter[]{typeFilter = (includeMultipleUserTypes = personQueryParam.isIncludeMultipleUserTypes()) ? UserUtils.getUserTypeLikeFilter((String)"1") : new QFilter(USERTYPE, "=", (Object)"1"), enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE), dptFilter = new QFilter(PROP_ENTRYENTITY_DPT, "in", superiorOrgList), managerFilter = new QFilter(PROP_ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.TRUE)}))))) {
            return new ArrayList<Long>(0);
        }
        HashMap<Long, ArrayList<Long>> dptManagerMap = new HashMap<Long, ArrayList<Long>>();
        for (DynamicObject userObj : userCol) {
            long dptId = userObj.getLong("dpt");
            ArrayList<Long> userIds = (ArrayList<Long>)dptManagerMap.get(dptId);
            if (userIds == null) {
                userIds = new ArrayList<Long>();
                dptManagerMap.put(dptId, userIds);
            }
            userIds.add(userObj.getLong("id"));
        }
        List breakOrgIds = personQueryParam.getBreakOrgIds();
        Iterator iterator = superiorOrgList.iterator();
        while (iterator.hasNext()) {
            long superiorOrgId = (Long)iterator.next();
            if (breakOrgIds != null && breakOrgIds.contains(superiorOrgId)) break;
            List managerList = (List)dptManagerMap.get(superiorOrgId);
            if (!Utils.isListNotEmpty((List)managerList)) continue;
            List breakUserIds = personQueryParam.getBreakUserIds();
            if (Utils.isListNotEmpty((List)breakUserIds)) {
                managerList.removeAll(breakUserIds);
            }
            return managerList;
        }
        return new ArrayList<Long>(0);
    }

    public long getUserMainOrgId(long userID) {
        ArrayList<Long> lstUserIds = new ArrayList<Long>();
        lstUserIds.add(userID);
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        this.getUserMainOrgId(lstUserIds, orgIds, null);
        return orgIds.isEmpty() ? 0L : (Long)orgIds.get(0);
    }

    public List<Long> getUserMainOrgIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(userIds.size());
        this.getUserMainOrgId(userIds, orgIds, null);
        return orgIds;
    }

    public List<Map<Long, Long>> getUserMainOrgId(List<Long> lstUserIds) {
        if (CollectionUtils.isEmpty(lstUserIds)) {
            return new ArrayList<Map<Long, Long>>(0);
        }
        ArrayList<Map<Long, Long>> lstUsrDpts = new ArrayList<Map<Long, Long>>(lstUserIds.size());
        this.getUserMainOrgId(lstUserIds, null, lstUsrDpts);
        return lstUsrDpts;
    }

    private void getUserMainOrgId(List<Long> userIds, List<Long> orgIds, List<Map<Long, Long>> lstUsrDpts) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIds)};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,entryentity.ispartjob,entryentity.dpt", (QFilter[])filters);
        block0: for (Map.Entry entry : userObjMap.entrySet()) {
            DynamicObject userObj = (DynamicObject)entry.getValue();
            long userId = userObj.getLong("id");
            DynamicObjectCollection jobCol = userObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject jobObj : jobCol) {
                if (jobObj.getBoolean("ispartjob")) continue;
                long orgId = jobObj.getLong("dpt_id");
                if (orgIds != null) {
                    orgIds.add(orgId);
                }
                if (lstUsrDpts == null) continue block0;
                HashMap<Long, Long> mpOrg = new HashMap<Long, Long>(2);
                mpOrg.put(userId, orgId);
                lstUsrDpts.add(mpOrg);
                continue block0;
            }
        }
    }

    public void addOrUpdate(List<UserParam> userList) {
        UserSaveServiceImpl saveService = new UserSaveServiceImpl(userList);
        saveService.save();
    }

    public List<Long> getAllUserType(boolean includeDisable) {
        QFilter[] filters = null;
        QFilter isvisibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        if (includeDisable) {
            filters = new QFilter[]{isvisibleFilter};
        } else {
            QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
            filters = new QFilter[]{isvisibleFilter, enableFilter};
        }
        Map usertypeObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (String)"id", (QFilter[])filters, (String)NUMBER);
        ArrayList<Long> usertypeList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Map)usertypeObjMap)) {
            usertypeList = new ArrayList(0);
        } else {
            usertypeList = new ArrayList(usertypeObjMap.size());
            for (DynamicObject usertypeObj : usertypeObjMap.values()) {
                usertypeList.add(usertypeObj.getLong("id"));
            }
        }
        return usertypeList;
    }

    public String getUserDefaultPsw() {
        return PswStrategyUtils.getEncryptedUserDefaultPsw((String)RequestContext.get().getTenantId());
    }

    public Set<Long> getAllUsersOfOrg(int jobType, List<Long> orgIds, boolean includeSubOrg, boolean includeDisableUser) {
        QFilter[] filters;
        Map userObjMap;
        QFilter partJobFilter;
        QFilter orgFilter;
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashSet<Long>(0);
        }
        if (includeSubOrg) {
            List lstSubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true);
            orgFilter = new QFilter(PROP_ENTRYENTITY_DPT, "in", (Object)lstSubOrgs);
        } else {
            orgFilter = new QFilter(PROP_ENTRYENTITY_DPT, "in", orgIds);
        }
        if (jobType == 1) {
            partJobFilter = new QFilter(PROP_ENTRYENTITY_ISPARTJOB, "=", (Object)Boolean.FALSE);
            orgFilter = orgFilter.and(partJobFilter);
        } else if (jobType == 2) {
            partJobFilter = new QFilter(PROP_ENTRYENTITY_ISPARTJOB, "=", (Object)Boolean.TRUE);
            orgFilter = orgFilter.and(partJobFilter);
        }
        if (!includeDisableUser) {
            QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
            orgFilter = orgFilter.and(enableFilter);
        }
        if (CollectionUtils.isEmpty((Map)(userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id", (QFilter[])(filters = new QFilter[]{orgFilter}))))) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> userIds = new HashSet<Long>(userObjMap.size());
        for (DynamicObject userObj : userObjMap.values()) {
            userIds.add(userObj.getLong("id"));
        }
        return userIds;
    }

    public List<Map<String, Object>> getAllUserContactType() {
        String selectFields = "id,number,name,enable";
        Map contactTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user_contacttype", (String)selectFields, null, (String)NUMBER);
        if (CollectionUtils.isEmpty((Map)contactTypeMap)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> contactTypeList = new ArrayList<Map<String, Object>>(contactTypeMap.size());
        HashMap<String, Object> contactTypeInfoMap = null;
        for (DynamicObject contactTypeObj : contactTypeMap.values()) {
            contactTypeInfoMap = new HashMap<String, Object>(4);
            contactTypeInfoMap.put("id", contactTypeObj.getPkValue());
            contactTypeInfoMap.put(NUMBER, contactTypeObj.getString(NUMBER));
            contactTypeInfoMap.put("name", contactTypeObj.getString("name"));
            contactTypeInfoMap.put(PROP_ENABLE, contactTypeObj.getBoolean(PROP_ENABLE));
            contactTypeList.add(contactTypeInfoMap);
        }
        return contactTypeList;
    }

    public Map<Long, Map<String, List<String>>> getUserContact(List<Long> userIds) {
        QFilter[] filters = null;
        if (userIds != null) {
            QFilter idFilter = new QFilter("id", "in", userIds);
            filters = new QFilter[]{idFilter};
        }
        return this.loadUserContact(filters);
    }

    public Map<Long, List<String>> getUserContact(String contactTypeNumber, List<Long> userIds) {
        if (StringUtils.isBlank((CharSequence)contactTypeNumber)) {
            return new HashMap<Long, List<String>>(0);
        }
        QFilter contactTypeFilter = new QFilter("contactentity.contacttype.number", "=", (Object)contactTypeNumber);
        if (userIds != null) {
            QFilter idFilter = new QFilter("id", "in", userIds);
            contactTypeFilter = contactTypeFilter.and(idFilter);
        }
        QFilter[] filters = new QFilter[]{contactTypeFilter};
        Map<Long, Map<String, List<String>>> userContactTypeMap = this.loadUserContact(filters);
        HashMap<Long, List<String>> userContactMap = new HashMap<Long, List<String>>(userContactTypeMap.size());
        for (Map.Entry<Long, Map<String, List<String>>> entry : userContactTypeMap.entrySet()) {
            userContactMap.put(entry.getKey(), entry.getValue().get(contactTypeNumber));
        }
        return userContactMap;
    }

    private Map<Long, Map<String, List<String>>> loadUserContact(QFilter[] filters) {
        String selectFileds = "id,contactentity.contacttype,contactentity.contact,contactentity.isdefault";
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFileds, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)userObjMap)) {
            return new HashMap<Long, Map<String, List<String>>>(0);
        }
        HashMap<Long, Map<String, List<String>>> userContactMap = new HashMap<Long, Map<String, List<String>>>(userObjMap.size());
        for (DynamicObject userObj : userObjMap.values()) {
            DynamicObjectCollection contactEntity;
            long userId = userObj.getLong("id");
            HashMap contactTypeMap = (HashMap)userContactMap.get(userId);
            if (contactTypeMap == null) {
                contactTypeMap = new HashMap();
            }
            if (CollectionUtils.isEmpty((Collection)(contactEntity = userObj.getDynamicObjectCollection("contactentity")))) continue;
            for (DynamicObject contactEntityObj : contactEntity) {
                String contact;
                DynamicObject contactTypeObj = contactEntityObj.getDynamicObject("contacttype");
                if (contactTypeObj == null || StringUtils.isBlank((CharSequence)(contact = contactEntityObj.getString("contact")))) continue;
                String currentType = contactTypeObj.getString(NUMBER);
                ArrayList<String> contactList = (ArrayList<String>)contactTypeMap.get(currentType);
                if (contactList == null) {
                    contactList = new ArrayList<String>();
                    contactTypeMap.put(currentType, contactList);
                }
                if (contactEntityObj.getBoolean("isdefault") && !contactList.isEmpty()) {
                    contactList.add(0, contact);
                    continue;
                }
                contactList.add(contact);
            }
            userContactMap.put(userId, contactTypeMap);
        }
        return userContactMap;
    }

    public Map<Long, String> getUserAvatarPath(List<Long> userIds, boolean isGetFullPath) {
        if (CollectionUtils.isEmpty(userIds)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> avatarPathMap = new HashMap<Long, String>(userIds.size());
        String selectFields = "id,usertype,picturefield";
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{idFilter};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)userObjMap)) {
            return avatarPathMap;
        }
        for (Map.Entry userEntry : userObjMap.entrySet()) {
            DynamicObject userObj = (DynamicObject)userEntry.getValue();
            String avatarPath = userObj.getString("picturefield");
            if (StringUtils.isBlank((CharSequence)avatarPath)) {
                avatarPath = "/images/pc/emotion/default_person_82_82.png";
            } else if (isGetFullPath && !avatarPath.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                if ("7".equals(userObj.getString(USERTYPE))) {
                    if (!(AVATAR_ADMIN.equals(avatarPath) || AVATAR_COSMIC_AD.equals(avatarPath) || AVATAR_SUPER_AD.equals(avatarPath) || AVATAR_AUDIT_AD.equals(avatarPath) || AVATAR_SAFE_AD.equals(avatarPath))) {
                        avatarPath = UrlService.getImageFullUrl((String)avatarPath);
                    }
                } else {
                    avatarPath = UrlService.getImageFullUrl((String)avatarPath);
                }
            }
            avatarPathMap.put(userObj.getLong("id"), avatarPath);
        }
        return avatarPathMap;
    }

    public Map<Long, Long> getCompanyByUserIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(userIds.size());
        HashMap<Long, Set<Long>> org2UserIdMapping = new HashMap<Long, Set<Long>>(userIds.size());
        HashMap<String, Set<Long>> longNumber2OrgMapping = new HashMap<String, Set<Long>>(16);
        HashSet<String> patternOrPatternTypeSet = new HashSet<String>(Arrays.asList("1", "2"));
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter jobFilter = new QFilter(PROP_ENTRYENTITY_ISPARTJOB, "=", (Object)"0");
        QFilter[] userFilters = new QFilter[]{idFilter, jobFilter};
        String userSelectFields = "id,entryentity.dpt.id orgId, entryentity.orgstructure.org.orgpattern.patterntype patterntype, entryentity.orgstructure.longnumber longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceHelper.getCompanyByUserIds.user", (String)"bos_user", (String)userSelectFields, (QFilter[])userFilters, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long userId = row.getLong("id");
                Long orgId = row.getLong(ORG_ID);
                String orgPatternType = row.getString("patterntype");
                if (patternOrPatternTypeSet.contains(orgPatternType)) {
                    result.put(userId, orgId);
                    continue;
                }
                Set ids = org2UserIdMapping.computeIfAbsent(orgId, k -> new HashSet(16));
                ids.add(userId);
                for (String longNumber = row.getString("longnumber"); longNumber != null && longNumber.contains("!"); longNumber = longNumber.substring(0, longNumber.lastIndexOf("!".charAt(0)))) {
                    Set orgIds = longNumber2OrgMapping.computeIfAbsent(longNumber, k -> new HashSet(16));
                    orgIds.add(orgId);
                }
            }
        }
        result.putAll(UserServiceImpl.getCompanyByParentOrgLongNumber(org2UserIdMapping, longNumber2OrgMapping));
        return result;
    }

    private static Map<Long, Long> getCompanyByParentOrgLongNumber(Map<Long, Set<Long>> org2UserIdMap, Map<String, Set<Long>> parentLongNumber2OrgMap) {
        if (parentLongNumber2OrgMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        QFilter treeTypeFilter = new QFilter("view.number", "=", (Object)"01");
        HashSet<String> patternOrPatternTypeSet = new HashSet<String>(Arrays.asList("1", "2"));
        QFilter allLongNumberFilter = new QFilter("longnumber", "in", parentLongNumber2OrgMap.keySet());
        QFilter patternTypeFilter = new QFilter("org.orgpattern.patterntype", "in", patternOrPatternTypeSet);
        QFilter[] filters = new QFilter[]{treeTypeFilter, patternTypeFilter, allLongNumberFilter};
        String selectFields = "org, org.orgpattern.patterntype patterntype, longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceHelper.getCompanyByUserIds.parent", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber desc");){
            while (ds.hasNext()) {
                result.putAll(UserServiceImpl.generateCompanyByParentOrg(org2UserIdMap, parentLongNumber2OrgMap, ds.next()));
            }
        }
        return result;
    }

    private static Map<Long, Long> generateCompanyByParentOrg(Map<Long, Set<Long>> org2UserIdMap, Map<String, Set<Long>> parentLongNumber2OrgMap, Row row) {
        Long orgId = row.getLong("org");
        String longNumber = row.getString("longnumber");
        Set<Long> subOrgIds = parentLongNumber2OrgMap.get(longNumber);
        HashMap<Long, Long> result = new HashMap<Long, Long>(subOrgIds.size());
        for (Long subOrgId : subOrgIds) {
            Set<Long> userIds = org2UserIdMap.remove(subOrgId);
            if (CollectionUtils.isEmpty(userIds)) continue;
            userIds.forEach(userId -> result.put((Long)userId, orgId));
        }
        return result;
    }

    public List<Long> getInchargeOrgs(long userId, boolean isIncludeSubOrg) {
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        if (userObj == null) {
            return new ArrayList<Long>(0);
        }
        DynamicObjectCollection positionObjCol = userObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)positionObjCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> inchargeOrgs = new ArrayList<Long>(positionObjCol.size());
        for (DynamicObject positionObj : positionObjCol) {
            DynamicObject orgObj;
            if (!positionObj.getBoolean("isincharge") || (orgObj = positionObj.getDynamicObject("dpt")) == null) continue;
            inchargeOrgs.add(orgObj.getLong("id"));
        }
        if (isIncludeSubOrg) {
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, inchargeOrgs, (boolean)true);
        }
        return inchargeOrgs;
    }

    public Map<Long, Integer> getUserBaseTypeByIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return new HashMap<Long, Integer>(0);
        }
        Map<Long, List<Long>> partnerUserTypeMap = this.getBizPartnerUserType(userIds);
        HashMap<Long, Integer> usertypeMap = new HashMap<Long, Integer>(userIds.size());
        String selectFields = "id,usertypes.fbasedataid fbasedataid,usertypes.fbasedataid.category category";
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{idFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceImpl.getUserBaseTypeByIds", (String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                int rowBaseType;
                Long userId = row.getLong("id");
                String category = row.getString("category");
                if ("1".equals(category)) {
                    rowBaseType = 100;
                } else {
                    List<Long> partnerUserTypeIds = partnerUserTypeMap.get(userId);
                    if (partnerUserTypeIds == null || !partnerUserTypeIds.contains(row.getLong("fbasedataid"))) continue;
                    rowBaseType = 200;
                }
                Integer baseType = (Integer)usertypeMap.get(userId);
                if (baseType == null) {
                    usertypeMap.put(userId, rowBaseType);
                    continue;
                }
                if (baseType == rowBaseType) continue;
                usertypeMap.put(userId, 300);
            }
        }
        return usertypeMap;
    }

    private Map<Long, List<Long>> getBizPartnerUserType(List<Long> userIds) {
        HashMap<Long, List<Long>> userTypeMap = new HashMap<Long, List<Long>>(userIds.size());
        String selectFields = "user,usertype";
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{userFilter, enableFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceImpl.getUserBaseTypeByIds", (String)ENTITY_BIZPARTNERUSER, (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                String[] userTypeArr;
                String userType = row.getString(USERTYPE);
                if (StringUtils.isBlank((CharSequence)userType)) continue;
                Long userId = row.getLong("user");
                ArrayList<Long> userTypeIds = (ArrayList<Long>)userTypeMap.get(userId);
                if (userTypeIds == null) {
                    userTypeIds = new ArrayList<Long>(16);
                    userTypeMap.put(userId, userTypeIds);
                }
                for (String type : userTypeArr = userType.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                    userTypeIds.add(Long.valueOf(type));
                }
            }
        }
        return userTypeMap;
    }

    public List<Long> getBizPartnerByUserId(long userId) {
        return this.getBizPartnerByUserId(userId, null);
    }

    public List<Long> getInChargeOfBizPartnerByUserId(long userId) {
        QFilter adminFilter = new QFilter("isadmin", "=", (Object)Boolean.TRUE);
        return this.getBizPartnerByUserId(userId, adminFilter);
    }

    private List<Long> getBizPartnerByUserId(long userId, QFilter otherFilter) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        if (otherFilter != null) {
            userFilter = userFilter.and(otherFilter);
        }
        QFilter enableFilter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{userFilter, enableFilter};
        Map bizPartnerUserObjMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BIZPARTNERUSER, (String)"bizpartner", (QFilter[])filters, (String)BIZPARTNER_NUMBER);
        if (CollectionUtils.isEmpty((Map)bizPartnerUserObjMap)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> bizPartnerIds = new ArrayList<Long>(bizPartnerUserObjMap.size());
        for (DynamicObject bizPartnerUserObj : bizPartnerUserObjMap.values()) {
            DynamicObject bizPartnerObj = bizPartnerUserObj.getDynamicObject("bizpartner");
            if (bizPartnerObj == null) continue;
            bizPartnerIds.add(bizPartnerObj.getLong("id"));
        }
        return bizPartnerIds;
    }

    public Set<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable) {
        return this.getAllUsersOfOrg(orgIds, isFindSubOrg, includeDisable, "bos_userposition", new ArrayList<Long>());
    }

    public Set<Long> getAllPartnerUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable) {
        return this.getAllUsersOfOrg(orgIds, isFindSubOrg, includeDisable, ENTITY_BIZPARTNERUSER, new ArrayList<Long>());
    }

    private Set<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable, String entityName, List<Long> inUserIds) {
        QFilter orgFilter;
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> userIds = new HashSet<Long>();
        if (isFindSubOrg) {
            List lstSubOrgs = OrgServiceHelper.getAllSubordinateOrgs(orgIds, (boolean)true);
            orgFilter = new QFilter("org", "in", (Object)lstSubOrgs);
        } else {
            orgFilter = new QFilter("org", "in", orgIds);
        }
        if (!includeDisable) {
            orgFilter = orgFilter.and(new QFilter("user.enable", "=", (Object)Boolean.TRUE));
        }
        if (!CollectionUtils.isEmpty(inUserIds)) {
            orgFilter.and(new QFilter("user", "in", inUserIds));
        }
        QFilter[] filters = new QFilter[]{orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)("UserServiceImpl.getAllUsersOfOrg" + entityName), (String)entityName, (String)"user", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                userIds.add(row.getLong(0));
            }
        }
        return userIds;
    }

    public Map<String, String> updateBizPartnerUserInfo(Map<String, Object> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> apiResult = this.checkOpenApiPermission(ResManager.loadKDString((String)"\u4fee\u6539", (String)"UserServiceImpl_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), BOS_BIZPARTNERUSER_MODIFY_PERMITERM, "updateBizPartnerUserInfo");
        if (!apiResult.isEmpty()) {
            for (Map.Entry<String, Object> entry : apiResult.entrySet()) {
                String key = entry.getKey();
                String msg = entry.getValue().toString();
                result.put(key, msg);
            }
            return result;
        }
        List datas = (List)params.get("data");
        if (datas == null || datas.isEmpty()) {
            return result;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] userParam = null;
        for (Map data : datas) {
            Object error = data.get("error");
            if (StringUtils.isNotBlank(error)) {
                Object companyNumber = data.get("companyNumber");
                log.info("updateBizPartnerUserInfo\uff1a\u5546\u52a1\u4f19\u4f34\u7684number\u4e3a" + companyNumber + "\u66f4\u65b0\u5931\u8d25,\u83b7\u53d6\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + error);
                continue;
            }
            List partnerUsers = (List)data.get(PARTNER_USERS);
            for (Map partnerUser : partnerUsers) {
                if (partnerUser == null || StringUtils.isBlank((CharSequence)((CharSequence)partnerUser.get(PHONE)))) continue;
                long eid = 0L;
                String pEid = (String)partnerUser.get(PARTNER_EID);
                if (StringUtils.isBlank((CharSequence)pEid)) {
                    partnerUser.put(PARTNER_EID, "0");
                } else {
                    try {
                        eid = Long.parseLong(pEid);
                    }
                    catch (Exception e) {
                        log.warn("updateBizPartnerUserInfo\uff1a" + pEid + "\uff1a\u5546\u52a1\u4f19\u4f34\u7684partnerEid\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (Throwable)e);
                    }
                }
                long uid = 0L;
                String pUid = (String)partnerUser.get("uid");
                if (StringUtils.isBlank((CharSequence)pUid)) {
                    partnerUser.put("uid", "0");
                } else {
                    try {
                        uid = Long.parseLong(pUid);
                    }
                    catch (Exception e) {
                        log.warn("updateBizPartnerUserInfo\uff1a" + pUid + "\uff1a\u5546\u52a1\u4f19\u4f34\u7684uid\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (Throwable)e);
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)partnerUser.get("oid")))) {
                    partnerUser.put("oid", "");
                }
                userParam = new Object[]{eid, partnerUser.get("oid"), uid, partnerUser.get(PHONE)};
                paramsList.add(userParam);
            }
        }
        String updateSql = "update t_sec_user set feid= ?,fopenid = ?,fuid= ? where fphone = ? and (fusertype  <> '6' and fusertype <> '7' and fusertype not like '%,1,%'  and fusertype not like '1,%'  and fusertype not like '%,1' and fusertype <> '1')";
        if (paramsList.size() > 0) {
            try (TXHandle h = TX.required();){
                int[] nArray = DB.executeBatch((DBRoute)DBRoute.base, (String)updateSql, paramsList);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getBizPartnerUserInfo(Map<String, Object> params) {
        void var11_17;
        Map<Object, Object> bizPartnerUserInfo = new HashMap();
        bizPartnerUserInfo = this.checkOpenApiPermission(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"UserServiceImpl_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), BOS_BIZPARTNERUSER_VIEW_PERMITERM, "getBizPartnerUserInfo");
        if (!bizPartnerUserInfo.isEmpty()) {
            return bizPartnerUserInfo;
        }
        Long timestamp = 0L;
        if (null != params.get(TIMESTAMP) && !"".equals(params.get(TIMESTAMP))) {
            timestamp = Long.valueOf(params.get(TIMESTAMP).toString());
        }
        log.info("\u83b7\u53d6\u5546\u52a1\u4f19\u4f34\u7528\u6237\u4fe1\u606f\uff1a \u83b7\u53d6\u53c2\u6570\u65f6\u95f4\u6233timestamp=" + timestamp);
        HashSet<Object> usertypes = new HashSet<String>();
        if (null != params.get(USERTYPE) && !"".equals(params.get(USERTYPE))) {
            String[] usertype = params.get(USERTYPE).toString().split(",");
            usertypes = new HashSet<String>(Arrays.asList(usertype));
        }
        if (usertypes.isEmpty()) {
            usertypes.add("3");
        }
        HashSet<String> deletedata = new HashSet<String>();
        if (timestamp != 0L) {
            Date time = new Date(timestamp);
            QFilter qFilter1 = new QFilter(CHANGETIME, ">=", (Object)time);
            QFilter qFilter2 = new QFilter("type", "=", (Object)"4");
            QFilter qFilter3 = null;
            for (String string : usertypes) {
                if (qFilter3 == null) {
                    qFilter3 = new QFilter(USER_USERTYPE, "like", (Object)("%," + string + ",%")).or(new QFilter(USER_USERTYPE, "like", (Object)(string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string))).or(new QFilter(USER_USERTYPE, "=", (Object)string));
                    continue;
                }
                qFilter3.or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)(string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string))).or(new QFilter(USER_USERTYPE, "=", (Object)string));
            }
            ORM ormOV = ORM.create();
            try (DataSet dataSet = ormOV.queryDataSet(UserServiceHelper.class.getName(), entityID_userChange, PHONE, new QFilter[]{qFilter1, qFilter2, qFilter3});){
                for (Row row : dataSet) {
                    if (StringUtils.isBlank((CharSequence)row.getString(PHONE))) continue;
                    deletedata.add(row.getString(PHONE));
                }
            }
        }
        RequestContext requestContext = RequestContext.get();
        Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
        String eid = account.getEid();
        String tenantId = requestContext.getTenantId();
        QFilter[] qFilters = null;
        if (timestamp != 0L) {
            Date date = new Date(timestamp);
            QFilter qFilter1 = new QFilter(USER_EID, "=", (Object)0L);
            QFilter qFilter2 = new QFilter("user.MODIFYTIME", ">=", (Object)date);
            QFilter qFilter3 = new QFilter("user.CREATETIME", ">=", (Object)date);
            DynamicObject[] qFilter4 = qFilter1.or(qFilter2).or(qFilter3);
            QFilter qFilter5 = null;
            for (String string : usertypes) {
                if (qFilter5 == null) {
                    qFilter5 = new QFilter(USER_USERTYPE, "like", (Object)("%," + string + ",%")).or(new QFilter(USER_USERTYPE, "like", (Object)(string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string))).or(new QFilter(USER_USERTYPE, "=", (Object)string));
                    continue;
                }
                qFilter5.or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)(string + ",%"))).or(new QFilter(USER_USERTYPE, "like", (Object)("%," + string))).or(new QFilter(USER_USERTYPE, "=", (Object)string));
            }
            long userId = RequestContext.get().getCurrUserId();
            QFilter dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId, "base", ENTITY_BIZPARTNERUSER, BOS_BIZPARTNERUSER_VIEW_PERMITERM, null);
            qFilters = dataPermissionFilter != null ? new QFilter[]{qFilter4, qFilter5, dataPermissionFilter} : new QFilter[]{qFilter4, qFilter5};
        }
        Integer n = 0;
        if (StringUtils.isNotBlank((Object)params.get("pageindex"))) {
            Integer n2 = Integer.valueOf(params.get("pageindex").toString());
            log.info("\u83b7\u53d6\u5546\u52a1\u4f19\u4f34\u7528\u6237\u4fe1\u606f\uff1a \u83b7\u53d6\u5f53\u524d\u9875\u6570 pageIndex = " + n2);
        }
        Integer pagesize = 1000;
        log.info("\u83b7\u53d6\u5546\u52a1\u4f19\u4f34\u7528\u6237\u4fe1\u606f\uff1a \u83b7\u53d6\u53c2\u6570\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u7684 eid = " + eid + ",\u79df\u6237\u4e2d\u5fc3id:tenantId=" + tenantId);
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)ENTITY_BIZPARTNERUSER, (String)"bizpartner.number ,bizpartner.name,user.usertype, isadmin,org.id ,user.eid,user.phone,user.name", qFilters, (String)"id", (int)var11_17.intValue(), (int)pagesize);
        HashMap<String, Map<String, String>> bizpartnerDatas = new HashMap<String, Map<String, String>>(dobjs.length);
        for (DynamicObject dynamicObject : dobjs) {
            HashMap<String, String> partnerUser;
            ArrayList<HashMap<String, String>> partnerUsers;
            String usertype;
            Map<String, String> data = null;
            if (!bizpartnerDatas.containsKey(dynamicObject.getString(BIZPARTNER_NUMBER))) {
                data = new HashMap<String, String>();
                data.put("companyName", dynamicObject.getString("bizpartner.name"));
                data.put("companyNumber", dynamicObject.getString(BIZPARTNER_NUMBER));
                if ("true".equals(dynamicObject.getString("isadmin"))) {
                    usertype = dynamicObject.getString(USER_USERTYPE);
                    if (usertype != null && usertype.contains("4")) {
                        data.put(PARTNER_TYPE, "1");
                    } else {
                        data.put(PARTNER_TYPE, "2");
                    }
                    if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString(USER_EID)) && !"0".equals(dynamicObject.getString(USER_EID))) {
                        data.put(PARTNER_EID, dynamicObject.getString(USER_EID));
                    } else {
                        data.put(PARTNER_EID, null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("org.id")) && !"0".equals(dynamicObject.getString("org.id"))) {
                        data.put(ORG_ID, dynamicObject.getString("org.id"));
                    } else {
                        data.put(ORG_ID, null);
                    }
                }
                partnerUsers = new ArrayList<HashMap<String, String>>();
                partnerUser = new HashMap();
                partnerUser.put(PHONE, dynamicObject.getString("user.phone"));
                partnerUser.put("name", dynamicObject.getString("user.name"));
                partnerUsers.add(partnerUser);
                data.put(PARTNER_USERS, (String)((Object)partnerUsers));
            } else {
                data = (Map)bizpartnerDatas.get(dynamicObject.getString(BIZPARTNER_NUMBER));
                if ("true".equals(dynamicObject.getString("isadmin"))) {
                    usertype = dynamicObject.getString(USER_USERTYPE);
                    if (usertype != null && usertype.contains("4")) {
                        data.put(PARTNER_TYPE, "1");
                    } else {
                        data.put(PARTNER_TYPE, "2");
                    }
                    if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString(USER_EID)) && !"0".equals(dynamicObject.getString(USER_EID))) {
                        data.put(PARTNER_EID, dynamicObject.getString(USER_EID));
                    } else {
                        data.put(PARTNER_EID, null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("org.id")) && !"0".equals(dynamicObject.getString("org.id"))) {
                        data.put(ORG_ID, dynamicObject.getString("org.id"));
                    } else {
                        data.put(ORG_ID, null);
                    }
                }
                partnerUsers = (ArrayList<HashMap<String, String>>)data.get(PARTNER_USERS);
                partnerUser = new HashMap<String, String>();
                partnerUser.put(PHONE, dynamicObject.getString("user.phone"));
                partnerUser.put("name", dynamicObject.getString("user.name"));
                partnerUsers.add(partnerUser);
                data.put(PARTNER_USERS, (String)((Object)partnerUsers));
            }
            bizpartnerDatas.put(dynamicObject.getString(BIZPARTNER_NUMBER), data);
        }
        ArrayList<Map> values = new ArrayList<Map>(bizpartnerDatas.size());
        for (Map bizpartnerData : bizpartnerDatas.values()) {
            values.add(bizpartnerData);
        }
        bizPartnerUserInfo.put(NUMBER, tenantId);
        bizPartnerUserInfo.put("eid", eid);
        bizPartnerUserInfo.put("data", values);
        bizPartnerUserInfo.put("deletedata", new ArrayList(deletedata));
        return bizPartnerUserInfo;
    }

    private Map<String, Object> checkOpenApiPermission(String operate, String permissionItemId, String openApiPermission) {
        long userId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject openApiServiceBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_OPEN_API_SERVICE_NEW, (String)ORG_AUTHOR_FILTER, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)openApiPermission)});
        boolean isOrgAuthorFilter = false;
        try {
            if (openApiServiceBizObj != null && openApiServiceBizObj.get(ORG_AUTHOR_FILTER) != null) {
                isOrgAuthorFilter = openApiServiceBizObj.getBoolean(ORG_AUTHOR_FILTER);
            }
        }
        catch (Exception e) {
            isOrgAuthorFilter = false;
        }
        if (isOrgAuthorFilter && !PermissionServiceHelper.checkPermission((Long)(userId = RequestContext.get().getCurrUserId()), (String)"base", (String)ENTITY_BIZPARTNERUSER, (String)permissionItemId)) {
            log.error("\u60a8\u6ca1\u6709\u5546\u52a1\u4f19\u4f34\u7528\u6237\u7684%1$s\u6743\u9650\u3002", (Object)operate);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5546\u52a1\u4f19\u4f34\u7528\u6237\u7684%1$s\u6743\u9650\u3002", (String)"UserServiceImpl_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), operate);
            result.put("success", "false");
            result.put("error", errorMsg);
            result.put("errorCode", "0");
        }
        return result;
    }

    public Set<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable, List<Long> inUserIds) {
        return this.getAllUsersOfOrg(orgIds, isFindSubOrg, includeDisable, "bos_userposition", inUserIds);
    }

    public Map<String, List<Long>> getPersonByCondition(List<Map<String, Object>> personQueryParams) {
        if (CollectionUtils.isEmpty(personQueryParams)) {
            return new HashMap<String, List<Long>>(0);
        }
        List<Long> orgIdsList = new ArrayList<Long>(8);
        for (Map<String, Object> orgMap : personQueryParams) {
            orgIdsList.add((Long)orgMap.get(ORG_ID));
        }
        Map<Long, Object> orgLong = this.getLongNumberByOrgIds(orgIdsList);
        Map<Long, Set<Long>> orgAndSub = this.getSubOrgIdsByLongNumber(1L, orgLong);
        for (Set<Long> subOrgId : orgAndSub.values()) {
            orgIdsList.addAll(subOrgId);
        }
        orgIdsList = orgIdsList.stream().distinct().collect(Collectors.toList());
        List<Map<String, Object>> personQueryParam = this.getUsersIdByOrgIds(orgIdsList);
        return this.buildUsersOfOrg(personQueryParams, personQueryParam, orgAndSub);
    }

    private Map<String, List<Long>> buildUsersOfOrg(List<Map<String, Object>> personQueryParams, List<Map<String, Object>> personQueryParam, Map<Long, Set<Long>> orgAndSub) {
        String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684key\u503c\uff1a%1$s", (String)"UserServiceImpl_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), ORG_ID);
        HashMap<String, List<Long>> usersOfOrg = new HashMap<String, List<Long>>(8);
        for (Map<String, Object> orgMap : personQueryParams) {
            List<Long> userIds = new ArrayList<Long>(16);
            String orgId = orgMap.get(ORG_ID) == null ? errorMsg : orgMap.get(ORG_ID);
            boolean isIncludeSubOrg = orgMap.get("isIncludeSubOrg") != null && (Boolean)orgMap.get("isIncludeSubOrg") != false;
            Set<Object> subOrgIds = orgAndSub.get(orgId) == null ? new HashSet(0) : orgAndSub.get(orgId);
            for (Map<String, Object> orgUserMap : personQueryParam) {
                Object dptId = orgUserMap.get(F_DPTID);
                if (isIncludeSubOrg) {
                    if (!orgId.equals(dptId) && !subOrgIds.contains(dptId)) continue;
                    userIds = this.getUserIdsByCondition(orgMap, orgUserMap, userIds);
                    continue;
                }
                if (!orgId.equals(dptId)) continue;
                userIds = this.getUserIdsByCondition(orgMap, orgUserMap, userIds);
            }
            usersOfOrg.put(orgId.toString(), userIds);
        }
        return usersOfOrg;
    }

    private Map<Long, Object> getLongNumberByOrgIds(List<Long> orgIdsList) {
        QFilter orgFilter = new QFilter("org", "in", orgIdsList);
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter[] orgFilters = new QFilter[]{orgFilter, viewFilter};
        DynamicObjectCollection orgObjCollection = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,longnumber", (QFilter[])orgFilters);
        if (CollectionUtils.isEmpty((Collection)orgObjCollection)) {
            return new HashMap<Long, Object>(0);
        }
        HashMap<Long, Object> orgLong = new HashMap<Long, Object>(orgObjCollection.size());
        for (DynamicObject orgObj : orgObjCollection) {
            orgLong.put((Long)orgObj.get("org"), orgObj.get("longnumber"));
        }
        return orgLong;
    }

    private Map<Long, Set<Long>> getSubOrgIdsByLongNumber(Long orgViewType, Map<Long, Object> orgLong) {
        if (MapUtils.isEmpty(orgLong)) {
            return new HashMap<Long, Set<Long>>(0);
        }
        QFilter viewFilter = new QFilter("view", "=", (Object)orgViewType);
        QFilter longNumFilter = new QFilter("1", "=", (Object)2);
        for (Object longNumber : orgLong.values()) {
            QFilter longNumberFilter = new QFilter("longnumber", "like", (Object)(longNumber + "!%"));
            longNumFilter.or(longNumberFilter);
        }
        QFilter[] subOrgFilters = new QFilter[]{viewFilter, longNumFilter};
        DynamicObjectCollection subOrgObjCollection = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,longnumber", (QFilter[])subOrgFilters);
        HashMap<Long, Set<Long>> orgAndSub = new HashMap<Long, Set<Long>>(8);
        if (CollectionUtils.isEmpty((Collection)subOrgObjCollection)) {
            return orgAndSub;
        }
        for (DynamicObject subOrgObj : subOrgObjCollection) {
            for (Map.Entry<Long, Object> entry : orgLong.entrySet()) {
                long orgId = entry.getKey();
                Set subOrgIds = orgAndSub.computeIfAbsent(orgId, k -> new HashSet(4));
                if (!subOrgObj.get("longnumber").toString().contains(orgLong.get(orgId).toString() + "!")) continue;
                subOrgIds.add((Long)subOrgObj.get("org"));
                orgAndSub.put(orgId, subOrgIds);
            }
        }
        return orgAndSub;
    }

    private List<Map<String, Object>> getUsersIdByOrgIds(List<Long> orgIdsList) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT up.fdptid, u.fid, up.fisincharge, u.fenable ", new Object[0]);
        sql.append("from t_sec_user u ", new Object[0]);
        sql.append("inner join t_sec_user_u uu on u.fid = uu.fid ", new Object[0]);
        sql.append("inner join t_sec_userposition up on u.fid = up.fid ", new Object[0]);
        sql.append("where uu.fisforbidden = '0' and ", new Object[0]);
        sql.appendIn("up.fdptid", orgIdsList.toArray());
        ArrayList<Map<String, Object>> personQueryParam = new ArrayList<Map<String, Object>>(16);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                HashMap<String, Object> userMap = new HashMap<String, Object>(16);
                long dptId = rs.getLong(F_DPTID);
                long userId = rs.getLong(FID);
                String isManager = rs.getString(F_ISINCHARGE);
                String isEnable = rs.getString(F_ENABLE);
                userMap.put(F_DPTID, dptId);
                userMap.put(FID, userId);
                userMap.put(F_ISINCHARGE, isManager);
                userMap.put(F_ENABLE, isEnable);
                personQueryParam.add(userMap);
            }
            return personQueryParam;
        });
        return personQueryParam;
    }

    private List<Long> getUserIdsByCondition(Map<String, Object> orgMap, Map<String, Object> orgUserMap, List<Long> userIds) {
        boolean isIncludeDisable = orgMap.get("isIncludeDisable") != null && (Boolean)orgMap.get("isIncludeDisable") != false;
        List<Long> userIdsList = new ArrayList<Long>(userIds);
        if (!isIncludeDisable && orgUserMap.get(F_ENABLE).toString().equals("1")) {
            userIdsList = this.isManager(orgMap, orgUserMap, userIds);
        }
        if (isIncludeDisable) {
            userIdsList = this.isManager(orgMap, orgUserMap, userIds);
        }
        return userIdsList;
    }

    private List<Long> isManager(Map<String, Object> orgMap, Map<String, Object> orgUserMap, List<Long> userIds) {
        boolean isManager = orgMap.get("isManager") != null && (Boolean)orgMap.get("isManager") != false;
        long userId = (Long)orgUserMap.get(FID);
        if (!isManager) {
            userIds.add(userId);
        }
        if (isManager && orgUserMap.get(F_ISINCHARGE).toString().equals("1")) {
            userIds.add(userId);
        }
        return userIds;
    }

    public Map<Long, String> enablePosition(Set<Long> positionIds) {
        if (positionIds.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        return this.execute(positionIds, PROP_ENABLE, BOS_POSITION, null, new HashMap<Long, String>(8));
    }

    public Map<Long, String> disablePosition(Set<Long> positionIds) {
        if (positionIds.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        return this.execute(positionIds, "disable", BOS_POSITION, null, new HashMap<Long, String>(8));
    }

    public Map<Long, String> deletePosition(Set<Long> positionIds) {
        if (positionIds.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        return this.execute(positionIds, "delete", BOS_POSITION, null, new HashMap<Long, String>(8));
    }

    public Map<Long, Set<DynamicObject>> getPeopleUnderPosition(Set<Long> positionIds) {
        QFilter positionIdFilter = new QFilter("post", "in", positionIds);
        Map dptObjsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (QFilter[])new QFilter[]{positionIdFilter});
        HashMap<Long, Set<DynamicObject>> positionUserMap = new HashMap<Long, Set<DynamicObject>>(positionIds.size());
        for (Map.Entry entry : dptObjsMap.entrySet()) {
            DynamicObject postObj = ((DynamicObject)entry.getValue()).getDynamicObject("post");
            DynamicObject userObj = ((DynamicObject)entry.getValue()).getDynamicObject("user");
            if (postObj == null || userObj == null) continue;
            Set userIds = positionUserMap.computeIfAbsent(postObj.getLong("id"), k -> new HashSet(8));
            userIds.add(userObj);
            positionUserMap.put(postObj.getLong("id"), userIds);
        }
        return positionUserMap;
    }

    public Object addOrUpdatePositions(List<Position> positionList) {
        UserPositionSaveServiceImpl userPositionSaveService = new UserPositionSaveServiceImpl(positionList);
        return userPositionSaveService.save();
    }

    public Map<Long, String> addOrUpdatePosition(List<Map<String, String>> positionList) {
        if (positionList.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> resultsMap = new HashMap<Long, String>(positionList.size());
        this.addOrUpdatePosition(positionList, resultsMap);
        return resultsMap;
    }

    @Deprecated
    private void addOrUpdatePosition(List<Map<String, String>> addOrUpdatePositionList, Map<Long, String> resultsMap) {
        ArrayList<DynamicObject> positionObjs = new ArrayList<DynamicObject>(addOrUpdatePositionList.size());
        ArrayList<Long> idList = new ArrayList<Long>(addOrUpdatePositionList.size());
        long i = 0L;
        for (Map<String, String> positionMap : addOrUpdatePositionList) {
            if (positionMap.get(ISMAINPOSIITON) != null && !"false".equals(positionMap.get(ISMAINPOSIITON)) && !"true".equals(positionMap.get(ISMAINPOSIITON))) {
                resultsMap.put(i++, ResManager.loadKDString((String)"\u4e3b\u8981\u804c\u4f4d\uff1a\u8bf7\u8f93\u5165true\u6216false\u3002", (String)"UserServiceImpl_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (positionMap.get("id") == null) continue;
            long id = Long.parseLong(positionMap.get("id"));
            idList.add(id);
        }
        Map positionObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        for (Map<String, String> positionMap : addOrUpdatePositionList) {
            if (positionMap.get("id") == null) {
                this.buildPositionObjs(null, positionMap, positionObjs);
                continue;
            }
            long id = Long.parseLong(positionMap.get("id"));
            DynamicObject positionObj = (DynamicObject)positionObjMap.get(id);
            this.buildPositionObjs(positionObj, positionMap, positionObjs);
        }
        this.execute(new HashSet<Long>(0), "save", BOS_POSITION, positionObjs.toArray(new DynamicObject[0]), resultsMap);
    }

    private void buildPositionObjs(DynamicObject positionObj, Map<String, String> positionMap, List<DynamicObject> positionObjs) {
        if (positionObj == null) {
            positionObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_POSITION);
            OrgViewUtils.genCommonField((DynamicObject)positionObj, (boolean)true);
        }
        if (positionMap.get("id") != null) {
            positionObj.set("id", (Object)Long.parseLong(positionMap.get("id")));
        }
        if (positionMap.get(NUMBER) != null && !positionMap.get(NUMBER).equals(positionObj.get(NUMBER))) {
            positionObj.set(NUMBER, (Object)positionMap.get(NUMBER));
        }
        if (positionMap.get("name") != null && !positionMap.get("name").equals(positionObj.get("name"))) {
            positionObj.set("name", (Object)positionMap.get("name"));
        }
        if (positionMap.get(DPTID) != null && !positionMap.get(DPTID).equals(positionObj.getString(DPT_ID))) {
            DynamicObject dptObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_adminorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(positionMap.get(DPTID)))});
            positionObj.set("dpt", (Object)dptObj);
        }
        if (positionMap.get(ISMAINPOSIITON) != null && !positionMap.get(ISMAINPOSIITON).equals(positionObj.getString(ISMAINPOSIITON))) {
            positionObj.set(ISMAINPOSIITON, (Object)positionMap.get(ISMAINPOSIITON));
        }
        if (positionMap.get(SUPPOSITIONID) != null) {
            DynamicObject supPositionObj = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(positionMap.get(SUPPOSITIONID)))});
            positionObj.set(SUPPOSITION, (Object)supPositionObj);
        }
        if (positionMap.get(REMARKS) != null && !positionMap.get(REMARKS).equals(positionObj.get(REMARKS))) {
            positionObj.set(REMARKS, (Object)positionMap.get(REMARKS));
        }
        long userId = RequestContext.get().getCurrUserId();
        positionObj.set("modifier", (Object)userId);
        positionObj.set("modifytime", (Object)new java.util.Date());
        positionObjs.add(positionObj);
    }

    private Map<Long, String> execute(Set<Long> ids, String operation, String entityNumber, DynamicObject[] dynamicObjects, Map<Long, String> operateResultMap) {
        if (ids.isEmpty() && dynamicObjects == null) {
            return new HashMap<Long, String>(0);
        }
        try {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
            operateOption.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
            OperationResult result = null;
            if (!ids.isEmpty()) {
                result = OperationServiceHelper.executeOperate((String)operation, (String)entityNumber, (Object[])ids.toArray(new Long[0]), (OperateOption)operateOption);
            }
            if (dynamicObjects != null) {
                result = OperationServiceHelper.executeOperate((String)operation, (String)entityNumber, (DynamicObject[])dynamicObjects, (OperateOption)operateOption);
            }
            if (result == null) {
                log.info("\u6267\u884c[" + entityNumber + "]\u64cd\u4f5c[" + operation + "]\u5931\u8d25\uff1a\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a\u3002");
            } else {
                this.getOperateResultMap(result, operateResultMap);
            }
        }
        catch (Exception e) {
            log.warn("\u6267\u884c[" + entityNumber + "]\u64cd\u4f5c[" + operation + "]\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return operateResultMap;
    }

    private void getOperateResultMap(OperationResult result, Map<Long, String> operateResultMap) {
        for (Object successId : result.getSuccessPkIds()) {
            operateResultMap.put(Long.parseLong(successId.toString()), "");
        }
        for (IOperateInfo iOperateInfo : result.getAllErrorOrValidateInfo()) {
            long failId = Long.parseLong(iOperateInfo.getPkValue().toString());
            if (operateResultMap.get(failId) != null) {
                ++failId;
            }
            String failMsg = iOperateInfo.getMessage();
            operateResultMap.put(failId, failMsg);
        }
    }

    @Deprecated
    public Map<Long, String> setMainPositionByDptIds(Map<Long, Long> mainPositionIds) {
        if (mainPositionIds.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> opResult = new HashMap<Long, String>(8);
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        QFilter idFilter = new QFilter("id", "in", mainPositionIds.values());
        QFilter orgQFilter = new QFilter("dpt", "in", mainPositionIds.keySet());
        Map newMainPositionMap = BusinessDataServiceHelper.loadFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{idFilter, orgQFilter});
        if (newMainPositionMap.isEmpty()) {
            result.put(0L, ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u5c97\u4f4did\u4e0d\u5b58\u5728\u6216\u90e8\u95e8id\u548c\u5c97\u4f4did\u4e0d\u5339\u914d\u3002", (String)"UserServiceImpl_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return result;
        }
        this.getMsg(newMainPositionMap, mainPositionIds, result);
        Map<Long, DynamicObject> positionToSPosition = this.getPositionToSPosition(mainPositionIds.values());
        for (Map.Entry mainPositions : newMainPositionMap.entrySet()) {
            DynamicObject positionObj = (DynamicObject)mainPositions.getValue();
            positionObj.set(SUPPOSITION, positionToSPosition.getOrDefault(positionObj.getLong("id"), null));
            positionObj.set(ISMAINPOSIITON, (Object)true);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)BOS_POSITION, (DynamicObject[])newMainPositionMap.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        this.getOperateResultMap(operationResult, opResult);
        for (Map.Entry entry : opResult.entrySet()) {
            for (DynamicObject dynamicObject : newMainPositionMap.values()) {
                if (((Long)entry.getKey()).longValue() != dynamicObject.getLong("masterid")) continue;
                result.put(Long.parseLong(dynamicObject.get(DPT_ID).toString()), (String)entry.getValue());
            }
        }
        return result;
    }

    private void getMsg(Map<Object, DynamicObject> newMainPositionMap, Map<Long, Long> mainPositionIds, Map<Long, String> result) {
        for (Map.Entry<Long, Long> positionIdsMap : mainPositionIds.entrySet()) {
            if (newMainPositionMap.containsKey(positionIdsMap.getValue())) continue;
            result.put(positionIdsMap.getKey(), ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u5c97\u4f4did\u4e0d\u5b58\u5728\u6216\u90e8\u95e8id\u548c\u5c97\u4f4did\u4e0d\u5339\u914d\u3002", (String)"UserServiceImpl_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            newMainPositionMap.remove(positionIdsMap.getKey());
        }
    }

    private Map<Long, DynamicObject> getPositionToSPosition(Collection<Long> positionIds) {
        QFilter positionFilter = new QFilter("position", "in", positionIds);
        QFilter reportTypeListFilter = new QFilter(REPORT_TYPE, "=", (Object)1690596074244322304L);
        Map rRlObj = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (String)"position,superiorposition", (QFilter[])new QFilter[]{reportTypeListFilter, positionFilter});
        if (rRlObj.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> positionToSPosition = new HashMap<Long, DynamicObject>(rRlObj.size());
        for (Map.Entry entry : rRlObj.entrySet()) {
            DynamicObject rRl = (DynamicObject)entry.getValue();
            DynamicObject positionObj = rRl.getDynamicObject("position");
            if (positionObj == null) continue;
            positionToSPosition.put(positionObj.getLong("id"), rRl.getDynamicObject(SUPPOSITION));
        }
        return positionToSPosition;
    }

    public Map<Long, Set<Long>> getPositionIdsByDptId(List<Long> dptIds) {
        HashMap<Long, Set<Long>> dptPositionMap = new HashMap<Long, Set<Long>>(dptIds.size());
        QFilter idFilter = new QFilter("dpt", "in", dptIds);
        Map dptPositionMaps = BusinessDataServiceHelper.loadFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject dynamicObject : dptPositionMaps.values()) {
            if (dynamicObject.get("dpt") == null) continue;
            Set positionIds = dptPositionMap.computeIfAbsent(dynamicObject.getLong(DPT_ID), k -> new HashSet(8));
            positionIds.add(dynamicObject.getLong("id"));
            dptPositionMap.put(dynamicObject.getLong(DPT_ID), positionIds);
        }
        return dptPositionMap;
    }

    public Map<Long, Map<Long, String>> deleteReportRelation(Map<Long, Set<Long>> relationMap) {
        if (relationMap.isEmpty()) {
            return new HashMap<Long, Map<Long, String>>(0);
        }
        HashMap<Long, Map<Long, String>> results = new HashMap<Long, Map<Long, String>>(relationMap.size());
        ArrayList dynamicObjects = new ArrayList(relationMap.size());
        HashMap<Long, String> opResult = new HashMap<Long, String>(relationMap.size());
        HashSet ids = new HashSet(relationMap.size());
        for (Map.Entry<Long, Set<Long>> entry : relationMap.entrySet()) {
            ids.addAll(entry.getValue());
        }
        QFilter reportTypeIdFilter = new QFilter(REPORT_TYPE_ID, "in", relationMap.keySet());
        QFilter positionIdFilter = new QFilter(POSITION_ID, "in", ids);
        Map reportRelationObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (QFilter[])new QFilter[]{reportTypeIdFilter, positionIdFilter});
        for (Map.Entry entry : reportRelationObjMap.entrySet()) {
            DynamicObject reportTypeObj = ((DynamicObject)entry.getValue()).getDynamicObject(REPORT_TYPE);
            DynamicObject positionObj = ((DynamicObject)entry.getValue()).getDynamicObject("position");
            if (reportTypeObj == null || positionObj == null) {
                log.error("\u6c47\u62a5\u7c7b\u578b\u6216\u5c97\u4f4d\u4e3anull\u3002");
                continue;
            }
            if (!relationMap.get(reportTypeObj.getLong("id")).contains(positionObj.getLong("id"))) continue;
            dynamicObjects.add(entry.getValue());
        }
        this.execute(new HashSet<Long>(0), "delete", BOS_REPORT_RELATION, dynamicObjects.toArray(new DynamicObject[0]), opResult);
        for (Map.Entry entry : opResult.entrySet()) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!((Long)entry.getKey()).equals(dynamicObject.getLong("masterid"))) continue;
                opResult.put(Long.parseLong(dynamicObject.get(POSITION_ID).toString()), (String)entry.getValue());
                results.put(Long.parseLong(dynamicObject.get(REPORT_TYPE_ID).toString()), opResult);
            }
        }
        return results;
    }

    public Map<Long, String> addOrUpdateReportRelation(List<Map<String, Long>> relationList) {
        if (relationList.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> resultsMap = new HashMap<Long, String>(relationList.size());
        this.addOrUpdateReportRelation(relationList, resultsMap);
        return resultsMap;
    }

    public Map<Long, Position> getPositions(List<Long> positionIds, boolean isIncludeSuperiorPosition) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return new HashMap<Long, Position>(0);
        }
        HashMap<Long, Position> positionMap = new HashMap<Long, Position>(positionIds.size());
        QFilter positionIdFilter = new QFilter("id", "in", positionIds);
        Map<Object, DynamicObject> positionObjMap = this.getPositionByFilter(positionIdFilter);
        if (positionObjMap.isEmpty()) {
            return positionMap;
        }
        Map<Long, Map<String, Object>> positionToSupPositionMap = null;
        if (isIncludeSuperiorPosition) {
            positionToSupPositionMap = this.getSuperiorPositions(1690596074244322304L, positionIds);
        }
        for (Map.Entry<Object, DynamicObject> entry : positionObjMap.entrySet()) {
            long positionId = Long.parseLong(entry.getKey().toString());
            DynamicObject positionObj = entry.getValue();
            Position position = positionMap.computeIfAbsent(positionId, k -> new Position());
            this.setPosition(position, positionObj, positionToSupPositionMap);
        }
        return positionMap;
    }

    public Map<String, Position> getPositionsByNumber(List<String> positionNumberList, boolean isIncludeSuperiorPosition) {
        if (CollectionUtils.isEmpty(positionNumberList)) {
            return new HashMap<String, Position>(0);
        }
        HashMap<String, Position> positionMap = new HashMap<String, Position>(positionNumberList.size());
        QFilter positionNumberFilter = new QFilter(NUMBER, "in", positionNumberList);
        Map<Object, DynamicObject> positionObjMap = this.getPositionByFilter(positionNumberFilter);
        if (positionObjMap.isEmpty()) {
            return positionMap;
        }
        Map<Long, Map<String, Object>> positionToSupPositionMap = null;
        if (isIncludeSuperiorPosition) {
            List<Long> positionIds = positionObjMap.keySet().stream().filter(Objects::nonNull).map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
            positionToSupPositionMap = this.getSuperiorPositions(1690596074244322304L, positionIds);
        }
        for (Map.Entry<Object, DynamicObject> entry : positionObjMap.entrySet()) {
            DynamicObject positionObj = entry.getValue();
            String number = positionObj.getString(NUMBER);
            Position position = positionMap.computeIfAbsent(number, k -> new Position());
            this.setPosition(position, positionObj, positionToSupPositionMap);
        }
        return positionMap;
    }

    private Map<Object, DynamicObject> getPositionByFilter(QFilter positionFilter) {
        String selectFields = "id,number,name,dpt.id,ismainposition,enable,remarks";
        return BusinessDataServiceHelper.loadFromCache((String)BOS_POSITION, (String)selectFields, (QFilter[])new QFilter[]{positionFilter});
    }

    private void setPosition(Position position, DynamicObject positionObj, Map<Long, Map<String, Object>> positionToSupPositionMap) {
        Map<String, Object> supPosition;
        long positionId = positionObj.getLong("id");
        position.setId(positionId);
        position.setNumber(positionObj.getString(NUMBER));
        position.setName(positionObj.getLocaleString("name"));
        position.setEnable(positionObj.getBoolean(PROP_ENABLE));
        position.setMainPosition(Boolean.valueOf(positionObj.getBoolean(ISMAINPOSIITON)));
        position.setRemarks((ILocaleString)new LocaleString(positionObj.getString(REMARKS)));
        position.setDptId(positionObj.getLong(DPT_ID));
        if (positionToSupPositionMap != null && (supPosition = positionToSupPositionMap.get(positionId)) != null) {
            Object supPositionId = supPosition.get("id");
            position.setSuperiorPositionId(supPositionId == null ? 0L : Long.parseLong(supPositionId.toString()));
        }
    }

    public Map<Long, Map<String, Object>> getReportType(boolean isIncludeDisable) {
        QFilter enableFilter = null;
        if (Boolean.FALSE.equals(isIncludeDisable)) {
            enableFilter = new QFilter(PROP_ENABLE, "=", (Object)true);
        }
        HashMap<Long, Map<String, Object>> rRL = new HashMap<Long, Map<String, Object>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceImpl.getReportType", (String)BOS_REPORT_TYPE, (String)"id,number,name,enable", (QFilter[])new QFilter[]{enableFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                long reportTypeId = r.getLong("id");
                Map attribute = rRL.computeIfAbsent(reportTypeId, k -> new HashMap(3));
                attribute.put(NUMBER, r.getString(NUMBER));
                attribute.put("name", r.getString("name"));
                attribute.put(PROP_ENABLE, r.getString(PROP_ENABLE));
            }
        }
        catch (Exception e) {
            log.warn("UserServiceImpl.getReportType is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return rRL;
    }

    public Map<Long, Map<String, Object>> getSuperiorPositions(long reportTypeId, List<Long> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<Long, Map<String, Object>> positionToSup = new HashMap<Long, Map<String, Object>>(positionIds.size());
        QFilter reportTypeIdFilter = new QFilter(REPORT_TYPE_ID, "=", (Object)reportTypeId);
        QFilter positionIdFilter = new QFilter(POSITION_ID, "in", positionIds);
        String selectFields = "position.id,superiorposition.id,superiorposition.number,superiorposition.name,superiorposition.enable,superiorposition.ismainposition";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserServiceImpl.getSuperiorPositions", (String)BOS_REPORT_RELATION, (String)selectFields, (QFilter[])new QFilter[]{reportTypeIdFilter, positionIdFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                long positionId = r.getLong(POSITION_ID);
                Map attribute = positionToSup.computeIfAbsent(positionId, k -> new HashMap(5));
                attribute.put("id", r.getLong(SUPERIORPOSITIONID));
                attribute.put(NUMBER, r.getString("superiorposition.number"));
                attribute.put("name", r.getString("superiorposition.name"));
                attribute.put(PROP_ENABLE, r.getString("superiorposition.enable"));
                attribute.put(ISMAINPOSIITON, r.getString("superiorposition.ismainposition"));
            }
        }
        catch (Exception e) {
            log.warn("UserServiceImpl.getSuperiorPositions is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return positionToSup;
    }

    public String getSuperiorPosition(long reportTypeId, long positionId) {
        ArrayList<Long> positionIds = new ArrayList<Long>(1);
        positionIds.add(positionId);
        Map<Long, Map<String, Object>> positionToSup = this.getSuperiorPositions(reportTypeId, positionIds);
        Map superiorPosition = positionToSup.getOrDefault(positionId, new HashMap(0));
        if (superiorPosition.isEmpty()) {
            return ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"UserServiceImpl_21", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return superiorPosition.get("id").toString();
    }

    private void addOrUpdateReportRelation(List<Map<String, Long>> addOrUpdateReportRelationList, Map<Long, String> resultsMap) {
        if (addOrUpdateReportRelationList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> reportRelationObjs = new ArrayList<DynamicObject>(addOrUpdateReportRelationList.size());
        ArrayList<Long> idList = new ArrayList<Long>(addOrUpdateReportRelationList.size());
        ArrayList<Long> positionIdList = new ArrayList<Long>(addOrUpdateReportRelationList.size());
        ArrayList<Long> typeIdList = new ArrayList<Long>(addOrUpdateReportRelationList.size());
        this.buildIdList(idList, positionIdList, typeIdList, addOrUpdateReportRelationList);
        Map reportRelationObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        Map positionObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{new QFilter("id", "in", positionIdList)});
        Map typeObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "in", typeIdList)});
        for (Map<String, Long> reportRelationMap : addOrUpdateReportRelationList) {
            if (reportRelationMap.get(TYPEID) != null && typeObjMap.get(reportRelationMap.get(TYPEID)) == null) {
                String msg = ResManager.loadKDString((String)"\u8be5\u6c47\u62a5\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"UserServiceImpl_22", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                resultsMap.put(reportRelationMap.get(TYPEID), msg);
                continue;
            }
            if (reportRelationMap.get(POSITIONID) != null && positionObjMap.get(reportRelationMap.get(POSITIONID)) == null) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"UserServiceImpl_23", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                resultsMap.put(reportRelationMap.get(TYPEID), msg);
                continue;
            }
            if (reportRelationMap.get("id") == null) {
                this.buildReportRelationObjs(null, reportRelationMap, reportRelationObjs, positionObjMap, typeObjMap);
                continue;
            }
            long id = reportRelationMap.get("id");
            DynamicObject reportRelationObj = (DynamicObject)reportRelationObjMap.get(id);
            this.buildReportRelationObjs(reportRelationObj, reportRelationMap, reportRelationObjs, positionObjMap, typeObjMap);
        }
        this.execute(new HashSet<Long>(0), "save", BOS_REPORT_RELATION, reportRelationObjs.toArray(new DynamicObject[0]), resultsMap);
    }

    private void buildIdList(List<Long> idList, List<Long> positionIdList, List<Long> typeIdList, List<Map<String, Long>> addOrUpdateReportRelationList) {
        for (Map<String, Long> reportRelationMap : addOrUpdateReportRelationList) {
            if (reportRelationMap.get(POSITIONID) != null) {
                positionIdList.add(reportRelationMap.get(POSITIONID));
            }
            if (reportRelationMap.get(SUPPOSITIONID) != null) {
                positionIdList.add(reportRelationMap.get(SUPPOSITIONID));
            }
            if (reportRelationMap.get(TYPEID) != null) {
                typeIdList.add(reportRelationMap.get(TYPEID));
            }
            if (reportRelationMap.get("id") == null) continue;
            long id = reportRelationMap.get("id");
            idList.add(id);
        }
    }

    private void buildReportRelationObjs(DynamicObject reportRelationObj, Map<String, Long> reportRelationMap, List<DynamicObject> reportRelationObjs, Map<Object, DynamicObject> positionObjMap, Map<Object, DynamicObject> typeObjMap) {
        if (reportRelationObj == null) {
            reportRelationObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_REPORT_RELATION);
        }
        if (reportRelationMap.get("id") != null) {
            reportRelationObj.set("id", (Object)reportRelationMap.get("id"));
            reportRelationObj.set("masterid", (Object)reportRelationMap.get("id"));
        }
        if (reportRelationMap.get(TYPEID) != null && reportRelationMap.get(TYPEID).longValue() != reportRelationObj.getLong(REPORT_TYPE_ID)) {
            reportRelationObj.set(REPORT_TYPE, (Object)typeObjMap.get(reportRelationMap.get(TYPEID)));
        }
        if (reportRelationMap.get(POSITIONID) != null && reportRelationMap.get(POSITIONID).longValue() != reportRelationObj.getLong(POSITION_ID)) {
            reportRelationObj.set("position", (Object)positionObjMap.get(reportRelationMap.get(POSITIONID)));
        }
        if (reportRelationMap.get(SUPPOSITIONID) != null && reportRelationMap.get(SUPPOSITIONID).longValue() != reportRelationObj.getLong(SUPERIORPOSITIONID)) {
            reportRelationObj.set(SUPPOSITION, (Object)positionObjMap.get(reportRelationMap.get(SUPPOSITIONID)));
        }
        reportRelationObjs.add(reportRelationObj);
    }

    public void changePsw(List<UserParam> userParamList) {
        if (CollectionUtils.isEmpty(userParamList)) {
            return;
        }
        HashMap<Long, UserParam> userParamMap = new HashMap<Long, UserParam>(userParamList.size());
        for (UserParam userParam : userParamList) {
            if (userParam.getId() == 0L) {
                userParam.setSuccess(false);
                userParam.setMsg(BaseMessage.getMessage((String)"M00002"));
                continue;
            }
            userParamMap.put(userParam.getId(), userParam);
        }
        if (userParamMap.isEmpty()) {
            return;
        }
        this.changePsw(userParamMap);
        for (Map.Entry entry : userParamMap.entrySet()) {
            UserServiceUtils.genErrorMsg((UserParam)entry.getValue(), BaseMessage.getMessage((String)"M00062"));
        }
    }

    private void changePsw(Map<Long, UserParam> userParamMap) {
        String selectFields = "id,password,pswhisstr,psweffectivedate,islocked,errcount,modifier,modifytime";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userParamMap.keySet())};
        DynamicObject[] userObjArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userObjArr == null || userObjArr.length == 0) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        java.util.Date currentDate = new java.util.Date();
        Boolean checkAdminUser = null;
        for (DynamicObject userObj : userObjArr) {
            Object newPsw;
            long userId = userObj.getLong("id");
            UserParam userParam = userParamMap.remove(userId);
            Map dataMap = userParam.getDataMap() == null ? new HashMap(0) : userParam.getDataMap();
            Object oldPsw = dataMap.get("oldPsw");
            if (StringUtils.isBlank(oldPsw)) {
                if (checkAdminUser == null) {
                    checkAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId) || PermCommonUtil.isCosmicUser((Long)currUserId);
                }
                if (!checkAdminUser.booleanValue()) {
                    UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserServiceImpl_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
            } else if (!this.validateOldPsw(userParam, oldPsw.toString(), userObj.getString("password"))) continue;
            String newPswStr = StringUtils.isBlank(newPsw = dataMap.get("newPsw")) ? this.getUserDefaultPsw() : PasswordEncryptUtil.getEncryptePasswordWithSalt((String)newPsw.toString(), (String)PasswordEncryptUtil.getCorrectUserIDSalt((String)String.valueOf(userId)));
            userObj.set("password", (Object)newPswStr);
            String pswHisStr = userObj.getString(PSWHISSTR);
            if (StringUtils.isBlank((CharSequence)pswHisStr)) {
                userObj.set(PSWHISSTR, (Object)newPswStr);
            } else {
                CharSequence[] pswHisStrArr = pswHisStr.split(",");
                if (pswHisStrArr.length >= 10) {
                    pswHisStrArr[0] = "";
                    pswHisStr = String.join((CharSequence)",", pswHisStrArr).substring(1);
                }
                userObj.set(PSWHISSTR, (Object)(pswHisStr + "," + newPswStr));
            }
            userObj.set("psweffectivedate", (Object)currentDate);
            userObj.set("islocked", (Object)"0");
            userObj.set("errcount", (Object)0);
            userObj.set("modifier", (Object)currUserId);
            userObj.set("modifytime", (Object)currentDate);
        }
        SaveServiceHelper.save((DynamicObject[])userObjArr);
    }

    private boolean validateOldPsw(UserParam userParam, String oldPsw, String dbPsw) {
        if (Objects.equals(dbPsw, oldPsw)) {
            return true;
        }
        if (PasswordEncryptUtil.checkPasswordWithSalt((String)PasswordEncryptUtil.getCorrectUserIDSalt((String)String.valueOf(userParam.getId())), (String)oldPsw, (String)dbPsw)) {
            return true;
        }
        String oldPswStr = EncryptUtils.encryptPSW((String)oldPsw);
        if (Objects.equals(dbPsw, oldPswStr)) {
            return true;
        }
        UserServiceUtils.genErrorMsg(userParam, ResManager.loadKDString((String)"\u65e7\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"UserServiceImpl_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        return false;
    }

    public Set<Long> getDepartmentIncludeSuperior(long userId) {
        HashSet<Long> orgIds = new HashSet<Long>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter};
        Map positionObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (String)"orgstructure", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)positionObjMap)) {
            return orgIds;
        }
        ArrayList<String> orgNumbers = new ArrayList<String>();
        OrgSeparation orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        String longNumberSep = orgSeparation.getLongNumberSep();
        for (Map.Entry entry : positionObjMap.entrySet()) {
            String[] numberArr;
            String longNumber;
            DynamicObject structureObj = ((DynamicObject)entry.getValue()).getDynamicObject("orgstructure");
            if (structureObj == null || StringUtils.isBlank((CharSequence)(longNumber = structureObj.getString("longnumber")))) continue;
            for (String number : numberArr = longNumber.split(longNumberSep)) {
                orgNumbers.add(number);
            }
        }
        if (orgNumbers.isEmpty()) {
            return orgIds;
        }
        QFilter numberFilter = new QFilter(NUMBER, "in", orgNumbers);
        filters = new QFilter[]{numberFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])filters);
        orgObjMap.keySet().forEach(id -> orgIds.add((Long)id));
        return orgIds;
    }

    public Map<Long, List<Long>> getUserDepartments(List<Long> userIds, boolean onlyMainJob, boolean onlyInCharge) {
        QFilter[] filters;
        String selectFields;
        Map positionObjMap;
        if (CollectionUtils.isEmpty(userIds)) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter userFilter = new QFilter("user", "in", userIds);
        if (onlyMainJob) {
            userFilter = userFilter.and(new QFilter("ispartjob", "=", (Object)Boolean.FALSE));
        }
        if (onlyInCharge) {
            userFilter = userFilter.and(new QFilter("isincharge", "=", (Object)Boolean.TRUE));
        }
        if (CollectionUtils.isEmpty((Map)(positionObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (String)(selectFields = "user,org"), (QFilter[])(filters = new QFilter[]{userFilter}))))) {
            return new HashMap<Long, List<Long>>(0);
        }
        HashMap<Long, List<Long>> userDptMap = new HashMap<Long, List<Long>>(userIds.size());
        for (Map.Entry entry : positionObjMap.entrySet()) {
            DynamicObject positionObj = (DynamicObject)entry.getValue();
            DynamicObject userObj = positionObj.getDynamicObject("user");
            DynamicObject orgObj = positionObj.getDynamicObject("org");
            if (userObj == null || orgObj == null) continue;
            userDptMap.computeIfAbsent(userObj.getLong("id"), v -> new ArrayList(16)).add(orgObj.getLong("id"));
        }
        return userDptMap;
    }
}

