/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.LogOldDataRule;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.imp.UsrGrpComRoleImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UsrGrpComRoleAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UsrGrpComRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.usrgrprole.GetUsrGrpRoleDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.usrgrp.UsrGrp;
import kd.bos.permission.model.perm.usrgrprole.UsrGrpRoleDim;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.UserGroupService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class UsrGrpRoleService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UsrGrpRoleService.class);

    public static Map<String, UsrGrpRoleDim> getUsrGrpRoleDimMap(GetUsrGrpRoleDimReq req) {
        HashMap<String, UsrGrpRoleDim> map = new HashMap<String, UsrGrpRoleDim>(8);
        List<QFilter> filterList = UsrGrpRoleService.getFilter(req);
        Integer returnType = req.getReturnType();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UsrGrpRoleService.getUserRoleDimMap", (String)"perm_usrgrprole", (String)"id, role, role.number, usrgrpid, usrgrpid.number, dimtype, dimid, includesub, starttime, endtime", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            StringBuilder sb = null;
            UsrGrpRoleDim one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UsrGrpRoleDim();
                Long usrgrpid = row.getLong("usrgrpid");
                String roleId = row.getString("role");
                String dimType = row.getString("dimtype");
                Long dimId = row.getLong("dimid");
                one.setId(row.getString("id"));
                one.setUserGroupId(usrgrpid);
                one.setRoleId(roleId);
                one.setDimType(dimType);
                one.setDimId(dimId);
                one.setIncludeSub(row.getBoolean("includesub"));
                one.setStartTime(row.getDate("starttime"));
                one.setEndTime(row.getDate("endtime"));
                if (Objects.equals(1, returnType)) {
                    sb = new StringBuilder().append(usrgrpid).append("|").append(roleId).append("|").append(dimType).append("|").append(dimId);
                    map.put(sb.toString(), one);
                    continue;
                }
                if (!Objects.equals(2, returnType)) continue;
                map.put(row.getString("id"), one);
            }
        }
        return map;
    }

    public static Set<String> getDimTypeSet(GetUsrGrpRoleDimReq req) {
        HashSet<String> result = new HashSet<String>(8);
        List<QFilter> filterList = UsrGrpRoleService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UsrGrpRoleService.getDimTypeSet", (String)"perm_usrgrprole", (String)"dimtype", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.add(row.getString("dimtype"));
            }
        }
        return result;
    }

    private static List<QFilter> getFilter(GetUsrGrpRoleDimReq req) {
        Map dimTypeDimNumSetMap;
        Set dimIdSet;
        Set dimTypeSet;
        Map roleNumberComRoleMap;
        Set collect;
        Set roleNumberSet;
        Set roleIdSet;
        Map userMap;
        Set collect2;
        Set usrGrpNumberSet;
        Set usrGrpIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(usrGrpIdSet = req.getUsrGrpIdSet()))) {
            filterList.add(new QFilter("usrgrpid", "in", (Object)usrGrpIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(usrGrpNumberSet = req.getUsrGrpNumberSet())) && !CollectionUtils.isEmpty(collect2 = (userMap = UserGroupHelper.getUsrGrpMap((Set)usrGrpNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(UsrGrp::getUserGroupId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usrgrpid", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(roleIdSet = req.getRoleIdSet()))) {
            filterList.add(new QFilter("role", "in", (Object)roleIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(roleNumberSet = req.getRoleNumberSet())) && !CollectionUtils.isEmpty(collect = (roleNumberComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)roleNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(ComRole::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("role", "in", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimTypeSet = req.getDimTypeSet()))) {
            filterList.add(new QFilter("dimtype", "in", (Object)dimTypeSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimIdSet = req.getDimIdSet()))) {
            filterList.add(new QFilter("dimid", "in", (Object)dimIdSet));
        }
        if (null != (dimTypeDimNumSetMap = req.getDimTypeDimNumSetMap()) && !dimTypeDimNumSetMap.isEmpty()) {
            HashSet<String> innerDimTypeSet = new HashSet<String>(8);
            HashSet innerDimIdSet = new HashSet(8);
            for (Map.Entry dimTypeDimNumSet : dimTypeDimNumSetMap.entrySet()) {
                String dimType = (String)dimTypeDimNumSet.getKey();
                Set dimNumberSet = (Set)dimTypeDimNumSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty((Collection)dimNumberSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumberSet, (String)"number", (String)dimType);
                Set collect3 = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                innerDimTypeSet.add(dimType);
                innerDimIdSet.addAll(collect3);
            }
            if (!CollectionUtils.isEmpty(innerDimTypeSet)) {
                filterList.add(new QFilter("dimtype", "in", innerDimTypeSet));
            }
            if (!CollectionUtils.isEmpty(innerDimIdSet)) {
                filterList.add(new QFilter("dimid", "in", innerDimIdSet));
            }
        }
        return filterList;
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        List needCheckBeanList = req.getNeedCheckBeanList();
        if (CollectionUtils.isEmpty((Collection)needCheckBeanList)) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, UsrGrpComRoleImportBean> passedMap = new HashMap<Integer, UsrGrpComRoleImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        OperationTypeEnum operationTypeEnum = null;
        EnumsImportType enumsImportType = req.getEnumsImportType();
        if (EnumsImportType.NEW != enumsImportType) {
            throw new KDBizException("unsurpport importType.");
        }
        operationTypeEnum = OperationTypeEnum.ADD;
        for (UsrGrpComRoleImportBean willSaveBean : needCheckBeanList) {
            if (null == willSaveBean) continue;
            willSaveBean.setOperationTypeEnum(operationTypeEnum);
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        PermCheckResp permCheckResp = new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
        super.beforeSaveCheckExt(req);
        return permCheckResp;
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, UsrGrpComRoleImportBean willSaveBean, Map<Integer, UsrGrpComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, UsrGrpComRoleImportBean willSaveBean, Map<Integer, UsrGrpComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean enableValidateTime;
        Set userGroups;
        String usrGrpNumber;
        Set hasPermDimSet;
        Dim dim;
        Map dimNumExistMap;
        String dimTypeNumBig;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int lineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getRoleNum();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)roleNum.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_19", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        long currUserId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)roleNum)) {
            Map<String, Boolean> roleNumCanModifyRoleMap;
            Boolean can;
            Map roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
            Set comRoleSet = (Set)roleNumberComRoleMap.get(roleNum);
            if (null == comRoleSet || comRoleSet.isEmpty()) {
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_16", (String)"bos-mservice-permission", (Object[])new Object[0]), roleNum));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
            if (!(can = (Boolean)(roleNumCanModifyRoleMap = null == checkNeedParamMap.get("roleNumCanModifyRoleMap") ? AdminGroupService.canModifyRole((Long)currUserId, Sets.newHashSet((Object[])new String[]{roleNum})) : (Map<String, Boolean>)checkNeedParamMap.get("roleNumCanModifyRoleMap")).get(roleNum)).booleanValue()) {
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ComRoleService_20", (String)"bos-mservice-permission", (Object[])new Object[0]), roleNum));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(dimTypeNumBig = willSaveBean.getDimTypeBig()))) {
            Map bigPermCtrlTypeMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            PermCtrlType bigPermCtrlType = (PermCtrlType)bigPermCtrlTypeMap.get(dimTypeNumBig);
            if (null == bigPermCtrlType) {
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNumBig));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        } else if (StringUtils.isEmpty((String)dimTypeNumBig.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_20", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String dimType = willSaveBean.getDimType();
        String dimNum = willSaveBean.getDimNum();
        if (StringUtils.isEmpty((String)dimNum.trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_21", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        HashMap<String, Map> dimTypeDimNumExistMap = null;
        if (null == checkNeedParamMap.get("dimTypeDimNumExistMap")) {
            dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimType, (Set)Sets.newHashSet((Object[])new String[]{dimNum}));
            dimTypeDimNumExistMap = new HashMap<String, Map>(8);
            dimTypeDimNumExistMap.put(dimType, dimNumExistMap);
        } else {
            dimTypeDimNumExistMap = (HashMap<String, Map>)checkNeedParamMap.get("dimTypeDimNumExistMap");
        }
        if (!(CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType))) || null != (dimNumExistMap = (Map)dimTypeDimNumExistMap.get(dimType)).get(dimNum) && ((Boolean)dimNumExistMap.get(dimNum)).booleanValue())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType)))) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermPermCtrlObjResp hasPermDimResult = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap")) {
            hasPermDimResult = PermCtrlTypeService.getAdminHasPermPermCtrlObj(new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{dimNum})));
        } else {
            Map dimTypeAdminHasPermPermCtrlObjMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap");
            GetHasPermPermCtrlObjResp getHasPermPermCtrlObjResp = hasPermDimResult = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermPermCtrlObjMap) ? null : (GetHasPermPermCtrlObjResp)dimTypeAdminHasPermPermCtrlObjMap.get(dimType);
        }
        if (null != hasPermDimResult && !hasPermDimResult.isHasAllDimPerm() && null == (dim = (Dim)(hasPermDimSet = hasPermDimResult.getHasPermDimSet()).stream().filter(x -> Objects.equals(dimNum, x.getDimNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)dimType) && null == hasPermDimResult) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(usrGrpNumber = willSaveBean.getUsrGrpNumber()).trim())) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UsrGrpRoleService_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map usrGrpNumMap = null == checkNeedParamMap.get("usrGrpNumMap") ? UserGroupHelper.getUsrGrpMap((Set)Sets.newHashSet((Object[])new String[]{usrGrpNumber}), (String)"number") : (Map)checkNeedParamMap.get("usrGrpNumMap");
        Set set = userGroups = null == usrGrpNumMap ? new HashSet(0) : (Set)usrGrpNumMap.get(usrGrpNumber);
        if (null == userGroups || userGroups.isEmpty()) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UsrGrpRoleService_1", (String)"bos-mservice-permission", (Object[])new Object[0]), usrGrpNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map<String, UsrGrpRoleDim> usrGrpRoleDimMap = null;
        if (null == checkNeedParamMap.get("usrGrpRoleDimMap")) {
            HashMap<String, HashSet> dimTypeDimNumSetMap = new HashMap<String, HashSet>(8);
            dimTypeDimNumSetMap.put(dimType, Sets.newHashSet((Object[])new String[]{dimNum}));
            usrGrpRoleDimMap = UsrGrpRoleService.getUsrGrpRoleDimMap(new GetUsrGrpRoleDimReq(Integer.valueOf(1), null, null, (Set)Sets.newHashSet((Object[])new String[]{usrGrpNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{roleNum}), null, null, dimTypeDimNumSetMap));
        } else {
            usrGrpRoleDimMap = (Map<String, UsrGrpRoleDim>)checkNeedParamMap.get("usrGrpRoleDimMap");
        }
        if (StringUtils.isNotEmpty((String)usrGrpNumber) && StringUtils.isNotEmpty((String)roleNum)) {
            HashSet dimIdSet;
            Map roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
            Set comRoles = (Set)roleNumberComRoleMap.get(roleNum);
            Map<String, Map> dimTypeDimNumDimMap = null;
            if (null == checkNeedParamMap.get("dimTypeDimNumDimMap")) {
                dimTypeDimNumDimMap = new HashMap(8);
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)Sets.newHashSet((Object[])new String[]{dimNum}), (String)"number", (String)dimType);
                dimTypeDimNumDimMap.put(dimType, dimNumDimSetMap);
            } else {
                dimTypeDimNumDimMap = (Map)checkNeedParamMap.get("dimTypeDimNumDimMap");
            }
            Map dimNumDimMap = (Map)dimTypeDimNumDimMap.get(dimType);
            Set<Object> set2 = dimIdSet = null == dimNumDimMap ? new HashSet(1) : dimNumDimMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
            if (!(CollectionUtils.isEmpty(userGroups) || CollectionUtils.isEmpty((Collection)comRoles) || CollectionUtils.isEmpty(dimIdSet))) {
                for (UsrGrp usrGrp : userGroups) {
                    for (ComRole comRole : comRoles) {
                        for (Long dimId : dimIdSet) {
                            String key = usrGrp.getUserGroupId() + "|" + comRole.getId() + "|" + dimType + "|" + dimId;
                            if (!usrGrpRoleDimMap.containsKey(key)) continue;
                            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"UserRoleService_18", (String)"bos-mservice-permission", (Object[])new Object[0]));
                            checkResult = false;
                            if (!failFast) continue;
                            return checkResult;
                        }
                    }
                }
            }
        }
        boolean bl = enableValidateTime = null == checkNeedParamMap.get("enableValidateTime") ? PermCommonUtil.isEnableValidateTime() : (Boolean)checkNeedParamMap.get("enableValidateTime");
        if (enableValidateTime) {
            Date endTime;
            Date startTime = willSaveBean.getStartTime();
            List list = PermCommonUtil.checkValidateTime((Date)startTime, (Date)(endTime = willSaveBean.getEndTime()), (Map)checkNeedParamMap);
            if (null != list && !list.isEmpty()) {
                for (String dataValidStr : list) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, dataValidStr);
                    checkResult = false;
                    if (!failFast) continue;
                    return checkResult;
                }
            }
        } else {
            willSaveBean.setStartTime(null);
            willSaveBean.setEndTime(null);
        }
        Boolean includeSub = willSaveBean.getIncludeSub();
        if (null == includeSub) {
            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u662f\u6216\u5426\u3002", (String)"UserRoleService_17", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (checkResult) {
            passedMap.put(lineNum, willSaveBean);
        }
        return checkResult;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            UsrGrpComRoleAfterSaveReq req = (UsrGrpComRoleAfterSaveReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])mainIdSet.toArray(mainIdSet.toArray(new String[mainIdSet.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_usrgrprole"));
            if (null == dynamicObjects || Objects.equals(0, dynamicObjects.length)) {
                return PermResult.ok();
            }
            ArrayList<UgRoleDim> addList = new ArrayList<UgRoleDim>(10);
            UgRoleDim ugRoleDim = null;
            for (DynamicObject one : dynamicObjects) {
                Long userGroupId = one.getLong("usrgrpid_id");
                String roleId = one.getString("role_id");
                Long dimId = one.getLong("dimid");
                String dimType = one.getString("dimtype");
                String includesub = one.getString("includesub");
                String startTimeStr = one.getString("fstarttime");
                String endTimeStr = one.getString("fendtime");
                Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate((String)startTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                Date endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                ugRoleDim = new UgRoleDim();
                ugRoleDim.setUsrGrpId(userGroupId);
                ugRoleDim.setRoleId(roleId);
                ugRoleDim.setDimId(dimId);
                ugRoleDim.setIncludeSub(includesub);
                ugRoleDim.setDimType(dimType);
                ugRoleDim.setStarttime(startTime);
                ugRoleDim.setEndtime(endTime);
                addList.add(ugRoleDim);
            }
            PermResult permResult = UsrGrpRoleService.usrGrpRoleRelateChangeBusi(addList, null);
            UsrGrpRoleService.roleAssignUsrGrpDim2PermLog(addList, null, null, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            super.afterMainEntitySaveExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UsrGrpRoleService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            UsrGrpComRoleAfterDelReq req = (UsrGrpComRoleAfterDelReq)reqOri;
            Map delUsrGrpRoleDimMap = req.getDelUsrGrpRoleDimMap();
            if (!CollectionUtils.isEmpty((Map)delUsrGrpRoleDimMap)) {
                ArrayList<UgRoleDim> delList = new ArrayList<UgRoleDim>(10);
                UgRoleDim ugRoleDim = null;
                for (Map.Entry delUsrGrpRoleDim : delUsrGrpRoleDimMap.entrySet()) {
                    UsrGrpRoleDim value = (UsrGrpRoleDim)delUsrGrpRoleDim.getValue();
                    if (null == value) continue;
                    Long userGroupId = value.getUserGroupId();
                    String roleId = value.getRoleId();
                    Long dimId = value.getDimId();
                    String dimType = value.getDimType();
                    ugRoleDim = new UgRoleDim();
                    ugRoleDim.setUsrGrpId(userGroupId);
                    ugRoleDim.setRoleId(roleId);
                    ugRoleDim.setDimId(dimId);
                    ugRoleDim.setIncludeSub(value.getIncludeSub() != false ? "1" : "0");
                    ugRoleDim.setDimType(dimType);
                    ugRoleDim.setStarttime(value.getStartTime());
                    ugRoleDim.setEndtime(value.getEndTime());
                    delList.add(ugRoleDim);
                }
                PermResult permResult = UsrGrpRoleService.usrGrpRoleRelateChangeBusi(null, delList);
                UsrGrpRoleService.roleAssignUsrGrpDim2PermLog(null, delList, null, reqOri.getPermLogReq(), new StringBuilder(permResult.getMsg()));
            }
            super.afterDelExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UsrGrpRoleService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static void roleAssignUsrGrpDim2PermLog(List<UgRoleDim> addList, List<UgRoleDim> delList, List<UgRoleDim> updateList, PermLogReq permLogReq, StringBuilder resultMsg) {
        try {
            permLogReq.check(false);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            diffMap.put("del", delList);
            diffMap.put("add", addList);
            diffMap.put("update", updateList);
            String formNum = permLogReq.getFormIdentity();
            String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : permLogReq.getAppId();
            String cloudId = StringUtils.isEmpty((String)permLogReq.getCloudId()) ? AppHelper.getMetaAppInfo((String)appId).getCloudId() : permLogReq.getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
            map.put("busi_from", permLogReq.getBusiFrom());
            map.put("busi_type", permLogReq.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", permLogReq.getOp());
            map.put("opbtn", permLogReq.getOpbtn());
            map.put("interface_method", permLogReq.getInterfaceMethod());
            map.put("op_item_id", permLogReq.getOpItemId());
            map.put("op_item_number", permLogReq.getOpItemNumber());
            map.put("op_item_name", permLogReq.getOpItemName());
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("oper_time", permLogReq.getOperTime());
            map.put("client_type", permLogReq.getClientType());
            map.put("client_ip", permLogReq.getClientIp());
            map.put("client_name", permLogReq.getClientType());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UsrGrpRoleService.roleAssignUsrGrpDim2PermLog error.", (Throwable)e);
            String lineSep = System.getProperty("line.separator");
            resultMsg.append("UsrGrpRoleService.roleAssignUsrGrpDim2PermLog error.").append(lineSep).append(e.getMessage()).append(lineSep);
        }
    }

    private static PermResult usrGrpRoleRelateChangeBusi(List<UgRoleDim> addList, List<UgRoleDim> delList) {
        try {
            String roleId;
            addList = null == addList ? new ArrayList<UgRoleDim>(0) : addList;
            delList = null == delList ? new ArrayList<UgRoleDim>(0) : delList;
            HashMap<String, Set> changedUsrGrpIdUserIdSetMap = new HashMap<String, Set>(1);
            HashMap<String, Set> lisenceUserIdSetMap = new HashMap<String, Set>(1);
            HashSet<String> roleIds = new HashSet<String>(8);
            if (null != addList && !addList.isEmpty()) {
                HashMap<String, Set<Long>> addRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
                HashMap<String, Set<Long>> addRoleIdUserIdsMapNoneEnable = new HashMap<String, Set<Long>>(8);
                UsrGrpRoleService.getRoleIdUserIdsMap(addList, addRoleIdUserIdsMap, addRoleIdUserIdsMapNoneEnable);
                for (UgRoleDim ugRoleDim : addList) {
                    Set addUserIdSet;
                    roleId = ugRoleDim.getRoleId();
                    roleIds.add(roleId);
                    Set addUserIdSetNoneEnable = (Set)addRoleIdUserIdsMapNoneEnable.get(roleId);
                    if (null != addUserIdSetNoneEnable && !addUserIdSetNoneEnable.isEmpty()) {
                        changedUsrGrpIdUserIdSetMap.computeIfAbsent(roleId, k -> new HashSet(8)).addAll(addUserIdSetNoneEnable);
                    }
                    if (null == (addUserIdSet = (Set)addRoleIdUserIdsMap.get(roleId)) || addUserIdSet.isEmpty()) continue;
                    lisenceUserIdSetMap.computeIfAbsent(roleId, k -> new HashSet(8)).addAll(addUserIdSet);
                }
            }
            if (null != delList && !delList.isEmpty()) {
                HashMap<String, Set<Long>> delRoleIdUserIdsMap = new HashMap<String, Set<Long>>(8);
                HashMap<String, Set<Long>> delRoleIdUserIdsMapNoneEnable = new HashMap<String, Set<Long>>(8);
                UsrGrpRoleService.getRoleIdUserIdsMap(delList, delRoleIdUserIdsMap, delRoleIdUserIdsMapNoneEnable);
                for (UgRoleDim ugRoleDim : delList) {
                    roleId = ugRoleDim.getRoleId();
                    roleIds.add(roleId);
                    Set delUserIdSetNoneEnable = (Set)delRoleIdUserIdsMapNoneEnable.get(roleId);
                    if (null == delUserIdSetNoneEnable || delUserIdSetNoneEnable.isEmpty()) continue;
                    changedUsrGrpIdUserIdSetMap.computeIfAbsent(roleId, k -> new HashSet(8)).addAll(delUserIdSetNoneEnable);
                }
            }
            if (null != lisenceUserIdSetMap && !lisenceUserIdSetMap.isEmpty()) {
                Map roleIdAppEntSetMap = PermRoleHelper.getRoleIdAppEntSetMap(lisenceUserIdSetMap.keySet());
                HashMap appEntityMap = null;
                for (Map.Entry lisenceUserIdSet : lisenceUserIdSetMap.entrySet()) {
                    Map roleIdAppEntSet;
                    roleId = (String)lisenceUserIdSet.getKey();
                    Set userIdSet = (Set)lisenceUserIdSet.getValue();
                    if (StringUtils.isEmpty((String)roleId) || null == userIdSet || userIdSet.isEmpty() || null == (roleIdAppEntSet = (Map)roleIdAppEntSetMap.get(roleId)) || roleIdAppEntSet.isEmpty()) continue;
                    appEntityMap = new HashMap(roleIdAppEntSet.size());
                    for (Map.Entry roleIdAppEnt : roleIdAppEntSet.entrySet()) {
                        appEntityMap.put(roleIdAppEnt.getKey(), new ArrayList((Collection)roleIdAppEnt.getValue()));
                    }
                    LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(userIdSet), appEntityMap);
                }
            }
            if (null != addList && !addList.isEmpty() || null != delList && !delList.isEmpty()) {
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
            }
            if (!CollectionUtils.isEmpty(changedUsrGrpIdUserIdSetMap) && null != changedUsrGrpIdUserIdSetMap && !changedUsrGrpIdUserIdSetMap.isEmpty()) {
                Set userIdSet = changedUsrGrpIdUserIdSetMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
                UserHasPermOrgCache.clearUserLoginOrgs(userIdSet);
            }
            if (!CollectionUtils.isEmpty(roleIds)) {
                String langStr = RequestContext.get().getLang().name();
                HashSet<String> appEntityAllSet = null;
                for (String id : roleIds) {
                    Set changedUserIdSet;
                    appEntityAllSet = new HashSet<String>(16);
                    if (PermCommonUtil.hasEnableOldDataRule()) {
                        List oldDataRuleList = PermRoleLogHelper.getOldDataRuleList((String)id, (String)langStr);
                        for (LogOldDataRule oldDataRule : oldDataRuleList) {
                            appEntityAllSet.add(oldDataRule.getAppId() + "|" + oldDataRule.getEntityId());
                        }
                    } else {
                        LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)id, (String)langStr);
                        appEntityAllSet.addAll(newDataRule.getNewDRAppEntitySet());
                    }
                    Set set = changedUserIdSet = null == changedUsrGrpIdUserIdSetMap.get(id) ? new HashSet(0) : (Set)changedUsrGrpIdUserIdSetMap.get(id);
                    if (CollectionUtils.isEmpty(appEntityAllSet)) continue;
                    List appEntityAllList = appEntityAllSet.stream().map(x -> {
                        String[] split = x.split("\\|", 2);
                        HashMap<String, String> map = new HashMap<String, String>(2);
                        map.put(split[0], split[1]);
                        return map;
                    }).collect(Collectors.toList());
                    PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdSet), appEntityAllList, (boolean)false);
                }
            }
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UsrGrpRoleService.usrGrpRoleRelateChangeBusi error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    private static void getRoleIdUserIdsMap(List<UgRoleDim> list, Map<String, Set<Long>> roleIdUserIdsMap, Map<String, Set<Long>> roleIdUserIdsMapNoneEnable) {
        Set<Long> usrGrpIdSet = list.stream().map(UgRoleDim::getUsrGrpId).collect(Collectors.toSet());
        Map<Long, Set<Long>> grpIdUIdSetMap = UserGroupService.getGrpIdUIdSetMap(usrGrpIdSet);
        Map<Long, Set<Long>> grpIdUIdSetMapNoneEnable = UserGroupService.getGrpIdUIdSetMapNoneEnable(usrGrpIdSet);
        for (UgRoleDim ugRoleDim : list) {
            Set<Long> userIdSetNoneEnable;
            String roleId = ugRoleDim.getRoleId();
            Long usrgrpId = ugRoleDim.getUsrGrpId();
            if (StringUtils.isEmpty((String)roleId) || null == usrgrpId || Objects.equals(0L, usrgrpId)) continue;
            Set<Long> userIdSet = grpIdUIdSetMap.get(usrgrpId);
            if (null != userIdSet && !userIdSet.isEmpty()) {
                roleIdUserIdsMap.computeIfAbsent(roleId, k -> new HashSet(8)).addAll(userIdSet);
            }
            if (null == (userIdSetNoneEnable = grpIdUIdSetMapNoneEnable.get(usrgrpId)) || userIdSetNoneEnable.isEmpty()) continue;
            roleIdUserIdsMapNoneEnable.computeIfAbsent(roleId, k -> new HashSet(8)).addAll(userIdSetNoneEnable);
        }
    }
}

