/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.admingroup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpBizUnitReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdmGrpBizUnitService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(AdmGrpBizUnitService.class);

    public static Map<Long, AdmGrpHasPermResp> getAssignableAdmGrpHasPerm(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        adminGroupIdSet.removeIf(x -> null == x || Objects.equals(0L, x));
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        return AdmGrpBizUnitService.getAssignableAdmGrpHasPermPri(adminGroupIdSet);
    }

    private static Map<Long, AdmGrpHasPermResp> getAssignableAdmGrpHasPermPri(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper(adminGroupIdSet, (boolean)true);
        Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
        AdmGrpHasPermResp topAdmGrpBizUnitMap = AdmGrpBizUnitService.getTopAdmGrpBizUnitSetMap();
        HashMap<Long, AdmGrpHasPermResp> map = new HashMap<Long, AdmGrpHasPermResp>(8);
        for (Long adminGroupId : adminGroupIdSet) {
            GetAdmGrpBizUnitReq req;
            Map<Long, Set<AdmGrpBizUnit>> admGrpBizUnitMap;
            AdmGroup curAdmGroup = (AdmGroup)admGroupMap.get(adminGroupId);
            if (null == curAdmGroup) continue;
            Set<AdmGrpBizUnit> curSet = null;
            long currentGroupId = curAdmGroup.getId();
            long level = curAdmGroup.getLevel().intValue();
            long parent = curAdmGroup.getParent();
            while (level > 1L && kd.bos.util.CollectionUtils.isEmpty(curSet = (admGrpBizUnitMap = AdmGrpBizUnitService.getAllAdmGrpCurBizUnitMap(false, req = (GetAdmGrpBizUnitReq)PermBuilder.of(GetAdmGrpBizUnitReq::new).with(GetAdmGrpBizUnitReq::setAdminGroupIdSet, (Object)Sets.newHashSet((Object[])new Long[]{currentGroupId})).build())).get(currentGroupId))) {
                AdmGroup admGroup = (AdmGroup)admGroupMap.get(parent);
                currentGroupId = parent;
                level = admGroup.getLevel().intValue();
                parent = admGroup.getParent();
            }
            if (kd.bos.util.CollectionUtils.isNotEmpty(curSet)) {
                AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
                resp.setBizUnitSet(curSet);
                map.put(adminGroupId, resp);
                continue;
            }
            map.put(adminGroupId, topAdmGrpBizUnitMap);
        }
        return map;
    }

    private static AdmGrpHasPermResp getTopAdmGrpBizUnitSetMap() {
        String key = String.format("%s%s", "getTopAdmGrpBizUnitSetMap_", RequestContext.get().getAccountId());
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, AdmGrpHasPermResp> map = new HashMap<String, AdmGrpHasPermResp>(8);
            AdmGrpHasPermResp topAdmGrpBizUnitSetMapPri = AdmGrpBizUnitService.getTopAdmGrpBizUnitSetMapPri();
            if (null == topAdmGrpBizUnitSetMapPri) {
                return map;
            }
            map.put("getTopAdmGrpBizUnitSetMap_", topAdmGrpBizUnitSetMapPri);
            return map;
        });
        return (AdmGrpHasPermResp)threadCacheMap.get("getTopAdmGrpBizUnitSetMap_");
    }

    private static AdmGrpHasPermResp getTopAdmGrpBizUnitSetMapPri() {
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        final HashSet bizUnitSet = new HashSet(8);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid  ");
        sql.append(" FROM t_org_org org ");
        sql.append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ");
        sql.append(" WHERE org.fenable = '1' AND os.fisfreeze = '0' ");
        sql.append(" AND EXISTS(SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FID = ").append(Long.parseLong("15")).append(" AND ov.FISDEFAULT = '1') ");
        Set orgIdSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> set = new HashSet<Long>(8);
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    set.add(orgId);
                }
                return set;
            }
        });
        if (null == orgIdSet || orgIdSet.isEmpty()) {
            resp.setBizUnitSet(new HashSet(0));
            return resp;
        }
        final Map orgMap = OrgHelper.getOrgMap(new ArrayList(orgIdSet));
        final Map orgPatternTypeMap = OrgHelper.getOrgPatternTypeMap();
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                AdmGrpBizUnit one = null;
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    String orgNum = rs.getString("fnumber");
                    Org org = (Org)orgMap.get(orgId);
                    String orgName = null == org ? "" : org.getOrgName();
                    String orgLongNumber = rs.getString("flongnumber").replace('!', ' ');
                    boolean isCorporateOrg = false;
                    String orgPatternId = rs.getString("forgpatternid");
                    String patternType = (String)orgPatternTypeMap.get(orgPatternId);
                    if ("1".equals(patternType) || "2".equals(patternType)) {
                        isCorporateOrg = true;
                    }
                    one = new AdmGrpBizUnit(null, null, null, null, orgId, orgNum, orgName, orgLongNumber, isCorporateOrg);
                    bizUnitSet.add(one);
                }
                return null;
            }
        });
        resp.setBizUnitSet(bizUnitSet);
        return resp;
    }

    private static Map<Long, Set<AdmGrpBizUnit>> getAllAdmGrpCurBizUnitMap(boolean isLeftTree, GetAdmGrpBizUnitReq req) {
        Set orgIdSet;
        String inStr;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid, pa.fusergroupid, pa.fid ");
        sql.append(" FROM t_perm_admingroupbizunit pa ");
        sql.append(" INNER JOIN t_org_org org ON org.fid = pa.forgId");
        sql.append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ");
        sql.append(" WHERE 1=1 ");
        if (isLeftTree) {
            sql.append(" AND org.fenable = '1' ").append(" AND os.fisfreeze = '0' ");
        }
        sql.append(" AND EXISTS (SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FID = ").append(Long.parseLong("15")).append(" AND ov.FISDEFAULT = '1') ");
        ArrayList paramList = new ArrayList(6);
        Set adminGroupIdSet = req.getAdminGroupIdSet();
        if (!CollectionUtils.isEmpty((Collection)adminGroupIdSet) && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(adminGroupIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sql.append(" and pa.fusergroupid in (").append(inStr).append(") ");
        }
        if (null == (orgIdSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> set = new HashSet<Long>(8);
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    set.add(orgId);
                }
                return set;
            }
        })) || orgIdSet.isEmpty()) {
            return new HashMap<Long, Set<AdmGrpBizUnit>>(0);
        }
        final Map orgMap = OrgHelper.getOrgMap(new ArrayList(orgIdSet));
        final Map orgPatternTypeMap = OrgHelper.getOrgPatternTypeMap();
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<Long, Set<AdmGrpBizUnit>>>(){

            public Map<Long, Set<AdmGrpBizUnit>> handle(ResultSet rs) throws SQLException {
                HashMap<Long, Set<AdmGrpBizUnit>> map = new HashMap<Long, Set<AdmGrpBizUnit>>(8);
                AdmGrpBizUnit one = null;
                while (rs.next()) {
                    long adminGrpId = rs.getLong("fusergroupid");
                    Long orgId = rs.getLong("forgid");
                    String orgNum = rs.getString("fnumber");
                    Org org = (Org)orgMap.get(orgId);
                    String orgName = null == org ? "" : org.getOrgName();
                    String orgLongNumber = rs.getString("flongnumber").replace('!', ' ');
                    boolean isCorporateOrg = false;
                    String orgPatternId = rs.getString("forgpatternid");
                    String patternType = (String)orgPatternTypeMap.get(orgPatternId);
                    if ("1".equals(patternType) || "2".equals(patternType)) {
                        isCorporateOrg = true;
                    }
                    one = new AdmGrpBizUnit(Long.valueOf(rs.getLong("fid")), Long.valueOf(adminGrpId), null, null, orgId, orgNum, orgName, orgLongNumber, isCorporateOrg);
                    map.computeIfAbsent(adminGrpId, k -> new HashSet(8)).add(one);
                }
                return map;
            }
        });
    }

    public static Map<Long, Set<AdmGrpBizUnit>> getAdmGrpBizUnitSetMap(GetAdmGrpBizUnitReq req) {
        List<QFilter> filterList = AdmGrpBizUnitService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpBizUnitService.getAdmGrpBizUnitSetMap", (String)"perm_admingroupbizunit", (String)"id, usergroup_id, usergroup.number, usergroup.name,  org_id, org.number, org.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<AdmGrpBizUnit>> map = new HashMap<Long, Set<AdmGrpBizUnit>>(8);
            AdmGrpBizUnit one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                one = new AdmGrpBizUnit(row.getLong("id"), adminGroupId, row.getString("usergroup.number"), row.getString("usergroup.name"), row.getLong("org_id"), row.getString("org.number"), row.getString("org.name"), null, false);
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(one);
            }
            HashMap<Long, Set<AdmGrpBizUnit>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, AdmGrpBizUnit> getAdmGrpBizUnitMap(GetAdmGrpBizUnitReq req) {
        List<QFilter> filterList = AdmGrpBizUnitService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpBizUnitService.getAdmGrpBizUnitMap", (String)"perm_admingroupbizunit", (String)"id, usergroup_id, usergroup.number, usergroup.name, usergroup.adminscheme,  org_id, org.number, org.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<Long, AdmGrpBizUnit> map = new HashMap<Long, AdmGrpBizUnit>(8);
            AdmGrpBizUnit one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long org_id = row.getLong("org_id");
                Long usergroup_id = row.getLong("usergroup_id");
                if (uniqueStrFilter && !uniqueStrSet.contains(usergroup_id + "|" + org_id)) continue;
                one = new AdmGrpBizUnit(id, usergroup_id, row.getString("usergroup.number"), row.getString("usergroup.name"), org_id, row.getString("org.number"), row.getString("org.name"), null, false);
                one.setAdminScheme(row.getLong("usergroup.adminscheme"));
                map.put(id, one);
            }
            HashMap<Long, AdmGrpBizUnit> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetAdmGrpBizUnitReq req) {
        Map orgMap;
        Set collect;
        Set orgNumSet;
        Set orgIdSet;
        Map admGroupMap;
        Set collect2;
        Set adminGroupNumSet;
        Set adminGroupIdSet;
        if (null == req) {
            req = new GetAdmGrpBizUnitReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupIdSet = req.getAdminGroupIdSet()))) {
            filterList.add(new QFilter("usergroup", "in", (Object)adminGroupIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupNumSet = req.getAdminGroupNumSet())) && !CollectionUtils.isEmpty(collect2 = (admGroupMap = AdminGroupHelper.getAdminGrpMap((Set)adminGroupNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(AdmGroup::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usergroup", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgIdSet = req.getOrgIdSet()))) {
            filterList.add(new QFilter("org", "in", (Object)orgIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgNumSet = req.getOrgNumSet())) && !CollectionUtils.isEmpty(collect = (orgMap = OrgHelper.getOrgMap((Set)orgNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("org", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpBizUnit>> afterDataMap = AdmGrpBizUnitService.getAdmGrpBizUnitSetMap(new GetAdmGrpBizUnitReq(mainIdSet, null, null, null, null, null));
            Set<Long> adminGroupIdSet = afterDataMap.keySet();
            if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpBizUnit>>>(){}));
            }
            for (Long adminGroupId : adminGroupIdSet) {
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Set<Object> after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del) && kd.bos.util.CollectionUtils.isEmpty((Collection)add)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpBizUnit", del);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("addAdmGrpBizUnit", add);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build());
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            Set adminGroupIdSet;
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpBizUnit>>>(){}));
            }
            if (null == (adminGroupIdSet = preDataMap.keySet()) || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpBizUnit>> afterDataMap = AdmGrpBizUnitService.getAdmGrpBizUnitSetMap(new GetAdmGrpBizUnitReq(null, adminGroupIdSet, null, null, null, null));
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set<Object> after;
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId));
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpBizUnit", del);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build());
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public static PermResult saveByAdmGrp(AdmGrpOperationReq req) {
        Map willAddBizUnitMap;
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String operEntNum = "perm_admingroupbizunit";
        String needClearAllCache = req.getNeedClearAllCache();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        String doDelExcessData = req.getDoDelExcessData();
        Boolean entSavePermlog = req.getEntSavePermlog();
        PermLogReq permLogReq = req.getPermLogReq();
        String permLogInterfaceMethod = "AdmGrpBizUnitService.saveByAdmGrp";
        Map willDelBizUnitMap = req.getWillDelBizUnitMap();
        if (null != willDelBizUnitMap && !willDelBizUnitMap.isEmpty()) {
            PermResult delRes;
            DynamicObject[] dynArr;
            Map<Long, AdmGrpBizUnit> dataMap;
            HashSet<Long> admGrpIdSet = new HashSet<Long>(8);
            HashSet<Long> orgIdSet = new HashSet<Long>(8);
            HashSet<String> uniqueStrSet = new HashSet<String>(8);
            for (Map.Entry one : willDelBizUnitMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                admGrpIdSet.add(Long.valueOf(adminGroupId));
                for (AdmGrpBizUnit innerOne : value) {
                    Long orgId = innerOne.getOrgId();
                    orgIdSet.add(orgId);
                    uniqueStrSet.add(adminGroupId + "|" + orgId);
                }
            }
            if (!(null == admGrpIdSet || admGrpIdSet.isEmpty() || null == (dataMap = AdmGrpBizUnitService.getAdmGrpBizUnitMap(new GetAdmGrpBizUnitReq(null, admGrpIdSet, null, orgIdSet, null, uniqueStrSet))) || dataMap.isEmpty() || null == (dynArr = BusinessDataServiceHelper.load((String)operEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", dataMap.keySet())})) || Objects.equals(0, dynArr.length) || (delRes = AdmGrpBizUnitService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"delete").with(PermOperationReq::setDataEntities, (Object)dynArr).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"delete").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getDel()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build())).isOk())) {
                return delRes;
            }
        }
        if (null != (willAddBizUnitMap = req.getWillAddBizUnitMap()) && !willAddBizUnitMap.isEmpty()) {
            GetBaseDataDynMapResp baseDataDynMapResp = null == req.getBaseDataDynMapResp() ? new GetBaseDataDynMapResp() : req.getBaseDataDynMapResp();
            Map orgDynMap = null == baseDataDynMapResp.getOrgDynMap() ? new HashMap(0) : baseDataDynMapResp.getOrgDynMap();
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(willAddBizUnitMap.size());
            DynamicObject dyn = null;
            for (Map.Entry one : willAddBizUnitMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                for (AdmGrpBizUnit innerOne : value) {
                    dyn = BusinessDataServiceHelper.newDynamicObject((String)operEntNum);
                    dyn.set("usergroup_id", (Object)adminGroupId);
                    Long orgId = innerOne.getOrgId();
                    dyn.set("org_id", (Object)orgId);
                    dyn.set("org", orgDynMap.get(orgId));
                    dynList.add(dyn);
                }
            }
            PermResult addRes = AdmGrpBizUnitService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)dynList.toArray(new DynamicObject[dynList.size()])).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build());
            if (!addRes.isOk()) {
                return addRes;
            }
        }
        return PermResult.ok();
    }
}

