/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.admingroup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpOrgAddUserReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdmGrpOrgAddUserService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(AdmGrpOrgAddUserService.class);

    public static Map<Long, AdmGrpHasPermResp> getAdmGrpHasPerm(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        adminGroupIdSet.removeIf(x -> null == x || Objects.equals(0L, x));
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        return AdmGrpOrgAddUserService.getAdmGrpHasPermPri(adminGroupIdSet);
    }

    private static Map<Long, AdmGrpHasPermResp> getAdmGrpHasPermPri(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(adminGroupIdSet);
        Map<Long, Set<AdmGrpOrgAddUser>> admGrpOrgAddUserSetMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserSetMap(new GetAdmGrpOrgAddUserReq(adminGroupIdSet));
        HashMap<Long, AdmGrpHasPermResp> map = new HashMap<Long, AdmGrpHasPermResp>(8);
        AdmGrpHasPermResp resp = null;
        for (Long adminGroupId : adminGroupIdSet) {
            AdmGroup curAdmGroup = (AdmGroup)admGroupMap.get(adminGroupId);
            if (null == curAdmGroup) {
                map.put(adminGroupId, resp);
                continue;
            }
            resp = new AdmGrpHasPermResp();
            resp.setHasAllOrgAddUser(false);
            resp.setOrgAddUserSet(null == admGrpOrgAddUserSetMap.get(adminGroupId) ? new HashSet(0) : admGrpOrgAddUserSetMap.get(adminGroupId));
            map.put(adminGroupId, resp);
        }
        return map;
    }

    public static Map<Long, Set<AdmGrpOrgAddUser>> getAdmGrpOrgAddUserSetMap(GetAdmGrpOrgAddUserReq req) {
        List<QFilter> filterList = AdmGrpOrgAddUserService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpOrgAddUserService.getAdmGrpOrgAddUserSetMap", (String)"perm_admingroupadduser", (String)"id, usergroup_id, usergroup.number, usergroup.name,  user_id, user.name, user.number, user.username", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<AdmGrpOrgAddUser>> map = new HashMap<Long, Set<AdmGrpOrgAddUser>>(8);
            AdmGrpOrgAddUser one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                one = new AdmGrpOrgAddUser(row.getLong("id"), adminGroupId, row.getString("usergroup.number"), row.getString("usergroup.name"), row.getLong("user_id"), row.getString("user.name"), row.getString("user.number"), row.getString("user.username"));
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(one);
            }
            HashMap<Long, Set<AdmGrpOrgAddUser>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, AdmGrpOrgAddUser> getAdmGrpOrgAddUserMap(GetAdmGrpOrgAddUserReq req) {
        List<QFilter> filterList = AdmGrpOrgAddUserService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpOrgAddUserService.getAdmGrpOrgAddUserMap", (String)"perm_admingroupadduser", (String)"id, usergroup_id, usergroup.number, usergroup.name, usergroup.adminscheme,  user_id, user.name, user.number, user.username", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<Long, AdmGrpOrgAddUser> map = new HashMap<Long, AdmGrpOrgAddUser>(8);
            AdmGrpOrgAddUser one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long usergroup_id = row.getLong("usergroup_id");
                Long user_id = row.getLong("user_id");
                if (uniqueStrFilter && !uniqueStrSet.contains(usergroup_id + "|" + user_id)) continue;
                one = new AdmGrpOrgAddUser(id, usergroup_id, row.getString("usergroup.number"), row.getString("usergroup.name"), user_id, row.getString("user.name"), row.getString("user.number"), row.getString("user.username"));
                one.setAdminScheme(row.getLong("usergroup.adminscheme"));
                map.put(id, one);
            }
            HashMap<Long, AdmGrpOrgAddUser> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetAdmGrpOrgAddUserReq req) {
        Map userMap;
        Set collect;
        Set userNumSet;
        Set userIdSet;
        Map admGroupMap;
        Set collect2;
        Set adminGroupNumSet;
        Set adminGroupIdSet;
        if (null == req) {
            req = new GetAdmGrpOrgAddUserReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupIdSet = req.getAdminGroupIdSet()))) {
            filterList.add(new QFilter("usergroup", "in", (Object)adminGroupIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupNumSet = req.getAdminGroupNumSet())) && !CollectionUtils.isEmpty(collect2 = (admGroupMap = AdminGroupHelper.getAdminGrpMap((Set)adminGroupNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(AdmGroup::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usergroup", "in", collect2));
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)(userNumSet = req.getUserNumSet())) && !kd.bos.util.CollectionUtils.isEmpty(collect = (userMap = UserHelper.getUserMap((Set)userNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpOrgAddUser>> afterDataMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserSetMap(new GetAdmGrpOrgAddUserReq(mainIdSet, null, null, null, null, null));
            Set<Long> adminGroupIdSet = afterDataMap.keySet();
            if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpOrgAddUser>>>(){}));
            }
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Set<Object> after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del) && kd.bos.util.CollectionUtils.isEmpty((Collection)add)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpOrgAddUser", del);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("addAdmGrpOrgAddUser", add);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build());
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            Set adminGroupIdSet;
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpOrgAddUser>>>(){}));
            }
            if (null == (adminGroupIdSet = preDataMap.keySet()) || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpOrgAddUser>> afterDataMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserSetMap(new GetAdmGrpOrgAddUserReq(null, adminGroupIdSet, null, null, null, null));
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set<Object> after;
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId));
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpOrgAddUser", del);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build());
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public static PermResult saveByAdmGrp(AdmGrpOperationReq req) {
        Map willAddOrgAddUserMap;
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String operEntNum = "perm_admingroupadduser";
        String needClearAllCache = req.getNeedClearAllCache();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        String doDelExcessData = req.getDoDelExcessData();
        Boolean entSavePermlog = req.getEntSavePermlog();
        PermLogReq permLogReq = req.getPermLogReq();
        String permLogInterfaceMethod = "AdmGrpOrgAddUserService.saveByAdmGrp";
        Map willDelOrgAddUserMap = req.getWillDelOrgAddUserMap();
        if (null != willDelOrgAddUserMap && !willDelOrgAddUserMap.isEmpty()) {
            PermResult delRes;
            DynamicObject[] dynArr;
            Map<Long, AdmGrpOrgAddUser> dataMap;
            HashSet<Long> admGrpIdSet = new HashSet<Long>(8);
            HashSet<Long> userIdSet = new HashSet<Long>(8);
            HashSet<String> uniqueStrSet = new HashSet<String>(8);
            for (Map.Entry one : willDelOrgAddUserMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                admGrpIdSet.add(Long.valueOf(adminGroupId));
                for (AdmGrpOrgAddUser innerOne : value) {
                    Long userId = innerOne.getUserId();
                    userIdSet.add(userId);
                    uniqueStrSet.add(adminGroupId + "|" + userId);
                }
            }
            if (!(null == admGrpIdSet || admGrpIdSet.isEmpty() || null == (dataMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserMap(new GetAdmGrpOrgAddUserReq(null, admGrpIdSet, null, userIdSet, null, uniqueStrSet))) || dataMap.isEmpty() || null == (dynArr = BusinessDataServiceHelper.load((String)operEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", dataMap.keySet())})) || Objects.equals(0, dynArr.length) || (delRes = AdmGrpOrgAddUserService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"delete").with(PermOperationReq::setDataEntities, (Object)dynArr).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"delete").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getDel()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build())).isOk())) {
                return delRes;
            }
        }
        if (null != (willAddOrgAddUserMap = req.getWillAddOrgAddUserMap()) && !willAddOrgAddUserMap.isEmpty()) {
            GetBaseDataDynMapResp baseDataDynMapResp = null == req.getBaseDataDynMapResp() ? new GetBaseDataDynMapResp() : req.getBaseDataDynMapResp();
            Map userDynMap = null == baseDataDynMapResp.getUserDynMap() ? new HashMap(0) : baseDataDynMapResp.getUserDynMap();
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(willAddOrgAddUserMap.size());
            DynamicObject dyn = null;
            for (Map.Entry one : willAddOrgAddUserMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                for (AdmGrpOrgAddUser innerOne : value) {
                    dyn = BusinessDataServiceHelper.newDynamicObject((String)operEntNum);
                    dyn.set("usergroup_id", (Object)adminGroupId);
                    Long userId = innerOne.getUserId();
                    dyn.set("user_id", (Object)userId);
                    dyn.set("user", userDynMap.get(userId));
                    dynList.add(dyn);
                }
            }
            PermResult addRes = AdmGrpOrgAddUserService.genOperateOptionAndExec((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)dynList.toArray(new DynamicObject[dynList.size()])).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build());
            if (!addRes.isOk()) {
                return addRes;
            }
        }
        return PermResult.ok();
    }

    public static ListShowParameter getUserF7LspMap(IPageCache pageCache, Set<Long> extraUserIds) {
        List F7Qfilter = UserHelper.getUserF7QfilterList((boolean)false, (Boolean)Boolean.TRUE, (String)"all", extraUserIds, (boolean)true, (Set)Sets.newHashSet((Object[])new String[]{"1"}), (Set)Sets.newHashSet((Object[])new String[]{"0"}), null);
        if (null == F7Qfilter) {
            return null;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        lsp.setCustomParam("externalUserType", (Object)"all");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)F7Qfilter)) {
            lsp.setListFilterParameter(new ListFilterParameter(F7Qfilter, null));
        }
        return lsp;
    }

    public static Map<String, Set<Long>> getAdmGrpUserIdSetMap(Set<String> admGrpNumSet) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdmGrpOrgAddUserService.getAdmGrpUserIdSetMap", (String)"perm_admingroupadduser", (String)"usergroup.number, user", (QFilter[])new QFilter[]{new QFilter("usergroup.number", "in", admGrpNumSet)}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                String adminGroupNum = row.getString("usergroup.number");
                Long userId = row.getLong("user");
                map.computeIfAbsent(adminGroupNum, k -> new HashSet(8)).add(userId);
            }
        }
        return map;
    }

    public static Set<PermUser> orgAddUserF7AddRange(Set<Long> excludeUserIdSet) {
        return UserHelper.getF7Users((boolean)true, (Boolean)Boolean.TRUE, (String)"all", excludeUserIdSet, (boolean)true, (Set)Sets.newHashSet((Object[])new String[]{"1"}), (Set)Sets.newHashSet((Object[])new String[]{"0"}), null);
    }
}

