/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.admingroup;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.admingroup.UserAdmGrp;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetUserAdmGrpReq;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.service.CommonService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserAdmGrpService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UserAdmGrpService.class);

    public static Map<Long, Set<Long>> getAdmGrpUserIdSetMap(Set<Long> adminGroupIdSet, boolean includeAdmGrpAdduser) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupHelper.getAdmGrpUserIdSetMap", (String)"perm_useradmingroup", (String)"usergroup, user", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", adminGroupIdSet)}, (String)"");
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Long adminGroupId = row.getLong("usergroup");
                Long userId = row.getLong("user");
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(userId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (includeAdmGrpAdduser) {
            Map admOrgAddUserIdSetMap = AdminGroupHelper.getAdmOrgAddUserIdSetMap(adminGroupIdSet);
            for (Map.Entry entry : admOrgAddUserIdSetMap.entrySet()) {
                map.computeIfAbsent((Long)entry.getKey(), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet(8))).addAll((Collection)entry.getValue());
            }
        }
        return map;
    }

    private static Map<Long, List<QFilter>> getAdmGrpAddUserF7QfilterMap(Set<Long> admGrpIdSet, boolean lspFilter) {
        if (null == admGrpIdSet || admGrpIdSet.isEmpty()) {
            return new HashMap<Long, List<QFilter>>(0);
        }
        HashMap<Long, List<QFilter>> map = new HashMap<Long, List<QFilter>>(admGrpIdSet.size());
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Long curUserSchemeAdminType = AdminSchemeHelper.getCurUserSchemeAdminType((Long)curEnableSchemeId);
        Set schemeFilterUserIds = AdminSchemeHelper.getTransAndOtherAdminTypeUserIds((Long)curEnableSchemeId, (Long)curUserSchemeAdminType);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"1");
        ArrayList<Long> userTypes = new ArrayList<Long>(10);
        userTypes.add(1L);
        QFilter userTypesLikeFilter = UserUtils.getUserTypesLikeFilter(userTypes);
        QFilter isforbiddenQfilter = new QFilter("isforbidden", "=", (Object)"0");
        Map<Long, Set<Long>> admGrpUserIdSetMap = UserAdmGrpService.getAdmGrpUserIdSetMap(admGrpIdSet, false);
        for (Long admGrpId : admGrpIdSet) {
            Set<Object> filterUserIds = null == admGrpUserIdSetMap.get(admGrpId) ? new HashSet(0) : admGrpUserIdSetMap.get(admGrpId);
            filterUserIds.addAll(schemeFilterUserIds);
            filterUserIds.add(currUserId);
            filterUserIds.add(1L);
            filterUserIds.add(2L);
            filterUserIds.add(3L);
            filterUserIds.add(10L);
            ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>(10);
            if (kd.bos.util.CollectionUtils.isNotEmpty(filterUserIds)) {
                rangeFilterList.add(new QFilter("id", "not in", filterUserIds));
            }
            rangeFilterList.add(enableQfilter);
            rangeFilterList.add(userTypesLikeFilter);
            rangeFilterList.add(isforbiddenQfilter);
            if (lspFilter) {
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
                lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                QFilter adminChargeUsersFilter = UserUtils.getAdminChargeUsersFilter((long)currUserId, (ListShowParameter)lsp, null);
                if (null != adminChargeUsersFilter) {
                    rangeFilterList.add(adminChargeUsersFilter);
                }
            }
            map.put(admGrpId, rangeFilterList);
        }
        return map;
    }

    public static Map<Long, Set<PermUser>> getAdmGrpAddUserF7Map(Set<Long> admGrpIdSet) {
        if (null == admGrpIdSet || admGrpIdSet.isEmpty()) {
            return new HashMap<Long, Set<PermUser>>(0);
        }
        HashMap<Long, Set<PermUser>> map = new HashMap<Long, Set<PermUser>>(admGrpIdSet.size());
        Map<Long, List<QFilter>> admGrpAddUserF7QfilterMap = UserAdmGrpService.getAdmGrpAddUserF7QfilterMap(admGrpIdSet, true);
        if (null == admGrpAddUserF7QfilterMap) {
            return new HashMap<Long, Set<PermUser>>(0);
        }
        for (Long admGrpId : admGrpIdSet) {
            List<QFilter> qFilterList = admGrpAddUserF7QfilterMap.get(admGrpId);
            if (null == qFilterList) continue;
            DataSet ds = QueryServiceHelper.queryDataSet((String)"UserAdmGrpService.getAdmGrpAddUserF7Map", (String)"bos_user", (String)"id, name, number", (QFilter[])qFilterList.toArray(qFilterList.toArray(new QFilter[qFilterList.size()])), (String)"");
            Throwable throwable = null;
            try {
                PermUser one = null;
                while (ds.hasNext()) {
                    Row row = ds.next();
                    one = new PermUser(row.getLong("id"), row.getString("number"), row.getString("name"));
                    map.computeIfAbsent(admGrpId, k -> new HashSet(8)).add(one);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return map;
    }

    public static Map<Long, ListShowParameter> getAdmGrpAddUserF7LspMap(Set<Long> admGrpIdSet, IPageCache pageCache) {
        if (null == admGrpIdSet || admGrpIdSet.isEmpty()) {
            return new HashMap<Long, ListShowParameter>(0);
        }
        Map<Long, List<QFilter>> admGrpAddUserF7QfilterMap = UserAdmGrpService.getAdmGrpAddUserF7QfilterMap(admGrpIdSet, false);
        if (null == admGrpAddUserF7QfilterMap) {
            return new HashMap<Long, ListShowParameter>(0);
        }
        HashMap<Long, ListShowParameter> map = new HashMap<Long, ListShowParameter>(admGrpIdSet.size());
        for (Long admGrpId : admGrpIdSet) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            List<QFilter> qFilterList = admGrpAddUserF7QfilterMap.get(admGrpId);
            if (kd.bos.util.CollectionUtils.isNotEmpty(qFilterList)) {
                lsp.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
            map.put(admGrpId, lsp);
        }
        return map;
    }

    public static Set<Long> getAdmGrpIdSet(GetUserAdmGrpReq req) {
        List<QFilter> filterList = UserAdmGrpService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserAdmGrpService.getAdmGrpIdSet", (String)"perm_useradmingroup", (String)"usergroup_id", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashSet<Long> set = new HashSet<Long>(8);
            Object one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                set.add(adminGroupId);
            }
            HashSet<Long> hashSet = set;
            return hashSet;
        }
    }

    public static Map<Long, Set<UserAdmGrp>> getUserAdmGrpSetMap(GetUserAdmGrpReq req) {
        List<QFilter> filterList = UserAdmGrpService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserAdmGrpService.getUserAdmGrpSetMap", (String)"perm_useradmingroup", (String)"id, usergroup_id, usergroup.number, usergroup.name, user_id, user.name, user.number, user.username", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<UserAdmGrp>> map = new HashMap<Long, Set<UserAdmGrp>>(8);
            UserAdmGrp one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                one = new UserAdmGrp(row.getLong("id"), adminGroupId, row.getString("usergroup.number"), row.getString("usergroup.name"), row.getLong("user_id"), row.getString("user.name"), row.getString("user.number"), row.getString("user.username"));
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(one);
            }
            HashMap<Long, Set<UserAdmGrp>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, UserAdmGrp> getUserAdmGrpMap(GetUserAdmGrpReq req) {
        List<QFilter> filterList = UserAdmGrpService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserAdmGrpService.getUserAdmGrpMap", (String)"perm_useradmingroup", (String)"id, usergroup_id, usergroup.number, usergroup.name, usergroup.adminscheme, usergroup.level, user_id, user.name, user.number, user.username", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<Long, UserAdmGrp> map = new HashMap<Long, UserAdmGrp>(8);
            UserAdmGrp one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long usergroup_id = row.getLong("usergroup_id");
                Long user_id = row.getLong("user_id");
                if (uniqueStrFilter && !uniqueStrSet.contains(usergroup_id + "|" + user_id)) continue;
                one = new UserAdmGrp(id, usergroup_id, row.getString("usergroup.number"), row.getString("usergroup.name"), user_id, row.getString("user.name"), row.getString("user.number"), row.getString("user.username"));
                one.setAdminScheme(row.getLong("usergroup.adminscheme"));
                one.setAdminLevel(row.getLong("usergroup.level"));
                map.put(id, one);
            }
            HashMap<Long, UserAdmGrp> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetUserAdmGrpReq req) {
        Map userMap;
        Set collect;
        Set userNumSet;
        Set userIdSet;
        Map admGroupMap;
        Set collect2;
        Set adminGroupNumSet;
        Set adminGroupIdSet;
        if (null == req) {
            req = new GetUserAdmGrpReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupIdSet = req.getAdminGroupIdSet()))) {
            filterList.add(new QFilter("usergroup", "in", (Object)adminGroupIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupNumSet = req.getAdminGroupNumSet())) && !CollectionUtils.isEmpty(collect2 = (admGroupMap = AdminGroupHelper.getAdminGrpMap((Set)adminGroupNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(AdmGroup::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usergroup", "in", collect2));
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)(userNumSet = req.getUserNumSet())) && !kd.bos.util.CollectionUtils.isEmpty(collect = (userMap = UserHelper.getUserMap((Set)userNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq req) {
        try {
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<UserAdmGrp>> afterDataMap = UserAdmGrpService.getUserAdmGrpSetMap(new GetUserAdmGrpReq(mainIdSet, null, null, null, null, null));
            Set<Long> adminGroupIdSet = afterDataMap.keySet();
            if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<UserAdmGrp>>>(){}));
            }
            HashMap<String, Map<String, Object>> saveDiffMap = new HashMap<String, Map<String, Object>>(8);
            HashSet<String> influenUserIdSet = new HashSet<String>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Set<Object> after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del) && kd.bos.util.CollectionUtils.isEmpty((Collection)add)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delUserAdmGrp", del);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("addUserAdmGrp", add);
                influenUserIdSet.addAll(del.stream().map(x -> String.valueOf(x.getUserId())).collect(Collectors.toSet()));
                influenUserIdSet.addAll(add.stream().map(x -> String.valueOf(x.getUserId())).collect(Collectors.toSet()));
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("influenUserIdSet", influenUserIdSet);
            }
            UserAdmGrpService.saveOrDel(saveDiffMap, req.getPermLogReq(), influenUserIdSet, req.getNeedClearAllCache());
            super.afterMainEntitySaveExt(req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq req) {
        try {
            Set adminGroupIdSet;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<UserAdmGrp>>>(){}));
            }
            if (null == (adminGroupIdSet = preDataMap.keySet()) || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<String, Map<String, Object>> saveDiffMap = new HashMap<String, Map<String, Object>>(8);
            Set<String> influenUserIdSet = new HashSet<String>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set del;
                Set set = del = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                if (kd.bos.util.CollectionUtils.isEmpty(del)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delUserAdmGrp", del);
                influenUserIdSet = del.stream().map(x -> String.valueOf(x.getUserId())).collect(Collectors.toSet());
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("influenUserIdSet", influenUserIdSet);
            }
            UserAdmGrpService.saveOrDel(saveDiffMap, req.getPermLogReq(), influenUserIdSet, req.getNeedClearAllCache());
            super.afterDelExt(req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private static void saveOrDel(Map<String, Map<String, Object>> saveDiffMap, PermLogReq permLogReq, Set<String> influenUserIdSet, String needClearAllCache) {
        if (null != saveDiffMap && !saveDiffMap.isEmpty() && (StringUtils.isEmpty((String)needClearAllCache) || Objects.equals("1", needClearAllCache))) {
            CacheMrg.clearAllCache();
        }
        if (null != influenUserIdSet && !influenUserIdSet.isEmpty()) {
            PermCommonUtil.cancelShowForm(influenUserIdSet.stream().map(Long::valueOf).collect(Collectors.toList()), null, (boolean)false);
        }
        UserAdmGrpService.saveOrDel2PermLog(saveDiffMap, permLogReq);
    }

    private static void saveOrDel2PermLog(Map<String, Map<String, Object>> saveDiffMap, PermLogReq permLogReq) {
        if (!PermCommonUtil.isEnablePermLog() || null == permLogReq || null == saveDiffMap || saveDiffMap.isEmpty()) {
            return;
        }
        Set<String> admGroupIdSet = saveDiffMap.keySet();
        try {
            Set admGroupIdLongSet = admGroupIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            Map admGroupInfoMap = AdminGroupHelper.getAdmGroupInfoMap(admGroupIdLongSet);
            int size = admGroupIdSet.size();
            ArrayList list = new ArrayList(size);
            for (String admGroupId : admGroupIdSet) {
                Map<String, Object> adminGroupIdSaveDiff;
                AdmGroup admGroup = (AdmGroup)admGroupInfoMap.get(Long.valueOf(admGroupId));
                if (null == admGroup || null == (adminGroupIdSaveDiff = saveDiffMap.get(admGroupId)) || adminGroupIdSaveDiff.isEmpty()) continue;
                String opItemId = admGroupId;
                String opItemName = admGroup.getName();
                String opItemNumber = admGroup.getNumber();
                adminGroupIdSaveDiff.put("langStr", RequestContext.get().getLang().name());
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", permLogReq.getCloudId());
                map.put("app_id", permLogReq.getAppId());
                map.put("form_identity", permLogReq.getFormIdentity());
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", permLogReq.getPreData());
                map.put("after_data", permLogReq.getAfterData());
                String saveDiffStr = StrUtil.compress((String)new ObjectMapper().writeValueAsString(adminGroupIdSaveDiff));
                map.put("diff_content", saveDiffStr);
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserAdmGrpService.saveOrDel2PermLog error, mainIdSet:{}", (Object)JSON.toJSONString(admGroupIdSet), (Object)e);
        }
    }

    public static DynamicObject[] getUserAdmGrpDynArr(Long userId, Long adminSchemeId) {
        QFilter[] filters = new QFilter[]{new QFilter("user.id", "=", (Object)userId).and("usergroup.adminscheme.id", "=", (Object)adminSchemeId)};
        DynamicObject[] userAdminGroup = BusinessDataServiceHelper.load((String)"perm_useradmingroup", (String)"user,usergroup", (QFilter[])filters);
        return userAdminGroup;
    }
}

