/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.comrole;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.comrole.get.ComRoleOperationReq;
import kd.bos.permission.model.perm.req.comrole.get.GetComRoleFuncPermReq;
import kd.bos.permission.service.ComRoleService;
import kd.bos.permission.service.CommonService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class ComRoleFuncPermService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(ComRoleFuncPermService.class);

    public static Map<String, Set<ComRoleFuncPerm>> getComRoleFuncPermSetMap(GetComRoleFuncPermReq req) {
        List<QFilter> filterList = ComRoleFuncPermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ComRoleFuncPermService.getComRoleFuncPermSetMap", (String)"perm_rolefuncperm", (String)"id, role_id, role.number, role.name, bizapp_id, bizapp.number, bizapp.name, entity_id, entity.name, permitem_id, permitem.number, permitem.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<String, Set<ComRoleFuncPerm>> map = new HashMap<String, Set<ComRoleFuncPerm>>(8);
            ComRoleFuncPerm one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String roleId = row.getString("role_id");
                String bizapp_id = row.getString("bizapp_id");
                String entity_id = row.getString("entity_id");
                String permitem_id = row.getString("permitem_id");
                one = (ComRoleFuncPerm)PermBuilder.of(ComRoleFuncPerm::new).with(ComRoleFuncPerm::setEntryId, (Object)row.getString("id")).with(ComRoleFuncPerm::setRoleId, (Object)roleId).with(ComRoleFuncPerm::setRoleNumber, (Object)row.getString("role.number")).with(ComRoleFuncPerm::setRoleName, (Object)row.getString("role.name")).with(App::setAppId, (Object)bizapp_id).with(App::setAppNumber, (Object)row.getString("bizapp.number")).with(App::setAppName, (Object)row.getString("bizapp.name")).with(Entity::setEntityNumber, (Object)entity_id).with(Entity::setEntityName, (Object)row.getString("entity.name")).with(PermItem::setPermItemId, (Object)permitem_id).with(PermItem::setPermItemNumber, (Object)row.getString("permitem.number")).with(PermItem::setPermItemName, (Object)row.getString("permitem.name")).build();
                map.computeIfAbsent(roleId, k -> new HashSet(8)).add(one);
            }
            HashMap<String, Set<ComRoleFuncPerm>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<String, ComRoleFuncPerm> getComRoleFuncPermMap(GetComRoleFuncPermReq req) {
        List<QFilter> filterList = ComRoleFuncPermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ComRoleFuncPermService.getComRoleFuncPermMap", (String)"perm_rolefuncperm", (String)"id, role_id, role.number, role.name,  bizapp_id, bizapp.number, bizapp.name, entity_id, entity.name, permitem_id, permitem.number, permitem.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<String, ComRoleFuncPerm> map = new HashMap<String, ComRoleFuncPerm>(8);
            ComRoleFuncPerm one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                String role_id = row.getString("role_id");
                String bizapp_id = row.getString("bizapp_id");
                String entity_id = row.getString("entity_id");
                String permitem_id = row.getString("permitem_id");
                if (uniqueStrFilter && !uniqueStrSet.contains(role_id + "|" + bizapp_id + "|" + entity_id + "|" + permitem_id)) continue;
                one = (ComRoleFuncPerm)PermBuilder.of(ComRoleFuncPerm::new).with(ComRoleFuncPerm::setEntryId, (Object)id).with(ComRoleFuncPerm::setRoleId, (Object)role_id).with(ComRoleFuncPerm::setRoleNumber, (Object)row.getString("role.number")).with(ComRoleFuncPerm::setRoleName, (Object)row.getString("role.name")).with(App::setAppId, (Object)bizapp_id).with(App::setAppNumber, (Object)row.getString("bizapp.number")).with(App::setAppName, (Object)row.getString("bizapp.name")).with(Entity::setEntityNumber, (Object)entity_id).with(Entity::setEntityName, (Object)row.getString("entity.name")).with(PermItem::setPermItemId, (Object)permitem_id).with(PermItem::setPermItemNumber, (Object)row.getString("permitem.number")).with(PermItem::setPermItemName, (Object)row.getString("permitem.name")).build();
                map.put(id, one);
            }
            HashMap<String, ComRoleFuncPerm> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetComRoleFuncPermReq req) {
        Map permItemMap;
        Set collect;
        Set permItemNumSet;
        Set permItemIdSet;
        Set entNumSet;
        Map appMap;
        Set collect2;
        Set appNumSet;
        Set appIdSet;
        Map comRoleMap;
        Set collect3;
        Set comRoleNumSet;
        Set roleIdSet;
        if (null == req) {
            req = new GetComRoleFuncPermReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", (Object)mainIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(roleIdSet = req.getComRoleIdSet()))) {
            filterList.add(new QFilter("role", "in", (Object)roleIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(comRoleNumSet = req.getComRoleNumSet())) && !CollectionUtils.isEmpty(collect3 = (comRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)comRoleNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(ComRole::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("role", "in", collect3));
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdSet = req.getAppIdSet()))) {
            filterList.add(new QFilter("bizapp", "in", (Object)appIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(appNumSet = req.getAppNumSet())) && !CollectionUtils.isEmpty(collect2 = (appMap = AppHelper.getAppMap((Set)appNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(App::getAppId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("bizapp", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(entNumSet = req.getEntNumSet()))) {
            filterList.add(new QFilter("entity", "in", (Object)entNumSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemIdSet = req.getPermItemIdSet()))) {
            filterList.add(new QFilter("permitem", "in", (Object)permItemIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemNumSet = req.getPermItemNumSet())) && !CollectionUtils.isEmpty(collect = (permItemMap = PermItemHelper.getPermItemMap((Set)permItemNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(PermItem::getPermItemId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("permitem", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            ComRoleOperationReq req = (ComRoleOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<String, Set<ComRoleFuncPerm>> afterDataMap = ComRoleFuncPermService.getComRoleFuncPermSetMap(new GetComRoleFuncPermReq(mainIdSet, null, null, null, null, null, null, null, null));
            Set<String> roleIdSet = afterDataMap.keySet();
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<String, Map<String, Object>> saveDiffMap = new HashMap<String, Map<String, Object>>(8);
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFuncPerm>>>(){}));
            }
            for (String roleId : roleIdSet) {
                Set pre = null == preDataMap.get(roleId) ? new HashSet(0) : (Set)preDataMap.get(roleId);
                Set<Object> after = null == afterDataMap.get(roleId) ? new HashSet(0) : afterDataMap.get(roleId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (CollectionUtils.isEmpty((Collection)del) && CollectionUtils.isEmpty((Collection)add)) continue;
                String roleIdStr = String.valueOf(roleId);
                saveDiffMap.computeIfAbsent(roleIdStr, k -> new HashMap()).put("delPermItem", del);
                saveDiffMap.computeIfAbsent(roleIdStr, k -> new HashMap()).put("addPermItem", add);
            }
            ComRoleFuncPermService.dealRolePerm(roleIdSet);
            this.syncLic(saveDiffMap);
            ComRoleService.saveOrDel((ComRoleOperationReq)PermBuilder.of(ComRoleOperationReq::new).with(PermOperationReq::setMainIdSet, roleIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(ComRoleOperationReq::setPreComRoleBaseMap, (Object)req.getPreComRoleBaseMap()).build());
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private void syncLic(Map<String, Map<String, Object>> saveDiffMap) {
        if (null == saveDiffMap || saveDiffMap.isEmpty()) {
            return;
        }
        Set<String> roleIdSet = saveDiffMap.keySet();
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        Map enableUserIdMap = PermRoleHelper.getEnableUserIdMap(roleIdSet);
        for (String roleId : roleIdSet) {
            Set addPermItemSet;
            Object addPermItem;
            Map<String, Object> mapObj;
            Set userIdSet = (Set)enableUserIdMap.get(roleId);
            if (null == userIdSet || userIdSet.isEmpty() || null == (mapObj = saveDiffMap.get(roleId)) || mapObj.isEmpty() || null == (addPermItem = mapObj.get("addPermItem")) || null == (addPermItemSet = (Set)addPermItem) || addPermItemSet.isEmpty()) continue;
            HashMap<String, List> appIdEntNumMap = new HashMap<String, List>(addPermItemSet.size());
            for (ComRoleFuncPerm comRoleFuncPerm : addPermItemSet) {
                appIdEntNumMap.computeIfAbsent(comRoleFuncPerm.getAppId(), k -> new ArrayList()).add(comRoleFuncPerm.getEntityNumber());
            }
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(userIdSet), appIdEntNumMap);
        }
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            Set<String> roleIdSet;
            ComRoleOperationReq req = (ComRoleOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFuncPerm>>>(){}));
            }
            if (null == (roleIdSet = preDataMap.keySet()) || roleIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<String, Set<ComRoleFuncPerm>> afterDataMap = ComRoleFuncPermService.getComRoleFuncPermSetMap(new GetComRoleFuncPermReq(null, roleIdSet, null, null, null, null, null, null, null));
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (String roleId : roleIdSet) {
                Set<Object> after;
                Set pre = null == preDataMap.get(roleId) ? new HashSet(0) : (Set)preDataMap.get(roleId);
                Sets.SetView del = Sets.difference(pre, after = null == afterDataMap.get(roleId) ? new HashSet(0) : afterDataMap.get(roleId));
                if (CollectionUtils.isEmpty((Collection)del)) continue;
                String roleIdStr = String.valueOf(roleId);
                saveDiffMap.computeIfAbsent(roleIdStr, k -> new HashMap()).put("delPermItem", del);
            }
            ComRoleFuncPermService.dealRolePerm(roleIdSet);
            ComRoleService.saveOrDel((ComRoleOperationReq)PermBuilder.of(ComRoleOperationReq::new).with(PermOperationReq::setMainIdSet, roleIdSet).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(ComRoleOperationReq::setPreComRoleBaseMap, (Object)req.getPreComRoleBaseMap()).build());
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{this.getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private static void dealRolePerm(Set<String> roleIdSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        Map<String, String> roleId_rolepermIdMap = ComRoleFuncPermService.getRoleIdRolepermIdMap(roleIdSet, "t_perm_roleperm");
        Map<String, String> roleId_rolepermIdMap_detail = ComRoleFuncPermService.getRoleIdRolepermIdMap(roleIdSet, "t_perm_rolepermdetial");
        Map<String, Integer> rolepermCountMap = ComRoleFuncPermService.getRoleIdDetailCountMap(roleIdSet, "t_perm_roleperm");
        Map<String, Integer> rolepermCountMap_detail = ComRoleFuncPermService.getRoleIdDetailCountMap(roleIdSet, "t_perm_rolepermdetial");
        Date curTime = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        HashSet<String> delRolePermByRoleId = new HashSet<String>(8);
        ArrayList<Object[]> insertRolePermParamList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> updateRolePermParamList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> updateRolePermDetailParamList = new ArrayList<Object[]>(10);
        for (String roleId : roleIdSet) {
            String rolepermId;
            boolean rolepermIsEmpty;
            Integer rolepermDetailCount = rolepermCountMap_detail.get(roleId);
            boolean rolepermDetailIsEmpty = null == rolepermDetailCount || 0 == rolepermDetailCount;
            Integer rolepermCount = rolepermCountMap.get(roleId);
            boolean bl = rolepermIsEmpty = null == rolepermCount || 0 == rolepermCount;
            if (rolepermDetailIsEmpty && rolepermIsEmpty) continue;
            if (!rolepermDetailIsEmpty && rolepermIsEmpty) {
                rolepermId = roleId_rolepermIdMap_detail.get(roleId);
                if (StringUtils.isEmpty((String)rolepermId)) {
                    rolepermId = DB.genStringId((String)"t_perm_roleperm");
                }
                insertRolePermParamList.add(new Object[]{rolepermId, roleId, curTime, currUserId, curTime, currUserId, "C", "1", " ", rolepermId});
                updateRolePermDetailParamList.add(new Object[]{rolepermId, roleId});
                continue;
            }
            if (rolepermDetailIsEmpty && !rolepermIsEmpty) {
                delRolePermByRoleId.add(roleId);
                continue;
            }
            if (rolepermDetailIsEmpty || rolepermIsEmpty) continue;
            rolepermId = roleId_rolepermIdMap.get(roleId);
            String rolepermId_detail = roleId_rolepermIdMap_detail.get(roleId);
            if (StringUtils.isEmpty((String)rolepermId) && StringUtils.isEmpty((String)rolepermId_detail)) {
                String newRolepermId = DB.genStringId((String)"t_perm_roleperm");
                updateRolePermParamList.add(new Object[]{newRolepermId, roleId});
                updateRolePermDetailParamList.add(new Object[]{newRolepermId, roleId});
                continue;
            }
            if (StringUtils.isNotEmpty((String)rolepermId) && StringUtils.isEmpty((String)rolepermId_detail)) {
                updateRolePermDetailParamList.add(new Object[]{rolepermId, roleId});
                continue;
            }
            if (StringUtils.isEmpty((String)rolepermId) && StringUtils.isNotEmpty((String)rolepermId_detail)) {
                updateRolePermParamList.add(new Object[]{rolepermId_detail, roleId});
                updateRolePermDetailParamList.add(new Object[]{rolepermId_detail, roleId});
                continue;
            }
            if (!StringUtils.isNotEmpty((String)rolepermId) || !StringUtils.isNotEmpty((String)rolepermId_detail)) continue;
            if (!Objects.equals(rolepermId, rolepermId_detail)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\uff08%1$s\uff09\u5b58\u5728\u591a\u6761\u529f\u80fd\u6743\u9650\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u590d\u6570\u636e\u3002", (String)"ComRoleFuncPermService_0", (String)"bos-mservice-permission", (Object[])new Object[0]), roleId));
            }
            updateRolePermDetailParamList.add(new Object[]{rolepermId, roleId});
        }
        if (CollectionUtils.isNotEmpty(updateRolePermDetailParamList)) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"update t_perm_rolepermdetial set fid = ? where froleid = ?", updateRolePermDetailParamList);
        }
        if (CollectionUtils.isNotEmpty(updateRolePermParamList)) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"update t_perm_roleperm set fid = ? where froleid = ?", updateRolePermParamList);
        }
        if (CollectionUtils.isNotEmpty(insertRolePermParamList)) {
            String sql = "INSERT INTO t_perm_roleperm (fid, froleid, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fnumber, fmasterid) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, insertRolePermParamList);
        }
        if (CollectionUtils.isNotEmpty(delRolePermByRoleId)) {
            DeleteServiceHelper.delete((String)"perm_roleperm", (QFilter[])new QFilter[]{new QFilter("roleid", "in", delRolePermByRoleId)});
        }
    }

    private static Map<String, String> getRoleIdRolepermIdMap(Set<String> roleIdSet, String tableName) {
        String inStr;
        ArrayList paramList = new ArrayList(6);
        StringBuilder sb = new StringBuilder();
        sb.append("select froleid, fid ");
        sb.append(" from ").append(tableName);
        sb.append(" where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(roleIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and froleid in (").append(inStr).append(") ");
        }
        final HashMap map = new HashMap(8);
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String fid = rs.getString("fid");
                    if (StringUtils.isEmpty((String)fid)) continue;
                    map.computeIfAbsent(froleid, k -> new HashSet(8)).add(fid);
                    Set set = (Set)map.get(froleid);
                    if (set.size() <= 1) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\uff08%1$s\uff09\u5b58\u5728\u591a\u6761\u529f\u80fd\u6743\u9650\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u590d\u6570\u636e\u3002", (String)"ComRoleFuncPermService_0", (String)"bos-mservice-permission", (Object[])new Object[0]), froleid));
                }
                return null;
            }
        });
        if (null == map || map.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> roleId_rolepermIdMap = new HashMap<String, String>(8);
        for (Map.Entry mm : map.entrySet()) {
            String roleId = (String)mm.getKey();
            Set fidSet = (Set)mm.getValue();
            if (StringUtils.isEmpty((String)roleId) || null == fidSet || fidSet.isEmpty()) continue;
            roleId_rolepermIdMap.put(roleId, (String)fidSet.stream().findFirst().get());
        }
        return roleId_rolepermIdMap;
    }

    private static Map<String, Integer> getRoleIdDetailCountMap(Set<String> roleIdSet, String tableName) {
        String inStr;
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Integer>(0);
        }
        ArrayList paramList = new ArrayList(6);
        StringBuilder sb = new StringBuilder();
        sb.append("select froleid, count(*) num ");
        sb.append(" from ").append(tableName);
        sb.append(" where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(roleIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and froleid in (").append(inStr).append(") ");
        }
        sb.append(" group by froleid ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, Integer>>(){

            public Map<String, Integer> handle(ResultSet rs) throws Exception {
                HashMap<String, Integer> map = new HashMap<String, Integer>(8);
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    Integer num = rs.getInt("num");
                    map.put(froleid, num);
                }
                return map;
            }
        });
    }
}

