/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.permctrltype;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.api.ext.IPermCtrlTypeExt;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.req.permctrltype.GetDimTypeIdReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.resp.permctrltype.GetDimTypeIdResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BosOrgPermCtrlTypeExt
implements IPermCtrlTypeExt {
    private static final Log log = LogFactory.getLog(BosOrgPermCtrlTypeExt.class);

    public Set<String> getExtIdentitySet() {
        return Sets.newHashSet((Object[])new String[]{"bos_org"});
    }

    public GetHasPermPermCtrlObjResp getAdminHasPermPermCtrlObj(GetHasPermPermCtrlObjReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            Map fieldFlagMap = IsoDimHelper.getFieldFlagMap((String)reqExtIdentity, (Set)Sets.newHashSet((Object[])new String[]{"id", "number", "name"}));
            String idFlag = (String)fieldFlagMap.get("id");
            String numberFlag = (String)fieldFlagMap.get("number");
            String nameFlag = (String)fieldFlagMap.get("name");
            if (StringUtils.isEmpty((String)idFlag) || StringUtils.isEmpty((String)numberFlag)) {
                throw new KDBizException("BosOrgPermCtrlTypeExt.getAdminHasPermPermCtrlObj, ent:[" + reqExtIdentity + "], has no id or numberFlag field.");
            }
            Long adminUserId = req.getAdminUserId();
            if (null == adminUserId || Objects.equals(0L, adminUserId)) {
                throw new KDBizException("BosOrgPermCtrlTypeExt.getAdminHasPermPermCtrlObj, ent:[" + reqExtIdentity + "], adminUserId is null.");
            }
            HasPermOrgResult hasPermDimResult = ((AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null)).getAdminChargeOrgAndBizUnit(adminUserId);
            HashSet hasPermOrgs = new HashSet(hasPermDimResult.getHasPermOrgs());
            boolean hasAllOrgPerm = hasPermDimResult.hasAllOrgPerm();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            Set reqDimIdSet = req.getDimIdSet();
            if (hasAllOrgPerm) {
                if (CollectionUtils.isNotEmpty((Collection)reqDimIdSet) && CollectionUtils.isNotEmpty(hasPermOrgs)) {
                    qFilterList.add(new QFilter(idFlag, "in", (Object)Sets.intersection((Set)reqDimIdSet, hasPermOrgs)));
                } else if (CollectionUtils.isNotEmpty((Collection)reqDimIdSet) && CollectionUtils.isEmpty(hasPermOrgs)) {
                    qFilterList.add(new QFilter(idFlag, "in", (Object)reqDimIdSet));
                } else if (CollectionUtils.isEmpty((Collection)reqDimIdSet) && CollectionUtils.isNotEmpty(hasPermOrgs)) {
                    qFilterList.add(new QFilter(idFlag, "in", hasPermOrgs));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)reqDimIdSet) && CollectionUtils.isNotEmpty(hasPermOrgs)) {
                qFilterList.add(new QFilter(idFlag, "in", (Object)Sets.intersection((Set)reqDimIdSet, hasPermOrgs)));
            } else if (CollectionUtils.isNotEmpty((Collection)reqDimIdSet) && CollectionUtils.isEmpty(hasPermOrgs)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermOrgs));
            } else if (CollectionUtils.isEmpty((Collection)reqDimIdSet) && CollectionUtils.isNotEmpty(hasPermOrgs)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermOrgs));
            } else if (CollectionUtils.isEmpty((Collection)reqDimIdSet) && CollectionUtils.isEmpty(hasPermOrgs)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermOrgs));
            }
            Set reqDimNumSet = req.getDimNumSet();
            if (null != reqDimNumSet && !reqDimNumSet.isEmpty()) {
                qFilterList.add(new QFilter(numberFlag, "in", (Object)reqDimNumSet));
            }
            HashSet<Dim> hasPermDimSet = new HashSet<Dim>(8);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BosOrgPermCtrlTypeExt.getAdminHasPermPermCtrlObj", (String)reqExtIdentity, (String)(idFlag + "," + numberFlag + "," + nameFlag), (QFilter[])qFilterList.toArray(qFilterList.toArray(new QFilter[qFilterList.size()])), (String)"");){
                Dim dim = null;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    dim = new Dim(reqExtIdentity, row.getLong(idFlag), row.getString(numberFlag), null);
                    dim.setDimName(row.getString(nameFlag));
                    hasPermDimSet.add(dim);
                }
            }
            return new GetHasPermPermCtrlObjResp(hasAllOrgPerm, hasPermDimSet);
        }
        catch (Exception e) {
            log.warn("BosOrgPermCtrlTypeExt.getAdminHasPermPermCtrlObj error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public GetHasPermUserResp getAdminHasPermUser(GetHasPermUserReq req) {
        try {
            String reqExtIdentity = req.getExtIdentity();
            Map fieldFlagMap = IsoDimHelper.getFieldFlagMap((String)reqExtIdentity, (Set)Sets.newHashSet((Object[])new String[]{"id", "number", "name"}));
            String idFlag = (String)fieldFlagMap.get("id");
            String numberFlag = (String)fieldFlagMap.get("number");
            String nameFlag = (String)fieldFlagMap.get("name");
            if (StringUtils.isEmpty((String)idFlag) || StringUtils.isEmpty((String)numberFlag)) {
                throw new KDBizException("BosOrgPermCtrlTypeExt.getAdminHasPermUser, ent:[" + reqExtIdentity + "], has no id or numberFlag field.");
            }
            Long adminUserId = req.getAdminUserId();
            if (null == adminUserId || Objects.equals(0L, adminUserId)) {
                throw new KDBizException("BosOrgPermCtrlTypeExt.getAdminHasPermUser, ent:[" + reqExtIdentity + "], adminUserId is null.");
            }
            boolean mustQueryAll = req.isMustQueryAll();
            UserScopeResult adminChargeUser = ((AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null)).getAdminChargeUser(adminUserId, mustQueryAll);
            HashSet hasPermUserIds = new HashSet(adminChargeUser.getUserIDs());
            boolean isAllUser = adminChargeUser.isAllUser();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            Set reqUserIdSet = req.getUserIdSet();
            if (isAllUser) {
                if (!mustQueryAll) {
                    return new GetHasPermUserResp(isAllUser, new HashSet(0));
                }
                if (CollectionUtils.isNotEmpty((Collection)reqUserIdSet) && CollectionUtils.isNotEmpty(hasPermUserIds)) {
                    qFilterList.add(new QFilter(idFlag, "in", (Object)Sets.intersection((Set)reqUserIdSet, hasPermUserIds)));
                } else if (CollectionUtils.isNotEmpty((Collection)reqUserIdSet) && CollectionUtils.isEmpty(hasPermUserIds)) {
                    qFilterList.add(new QFilter(idFlag, "in", (Object)reqUserIdSet));
                } else if (CollectionUtils.isEmpty((Collection)reqUserIdSet) && CollectionUtils.isNotEmpty(hasPermUserIds)) {
                    qFilterList.add(new QFilter(idFlag, "in", hasPermUserIds));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)reqUserIdSet) && CollectionUtils.isNotEmpty(hasPermUserIds)) {
                qFilterList.add(new QFilter(idFlag, "in", (Object)Sets.intersection((Set)reqUserIdSet, hasPermUserIds)));
            } else if (CollectionUtils.isNotEmpty((Collection)reqUserIdSet) && CollectionUtils.isEmpty(hasPermUserIds)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermUserIds));
            } else if (CollectionUtils.isEmpty((Collection)reqUserIdSet) && CollectionUtils.isNotEmpty(hasPermUserIds)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermUserIds));
            } else if (CollectionUtils.isEmpty((Collection)reqUserIdSet) && CollectionUtils.isEmpty(hasPermUserIds)) {
                qFilterList.add(new QFilter(idFlag, "in", hasPermUserIds));
            }
            Set reqUserNumSet = req.getUserNumSet();
            if (null != reqUserNumSet && !reqUserNumSet.isEmpty()) {
                qFilterList.add(new QFilter(numberFlag, "in", (Object)reqUserNumSet));
            }
            HashSet<PermUser> hasPermUserSet = new HashSet<PermUser>(8);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BosOrgPermCtrlTypeExt.getAdminHasPermUser", (String)"bos_user", (String)(idFlag + "," + numberFlag + "," + nameFlag), (QFilter[])qFilterList.toArray(qFilterList.toArray(new QFilter[qFilterList.size()])), (String)"");){
                PermUser one = null;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    one = new PermUser(row.getLong(idFlag), row.getString(numberFlag), row.getString(nameFlag));
                    hasPermUserSet.add(one);
                }
            }
            return new GetHasPermUserResp(isAllUser, hasPermUserSet);
        }
        catch (Exception e) {
            log.warn("BosOrgPermCtrlTypeExt.getAdminHasPermUser error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public GetDimTypeIdResp getDimTypeId(GetDimTypeIdReq req) {
        try {
            HashSet<String> dimTypeIdSet = new HashSet<String>(8);
            Set dimTypeSet = req.getDimTypeSet();
            if (null != dimTypeSet && !dimTypeSet.isEmpty()) {
                for (String type : dimTypeSet) {
                    String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)type);
                    if (null == suitableDimType || suitableDimType.length < 3) continue;
                    dimTypeIdSet.add(suitableDimType[2]);
                }
            } else {
                dimTypeIdSet.add("DIM_ORG");
            }
            return new GetDimTypeIdResp(dimTypeIdSet);
        }
        catch (Exception e) {
            log.warn("BosOrgPermCtrlTypeExt.getDimTypeId error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

