/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.scheme;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.model.perm.SchemeDataProcessingResult;
import kd.bos.permission.service.scheme.EncryptSchemeService;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.threads.ThreadPools;

public class DefEncryptSchemeServiceImpl
implements EncryptSchemeService {
    private static final Log LOG = LogFactory.getLog(DefEncryptSchemeServiceImpl.class);
    private static ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"DefEncryptSchemeServicePool", (int)1, (int)1000);

    @Override
    public String getPublicKey() {
        return SchemeUtil.getPublicKey();
    }

    @Override
    public String getSchemeKey(EncryptionScheme scheme) {
        String publicKey = this.getPublicKey();
        JSONObject schemeKeyResult = SchemeUtil.getSchemeKey(scheme, publicKey);
        boolean isSuccess = schemeKeyResult.getBoolean("success");
        if (!isSuccess) {
            String description = schemeKeyResult.getString("description");
            LOG.error(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u83b7\u53d6SchemeKey\u5931\u8d25\uff0c \u539f\u56e0\uff1a%1$s", (String)"DefEncryptSchemeServiceImpl_5", (String)"bos-mservice-permission", (Object[])new Object[0]), description));
            return "";
        }
        String schemeKey = schemeKeyResult.getString("data");
        if (StringUtils.isBlank((CharSequence)schemeKey)) {
            LOG.error(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u83b7\u53d6SchemeKey\u5931\u8d25\uff0c \u539f\u56e0\uff1aSchemeKey\u4e3a\u7a7a\u3002", (String)"DefEncryptSchemeServiceImpl_6", (String)"bos-mservice-permission", (Object[])new Object[0]));
            return "";
        }
        return schemeKey;
    }

    @Override
    public String getWorkKey(long schemeId, String schemeKey) {
        String publicKey = this.getPublicKey();
        return SchemeUtil.getWorkKey(schemeId, publicKey, schemeKey);
    }

    @Override
    public SchemeDataProcessingResult dataProcessing(Map<String, List<PrivacyDataModel>> bizData, boolean isEncrypt) {
        SchemeDataProcessingResult result = new SchemeDataProcessingResult();
        if (bizData == null || bizData.isEmpty()) {
            SchemeUtil.success(result, ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e3a\u7a7a", (String)"DefEncryptSchemeServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]), bizData);
            return result;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(bizData.size());
        for (Map.Entry<String, List<PrivacyDataModel>> entry : bizData.entrySet()) {
            long schemeId = Long.parseLong(entry.getKey());
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                EncryptionScheme scheme = this.getEncryptionScheme(schemeId);
                String algorithm = scheme.getAlgorithm();
                int length = scheme.getLength();
                String workKey = this.getWorkKey(schemeId, scheme.getSchemeKey());
                List data = (List)entry.getValue();
                SchemeUtil.dataProcessing(workKey, algorithm, length, data, isEncrypt);
            }, EXECUTOR_SERVICE);
            futures.add(future);
        }
        String tag = isEncrypt ? ResManager.loadKDString((String)"\u52a0\u5bc6", (String)"DefEncryptSchemeServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u89e3\u5bc6", (String)"DefEncryptSchemeServiceImpl_2", (String)"bos-mservice-permission", (Object[])new Object[0]);
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)allFutures.whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("EncryptionSchemeDataProcessing error", ex);
                SchemeUtil.error(result, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"DefEncryptSchemeServiceImpl_3", (String)"bos-mservice-permission", (Object[])new Object[0]), tag));
            } else {
                SchemeUtil.success(result, tag + ResManager.loadKDString((String)"\u6210\u529f", (String)"DefEncryptSchemeServiceImpl_4", (String)"bos-mservice-permission", (Object[])new Object[0]), bizData);
            }
        })).join();
        return result;
    }
}

