/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.scheme;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.model.perm.SchemeDataProcessingResult;
import kd.bos.permission.util.SchemeUtil;

public interface EncryptSchemeService {
    public String getPublicKey();

    public String getSchemeKey(EncryptionScheme var1);

    public String getWorkKey(long var1, String var3);

    public SchemeDataProcessingResult dataProcessing(Map<String, List<PrivacyDataModel>> var1, boolean var2);

    default public JSONObject decrypt(long schemeId, String bizData) {
        try {
            EncryptionScheme scheme = this.getEncryptionScheme(schemeId);
            String algorithm = scheme.getAlgorithm();
            int length = scheme.getLength();
            String workKey = this.getWorkKey(schemeId, scheme.getSchemeKey());
            return this.decrypt(workKey, algorithm, length, bizData);
        }
        catch (Exception ex) {
            JSONObject result = new JSONObject();
            SchemeUtil.error(result, ex.getMessage());
            return result;
        }
    }

    default public JSONObject decrypt(String workKey, String algorithm, int length, String bizData) {
        return SchemeUtil.dataProcessing(workKey, algorithm, length, bizData, false);
    }

    default public JSONObject encrypt(long schemeId, String bizData) {
        try {
            EncryptionScheme scheme = this.getEncryptionScheme(schemeId);
            String algorithm = scheme.getAlgorithm();
            int length = scheme.getLength();
            String workKey = this.getWorkKey(schemeId, scheme.getSchemeKey());
            return this.encrypt(workKey, algorithm, length, bizData);
        }
        catch (Exception ex) {
            JSONObject result = new JSONObject();
            SchemeUtil.error(result, ex.getMessage());
            return result;
        }
    }

    default public JSONObject encrypt(String workKey, String algorithm, int length, String bizData) {
        return SchemeUtil.dataProcessing(workKey, algorithm, length, bizData, true);
    }

    default public EncryptionScheme getEncryptionScheme(long schemeId) {
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme(schemeId);
        if (scheme == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u52a0\u5bc6\u65b9\u6848\"%s\"", (String)"EncryptSchemeService_0", (String)"bos-mservice-permission", (Object[])new Object[0]), schemeId));
        }
        String schemeKey = scheme.getSchemeKey();
        if (StringUtils.isBlank((CharSequence)schemeKey)) {
            schemeKey = this.getSchemeKey(scheme);
            if (StringUtils.isBlank((CharSequence)schemeKey)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u83b7\u53d6SchemeKey\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"EncryptSchemeService_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
            }
            SchemeUtil.updateSchemeKey(schemeId, schemeKey);
            SchemeUtil.updateSchemeCache(String.valueOf(schemeId), scheme.getNumber(), schemeKey);
        }
        return scheme;
    }
}

