/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.service.admingroup.AdmGrpFunpermService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class AdminPermService {
    private static final Log logger = LogFactory.getLog(AdminPermService.class);

    public static boolean checkAdminPerm(Long adminId, String appId, String entityNum, String permItemId) {
        boolean isBindingPerm;
        appId = PermCommonUtil.getCheckPermAppId((String)appId, (String)entityNum);
        if (!PermissionServiceHelper.isAdminUser((long)adminId)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)permItemId) && !(isBindingPerm = PermCommonUtil.hasBindingFunctionPerm((String)entityNum, (String)permItemId))) {
            return true;
        }
        try {
            String appNum = AppMetadataCache.getAppNumberById((String)appId);
            if (appNum == null) {
                return false;
            }
            AppInfo appInfo = AppHelper.getMetaAppInfo((String)appNum);
            if (appInfo == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (!PermCommonUtil.isInSysCloud((String)appId) && !PermCommonUtil.isAdminDomainApp((String)appId)) {
            return false;
        }
        return AdminPermService.checkAdminPermItem(adminId, appId, entityNum, permItemId);
    }

    public static void checkAdminPermItems(Long adminId, String appId, String entityNum, Set<String> permItemSet, Map<String, Boolean> permItemIdHasRightMap) {
        if ("perm_admin_edit".equals(entityNum)) {
            return;
        }
        boolean isBinding = PermCommonUtil.hasBindingFunctionPerm((String)entityNum);
        if (!isBinding) {
            return;
        }
        AdminType adminType = PermissionServiceHelper.getAdminType((long)adminId);
        if (!PermCommonUtil.hasEnableOldAdmin()) {
            String adminInfoStr = CacheMrg.getCache((String)CacheMrg.getType4AdminGroupUser(), (String)(adminId + ""));
            if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                if (null == adminGroupIds || adminGroupIds.isEmpty()) {
                    return;
                }
                AdmGrpHasPermResp virtualAdminPerm = AdminSchemeHelper.getVirtualAdminPerm((AdminType)adminType, (boolean)true);
                boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
                Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper((Set)adminGroupIds, (boolean)true);
                Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
                for (Long adminGroupId : adminGroupIds) {
                    AdminPermService.checkAdminGroupHasPermItems(adminGroupId, appId, entityNum, permItemSet, virtualAdminPerm, admGroupMap, superAdminStrategy, permItemIdHasRightMap);
                }
            }
        } else {
            Set hasPermItemIds = AdminSchemeHelper.batchCheckVirtualAdminPerm((AdminType)adminType, (String)appId, (String)entityNum, permItemSet);
            for (String permItemId : hasPermItemIds) {
                permItemIdHasRightMap.put(permItemId, Boolean.TRUE);
            }
            permItemSet.removeAll(hasPermItemIds);
        }
    }

    private static void checkAdminGroupHasPermItems(Long adminGroupId, String appId, String entityNum, Set<String> permItemIdSet, AdmGrpHasPermResp virtualAdminPerm, Map<Long, AdmGroup> admGroupMap, boolean superAdminStrategy, Map<String, Boolean> permItemIdHasRightMap) {
        if (!PermCommonUtil.isInSysCloud((String)appId) && !PermCommonUtil.isAdminDomainApp((String)appId)) {
            return;
        }
        DynamicObject curAdmGrpDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
        AdmGrpHasPermResp admGrpHasPerm = AdmGrpFunpermService.getAssignedAdmGrpHasPerm(curAdmGrpDyn, virtualAdminPerm, admGroupMap, null);
        Set funpermSet = admGrpHasPerm.getFunpermSet();
        boolean hasAllFunperm = admGrpHasPerm.isHasAllFunperm();
        if (superAdminStrategy) {
            if (PermCommonUtil.isInSysCloud((String)appId)) {
                if (hasAllFunperm) {
                    for (String permItemId : permItemIdSet) {
                        permItemIdHasRightMap.put(permItemId, Boolean.TRUE);
                    }
                    permItemIdSet.clear();
                    return;
                }
                if (null != funpermSet && !funpermSet.isEmpty()) {
                    for (AdmGrpFunperm one : funpermSet) {
                        String permItemId = one.getPermItemId();
                        if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !permItemIdSet.contains(permItemId)) continue;
                        permItemIdHasRightMap.put(permItemId, Boolean.TRUE);
                        permItemIdSet.remove(permItemId);
                    }
                }
                return;
            }
            if (PermCommonUtil.isAdminDomainApp((String)appId) && null != funpermSet && !funpermSet.isEmpty()) {
                for (AdmGrpFunperm one : funpermSet) {
                    String permItemId = one.getPermItemId();
                    if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !permItemIdSet.contains(permItemId)) continue;
                    permItemIdHasRightMap.put(permItemId, Boolean.TRUE);
                    permItemIdSet.remove(permItemId);
                }
            }
            return;
        }
        if (null != funpermSet && !funpermSet.isEmpty()) {
            for (AdmGrpFunperm one : funpermSet) {
                String permItemId = one.getPermItemId();
                if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !permItemIdSet.contains(permItemId)) continue;
                permItemIdHasRightMap.put(permItemId, Boolean.TRUE);
                permItemIdSet.remove(permItemId);
            }
        }
    }

    public static boolean checkAdminPermItem(Long adminId, String appId, String entityNum, String permItemId) {
        if ("perm_admin_edit".equals(entityNum)) {
            return true;
        }
        boolean isBinding = PermCommonUtil.hasBindingFunctionPerm((String)entityNum);
        if (!isBinding) {
            return true;
        }
        AdminType adminType = PermissionServiceHelper.getAdminType((long)adminId);
        if (!PermCommonUtil.hasEnableOldAdmin()) {
            String adminInfoStr = CacheMrg.getCache((String)CacheMrg.getType4AdminGroupUser(), (String)(adminId + ""));
            if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                if (null == adminGroupIds || adminGroupIds.isEmpty()) {
                    return false;
                }
                AdmGrpHasPermResp virtualAdminPerm = AdminSchemeHelper.getVirtualAdminPerm((AdminType)adminType, (boolean)true);
                boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
                Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper((Set)adminGroupIds, (boolean)true);
                Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
                for (Long adminGroupId : adminGroupIds) {
                    Boolean adminGroupHasPermItem = AdminPermService.checkAdminGroupHasPermItem(adminGroupId, appId, entityNum, permItemId, virtualAdminPerm, admGroupMap, superAdminStrategy);
                    if (!Boolean.TRUE.equals(adminGroupHasPermItem)) continue;
                    return adminGroupHasPermItem;
                }
            }
        } else {
            HashSet permItemSet = StringUtils.isEmpty((String)permItemId) ? new HashSet(1) : new HashSet<String>(Collections.singletonList(permItemId));
            return AdminSchemeHelper.checkVirtualAdminPerm((AdminType)adminType, (String)appId, (String)entityNum, permItemSet);
        }
        return false;
    }

    private static Boolean checkAdminGroupHasPermItem(Long adminGroupId, String appId, String entityNum, String permItemId, AdmGrpHasPermResp virtualAdminPerm, Map<Long, AdmGroup> admGroupMap, boolean superAdminStrategy) {
        if (!PermCommonUtil.isInSysCloud((String)appId) && !PermCommonUtil.isAdminDomainApp((String)appId)) {
            return Boolean.FALSE;
        }
        DynamicObject curAdmGrpDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
        AdmGrpHasPermResp admGrpHasPerm = AdmGrpFunpermService.getAssignedAdmGrpHasPerm(curAdmGrpDyn, virtualAdminPerm, admGroupMap, null);
        Set funpermSet = admGrpHasPerm.getFunpermSet();
        boolean hasAllFunperm = admGrpHasPerm.isHasAllFunperm();
        if (superAdminStrategy) {
            if (PermCommonUtil.isInSysCloud((String)appId)) {
                if (hasAllFunperm) {
                    return Boolean.TRUE;
                }
                if (null != funpermSet && !funpermSet.isEmpty()) {
                    for (AdmGrpFunperm one : funpermSet) {
                        if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !Objects.equals(permItemId, one.getPermItemId())) continue;
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }
            if (PermCommonUtil.isAdminDomainApp((String)appId) && null != funpermSet && !funpermSet.isEmpty()) {
                for (AdmGrpFunperm one : funpermSet) {
                    if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !Objects.equals(permItemId, one.getPermItemId())) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        if (null != funpermSet && !funpermSet.isEmpty()) {
            for (AdmGrpFunperm one : funpermSet) {
                if (!Objects.equals(appId, one.getAppId()) || !Objects.equals(entityNum, one.getEntNum()) || !Objects.equals(permItemId, one.getPermItemId())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

