/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.user;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.CommRoleFunPermService;
import kd.bos.permission.cache.UserAppPermService;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.MenuHelper;
import kd.bos.permission.cache.util.AdminUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.service.admingroup.AdmGrpFunpermService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UserMenuService {
    private static final Log logger = LogFactory.getLog(UserMenuService.class);
    private static final ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_UserMenuService", (int)10);

    public static List<String> getCache(Long pUserID, String pAppId) {
        String userMenuJson = CacheMrg.getCache((String)CacheMrg.getType4UserMenu(), (String)(pUserID + "_" + pAppId));
        if ("DATA_LOADED".equals(userMenuJson)) {
            return new ArrayList<String>(1);
        }
        if (StringUtils.isEmpty((String)userMenuJson)) {
            ArrayList<String> resultList = new ArrayList<String>(8);
            int queryRemainExpireTime = UserAppPermService.getAppCacheExp((long)pUserID);
            int remainExpireTime = 0 == queryRemainExpireTime ? CacheMrg.getExpireTime() : queryRemainExpireTime;
            Map<String, Set<String>> userNoPermMenuByBatchApp = UserMenuService.getUserNoPermMenuByBatchApp(pUserID, Sets.newHashSet((Object[])new String[]{pAppId}));
            if (null == userNoPermMenuByBatchApp || userNoPermMenuByBatchApp.isEmpty()) {
                UserMenuService.putCache(pUserID, pAppId, resultList, remainExpireTime);
                return resultList;
            }
            Set<String> menuIdSet = userNoPermMenuByBatchApp.get(pAppId);
            if (null == menuIdSet || menuIdSet.isEmpty()) {
                UserMenuService.putCache(pUserID, pAppId, resultList, remainExpireTime);
                return resultList;
            }
            resultList = new ArrayList<String>(menuIdSet);
            UserMenuService.putCache(pUserID, pAppId, resultList, remainExpireTime);
            return resultList;
        }
        return (List)SerializationUtils.fromJsonString((String)userMenuJson, List.class);
    }

    public static void putCache(Long userId, String appId, List<String> menuIds, int remainExpireTime) {
        CacheMrg.putCache((String)CacheMrg.getType4UserMenu(), (String)(userId + "_" + appId), (String)(CollectionUtils.isEmpty(menuIds) ? "DATA_LOADED" : SerializationUtils.toJsonString(menuIds)), (int)remainExpireTime);
    }

    public static Map<String, Set<String>> getUserNoPermMenuByBatchApp(Long userId, Set<String> appIdSet) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        try {
            Map existCacheMap;
            Sets.SetView needQueryAppIdSet;
            Map existCacheMap2;
            if (null == userId || null == appIdSet || appIdSet.isEmpty()) {
                return map;
            }
            appIdSet.removeIf(appId -> StringUtils.isEmpty((String)appId));
            if (null == appIdSet || appIdSet.isEmpty()) {
                return map;
            }
            String type4UserMenu = CacheMrg.getType4UserMenu();
            String cacheKey = String.valueOf(userId);
            String userMenuJson = UserMenuService.getCachedUserMenuJson(type4UserMenu, cacheKey);
            Set<Object> cachedAppIdSet = new HashSet(8);
            if (StringUtils.isNotEmpty((String)userMenuJson) && null != (existCacheMap2 = (Map)new ObjectMapper().readValue(userMenuJson, (TypeReference)new TypeReference<HashMap<String, Set<String>>>(){})) && !existCacheMap2.isEmpty()) {
                cachedAppIdSet = existCacheMap2.keySet();
                for (Map.Entry mm : existCacheMap2.entrySet()) {
                    map.put((String)mm.getKey(), (Set<String>)mm.getValue());
                }
            }
            if (CollectionUtils.isEmpty((Collection)(needQueryAppIdSet = Sets.difference(appIdSet, cachedAppIdSet)))) {
                return map;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            boolean enableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
            paramMap.put("enableOldAdmin", enableOldAdmin);
            String type4Admin = enableOldAdmin ? CacheMrg.getType4AdminUserOld() : CacheMrg.getType4AdminGroupUser();
            paramMap.put("type4Admin", type4Admin);
            String strAdminInfo = CacheMrg.getCache((String)type4Admin, (String)String.valueOf(userId));
            paramMap.put("strAdminInfo", strAdminInfo);
            String type4HasEnableOldAdmin = CacheMrg.getType4HasEnableOldAdmin();
            paramMap.put("type4HasEnableOldAdmin", type4HasEnableOldAdmin);
            AdminType adminType = AdminUserCache.getAdminTypeWithParaMap((String)Long.toString(userId), paramMap);
            paramMap.put("adminType", adminType);
            PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            boolean isAdminUser = permService.isAdminUserWithParaMap(userId.longValue(), "", paramMap);
            paramMap.put("isAdminUser", isAdminUser);
            boolean isAdmintype = permService.isAdminUserWithParaMap(userId.longValue(), AdminType.Administrator, paramMap);
            paramMap.put("isAdmintype", isAdmintype);
            boolean isSuperAdmin = permService.isAdminUserWithParaMap(userId.longValue(), "10", paramMap);
            paramMap.put("isSuperAdmin", isSuperAdmin);
            boolean isCosmic = PermCommonUtil.isCosmicUser((Long)userId);
            paramMap.put("isCosmic", isCosmic);
            boolean isSuperUser = PermCommonUtil.isSuperUser((long)userId);
            paramMap.put("isSuperUser", isSuperUser);
            List checkPermAllUserAppIdList = PermCommonUtil.getCheckPermAllUserAppIdList();
            paramMap.put("checkPermAllUserAppIdList", checkPermAllUserAppIdList);
            DynamicObject adminScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_adminscheme", (String)"id,entryentity.admintype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
            long adminSchemeId = adminScheme.getLong("id");
            boolean isSuperAdminStrategy = adminSchemeId == PermHelperConst.SUPERADMIN_STRATEGY_ID;
            paramMap.put("isSuperAdminStrategy", isSuperAdminStrategy);
            DynamicObjectCollection adminTypes = adminScheme.getDynamicObjectCollection("entryentity");
            boolean onlyOneAdmin = adminTypes.size() == 1;
            paramMap.put("onlyOneAdmin", onlyOneAdmin);
            boolean allowAdminBizOperate = AdminUtil.isAllowAdminBizOperate();
            paramMap.put("allowAdminBizOperate", allowAdminBizOperate);
            List allUserAppIds = PermCommonUtil.getAllUserAppIds();
            paramMap.put("allUserAppIds", allUserAppIds);
            boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
            paramMap.put("isSingleBizRole", isSingleBizRole);
            Map appIdMenuRuntimeListMap = MenuHelper.getAppIdMenuRuntimeListMap((Set)needQueryAppIdSet);
            paramMap.put("appIdMenuRuntimeListMap", appIdMenuRuntimeListMap);
            Map<String, Set<String>> userAppEntPermItemStrSetMap = UserMenuService.getUserAppEntPermItemStrSet(userId, isSingleBizRole);
            Set<String> userAppEntPermItemStrSet = isSingleBizRole ? userAppEntPermItemStrSetMap.get("singleBizRoleUserAppntPermItemStrSet") : userAppEntPermItemStrSetMap.get("notSingleBizRoleUserAppntPermItemStrSet");
            paramMap.put("userAppEntPermItemStrSet", userAppEntPermItemStrSet);
            Map allUserAppIdEntNumMap = PermCommonUtil.getCheckPermAllUserAppEntMap();
            paramMap.put("allUserAppIdEntNumMap", allUserAppIdEntNumMap);
            paramMap.put("userId", userId);
            Map extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet(1));
            paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
            HashMap perm_formEntityNumMap = new HashMap(8);
            paramMap.put("perm_formEntityNumMap", perm_formEntityNumMap);
            int queryRemainExpireTime = UserAppPermService.getAppCacheExp((long)userId);
            int minTime = 0 == queryRemainExpireTime ? CacheMrg.getExpireTime() : queryRemainExpireTime;
            String userMenuJsonAgain = UserMenuService.getCachedUserMenuJson(type4UserMenu, cacheKey);
            if (StringUtils.isNotEmpty((String)userMenuJsonAgain) && null != (existCacheMap = (Map)new ObjectMapper().readValue(userMenuJsonAgain, (TypeReference)new TypeReference<HashMap<String, Set<String>>>(){})) && !existCacheMap.isEmpty()) {
                Set againCachedAppIdSet = existCacheMap.keySet();
                for (Map.Entry mm : existCacheMap.entrySet()) {
                    map.put((String)mm.getKey(), (Set<String>)mm.getValue());
                }
                needQueryAppIdSet = Sets.difference((Set)needQueryAppIdSet, againCachedAppIdSet);
            }
            if (CollectionUtils.isEmpty((Collection)needQueryAppIdSet)) {
                return map;
            }
            for (String appId2 : needQueryAppIdSet) {
                paramMap.put("appId", appId2);
                Object[] results = UserMenuService.loadIntoCacheBatch(paramMap);
                List menuIds = (List)results[0];
                HashSet menuIdSet = new HashSet(menuIds);
                map.put(appId2, menuIdSet);
            }
            CacheMrg.putCache((String)type4UserMenu, (String)cacheKey, (String)SerializationUtils.toJsonString(map), (int)minTime);
            return map;
        }
        catch (Exception e) {
            logger.warn("UserMenuCache.getUserNoPermMenuByBatchApp error, userId:{}, appIdSet:{}", new Object[]{userId, JSON.toJSONString(appIdSet), e});
            for (String appId3 : appIdSet) {
                map.put(appId3, new HashSet(1));
            }
            return map;
        }
    }

    private static Object[] loadIntoCacheBatch(Map<String, Object> paramMap) {
        boolean isCosmic;
        List checkPermAllUserAppIdList;
        Long userId = (Long)paramMap.get("userId");
        String appId = (String)paramMap.get("appId");
        AppInfo appInfo = null;
        String cloudId = null;
        List menuList = null;
        try {
            appInfo = AppHelper.getMetaAppInfo((String)appId);
            cloudId = appInfo.getCloudId();
            Map appIdMenuRuntimeListMap = (Map)paramMap.get("appIdMenuRuntimeListMap");
            menuList = (List)appIdMenuRuntimeListMap.get(appId);
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u5e94\u7528\u53ca\u5176\u83dc\u5355\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return new Object[]{new ArrayList(0), null};
        }
        if (menuList == null || menuList.isEmpty()) {
            return new Object[]{new ArrayList(0), null};
        }
        int menuListSize = menuList.size();
        ArrayList<String> noPermMenuIds = new ArrayList<String>(menuListSize);
        boolean isSuperAdminStrategy = (Boolean)paramMap.get("isSuperAdminStrategy");
        boolean onlyOneAdmin = (Boolean)paramMap.get("onlyOneAdmin");
        boolean isSuperAdmin = (Boolean)paramMap.get("isSuperAdmin");
        if ("83bfebc8000037ac".equals(appId) && (!isSuperAdmin || isSuperAdminStrategy || onlyOneAdmin)) {
            noPermMenuIds.add("1376969428704443392");
        }
        if ("0XWTKVOQW+ML".equals(appId) && (!isSuperAdmin || isSuperAdminStrategy || onlyOneAdmin)) {
            noPermMenuIds.add("1707868004299057152");
        }
        boolean allowAdminBizOperate = (Boolean)paramMap.get("allowAdminBizOperate");
        if (isSuperAdmin && !allowAdminBizOperate && !cloudId.equals("83bfebc800000bac") && !cloudId.equals("0QLCSO6KKZC9")) {
            for (AppMenuInfo menuInfo : menuList) {
                noPermMenuIds.add(menuInfo.getId());
            }
            Long administratorUserId = 1L;
            if (userId.equals(administratorUserId) && cloudId.equals("83bfebc8000008ac")) {
                noPermMenuIds.remove("1716859565947162624");
            }
            return new Object[]{noPermMenuIds, null};
        }
        boolean isAllUserApp = appInfo.isAllUserApp();
        if (isAllUserApp && (CollectionUtils.isEmpty((Collection)(checkPermAllUserAppIdList = (List)paramMap.get("checkPermAllUserAppIdList"))) || !checkPermAllUserAppIdList.contains(appId))) {
            return new Object[]{noPermMenuIds, null};
        }
        List<String> adminNoPermMenuIds = null;
        boolean isAdminUser = (Boolean)paramMap.get("isAdminUser");
        if (isAdminUser && (PermCommonUtil.isInSysCloud((String)appId) || PermCommonUtil.isAdminDomainApp((String)appId))) {
            adminNoPermMenuIds = UserMenuService.getAdminNoPermMenuIds(userId, appId, paramMap);
            if (adminNoPermMenuIds != null && !adminNoPermMenuIds.isEmpty()) {
                noPermMenuIds.addAll(adminNoPermMenuIds);
            }
            if (isSuperAdmin && !allowAdminBizOperate) {
                UserMenuService.computeSeniorMenu(appId, menuList, noPermMenuIds);
                return new Object[]{noPermMenuIds, null};
            }
            noPermMenuIds.removeAll(adminNoPermMenuIds);
        }
        ArrayList<String> cosmicMenus = new ArrayList<String>(8);
        cosmicMenus.add("0Z=XT1146SQH");
        cosmicMenus.add("0Z=YK8U6WG1=");
        cosmicMenus.add("0Z=YKU9=29GP");
        if (!isSuperAdminStrategy && !onlyOneAdmin) {
            cosmicMenus.add("1723414273201329152");
        }
        ArrayList<String> oldCosmicMenus = new ArrayList<String>(8);
        oldCosmicMenus.add("/SLXJ2Z=GE0J");
        oldCosmicMenus.add("/SLXK+KV6J9S");
        oldCosmicMenus.add("/SLXLT9=3VCC");
        if (!isSuperAdminStrategy && !onlyOneAdmin) {
            oldCosmicMenus.add("1376833233034946560");
        }
        if (isCosmic = ((Boolean)paramMap.get("isCosmic")).booleanValue()) {
            for (AppMenuInfo appMenuInfo : menuList) {
                String menuId = appMenuInfo.getId();
                if (cosmicMenus.contains(menuId)) continue;
                noPermMenuIds.add(menuId);
            }
            return new Object[]{noPermMenuIds, null};
        }
        if ("0XWTKVOQW+ML".equals(appId)) {
            noPermMenuIds.addAll(cosmicMenus);
        } else if ("83bfebc8000037ac".equals(appId)) {
            noPermMenuIds.addAll(oldCosmicMenus);
        }
        List<String> superUserDisMenuList = UserMenuService.getSuperUserDisMenuList(userId, appId, menuList, adminNoPermMenuIds, paramMap);
        if ("0XWTKVOQW+ML".equals(appId)) {
            superUserDisMenuList.addAll(cosmicMenus);
            superUserDisMenuList.add("1707868004299057152");
        } else if ("83bfebc8000037ac".equals(appId)) {
            superUserDisMenuList.addAll(oldCosmicMenus);
            superUserDisMenuList.add("1376969428704443392");
        }
        boolean isSuperUser = (Boolean)paramMap.get("isSuperUser");
        if (isSuperUser) {
            UserMenuService.computeSeniorMenu(appId, menuList, superUserDisMenuList);
            return new Object[]{superUserDisMenuList, null};
        }
        List<String> adminDisMenuList = UserMenuService.adminDisMenuList(userId, menuList, paramMap);
        List allMenuFormNums = PermCommonUtil.getFormNumFromMenuMeta((List)menuList);
        Map menu_formEntityNumMap = PermCommonUtil.getEntityNumsByFormNums((List)allMenuFormNums);
        paramMap.put("menu_formEntityNumMap", menu_formEntityNumMap);
        HashMap entityPermItemMap = new HashMap();
        List hasBindingPermEntNums = PermCommonUtil.getHasBindPermFormNums((List)allMenuFormNums, entityPermItemMap, paramMap);
        Map checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMap3New((String)appId, (List)hasBindingPermEntNums, paramMap);
        ArrayList<Object[]> menuAppEntityPermList = new ArrayList<Object[]>(64);
        HashSet<String> needCheckPermMenuId = new HashSet<String>(8);
        for (AppMenuInfo appMenuInfo : menuList) {
            Set bindingPermItemIds;
            String menuId = appMenuInfo.getId();
            String formNum = appMenuInfo.getFormId();
            if (StringUtils.isEmpty((String)formNum)) continue;
            String entityNum = (String)menu_formEntityNumMap.get(formNum);
            if (entityNum == null || StringUtils.isEmpty((String)entityNum)) {
                logger.warn(String.format(ResManager.loadKDString((String)"\u8868\u5355%1$s\u627e\u4e0d\u5230\u5bf9\u5e94\u5b9e\u4f53", (String)"UserMenuCache_0", (String)"bos-permission-cache", (Object[])new Object[0]), formNum));
                continue;
            }
            if (!hasBindingPermEntNums.contains(entityNum)) continue;
            String permItemId = appMenuInfo.getPermission();
            String parameterType = appMenuInfo.getParamType();
            if (StringUtils.isEmpty((String)permItemId)) {
                permItemId = "ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? "47150e89000000ac" : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? "47156aff000000ac" : "47150e89000000ac");
            }
            if ((bindingPermItemIds = (Set)entityPermItemMap.get(entityNum)) != null && !bindingPermItemIds.isEmpty() && bindingPermItemIds.contains(permItemId)) {
                needCheckPermMenuId.add(menuId);
            }
            Object[] menuAppEntityPermObj = new Object[]{menuId, checkPermEntityAppMap.get(entityNum), entityNum, permItemId};
            menuAppEntityPermList.add(menuAppEntityPermObj);
        }
        HashSet<String> hasPermMenuIdsInCheckPermAllUserApp = new HashSet<String>(16);
        List allUserAppIds = (List)paramMap.get("allUserAppIds");
        Map allUserAppIdEntNumMap = (Map)paramMap.get("allUserAppIdEntNumMap");
        Iterator iterator = menuAppEntityPermList.iterator();
        while (iterator.hasNext()) {
            List checkPermEntityNums;
            Object[] menuAppEntityPermObj = (Object[])iterator.next();
            String menuId = (String)menuAppEntityPermObj[0];
            String checkPermAppId = (String)menuAppEntityPermObj[1];
            String menuEntityNum = (String)menuAppEntityPermObj[2];
            if (StringUtils.isEmpty((String)checkPermAppId) || !allUserAppIds.contains(checkPermAppId) || CollectionUtils.isEmpty((Collection)(checkPermEntityNums = (List)allUserAppIdEntNumMap.get(checkPermAppId))) || checkPermEntityNums.contains(menuEntityNum)) continue;
            hasPermMenuIdsInCheckPermAllUserApp.add(menuId);
            iterator.remove();
        }
        Set userAppEntPermItemStrSet = (Set)paramMap.get("userAppEntPermItemStrSet");
        Set<String> finalHasPermMenuSet = UserMenuService.getFinalHasPermMenuSet(menuAppEntityPermList, hasPermMenuIdsInCheckPermAllUserApp, userAppEntPermItemStrSet);
        needCheckPermMenuId.removeAll(finalHasPermMenuSet);
        if (adminNoPermMenuIds != null) {
            int adminNoPermMenuIdsSize = adminNoPermMenuIds.size();
            if (adminNoPermMenuIdsSize > 0) {
                ArrayList<String> interSectResult = new ArrayList<String>(adminNoPermMenuIdsSize);
                for (String adminNoPermMenuId : adminNoPermMenuIds) {
                    if (!needCheckPermMenuId.contains(adminNoPermMenuId)) continue;
                    interSectResult.add(adminNoPermMenuId);
                }
                noPermMenuIds = interSectResult;
            }
        } else {
            noPermMenuIds.addAll(needCheckPermMenuId);
        }
        noPermMenuIds.addAll(adminDisMenuList);
        noPermMenuIds.addAll(superUserDisMenuList);
        if ("0XWTKVOQW+ML".equals(appId) && isSuperAdmin && !isSuperAdminStrategy && !onlyOneAdmin) {
            noPermMenuIds.remove("1707868004299057152");
        }
        if ("83bfebc8000037ac".equals(appId) && isSuperAdmin && !isSuperAdminStrategy && !onlyOneAdmin) {
            noPermMenuIds.remove("1376969428704443392");
        }
        UserMenuService.computeSeniorMenu(appId, menuList, noPermMenuIds);
        return new Object[]{noPermMenuIds, null};
    }

    private static Set<String> getFinalHasPermMenuSet(List<Object[]> menuAppEntityPermList, Set<String> hasPermMenuIdsInCheckPermAllUserApp, Set<String> userAppEntPermItemStrSet) {
        HashSet<String> menuSet = new HashSet<String>(8);
        for (int i = 0; i < menuAppEntityPermList.size(); ++i) {
            Object[] objects = menuAppEntityPermList.get(i);
            String app = String.valueOf(objects[1]);
            String ent = String.valueOf(objects[2]);
            String perm = String.valueOf(objects[3]);
            if (!userAppEntPermItemStrSet.contains(app + ent + perm)) continue;
            menuSet.add(String.valueOf(objects[0]));
        }
        menuSet.addAll(hasPermMenuIdsInCheckPermAllUserApp);
        return menuSet;
    }

    private static List<String> adminDisMenuList(Long userId, List<AppMenuInfo> menuList, Map<String, Object> paramMap) {
        ArrayList<String> noPermMenuIds = new ArrayList<String>();
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean isAdminType = null == paramMap || null == paramMap.get("isAdmintype") ? permService.isAdminUserWithParaMap(userId.longValue(), AdminType.Administrator, paramMap) : ((Boolean)paramMap.get("isAdmintype")).booleanValue();
        boolean isSuperAdminType = null == paramMap || null == paramMap.get("isSuperAdmin") ? permService.isAdminUserWithParaMap(userId.longValue(), "10", paramMap) : ((Boolean)paramMap.get("isSuperAdmin")).booleanValue();
        for (AppMenuInfo appMenuInfo : menuList) {
            String isSuperAdminApp;
            String tenantId;
            String isVisible;
            String formNum = appMenuInfo.getFormId();
            if (StringUtils.isEmpty((String)formNum)) continue;
            String menuId = appMenuInfo.getId();
            String parmName = appMenuInfo.getParams();
            String formId = appMenuInfo.getFormId();
            if (!StringUtils.isNotEmpty((String)parmName)) continue;
            Map parmInfo = (Map)SerializationUtils.fromJsonString((String)parmName, Map.class);
            String isAdminApp = (String)parmInfo.get("administratorOnlyUse");
            if ("true".equals(isAdminApp) && !isAdminType) {
                String adminAppId = appMenuInfo.getId();
                noPermMenuIds.add(adminAppId);
            }
            if ("bd_ksql_query_function".equals(formId) && (isVisible = System.getProperty((tenantId = RequestContext.get().getTenantId()) + "_queryAnalyzer")) != null && !"true".equalsIgnoreCase(isVisible) && !isSuperAdminType) {
                noPermMenuIds.add(menuId);
            }
            if (!"true".equals(isSuperAdminApp = (String)parmInfo.get("superAdminOnlyUse")) || isSuperAdminType && isAdminType) continue;
            noPermMenuIds.add(menuId);
        }
        return noPermMenuIds;
    }

    private static List<String> getSuperUserDisMenuList(Long userId, String appId, List<AppMenuInfo> menuList, List<String> adminNoPermMenuIds, Map<String, Object> paramMap) {
        List queryAllSysApp;
        boolean isadmintype = false;
        isadmintype = null == paramMap || paramMap.isEmpty() || null == paramMap.get("isAdmintype") ? PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator) : (Boolean)paramMap.get("isAdmintype");
        ArrayList<String> noPermMenuIds = new ArrayList<String>();
        for (AppMenuInfo appMenuInfo : menuList) {
            String tenantId;
            String isVisible;
            String formNum = appMenuInfo.getFormId();
            if (StringUtils.isEmpty((String)formNum)) continue;
            String menuId = appMenuInfo.getId();
            String parmName = appMenuInfo.getParams();
            String formId = appMenuInfo.getFormId();
            if (!StringUtils.isNotEmpty((String)parmName)) continue;
            Map parmInfo = (Map)SerializationUtils.fromJsonString((String)parmName, Map.class);
            String isAdminMenu = (String)parmInfo.get("administratorOnlyUseExcSuperUser");
            if ("true".equals(isAdminMenu) && !isadmintype) {
                noPermMenuIds.add(menuId);
            }
            if (!"bd_ksql_query_function".equals(formId) || (isVisible = System.getProperty((tenantId = RequestContext.get().getTenantId()) + "_queryAnalyzer")) == null || "true".equalsIgnoreCase(isVisible)) continue;
            noPermMenuIds.add(menuId);
        }
        boolean enableSysAuthority = PermCommonUtil.isEnableSysAuthority();
        if (!enableSysAuthority && (queryAllSysApp = AdminSchemeHelper.queryAllSysApp((boolean)false, (boolean)false, (boolean)true)) != null && queryAllSysApp.contains(appId)) {
            noPermMenuIds.addAll(adminNoPermMenuIds);
        }
        return noPermMenuIds;
    }

    private static void computeSeniorMenu(String appId, List<AppMenuInfo> menuList, List<String> noPermMenuIds) {
        HashMap<String, List> menuMap = new HashMap<String, List>(menuList.size());
        HashMap<String, String> menuNodeMap = new HashMap<String, String>(menuList.size());
        for (AppMenuInfo appMenuInfo : menuList) {
            String id = appMenuInfo.getId();
            String parentId = appMenuInfo.getParentId();
            if (StringUtils.isEmpty((String)parentId) || parentId.equals(appId)) continue;
            menuMap.computeIfAbsent(parentId, k -> new ArrayList()).add(id);
            menuNodeMap.put(id, parentId);
        }
        if (menuMap.size() > 0) {
            for (Map.Entry entry : menuMap.entrySet()) {
                String menuId = (String)entry.getKey();
                List menuIdList = (List)entry.getValue();
                Iterator iterator = menuIdList.iterator();
                while (iterator.hasNext()) {
                    String childMenuId = (String)iterator.next();
                    if (!noPermMenuIds.contains(childMenuId)) continue;
                    iterator.remove();
                }
                if (!menuIdList.isEmpty()) continue;
                noPermMenuIds.add(menuId);
                String parentId = (String)menuNodeMap.get(menuId);
                if (StringUtils.isEmpty((String)parentId) || (menuIdList = (List)menuMap.get(parentId)) == null || menuIdList.isEmpty()) continue;
                Iterator iterator2 = menuIdList.iterator();
                while (iterator2.hasNext()) {
                    String childMenuId = (String)iterator2.next();
                    if (!noPermMenuIds.contains(childMenuId)) continue;
                    iterator2.remove();
                }
                if (!menuIdList.isEmpty()) continue;
                noPermMenuIds.add(parentId);
            }
        }
    }

    private static String getCachedUserMenuJson(String type4UserMenu, String cacheKey) {
        String threadCacheKey = String.format("%s%s%s%s", "getCachedUserMenuJson_", RequestContext.get().getAccountId(), type4UserMenu, cacheKey);
        Map threadCacheMap = (Map)ThreadCache.get((Object)threadCacheKey, () -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            String userMenuJson = CacheMrg.getCache((String)type4UserMenu, (String)cacheKey);
            if (StringUtils.isEmpty((String)userMenuJson)) {
                map.put("getCachedUserMenuJson", "");
                return map;
            }
            map.put("getCachedUserMenuJson", userMenuJson);
            return map;
        });
        return (String)threadCacheMap.get("getCachedUserMenuJson");
    }

    private static Map<String, Set<String>> getUserAppEntPermItemStrSet(final Long userId, boolean isSingleBizRole) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        HashSet singleBizRoleUserAppntPermItemStrSet = new HashSet(8);
        HashSet notSingleBizRoleUserAppntPermItemStrSet = new HashSet(8);
        map.put("singleBizRoleUserAppntPermItemStrSet", singleBizRoleUserAppntPermItemStrSet);
        map.put("notSingleBizRoleUserAppntPermItemStrSet", notSingleBizRoleUserAppntPermItemStrSet);
        try {
            if (!isSingleBizRole) {
                long start = System.currentTimeMillis();
                Set bizRolePermMenuSet = BizRoleFunPermService.getUserAppEntPermItemStrSet((Long)userId);
                logger.debug("\n{}-\u8017\u65f6\uff0c{}ms", (Object)"bizRolePermMenuSet", (Object)(System.currentTimeMillis() - start));
                Callable<Map<String, Set<String>>> userDirectFunPermMenuSetCallable = new Callable<Map<String, Set<String>>>(){

                    @Override
                    public Map<String, Set<String>> call() throws Exception {
                        return DirectAuthorizeHelper.getUserAppEntPermItemStrMap((Set)Sets.newHashSet((Object[])new Long[]{userId}));
                    }
                };
                Future userDirectFunPermMenuSetFuture = pool.submit((Callable)userDirectFunPermMenuSetCallable, RequestContext.get());
                Callable<Set<String>> comRoleFunPermMenuSetCallable = new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws Exception {
                        return CommRoleFunPermService.getUserAppEntPermItemStrSet((Long)userId);
                    }
                };
                Future comRoleFunPermMenuSetFuture = pool.submit((Callable)comRoleFunPermMenuSetCallable, RequestContext.get());
                Map userDirectFunPermMenuSetMap = (Map)userDirectFunPermMenuSetFuture.get();
                logger.debug("\n{}-\u8017\u65f6\uff0c{}ms", (Object)"userDirectFunPermMenuSetMap", (Object)(System.currentTimeMillis() - start));
                Set userDirectFunPermMenuSet = (Set)userDirectFunPermMenuSetMap.get(String.valueOf(userId));
                userDirectFunPermMenuSet = null == userDirectFunPermMenuSet || userDirectFunPermMenuSet.isEmpty() ? Collections.emptySet() : userDirectFunPermMenuSet;
                notSingleBizRoleUserAppntPermItemStrSet.addAll(userDirectFunPermMenuSet);
                Set comRoleFunPermMenuSet = (Set)comRoleFunPermMenuSetFuture.get();
                logger.debug("\n{}-\u8017\u65f6\uff0c{}ms", (Object)"comRoleFunPermMenuSet", (Object)(System.currentTimeMillis() - start));
                notSingleBizRoleUserAppntPermItemStrSet.addAll(comRoleFunPermMenuSet);
                notSingleBizRoleUserAppntPermItemStrSet.addAll(bizRolePermMenuSet);
                logger.debug("\n{}-\u8017\u65f6\uff0c{}ms", (Object)"notSingleBizRoleUserAppntPermItemStrSet", (Object)(System.currentTimeMillis() - start));
                map.put("notSingleBizRoleUserAppntPermItemStrSet", notSingleBizRoleUserAppntPermItemStrSet);
            } else {
                Set bizRolePermMenuSet = BizRoleFunPermService.getUserAppEntPermItemStrSet((Long)userId);
                singleBizRoleUserAppntPermItemStrSet.addAll(bizRolePermMenuSet);
                map.put("singleBizRoleUserAppntPermItemStrSet", singleBizRoleUserAppntPermItemStrSet);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return map;
    }

    private static List<String> getAdminNoPermMenuIds(Long adminId, String appId, Map<String, Object> paramMap) {
        List menuList;
        boolean enableOldAdmin;
        AdminType adminType;
        boolean isSuperAdminStrategy = false;
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>(8);
        }
        isSuperAdminStrategy = null == paramMap.get("isSuperAdminStrategy") ? PermCommonUtil.isSuperAdminStrategy() : (Boolean)paramMap.get("isSuperAdminStrategy");
        ArrayList<String> noPermMenuIds = new ArrayList<String>(100);
        if (!adminId.equals(10L)) {
            ArrayList<String> cosmicMenus;
            if ("83bfebc8000037ac".equals(appId)) {
                cosmicMenus = new ArrayList<String>(10);
                cosmicMenus.add("/SLXJ2Z=GE0J");
                cosmicMenus.add("/SLXK+KV6J9S");
                cosmicMenus.add("/SLXLT9=3VCC");
                noPermMenuIds.addAll(cosmicMenus);
            } else if ("0XWTKVOQW+ML".equals(appId)) {
                cosmicMenus = new ArrayList(10);
                cosmicMenus.add("0Z=XT1146SQH");
                cosmicMenus.add("0Z=YK8U6WG1=");
                cosmicMenus.add("0Z=YKU9=29GP");
                noPermMenuIds.addAll(cosmicMenus);
            }
        }
        AdminType adminType2 = adminType = null == paramMap.get("adminType") ? PermissionServiceHelper.getAdminType((long)adminId) : (AdminType)paramMap.get("adminType");
        if (adminType == null || adminType == AdminType.NotAdmin) {
            return null;
        }
        String appNum = AppMetadataCache.getAppNumberById((String)appId);
        if (!PermCommonUtil.isInSysCloud((String)appId) && !PermCommonUtil.isAdminDomainApp((String)appId)) {
            return null;
        }
        Set<Object> hasPermEntityNums = new HashSet(10);
        boolean bl = enableOldAdmin = null == paramMap || null == paramMap.get("enableOldAdmin") ? PermCommonUtil.hasEnableOldAdmin(paramMap) : (Boolean)paramMap.get("enableOldAdmin");
        if (!enableOldAdmin) {
            String adminInfoStr = CacheMrg.getCache((String)CacheMrg.getType4AdminGroupUser(), (String)(adminId + ""));
            if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                AdmGrpHasPermResp admGrpHasPermByAdmGrps = AdmGrpFunpermService.getAssignedAdmGrpHasPerm(adminGroupIds);
                boolean hasAllFunperm = admGrpHasPermByAdmGrps.isHasAllFunperm();
                if (hasAllFunperm && isSuperAdminStrategy && PermCommonUtil.isInSysCloud((String)appId)) {
                    List notPublishedMenuId = PermCommonUtil.getNotPublishedMenuIdByAppNum((String)appNum);
                    noPermMenuIds.addAll(notPublishedMenuId);
                    return noPermMenuIds;
                }
                Set funpermSet = admGrpHasPermByAdmGrps.getFunpermSet();
                if (null != funpermSet && !funpermSet.isEmpty()) {
                    for (AdmGrpFunperm funperm : funpermSet) {
                        hasPermEntityNums.add(funperm.getAppId() + funperm.getEntNum() + funperm.getPermItemId());
                    }
                }
            }
        } else {
            if (isSuperAdminStrategy) {
                List notPublishedMenuId = PermCommonUtil.getNotPublishedMenuIdByAppNum((String)appNum);
                noPermMenuIds.addAll(notPublishedMenuId);
                return noPermMenuIds;
            }
            hasPermEntityNums = UserMenuService.getVirtualAdminHasPermEntity(adminType.toString());
        }
        Map appIdMenuRuntimeListMap = null == paramMap.get("appIdMenuRuntimeListMap") ? new HashMap(0) : (Map)paramMap.get("appIdMenuRuntimeListMap");
        List list = menuList = null == appIdMenuRuntimeListMap.get(appNum) ? AppMetadataCache.getAppMenusInfoByAppId((String)appNum) : (List)appIdMenuRuntimeListMap.get(appNum);
        if (menuList == null || menuList.size() == 0) {
            return new ArrayList<String>();
        }
        List allMenuFormNums = PermCommonUtil.getFormNumFromMenuMeta((List)menuList);
        HashMap entityPermItemMap = new HashMap(8);
        List hasBindingPermForms = PermCommonUtil.getHasBindPermFormNums((List)allMenuFormNums, entityPermItemMap, paramMap);
        boolean paramMapIsEmpty = CollectionUtils.isEmpty(paramMap);
        Map checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMapNew((String)appId, (List)hasBindingPermForms, paramMap);
        for (AppMenuInfo appMenuInfo : menuList) {
            String checkPermAppId;
            String checkPermKey;
            Set bindingPermItemIds;
            boolean issuperadmintype;
            String entityNum;
            String formNum = appMenuInfo.getFormId();
            String menuId = appMenuInfo.getId();
            if (StringUtils.isEmpty((String)formNum) || (entityNum = PermCommonUtil.getEntityNumByFormNum((String)formNum)) == null) continue;
            Map paramInfo = new HashMap(16);
            String paramName = appMenuInfo.getParams();
            if (StringUtils.isNotEmpty((String)paramName)) {
                paramInfo = (Map)SerializationUtils.fromJsonString((String)paramName, Map.class);
            }
            String superAdminOnlyUse = (String)paramInfo.get("superAdminOnlyUse");
            String superAdminOnlyUseExcSuperUser = (String)paramInfo.get("superAdminOnlyUseExcSuperUser");
            boolean isadmintype = paramMapIsEmpty ? PermissionServiceHelper.isAdminUser((long)adminId, (AdminType)AdminType.Administrator) : (Boolean)paramMap.get("isAdmintype");
            boolean bl2 = issuperadmintype = paramMapIsEmpty ? PermissionServiceHelper.isAdminUser((long)adminId, (String)"10") : (Boolean)paramMap.get("isSuperAdmin");
            if (!(!"true".equals(superAdminOnlyUse) && !"true".equals(superAdminOnlyUseExcSuperUser) || issuperadmintype && isadmintype)) {
                noPermMenuIds.add(menuId);
            }
            if (!hasBindingPermForms.contains(entityNum)) continue;
            String permItemId = appMenuInfo.getPermission();
            String parameterType = appMenuInfo.getParamType();
            if (StringUtils.isEmpty((String)permItemId)) {
                permItemId = "ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? "47150e89000000ac" : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? "47156aff000000ac" : "47150e89000000ac");
            }
            if (CollectionUtils.isEmpty((Collection)(bindingPermItemIds = (Set)entityPermItemMap.get(entityNum))) || !bindingPermItemIds.contains(permItemId) || hasPermEntityNums.contains(checkPermKey = (checkPermAppId = (String)checkPermEntityAppMap.get(entityNum)) + entityNum + permItemId)) continue;
            noPermMenuIds.add(menuId);
        }
        noPermMenuIds.remove("18XQ/L5XWABD");
        return noPermMenuIds;
    }

    private static Set<String> getEntityAdminHasPermEntity(Long adminGroupId) {
        String sql = " SELECT DISTINCT fappid||fentitynum||fpermitemid as res FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        Set hasPermEntityNums = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> entity = new HashSet<String>(200);
                while (rs.next()) {
                    String entityNum = rs.getString("res");
                    entity.add(entityNum);
                }
                return entity;
            }
        });
        return hasPermEntityNums;
    }

    private static Set<String> getVirtualAdminHasPermEntity(String adminType) {
        String sql = new StringBuffer("select distinct dtl.fbizappid||dtl.fentitynum||dtl.fpermitemid as res from t_perm_adminscheme ads ").append(" inner join t_perm_adminschemeentry ent on (ads.fid = ent.fid) ").append(" inner join t_perm_adminschemedetail dtl on(ent.fentryid = dtl.fentryid) ").append(" where ads.fenable = '1' ").append(" and ent.fadmintype = ? ").toString();
        Set hasPermEntityNums = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{new SqlParameter(":fadmintype", -5, (Object)Long.valueOf(adminType))}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> list = new HashSet<String>(200);
                while (rs.next()) {
                    String res = rs.getString("res");
                    list.add(res);
                }
                return list;
            }
        });
        return hasPermEntityNums;
    }
}

