/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class OrgAddUniqueIndexUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(OrgAddUniqueIndexUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        this.addOrgUniqueIndex();
        this.addStructureUniqueIndex();
        return result;
    }

    private void addOrgUniqueIndex() {
        if (((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FNUMBER FROM T_ORG_ORG GROUP BY FNUMBER HAVING COUNT(FNUMBER) > 1", resultSet -> resultSet.next())).booleanValue()) {
            log.error("\u7ec4\u7ec7\u8868\uff08T_ORG_ORG\uff09\u6dfb\u52a0\u552f\u4e00\u7d22\u5f15\u5931\u8d25\uff1a\u5b58\u5728\u91cd\u590d\u7684\u7f16\u7801\uff08FNUMBER\uff09\uff0c\u9700\u8981\u624b\u5de5\u4fee\u590d\u540e\u624d\u80fd\u52a0\u4e0a\u552f\u4e00\u7d22\u5f15\u3002");
        } else {
            String deleteOldIndexSql = "EXEC p_DropIdx 'IDX_T_ORG_Org_FNumber', 'T_ORG_ORG';";
            this.execute(deleteOldIndexSql);
            String createUniqueIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'UX_T_Org_Org_Number') CREATE UNIQUE INDEX UX_T_Org_Org_Number ON T_ORG_Org (FNUMBER)";
            this.execute(createUniqueIndexSql);
        }
    }

    private void addStructureUniqueIndex() {
        if (((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FORGID FROM T_ORG_STRUCTURE GROUP BY FVIEWID, FORGID HAVING COUNT(FORGID) > 1", resultSet -> resultSet.next())).booleanValue()) {
            log.error("\u7ec4\u7ec7\u7ed3\u6784\u8868\uff08T_ORG_STRUCTURE\uff09\u6dfb\u52a0\u552f\u4e00\u7d22\u5f15\u5931\u8d25\uff1a\u76f8\u540c\u7684\u7ec4\u7ec7\uff08FORGID\uff09\u5b58\u5728\u91cd\u590d\u7684\u89c6\u56fe\u65b9\u6848\uff08FVIEWID\uff09\uff0c\u9700\u8981\u624b\u5de5\u4fee\u590d\u540e\u624d\u80fd\u52a0\u4e0a\u552f\u4e00\u7d22\u5f15\u3002");
        } else {
            String createUniqueIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'UX_ORG_Struc_ViewOrg') CREATE UNIQUE INDEX UX_ORG_Struc_ViewOrg ON T_ORG_Structure (FVIEWID, FORGID)";
            this.execute(createUniqueIndexSql);
        }
    }

    private void execute(String sql) {
        try {
            DB.execute((DBRoute)DBRoute.basedata, (String)sql);
        }
        catch (Exception e) {
            log.error(sql + "\uff1a\u6267\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }
}

