/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.util.AppendPermByAdminUpgradeUtil;
import kd.bos.permission.cache.util.AppendPermByAppEntNumMapAuthorizeUtil;
import kd.bos.permission.cache.util.AppendPermBySureAppEntPermItemUtil;
import kd.bos.permission.cache.util.AppendPermItemAuthByAppUpgradeUtil;
import kd.bos.permission.cache.util.AppendPermItemAuthUpgradeUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.UpgradeRoleDataRuleNewModelUtil;
import kd.bos.permission.enums.EnumsPermUpgradeType;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.upgrade.PermUpgradePreProcessFile;
import kd.bos.permission.model.perm.req.upgrade.PermUpgradePreProcessReq;
import kd.bos.permission.model.perm.req.upgrade.xml.PermUpgradeMetaXml;
import kd.bos.permission.servicehelper.upgrade.AdminPswStrategyUpgradeService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PermUpgradeService {
    private static final Log logger = LogFactory.getLog(PermUpgradeService.class);

    public static PermResult upgradePreProcess(List<PermUpgradePreProcessFile> fileList) {
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }
        for (PermUpgradePreProcessFile ff : fileList) {
            PermUpgradeService.upgradePreProcessForSingleFile(ff);
        }
        return PermResult.ok();
    }

    private static void upgradePreProcessForSingleFile(PermUpgradePreProcessFile ff) {
        String fileName = ff.getFileName();
        String content = ff.getContent();
        if (StringUtils.isBlank((String)content)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0cfileName=%1$s\u3002", (String)"PermUpgradeService_0", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName));
        }
        try {
            JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{PermUpgradeMetaXml.class});
            Unmarshaller unmarshaller = cont.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new ByteArrayInputStream(content.getBytes()));
            Object baseXml = unmarshaller.unmarshal((Node)document);
            if (!(baseXml instanceof PermUpgradeMetaXml)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u672a\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\uff0cfileName=%1$s\u3002", (String)"PermUpgradeService_1", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName));
            }
            PermUpgradeMetaXml permUpgradeMetaXml = (PermUpgradeMetaXml)baseXml;
            String number = permUpgradeMetaXml.getNumber();
            if (!Objects.equals("permUpgradePreProcess", number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u672a\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\uff0cfileName=%1$s\u3002", (String)"PermUpgradeService_1", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName));
            }
            if (!PermUpgradeService.checkModifyVersion(fileName, permUpgradeMetaXml)) {
                return;
            }
            String data = permUpgradeMetaXml.getData();
            if (StringUtils.isEmpty((String)data)) {
                logger.debug("PermUpgradeService.upgradePreProcessForSingleFile, data is empty, number:{}, fileName:{}", (Object)number, (Object)fileName);
                return;
            }
            List reqList = SerializationUtils.fromJsonStringToList((String)data, PermUpgradePreProcessReq.class);
            if (null == reqList || reqList.isEmpty()) {
                logger.debug("PermUpgradeService.upgradePreProcessForSingleFile, reqList is empty, number:{}, fileName:{}", (Object)number, (Object)fileName);
                return;
            }
            for (PermUpgradePreProcessReq req : reqList) {
                PermUpgradeService.upgradePreProcessForSingReq(req, number, fileName);
            }
            Long param_id = permUpgradeMetaXml.getId();
            if (PermUpgradeService.idExists(fileName, param_id)) {
                return;
            }
            long param_modifyVersion = permUpgradeMetaXml.getModifyVersion();
            if (PermUpgradeService.modifyVersionExists(fileName, param_modifyVersion)) {
                return;
            }
            String sql = "insert into t_perm_upgradedetail(fid, fnumber, fmodifyversion, ffilename, fcreatorid, fcreatetime) values(?, ?, ?, ?, ?, ?)";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{permUpgradeMetaXml.getId(), number, permUpgradeMetaXml.getModifyVersion(), fileName, RequestContext.get().getCurrUserId(), new Date()});
        }
        catch (Exception e) {
            logger.error("PermUpgradeService.upgradePreProcessForSingleFile.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static boolean checkModifyVersion(String fileName, PermUpgradeMetaXml permUpgradeMetaXml) {
        Long param_id = permUpgradeMetaXml.getId();
        long param_modifyVersion = permUpgradeMetaXml.getModifyVersion();
        if (null == param_id || Objects.equals(0L, param_modifyVersion)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u975e\u6cd5\u7684id\u6216modifyVersion\uff0cfileName=%1$s\uff0cid=%2$s\uff0cmodifyVersion=%3$s\u3002", (String)"PermUpgradeService_7", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName, param_id, param_modifyVersion));
        }
        if (PermUpgradeService.idExists(fileName, param_id)) {
            return false;
        }
        return !PermUpgradeService.modifyVersionExists(fileName, param_modifyVersion);
    }

    private static boolean modifyVersionExists(String fileName, long param_modifyVersion) {
        try (DataSet ds = DB.queryDataSet((String)"PermUpgradeService.modifyVersionExists", (DBRoute)DBRoute.basedata, (String)"select fid from t_perm_upgradedetail where fmodifyversion = ?", (Object[])new Object[]{param_modifyVersion});){
            if (ds.hasNext()) {
                logger.error(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0cmodifyVersion\u5df2\u5b58\u5728\uff0cfileName=%1$s\uff0cmodifyVersion=%2$s\u3002", (String)"PermUpgradeService_6", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName, param_modifyVersion));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean idExists(String fileName, Long param_id) {
        try (DataSet ds = DB.queryDataSet((String)"PermUpgradeService.idExists", (DBRoute)DBRoute.basedata, (String)"select fid from t_perm_upgradedetail where fid = ?", (Object[])new Object[]{param_id});){
            if (ds.hasNext()) {
                logger.error(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0cid\u5df2\u5b58\u5728\uff0cfileName=%1$s\uff0cid=%2$s\u3002", (String)"PermUpgradeService_5", (String)"bos-mservice-permission", (Object[])new Object[0]), fileName, param_id));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void upgradePreProcessForSingReq(PermUpgradePreProcessReq req, String number, String fileName) throws Exception {
        EnumsPermUpgradeType enumsPermUpgradeType = req.getEnumsPermUpgradeType();
        if (enumsPermUpgradeType.illegal()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u975e\u6cd5\u7684\u6743\u9650\u5347\u7ea7\u7c7b\u578b\u679a\u4e3e\uff0cnumber=%1$s\uff0c fileName=%2$s\u3002", (String)"PermUpgradeService_2", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName));
        }
        String type = enumsPermUpgradeType.getType();
        String handler = enumsPermUpgradeType.getHandler();
        Object obj = TypesContainer.getOrRegisterSingletonInstance((String)handler);
        Map paramMap = req.getParamMap();
        PermUpgradeService.appendPermItem(number, fileName, enumsPermUpgradeType, obj, paramMap);
        if (EnumsPermUpgradeType.COMROLE_DATARULE_MODEL_UPGRADE == enumsPermUpgradeType) {
            if (!(obj instanceof UpgradeRoleDataRuleNewModelUtil)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            PermResult upgrade = UpgradeRoleDataRuleNewModelUtil.upgrade((int)1);
            if (!upgrade.isOk()) {
                throw new KDBizException(upgrade.getMsg());
            }
            return;
        }
        if (EnumsPermUpgradeType.ADMINPWDSCHEME_UPPER == enumsPermUpgradeType) {
            if (!(obj instanceof AdminPswStrategyUpgradeService)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            AdminPswStrategyUpgradeService.upgrade();
            return;
        }
    }

    private static void appendPermItem(String number, String fileName, EnumsPermUpgradeType enumsPermUpgradeType, Object obj, Map<String, Object> paramMap) {
        String type = enumsPermUpgradeType.getType();
        String handler = enumsPermUpgradeType.getHandler();
        if (EnumsPermUpgradeType.APPENDPERMITEM_ENTPERMITEM2ENTPERMITEM == enumsPermUpgradeType) {
            if (!(obj instanceof AppendPermItemAuthUpgradeUtil)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            List<List<Object>> needAppendPermList = PermUpgradeService.appendPermItemSomeCheck(number, fileName, type, paramMap);
            if (null == needAppendPermList) {
                return;
            }
            List list = ListUtil.listListObj2ListObjArr(needAppendPermList);
            AppendPermItemAuthUpgradeUtil.upgrade((List)list, null);
            return;
        }
        if (EnumsPermUpgradeType.APPENDPERMITEM_APP2ORIAPP == enumsPermUpgradeType) {
            if (!(obj instanceof AppendPermItemAuthByAppUpgradeUtil)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            List<List<Object>> needAppendPermList = PermUpgradeService.appendPermItemSomeCheck(number, fileName, type, paramMap);
            if (null == needAppendPermList) {
                return;
            }
            List list = ListUtil.listListObj2ListObjArr(needAppendPermList);
            AppendPermItemAuthByAppUpgradeUtil.upgrade((List)list, null);
            return;
        }
        if (EnumsPermUpgradeType.APPENDPERMITEM_APPENT2APPENT == enumsPermUpgradeType) {
            if (!(obj instanceof AppendPermByAppEntNumMapAuthorizeUtil)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            List<List<Object>> needAppendPermList = PermUpgradeService.appendPermItemSomeCheck(number, fileName, type, paramMap);
            if (null == needAppendPermList) {
                return;
            }
            List list = ListUtil.listListObj2ListObjArr(needAppendPermList);
            AppendPermByAppEntNumMapAuthorizeUtil.upgrade((List)list, null);
            return;
        }
        if (EnumsPermUpgradeType.APPENDPERMITEM_BYADMIN == enumsPermUpgradeType) {
            PermUpgradeService.appendpermitem_byadmin(number, fileName, type, handler, obj, paramMap);
            return;
        }
        if (EnumsPermUpgradeType.APPENDPERMITEM_SUREAPPENTPERMITEM == enumsPermUpgradeType) {
            if (!(obj instanceof AppendPermBySureAppEntPermItemUtil)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
            }
            List<List<Object>> needAppendPermList = PermUpgradeService.appendPermItemSomeCheck(number, fileName, type, paramMap);
            if (null == needAppendPermList) {
                return;
            }
            List list = ListUtil.listListObj2ListObjArr(needAppendPermList);
            AppendPermBySureAppEntPermItemUtil.upgrade((List)list, null);
            return;
        }
    }

    private static List<List<Object>> appendPermItemSomeCheck(String number, String fileName, String type, Map<String, Object> paramMap) {
        if (!paramMap.containsKey("needAppendPermList")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u672a\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\u3002", (String)"PermUpgradeService_3", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type));
        }
        List needAppendPermList = (List)paramMap.get("needAppendPermList");
        if (null == needAppendPermList || needAppendPermList.isEmpty()) {
            return null;
        }
        return needAppendPermList;
    }

    private static void appendpermitem_byadmin(String number, String fileName, String type, String handler, Object obj, Map<String, Object> paramMap) {
        if (!paramMap.containsKey("needAppendPermList") || !paramMap.containsKey("justPreSet3Power")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0c\u672a\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\u3002", (String)"PermUpgradeService_3", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type));
        }
        if (!(obj instanceof AppendPermByAdminUpgradeUtil)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u7684\u5347\u7ea7\u9884\u5904\u7406\uff0chandler\u5339\u914d\u5931\u8d25\uff0cnumber=%1$s\uff0c fileName=%2$s\uff0c enumsPermUpgradeType=%3$s\uff0chandler=%4$s\u3002", (String)"PermUpgradeService_4", (String)"bos-mservice-permission", (Object[])new Object[0]), number, fileName, type, handler));
        }
        List needAppendPermList = (List)paramMap.get("needAppendPermList");
        if (null == needAppendPermList || needAppendPermList.isEmpty()) {
            return;
        }
        boolean justPreSet3Power = (Boolean)paramMap.get("justPreSet3Power");
        if (justPreSet3Power) {
            List list = ListUtil.listListObj2ListObjArr((List)needAppendPermList);
            AppendPermByAdminUpgradeUtil.upgrade((List)list, null);
            return;
        }
        Set fentryIdSet = AdminSchemeHelper.getNotOneBigSchemeEntryIdSet();
        if (null == fentryIdSet || fentryIdSet.isEmpty()) {
            return;
        }
        Long[] threeStrategyEntryIdArr = fentryIdSet.toArray(new Long[fentryIdSet.size()]);
        ArrayList<Object[]> list = new ArrayList<Object[]>(10);
        for (List one : needAppendPermList) {
            if (null == one || one.size() != 3) continue;
            list.add(new Object[]{one.get(0), one.get(1), one.get(2), threeStrategyEntryIdArr});
        }
        AppendPermByAdminUpgradeUtil.upgrade(list, null);
    }

    public static void addOperLog(String procInfo, String opName) {
        AppLogInfo appLogInfo = new AppLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(procInfo);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    protected String printMyStatckTrace(Exception e) {
        StackTraceElement[] stackElements = e.getStackTrace();
        StringBuilder sb = new StringBuilder(e.getMessage());
        if (null != stackElements) {
            for (int i = 0; i < stackElements.length; ++i) {
                sb.append(stackElements[i].getClassName());
                sb.append('.').append(stackElements[i].getMethodName());
                sb.append("(").append(stackElements[i].getFileName()).append(':');
                sb.append(stackElements[i].getLineNumber());
                sb.append(")\n");
            }
        }
        return sb.toString();
    }
}

