/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import java.util.Arrays;
import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.constant.PermApiConst;
import kd.bos.permission.model.PermResult;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PortalPermItemUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PortalPermItemUpgradeService.class);
    private static Long[] adminEntryIds = new Long[]{PermApiConst.THREE_STRATEGY_1_ADMIN_ENTRYID};

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder pProcessInfo = new StringBuilder();
            PermResult permResult = PermissionServiceHelper.appendPermItemAuthUpgrade(this.buildData(), (StringBuilder)pProcessInfo);
            StringBuilder noPermProcessInfo = new StringBuilder();
            PermResult upgradeByAppPermResult = PermissionServiceHelper.appendPermItemAuthByAppUpgrade(this.noPermItemForm(), (StringBuilder)noPermProcessInfo);
            if (permResult.isOk() && upgradeByAppPermResult.isOk()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(String.format("appendPermItemAuthUpgrade info:%s, appendPermItemAuthByAppUpgrade info:%s", pProcessInfo.toString(), upgradeByAppPermResult.toString()));
            }
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
            logger.warn("PortalPermItemUpgradeService error", (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("fail", "PortalPermItemUpgradeService error"), new Object[0]);
        }
        logger.debug("PortalPermItemUpgradeService end");
        return result;
    }

    private List<Object[]> noPermItemForm() {
        String sysLoginConfigForm = "sys_login_config";
        String sysAppId = "18XSXYEL8//U";
        Object[] sysLoginConfigSavePermItem = new Object[]{new String[]{sysAppId}, sysLoginConfigForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] sysLoginConfigSearchPermItem = new Object[]{new String[]{sysAppId}, sysLoginConfigForm, "47150e89000000ac", adminEntryIds};
        String schemeGroupForm = "portal_group_user_rel";
        Object[] schemeGroupAddItem = new Object[]{new String[]{sysAppId}, schemeGroupForm, "0=KX5+RHU1BB", adminEntryIds};
        Object[] schemeGroupDeleteItem = new Object[]{new String[]{sysAppId}, schemeGroupForm, "4715e1f1000000ac", adminEntryIds};
        Object[] schemeGroupSearchItem = new Object[]{new String[]{sysAppId}, schemeGroupForm, "47150e89000000ac", adminEntryIds};
        String onlineForm = "bos_smc_onlineuser_new";
        Object[] onlineExportPermItem = new Object[]{new String[]{sysAppId}, onlineForm, "4730fc9f000004ae", adminEntryIds};
        Object[] onlineLogoutPermItem = new Object[]{new String[]{sysAppId}, onlineForm, "3=7DPH46=MDO", adminEntryIds};
        Object[] onlineSearchPermItem = new Object[]{new String[]{sysAppId}, onlineForm, "47150e89000000ac", adminEntryIds};
        String shortcutsForm = "bos_shortcuts";
        String ctsAppId = "18XR3MJ0W0ET";
        Object[] shortcutsResetPermItem = new Object[]{new String[]{ctsAppId}, shortcutsForm, "3GRUDK+N10A2", adminEntryIds};
        Object[] shortcutsSavePermItem = new Object[]{new String[]{ctsAppId}, shortcutsForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] shortcutsDeletePermItem = new Object[]{new String[]{ctsAppId}, shortcutsForm, "4715e1f1000000ac", adminEntryIds};
        Object[] shortcutsSearchPermItem = new Object[]{new String[]{ctsAppId}, shortcutsForm, "47150e89000000ac", adminEntryIds};
        Object[] shortcutsAddPermItem = new Object[]{new String[]{ctsAppId}, shortcutsForm, "47156aff000000ac", adminEntryIds};
        String userprivacyForm = "userprivacystmt";
        Object[] userprivacySearchPermItem = new Object[]{new String[]{sysAppId}, userprivacyForm, "47150e89000000ac", adminEntryIds};
        String loginLogForm = "bos_login_log_new";
        Object[] loginLogSearchPermItem = new Object[]{new String[]{sysAppId}, loginLogForm, "47150e89000000ac", adminEntryIds};
        List<Object[]> data = Arrays.asList(sysLoginConfigSavePermItem, sysLoginConfigSearchPermItem, schemeGroupAddItem, schemeGroupDeleteItem, schemeGroupSearchItem, onlineExportPermItem, onlineLogoutPermItem, onlineSearchPermItem, shortcutsResetPermItem, shortcutsSavePermItem, shortcutsDeletePermItem, shortcutsSearchPermItem, shortcutsAddPermItem, userprivacySearchPermItem, loginLogSearchPermItem);
        return data;
    }

    private List<Object[]> buildData() {
        String viewPermItem = "47150e89000000ac";
        String contractForm = "contractsubject";
        Object[] applyItem = new Object[]{contractForm, viewPermItem, contractForm, "3GIA8GE7UIG+", adminEntryIds};
        Object[] registerItem = new Object[]{contractForm, viewPermItem, contractForm, "3GLACZBQFKNP", adminEntryIds};
        Object[] authItem = new Object[]{contractForm, viewPermItem, contractForm, "3GLAGM7QG9C0", adminEntryIds};
        Object[] uploadItem = new Object[]{contractForm, viewPermItem, contractForm, "3GLAKU95D0LY", adminEntryIds};
        Object[] sendsmsItem = new Object[]{contractForm, viewPermItem, contractForm, "3GLANI7747Q2", adminEntryIds};
        String bizForm = "companyauth";
        Object[] bizRegisterItem = new Object[]{bizForm, viewPermItem, bizForm, "3GLACZBQFKNP", adminEntryIds};
        Object[] bizAuthItem = new Object[]{bizForm, viewPermItem, bizForm, "3GLAGM7QG9C0", adminEntryIds};
        Object[] bizUploadItem = new Object[]{bizForm, viewPermItem, bizForm, "3GLAKU95D0LY", adminEntryIds};
        Object[] bizSendsmsItem = new Object[]{bizForm, viewPermItem, bizForm, "3GLANI7747Q2", adminEntryIds};
        String schemeForm = "portal_scheme";
        Object[] importItem = new Object[]{schemeForm, viewPermItem, schemeForm, "3GLI6SM83QG6", adminEntryIds};
        Object[] exportItem = new Object[]{schemeForm, viewPermItem, schemeForm, "3GLI5HNK2IVP", adminEntryIds};
        Object[] saveItem = new Object[]{schemeForm, viewPermItem, schemeForm, "0=KX5+QVF5+R", adminEntryIds};
        String themeForm = "bas_uitheme";
        Object[] themeDeleteItem = new Object[]{themeForm, viewPermItem, themeForm, "4715e1f1000000ac", adminEntryIds};
        Object[] themeNewItem = new Object[]{themeForm, viewPermItem, themeForm, "47156aff000000ac", adminEntryIds};
        Object[] themeSaveItem = new Object[]{themeForm, viewPermItem, themeForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] themeModifyItem = new Object[]{themeForm, viewPermItem, themeForm, "4715a0df000000ac", adminEntryIds};
        String privacytplForm = "privacystatementtpl";
        Object[] privacyTplSaveItem = new Object[]{privacytplForm, viewPermItem, privacytplForm, "0=KX5+QVF5+R", adminEntryIds};
        String privacyForm = "privacystatement";
        Object[] privacySaveItem = new Object[]{privacyForm, viewPermItem, privacyForm, "0=KX5+QVF5+R", adminEntryIds};
        String msgnoticeForm = "msg_notice";
        Object[] msgnoticeCopyItem = new Object[]{msgnoticeForm, viewPermItem, msgnoticeForm, "4730fc9f000020ae", adminEntryIds};
        Object[] msgnoticeSaveItem = new Object[]{msgnoticeForm, viewPermItem, msgnoticeForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] msgnoticeDeleteItem = new Object[]{msgnoticeForm, viewPermItem, msgnoticeForm, "4715e1f1000000ac", adminEntryIds};
        String wxgzhForm = "cts_wxgzh";
        Object[] wxgzhSaveItem = new Object[]{wxgzhForm, viewPermItem, wxgzhForm, "0=KX5+QVF5+R", adminEntryIds};
        String weakpswForm = "perm_weakpsw";
        Object[] weakpswSaveItem = new Object[]{weakpswForm, viewPermItem, weakpswForm, "0=KX5+QVF5+R", adminEntryIds};
        String sealtypeForm = "bos_ec_sealtype";
        Object[] sealtypeSaveItem = new Object[]{sealtypeForm, viewPermItem, sealtypeForm, "0=KX5+QVF5+R", adminEntryIds};
        String wxqyhForm = "cts_wxqyh";
        Object[] wxqyhSaveItem = new Object[]{wxqyhForm, viewPermItem, wxqyhForm, "0=KX5+QVF5+R", adminEntryIds};
        String pswstrategyForm = "perm_pswstrategy";
        Object[] pswstrategySaveItem = new Object[]{pswstrategyForm, viewPermItem, pswstrategyForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] pswstrategyDeleteItem = new Object[]{pswstrategyForm, viewPermItem, pswstrategyForm, "4715e1f1000000ac", adminEntryIds};
        Object[] pswstrategyNewItem = new Object[]{pswstrategyForm, viewPermItem, pswstrategyForm, "47156aff000000ac", adminEntryIds};
        Object[] pswstrategyAssignItem = new Object[]{pswstrategyForm, viewPermItem, pswstrategyForm, "3AWKZ4KKP9TQ", adminEntryIds};
        String flybookForm = "cts_fly_book";
        Object[] flybookSaveItem = new Object[]{flybookForm, viewPermItem, flybookForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] flybookDeleteItem = new Object[]{flybookForm, viewPermItem, flybookForm, "4715e1f1000000ac", adminEntryIds};
        Object[] flybookNewItem = new Object[]{flybookForm, viewPermItem, flybookForm, "47156aff000000ac", adminEntryIds};
        String dingdingForm = "cts_dingding";
        Object[] dingdingSaveItem = new Object[]{dingdingForm, viewPermItem, dingdingForm, "0=KX5+QVF5+R", adminEntryIds};
        String welinkForm = "cts_welink";
        Object[] welinkSaveItem = new Object[]{welinkForm, viewPermItem, welinkForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] welinkDeleteItem = new Object[]{welinkForm, viewPermItem, welinkForm, "4715e1f1000000ac", adminEntryIds};
        Object[] welinkNewItem = new Object[]{welinkForm, viewPermItem, welinkForm, "47156aff000000ac", adminEntryIds};
        String proverbsForm = "bos_proverbs";
        Object[] proverbsSavePermItem = new Object[]{proverbsForm, viewPermItem, proverbsForm, "0=KX5+QVF5+R", adminEntryIds};
        Object[] proverbsExportPermItem = new Object[]{proverbsForm, viewPermItem, proverbsForm, "4730fc9f000004ae", adminEntryIds};
        Object[] proverbsImportPermItem = new Object[]{proverbsForm, viewPermItem, proverbsForm, "4730fc9f000003ae", adminEntryIds};
        String logForm = "bos_log_operation";
        String newLogForm = "bos_log_operation_web";
        Object[] logSetPermItem = new Object[]{logForm, viewPermItem, newLogForm, "38F+SLTJ/DCR", adminEntryIds};
        Object[] logSearchPermItem = new Object[]{logForm, viewPermItem, newLogForm, viewPermItem, adminEntryIds};
        List<Object[]> data = Arrays.asList(applyItem, registerItem, authItem, uploadItem, sendsmsItem, bizRegisterItem, bizAuthItem, bizUploadItem, bizSendsmsItem, importItem, exportItem, saveItem, logSetPermItem, logSearchPermItem, themeDeleteItem, themeNewItem, themeSaveItem, themeModifyItem, privacyTplSaveItem, privacySaveItem, msgnoticeCopyItem, msgnoticeSaveItem, msgnoticeDeleteItem, wxgzhSaveItem, weakpswSaveItem, sealtypeSaveItem, wxqyhSaveItem, pswstrategySaveItem, pswstrategyDeleteItem, pswstrategyNewItem, pswstrategyAssignItem, flybookSaveItem, flybookDeleteItem, flybookNewItem, dingdingSaveItem, welinkSaveItem, welinkDeleteItem, welinkNewItem, proverbsSavePermItem, proverbsExportPermItem, proverbsImportPermItem);
        return data;
    }
}

