/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;

public class UserAvatarUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(UserAvatarUpgradeService.class);
    private static final int BATCH_SIZE = 500;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.debug("UserAvatarUpgradeService.start");
        UpgradeResult result = new UpgradeResult();
        try {
            DynamicObject[] userDatas;
            String imageServerUrl = UrlService.getImageFullUrl((String)"");
            if (imageServerUrl.endsWith("/")) {
                imageServerUrl = imageServerUrl.substring(0, imageServerUrl.length() - 1);
            }
            logger.debug("imageServerUrl: " + imageServerUrl);
            QFilter filter = new QFilter("picturefield", "like", (Object)("%" + imageServerUrl + "%"));
            while ((userDatas = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, picturefield", (QFilter[])new QFilter[]{filter}, (String)"id asc", (int)500)) != null && userDatas.length != 0) {
                for (DynamicObject userData : userDatas) {
                    String picturePath = userData.getString("picturefield");
                    userData.set("picturefield", (Object)picturePath.replaceFirst(imageServerUrl, ""));
                }
                SaveServiceHelper.update((DynamicObject[])userDatas);
            }
            result.setSuccess(true);
            result.setLog("UserAvatarUpgradeService data update success");
        }
        catch (Exception e) {
            logger.error("UserAvatarUpgradeService--beforeExecuteSqlWithResult", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
        }
        logger.debug("UserAvatarUpgradeService.end");
        return result;
    }
}

