/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UserNameIndexUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UserNameIndexUpgradeServiceImpl.class);
    private static final String querySQL = "select fusername from t_Sec_user_u group by fusername having count(fusername)>1";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4eba\u5458\u7528\u6237\u540d\u91cd\u590d\u6027\u68c0\u67e5\uff0c\u5e76\u5bf9\u91cd\u590d\u7684\u7528\u6237\u540d\u6267\u884c\u6dfb\u52a0\u540e\u7f00\u64cd\u4f5c\u3002", (String)"UserUserNameUpgradeServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        try {
            this.deleteOldData();
            this.addUserUniqueIndex();
        }
        catch (Exception exception) {
            String errorInfo = ResManager.loadKDString((String)"\u66f4\u65b0\u7528\u6237\u540d\u91cd\u590d\u7684\u4eba\u5458\u5931\u8d25\u3002", (String)"UserUserNameUpgradeServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]);
            logger.error(errorInfo);
            result.setSuccess(true);
        }
        return result;
    }

    private void addUserUniqueIndex() {
        if (((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, resultSet -> resultSet.next())).booleanValue()) {
            logger.error("\u4eba\u5458\u8868\uff08T_SEC_USER_U\uff09\u6dfb\u52a0\u552f\u4e00\u7d22\u5f15\u5931\u8d25\uff1a\u5b58\u5728\u91cd\u590d\u7684\u7f16\u7801\uff08FUSERNAME\uff09\uff0c\u9700\u8981\u624b\u5de5\u4fee\u590d\u540e\u624d\u80fd\u52a0\u4e0a\u552f\u4e00\u7d22\u5f15\u3002");
        } else {
            String deleteOldIndexSql = "EXEC p_DropIdx 'IDX_T_SEC_User_U_UserName', 'T_SEC_User_U';";
            this.execute(deleteOldIndexSql);
            String createUniqueIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'UX_T_SEC_User_U_UserName') CREATE UNIQUE INDEX UX_T_SEC_User_U_UserName ON T_SEC_User_U ( FUserName );";
            this.execute(createUniqueIndexSql);
        }
    }

    private void deleteOldData() {
        String deleteOldSql = "delete from t_sec_user_u u where not exists (select 1 from t_sec_user t where u.fid = t.fid );";
        this.execute(deleteOldSql);
    }

    private void execute(String sql) {
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
    }
}

