/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserTypeUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UserTypeUpgradeServiceImpl.class);
    private static final String DELETE_SQL = "delete from t_sec_usertypes";
    private static final String INSERT_SQL = "insert into t_sec_usertypes (fpkid,fid,fbasedataid) values(?,?,?)";
    private static final String DELETE_HISTORY_SQL = "delete from t_sec_usertypes_h";
    private static final String INSERT_HISTORY_SQL = "insert into t_sec_usertypes_h (fpkid,fid,fbasedataid) values(?,?,?)";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4eba\u5458\u7c7b\u578b\u6570\u636e\u5347\u7ea7...", (String)"UserTypeUpgradeServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
            this.upgrade("bos_user");
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u5458\u7c7b\u578b\u6570\u636e\u5347\u7ea7\u5df2\u5b8c\u6210\u3002", (String)"UserTypeUpgradeServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        catch (Exception e) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u6570\u636e\u5347\u7ea7\u5f02\u5e38\uff1a%1$s\u3002", (String)"UserTypeUpgradeServiceImpl_2", (String)"bos-mservice-permission", (Object[])new Object[0]), e.getMessage());
            result.setErrorInfo(errorInfo);
            result.setSuccess(false);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(errorInfo);
        }
        return result;
    }

    private void upgrade(String entityName) {
        List<Map<String, Object>> userTypeList = this.getAllUserTypes(entityName);
        int count = userTypeList.size();
        if (count == 0) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(count);
        ORM idGen = ORM.create();
        long[] pks = idGen.genLongIds(entityName, count);
        int pkIndex = 0;
        for (Map<String, Object> userTypeMapLoop : userTypeList) {
            long pk = pks[pkIndex++];
            paramsList.add(new Object[]{pk, userTypeMapLoop.get("id"), userTypeMapLoop.get("usertype")});
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if ("bos_user".equals(entityName)) {
                    DB.execute((DBRoute)DBRoute.base, (String)DELETE_SQL);
                    DB.executeBatch((DBRoute)DBRoute.base, (String)INSERT_SQL, paramsList);
                } else {
                    DB.execute((DBRoute)DBRoute.base, (String)DELETE_HISTORY_SQL);
                    DB.executeBatch((DBRoute)DBRoute.base, (String)INSERT_HISTORY_SQL, paramsList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                String errorInfo = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u6570\u636e\u5347\u7ea7\u5f02\u5e38\uff1a%1$s\u3002", (String)"UserTypeUpgradeServiceImpl_2", (String)"bos-mservice-permission", (Object[])new Object[0]), e.getMessage());
                logger.error(errorInfo, (Throwable)e);
                throw new KDBizException(errorInfo);
            }
        }
    }

    private List<Map<String, Object>> getAllUserTypes(String entityName) {
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)entityName, (String)"id,usertype", null);
        if (userCol == null) {
            return new ArrayList<Map<String, Object>>();
        }
        int count = userCol.size();
        if (count == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> userTypeList = new ArrayList<Map<String, Object>>(count);
        for (DynamicObject userObj : userCol) {
            String[] userTypeArr;
            String userType = userObj.getString("usertype");
            if (StringUtils.isBlank((CharSequence)userType)) continue;
            long userId = userObj.getLong("id");
            for (String userTypeId : userTypeArr = userType.split(",")) {
                if (StringUtils.isBlank((CharSequence)userTypeId)) continue;
                HashMap<String, Long> userTypeMap = new HashMap<String, Long>(2);
                userTypeMap.put("id", userId);
                try {
                    userTypeMap.put("usertype", Long.parseLong(userTypeId.trim()));
                }
                catch (Exception e) {
                    logger.error(userId + "\uff1a\u4eba\u5458\u5347\u7ea7\u51fa\u73b0\u5f02\u5e38\u4eba\u5458\u7c7b\u578bID\uff1a" + userTypeId);
                    continue;
                }
                userTypeList.add(userTypeMap);
            }
        }
        return userTypeList;
    }
}

