/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.servicehelper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserUserNameUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UserUserNameUpgradeServiceImpl.class);
    private static final String querySQL = "select fusername from t_Sec_user_u group by fusername having count(fusername)>1";
    private static final String queryIDSQL = "select fid,fusername from t_sec_user_u where fusername = '' or fusername =' ' or fusername is null ";
    private static final String USERNAME = "username";
    private Set<String> exitsUsernameSet = new HashSet<String>();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4eba\u5458\u7528\u6237\u540d\u91cd\u590d\u6027\u68c0\u67e5\uff0c\u5e76\u5bf9\u91cd\u590d\u7684\u7528\u6237\u540d\u6267\u884c\u6dfb\u52a0\u540e\u7f00\u64cd\u4f5c\u3002", (String)"UserUserNameUpgradeServiceImpl_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        try {
            this.deleteOldData();
            this.dealUserName();
            this.dealUserName();
            this.addUserUniqueIndex();
        }
        catch (Exception exception) {
            String errorInfo = ResManager.loadKDString((String)"\u66f4\u65b0\u7528\u6237\u540d\u91cd\u590d\u7684\u4eba\u5458\u5931\u8d25\u3002", (String)"UserUserNameUpgradeServiceImpl_1", (String)"bos-mservice-permission", (Object[])new Object[0]);
            logger.error(errorInfo);
            result.setSuccess(true);
        }
        return result;
    }

    public void dealUserName() {
        Set<String> userNameList = this.getRepeatUserName();
        userNameList.add(" ");
        this.modifyUserName(userNameList);
    }

    private Set<String> getRepeatUserName() {
        Set usernameList = (Set)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, (ResultSetHandler)new ResultSetHandler<Set<String>>(){
            Set<String> usernameList = new HashSet<String>();

            public Set<String> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String value = resultSet.getString("fusername");
                    this.usernameList.add(value);
                }
                return this.usernameList;
            }
        });
        return usernameList;
    }

    private void modifyUserName(Set<String> usernameList) {
        QFilter usernameQFilter = new QFilter(USERNAME, "in", usernameList);
        ArrayList<Long> ids = this.getSpecialUser();
        if (!CollectionUtils.isEmpty(ids)) {
            usernameQFilter.or(new QFilter("id", "in", ids));
        }
        QFilter[] qFilters = new QFilter[]{usernameQFilter};
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,username,name,fullpinyin,simplepinyin,enable", (QFilter[])qFilters);
        HashMap<String, Integer> usernameMap = new HashMap<String, Integer>();
        for (DynamicObject user : users) {
            String userNameOld = user.getString(USERNAME);
            if (user.getBoolean("enable") && StringUtils.isNotBlank((CharSequence)userNameOld)) {
                int count = usernameMap.getOrDefault(userNameOld, 0);
                usernameMap.put(userNameOld, count + 1);
            }
            if (usernameMap.getOrDefault(userNameOld, 0) == 1) {
                this.exitsUsernameSet.add(userNameOld);
                continue;
            }
            String existUsername = user.getString("fullpinyin");
            if (StringUtils.isBlank((CharSequence)existUsername) && StringUtils.isNotBlank((CharSequence)user.getString("name"))) {
                existUsername = UserUtils.getFullSpellByName((String)user.getString("name"));
            }
            if (StringUtils.isBlank((CharSequence)existUsername)) {
                existUsername = userNameOld;
            }
            Set existsUserNames = UserUtils.getExistsUserNames((long)0L, (String)existUsername);
            existsUserNames.addAll(this.exitsUsernameSet);
            this.exitsUsernameSet.addAll(existsUserNames);
            String userNameNew = UserUtils.getUserNameByFullPinyin((long)0L, (String)existUsername, (Set)existsUserNames);
            this.exitsUsernameSet.add(userNameNew);
            user.set(USERNAME, (Object)userNameNew);
        }
        SaveServiceHelper.save((DynamicObject[])users);
    }

    private ArrayList<Long> getSpecialUser() {
        ArrayList ids = (ArrayList)DB.query((DBRoute)DBRoute.basedata, (String)queryIDSQL, (ResultSetHandler)new ResultSetHandler<ArrayList<Long>>(){
            ArrayList<Long> ids = new ArrayList();

            public ArrayList<Long> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    this.ids.add(resultSet.getLong("fid"));
                }
                return this.ids;
            }
        });
        return ids;
    }

    private void addUserUniqueIndex() {
        if (((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, resultSet -> resultSet.next())).booleanValue()) {
            logger.error("\u4eba\u5458\u8868\uff08T_SEC_USER_U\uff09\u6dfb\u52a0\u552f\u4e00\u7d22\u5f15\u5931\u8d25\uff1a\u5b58\u5728\u91cd\u590d\u7684\u7f16\u7801\uff08FUSERNAME\uff09\uff0c\u9700\u8981\u624b\u5de5\u4fee\u590d\u540e\u624d\u80fd\u52a0\u4e0a\u552f\u4e00\u7d22\u5f15\u3002");
        } else {
            String deleteOldIndexSql = "EXEC p_DropIdx 'IDX_T_SEC_User_U_UserName', 'T_SEC_User_U';";
            this.execute(deleteOldIndexSql);
            String createUniqueIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'UX_T_SEC_User_U_UserName') CREATE UNIQUE INDEX UX_T_SEC_User_U_UserName ON T_SEC_User_U ( FUserName );";
            this.execute(createUniqueIndexSql);
        }
    }

    private void deleteOldData() {
        String deleteOldSql = "delete from t_sec_user_u u where not exists (select 1 from t_sec_user t where u.fid = t.fid );";
        this.execute(deleteOldSql);
    }

    private void execute(String sql) {
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
    }
}

