/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.task.scheme;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import kd.bos.crypto.MultiEncrypters;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.task.scheme.TaskContext;
import org.apache.commons.beanutils.ConvertUtils;

public class DataProcessingTask {
    private static final Log LOG = LogFactory.getLog(DataProcessingTask.class);
    String algorithm;
    String workKey;
    int length;
    boolean isEncrypt;
    List<PrivacyDataModel> data;
    int start;
    int end;
    private Cipher cipher;

    public DataProcessingTask(TaskContext context, List<PrivacyDataModel> data, int start, int end) {
        this.algorithm = context.getAlgorithm();
        this.workKey = context.getWorkKey();
        this.length = context.getLength();
        this.isEncrypt = context.isEncrypt();
        this.data = data;
        this.start = start;
        this.end = end;
    }

    public void process() {
        for (int i = this.start; i < this.end; ++i) {
            String value;
            PrivacyDataModel datum = this.data.get(i);
            Object bizId = datum.getBizId();
            if (this.isEncrypt) {
                value = this.encrypt(this.cipher, bizId, String.valueOf(datum.getValue()));
                datum.setEncryptValue(value);
                continue;
            }
            value = this.decrypt(this.cipher, bizId, datum.getEncryptValue());
            int fieldType = datum.getFieldType();
            Object convertValue = this.convert(value, fieldType);
            datum.setValue(convertValue);
        }
    }

    private String encrypt(Cipher cipher, Object bizId, String bizData) {
        try {
            return MultiEncrypters.encrypt((Cipher)cipher, (String)this.algorithm, (String)this.workKey, (int)this.length, (String)bizData);
        }
        catch (Exception ex) {
            LOG.warn(String.format(ResManager.loadKDString((String)"DataProcessingTask\u3010bizId\uff1a%1$s\uff0c bizData \uff1a%2$s\u3011\u52a0\u5bc6\u5931\u8d25", (String)"DataProcessingTask_2", (String)"bos-mservice-permission", (Object[])new Object[0]), bizId, bizData), (Throwable)ex);
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"bizId\u3010%s\u3011\u52a0\u5bc6\u5931\u8d25\u3002", (String)"DataProcessingTask_0", (String)"bos-mservice-permission", (Object[])new Object[0]), bizId), ex);
        }
    }

    private String decrypt(Cipher cipher, Object bizId, String bizData) {
        try {
            return MultiEncrypters.decrypt((Cipher)cipher, (String)this.algorithm, (String)this.workKey, (int)this.length, (String)bizData);
        }
        catch (Exception ex) {
            LOG.warn(String.format(ResManager.loadKDString((String)"DataProcessingTask\u3010bizId\uff1a%1$s\uff0c bizData \uff1a%2$s\u3011\u89e3\u5bc6\u5931\u8d25", (String)"DataProcessingTask_3", (String)"bos-mservice-permission", (Object[])new Object[0]), bizId, bizData), (Throwable)ex);
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"bizId\u3010%s\u3011\u89e3\u5bc6\u5931\u8d25\u3002", (String)"DataProcessingTask_1", (String)"bos-mservice-permission", (Object[])new Object[0]), bizId), ex);
        }
    }

    private Object convert(String str, int type) {
        Class clazz;
        if (str == null) {
            return null;
        }
        switch (type) {
            case 4: {
                clazz = Integer.class;
                break;
            }
            case -7: {
                clazz = Boolean.TYPE;
                break;
            }
            case -6: {
                clazz = Byte.TYPE;
                break;
            }
            case 5: {
                clazz = Short.TYPE;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                clazz = byte[].class;
                break;
            }
            default: {
                clazz = String.class;
            }
        }
        if (Date.class.isAssignableFrom(clazz)) {
            Long ts = (Long)ConvertUtils.convert((String)str, Long.class);
            Timestamp obj = new Timestamp(ts);
            return ConvertUtils.convert((Object)obj, clazz);
        }
        return ConvertUtils.convert((String)str, clazz);
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }
}

