/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataValidator {
    private static final Log log = LogFactory.getLog(BaseDataValidator.class);
    protected String checkObj;
    protected String checkObjName;
    protected String errorMsg;
    private boolean doCheck;

    public BaseDataValidator(String checkObj, String checkObjName, boolean blankAble) {
        this(checkObj, checkObjName, blankAble, true);
    }

    public BaseDataValidator(String checkObj, String checkObjName, boolean blankAble, boolean doCheck) {
        this.checkObj = checkObj;
        this.checkObjName = checkObjName;
        this.doCheck = doCheck;
        if (StringUtils.isBlank((CharSequence)checkObj)) {
            if (!blankAble) {
                this.addErrorMsg(checkObjName + ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseDataValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
            }
            return;
        }
        this.validate();
    }

    private final void validate() {
        try {
            this.prepare();
            if (this.doCheck) {
                this.check();
            }
        }
        catch (KDBizException e) {
            this.addErrorMsg(e.getMessage());
        }
    }

    public final void addErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void prepare() {
        log.debug("\u9ed8\u8ba4\u6570\u636e\u51c6\u5907\u5904\u7406\u3002");
    }

    public void check() {
        log.debug("\u9ed8\u8ba4\u6821\u9a8c\u89c4\u5219\u3002");
    }
}

