/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PermDataMigrationUtils {
    private static final Log logger = LogFactory.getLog(PermDataMigrationUtils.class);

    public static StringBuilder generateOpRulesSql(Set<String> rulesId, boolean containEnabledStatus, boolean containExUser, boolean containExUserGrp, boolean containExRole) {
        StringBuilder sbSql = new StringBuilder();
        if (CollectionUtils.isEmpty(rulesId)) {
            logger.debug("No data selected.");
            return sbSql;
        }
        String tableName = "t_perm_operationrule";
        String fields = "fid,fenabled,foperationtype,fentitytypeid,fispublic,fbizappid,fispreset,frule,foperationkey,fname,fdescription";
        StringBuilder whereBuilder = new StringBuilder("(");
        for (String ruleId : rulesId) {
            if (!StringUtils.isNotEmpty((String)ruleId)) continue;
            whereBuilder.append('\'').append(ruleId).append("',");
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String strWhere = whereBuilder.toString();
        Map map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_operationrule_l";
        fields = "fpkid,fid,flocaleid,fname,fdescription";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        if (containEnabledStatus) {
            tableName = "t_perm_operationruleobj";
            fields = "fid,foperationruleid,fseq,fentitytypeid,fobjenabled,fbizappid";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "foperationruleid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"perm_operationruleobj", (String)"id", (QFilter[])new QFilter[]{new QFilter("operationrule", "in", rulesId)});
            whereBuilder = new StringBuilder("(");
            for (DynamicObject object : dynamicObjects) {
                String opRuleObjId = (String)object.getPkValue();
                if (!StringUtils.isNotEmpty((String)opRuleObjId)) continue;
                whereBuilder.append('\'').append(opRuleObjId).append("',");
            }
            whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
            strWhere = whereBuilder.toString();
            if (!")".equals(strWhere)) {
                if (containExUser) {
                    tableName = "t_perm_exceptuser";
                    fields = "fid,foperationruleobjid,fuserid";
                    map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "foperationruleobjid in " + strWhere, null, null);
                    sbSql.append(map.get("sql"));
                }
                if (containExUserGrp) {
                    tableName = "t_perm_oprexusrgrp";
                    fields = "fid,foperationruleobjid,fusergroupid";
                    map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "foperationruleobjid in " + strWhere, null, null);
                    sbSql.append(map.get("sql"));
                }
                if (containExRole) {
                    tableName = "t_perm_oprexrole";
                    fields = "fid,foperationruleobjid,froleid";
                    map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "foperationruleobjid in " + strWhere, null, null);
                    sbSql.append(map.get("sql"));
                }
            }
        }
        return sbSql;
    }

    public static List<String> exportDataBySqlFile(StringBuilder sbSql, String exportPath, int threshold) {
        LinkedList<String> fileUrlList = new LinkedList<String>();
        if (sbSql == null || sbSql.length() == 0) {
            return fileUrlList;
        }
        if (StringUtils.isEmpty((String)exportPath)) {
            exportPath = System.getProperty("user.home") + File.separator + "KINGDEEDOWNLOAD" + File.separator;
        }
        if (!exportPath.endsWith(File.separator)) {
            exportPath = exportPath + File.separator;
        }
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HHmmss");
        if (threshold <= 0) {
            threshold = 2000000;
        }
        int fileNum = 0;
        String sql = sbSql.toString();
        while (true) {
            int index;
            if ((index = sql.indexOf(59, threshold)) == -1) {
                String fileName = exportPath + format.format(date) + "_export" + fileNum + ".sql";
                fileUrlList.add(fileName);
                File file = new File(fileName);
                try (FileOutputStream stream = new FileOutputStream(file);){
                    stream.write(sql.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (IOException e) {
                    logger.warn("exportDataBySqlFile IO error.", (Throwable)e);
                    file.deleteOnExit();
                    return new LinkedList<String>();
                }
            }
            String subString = sql.substring(0, index + 1);
            String fileName = exportPath + format.format(date) + "_export" + fileNum++ + ".sql";
            fileUrlList.add(fileName);
            File file = new File(fileName);
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(subString.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                logger.warn("exportDataBySqlFile IO error.", (Throwable)e);
                file.deleteOnExit();
                return new LinkedList<String>();
            }
            sql = sql.substring(index + 1);
        }
        return fileUrlList;
    }

    public static boolean importDataBySqlFile(List<String> fileUrlList) {
        try (TXHandle h = TX.required();){
            for (String fileUrl : fileUrlList) {
                try {
                    FileInputStream stream = new FileInputStream(new File(fileUrl));
                    Throwable throwable = null;
                    try {
                        byte[] bytes = new byte[stream.available()];
                        stream.read(bytes);
                        String sql = new String(bytes, StandardCharsets.UTF_8);
                        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception e) {
                    logger.warn("importDataBySqlFile: wrong file:{}", (Object)fileUrl, (Object)e);
                    h.markRollback();
                    boolean bl = false;
                    if (h != null) {
                        if (var2_2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var2_2.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public static StringBuilder generateComRolesSql(Set<String> roleIds) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(3);
        paraMap.put("roleIds", roleIds);
        paraMap.put("include_field", true);
        paraMap.put("include_dr", true);
        paraMap.put("include_dimuser", true);
        paraMap.put("include_dimug", true);
        paraMap.put("controltype", "ALL");
        paraMap.put("isPreset", "0");
        return PermDataMigrationUtils.generateComRolesSql(paraMap);
    }

    public static StringBuilder generateComRolesSql(Map<String, Object> paraMap) {
        Set roleIds = (Set)paraMap.get("roleIds");
        Set formNumSet = (Set)paraMap.get("formNumSet");
        boolean include_field = (Boolean)paraMap.get("include_field");
        boolean include_dr = (Boolean)paraMap.get("include_dr");
        boolean include_dimuser = (Boolean)paraMap.get("include_dimuser");
        boolean include_dimug = (Boolean)paraMap.get("include_dimug");
        String controltype = (String)paraMap.get("controltype");
        controltype = PermDataMigrationUtils.transControlType(controltype);
        String isPreset = (String)paraMap.get("isPreset");
        StringBuilder sbSql = new StringBuilder();
        if (CollectionUtils.isEmpty((Collection)roleIds)) {
            logger.debug("No data selected.");
            return sbSql;
        }
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String tableName = "";
        String fields = "";
        Map map = null;
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"perm_role", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)roleIds)});
        StringBuilder whereBuilder = new StringBuilder("(");
        for (DynamicObject dynamicObject : objects) {
            String roleGroupId;
            DynamicObject group = dynamicObject.getDynamicObject("group");
            if (group == null || !StringUtils.isNotEmpty((String)(roleGroupId = (String)group.getPkValue()))) continue;
            whereBuilder.append('\'').append(roleGroupId).append("',");
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        String strWhere = whereBuilder.toString();
        if (!")".equals(strWhere)) {
            tableName = "t_perm_rolegroup";
            fields = "fid,fnumber,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,flevel,flongnumber,fisleaf,fparentid,fdisablerid,fdisabledate,fmasterid,fname,fdescription,ffullname";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            tableName = "t_perm_rolegroup_l";
            fields = "fpkid,fid,flocaleid,fname,fdescription,ffullname";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
        }
        tableName = "t_perm_role";
        fields = "fid,ftype,fnumber,flongnumber,fparentroleid,fbizdomainid,frolegroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fgroupid,fdisablerid,fdisabledate,fmasterid,fissystem,fremark,fname,fdimtypeid";
        whereBuilder = new StringBuilder("(");
        for (String roleId : roleIds) {
            if (!StringUtils.isNotEmpty((String)roleId)) continue;
            whereBuilder.append('\'').append(roleId).append("',");
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        String roleIdWhere = whereBuilder.toString();
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + roleIdWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_role_l";
        fields = "fpkid,fid,flocaleid,fname,fremark";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + roleIdWhere, null, null);
        sbSql.append(map.get("sql"));
        sbSql.append("\n/** \u89d2\u8272-\u529f\u80fd\u6743\u9650 start **/\n");
        if (StringUtils.isEmpty((String)isPreset) || "0".equals(isPreset)) {
            PermDataMigrationUtils.rolePermDetailNormal(sbSql, builder, roleIdWhere, formNumSet);
        } else if (StringUtils.isNotEmpty((String)isPreset) || "1".equals(isPreset)) {
            PermDataMigrationUtils.rolePermDetailPreset(sbSql, builder, roleIds, formNumSet);
        }
        sbSql.append("/** \u89d2\u8272-\u529f\u80fd\u6743\u9650 end **/\n");
        if (include_field) {
            sbSql.append("\n/** \u89d2\u8272-\u5b57\u6bb5\u6743\u9650 start **/\n");
            tableName = "t_perm_rolefieldperm";
            fields = "fid,froleid,ffieldpermid,finheritmode";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "froleid in " + roleIdWhere, null, null);
            sbSql.append(map.get("sql"));
            DynamicObject[] fieldPerms = BusinessDataServiceHelper.load((String)"perm_rolefieldperm", (String)"fieldperm", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIds)});
            whereBuilder = new StringBuilder("(");
            for (DynamicObject object : fieldPerms) {
                String fieldPermId;
                DynamicObject fieldperm = object.getDynamicObject("fieldperm");
                if (fieldperm == null || !StringUtils.isNotEmpty((String)(fieldPermId = (String)fieldperm.getPkValue()))) continue;
                whereBuilder.append('\'').append(fieldPermId).append("',");
            }
            whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
            strWhere = whereBuilder.toString();
            if (!")".equals(strWhere)) {
                tableName = "t_perm_fieldperm";
                fields = "fid,fnumber";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                sbSql.append(map.get("sql"));
                tableName = "t_perm_fieldpermdetail";
                fields = "fentryid,fid,fseq,fentitytypeid,ffieldname,fcontrolmode,fbizappid";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                sbSql.append(map.get("sql"));
            }
            sbSql.append("/** \u89d2\u8272-\u5b57\u6bb5\u6743\u9650 end **/\n");
        }
        if (include_dr) {
            whereBuilder = new StringBuilder(8);
            sbSql.append("\n/** \u89d2\u8272-\u6570\u636e\u89c4\u5219 start **/\n");
            boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
            if (hasEnableRoleDataRuleNewModel) {
                tableName = "t_perm_roledatarule";
                fields = "fid,froleid,fappid,fentitynum,fpermitemid,fdataruleid,fcreatetime,fcreatorid,fmodifytime,fmodifierid";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "froleid in " + roleIdWhere, null, null);
                sbSql.append(map.get("sql"));
                DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"perm_roledatarule", (String)"datarule", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIds)});
                whereBuilder.append("(");
                if (dynamicObjectArray != null && dynamicObjectArray.length != 0) {
                    for (DynamicObject object : dynamicObjectArray) {
                        Long dataRuleId = object.getLong("datarule_id");
                        if (dataRuleId == null || dataRuleId == 0L) continue;
                        whereBuilder.append(dataRuleId).append(',');
                    }
                }
                whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
                strWhere = whereBuilder.toString();
                if (!")".equals(strWhere)) {
                    tableName = "t_perm_datarule";
                    fields = "fid,fmasterid,fnumber,fbizappid,fentitynum,frule,fisdetail,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fdescription,frule_tag,fname,fapplyscope,fcloudid";
                    map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                    try {
                        sbSql.append(PermDataMigrationUtils.combineSqlAndXml(map));
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage());
                        throw new RuntimeException(e);
                    }
                    tableName = "t_perm_datarule_l";
                    fields = "fid,flocaleid,fname,fdescription,fpkid";
                    map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                    sbSql.append(map.get("sql"));
                }
            } else {
                PermDataMigrationUtils.generateRoleDrOldModelSql(roleIds, sbSql, builder, roleIdWhere);
            }
            sbSql.append("/** \u89d2\u8272-\u6570\u636e\u89c4\u5219 end **/\n");
        }
        if (include_dimuser) {
            sbSql.append("\n/** \u89d2\u8272\u4e0b\uff0c\u9694\u79bb\u7ef4\u5ea6-\u7528\u6237\u5173\u7cfb t_perm_userrole start **/\n");
            sbSql.append(PermDataMigrationUtils.getUserRoleSql(roleIds, controltype, builder).get("sql"));
            sbSql.append("/** \u89d2\u8272\u4e0b\uff0c\u9694\u79bb\u7ef4\u5ea6-\u7528\u6237\u5173\u7cfb t_perm_userrole end **/\n");
        }
        if (include_dimug) {
            sbSql.append("\n/** \u89d2\u8272\u4e0b\uff0c\u9694\u79bb\u7ef4\u5ea6-\u7528\u6237\u7ec4\u5173\u7cfb t_perm_usrgrprole start **/\n");
            sbSql.append(PermDataMigrationUtils.getUsrGrpRoleSql(roleIds, controltype, builder).get("sql"));
            sbSql.append("/** \u89d2\u8272\u4e0b\uff0c\u9694\u79bb\u7ef4\u5ea6-\u7528\u6237\u7ec4\u5173\u7cfb t_perm_usrgrprole end **/\n");
        }
        return sbSql;
    }

    @Deprecated
    private static void generateRoleDrOldModelSql(Set<String> roleIds, StringBuilder sbSql, PreInsDataScriptBuilder builder, String roleIdWhere) {
        String tableName = "t_perm_roledataperm";
        String fields = "fid,fdatapermid,froleid,fisupdate,fupdatetime,fupdatorid";
        Map map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "froleid in " + roleIdWhere, null, null);
        sbSql.append(map.get("sql"));
        DynamicObject[] dataPerms = BusinessDataServiceHelper.load((String)"perm_roledataperm", (String)"datapermid", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIds)});
        StringBuilder whereBuilder = new StringBuilder("(");
        for (DynamicObject object : dataPerms) {
            String dataPermId;
            DynamicObject dataPerm = object.getDynamicObject("datapermid");
            if (dataPerm == null || !StringUtils.isNotEmpty((String)(dataPermId = (String)dataPerm.getPkValue()))) continue;
            whereBuilder.append('\'').append(dataPermId).append("',");
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        String strWhere = whereBuilder.toString();
        if (!")".equals(strWhere)) {
            tableName = "t_perm_dataperm";
            fields = "fid,fpermitemid,fnumber,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fmasterid";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            tableName = "t_perm_datapermentry";
            fields = "fentryid,fid,fentitytypeid,fseq,fbizappid,frule";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
        }
        tableName = "t_perm_roledatarules";
        fields = "fid,fdatarulesid,froleid,fcreatetime,fcreatorid,fmodifytime,fmodifierid";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "froleid in " + roleIdWhere, null, null);
        sbSql.append(map.get("sql"));
        DynamicObject[] dataRules = BusinessDataServiceHelper.load((String)"perm_roledatarules", (String)"datarules", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIds)});
        whereBuilder = new StringBuilder("(");
        ArrayList<Long> dataRulesList = new ArrayList<Long>(8);
        for (DynamicObject object : dataRules) {
            Long dataRulesId;
            DynamicObject dataRule = object.getDynamicObject("datarules");
            if (dataRule == null || (dataRulesId = (Long)dataRule.getPkValue()) == 0L) continue;
            dataRulesList.add(dataRulesId);
            whereBuilder.append(dataRulesId).append(',');
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        strWhere = whereBuilder.toString();
        if (!")".equals(strWhere)) {
            tableName = "t_perm_datarules";
            fields = "fid,fmasterid,fnumber,fstatus,fenable,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fname,fdataruleid";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            tableName = "t_perm_datarules_l";
            fields = "fid,flocaleid,fname,fpkid";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            tableName = "t_perm_datarules_entry";
            fields = "fentryid,fid,fseq,fbizappid,fentitynum,fdataruleid";
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
            sbSql.append(map.get("sql"));
            DynamicObject[] dataRule = BusinessDataServiceHelper.load((String)"perm_datarules", (String)"entryentity.datarule", (QFilter[])new QFilter[]{new QFilter("id", "in", dataRulesList)});
            whereBuilder = new StringBuilder("(");
            LinkedList<Long> dataRuleList = new LinkedList<Long>();
            for (DynamicObject object : dataRule) {
                DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    Long dataRuleId;
                    DynamicObject datarule = dynamicObject.getDynamicObject("datarule");
                    if (datarule == null || (dataRuleId = (Long)datarule.getPkValue()) == 0L) continue;
                    dataRuleList.add(dataRuleId);
                    whereBuilder.append(dataRuleId).append(',');
                }
            }
            whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
            strWhere = whereBuilder.toString();
            if (!")".equals(strWhere)) {
                Long dataruleId;
                DynamicObjectCollection entryEntity;
                tableName = "t_perm_datarule_entry";
                fields = "fentryid,fid,fseq,fpermitemid,fopkey,foptype,fdataruleid";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                sbSql.append(map.get("sql"));
                tableName = "t_perm_datarule_prop";
                fields = "fid,fentryid,fpropkey,fdataruleid,fpropentnum,fseq";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                sbSql.append(map.get("sql"));
                DynamicObject[] entryObjects = BusinessDataServiceHelper.load((String)"perm_datarule", (String)"entryentity.datarule", (QFilter[])new QFilter[]{new QFilter("id", "in", dataRuleList)});
                DynamicObject[] propObjects = BusinessDataServiceHelper.load((String)"perm_datarule", (String)"entryentity_prop.propdatarule", (QFilter[])new QFilter[]{new QFilter("id", "in", dataRuleList)});
                whereBuilder = new StringBuilder(strWhere);
                whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(',');
                for (DynamicObject entryObject : entryObjects) {
                    entryEntity = entryObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject datarule = dynamicObject.getDynamicObject("datarule");
                        if (datarule == null) continue;
                        dataruleId = (Long)datarule.getPkValue();
                        whereBuilder.append(dataruleId).append(',');
                    }
                }
                for (DynamicObject propObject : propObjects) {
                    entryEntity = propObject.getDynamicObjectCollection("entryentity_prop");
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject propDataRule = dynamicObject.getDynamicObject("propdatarule");
                        if (propDataRule == null) continue;
                        dataruleId = (Long)propDataRule.getPkValue();
                        whereBuilder.append(dataruleId).append(',');
                    }
                }
                whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
                strWhere = whereBuilder.toString();
                tableName = "t_perm_datarule";
                fields = "fid,fmasterid,fnumber,fbizappid,fentitynum,frule,fisdetail,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fdescription,frule_tag,fname,fapplyscope,fcloudid";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                try {
                    sbSql.append(PermDataMigrationUtils.combineSqlAndXml(map));
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                    throw new RuntimeException(e);
                }
                tableName = "t_perm_datarule_l";
                fields = "fid,flocaleid,fname,fdescription,fpkid";
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
                sbSql.append(map.get("sql"));
            }
        }
    }

    private static String transControlType(String controltype) {
        if (StringUtils.isEmpty((String)controltype)) {
            return "ALL";
        }
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)controltype);
        if (StringUtils.isEmpty((String)suitableDimType[1])) {
            return "ALL";
        }
        return suitableDimType[1];
    }

    private static Map<String, Object> getUsrGrpRoleSql(Set<String> roleIds, String controltype, PreInsDataScriptBuilder builder) {
        String roleIdStr = String.join((CharSequence)"','", roleIds);
        StringBuilder sb = new StringBuilder();
        sb.append("froleid in('").append(roleIdStr).append("')");
        if (StringUtils.isNotEmpty((String)controltype) && !"ALL".equals(controltype)) {
            sb.append(" and fdimtype = '").append(controltype).append('\'');
        }
        return builder.genInsertSQLScript(DBRoute.basedata, "t_perm_usrgrprole", "fid, fusrgrpid, froleid, fdimid, fincludesub, fdimtype, fstarttime, fendtime, fcreatorid, fcreatetime, fmodifierid, fmodifytime", sb.toString(), null, null);
    }

    private static Map<String, Object> getUserRoleSql(Set<String> roleIds, String controltype, PreInsDataScriptBuilder builder) {
        String roleIdStr = String.join((CharSequence)"','", roleIds);
        StringBuilder sb = new StringBuilder();
        sb.append("froleid in('").append(roleIdStr).append("')");
        if (StringUtils.isNotEmpty((String)controltype) && !"ALL".equals(controltype)) {
            sb.append(" and fdimtype = '").append(controltype).append('\'');
        }
        return builder.genInsertSQLScript(DBRoute.basedata, "t_perm_userrole", "fid, forgid, fuserid, froleid, fisincludesuborg, fsource, fbizroleid, fdimtype, fcreatedatefield, fcreaterfield, fmodifydatefield, fmodifierfield, fstarttime, fendtime", sb.toString(), null, null);
    }

    private static void rolePermDetailPreset(StringBuilder sbSql, PreInsDataScriptBuilder builder, Set<String> roleIds, Set<String> formNumSet) {
        String lineSep = System.getProperty("line.separator");
        sbSql.append(lineSep);
        String rolepermdetailTableName = "t_perm_rolepermdetial";
        String rolepermTableName = "t_perm_roleperm";
        int m = SqlUtil.getBatchCount((Integer)1, (int)roleIds.size());
        List listAvg = ListUtil.averageAssign(new ArrayList<String>(roleIds), (int)m);
        for (List roleIdList : listAvg) {
            String roleIdWhere = String.join((CharSequence)"','", roleIdList);
            sbSql.append("DELETE FROM ").append(rolepermTableName).append(" WHERE FROLEID IN('").append(roleIdWhere).append("');").append(lineSep);
            String fields = "fid,froleid,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fnumber,fmasterid";
            Map map = builder.genInsertSQLScript(DBRoute.basedata, rolepermTableName, fields, " FROLEID IN('" + roleIdWhere + "')", null, null);
            sbSql.append(PermDataMigrationUtils.removeRolePermDelSql(map.get("sql")));
            fields = "FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FINHERITMODE,FENTITYTYPEID,FBIZAPPID,FROLEID";
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append(fields).append(" from ").append(rolepermdetailTableName).append(" WHERE FROLEID IN('").append(roleIdWhere).append("')");
            if (null != formNumSet && !formNumSet.isEmpty()) {
                String formNumStr = String.join((CharSequence)"','", formNumSet);
                sb.append(" and FENTITYTYPEID in ('").append(formNumStr).append("')");
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(128);
            PermDataMigrationUtils.queryRolePermDetail(sb, list);
            if (CollectionUtils.isEmpty(list)) {
                sbSql.append(lineSep);
                continue;
            }
            HashMap roleIdFidMap = new HashMap(8);
            for (Map map2 : list) {
                Object fid = map2.get("fid");
                Object fentryid = map2.get("fentryid");
                Object fseq = map2.get("fseq");
                String fcontrolmode = (String)map2.get("fcontrolmode");
                Object fpermitemid = map2.get("fpermitemid");
                String finheritmode = (String)map2.get("finheritmode");
                Object fentitytypeid = map2.get("fentitytypeid");
                Object fbizappid = map2.get("fbizappid");
                Object froleid = map2.get("froleid");
                sbSql.append("DELETE FROM ").append(rolepermdetailTableName).append(" WHERE FBIZAPPID='").append(fbizappid).append('\'').append(" AND FENTITYTYPEID='").append(fentitytypeid).append('\'').append(" AND FPERMITEMID='").append(fpermitemid).append('\'').append(" AND FROLEID='").append(froleid).append('\'').append(';').append(lineSep);
                sbSql.append("INSERT INTO ").append(rolepermdetailTableName).append('(').append(fields).append(") VALUES ('").append(fid).append("','").append(fentryid).append("',").append(fseq).append(",'").append(StringUtils.isEmpty((String)fcontrolmode) ? " " : fcontrolmode).append("','").append(fpermitemid).append("','").append(StringUtils.isEmpty((String)finheritmode) ? " " : finheritmode).append("','").append(fentitytypeid).append("','").append(fbizappid).append("','").append(froleid).append("');").append(lineSep);
                roleIdFidMap.put(froleid, fid);
            }
            for (Map.Entry entry : roleIdFidMap.entrySet()) {
                Object roleId = entry.getKey();
                Object fid = entry.getValue();
                sbSql.append("UPDATE ").append(rolepermTableName).append(" SET FID = '").append(fid).append("' WHERE FROLEID = '").append(roleId).append("' and FID !='").append(fid).append("';").append(lineSep);
                sbSql.append("UPDATE ").append(rolepermdetailTableName).append(" SET FID = '").append(fid).append("' WHERE FROLEID = '").append(roleId).append("' and FID !='").append(fid).append("';").append(lineSep);
            }
            sbSql.append(lineSep);
        }
    }

    private static void queryRolePermDetail(StringBuilder sb, final List<Map<String, Object>> list) {
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = null;
                while (rs.next()) {
                    map = new HashMap<String, String>(16);
                    map.put("fid", rs.getString("fid"));
                    map.put("fentryid", rs.getString("fentryid"));
                    map.put("fseq", rs.getString("fseq"));
                    map.put("fcontrolmode", rs.getString("fcontrolmode"));
                    map.put("fpermitemid", rs.getString("fpermitemid"));
                    map.put("finheritmode", rs.getString("finheritmode"));
                    map.put("fentitytypeid", rs.getString("fentitytypeid"));
                    map.put("fbizappid", rs.getString("fbizappid"));
                    map.put("froleid", rs.getString("froleid"));
                    list.add(map);
                }
                return null;
            }
        });
    }

    private static void rolePermDetailNormal(StringBuilder sbSql, PreInsDataScriptBuilder builder, String roleIdWhere, Set<String> formNumSet) {
        String lineSep = System.getProperty("line.separator");
        String tableName = "t_perm_roleperm";
        sbSql.append("DELETE FROM ").append(tableName).append(" WHERE FROLEID in").append(roleIdWhere).append(';').append(lineSep);
        String fields = "fid,froleid,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fenable,fnumber,fmasterid";
        Map map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "froleid in " + roleIdWhere, null, null);
        sbSql.append(PermDataMigrationUtils.removeRolePermDelSql(map.get("sql")));
        tableName = "t_perm_rolepermdetial";
        sbSql.append("DELETE FROM ").append(tableName).append(" WHERE FROLEID in").append(roleIdWhere).append(';').append(System.getProperty("line.separator"));
        fields = "fid,fentryid,fseq,fcontrolmode,fpermitemid,finheritmode,fentitytypeid,fbizappid,froleid";
        String[] split = roleIdWhere.split(",");
        int length = split.length;
        if (length <= 10) {
            StringBuilder strWhere = new StringBuilder();
            strWhere.append("FROLEID in ").append(roleIdWhere);
            if (null != formNumSet && !formNumSet.isEmpty()) {
                String formNumStr = String.join((CharSequence)"','", formNumSet);
                strWhere.append(" and FENTITYTYPEID in ('").append(formNumStr).append("')");
            }
            map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, strWhere.toString(), null, null);
        } else {
            String finalRoleIds;
            split[0] = split[0].substring(1);
            split[length - 1] = split[length - 1].substring(0, split[length - 1].length() - 1);
            int groupCount = length / 10;
            for (int i = 0; i < groupCount; ++i) {
                StringBuilder roleIdsBuilder = new StringBuilder();
                roleIdsBuilder.append("FROLEID in (");
                for (int j = i * 10; j < i * 10 + 10; ++j) {
                    roleIdsBuilder.append(split[j]).append(',');
                }
                roleIdsBuilder.deleteCharAt(roleIdsBuilder.length() - 1).append(')');
                if (null != formNumSet && !formNumSet.isEmpty()) {
                    String formNumStr = String.join((CharSequence)"','", formNumSet);
                    roleIdsBuilder.append(" and FENTITYTYPEID in ('").append(formNumStr).append("')");
                }
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, roleIdsBuilder.toString(), null, null);
                sbSql.append(PermDataMigrationUtils.removeRolePermDetailDelSql(map.get("sql")));
            }
            StringBuilder roleIdsBuilder = new StringBuilder();
            roleIdsBuilder.append("FROLEID in (");
            for (int i = groupCount * 10; i < split.length; ++i) {
                roleIdsBuilder.append(split[i]).append(",");
            }
            roleIdsBuilder.deleteCharAt(roleIdsBuilder.length() - 1).append(')');
            if (null != formNumSet && !formNumSet.isEmpty()) {
                String formNumStr = String.join((CharSequence)"','", formNumSet);
                roleIdsBuilder.append(" and FENTITYTYPEID in ('").append(formNumStr).append("')");
            }
            if (!"FROLEID in )".equals(finalRoleIds = roleIdsBuilder.toString())) {
                map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, finalRoleIds, null, null);
            }
        }
        sbSql.append(PermDataMigrationUtils.removeRolePermDetailDelSql(map.get("sql")));
    }

    private static Object removeRolePermDelSql(Object sql) {
        if (null == sql) {
            return "";
        }
        sql = sql.toString().replaceAll("DELETE FROM t_perm_roleperm WHERE FID = '(.*?)';" + System.getProperty("line.separator"), "");
        return sql;
    }

    private static Object removeRolePermDetailDelSql(Object sql) {
        if (null == sql) {
            return "";
        }
        sql = sql.toString().replaceAll("DELETE FROM t_perm_rolepermdetial WHERE FENTRYID = '(.*?)';" + System.getProperty("line.separator"), "");
        return sql;
    }

    public static StringBuilder generateBizRolesSql(Set<Long> bizRoleIds) {
        StringBuilder sbSql = new StringBuilder();
        if (CollectionUtils.isEmpty(bizRoleIds)) {
            logger.debug("No data selected.");
            return sbSql;
        }
        String tableName = "t_perm_bizrole";
        String fields = "fid,fmasterid,fnumber,fusertype,fstatus,fenable,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fdisablerid,fdisabledate,fname,fdescription";
        StringBuilder whereBuilder = new StringBuilder("(");
        for (Long bizRoleId : bizRoleIds) {
            if (bizRoleId == 0L) continue;
            whereBuilder.append(bizRoleId).append(',');
        }
        whereBuilder.deleteCharAt(whereBuilder.length() - 1).append(')');
        String strWhere = whereBuilder.toString();
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_bizrole_l";
        fields = "fpkid,fid,flocaleid,fname,fdescription";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_bizrolecomrole";
        fields = "fentryid,fid,fseq,froleid,fenable";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"perm_bizrole", (String)"bizrolecomrole.role", (QFilter[])new QFilter[]{new QFilter("id", "in", bizRoleIds)});
        HashSet<String> roleIds = new HashSet<String>(8);
        for (DynamicObject object : objects) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("bizrolecomrole");
            for (DynamicObject dynamicObject : collection) {
                String roleId;
                DynamicObject role = dynamicObject.getDynamicObject("role");
                if (role == null || !StringUtils.isNotEmpty((String)(roleId = (String)role.getPkValue()))) continue;
                roleIds.add(roleId);
            }
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>(3);
        paraMap.put("roleIds", roleIds);
        paraMap.put("include_field", true);
        paraMap.put("include_dr", true);
        paraMap.put("include_dimuser", true);
        paraMap.put("include_dimug", true);
        paraMap.put("controltype", "ALL");
        paraMap.put("isPreset", "0");
        StringBuilder comRolesSql = PermDataMigrationUtils.generateComRolesSql(paraMap);
        sbSql.append((CharSequence)comRolesSql);
        tableName = "t_perm_bizroleperm";
        fields = "fentryid,fid,fseq,fpermitemid,fentitytypeid,fbizappid";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_bizroledisperm";
        fields = "fentryid,fid,fseq,fpermitemid,fentitytypeid,fbizappid";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        tableName = "t_perm_bizroleorg";
        fields = "fentryid,fid,fseq,forgid,fisincludesuborg,fdimtype";
        map = builder.genInsertSQLScript(DBRoute.basedata, tableName, fields, "fid in " + strWhere, null, null);
        sbSql.append(map.get("sql"));
        return sbSql;
    }

    public static String combineSqlAndXml(Map<String, Object> map) throws IOException, SAXException, ParserConfigurationException {
        if (map == null || map.isEmpty()) {
            return "";
        }
        Object sql = map.get("sql");
        if (!(sql instanceof String)) {
            return "";
        }
        String sqlStr = (String)sql;
        Object xmlData = map.get("xml");
        if (xmlData == null) {
            return sqlStr;
        }
        Map xmlMap = (Map)xmlData;
        if (xmlMap.isEmpty()) {
            return sqlStr;
        }
        for (Map.Entry entry : xmlMap.entrySet()) {
            StringWriter value = (StringWriter)entry.getValue();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(value.toString())));
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("data");
            if (nodeList.getLength() <= 0) continue;
            Node node = nodeList.item(0);
            String content = node.getTextContent();
            String key = (String)entry.getKey();
            String[] split = key.split("\\.");
            if (split.length < 2) continue;
            String id = split[split.length - 2];
            String oldStr = "(" + id + ",' '";
            String newStr = "(" + id + ",'" + content + "'";
            sqlStr = sqlStr.replace(oldStr, newStr);
        }
        return sqlStr;
    }
}

