/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.req.permctrltype.GetDimTypeIdReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.resp.permctrltype.GetDimTypeIdResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermFilterUtil {
    public static QFilter getViewPermFilter(Long userId, String pAppId, String entityNum) {
        String viewOpKey;
        QFilter tempOpRuleFilter;
        QFilter tempDataRuleFilter;
        if (userId == null || userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        String appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)pAppId);
        PermissionServiceImpl permServ = new PermissionServiceImpl();
        QFilter finalFilter = null;
        QFilter funcPermDimFilter = new QFilter("1", "=", (Object)1);
        QFilter dataRuleFilter = new QFilter("1", "=", (Object)1);
        QFilter opRuleFilter = new QFilter("1", "=", (Object)1);
        QFilter tempDimFilter = PermFilterUtil.getHasPermDimFilter(userId, appId, entityNum);
        if (tempDimFilter != null) {
            funcPermDimFilter = tempDimFilter;
        }
        if ((tempDataRuleFilter = permServ.getDataPermWithOrg(userId, appId, entityNum)) != null) {
            dataRuleFilter = tempDataRuleFilter;
        }
        if ((tempOpRuleFilter = permServ.getOperationRuleFilter(userId, appId, entityNum, viewOpKey = "view", null)) != null) {
            opRuleFilter = tempOpRuleFilter;
        }
        finalFilter = funcPermDimFilter.and(dataRuleFilter).and(opRuleFilter);
        return finalFilter;
    }

    private static QFilter getHasPermDimFilter(Long userId, String appId, String entityNum) {
        QFilter resultFilter = null;
        boolean needDimCtrl = PermCommonUtil.needDimControl((String)entityNum);
        if (!needDimCtrl) {
            return null;
        }
        PermissionServiceImpl permServ = new PermissionServiceImpl();
        String viewPermId = "47150e89000000ac";
        HasPermDimObjResult hasPermDimObjs = permServ.getHasPermDimObjs(userId, appId, entityNum, viewPermId);
        if (hasPermDimObjs.hasAllDimObjPerm()) {
            return null;
        }
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNum);
        String firstDimFieldKey = PermCommonUtil.getCheckPermDimObjFieldKey((MainEntityType)met, (String)"1");
        String secDimFieldKey = PermCommonUtil.getCheckPermDimObjFieldKey((MainEntityType)met, (String)"2");
        if (StringUtils.isNotEmpty((String)firstDimFieldKey)) {
            List hasPermDimObjIds = hasPermDimObjs.getHasPermDimObjs();
            resultFilter = new QFilter(firstDimFieldKey, "in", (Object)hasPermDimObjIds);
            if (StringUtils.isNotEmpty((String)secDimFieldKey)) {
                resultFilter = resultFilter.or(new QFilter(secDimFieldKey, "in", (Object)hasPermDimObjIds));
            }
        }
        return resultFilter;
    }

    private static AbstractPermissionServiceImpl getPermissionService() {
        return (AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null);
    }

    public static QFilter getDimTypeUserDataQfilter(Map<String, Object> paramMap) {
        if (null == paramMap) {
            return null;
        }
        Object dimTypeFieldObj = paramMap.get("dimTypeField");
        if (null == dimTypeFieldObj) {
            return null;
        }
        Object dimIdFieldObj = paramMap.get("dimIdField");
        if (null == dimIdFieldObj) {
            return null;
        }
        Object userFieldObj = paramMap.get("userField");
        if (null == userFieldObj) {
            return null;
        }
        boolean enableJustShowAdminCharged = null == paramMap.get("enableJustShowAdminCharged") ? PermCommonUtil.isEnableJustShowAdminCharged() : (Boolean)paramMap.get("enableJustShowAdminCharged");
        String dimTypeField = (String)dimTypeFieldObj;
        String dimIdField = (String)dimIdFieldObj;
        String userField = (String)userFieldObj;
        QFilter dimTypeDataQfilter = null;
        if (enableJustShowAdminCharged) {
            UserScopeResult adminChargeUser;
            long currUserId = RequestContext.get().getCurrUserId();
            HasPermOrgResult adminChargeOrgAndBizUnit = PermFilterUtil.getPermissionService().getAdminChargeOrgAndBizUnit(currUserId);
            if (!adminChargeOrgAndBizUnit.hasAllOrgPerm()) {
                List hasPermOrgs = adminChargeOrgAndBizUnit.getHasPermOrgs();
                dimTypeDataQfilter = new QFilter(dimTypeField, "=", (Object)"bos_org");
                dimTypeDataQfilter.and(new QFilter(dimIdField, "in", new HashSet(hasPermOrgs)));
            }
            if (!(adminChargeUser = PermFilterUtil.getPermissionService().getAdminChargeUser(currUserId, false)).isAllUser()) {
                List chargeUserList = adminChargeUser.getUserIDs();
                if (null == dimTypeDataQfilter) {
                    dimTypeDataQfilter = new QFilter(userField, "in", new HashSet(chargeUserList));
                } else {
                    dimTypeDataQfilter.and(new QFilter(userField, "in", new HashSet(chargeUserList)));
                }
            }
            if (null != dimTypeDataQfilter) {
                dimTypeDataQfilter.or(new QFilter(dimTypeField, "!=", (Object)"bos_org"));
            }
        }
        return dimTypeDataQfilter;
    }

    public static QFilter getAdminChargeUserQfilter(Map<String, Object> paramMap) {
        if (null == paramMap) {
            return null;
        }
        Object userFieldObj = paramMap.get("userField");
        if (null == userFieldObj) {
            return null;
        }
        boolean enableJustShowAdminCharged = null == paramMap.get("enableJustShowAdminCharged") ? PermCommonUtil.isEnableJustShowAdminCharged() : (Boolean)paramMap.get("enableJustShowAdminCharged");
        String userField = (String)userFieldObj;
        QFilter qfilter = null;
        if (enableJustShowAdminCharged) {
            long currUserId = RequestContext.get().getCurrUserId();
            UserScopeResult adminChargeUser = PermFilterUtil.getPermissionService().getAdminChargeUser(currUserId, false);
            if (!adminChargeUser.isAllUser()) {
                List chargeUserList = adminChargeUser.getUserIDs();
                if (null == qfilter) {
                    qfilter = new QFilter(userField, "in", new HashSet(chargeUserList));
                }
            }
        }
        return qfilter;
    }

    public static QFilter getComRoleQfilter(Map<String, Object> paramMap) {
        QFilter adminGrpFilter;
        QFilter roleAppFilter;
        QFilter roleDimTypeFilter;
        if (null == paramMap) {
            return null;
        }
        Object roleIdFieldObj = paramMap.get("roleIdField");
        if (null == roleIdFieldObj) {
            return null;
        }
        String roleIdField = (String)roleIdFieldObj;
        QFilter finalFilter = null;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Map<String, QFilter> comRoleListCusFilterMap = PermFilterUtil.getComRoleListCusFilterMap(paramMap);
        QFilter excludeRoleNumFilter = comRoleListCusFilterMap.get("excludeRoleNumFilter");
        if (null != excludeRoleNumFilter) {
            filterList.add(excludeRoleNumFilter);
        }
        if (null != (roleDimTypeFilter = comRoleListCusFilterMap.get("roleDimTypeFilter"))) {
            filterList.add(roleDimTypeFilter);
        }
        if (null != (roleAppFilter = comRoleListCusFilterMap.get("roleAppFilter"))) {
            filterList.add(roleAppFilter);
        }
        if (null != (adminGrpFilter = comRoleListCusFilterMap.get("adminGrpFilter"))) {
            filterList.add(adminGrpFilter);
        }
        if (null == filterList || filterList.isEmpty()) {
            return finalFilter;
        }
        finalFilter = PermFilterUtil.filterList2Qfilter(roleIdField, finalFilter, filterList);
        return finalFilter;
    }

    private static Map<String, QFilter> getComRoleListCusFilterMap(Map<String, Object> paramMap) {
        String dimType = null == paramMap.get("dimType") ? "" : (String)paramMap.get("dimType");
        String filterAppNumsStr = null == paramMap.get("filterAppNumsStr") ? "" : (String)paramMap.get("filterAppNumsStr");
        HashMap<String, QFilter> comRoleListCusFilterMap = new HashMap<String, QFilter>(8);
        QFilter excludeRoleNumFilter = PermFilterUtil.addExcludeRoleFilter();
        comRoleListCusFilterMap.put("excludeRoleNumFilter", excludeRoleNumFilter);
        QFilter roleDimTypeFilter = PermFilterUtil.addDimTypeFilter(dimType);
        comRoleListCusFilterMap.put("roleDimTypeFilter", roleDimTypeFilter);
        QFilter roleAppFilter = PermFilterUtil.addAppFilter(filterAppNumsStr);
        comRoleListCusFilterMap.put("roleAppFilter", roleAppFilter);
        QFilter adminGrpFilter = PermFilterUtil.addAdminGrpFilter();
        comRoleListCusFilterMap.put("adminGrpFilter", adminGrpFilter);
        return comRoleListCusFilterMap;
    }

    private static QFilter addExcludeRoleFilter() {
        ArrayList<String> excludeRoleNumList = new ArrayList<String>();
        excludeRoleNumList.add("WFADMINS");
        QFilter filter = new QFilter("number", "not in", excludeRoleNumList);
        return filter;
    }

    private static QFilter addAdminGrpFilter() {
        boolean hasEnableOldAdmin = PermissionServiceHelper.hasEnableOldAdmin();
        if (hasEnableOldAdmin) {
            return null;
        }
        long curUserId = RequestContext.get().getCurrUserId();
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)curUserId);
        if (!isAdminUser) {
            return null;
        }
        List<String> hasViewPermComRoleIds = AdminGroupService.getHasViewPermComRoleIds(curUserId);
        if (hasViewPermComRoleIds == null) {
            return null;
        }
        if (!hasViewPermComRoleIds.isEmpty()) {
            return new QFilter("id", "in", hasViewPermComRoleIds);
        }
        return null;
    }

    private static QFilter addAppFilter(String filterAppNumsStr) {
        ArrayList<String> filterAppIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)filterAppNumsStr) && !filterAppNumsStr.equals("BASE") && !filterAppNumsStr.equals("SCP")) {
            if (filterAppNumsStr.contains(",")) {
                List<String> filterAppNums = Arrays.asList(filterAppNumsStr.split(","));
                for (String filterAppNum : filterAppNums) {
                    if (StringUtils.isEmpty((String)filterAppNum)) continue;
                    String filterAppId = AppHelper.getMetaAppInfo((String)filterAppNum.trim().toLowerCase()).getId();
                    filterAppIds.add(filterAppId);
                }
            } else {
                String filterAppId = AppHelper.getMetaAppInfo((String)filterAppNumsStr.toLowerCase()).getId();
                filterAppIds.add(filterAppId);
            }
            return new QFilter("bizdomain", "in", filterAppIds);
        }
        return null;
    }

    private static QFilter addDimTypeFilter(String dimType) {
        Set<Object> dimTypeSet = new HashSet(8);
        if (StringUtils.isNotEmpty((String)dimType)) {
            dimTypeSet = Arrays.stream(dimType.split(",")).collect(Collectors.toSet());
        }
        GetDimTypeIdResp dimTypeIdResp = PermCtrlTypeService.getDimTypeId(new GetDimTypeIdReq(dimType, dimTypeSet));
        Set dimTypeIdSet = dimTypeIdResp.getDimTypeIdSet();
        QFilter normalFilter = new QFilter("dimtypeid", "=", (Object)" ");
        QFilter dimtypeFilter = new QFilter("dimtypeid", "in", (Object)dimTypeIdSet);
        dimtypeFilter = dimtypeFilter.or(normalFilter);
        return dimtypeFilter;
    }

    public static QFilter getDimObjQfilter(Map<String, Object> paramMap) {
        boolean enableJustShowAdminCharged;
        if (null == paramMap) {
            return null;
        }
        Object dimObjIdField = paramMap.get("dimObjIdField");
        if (null == dimObjIdField) {
            return null;
        }
        QFilter qfilter = null;
        boolean bl = enableJustShowAdminCharged = null == paramMap.get("enableJustShowAdminCharged") ? PermCommonUtil.isEnableJustShowAdminCharged() : (Boolean)paramMap.get("enableJustShowAdminCharged");
        if (enableJustShowAdminCharged) {
            String dimObjIdFieldStr = (String)dimObjIdField;
            String dimType = null == paramMap.get("dimType") ? "bos_org" : (String)paramMap.get("dimType");
            Long currUserId = null == paramMap.get("userId") ? Long.valueOf(RequestContext.get().getCurrUserId()) : (Long)paramMap.get("userId");
            GetHasPermPermCtrlObjResp hasPermDimResult = PermCtrlTypeService.getAdminHasPermPermCtrlObj(new GetHasPermPermCtrlObjReq(dimType, currUserId, null, null));
            boolean hasAllDimPerm = hasPermDimResult.isHasAllDimPerm();
            Set hasPermDimSet = hasPermDimResult.getHasPermDimSet();
            if (hasAllDimPerm) {
                return qfilter;
            }
            if (null == qfilter) {
                qfilter = new QFilter(dimObjIdFieldStr, "in", hasPermDimSet.stream().map(Dim::getDimId).collect(Collectors.toSet()));
            }
        }
        return qfilter;
    }

    private static QFilter filterList2Qfilter(String roleIdField, QFilter finalFilter, List<QFilter> filterList) {
        if (null == filterList || filterList.isEmpty()) {
            return finalFilter;
        }
        for (int i = 0; i < filterList.size(); ++i) {
            QFilter qFilter = filterList.get(i);
            if (!Objects.equals("id", roleIdField)) {
                qFilter.__setProperty(roleIdField + "." + qFilter.getProperty());
                List nests = qFilter.getNests(true);
                if (null != nests && !nests.isEmpty()) {
                    for (QFilter.QFilterNest nest : nests) {
                        QFilter filter = nest.getFilter();
                        filter.__setProperty(roleIdField + "." + filter.getProperty());
                    }
                }
            }
            if (0 == i) {
                finalFilter = qFilter;
                continue;
            }
            finalFilter.and(qFilter);
        }
        return finalFilter;
    }
}

