/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.permission.util.BaseDataValidator;

public class PhoneI18nValidator
extends BaseDataValidator {
    private String format;
    private String store;
    private List<String> phoneList;

    public PhoneI18nValidator(String checkObj, boolean blankAble) {
        this(checkObj, blankAble, true);
    }

    public PhoneI18nValidator(String checkObj, boolean blankAble, boolean doCheck) {
        super(checkObj, ResManager.loadKDString((String)"\u201c\u624b\u673a\u201d", (String)"PhoneI18nValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), blankAble, doCheck);
    }

    public PhoneI18nValidator(List<String> phoneList) {
        super("", "", true, false);
        this.phoneList = phoneList;
    }

    @Override
    public void prepare() {
        this.formatPhone(this.checkObj);
    }

    private String formatPhone(String phone) {
        if (phone.startsWith("+")) {
            phone = phone.replace("+", "");
            phone = "+" + phone;
        } else {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        this.format = phone;
        this.store = phone.startsWith("+86-") ? phone.split("-")[1] : phone.substring(1);
        return this.store;
    }

    public String getFormattedPhone() {
        return this.format;
    }

    @Override
    public void check() {
        this.phoneList = Collections.singletonList(this.format);
        Map<String, String> resultMap = this.batchCheck();
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String message = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            throw new KDBizException(message);
        }
    }

    public String getStore() {
        return this.store;
    }

    public Map<String, String> batchCheck() {
        if (this.phoneList == null || this.phoneList.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> phoneResultMap = new HashMap<String, String>(this.phoneList.size());
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(this.phoneList);
        for (int i = 0; i < resultList.size() && this.phoneList.size() > i; ++i) {
            TelephoneVerifyResult item = (TelephoneVerifyResult)resultList.get(i);
            String error = null;
            if (!item.isParseSuccess()) {
                error = item.getParseErrorMsg();
            } else if (!item.isVerifySuccess()) {
                String message;
                Map result = item.getVerifyResult();
                String string = message = CollectionUtils.isEmpty((Map)result) ? "" : (String)result.get("message");
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    error = message;
                }
            }
            phoneResultMap.put(this.phoneList.get(i), error);
        }
        return phoneResultMap;
    }
}

