/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.permission.util.BaseDataValidator;

public class PhoneValidator
extends BaseDataValidator {
    public static final String AREA_CODE_CHINA = "86-";
    public static final String AREA_CODE_PLUS = "+";
    public static final String AREA_CODE_SPLIT = "-";
    public static final char AREA_CODE_SPLIT_CHAR = '-';
    public static final int MIN_LENGTH = 6;
    public static final int MAX_LENGTH = 11;

    public PhoneValidator(String checkObj, boolean blankAble) {
        super(checkObj, ResManager.loadKDString((String)"\u201c\u624b\u673a\u201d", (String)"PhoneValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), blankAble);
    }

    @Override
    public void prepare() {
        this.format();
    }

    private void format() {
        int count;
        if (StringUtils.isBlank((CharSequence)this.checkObj)) {
            this.checkObj = "";
        }
        this.checkObj = this.checkObj.replaceAll(" ", "");
        this.checkObj = this.checkObj.replace(AREA_CODE_PLUS, "");
        if (this.checkObj.startsWith(AREA_CODE_CHINA)) {
            this.checkObj = StringUtils.substringAfter((String)this.checkObj, (String)AREA_CODE_CHINA);
        }
        if ((count = this.checkObj.length() - this.checkObj.replace(AREA_CODE_SPLIT, "").length()) > 1) {
            this.checkObj = this.checkObj.endsWith(AREA_CODE_SPLIT) ? StringUtils.substringBeforeLast((String)this.checkObj, (String)AREA_CODE_SPLIT) : this.checkObj.replaceFirst(AREA_CODE_SPLIT, "");
        }
    }

    public String getFormattedPhone() {
        return this.checkObj;
    }

    @Override
    public void check() {
        this.verifyCharacter();
        this.verifyFormat();
    }

    private void verifyCharacter() {
        Pattern pattern = Pattern.compile("^(?!-)(?!.*?-$)[0-9-]+$");
        Matcher matcher = pattern.matcher(this.checkObj);
        if (!matcher.matches()) {
            throw new KDBizException(UserMessage.getMessage((String)"M00006"));
        }
    }

    private void verifyFormat() {
        boolean isValid = true;
        if (this.checkObj.indexOf(45) == -1) {
            isValid = StringUtils.isPhoneNumberValid((String)this.checkObj);
        } else {
            int codeNumber = StringUtils.substringBefore((String)this.checkObj, (String)Character.toString('-')).length();
            if (codeNumber > 4) {
                throw new KDBizException(UserMessage.getMessage((String)"M00007"));
            }
            int phoneNumber = this.checkObj.length() - codeNumber - 1;
            if (phoneNumber < 6 || phoneNumber > 11) {
                throw new KDBizException(UserMessage.getMessage((String)"M00008", (Object[])new Object[]{6, 11}));
            }
        }
        if (!isValid) {
            throw new KDBizException(UserMessage.getMessage((String)"M00009"));
        }
    }
}

