/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.PublicKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.context.RequestContext;
import kd.bos.crypto.AlgorithmDesc;
import kd.bos.crypto.MultiEncrypters;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.SchemeDataProcessingResult;
import kd.bos.permission.task.scheme.DataProcessingTask;
import kd.bos.permission.task.scheme.TaskContext;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.session.SHAUtils;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;

public class SchemeUtil {
    private static final Log LOG = LogFactory.getLog(SchemeUtil.class);
    private static final int DEF_THREAD_COUNT = 10;
    private static final int MAX_THREAD_COUNT = 1000;
    private static ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"EncryptionSchemeDataProcessingPool", (int)10, (int)1000);
    private static final String CACHE_KMS_KEY = "kms_key";
    private static final String CACHE_PUBLIC_KEY = "public_key";
    private static final String CACHE_WORK_KEY = "work_key";
    private static final String CACHE_ENCRYPTION_SCHEME = "encryptionScheme";
    private static final String CODE_SUCCESS = "100";
    private static final String KEY_SYSTEM_TYPE = "bos-mservice-permission";

    public static boolean checkSchemeEnable(long schemeId) {
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        filter.and("enable", "=", (Object)"1");
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_encryptionscheme", (String)"id", (QFilter[])filter.toArray());
        return scheme != null;
    }

    public static long addNewScheme(String schemeNumber, String schemeName, String algorithm, String length) {
        String sql = "SELECT FID FROM T_PERM_ENCRYPTIONSCHEME WHERE FNUMBER = ?";
        long schemeId = (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeNumber}, rh -> {
            long id = 0L;
            if (rh.next()) {
                id = rh.getLong("FID");
            }
            return id;
        });
        if (schemeId != 0L) {
            return schemeId;
        }
        sql = "INSERT INTO T_PERM_ENCRYPTIONSCHEME (FID, FALGORITHM, FLENGTH, FNUMBER, FNAME, FENABLE, FCREATORID, FCREATETIME, FISSYSTEM) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
        ArrayList<Object> params = new ArrayList<Object>(9);
        schemeId = DB.genLongId((String)"T_PERM_ENCRYPTIONSCHEME");
        params.add(schemeId);
        params.add(algorithm);
        params.add(length);
        params.add(schemeNumber);
        params.add(schemeName);
        params.add("1");
        params.add(1);
        params.add(TimeServiceHelper.now());
        params.add("1");
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray());
        return schemeId;
    }

    public static void error(JSONObject result, String message) {
        result.put("success", (Object)false);
        result.put("description", (Object)message);
        result.put("data", (Object)"");
    }

    public static void success(JSONObject result, String message, Object data) {
        result.put("success", (Object)true);
        result.put("description", (Object)message);
        result.put("data", data);
    }

    public static void error(SchemeDataProcessingResult result, String message) {
        result.setSuccess(false);
        result.setDescription(message);
        result.setData(null);
    }

    public static void success(SchemeDataProcessingResult result, String message, Map<String, List<PrivacyDataModel>> data) {
        result.setSuccess(true);
        result.setDescription(message);
        result.setData(data);
    }

    public static List<DynamicObject> getSchemes() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("number", "!=", (Object)"LICENCE-SIGNATURE");
        Map data = BusinessDataServiceHelper.loadFromCache((String)"perm_encryptionscheme", (String)"id, number, name", (QFilter[])filter.toArray());
        return new ArrayList<DynamicObject>(data.values());
    }

    public static Map<String, List<Integer>> getSupportAlgorithms() {
        HashMap<String, List<Integer>> supports = new HashMap<String, List<Integer>>(0);
        List algorithms = MultiEncrypters.getAllAlgorithm();
        for (AlgorithmDesc algorithm : algorithms) {
            String transformation = algorithm.getTransformation();
            supports.put(transformation, algorithm.getSupport());
        }
        return supports;
    }

    public static EncryptionScheme getEncryptionScheme(long schemeId) {
        String strSchemeId;
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_ENCRYPTION_SCHEME);
        if (cache.contains(strSchemeId = String.valueOf(schemeId))) {
            return (EncryptionScheme)cache.get(strSchemeId);
        }
        String sql = " select fid, fnumber, fname, falgorithm, flength, fschemekey from t_perm_encryptionscheme where fid = ? ";
        try (DataSet data = DB.queryDataSet((String)"getEncryptionSchemeById", (DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeId});){
            if (data == null || data.isEmpty()) {
                EncryptionScheme encryptionScheme = null;
                return encryptionScheme;
            }
            Row row = data.next();
            EncryptionScheme scheme = new EncryptionScheme();
            scheme.setPkId(row.getLong("fid").longValue());
            scheme.setNumber(row.getString("fnumber"));
            scheme.setName(row.getString("fname"));
            scheme.setAlgorithm(row.getString("falgorithm"));
            scheme.setLength(Integer.parseInt(row.getString("flength")));
            scheme.setSchemeKey(row.getString("fschemekey"));
            cache.put(strSchemeId, (Object)scheme);
            EncryptionScheme encryptionScheme = scheme;
            return encryptionScheme;
        }
    }

    public static EncryptionScheme getEncryptionScheme(String schemeNumber) {
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_ENCRYPTION_SCHEME);
        if (cache.contains(schemeNumber)) {
            return (EncryptionScheme)cache.get(schemeNumber);
        }
        String sql = " select fid, fnumber, fname, falgorithm, flength, fschemekey from t_perm_encryptionscheme where fnumber = ?";
        try (DataSet data = DB.queryDataSet((String)"getEncryptionSchemeByNumber", (DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeNumber});){
            if (data == null || data.isEmpty()) {
                EncryptionScheme encryptionScheme = null;
                return encryptionScheme;
            }
            Row row = data.next();
            EncryptionScheme scheme = new EncryptionScheme();
            scheme.setPkId(row.getLong("fid").longValue());
            scheme.setNumber(row.getString("fnumber"));
            scheme.setName(row.getString("fname"));
            scheme.setAlgorithm(row.getString("falgorithm"));
            scheme.setLength(Integer.parseInt(row.getString("flength")));
            scheme.setSchemeKey(row.getString("fschemekey"));
            cache.put(schemeNumber, (Object)scheme);
            EncryptionScheme encryptionScheme = scheme;
            return encryptionScheme;
        }
    }

    public static void updateSchemeCache(String schemeId, String schemeNumber, String schemeKey) {
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_ENCRYPTION_SCHEME);
        cache.remove(new String[]{schemeId});
        cache.remove(new String[]{schemeNumber});
    }

    public static void resetPublicKeyCache() {
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_PUBLIC_KEY);
        cache.remove(new String[]{CACHE_PUBLIC_KEY});
    }

    public static JSONObject dataProcessing(String workKey, String algorithm, int length, String bizData, boolean isEncrypt) {
        JSONObject result = new JSONObject();
        try {
            String message;
            String data;
            if (StringUtils.isBlank((CharSequence)workKey)) {
                SchemeUtil.error(result, ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeUtil_0", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
                return result;
            }
            if (isEncrypt) {
                data = MultiEncrypters.encrypt((String)algorithm, (String)workKey, (int)length, (String)bizData);
                message = ResManager.loadKDString((String)"\u52a0\u5bc6\u6210\u529f", (String)"SchemeUtil_1", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]);
            } else {
                data = MultiEncrypters.decrypt((String)algorithm, (String)workKey, (int)length, (String)bizData);
                message = ResManager.loadKDString((String)"\u89e3\u5bc6\u6210\u529f", (String)"SchemeUtil_2", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]);
            }
            SchemeUtil.success(result, message, data);
        }
        catch (Exception ex) {
            String title = isEncrypt ? "Encrypt error" : "Decrypt error";
            LOG.warn(title, (Throwable)ex);
            SchemeUtil.error(result, ex.getMessage());
        }
        return result;
    }

    public static void dataProcessing(String workKey, String algorithm, int length, List<PrivacyDataModel> bizData, boolean isEncrypt) {
        if (StringUtils.isBlank((CharSequence)workKey)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeUtil_0", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String tag = isEncrypt ? ResManager.loadKDString((String)"\u52a0\u5bc6", (String)"SchemeUtil_3", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u89e3\u5bc6", (String)"SchemeUtil_4", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]);
        TaskContext context = new TaskContext(algorithm, workKey, length, isEncrypt);
        int dataCount = bizData.size();
        int threadCount = 10;
        int threadSize = dataCount / threadCount + 1;
        List<PrivacyDataModel> data = Collections.synchronizedList(bizData);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        boolean isEnd = false;
        for (int i = 0; i < threadCount && !isEnd; ++i) {
            int start = threadSize * i;
            int end = threadSize * (i + 1);
            if (end == 0 || end >= dataCount) {
                end = dataCount;
                isEnd = true;
            }
            DataProcessingTask task = new DataProcessingTask(context, data, start, end);
            task.setCipher(MultiEncrypters.getCipher((String)context.getAlgorithm()));
            CompletableFuture<Void> future = CompletableFuture.runAsync(task::process, EXECUTOR_SERVICE);
            futures.add(future);
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)allFutures.whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.warn("EncryptionSchemeDataProcessing error", ex);
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"SchemeUtil_5", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), tag));
            }
        })).join();
    }

    public static JSONObject generateSignature(String data, long schemeId) {
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme(schemeId);
        return SchemeUtil.generateSignature(data, scheme, false);
    }

    public static JSONObject generateSignature(String data, String schemeNumber) {
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme(schemeNumber);
        return SchemeUtil.generateSignature(data, scheme, true);
    }

    public static JSONObject generateSignature(String data, String tenantId, String accountId) {
        String publicK = SchemeUtil.getPublicKeyFromMC(tenantId, accountId);
        if (StringUtils.isBlank((CharSequence)publicK)) {
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u516c\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"SchemeUtil_6", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
        String schemeKey = SchemeUtil.getCorrectSchemeKey(accountId, tenantId);
        if (StringUtils.isBlank((CharSequence)schemeKey)) {
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6FSchemeKey\u5931\u8d25\u3002", (String)"SchemeUtil_7", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey((String)publicK);
            String workKeyId = RSAEncrypterUtil.decrypt((String)schemeKey, (PublicKey)publicKey);
            String property = SchemeUtil.getPropertyFromZk(tenantId, accountId);
            String workKey = SchemeUtil.getWorkKey(property, workKeyId, publicKey);
            JSONObject result = new JSONObject();
            SchemeUtil.generateSignature(data, result, workKey);
            return result;
        }
        catch (Exception ex) {
            LOG.warn(ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25", (String)"SchemeUtil_27", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)ex);
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"SchemeUtil_8", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
    }

    public static JSONObject generateSignature(Map<String, String> data, long schemeId) {
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme(schemeId);
        return SchemeUtil.generateSignature(data, scheme, false);
    }

    public static JSONObject generateSignature(Map<String, String> data, String schemeNumber) {
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme(schemeNumber);
        return SchemeUtil.generateSignature(data, scheme, true);
    }

    public static JSONObject generateSignature(Map<String, String> data, String tenantId, String accountId) {
        String publicK = SchemeUtil.getPublicKeyFromMC(tenantId, accountId);
        if (StringUtils.isBlank((CharSequence)publicK)) {
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u516c\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"SchemeUtil_6", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
        String schemeKey = SchemeUtil.getCorrectSchemeKey(accountId, tenantId);
        if (StringUtils.isBlank((CharSequence)schemeKey)) {
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6FSchemeKey\u5931\u8d25\u3002", (String)"SchemeUtil_7", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey((String)publicK);
            String workKeyId = RSAEncrypterUtil.decrypt((String)schemeKey, (PublicKey)publicKey);
            String property = SchemeUtil.getPropertyFromZk(tenantId, accountId);
            String workKey = SchemeUtil.getWorkKey(property, workKeyId, publicKey);
            JSONObject result = new JSONObject();
            SchemeUtil.generateSignature(data, result, workKey);
            return result;
        }
        catch (Exception ex) {
            LOG.warn(ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25", (String)"SchemeUtil_27", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)ex);
            throw new KDException(BosErrorCode.findPropertyFailed, new Object[]{ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"SchemeUtil_8", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])});
        }
    }

    public static void updateSchemeKey(long schemeId, String schemeKey) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                String sql = "update t_perm_encryptionscheme set fschemekey = ? where fid = ?;";
                Object[] params = new Object[]{schemeKey, schemeId};
                DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
            }
            catch (Exception ex) {
                handle.markRollback();
                String msg = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u52a0\u5bc6\u65b9\u6848\u3010%1$s\u3011schemeKey\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"SchemeUtil_9", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), schemeId, ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                LOG.warn(msg);
            }
        }
    }

    public static String getPublicKey() {
        return SchemeUtil.getPublicKey(true);
    }

    public static String getPublicKey(boolean isSelectFromDb) {
        String publicKey;
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_PUBLIC_KEY);
        if (cache.contains(CACHE_PUBLIC_KEY) && StringUtils.isNotBlank((CharSequence)(publicKey = String.valueOf(cache.get(CACHE_PUBLIC_KEY))))) {
            return publicKey;
        }
        if (isSelectFromDb && StringUtils.isNotBlank((CharSequence)(publicKey = SchemeUtil.getPublicKeyFromDb()))) {
            cache.put(CACHE_PUBLIC_KEY, (Object)publicKey);
            return publicKey;
        }
        RequestContext context = RequestContext.get();
        publicKey = SchemeUtil.getPublicKeyFromMC(context.getTenantId(), context.getAccountId());
        if (StringUtils.isNotBlank((CharSequence)publicKey)) {
            cache.put(CACHE_PUBLIC_KEY, (Object)publicKey);
            if (isSelectFromDb) {
                SchemeUtil.insertPublicKeyIntoDb(publicKey);
            }
            return publicKey;
        }
        return "";
    }

    public static String getPublicKeyFromMC(String tenantId, String accountId) {
        JSONObject data;
        String accessToken;
        String suffix = "/kapi/app/mc/generatePublicKey";
        JSONObject params = SchemeUtil.createPostParams(tenantId, accountId);
        JSONObject result = SchemeUtil.postMc(suffix, params, accessToken = SchemeUtil.getMcAccessToken());
        boolean isSuccess = result.getBoolean("success");
        if (isSuccess && (data = result.getJSONObject("data")) != null) {
            return data.getString("publicKey");
        }
        return "";
    }

    public static String getPublicKeyFromDb() {
        return PermCommonUtil.getKmsPublicKey();
    }

    public static void resetPublicKeyIntoDb() {
        PermCommonUtil.saveKmsPublicKey((String)"");
    }

    private static void insertPublicKeyIntoDb(String publicKey) {
        PermCommonUtil.saveKmsPublicKey((String)publicKey);
    }

    public static void deployDataKeyByMC(String tenantId, long dcId) {
        JSONObject params = new JSONObject();
        params.put("tenantId", (Object)tenantId);
        params.put("dcId", (Object)dcId);
        String accessToken = SchemeUtil.getMcAccessToken();
        String suffix = "/kapi/v2/mc/webClient/deployDataKey";
        JSONObject result = SchemeUtil.postMc(suffix, params, accessToken);
        boolean status = result.getBooleanValue("status");
        if (!status) {
            LOG.warn("\u53d1\u5e03\u5bc6\u94a5\u5f02\u5e38", (Object)result.getString("message"));
        }
    }

    public static JSONObject getSchemeKey(EncryptionScheme scheme, String publicKey) {
        JSONObject result = new JSONObject();
        try {
            if (StringUtils.isBlank((CharSequence)publicKey)) {
                throw new KDException(new ErrorCode("0", ResManager.loadKDString((String)"\u516c\u94a5\u4e3a\u7a7a", (String)"SchemeUtil_10", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
            }
            String schemeId = String.valueOf(scheme.getPkId());
            String encryptSchemeId = RSAEncrypterUtil.encrypt((String)schemeId, (PublicKey)RSAEncrypterUtil.getPublicKey((String)publicKey));
            JSONObject info = SchemeUtil.getSchemeKey(encryptSchemeId, scheme);
            boolean isSuccess = info.getBoolean("success");
            if (isSuccess) {
                JSONObject data = info.getJSONObject("data");
                SchemeUtil.success(result, "", data.getString("dataKeyId"));
            } else {
                SchemeUtil.error(result, info.getString("description"));
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u4f5c\u5bc6\u94a5\u52a0\u5bc6id\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"SchemeUtil_19", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u4f5c\u5bc6\u94a5id\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7", (String)"SchemeUtil_11", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return result;
    }

    public static String getCorrectSchemeKey(String accountId, String tenantId) {
        String schemeKey = "";
        Account account = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            String sql = "select fschemekey from t_perm_encryptionscheme where fnumber = 'LICENCE-SIGNATURE'";
            statement = conn.prepareStatement(sql);
            rs = statement.executeQuery();
            if (rs.next()) {
                schemeKey = rs.getString("fschemekey");
            }
        }
        catch (Exception ex) {
            try {
                LOG.warn((Throwable)ex);
                throw new KDException((Throwable)ex, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return schemeKey;
    }

    public static String getWorkKey(long schemeId, String publicK, String schemeKey) {
        String workKey;
        String cacheKey;
        LocalMemoryCache cache = SchemeUtil.getLocalMemoryCache(CACHE_WORK_KEY);
        if (cache.contains(cacheKey = "work_key_" + schemeId) && StringUtils.isNotBlank((CharSequence)(workKey = String.valueOf(cache.get(cacheKey))))) {
            return workKey;
        }
        try {
            String property;
            String workKey2;
            if (StringUtils.isBlank((CharSequence)publicK)) {
                throw new KDException(new ErrorCode("0", ResManager.loadKDString((String)"\u516c\u94a5\u4e3a\u7a7a", (String)"SchemeUtil_10", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
            }
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey((String)publicK);
            LocalMemoryCache kmsCache = SchemeUtil.getLocalMemoryCache(CACHE_KMS_KEY);
            String workKeyId = RSAEncrypterUtil.decrypt((String)schemeKey, (PublicKey)publicKey);
            if (kmsCache.contains(CACHE_KMS_KEY) && StringUtils.isNotBlank((CharSequence)(workKey2 = SchemeUtil.getWorkKey(property = String.valueOf(kmsCache.get(CACHE_KMS_KEY)), workKeyId, publicKey)))) {
                cache.put(cacheKey, (Object)workKey2);
                return workKey2;
            }
            property = System.getProperty("kms.key");
            if (property != null) {
                kmsCache.put(CACHE_KMS_KEY, (Object)property);
                workKey2 = SchemeUtil.getWorkKey(property, workKeyId, publicKey);
                if (StringUtils.isNotBlank((CharSequence)workKey2)) {
                    cache.put(cacheKey, (Object)workKey2);
                    return workKey2;
                }
            }
            RequestContext context = RequestContext.get();
            property = SchemeUtil.getPropertyFromZk(context.getTenantId(), context.getAccountId());
            kmsCache.put(CACHE_KMS_KEY, (Object)property);
            workKey2 = SchemeUtil.getWorkKey(property, workKeyId, publicKey);
            if (StringUtils.isNotBlank((CharSequence)workKey2)) {
                cache.put(cacheKey, (Object)workKey2);
            }
            return workKey2;
        }
        catch (Exception ex) {
            LOG.warn(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"SchemeUtil_20", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            return "";
        }
    }

    private static String getWorkKey(String property, String workKeyId, PublicKey publicKey) {
        String key;
        String workKey = "";
        JSONObject data = JSON.parseObject((String)property);
        if (data != null && data.containsKey((Object)workKeyId) && StringUtils.isNotBlank((CharSequence)(key = data.getString(workKeyId)))) {
            try {
                workKey = RSAEncrypterUtil.decrypt((String)key, (PublicKey)publicKey);
            }
            catch (Exception ex) {
                workKey = key;
            }
        }
        return workKey;
    }

    private static LocalMemoryCache getLocalMemoryCache(String typePrefix) {
        String type = SchemeUtil.getType(typePrefix);
        CacheConfigInfo config = new CacheConfigInfo();
        config.setTimeout(86400);
        config.setMaxItemSize(500);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("perm_encryptionscheme", type, config);
    }

    private static JSONObject createPostParams() {
        RequestContext ctx = RequestContext.get();
        String accountId = ctx.getAccountId();
        String tenantId = ctx.getTenantId();
        return SchemeUtil.createPostParams(tenantId, accountId);
    }

    private static JSONObject createPostParams(String tenantId, String accountId) {
        JSONObject params = new JSONObject();
        params.put("dcId", (Object)accountId);
        params.put("tenantId", (Object)tenantId);
        return params;
    }

    private static JSONObject generateSignature(String data, EncryptionScheme scheme, boolean isSelectFromDb) {
        JSONObject result = new JSONObject();
        if (data == null) {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u8bf7\u63d0\u4f9b\u6b63\u786e\u7684\u6570\u636e", (String)"SchemeUtil_12", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
            return result;
        }
        String workKey = SchemeUtil.signatureValidate(isSelectFromDb, scheme, result);
        if (StringUtils.isBlank((CharSequence)workKey)) {
            return result;
        }
        SchemeUtil.generateSignature(data, result, workKey);
        return result;
    }

    private static JSONObject generateSignature(Map<String, String> data, EncryptionScheme scheme, boolean isSelectFromDb) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u8bf7\u63d0\u4f9b\u6b63\u786e\u7684\u6570\u636e", (String)"SchemeUtil_12", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
            return result;
        }
        String workKey = SchemeUtil.signatureValidate(isSelectFromDb, scheme, result);
        if (StringUtils.isBlank((CharSequence)workKey)) {
            return result;
        }
        SchemeUtil.generateSignature(data, result, workKey);
        return result;
    }

    private static void generateSignature(String data, JSONObject result, String workKey) {
        String sign = SHAUtils.getSHA256StrJava((String)(data + "&key=" + workKey));
        if (StringUtils.isNotBlank((CharSequence)sign)) {
            SchemeUtil.success(result, ResManager.loadKDString((String)"\u7b7e\u540d\u6210\u529f", (String)"SchemeUtil_13", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), sign);
        } else {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25", (String)"SchemeUtil_14", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private static void generateSignature(Map<String, String> data, JSONObject result, String workKey) {
        HashMap<String, String> info = new HashMap<String, String>(data.size());
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                info.put(key, "");
                continue;
            }
            String sign = SHAUtils.getSHA256StrJava((String)("group=" + key + "&value=" + value + "&key=" + workKey));
            info.put(key, sign);
        }
        SchemeUtil.success(result, ResManager.loadKDString((String)"\u7b7e\u540d\u5b8c\u6210", (String)"SchemeUtil_15", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), info);
    }

    private static JSONObject postMc(String suffix, JSONObject params, String accessToken) {
        JSONObject result = new JSONObject();
        try {
            JSONObject returnResult;
            String host = System.getProperty("mc.server.url");
            String url = host + suffix;
            LOG.debug(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u8bf7\u6c42url\uff1a%1$s", (String)"SchemeUtil_22", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), url));
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("Content-type", "application/json;charset=UTF-8");
            header.put("access_token", accessToken);
            header.put("api", "true");
            header.put("accessToken", accessToken);
            String param = JSON.toJSONString((Object)params);
            LOG.debug(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u8bf7\u6c42%1$s\u53c2\u6570\uff1a%2$s", (String)"SchemeUtil_23", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), suffix, param));
            String response = HttpClientUtils.postjson((String)url, header, (String)param);
            LOG.debug(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u8bf7\u6c42%1$s\u8fd4\u53c2\uff1a%2$s", (String)"SchemeUtil_24", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), suffix, response));
            if (StringUtils.isNotBlank((CharSequence)response) && (returnResult = JSON.parseObject((String)response)) != null) {
                boolean isSuccess = returnResult.getBoolean("success");
                String errorCode = returnResult.getString("errorcode");
                if (!isSuccess || !StringUtils.equals((CharSequence)errorCode, (CharSequence)CODE_SUCCESS)) {
                    String description = returnResult.getString("description");
                    SchemeUtil.error(result, description);
                } else {
                    JSONObject data = returnResult.getJSONObject("data");
                    SchemeUtil.success(result, "", data);
                }
            }
        }
        catch (IOException e) {
            LOG.warn(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u8bf7\u6c42%1$s\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"SchemeUtil_21", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), suffix, e.getMessage()));
        }
        return result;
    }

    private static String signatureValidate(boolean isSelectFromDb, EncryptionScheme scheme, JSONObject result) {
        String workKey;
        if (scheme == null) {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u52a0\u5bc6\u65b9\u6848", (String)"SchemeUtil_16", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
            return "";
        }
        String publicKey = SchemeUtil.getPublicKey(isSelectFromDb);
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u83b7\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7", (String)"SchemeUtil_17", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
            return "";
        }
        long schemeId = scheme.getPkId();
        String schemeKey = scheme.getSchemeKey();
        if (StringUtils.isBlank((CharSequence)schemeKey)) {
            JSONObject info = SchemeUtil.getSchemeKey(scheme, publicKey);
            boolean isSuccess = info.getBoolean("success");
            if (!isSuccess) {
                SchemeUtil.error(result, info.getString("description"));
                return "";
            }
            schemeKey = info.getString("data");
            SchemeUtil.updateSchemeKey(schemeId, schemeKey);
            SchemeUtil.updateSchemeCache(String.valueOf(schemeId), scheme.getNumber(), schemeKey);
        }
        if (StringUtils.isBlank((CharSequence)(workKey = SchemeUtil.getWorkKey(schemeId, publicKey, schemeKey)))) {
            SchemeUtil.error(result, ResManager.loadKDString((String)"\u5de5\u4f5c\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeUtil_0", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
            return "";
        }
        return workKey;
    }

    private static String getMcAccessToken() {
        JSONObject params = new JSONObject();
        params.put("accountId", (Object)"");
        params.put("tenantId", (Object)"");
        String host = System.getProperty("mc.server.url");
        String suffix = "/api/upgradeLogin.do";
        try {
            LOG.debug(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42token\u7684url\uff1a%1$s", (String)"SchemeUtil_26", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), host + suffix));
            String data = HttpClientUtils.postjson((String)(host + suffix), null, (String)JSON.toJSONString((Object)params));
            JSONObject jsonData = JSON.parseObject((String)data);
            return jsonData.getJSONObject("data").getString("access_token");
        }
        catch (Exception ex) {
            LOG.warn(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"SchemeUtil_25", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]), ex.getMessage()));
            return "";
        }
    }

    private static String getPropertyFromZk(String tenantId, String accountId) {
        String property = SchemeUtil.getPropertyFromZk();
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return property;
        }
        try {
            SchemeUtil.deployDataKeyByMC(tenantId, Long.parseLong(accountId));
            return SchemeUtil.getPropertyFromZk();
        }
        catch (Exception ex) {
            LOG.warn("deployDataKeyByMC failed", (Throwable)ex);
            return "";
        }
    }

    private static String getPropertyFromZk() {
        String url = SystemProperties.getWithEnv((String)"configUrl");
        String path = ZKFactory.getZkRootPath((String)url) + Instance.getClusterName() + "/config/common/prop";
        Configuration configuration = ConfigurationFactory.getConfigurationByPath((String)path);
        configuration.keys();
        String property = configuration.getProperty("kms.properties");
        return property.substring(property.indexOf("{"));
    }

    private static JSONObject getSchemeKey(String encryptSchemeId, EncryptionScheme scheme) {
        JSONObject params = SchemeUtil.createPostParams();
        params.put("schemaId", (Object)encryptSchemeId);
        params.put("keySize", (Object)scheme.getLength());
        String source = scheme.getSource();
        if (!StringUtils.equals((CharSequence)source, (CharSequence)"0")) {
            params.put("isTrust", (Object)true);
            params.put("trustDataKey", (Object)scheme.getTrustDataKey());
        }
        String accessToken = SchemeUtil.getMcAccessToken();
        String suffix = "/kapi/app/mc/generateDataKey";
        return SchemeUtil.postMc(suffix, params, accessToken);
    }

    private static String getType(String typePrefix) {
        String accountId = CacheKeyUtil.getAcctId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"SchemeUtil_18", (String)KEY_SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return typePrefix + "_result_" + accountId;
    }

    private static int getThreadSize() {
        int threadSize;
        try {
            DynamicObject param = ParameterReader.getBillParameter((String)"perm_encryptionscheme");
            threadSize = Math.max(param.getInt("thread_size"), 5000);
        }
        catch (Exception ex) {
            LOG.warn("SchemeUtil.getThreadSize error", (Throwable)ex);
            threadSize = 5000;
        }
        return threadSize;
    }
}

