/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.api.customtable.model;

import com.kingdee.bos.qing.api.customtable.model.FieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComplexFieldData
extends FieldData<String, String> {
    private List<FieldData> innerFieldDatas;
    private Map<String, Integer> fieldIndex = new HashMap<String, Integer>(16);

    public ComplexFieldData(FieldType fieldType, String rawFieldName, String qingFieldName, String rawValue, List<FieldData> innerFieldDatas) {
        super(rawFieldName, qingFieldName, rawValue);
        this.setFieldType(fieldType);
        this.innerFieldDatas = innerFieldDatas;
        int index = 0;
        for (FieldData fieldData : innerFieldDatas) {
            this.fieldIndex.put(fieldData.getRawFieldName(), index);
            ++index;
        }
    }

    public void setInnerFieldData(String fieldKey, Object value) {
        Integer colIndex = this.fieldIndex.get(fieldKey);
        if (null == colIndex) {
            throw new IllegalStateException("field not exist:" + fieldKey);
        }
        this.innerFieldDatas.get(colIndex).changeData(value);
    }

    public void setInnerFieldDataIgnoreUnExist(String fieldKey, Object value) {
        Integer colIndex = this.fieldIndex.get(fieldKey);
        if (null == colIndex) {
            return;
        }
        this.innerFieldDatas.get(colIndex).changeData(value);
    }

    @Override
    public String getRawValue() {
        return (String)super.getRawValue();
    }

    public List<FieldData> getInnerFieldDatas() {
        return Collections.unmodifiableList(this.innerFieldDatas);
    }

    @Override
    public void flushToMap(Map<String, Object> target) {
        target.put(this.getQingFieldName(), this.isDirty() ? this.getChangedValue() : this.getRawValue());
        for (FieldData fieldData : this.innerFieldDatas) {
            fieldData.flushToMap(target);
        }
    }

    @Override
    public void bindRawValue(String rawValue) {
        super.bindRawValue(rawValue);
        if (null == rawValue) {
            for (FieldData fieldData : this.innerFieldDatas) {
                fieldData.bindRawValue(null);
            }
        }
    }
}

